"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_lambda_1 = require("monocdk/aws-lambda");
/**
 * Lambda functions are configured with a dead-letter configuration - (Control ID: 164.312(b))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_lambda_1.CfnFunction) {
        const deadLetterConfig = monocdk_1.Stack.of(node).resolve(node.deadLetterConfig);
        if (deadLetterConfig == undefined ||
            deadLetterConfig.targetArn == undefined) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGlwYWFTZWN1cml0eUxhbWJkYURscS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9ISVBBQS1TZWN1cml0eS9ydWxlcy9sYW1iZGEvaGlwYWFTZWN1cml0eUxhbWJkYURscS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7OztFQUdFOztBQUVGLHFDQUE2QztBQUM3QyxtREFBaUQ7QUFFakQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLHdCQUFXLEVBQUU7UUFDL0IsTUFBTSxnQkFBZ0IsR0FBRyxlQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztRQUN2RSxJQUNFLGdCQUFnQixJQUFJLFNBQVM7WUFDN0IsZ0JBQWdCLENBQUMsU0FBUyxJQUFJLFNBQVMsRUFDdkM7WUFDQSxPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFYRCw0QkFXQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuXG5pbXBvcnQgeyBDZm5SZXNvdXJjZSwgU3RhY2sgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IENmbkZ1bmN0aW9uIH0gZnJvbSAnbW9ub2Nkay9hd3MtbGFtYmRhJztcblxuLyoqXG4gKiBMYW1iZGEgZnVuY3Rpb25zIGFyZSBjb25maWd1cmVkIHdpdGggYSBkZWFkLWxldHRlciBjb25maWd1cmF0aW9uIC0gKENvbnRyb2wgSUQ6IDE2NC4zMTIoYikpXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuRnVuY3Rpb24pIHtcbiAgICBjb25zdCBkZWFkTGV0dGVyQ29uZmlnID0gU3RhY2sub2Yobm9kZSkucmVzb2x2ZShub2RlLmRlYWRMZXR0ZXJDb25maWcpO1xuICAgIGlmIChcbiAgICAgIGRlYWRMZXR0ZXJDb25maWcgPT0gdW5kZWZpbmVkIHx8XG4gICAgICBkZWFkTGV0dGVyQ29uZmlnLnRhcmdldEFybiA9PSB1bmRlZmluZWRcbiAgICApIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=