"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_cloudfront_1 = require("monocdk/aws-cloudfront");
const nag_pack_1 = require("../../../nag-pack");
/**
 * CloudFront distributions have access logging enabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_cloudfront_1.CfnDistribution) {
        const distributionConfig = monocdk_1.Stack.of(node).resolve(node.distributionConfig);
        if (distributionConfig.logging == undefined) {
            return false;
        }
    }
    else if (node instanceof aws_cloudfront_1.CfnStreamingDistribution) {
        const distributionConfig = monocdk_1.Stack.of(node).resolve(node.streamingDistributionConfig);
        if (distributionConfig.logging == undefined) {
            return false;
        }
        const logging = monocdk_1.Stack.of(node).resolve(distributionConfig.logging);
        const enabled = nag_pack_1.resolveIfPrimitive(node, logging.enabled);
        if (!enabled) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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