from os.path import abspath, dirname

from setuptools import setup

LONG_DESCRIPTION = open(dirname(abspath(__file__)) + "/README.md", "r").read()


setup(
    name="types-aioboto3-lite",
    version="9.6.0",
    packages=["aioboto3-stubs"],
    url="https://github.com/youtype/mypy_boto3_builder",
    license="MIT License",
    author="Vlad Emelianov",
    author_email="vlad.emelianov.nz@gmail.com",
    description="Type annotations for aioboto3 9.6.0 generated with mypy-boto3-builder 7.8.0",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "Environment :: Console",
        "License :: OSI Approved :: MIT License",
        "Natural Language :: English",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: Implementation :: CPython",
        "Typing :: Stubs Only",
    ],
    keywords="aioboto3 type-annotations aioboto3-stubs mypy typeshed autocomplete",
    long_description=LONG_DESCRIPTION,
    long_description_content_type="text/markdown",
    package_data={"aioboto3-stubs": ["py.typed", "*.pyi", "*/*.pyi"]},
    python_requires=">=3.6",
    project_urls={
        "Documentation": "https://youtype.github.io/types_aioboto3_docs/",
        "Source": "https://github.com/youtype/mypy_boto3_builder",
        "Tracker": "https://github.com/youtype/mypy_boto3_builder/issues",
    },
    install_requires=[
        "botocore-stubs",
        "types-s3transfer",
        "typing-extensions>=4.1.0",
    ],
    extras_require={
        "all": [
            "types-aiobotocore-accessanalyzer",
            "types-aiobotocore-account",
            "types-aiobotocore-acm",
            "types-aiobotocore-acm-pca",
            "types-aiobotocore-alexaforbusiness",
            "types-aiobotocore-amp",
            "types-aiobotocore-amplify",
            "types-aiobotocore-amplifybackend",
            "types-aiobotocore-amplifyuibuilder",
            "types-aiobotocore-apigateway",
            "types-aiobotocore-apigatewaymanagementapi",
            "types-aiobotocore-apigatewayv2",
            "types-aiobotocore-appconfig",
            "types-aiobotocore-appconfigdata",
            "types-aiobotocore-appflow",
            "types-aiobotocore-appintegrations",
            "types-aiobotocore-application-autoscaling",
            "types-aiobotocore-application-insights",
            "types-aiobotocore-applicationcostprofiler",
            "types-aiobotocore-appmesh",
            "types-aiobotocore-apprunner",
            "types-aiobotocore-appstream",
            "types-aiobotocore-appsync",
            "types-aiobotocore-athena",
            "types-aiobotocore-auditmanager",
            "types-aiobotocore-autoscaling",
            "types-aiobotocore-autoscaling-plans",
            "types-aiobotocore-backup",
            "types-aiobotocore-backup-gateway",
            "types-aiobotocore-batch",
            "types-aiobotocore-billingconductor",
            "types-aiobotocore-braket",
            "types-aiobotocore-budgets",
            "types-aiobotocore-ce",
            "types-aiobotocore-chime",
            "types-aiobotocore-chime-sdk-identity",
            "types-aiobotocore-chime-sdk-media-pipelines",
            "types-aiobotocore-chime-sdk-meetings",
            "types-aiobotocore-chime-sdk-messaging",
            "types-aiobotocore-cloud9",
            "types-aiobotocore-cloudcontrol",
            "types-aiobotocore-clouddirectory",
            "types-aiobotocore-cloudformation",
            "types-aiobotocore-cloudfront",
            "types-aiobotocore-cloudhsm",
            "types-aiobotocore-cloudhsmv2",
            "types-aiobotocore-cloudsearch",
            "types-aiobotocore-cloudsearchdomain",
            "types-aiobotocore-cloudtrail",
            "types-aiobotocore-cloudwatch",
            "types-aiobotocore-codeartifact",
            "types-aiobotocore-codebuild",
            "types-aiobotocore-codecommit",
            "types-aiobotocore-codedeploy",
            "types-aiobotocore-codeguru-reviewer",
            "types-aiobotocore-codeguruprofiler",
            "types-aiobotocore-codepipeline",
            "types-aiobotocore-codestar",
            "types-aiobotocore-codestar-connections",
            "types-aiobotocore-codestar-notifications",
            "types-aiobotocore-cognito-identity",
            "types-aiobotocore-cognito-idp",
            "types-aiobotocore-cognito-sync",
            "types-aiobotocore-comprehend",
            "types-aiobotocore-comprehendmedical",
            "types-aiobotocore-compute-optimizer",
            "types-aiobotocore-config",
            "types-aiobotocore-connect",
            "types-aiobotocore-connect-contact-lens",
            "types-aiobotocore-connectcampaigns",
            "types-aiobotocore-connectparticipant",
            "types-aiobotocore-cur",
            "types-aiobotocore-customer-profiles",
            "types-aiobotocore-databrew",
            "types-aiobotocore-dataexchange",
            "types-aiobotocore-datapipeline",
            "types-aiobotocore-datasync",
            "types-aiobotocore-dax",
            "types-aiobotocore-detective",
            "types-aiobotocore-devicefarm",
            "types-aiobotocore-devops-guru",
            "types-aiobotocore-directconnect",
            "types-aiobotocore-discovery",
            "types-aiobotocore-dlm",
            "types-aiobotocore-dms",
            "types-aiobotocore-docdb",
            "types-aiobotocore-drs",
            "types-aiobotocore-ds",
            "types-aiobotocore-dynamodb",
            "types-aiobotocore-dynamodbstreams",
            "types-aiobotocore-ebs",
            "types-aiobotocore-ec2",
            "types-aiobotocore-ec2-instance-connect",
            "types-aiobotocore-ecr",
            "types-aiobotocore-ecr-public",
            "types-aiobotocore-ecs",
            "types-aiobotocore-efs",
            "types-aiobotocore-eks",
            "types-aiobotocore-elastic-inference",
            "types-aiobotocore-elasticache",
            "types-aiobotocore-elasticbeanstalk",
            "types-aiobotocore-elastictranscoder",
            "types-aiobotocore-elb",
            "types-aiobotocore-elbv2",
            "types-aiobotocore-emr",
            "types-aiobotocore-emr-containers",
            "types-aiobotocore-emr-serverless",
            "types-aiobotocore-es",
            "types-aiobotocore-events",
            "types-aiobotocore-evidently",
            "types-aiobotocore-finspace",
            "types-aiobotocore-finspace-data",
            "types-aiobotocore-firehose",
            "types-aiobotocore-fis",
            "types-aiobotocore-fms",
            "types-aiobotocore-forecast",
            "types-aiobotocore-forecastquery",
            "types-aiobotocore-frauddetector",
            "types-aiobotocore-fsx",
            "types-aiobotocore-gamelift",
            "types-aiobotocore-gamesparks",
            "types-aiobotocore-glacier",
            "types-aiobotocore-globalaccelerator",
            "types-aiobotocore-glue",
            "types-aiobotocore-grafana",
            "types-aiobotocore-greengrass",
            "types-aiobotocore-greengrassv2",
            "types-aiobotocore-groundstation",
            "types-aiobotocore-guardduty",
            "types-aiobotocore-health",
            "types-aiobotocore-healthlake",
            "types-aiobotocore-honeycode",
            "types-aiobotocore-iam",
            "types-aiobotocore-identitystore",
            "types-aiobotocore-imagebuilder",
            "types-aiobotocore-importexport",
            "types-aiobotocore-inspector",
            "types-aiobotocore-inspector2",
            "types-aiobotocore-iot",
            "types-aiobotocore-iot-data",
            "types-aiobotocore-iot-jobs-data",
            "types-aiobotocore-iot1click-devices",
            "types-aiobotocore-iot1click-projects",
            "types-aiobotocore-iotanalytics",
            "types-aiobotocore-iotdeviceadvisor",
            "types-aiobotocore-iotevents",
            "types-aiobotocore-iotevents-data",
            "types-aiobotocore-iotfleethub",
            "types-aiobotocore-iotsecuretunneling",
            "types-aiobotocore-iotsitewise",
            "types-aiobotocore-iotthingsgraph",
            "types-aiobotocore-iottwinmaker",
            "types-aiobotocore-iotwireless",
            "types-aiobotocore-ivs",
            "types-aiobotocore-ivschat",
            "types-aiobotocore-kafka",
            "types-aiobotocore-kafkaconnect",
            "types-aiobotocore-kendra",
            "types-aiobotocore-keyspaces",
            "types-aiobotocore-kinesis",
            "types-aiobotocore-kinesis-video-archived-media",
            "types-aiobotocore-kinesis-video-media",
            "types-aiobotocore-kinesis-video-signaling",
            "types-aiobotocore-kinesisanalytics",
            "types-aiobotocore-kinesisanalyticsv2",
            "types-aiobotocore-kinesisvideo",
            "types-aiobotocore-kms",
            "types-aiobotocore-lakeformation",
            "types-aiobotocore-lambda",
            "types-aiobotocore-lex-models",
            "types-aiobotocore-lex-runtime",
            "types-aiobotocore-lexv2-models",
            "types-aiobotocore-lexv2-runtime",
            "types-aiobotocore-license-manager",
            "types-aiobotocore-lightsail",
            "types-aiobotocore-location",
            "types-aiobotocore-logs",
            "types-aiobotocore-lookoutequipment",
            "types-aiobotocore-lookoutmetrics",
            "types-aiobotocore-lookoutvision",
            "types-aiobotocore-m2",
            "types-aiobotocore-machinelearning",
            "types-aiobotocore-macie",
            "types-aiobotocore-macie2",
            "types-aiobotocore-managedblockchain",
            "types-aiobotocore-marketplace-catalog",
            "types-aiobotocore-marketplace-entitlement",
            "types-aiobotocore-marketplacecommerceanalytics",
            "types-aiobotocore-mediaconnect",
            "types-aiobotocore-mediaconvert",
            "types-aiobotocore-medialive",
            "types-aiobotocore-mediapackage",
            "types-aiobotocore-mediapackage-vod",
            "types-aiobotocore-mediastore",
            "types-aiobotocore-mediastore-data",
            "types-aiobotocore-mediatailor",
            "types-aiobotocore-memorydb",
            "types-aiobotocore-meteringmarketplace",
            "types-aiobotocore-mgh",
            "types-aiobotocore-mgn",
            "types-aiobotocore-migration-hub-refactor-spaces",
            "types-aiobotocore-migrationhub-config",
            "types-aiobotocore-migrationhubstrategy",
            "types-aiobotocore-mobile",
            "types-aiobotocore-mq",
            "types-aiobotocore-mturk",
            "types-aiobotocore-mwaa",
            "types-aiobotocore-neptune",
            "types-aiobotocore-network-firewall",
            "types-aiobotocore-networkmanager",
            "types-aiobotocore-nimble",
            "types-aiobotocore-opensearch",
            "types-aiobotocore-opsworks",
            "types-aiobotocore-opsworkscm",
            "types-aiobotocore-organizations",
            "types-aiobotocore-outposts",
            "types-aiobotocore-panorama",
            "types-aiobotocore-personalize",
            "types-aiobotocore-personalize-events",
            "types-aiobotocore-personalize-runtime",
            "types-aiobotocore-pi",
            "types-aiobotocore-pinpoint",
            "types-aiobotocore-pinpoint-email",
            "types-aiobotocore-pinpoint-sms-voice",
            "types-aiobotocore-pinpoint-sms-voice-v2",
            "types-aiobotocore-polly",
            "types-aiobotocore-pricing",
            "types-aiobotocore-proton",
            "types-aiobotocore-qldb",
            "types-aiobotocore-qldb-session",
            "types-aiobotocore-quicksight",
            "types-aiobotocore-ram",
            "types-aiobotocore-rbin",
            "types-aiobotocore-rds",
            "types-aiobotocore-rds-data",
            "types-aiobotocore-redshift",
            "types-aiobotocore-redshift-data",
            "types-aiobotocore-redshift-serverless",
            "types-aiobotocore-rekognition",
            "types-aiobotocore-resiliencehub",
            "types-aiobotocore-resource-groups",
            "types-aiobotocore-resourcegroupstaggingapi",
            "types-aiobotocore-robomaker",
            "types-aiobotocore-rolesanywhere",
            "types-aiobotocore-route53",
            "types-aiobotocore-route53-recovery-cluster",
            "types-aiobotocore-route53-recovery-control-config",
            "types-aiobotocore-route53-recovery-readiness",
            "types-aiobotocore-route53domains",
            "types-aiobotocore-route53resolver",
            "types-aiobotocore-rum",
            "types-aiobotocore-s3",
            "types-aiobotocore-s3control",
            "types-aiobotocore-s3outposts",
            "types-aiobotocore-sagemaker",
            "types-aiobotocore-sagemaker-a2i-runtime",
            "types-aiobotocore-sagemaker-edge",
            "types-aiobotocore-sagemaker-featurestore-runtime",
            "types-aiobotocore-sagemaker-runtime",
            "types-aiobotocore-savingsplans",
            "types-aiobotocore-schemas",
            "types-aiobotocore-sdb",
            "types-aiobotocore-secretsmanager",
            "types-aiobotocore-securityhub",
            "types-aiobotocore-serverlessrepo",
            "types-aiobotocore-service-quotas",
            "types-aiobotocore-servicecatalog",
            "types-aiobotocore-servicecatalog-appregistry",
            "types-aiobotocore-servicediscovery",
            "types-aiobotocore-ses",
            "types-aiobotocore-sesv2",
            "types-aiobotocore-shield",
            "types-aiobotocore-signer",
            "types-aiobotocore-sms",
            "types-aiobotocore-sms-voice",
            "types-aiobotocore-snow-device-management",
            "types-aiobotocore-snowball",
            "types-aiobotocore-sns",
            "types-aiobotocore-sqs",
            "types-aiobotocore-ssm",
            "types-aiobotocore-ssm-contacts",
            "types-aiobotocore-ssm-incidents",
            "types-aiobotocore-sso",
            "types-aiobotocore-sso-admin",
            "types-aiobotocore-sso-oidc",
            "types-aiobotocore-stepfunctions",
            "types-aiobotocore-storagegateway",
            "types-aiobotocore-sts",
            "types-aiobotocore-support",
            "types-aiobotocore-swf",
            "types-aiobotocore-synthetics",
            "types-aiobotocore-textract",
            "types-aiobotocore-timestream-query",
            "types-aiobotocore-timestream-write",
            "types-aiobotocore-transcribe",
            "types-aiobotocore-transfer",
            "types-aiobotocore-translate",
            "types-aiobotocore-voice-id",
            "types-aiobotocore-waf",
            "types-aiobotocore-waf-regional",
            "types-aiobotocore-wafv2",
            "types-aiobotocore-wellarchitected",
            "types-aiobotocore-wisdom",
            "types-aiobotocore-workdocs",
            "types-aiobotocore-worklink",
            "types-aiobotocore-workmail",
            "types-aiobotocore-workmailmessageflow",
            "types-aiobotocore-workspaces",
            "types-aiobotocore-workspaces-web",
            "types-aiobotocore-xray",
        ],
        "essential": [
            "types-aiobotocore-cloudformation",
            "types-aiobotocore-dynamodb",
            "types-aiobotocore-ec2",
            "types-aiobotocore-lambda",
            "types-aiobotocore-rds",
            "types-aiobotocore-s3",
            "types-aiobotocore-sqs",
        ],
        "accessanalyzer": ["types-aiobotocore-accessanalyzer"],
        "account": ["types-aiobotocore-account"],
        "acm": ["types-aiobotocore-acm"],
        "acm-pca": ["types-aiobotocore-acm-pca"],
        "alexaforbusiness": ["types-aiobotocore-alexaforbusiness"],
        "amp": ["types-aiobotocore-amp"],
        "amplify": ["types-aiobotocore-amplify"],
        "amplifybackend": ["types-aiobotocore-amplifybackend"],
        "amplifyuibuilder": ["types-aiobotocore-amplifyuibuilder"],
        "apigateway": ["types-aiobotocore-apigateway"],
        "apigatewaymanagementapi": ["types-aiobotocore-apigatewaymanagementapi"],
        "apigatewayv2": ["types-aiobotocore-apigatewayv2"],
        "appconfig": ["types-aiobotocore-appconfig"],
        "appconfigdata": ["types-aiobotocore-appconfigdata"],
        "appflow": ["types-aiobotocore-appflow"],
        "appintegrations": ["types-aiobotocore-appintegrations"],
        "application-autoscaling": ["types-aiobotocore-application-autoscaling"],
        "application-insights": ["types-aiobotocore-application-insights"],
        "applicationcostprofiler": ["types-aiobotocore-applicationcostprofiler"],
        "appmesh": ["types-aiobotocore-appmesh"],
        "apprunner": ["types-aiobotocore-apprunner"],
        "appstream": ["types-aiobotocore-appstream"],
        "appsync": ["types-aiobotocore-appsync"],
        "athena": ["types-aiobotocore-athena"],
        "auditmanager": ["types-aiobotocore-auditmanager"],
        "autoscaling": ["types-aiobotocore-autoscaling"],
        "autoscaling-plans": ["types-aiobotocore-autoscaling-plans"],
        "backup": ["types-aiobotocore-backup"],
        "backup-gateway": ["types-aiobotocore-backup-gateway"],
        "batch": ["types-aiobotocore-batch"],
        "billingconductor": ["types-aiobotocore-billingconductor"],
        "braket": ["types-aiobotocore-braket"],
        "budgets": ["types-aiobotocore-budgets"],
        "ce": ["types-aiobotocore-ce"],
        "chime": ["types-aiobotocore-chime"],
        "chime-sdk-identity": ["types-aiobotocore-chime-sdk-identity"],
        "chime-sdk-media-pipelines": ["types-aiobotocore-chime-sdk-media-pipelines"],
        "chime-sdk-meetings": ["types-aiobotocore-chime-sdk-meetings"],
        "chime-sdk-messaging": ["types-aiobotocore-chime-sdk-messaging"],
        "cloud9": ["types-aiobotocore-cloud9"],
        "cloudcontrol": ["types-aiobotocore-cloudcontrol"],
        "clouddirectory": ["types-aiobotocore-clouddirectory"],
        "cloudformation": ["types-aiobotocore-cloudformation"],
        "cloudfront": ["types-aiobotocore-cloudfront"],
        "cloudhsm": ["types-aiobotocore-cloudhsm"],
        "cloudhsmv2": ["types-aiobotocore-cloudhsmv2"],
        "cloudsearch": ["types-aiobotocore-cloudsearch"],
        "cloudsearchdomain": ["types-aiobotocore-cloudsearchdomain"],
        "cloudtrail": ["types-aiobotocore-cloudtrail"],
        "cloudwatch": ["types-aiobotocore-cloudwatch"],
        "codeartifact": ["types-aiobotocore-codeartifact"],
        "codebuild": ["types-aiobotocore-codebuild"],
        "codecommit": ["types-aiobotocore-codecommit"],
        "codedeploy": ["types-aiobotocore-codedeploy"],
        "codeguru-reviewer": ["types-aiobotocore-codeguru-reviewer"],
        "codeguruprofiler": ["types-aiobotocore-codeguruprofiler"],
        "codepipeline": ["types-aiobotocore-codepipeline"],
        "codestar": ["types-aiobotocore-codestar"],
        "codestar-connections": ["types-aiobotocore-codestar-connections"],
        "codestar-notifications": ["types-aiobotocore-codestar-notifications"],
        "cognito-identity": ["types-aiobotocore-cognito-identity"],
        "cognito-idp": ["types-aiobotocore-cognito-idp"],
        "cognito-sync": ["types-aiobotocore-cognito-sync"],
        "comprehend": ["types-aiobotocore-comprehend"],
        "comprehendmedical": ["types-aiobotocore-comprehendmedical"],
        "compute-optimizer": ["types-aiobotocore-compute-optimizer"],
        "config": ["types-aiobotocore-config"],
        "connect": ["types-aiobotocore-connect"],
        "connect-contact-lens": ["types-aiobotocore-connect-contact-lens"],
        "connectcampaigns": ["types-aiobotocore-connectcampaigns"],
        "connectparticipant": ["types-aiobotocore-connectparticipant"],
        "cur": ["types-aiobotocore-cur"],
        "customer-profiles": ["types-aiobotocore-customer-profiles"],
        "databrew": ["types-aiobotocore-databrew"],
        "dataexchange": ["types-aiobotocore-dataexchange"],
        "datapipeline": ["types-aiobotocore-datapipeline"],
        "datasync": ["types-aiobotocore-datasync"],
        "dax": ["types-aiobotocore-dax"],
        "detective": ["types-aiobotocore-detective"],
        "devicefarm": ["types-aiobotocore-devicefarm"],
        "devops-guru": ["types-aiobotocore-devops-guru"],
        "directconnect": ["types-aiobotocore-directconnect"],
        "discovery": ["types-aiobotocore-discovery"],
        "dlm": ["types-aiobotocore-dlm"],
        "dms": ["types-aiobotocore-dms"],
        "docdb": ["types-aiobotocore-docdb"],
        "drs": ["types-aiobotocore-drs"],
        "ds": ["types-aiobotocore-ds"],
        "dynamodb": ["types-aiobotocore-dynamodb"],
        "dynamodbstreams": ["types-aiobotocore-dynamodbstreams"],
        "ebs": ["types-aiobotocore-ebs"],
        "ec2": ["types-aiobotocore-ec2"],
        "ec2-instance-connect": ["types-aiobotocore-ec2-instance-connect"],
        "ecr": ["types-aiobotocore-ecr"],
        "ecr-public": ["types-aiobotocore-ecr-public"],
        "ecs": ["types-aiobotocore-ecs"],
        "efs": ["types-aiobotocore-efs"],
        "eks": ["types-aiobotocore-eks"],
        "elastic-inference": ["types-aiobotocore-elastic-inference"],
        "elasticache": ["types-aiobotocore-elasticache"],
        "elasticbeanstalk": ["types-aiobotocore-elasticbeanstalk"],
        "elastictranscoder": ["types-aiobotocore-elastictranscoder"],
        "elb": ["types-aiobotocore-elb"],
        "elbv2": ["types-aiobotocore-elbv2"],
        "emr": ["types-aiobotocore-emr"],
        "emr-containers": ["types-aiobotocore-emr-containers"],
        "emr-serverless": ["types-aiobotocore-emr-serverless"],
        "es": ["types-aiobotocore-es"],
        "events": ["types-aiobotocore-events"],
        "evidently": ["types-aiobotocore-evidently"],
        "finspace": ["types-aiobotocore-finspace"],
        "finspace-data": ["types-aiobotocore-finspace-data"],
        "firehose": ["types-aiobotocore-firehose"],
        "fis": ["types-aiobotocore-fis"],
        "fms": ["types-aiobotocore-fms"],
        "forecast": ["types-aiobotocore-forecast"],
        "forecastquery": ["types-aiobotocore-forecastquery"],
        "frauddetector": ["types-aiobotocore-frauddetector"],
        "fsx": ["types-aiobotocore-fsx"],
        "gamelift": ["types-aiobotocore-gamelift"],
        "gamesparks": ["types-aiobotocore-gamesparks"],
        "glacier": ["types-aiobotocore-glacier"],
        "globalaccelerator": ["types-aiobotocore-globalaccelerator"],
        "glue": ["types-aiobotocore-glue"],
        "grafana": ["types-aiobotocore-grafana"],
        "greengrass": ["types-aiobotocore-greengrass"],
        "greengrassv2": ["types-aiobotocore-greengrassv2"],
        "groundstation": ["types-aiobotocore-groundstation"],
        "guardduty": ["types-aiobotocore-guardduty"],
        "health": ["types-aiobotocore-health"],
        "healthlake": ["types-aiobotocore-healthlake"],
        "honeycode": ["types-aiobotocore-honeycode"],
        "iam": ["types-aiobotocore-iam"],
        "identitystore": ["types-aiobotocore-identitystore"],
        "imagebuilder": ["types-aiobotocore-imagebuilder"],
        "importexport": ["types-aiobotocore-importexport"],
        "inspector": ["types-aiobotocore-inspector"],
        "inspector2": ["types-aiobotocore-inspector2"],
        "iot": ["types-aiobotocore-iot"],
        "iot-data": ["types-aiobotocore-iot-data"],
        "iot-jobs-data": ["types-aiobotocore-iot-jobs-data"],
        "iot1click-devices": ["types-aiobotocore-iot1click-devices"],
        "iot1click-projects": ["types-aiobotocore-iot1click-projects"],
        "iotanalytics": ["types-aiobotocore-iotanalytics"],
        "iotdeviceadvisor": ["types-aiobotocore-iotdeviceadvisor"],
        "iotevents": ["types-aiobotocore-iotevents"],
        "iotevents-data": ["types-aiobotocore-iotevents-data"],
        "iotfleethub": ["types-aiobotocore-iotfleethub"],
        "iotsecuretunneling": ["types-aiobotocore-iotsecuretunneling"],
        "iotsitewise": ["types-aiobotocore-iotsitewise"],
        "iotthingsgraph": ["types-aiobotocore-iotthingsgraph"],
        "iottwinmaker": ["types-aiobotocore-iottwinmaker"],
        "iotwireless": ["types-aiobotocore-iotwireless"],
        "ivs": ["types-aiobotocore-ivs"],
        "ivschat": ["types-aiobotocore-ivschat"],
        "kafka": ["types-aiobotocore-kafka"],
        "kafkaconnect": ["types-aiobotocore-kafkaconnect"],
        "kendra": ["types-aiobotocore-kendra"],
        "keyspaces": ["types-aiobotocore-keyspaces"],
        "kinesis": ["types-aiobotocore-kinesis"],
        "kinesis-video-archived-media": ["types-aiobotocore-kinesis-video-archived-media"],
        "kinesis-video-media": ["types-aiobotocore-kinesis-video-media"],
        "kinesis-video-signaling": ["types-aiobotocore-kinesis-video-signaling"],
        "kinesisanalytics": ["types-aiobotocore-kinesisanalytics"],
        "kinesisanalyticsv2": ["types-aiobotocore-kinesisanalyticsv2"],
        "kinesisvideo": ["types-aiobotocore-kinesisvideo"],
        "kms": ["types-aiobotocore-kms"],
        "lakeformation": ["types-aiobotocore-lakeformation"],
        "lambda": ["types-aiobotocore-lambda"],
        "lex-models": ["types-aiobotocore-lex-models"],
        "lex-runtime": ["types-aiobotocore-lex-runtime"],
        "lexv2-models": ["types-aiobotocore-lexv2-models"],
        "lexv2-runtime": ["types-aiobotocore-lexv2-runtime"],
        "license-manager": ["types-aiobotocore-license-manager"],
        "lightsail": ["types-aiobotocore-lightsail"],
        "location": ["types-aiobotocore-location"],
        "logs": ["types-aiobotocore-logs"],
        "lookoutequipment": ["types-aiobotocore-lookoutequipment"],
        "lookoutmetrics": ["types-aiobotocore-lookoutmetrics"],
        "lookoutvision": ["types-aiobotocore-lookoutvision"],
        "m2": ["types-aiobotocore-m2"],
        "machinelearning": ["types-aiobotocore-machinelearning"],
        "macie": ["types-aiobotocore-macie"],
        "macie2": ["types-aiobotocore-macie2"],
        "managedblockchain": ["types-aiobotocore-managedblockchain"],
        "marketplace-catalog": ["types-aiobotocore-marketplace-catalog"],
        "marketplace-entitlement": ["types-aiobotocore-marketplace-entitlement"],
        "marketplacecommerceanalytics": ["types-aiobotocore-marketplacecommerceanalytics"],
        "mediaconnect": ["types-aiobotocore-mediaconnect"],
        "mediaconvert": ["types-aiobotocore-mediaconvert"],
        "medialive": ["types-aiobotocore-medialive"],
        "mediapackage": ["types-aiobotocore-mediapackage"],
        "mediapackage-vod": ["types-aiobotocore-mediapackage-vod"],
        "mediastore": ["types-aiobotocore-mediastore"],
        "mediastore-data": ["types-aiobotocore-mediastore-data"],
        "mediatailor": ["types-aiobotocore-mediatailor"],
        "memorydb": ["types-aiobotocore-memorydb"],
        "meteringmarketplace": ["types-aiobotocore-meteringmarketplace"],
        "mgh": ["types-aiobotocore-mgh"],
        "mgn": ["types-aiobotocore-mgn"],
        "migration-hub-refactor-spaces": ["types-aiobotocore-migration-hub-refactor-spaces"],
        "migrationhub-config": ["types-aiobotocore-migrationhub-config"],
        "migrationhubstrategy": ["types-aiobotocore-migrationhubstrategy"],
        "mobile": ["types-aiobotocore-mobile"],
        "mq": ["types-aiobotocore-mq"],
        "mturk": ["types-aiobotocore-mturk"],
        "mwaa": ["types-aiobotocore-mwaa"],
        "neptune": ["types-aiobotocore-neptune"],
        "network-firewall": ["types-aiobotocore-network-firewall"],
        "networkmanager": ["types-aiobotocore-networkmanager"],
        "nimble": ["types-aiobotocore-nimble"],
        "opensearch": ["types-aiobotocore-opensearch"],
        "opsworks": ["types-aiobotocore-opsworks"],
        "opsworkscm": ["types-aiobotocore-opsworkscm"],
        "organizations": ["types-aiobotocore-organizations"],
        "outposts": ["types-aiobotocore-outposts"],
        "panorama": ["types-aiobotocore-panorama"],
        "personalize": ["types-aiobotocore-personalize"],
        "personalize-events": ["types-aiobotocore-personalize-events"],
        "personalize-runtime": ["types-aiobotocore-personalize-runtime"],
        "pi": ["types-aiobotocore-pi"],
        "pinpoint": ["types-aiobotocore-pinpoint"],
        "pinpoint-email": ["types-aiobotocore-pinpoint-email"],
        "pinpoint-sms-voice": ["types-aiobotocore-pinpoint-sms-voice"],
        "pinpoint-sms-voice-v2": ["types-aiobotocore-pinpoint-sms-voice-v2"],
        "polly": ["types-aiobotocore-polly"],
        "pricing": ["types-aiobotocore-pricing"],
        "proton": ["types-aiobotocore-proton"],
        "qldb": ["types-aiobotocore-qldb"],
        "qldb-session": ["types-aiobotocore-qldb-session"],
        "quicksight": ["types-aiobotocore-quicksight"],
        "ram": ["types-aiobotocore-ram"],
        "rbin": ["types-aiobotocore-rbin"],
        "rds": ["types-aiobotocore-rds"],
        "rds-data": ["types-aiobotocore-rds-data"],
        "redshift": ["types-aiobotocore-redshift"],
        "redshift-data": ["types-aiobotocore-redshift-data"],
        "redshift-serverless": ["types-aiobotocore-redshift-serverless"],
        "rekognition": ["types-aiobotocore-rekognition"],
        "resiliencehub": ["types-aiobotocore-resiliencehub"],
        "resource-groups": ["types-aiobotocore-resource-groups"],
        "resourcegroupstaggingapi": ["types-aiobotocore-resourcegroupstaggingapi"],
        "robomaker": ["types-aiobotocore-robomaker"],
        "rolesanywhere": ["types-aiobotocore-rolesanywhere"],
        "route53": ["types-aiobotocore-route53"],
        "route53-recovery-cluster": ["types-aiobotocore-route53-recovery-cluster"],
        "route53-recovery-control-config": ["types-aiobotocore-route53-recovery-control-config"],
        "route53-recovery-readiness": ["types-aiobotocore-route53-recovery-readiness"],
        "route53domains": ["types-aiobotocore-route53domains"],
        "route53resolver": ["types-aiobotocore-route53resolver"],
        "rum": ["types-aiobotocore-rum"],
        "s3": ["types-aiobotocore-s3"],
        "s3control": ["types-aiobotocore-s3control"],
        "s3outposts": ["types-aiobotocore-s3outposts"],
        "sagemaker": ["types-aiobotocore-sagemaker"],
        "sagemaker-a2i-runtime": ["types-aiobotocore-sagemaker-a2i-runtime"],
        "sagemaker-edge": ["types-aiobotocore-sagemaker-edge"],
        "sagemaker-featurestore-runtime": ["types-aiobotocore-sagemaker-featurestore-runtime"],
        "sagemaker-runtime": ["types-aiobotocore-sagemaker-runtime"],
        "savingsplans": ["types-aiobotocore-savingsplans"],
        "schemas": ["types-aiobotocore-schemas"],
        "sdb": ["types-aiobotocore-sdb"],
        "secretsmanager": ["types-aiobotocore-secretsmanager"],
        "securityhub": ["types-aiobotocore-securityhub"],
        "serverlessrepo": ["types-aiobotocore-serverlessrepo"],
        "service-quotas": ["types-aiobotocore-service-quotas"],
        "servicecatalog": ["types-aiobotocore-servicecatalog"],
        "servicecatalog-appregistry": ["types-aiobotocore-servicecatalog-appregistry"],
        "servicediscovery": ["types-aiobotocore-servicediscovery"],
        "ses": ["types-aiobotocore-ses"],
        "sesv2": ["types-aiobotocore-sesv2"],
        "shield": ["types-aiobotocore-shield"],
        "signer": ["types-aiobotocore-signer"],
        "sms": ["types-aiobotocore-sms"],
        "sms-voice": ["types-aiobotocore-sms-voice"],
        "snow-device-management": ["types-aiobotocore-snow-device-management"],
        "snowball": ["types-aiobotocore-snowball"],
        "sns": ["types-aiobotocore-sns"],
        "sqs": ["types-aiobotocore-sqs"],
        "ssm": ["types-aiobotocore-ssm"],
        "ssm-contacts": ["types-aiobotocore-ssm-contacts"],
        "ssm-incidents": ["types-aiobotocore-ssm-incidents"],
        "sso": ["types-aiobotocore-sso"],
        "sso-admin": ["types-aiobotocore-sso-admin"],
        "sso-oidc": ["types-aiobotocore-sso-oidc"],
        "stepfunctions": ["types-aiobotocore-stepfunctions"],
        "storagegateway": ["types-aiobotocore-storagegateway"],
        "sts": ["types-aiobotocore-sts"],
        "support": ["types-aiobotocore-support"],
        "swf": ["types-aiobotocore-swf"],
        "synthetics": ["types-aiobotocore-synthetics"],
        "textract": ["types-aiobotocore-textract"],
        "timestream-query": ["types-aiobotocore-timestream-query"],
        "timestream-write": ["types-aiobotocore-timestream-write"],
        "transcribe": ["types-aiobotocore-transcribe"],
        "transfer": ["types-aiobotocore-transfer"],
        "translate": ["types-aiobotocore-translate"],
        "voice-id": ["types-aiobotocore-voice-id"],
        "waf": ["types-aiobotocore-waf"],
        "waf-regional": ["types-aiobotocore-waf-regional"],
        "wafv2": ["types-aiobotocore-wafv2"],
        "wellarchitected": ["types-aiobotocore-wellarchitected"],
        "wisdom": ["types-aiobotocore-wisdom"],
        "workdocs": ["types-aiobotocore-workdocs"],
        "worklink": ["types-aiobotocore-worklink"],
        "workmail": ["types-aiobotocore-workmail"],
        "workmailmessageflow": ["types-aiobotocore-workmailmessageflow"],
        "workspaces": ["types-aiobotocore-workspaces"],
        "workspaces-web": ["types-aiobotocore-workspaces-web"],
        "xray": ["types-aiobotocore-xray"],
    },
    zip_safe=False,
)
