from typing import Dict

from pydantic import BaseModel


class Vulnerability(BaseModel):

    validate_time: int
    invalidate_time: int = None
    last_check: int = None
    incidents: list = None
    id: int
    wid: str
    template: str
    status: str
    target: str
    type: str
    threat: int
    clientid: int
    testrun_id: int = None
    ticket_status: str = None
    ticket_history: list
    method: str
    domain: str
    path: str
    parameter: str
    title: str
    description: str
    additional: str
    exploit_example: str
    filter: list
    validated: bool
    hidden: bool
    detection_method: str
    vuln_recheck_type: str = None
    template_params: dict


class VulnTemplate(BaseModel):
    id: int
    name: str
    params: Dict
