# Pentest

To prove the security of the *WebScripts Server*, I ran *web scanners* and tools for *web pentest* and printed the results.

I launch WebScripts with this command to perform scans:

```bash
python3 -m WebScripts --accept-unauthenticated-user --accept-unknow-user --blacklist-time 0 --auth-failures-to-blacklist 99999
```

## SkipFish

```bash
skipfish -H Api-Key=AdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdminAdmin -o ~/Documents/skipfish http://127.0.0.1:8000/
```

Scanner version: 2.10b

### Warnings and informations

Internal warning:

 1. Node should be a directory, detection error? *(2)*
    - http://127.0.0.1:8000/error_pages/Report/new
    - http://127.0.0.1:8000/web

Information note:

 - Incorrect or missing MIME type (low risk) *(2)*
    - http://127.0.0.1:8000/web *(Memo: application/javascript)*
    - http://127.0.0.1:8000/web/auth *(Memo: application/javascript)*
 - Hidden files / directories *(1)*
    - http://127.0.0.1:8000/auth/
 - Server error triggered *(3)*
    - http://127.0.0.1:8000/auth/
    - http://127.0.0.1:8000/error_pages/Report/
    - http://127.0.0.1:8000/error_pages/Report/new
 - Resource not directly accessible *(2)*
    - http://127.0.0.1:8000/auth/
    - http://127.0.0.1:8000/error_pages/Report/
 - New 404 signature seen *(2)*
    - http://127.0.0.1:8000/sfi9876
    - http://127.0.0.1:8000/sfi9876/
 - New 'X-\*' header value seen *(4)*
    - http://127.0.0.1:8000/ *(Memo: X-Frame-Options)*
    - http://127.0.0.1:8000/ *(Memo: X-XSS-Protection)*
    - http://127.0.0.1:8000/ *(Memo: X-Content-Type-Options)*
    - http://127.0.0.1:8000/ *(Memo: X-Server)*
 - New 'Server' header value seen *(1)*
    - http://127.0.0.1:8000/ *(Memo: WebScripts 0.0.7)*

### Pages and ressources
application/javascript (5)

 - http://127.0.0.1:8000/js/webscripts_index_js_scripts.js (2263 bytes)
 - http://127.0.0.1:8000/js/webscripts_js_scripts.js (4326 bytes)
 - http://127.0.0.1:8000/js/webscripts_script_js_scripts.js (20726 bytes)
 - http://127.0.0.1:8000/web (5399 bytes)
 - http://127.0.0.1:8000/web/auth (6591 bytes)

application/xhtml+xml (8)

 - http://127.0.0.1:8000/static/commons.html (43982 bytes)
 - http://127.0.0.1:8000/static/error_pages.html (8663 bytes)
 - http://127.0.0.1:8000/static/Errors.html (32865 bytes)
 - http://127.0.0.1:8000/static/manage_defaults_databases.html (27746 bytes)
 - http://127.0.0.1:8000/static/Pages.html (7678 bytes)
 - http://127.0.0.1:8000/static/uploads_management.html (13834 bytes)
 - http://127.0.0.1:8000/static/utils.html (17131 bytes)
 - http://127.0.0.1:8000/static/WebScripts.html (19858 bytes)

image/jpeg (1)

 - http://127.0.0.1:8000/static/webscripts_header.jpg (44039 bytes)

image/png (1)

 - http://127.0.0.1:8000/static/webscripts_icon.png (1741 bytes)

text/css (3)

 - http://127.0.0.1:8000/static/webscripts_script_style.css (2039 bytes)
 - http://127.0.0.1:8000/static/webscripts_style.css (5195 bytes)
 - http://127.0.0.1:8000/static/webscripts_index_style.css (874 bytes)

text/html (4)

 - http://127.0.0.1:8000/ (165 bytes)
 - http://127.0.0.1:8000/auth/ [Not linked (brute-forced)] \(8232 bytes)
 - http://127.0.0.1:8000/error_pages/Report/new (8199 bytes)
 - http://127.0.0.1:8000/error_pages/Report/new// (8227 bytes)

## WhatWeb

```bash
whatweb -u Admin:Admin -v -a 4 http://127.0.0.1:8000/
```

```text
WhatWeb report for http://127.0.0.1:8000/
Status    : 301 Moved Permanently
Title     : <None>
IP        : 127.0.0.1
Country   : RESERVED, ZZ

Summary   : Matomo, Strict-Transport-Security[max-age=63072000; includeSubDomains; preload], RedirectLocation[/web/], X-Frame-Options[deny], X-XSS-Protection[1; mode=block], UncommonHeaders[content-security-policy,x-content-type-options,referrer-policy,clear-site-data,feature-policy,cross-origin-embedder-policy,cross-origin-opener-policy,cross-origin-resource-policy,x-server], HTTPServer[WebScripts 0.0.7], Script

Detected Plugins:
[ HTTPServer ]
        HTTP server header string. This plugin also attempts to 
        identify the operating system from the server header. 

        String       : WebScripts 0.0.7 (from server string)

[ Matomo ]
        Matomo is the leading open alternative to Google Analytics 
        that gives you full control over your data. Matomo lets you 
        easily collect data from websites, apps & the IoT and 
        visualise this data and extract insights. Privacy is 
        built-in. Matomo was formerly known as Piwik, and is 
        developed in PHP. 

        Aggressive function available (check plugin file or details).
        Google Dorks: (1)
        Website     : https://matomo.org

[ RedirectLocation ]
        HTTP Server string location. used with http-status 301 and 
        302 

        String       : /web/ (from location)

[ Script ]
        This plugin detects instances of script HTML elements and 
        returns the script language/type. 


[ Strict-Transport-Security ]
        Strict-Transport-Security is an HTTP header that restricts 
        a web browser from accessing a website without the security 
        of the HTTPS protocol. 

        String       : max-age=63072000; includeSubDomains; preload

[ UncommonHeaders ]
        Uncommon HTTP server headers. The blacklist includes all 
        the standard headers and many non standard but common ones. 
        Interesting but fairly common headers should have their own 
        plugins, eg. x-powered-by, server and x-aspnet-version. 
        Info about headers can be found at www.http-stats.com 

        String       : content-security-policy,x-content-type-options,referrer-policy,clear-site-data,feature-policy,cross-origin-embedder-policy,cross-origin-opener-policy,cross-origin-resource-policy,x-server (from headers)                                                                                         

[ X-Frame-Options ]
        This plugin retrieves the X-Frame-Options value from the 
        HTTP header. - More Info: 
        http://msdn.microsoft.com/en-us/library/cc288472%28VS.85%29.
        aspx

        String       : deny

[ X-XSS-Protection ]
        This plugin retrieves the X-XSS-Protection value from the 
        HTTP header. - More Info: 
        http://msdn.microsoft.com/en-us/library/cc288472%28VS.85%29.
        aspx

        String       : 1; mode=block

HTTP Headers:
        HTTP/1.0 301 Moved Permanently
        Date: Sat, 11 Sep 2021 09:47:05 GMT
        Server: WebScripts 0.0.7
        Content-Type: text/html; charset=utf-8
        Strict-Transport-Security: max-age=63072000; includeSubDomains; preload
        Content-Security-Policy: default-src 'self'; form-action 'none'; frame-ancestors 'none'
        X-Frame-Options: deny
        X-XSS-Protection: 1; mode=block
        X-Content-Type-Options: nosniff
        Referrer-Policy: origin-when-cross-origin
        Cache-Control: no-store
        Pragma: no-store
        Clear-Site-Data: *
        Feature-Policy: microphone 'none'; camera 'none'
        Cross-Origin-Embedder-Policy: require-corp
        Cross-Origin-Opener-Policy: same-origin
        Cross-Origin-Resource-Policy: same-origin
        X-Server: WebScripts
        Location: /web/
        Content-Length: 165

WhatWeb report for http://127.0.0.1:8000/web/
Status    : 200 OK
Title     : Index of WebScripts Server
IP        : 127.0.0.1
Country   : RESERVED, ZZ

Summary   : Matomo, Strict-Transport-Security[max-age=63072000; includeSubDomains; preload], X-Frame-Options[deny], HTML5, X-XSS-Protection[1; mode=block], UncommonHeaders[content-security-policy,x-content-type-options,referrer-policy,clear-site-data,feature-policy,cross-origin-embedder-policy,cross-origin-opener-policy,cross-origin-resource-policy,x-server], HTTPServer[WebScripts 0.0.7], Script[text/javascript]

Detected Plugins:
[ HTML5 ]
        HTML version 5, detected by the doctype declaration 


[ HTTPServer ]
        HTTP server header string. This plugin also attempts to 
        identify the operating system from the server header. 

        String       : WebScripts 0.0.7 (from server string)

[ Matomo ]
        Matomo is the leading open alternative to Google Analytics 
        that gives you full control over your data. Matomo lets you 
        easily collect data from websites, apps & the IoT and 
        visualise this data and extract insights. Privacy is 
        built-in. Matomo was formerly known as Piwik, and is 
        developed in PHP. 

        Aggressive function available (check plugin file or details).
        Google Dorks: (1)
        Website     : https://matomo.org

[ Script ]
        This plugin detects instances of script HTML elements and 
        returns the script language/type. 

        String       : text/javascript

[ Strict-Transport-Security ]
        Strict-Transport-Security is an HTTP header that restricts 
        a web browser from accessing a website without the security 
        of the HTTPS protocol. 

        String       : max-age=63072000; includeSubDomains; preload

[ UncommonHeaders ]
        Uncommon HTTP server headers. The blacklist includes all 
        the standard headers and many non standard but common ones. 
        Interesting but fairly common headers should have their own 
        plugins, eg. x-powered-by, server and x-aspnet-version. 
        Info about headers can be found at www.http-stats.com 

        String       : content-security-policy,x-content-type-options,referrer-policy,clear-site-data,feature-policy,cross-origin-embedder-policy,cross-origin-opener-policy,cross-origin-resource-policy,x-server (from headers)                                                                                         

[ X-Frame-Options ]
        This plugin retrieves the X-Frame-Options value from the 
        HTTP header. - More Info: 
        http://msdn.microsoft.com/en-us/library/cc288472%28VS.85%29.
        aspx

        String       : deny

[ X-XSS-Protection ]
        This plugin retrieves the X-XSS-Protection value from the 
        HTTP header. - More Info: 
        http://msdn.microsoft.com/en-us/library/cc288472%28VS.85%29.
        aspx

        String       : 1; mode=block

HTTP Headers:
        HTTP/1.0 200 OK
        Date: Sat, 11 Sep 2021 09:52:46 GMT
        Server: WebScripts 0.0.7
        Content-Type: text/html; charset=utf-8
        Strict-Transport-Security: max-age=63072000; includeSubDomains; preload
        Content-Security-Policy: default-src 'self'; form-action 'none'; frame-ancestors 'none'; script-src 'self' 'sha512-PrdxK6oDVtJdo252hYBGESefJT/X4juRfz9nEf9gFJ4JkLYYIkFqdmTUJ3Dj1Bbqt0yp5cwmUHsMYpCdGdSryg=='
        X-Frame-Options: deny
        X-XSS-Protection: 1; mode=block
        X-Content-Type-Options: nosniff
        Referrer-Policy: origin-when-cross-origin
        Cache-Control: no-store
        Pragma: no-store
        Clear-Site-Data: *
        Feature-Policy: microphone 'none'; camera 'none'
        Cross-Origin-Embedder-Policy: require-corp
        Cross-Origin-Opener-Policy: same-origin
        Cross-Origin-Resource-Policy: same-origin
        X-Server: WebScripts
        Content-Length: 5399
```

## Test RCE (Remote Code Execution) on /API/

```text
[!] Start tests RCE (Remote Code Execution)...
[+] Injection: [';', 'cat', ' ', '/etc/passwd']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ;cat /etc/passwd
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['|', 'cat', ' ', '/etc/passwd']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: |cat /etc/passwd
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['&&', 'cat', ' ', '/etc/passwd']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: &&cat /etc/passwd
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['\n', 'cat', ' ', '/etc/passwd']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection:
cat /etc/passwd
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['&&', 'cat', ' ', '/etc/passwd', '&&']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: &&cat /etc/passwd&&
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: [';', 'cat', ' ', '/etc/passwd', ';']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ;cat /etc/passwd;
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['|', 'cat', ' ', '/etc/passwd', '|']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: |cat /etc/passwd|
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: [';', 'cat', ' ', '/etc/passwd', '|']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ;cat /etc/passwd|
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['\n', 'cat', ' ', '/etc/passwd', '\n']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection:
cat /etc/passwd

[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['\\etc\\passwd']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: \etc\passwd
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./etc/passwd']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: .|./.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./etc/passwd
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['../../../../../../../bin/cat', ' ', '/etc/passwd', '|']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ../../../../../../../bin/cat /etc/passwd|
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['"', ';', 'system(cat /etc/passwd);']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ";system(cat /etc/passwd);
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['`cat /etc/passwd`']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: `cat /etc/passwd`
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: [';', "system('cat /etc/passwd')"]
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ;system('cat /etc/passwd')
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['&&', "system('cat /etc/passwd')"]
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: &&system('cat /etc/passwd')
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['|', "system('cat /etc/passwd')"]
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: |system('cat /etc/passwd')
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['|', "system('cat /etc/passwd');"]
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: |system('cat /etc/passwd');
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['perl', ' ', '-e"system(\'cat /etc/passwd\');"', "\n'"]
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: perl -e"system('cat /etc/passwd');"
'
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['/bin/cat', '/etc/passwd', '|', "'\n'"]
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: /bin/cat/etc/passwd|'
'
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['/bin/cat', '/etc/passwd', "|'"]
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: /bin/cat/etc/passwd|'
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['system("cat /etc/passwd")', ';', 'die']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: system("cat /etc/passwd");die
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ['";cat /etc/passwd;echo "']
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[+] Injection: ";cat /etc/passwd;echo "
[*] Response: {'stdout': '<table>\r\n</table>\r\n', 'stderr': '', 'code': 0, 'Content-Type': 'text/html', 'error': 'No errors'}
[!] End.
```

*WebScripts logs* on the **RCE pentests**:
```txt
[2021-09-11 19:33:12] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:13] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', ';', 'cat', ' ', '/etc/passwd']
[2021-09-11 19:33:13] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:13] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:13] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:13] INFO(20)         Run authentication script.
[2021-09-11 19:33:14] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:14] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:14] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', ';', 'cat', ' ', '/etc/passwd']
[2021-09-11 19:33:14] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:14] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:14] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:14] INFO(20)         Run authentication script.
[2021-09-11 19:33:15] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:15] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:16] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '|', 'cat', ' ', '/etc/passwd']
[2021-09-11 19:33:16] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:16] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:16] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:16] INFO(20)         Run authentication script.
[2021-09-11 19:33:16] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:16] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:17] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '|', 'cat', ' ', '/etc/passwd']
[2021-09-11 19:33:17] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:17] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:17] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:17] INFO(20)         Run authentication script.
[2021-09-11 19:33:17] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:17] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:18] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '&&', 'cat', ' ', '/etc/passwd']
[2021-09-11 19:33:18] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:18] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:18] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:18] INFO(20)         Run authentication script.
[2021-09-11 19:33:19] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:19] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:19] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '&&', 'cat', ' ', '/etc/passwd']
[2021-09-11 19:33:19] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:19] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:19] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:19] INFO(20)         Run authentication script.
[2021-09-11 19:33:20] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:20] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:20] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '\n', 'cat', ' ', '/etc/passwd']
[2021-09-11 19:33:20] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:20] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:20] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:20] INFO(20)         Run authentication script.
[2021-09-11 19:33:21] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:21] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:22] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '\n', 'cat', ' ', '/etc/passwd']
[2021-09-11 19:33:22] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:22] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:22] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:22] INFO(20)         Run authentication script.
[2021-09-11 19:33:22] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:22] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:23] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '&&', 'cat', ' ', '/etc/passwd', '&&']
[2021-09-11 19:33:23] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:23] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:23] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:23] INFO(20)         Run authentication script.
[2021-09-11 19:33:23] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:23] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:24] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '&&', 'cat', ' ', '/etc/passwd', '&&']
[2021-09-11 19:33:24] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:24] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:24] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:24] INFO(20)         Run authentication script.
[2021-09-11 19:33:25] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:25] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:25] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', ';', 'cat', ' ', '/etc/passwd', ';']
[2021-09-11 19:33:25] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:25] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:25] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:25] INFO(20)         Run authentication script.
[2021-09-11 19:33:26] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:26] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:27] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', ';', 'cat', ' ', '/etc/passwd', ';']
[2021-09-11 19:33:27] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:27] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:27] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:27] INFO(20)         Run authentication script.
[2021-09-11 19:33:27] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:27] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:28] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '|', 'cat', ' ', '/etc/passwd', '|']
[2021-09-11 19:33:28] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:28] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:28] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:28] INFO(20)         Run authentication script.
[2021-09-11 19:33:28] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:28] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:29] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '|', 'cat', ' ', '/etc/passwd', '|']
[2021-09-11 19:33:29] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:29] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:29] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:29] INFO(20)         Run authentication script.
[2021-09-11 19:33:30] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:30] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:30] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', ';', 'cat', ' ', '/etc/passwd', '|']
[2021-09-11 19:33:30] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:30] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:30] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:30] INFO(20)         Run authentication script.
[2021-09-11 19:33:31] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:31] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:31] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', ';', 'cat', ' ', '/etc/passwd', '|']
[2021-09-11 19:33:31] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:31] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:31] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:31] INFO(20)         Run authentication script.
[2021-09-11 19:33:32] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:32] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:33] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '\n', 'cat', ' ', '/etc/passwd', '\n']
[2021-09-11 19:33:33] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:33] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:33] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:33] INFO(20)         Run authentication script.
[2021-09-11 19:33:33] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:33] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:34] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '\n', 'cat', ' ', '/etc/passwd', '\n']
[2021-09-11 19:33:34] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:34] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:34] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:34] INFO(20)         Run authentication script.
[2021-09-11 19:33:35] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:35] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:35] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '/etc/passwd']
[2021-09-11 19:33:35] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:35] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:35] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:35] INFO(20)         Run authentication script.
[2021-09-11 19:33:36] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:36] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:36] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '/etc/passwd']
[2021-09-11 19:33:36] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:36] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:36] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:36] INFO(20)         Run authentication script.
[2021-09-11 19:33:37] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:37] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:38] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./etc/passwd']
[2021-09-11 19:33:38] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:38] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:38] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:38] INFO(20)         Run authentication script.
[2021-09-11 19:33:38] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:38] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:39] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./.|./etc/passwd']
[2021-09-11 19:33:39] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:39] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:39] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:39] INFO(20)         Run authentication script.
[2021-09-11 19:33:40] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:40] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:40] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '../../../../../../../bin/cat', ' ', '/etc/passwd', '|']
[2021-09-11 19:33:40] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:40] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:40] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:40] INFO(20)         Run authentication script.
[2021-09-11 19:33:41] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:41] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:41] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '../../../../../../../bin/cat', ' ', '/etc/passwd', '|']
[2021-09-11 19:33:41] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:41] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:41] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:41] INFO(20)         Run authentication script.
[2021-09-11 19:33:42] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:42] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:43] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '"', ';', 'system(cat /etc/passwd);']
[2021-09-11 19:33:43] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:43] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:43] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:43] INFO(20)         Run authentication script.
[2021-09-11 19:33:43] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:43] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:44] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '"', ';', 'system(cat /etc/passwd);']
[2021-09-11 19:33:44] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:44] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:44] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:44] INFO(20)         Run authentication script.
[2021-09-11 19:33:45] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:45] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:45] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '`cat /etc/passwd`']
[2021-09-11 19:33:45] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:45] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:45] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:45] INFO(20)         Run authentication script.
[2021-09-11 19:33:46] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:46] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:46] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '`cat /etc/passwd`']
[2021-09-11 19:33:46] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:46] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:46] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:46] INFO(20)         Run authentication script.
[2021-09-11 19:33:47] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:47] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:48] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', ';', "system('cat /etc/passwd')"]
[2021-09-11 19:33:48] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:48] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:48] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:48] INFO(20)         Run authentication script.
[2021-09-11 19:33:48] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:48] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:49] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', ';', "system('cat /etc/passwd')"]
[2021-09-11 19:33:49] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:49] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:49] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:49] INFO(20)         Run authentication script.
[2021-09-11 19:33:50] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:50] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:50] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '&&', "system('cat /etc/passwd')"]
[2021-09-11 19:33:50] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:50] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:50] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:50] INFO(20)         Run authentication script.
[2021-09-11 19:33:51] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:51] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:51] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '&&', "system('cat /etc/passwd')"]
[2021-09-11 19:33:51] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:51] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:51] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:52] INFO(20)         Run authentication script.
[2021-09-11 19:33:52] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:52] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:53] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '|', "system('cat /etc/passwd')"]
[2021-09-11 19:33:53] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:53] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:53] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:53] INFO(20)         Run authentication script.
[2021-09-11 19:33:53] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:53] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:54] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '|', "system('cat /etc/passwd')"]
[2021-09-11 19:33:54] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:54] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:54] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:54] INFO(20)         Run authentication script.
[2021-09-11 19:33:55] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:55] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:55] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '|', "system('cat /etc/passwd');"]
[2021-09-11 19:33:55] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:55] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:55] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:55] INFO(20)         Run authentication script.
[2021-09-11 19:33:56] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:56] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:57] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '|', "system('cat /etc/passwd');"]
[2021-09-11 19:33:57] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:57] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:57] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:57] INFO(20)         Run authentication script.
[2021-09-11 19:33:57] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:57] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:58] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', 'perl', ' ', '-e"system(\'cat /etc/passwd\');"', "\n'"]
[2021-09-11 19:33:58] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:58] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:58] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:58] INFO(20)         Run authentication script.
[2021-09-11 19:33:58] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:33:58] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:33:59] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', 'perl', ' ', '-e"system(\'cat /etc/passwd\');"', "\n'"]
[2021-09-11 19:33:59] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:33:59] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:33:59] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:33:59] INFO(20)         Run authentication script.
[2021-09-11 19:34:00] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:34:00] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:34:00] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '/bin/cat', '/etc/passwd', '|', "'\n'"]
[2021-09-11 19:34:00] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:34:00] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:34:00] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:34:00] INFO(20)         Run authentication script.
[2021-09-11 19:34:01] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:34:01] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:34:02] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '/bin/cat', '/etc/passwd', '|', "'\n'"]
[2021-09-11 19:34:02] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:34:02] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:34:02] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:34:02] INFO(20)         Run authentication script.
[2021-09-11 19:34:02] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:34:02] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:34:03] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '/bin/cat', '/etc/passwd', "|'"]
[2021-09-11 19:34:03] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:34:03] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:34:03] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:34:03] INFO(20)         Run authentication script.
[2021-09-11 19:34:03] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:34:03] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:34:04] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '/bin/cat', '/etc/passwd', "|'"]
[2021-09-11 19:34:04] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:34:04] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:34:04] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:34:04] INFO(20)         Run authentication script.
[2021-09-11 19:34:05] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:34:05] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:34:05] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', 'system("cat /etc/passwd")', ';', 'die']
[2021-09-11 19:34:05] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:34:05] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:34:05] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:34:05] INFO(20)         Run authentication script.
[2021-09-11 19:34:06] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:34:06] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:34:07] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', 'system("cat /etc/passwd")', ';', 'die']
[2021-09-11 19:34:07] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:34:07] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:34:07] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:34:07] INFO(20)         Run authentication script.
[2021-09-11 19:34:07] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:34:07] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:34:08] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '";cat /etc/passwd;echo "']
[2021-09-11 19:34:08] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:34:08] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
[2021-09-11 19:34:08] DEBUG(10)        Request (POST) from 127.0.0.1 on /api/scripts/view_users.py.
[2021-09-11 19:34:08] INFO(20)         Run authentication script.
[2021-09-11 19:34:08] DEBUG(10)        SCRIPT "auth.py" executed without error for user named "Not Authenticated".
[2021-09-11 19:34:08] INFO(20)         Admin get access to category Administration (['*'])
[2021-09-11 19:34:09] INFO(20)         Command: ['python3', './scripts/account/view_users.py', '--names', '";cat /etc/passwd;echo "']
[2021-09-11 19:34:09] DEBUG(10)        SCRIPT "view_users.py" executed without error for user named "Admin".
127.0.0.1 - - [11/Sep/2021 19:34:09] "POST /api/scripts/view_users.py HTTP/1.1" 200 113
```

## Dirb

```bash
dirb http://127.0.0.1:8000/web/ -u Admin:Admin
```

```text
-----------------
DIRB v2.22    
By The Dark Raver
-----------------

START_TIME: Sat Sep 11 13:22:32 2021
URL_BASE: http://127.0.0.1:8000/web/
WORDLIST_FILES: /usr/share/dirb/wordlists/common.txt
AUTHORIZATION: Admin:Admin

-----------------

GENERATED WORDS: 4612                                                          

---- Scanning URL: http://127.0.0.1:8000/web/ ----
                                                                                                                                                            
-----------------
END_TIME: Sat Sep 11 13:28:03 2021
DOWNLOADED: 4612 - FOUND: 0
```

## Nikto

```bash
nikto -o nikto.json -Format json -Tuning x -evasion 12345678AB -id Admin:Admin -C all -h http://127.0.0.1:8000/web/auth/
```

```text
- Nikto v2.1.6
---------------------------------------------------------------------------
+ Target IP:          127.0.0.1
+ Target Hostname:    127.0.0.1
+ Target Port:        8000
+ Using Encoding:     Random URI encoding (non-UTF8)
+ Using Encoding:     Directory self-reference (/./)
+ Using Encoding:     Premature URL ending
+ Using Encoding:     Prepend long random string
+ Using Encoding:     Fake parameter
+ Using Encoding:     TAB as request spacer
+ Using Encoding:     Change the case of the URL
+ Using Encoding:     Use Windows directory separator (\)
+ Start Time:         2021-09-11 06:05:12 (GMT-4)
---------------------------------------------------------------------------
+ Server: WebScripts 0.0.7
+ Retrieved x-server header: WebScripts
+ Uncommon header 'cross-origin-opener-policy' found, with contents: same-origin
+ Uncommon header 'cross-origin-resource-policy' found, with contents: same-origin
+ Uncommon header 'cross-origin-embedder-policy' found, with contents: require-corp
+ Uncommon header 'feature-policy' found, with contents: microphone 'none'; camera 'none'
+ Uncommon header 'clear-site-data' found, with contents: *
+ Uncommon header 'x-server' found, with contents: WebScripts
+ Server banner has changed from 'WebScripts 0.0.7' to 'WSGIServer/0.2 CPython/3.9.6' which may suggest a WAF, load balancer or proxy is in place
+ ERROR: Error limit (20) reached for host, giving up. Last error: 
+ Scan terminated:  0 error(s) and 7 item(s) reported on remote host
+ End Time:           2021-09-11 06:06:29 (GMT-4) (77 seconds)
---------------------------------------------------------------------------
+ 1 host(s) tested
```

```json
{
    "host": "127.0.0.1",
    "ip": "127.0.0.1",
    "port": "8000",
    "banner": "WebScripts 0.0.7",
    "vulnerabilities": [
        {
            "id": "999986",
            "OSVDB": "0",
            "method": "GET",
            "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20xWDpvJSTFV/../../dQumZQAd1Z1jLBuoqe.html%3Fmft0bC82cl1WFAedA=/..//.%5c%4a%48%64%57Zv%45%65Pb%35%44%5arUTJH%44w%5a%76ee%70%625Dzr%75%74JhDW%7a%56%45%45%50%625Dz%72Utjh%64W%7a%56%45Epb%35%44Z%52UTj%68d%57%5a%56%65e%70%62%35%44%7a%52%55%54%4aH%44%77z%76EE%50B5%64zR%55%54j%68%64w%5aV%45%65%70B5DzRu%54jH%64w%7a%56E%45%70%62%35dZr%55TJHdwz%56e%65Pb5DZ%52%55%54%4a%48%44wz%56E%45%70%425%64zR%55tJ%48%44W%5aVEe%70B5%44zr%75%74%4ah%44W%7a%76eE%70%42%35%64zr%75%74J%68%44%77Zve%65Pb%35%64%7a%52%55%74%6ah%44%57%7avE%65%70%62%35%64%5a%72uT%6a%68DwZVe%65%70b5%64%7a%72%75%54%6a%48%64%57zVee%70%625%44z%72%55tjH%44W%7aV%45%45%50b%35dzrUtjH%64wZ%56EeP%42%35%64zr%75Tj%68%64%57%7a%56EePb%35D%7a%72u%54jHD%77%5aV%65ePB5dzrut%4ahDwZV%65%65%70%42%35%64%7aR%75T%4a%48%64W%7a%76%65ep%625d%5aRUTJH%44wz%56%65%45p%625dZrUT%6a%68D%77%7aVeE%70%425DzRU%74jh%44w%7avE%65%50%425%44zrUT%4a%68%44%57%7a%76eEP%62%35%64z%52%75%54jHDwZVE%45%50%42%35dzRU%74J%48%64%77%5a%56%45%45P%62%35D%5a%72%55tJh%64wZ%76%45E%50B%35%44zR%55%74%6ah%44W%5aveE%50%425d%7a%72ut%4a%68DWZVE%65%50B5DzR%55tJHDwzV%65%45%50%42%35%44zR%55t%5c.%5c%2e.%5c%2e\\W%65b\\.\\Au%74%48%5c./",
            "msg": "Retrieved x-server header: WebScripts"
        },
        {
            "id": "999100",
            "OSVDB": "0",
            "method": "GET",
            "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20xWDpvJSTFV/../../dQumZQAd1Z1jLBuoqe.html%3Fmft0bC82cl1WFAedA=/..//.%5c%4a%48%64%57Zv%45%65Pb%35%44%5arUTJH%44w%5a%76ee%70%625Dzr%75%74JhDW%7a%56%45%45%50%625Dz%72Utjh%64W%7a%56%45Epb%35%44Z%52UTj%68d%57%5a%56%65e%70%62%35%44%7a%52%55%54%4aH%44%77z%76EE%50B5%64zR%55%54j%68%64w%5aV%45%65%70B5DzRu%54jH%64w%7a%56E%45%70%62%35dZr%55TJHdwz%56e%65Pb5DZ%52%55%54%4a%48%44wz%56E%45%70%425%64zR%55tJ%48%44W%5aVEe%70B5%44zr%75%74%4ah%44W%7a%76eE%70%42%35%64zr%75%74J%68%44%77Zve%65Pb%35%64%7a%52%55%74%6ah%44%57%7avE%65%70%62%35%64%5a%72uT%6a%68DwZVe%65%70b5%64%7a%72%75%54%6a%48%64%57zVee%70%625%44z%72%55tjH%44W%7aV%45%45%50b%35dzrUtjH%64wZ%56EeP%42%35%64zr%75Tj%68%64%57%7a%56EePb%35D%7a%72u%54jHD%77%5aV%65ePB5dzrut%4ahDwZV%65%65%70%42%35%64%7aR%75T%4a%48%64W%7a%76%65ep%625d%5aRUTJH%44wz%56%65%45p%625dZrUT%6a%68D%77%7aVeE%70%425DzRU%74jh%44w%7avE%65%50%425%44zrUT%4a%68%44%57%7a%76eEP%62%35%64z%52%75%54jHDwZVE%45%50%42%35dzRU%74J%48%64%77%5a%56%45%45P%62%35D%5a%72%55tJh%64wZ%76%45E%50B%35%44zR%55%74%6ah%44W%5aveE%50%425d%7a%72ut%4a%68DWZVE%65%50B5DzR%55tJHDwzV%65%45%50%42%35%44zR%55t%5c.%5c%2e.%5c%2e\\W%65b\\.\\Au%74%48%5c./",
            "msg": "Uncommon header 'cross-origin-opener-policy' found, with contents: same-origin"
        },
        {
            "id": "999100",
            "OSVDB": "0",
            "method": "GET",
            "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20xWDpvJSTFV/../../dQumZQAd1Z1jLBuoqe.html%3Fmft0bC82cl1WFAedA=/..//.%5c%4a%48%64%57Zv%45%65Pb%35%44%5arUTJH%44w%5a%76ee%70%625Dzr%75%74JhDW%7a%56%45%45%50%625Dz%72Utjh%64W%7a%56%45Epb%35%44Z%52UTj%68d%57%5a%56%65e%70%62%35%44%7a%52%55%54%4aH%44%77z%76EE%50B5%64zR%55%54j%68%64w%5aV%45%65%70B5DzRu%54jH%64w%7a%56E%45%70%62%35dZr%55TJHdwz%56e%65Pb5DZ%52%55%54%4a%48%44wz%56E%45%70%425%64zR%55tJ%48%44W%5aVEe%70B5%44zr%75%74%4ah%44W%7a%76eE%70%42%35%64zr%75%74J%68%44%77Zve%65Pb%35%64%7a%52%55%74%6ah%44%57%7avE%65%70%62%35%64%5a%72uT%6a%68DwZVe%65%70b5%64%7a%72%75%54%6a%48%64%57zVee%70%625%44z%72%55tjH%44W%7aV%45%45%50b%35dzrUtjH%64wZ%56EeP%42%35%64zr%75Tj%68%64%57%7a%56EePb%35D%7a%72u%54jHD%77%5aV%65ePB5dzrut%4ahDwZV%65%65%70%42%35%64%7aR%75T%4a%48%64W%7a%76%65ep%625d%5aRUTJH%44wz%56%65%45p%625dZrUT%6a%68D%77%7aVeE%70%425DzRU%74jh%44w%7avE%65%50%425%44zrUT%4a%68%44%57%7a%76eEP%62%35%64z%52%75%54jHDwZVE%45%50%42%35dzRU%74J%48%64%77%5a%56%45%45P%62%35D%5a%72%55tJh%64wZ%76%45E%50B%35%44zR%55%74%6ah%44W%5aveE%50%425d%7a%72ut%4a%68DWZVE%65%50B5DzR%55tJHDwzV%65%45%50%42%35%44zR%55t%5c.%5c%2e.%5c%2e\\W%65b\\.\\Au%74%48%5c./",
            "msg": "Uncommon header 'cross-origin-resource-policy' found, with contents: same-origin"
        },
        {
            "id": "999100",
            "OSVDB": "0",
            "method": "GET",
            "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20xWDpvJSTFV/../../dQumZQAd1Z1jLBuoqe.html%3Fmft0bC82cl1WFAedA=/..//.%5c%4a%48%64%57Zv%45%65Pb%35%44%5arUTJH%44w%5a%76ee%70%625Dzr%75%74JhDW%7a%56%45%45%50%625Dz%72Utjh%64W%7a%56%45Epb%35%44Z%52UTj%68d%57%5a%56%65e%70%62%35%44%7a%52%55%54%4aH%44%77z%76EE%50B5%64zR%55%54j%68%64w%5aV%45%65%70B5DzRu%54jH%64w%7a%56E%45%70%62%35dZr%55TJHdwz%56e%65Pb5DZ%52%55%54%4a%48%44wz%56E%45%70%425%64zR%55tJ%48%44W%5aVEe%70B5%44zr%75%74%4ah%44W%7a%76eE%70%42%35%64zr%75%74J%68%44%77Zve%65Pb%35%64%7a%52%55%74%6ah%44%57%7avE%65%70%62%35%64%5a%72uT%6a%68DwZVe%65%70b5%64%7a%72%75%54%6a%48%64%57zVee%70%625%44z%72%55tjH%44W%7aV%45%45%50b%35dzrUtjH%64wZ%56EeP%42%35%64zr%75Tj%68%64%57%7a%56EePb%35D%7a%72u%54jHD%77%5aV%65ePB5dzrut%4ahDwZV%65%65%70%42%35%64%7aR%75T%4a%48%64W%7a%76%65ep%625d%5aRUTJH%44wz%56%65%45p%625dZrUT%6a%68D%77%7aVeE%70%425DzRU%74jh%44w%7avE%65%50%425%44zrUT%4a%68%44%57%7a%76eEP%62%35%64z%52%75%54jHDwZVE%45%50%42%35dzRU%74J%48%64%77%5a%56%45%45P%62%35D%5a%72%55tJh%64wZ%76%45E%50B%35%44zR%55%74%6ah%44W%5aveE%50%425d%7a%72ut%4a%68DWZVE%65%50B5DzR%55tJHDwzV%65%45%50%42%35%44zR%55t%5c.%5c%2e.%5c%2e\\W%65b\\.\\Au%74%48%5c./",
            "msg": "Uncommon header 'cross-origin-embedder-policy' found, with contents: require-corp"
        },
        {
            "id": "999100",
            "OSVDB": "0",
            "method": "GET",
            "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20xWDpvJSTFV/../../dQumZQAd1Z1jLBuoqe.html%3Fmft0bC82cl1WFAedA=/..//.%5c%4a%48%64%57Zv%45%65Pb%35%44%5arUTJH%44w%5a%76ee%70%625Dzr%75%74JhDW%7a%56%45%45%50%625Dz%72Utjh%64W%7a%56%45Epb%35%44Z%52UTj%68d%57%5a%56%65e%70%62%35%44%7a%52%55%54%4aH%44%77z%76EE%50B5%64zR%55%54j%68%64w%5aV%45%65%70B5DzRu%54jH%64w%7a%56E%45%70%62%35dZr%55TJHdwz%56e%65Pb5DZ%52%55%54%4a%48%44wz%56E%45%70%425%64zR%55tJ%48%44W%5aVEe%70B5%44zr%75%74%4ah%44W%7a%76eE%70%42%35%64zr%75%74J%68%44%77Zve%65Pb%35%64%7a%52%55%74%6ah%44%57%7avE%65%70%62%35%64%5a%72uT%6a%68DwZVe%65%70b5%64%7a%72%75%54%6a%48%64%57zVee%70%625%44z%72%55tjH%44W%7aV%45%45%50b%35dzrUtjH%64wZ%56EeP%42%35%64zr%75Tj%68%64%57%7a%56EePb%35D%7a%72u%54jHD%77%5aV%65ePB5dzrut%4ahDwZV%65%65%70%42%35%64%7aR%75T%4a%48%64W%7a%76%65ep%625d%5aRUTJH%44wz%56%65%45p%625dZrUT%6a%68D%77%7aVeE%70%425DzRU%74jh%44w%7avE%65%50%425%44zrUT%4a%68%44%57%7a%76eEP%62%35%64z%52%75%54jHDwZVE%45%50%42%35dzRU%74J%48%64%77%5a%56%45%45P%62%35D%5a%72%55tJh%64wZ%76%45E%50B%35%44zR%55%74%6ah%44W%5aveE%50%425d%7a%72ut%4a%68DWZVE%65%50B5DzR%55tJHDwzV%65%45%50%42%35%44zR%55t%5c.%5c%2e.%5c%2e\\W%65b\\.\\Au%74%48%5c./",
            "msg": "Uncommon header 'feature-policy' found, with contents: microphone 'none'; camera 'none'"
        },
        {
            "id": "999100",
            "OSVDB": "0",
            "method": "GET",
            "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20xWDpvJSTFV/../../dQumZQAd1Z1jLBuoqe.html%3Fmft0bC82cl1WFAedA=/..//.%5c%4a%48%64%57Zv%45%65Pb%35%44%5arUTJH%44w%5a%76ee%70%625Dzr%75%74JhDW%7a%56%45%45%50%625Dz%72Utjh%64W%7a%56%45Epb%35%44Z%52UTj%68d%57%5a%56%65e%70%62%35%44%7a%52%55%54%4aH%44%77z%76EE%50B5%64zR%55%54j%68%64w%5aV%45%65%70B5DzRu%54jH%64w%7a%56E%45%70%62%35dZr%55TJHdwz%56e%65Pb5DZ%52%55%54%4a%48%44wz%56E%45%70%425%64zR%55tJ%48%44W%5aVEe%70B5%44zr%75%74%4ah%44W%7a%76eE%70%42%35%64zr%75%74J%68%44%77Zve%65Pb%35%64%7a%52%55%74%6ah%44%57%7avE%65%70%62%35%64%5a%72uT%6a%68DwZVe%65%70b5%64%7a%72%75%54%6a%48%64%57zVee%70%625%44z%72%55tjH%44W%7aV%45%45%50b%35dzrUtjH%64wZ%56EeP%42%35%64zr%75Tj%68%64%57%7a%56EePb%35D%7a%72u%54jHD%77%5aV%65ePB5dzrut%4ahDwZV%65%65%70%42%35%64%7aR%75T%4a%48%64W%7a%76%65ep%625d%5aRUTJH%44wz%56%65%45p%625dZrUT%6a%68D%77%7aVeE%70%425DzRU%74jh%44w%7avE%65%50%425%44zrUT%4a%68%44%57%7a%76eEP%62%35%64z%52%75%54jHDwZVE%45%50%42%35dzRU%74J%48%64%77%5a%56%45%45P%62%35D%5a%72%55tJh%64wZ%76%45E%50B%35%44zR%55%74%6ah%44W%5aveE%50%425d%7a%72ut%4a%68DWZVE%65%50B5DzR%55tJHDwzV%65%45%50%42%35%44zR%55t%5c.%5c%2e.%5c%2e\\W%65b\\.\\Au%74%48%5c./",
            "msg": "Uncommon header 'clear-site-data' found, with contents: *"
        },
        {
            "id": "999100",
            "OSVDB": "0",
            "method": "GET",
            "url": "/web/auth/%20HTTP/1.1%0d%0aAccept%3a%20xWDpvJSTFV/../../dQumZQAd1Z1jLBuoqe.html%3Fmft0bC82cl1WFAedA=/..//.%5c%4a%48%64%57Zv%45%65Pb%35%44%5arUTJH%44w%5a%76ee%70%625Dzr%75%74JhDW%7a%56%45%45%50%625Dz%72Utjh%64W%7a%56%45Epb%35%44Z%52UTj%68d%57%5a%56%65e%70%62%35%44%7a%52%55%54%4aH%44%77z%76EE%50B5%64zR%55%54j%68%64w%5aV%45%65%70B5DzRu%54jH%64w%7a%56E%45%70%62%35dZr%55TJHdwz%56e%65Pb5DZ%52%55%54%4a%48%44wz%56E%45%70%425%64zR%55tJ%48%44W%5aVEe%70B5%44zr%75%74%4ah%44W%7a%76eE%70%42%35%64zr%75%74J%68%44%77Zve%65Pb%35%64%7a%52%55%74%6ah%44%57%7avE%65%70%62%35%64%5a%72uT%6a%68DwZVe%65%70b5%64%7a%72%75%54%6a%48%64%57zVee%70%625%44z%72%55tjH%44W%7aV%45%45%50b%35dzrUtjH%64wZ%56EeP%42%35%64zr%75Tj%68%64%57%7a%56EePb%35D%7a%72u%54jHD%77%5aV%65ePB5dzrut%4ahDwZV%65%65%70%42%35%64%7aR%75T%4a%48%64W%7a%76%65ep%625d%5aRUTJH%44wz%56%65%45p%625dZrUT%6a%68D%77%7aVeE%70%425DzRU%74jh%44w%7avE%65%50%425%44zrUT%4a%68%44%57%7a%76eEP%62%35%64z%52%75%54jHDwZVE%45%50%42%35dzRU%74J%48%64%77%5a%56%45%45P%62%35D%5a%72%55tJh%64wZ%76%45E%50B%35%44zR%55%74%6ah%44W%5aveE%50%425d%7a%72ut%4a%68DWZVE%65%50B5DzR%55tJHDwzV%65%45%50%42%35%44zR%55t%5c.%5c%2e.%5c%2e\\W%65b\\.\\Au%74%48%5c./",
            "msg": "Uncommon header 'x-server' found, with contents: WebScripts"
        }
    ]
}
```

## ZAP

```json
{
    "@version": "2.10.0",
    "@generated": "Sat, 11 Sep 2021 08:11:24",
    "site": [
        {
            "@name": "http://localhost:8000",
            "@host": "localhost",
            "@port": "8000",
            "@ssl": "false",
            "alerts": [
                {
                    "pluginid": "10027",
                    "alertRef": "10027",
                    "alert": "Information Disclosure - Suspicious Comments",
                    "name": "Information Disclosure - Suspicious Comments",
                    "riskcode": "0",
                    "confidence": "2",
                    "riskdesc": "Informational (Medium)",
                    "desc": "<p>The response appears to contain suspicious comments which may help an attacker. Note: Matches made within script blocks or files are against the entire content not only comments.</p>",
                    "instances": [
                        {
                            "uri": "http://localhost:8000/web/scripts/get_password_share.py",
                            "method": "GET"
                        },
                        {
                            "uri": "http://localhost:8000/web/",
                            "method": "GET"
                        },
                        {
                            "uri": "http://localhost:8000/web/scripts/show_license.py",
                            "method": "GET"
                        },
                        {
                            "uri": "http://localhost:8000/web/auth/",
                            "method": "GET"
                        },
                        {
                            "uri": "http://localhost:8000/web/scripts/password_generator.py",
                            "method": "GET"
                        },
                        {
                            "uri": "http://localhost:8000/web/scripts/new_password_share.py",
                            "method": "GET"
                        },
                        {
                            "uri": "http://localhost:8000/",
                            "method": "GET"
                        }
                    ],
                    "count": "7",
                    "solution": "<p>Remove all comments that return information that may help an attacker and fix any underlying problems they refer to.</p>",
                    "otherinfo": "<p>The following comment/snippet was identified via the pattern: \\bLATER\\b</p><p><!--</p><p></p><p>    HTML page to launch scripts.</p><p>    Copyright (C) 2021  Maurice Lambert</p><p></p><p>    This program is free software: you can redistribute it and/or modify</p><p>    it under the terms of the GNU General Public License as published by</p><p>    the Free Software Foundation, either version 3 of the License, or</p><p>    (at your option) any later version.</p><p></p><p>    This program is distributed in the hope that it will be useful,</p><p>    but WITHOUT ANY WARRANTY; without even the implied warranty of</p><p>    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the</p><p>    GNU General Public License for more details.</p><p></p><p>    You should have received a copy of the GNU General Public License</p><p>    along with this program.  If not, see <https://www.gnu.org/licenses/>.</p><p></p><p>--></p><p></p>",
                    "reference": "<p></p>",
                    "cweid": "200",
                    "wascid": "13",
                    "sourceid": "3"
                },
                {
                    "pluginid": "30002",
                    "alertRef": "30002",
                    "alert": "Format String Error",
                    "name": "Format String Error",
                    "riskcode": "2",
                    "confidence": "2",
                    "riskdesc": "Medium (Medium)",
                    "desc": "<p>A Format String error occurs when the submitted data of an input string is evaluated as a command by the application. </p>",
                    "instances": [
                        {
                            "uri": "http://localhost:8000/error_pages/Request/send/404",
                            "method": "POST",
                            "param": "value",
                            "attack": "ZAP %1!s%2!s%3!s%4!s%5!s%6!s%7!s%8!s%9!s%10!s%11!s%12!s%13!s%14!s%15!s%16!s%17!s%18!s%19!s%20!s%21!n%22!n%23!n%24!n%25!n%26!n%27!n%28!n%29!n%30!n%31!n%32!n%33!n%34!n%35!n%36!n%37!n%38!n%39!n%40!n\n"
                        }
                    ],
                    "count": "1",
                    "solution": "<p>Rewrite the background program using proper deletion of bad character strings.  This will require a recompile of the background executable.</p>",
                    "otherinfo": "<p>Potential Format String Error.  The script closed the connection on a microsoft format string error</p>",
                    "reference": "<p>https://owasp.org/www-community/attacks/Format_string_attack</p>",
                    "cweid": "134",
                    "wascid": "6",
                    "sourceid": "1"
                },
                {
                    "pluginid": "90022",
                    "alertRef": "90022",
                    "alert": "Application Error Disclosure",
                    "name": "Application Error Disclosure",
                    "riskcode": "1",
                    "confidence": "2",
                    "riskdesc": "Low (Medium)",
                    "desc": "<p>This page contains an error/warning message that may disclose sensitive information like the location of the file that produced the unhandled exception. This information can be used to launch further attacks against the web application. The alert could be a false positive if the error message is found inside a documentation page.</p>",
                    "instances": [
                        {
                            "uri": "http://localhost:8000/auth/",
                            "method": "POST",
                            "evidence": "HTTP/1.0 500 Internal Error"
                        }
                    ],
                    "count": "1",
                    "solution": "<p>Review the source code of this page. Implement custom error pages. Consider implementing a mechanism to provide a unique error reference/identifier to the client (browser) while logging the details on the server side and not exposing them to the user.</p>",
                    "reference": "<p></p>",
                    "cweid": "200",
                    "wascid": "13",
                    "sourceid": "3"
                },
                {
                    "pluginid": "10027",
                    "alertRef": "10027",
                    "alert": "Information Disclosure - Suspicious Comments",
                    "name": "Information Disclosure - Suspicious Comments",
                    "riskcode": "0",
                    "confidence": "1",
                    "riskdesc": "Informational (Low)",
                    "desc": "<p>The response appears to contain suspicious comments which may help an attacker. Note: Matches made within script blocks or files are against the entire content not only comments.</p>",
                    "instances": [
                        {
                            "uri": "http://localhost:8000/js/webscripts_script_js_scripts.js",
                            "method": "GET"
                        },
                        {
                            "uri": "http://localhost:8000/js/webscripts_index_js_scripts.js",
                            "method": "GET"
                        },
                        {
                            "uri": "http://localhost:8000/js/webscripts_js_scripts.js",
                            "method": "GET"
                        }
                    ],
                    "count": "3",
                    "solution": "<p>Remove all comments that return information that may help an attacker and fix any underlying problems they refer to.</p>",
                    "otherinfo": "<p>The following comment/snippet was identified via the pattern: \\bLATER\\b</p><p>\t\t(at your option) any later version.</p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b</p><p>            let select = document.createElement(\"select\");</p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b</p><p>            select.id = argument.name;</p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b</p><p>            select.name = argument.name;</p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b</p><p>                select.multiple = true;</p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b</p><p>                select.value = argument.default_value;</p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b</p><p>                select.appendChild(option);</p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b</p><p>            return select;</p><p>The following comment/snippet was identified via the pattern: \\bQUERY\\b</p><p>            let query = location.search;</p><p>The following comment/snippet was identified via the pattern: \\bQUERY\\b</p><p>            query = query.substr(1);</p><p>The following comment/snippet was identified via the pattern: \\bQUERY\\b</p><p>            query.split(\"&\").forEach(function(part) {</p><p>The following comment/snippet was identified via the pattern: \\bFROM\\b</p><p>        let values = Array.from(document.getElementsByTagName('input')).concat(</p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b</p><p>            Array.from(document.getElementsByTagName('select')));</p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b</p><p>function add_SELECT_argument(select, values, counter, arguments_) {</p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b</p><p>    for (let l = 0; l < select.options.length; ++l) {</p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b</p><p>        option = select.options[l];</p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b</p><p>                select.id,</p><p>The following comment/snippet was identified via the pattern: \\bSELECT\\b</p><p>                select.name,</p><p>The following comment/snippet was identified via the pattern: \\bBUG\\b</p><p>                `HTTP ERROR ${xhttp.status}. You can report a bug <a href=\"/error_pages/Report/new/${xhttp.status}\">on the local report page</a>.`;</p><p></p>",
                    "reference": "<p></p>",
                    "cweid": "200",
                    "wascid": "13",
                    "sourceid": "3"
                },
                {
                    "pluginid": "90022",
                    "alertRef": "90022",
                    "alert": "Application Error Disclosure",
                    "name": "Application Error Disclosure",
                    "riskcode": "2",
                    "confidence": "2",
                    "riskdesc": "Medium (Medium)",
                    "desc": "<p>This page contains an error/warning message that may disclose sensitive information like the location of the file that produced the unhandled exception. This information can be used to launch further attacks against the web application. The alert could be a false positive if the error message is found inside a documentation page.</p>",
                    "instances": [
                        {
                            "uri": "http://localhost:8000/js/webscripts_script_js_scripts.js",
                            "method": "GET",
                            "evidence": "Internal Server Error"
                        }
                    ],
                    "count": "1",
                    "solution": "<p>Review the source code of this page. Implement custom error pages. Consider implementing a mechanism to provide a unique error reference/identifier to the client (browser) while logging the details on the server side and not exposing them to the user.</p>",
                    "reference": "<p></p>",
                    "cweid": "200",
                    "wascid": "13",
                    "sourceid": "3"
                }
            ]
        }
    ]
}

```