# generated by datamodel-codegen:
#   filename:  schema/entity/data/metrics.json
#   timestamp: 2021-10-12T00:34:28+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Field, constr

from ...type import basic, entityReference, usageDetails


class Metrics(BaseModel):
    id: basic.Uuid = Field(
        ..., description='Unique identifier that identifies this metrics instance.'
    )
    name: constr(min_length=1, max_length=64) = Field(
        ..., description='Name that identifies this metrics instance uniquely.'
    )
    fullyQualifiedName: Optional[constr(min_length=1, max_length=64)] = Field(
        None,
        description="A unique name that identifies a metric in the format 'ServiceName.MetricName'.",
    )
    description: Optional[str] = Field(
        None,
        description='Description of metrics instance, what it is, and how to use it.',
    )
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this metrics.'
    )
    service: entityReference.EntityReference = Field(
        ..., description='Link to service where this metrics is hosted in.'
    )
    usageSummary: Optional[usageDetails.TypeUsedToReturnUsageDetailsOfAnEntity] = Field(
        None, description='Latest usage information for this database.'
    )
