import unittest

from pycoin.symbols.btc import network


class ElectrumTest(unittest.TestCase):
    def test_initial_key(self):
        RECEIVING_ADDRESSES = [
            "1LDkC1H438qSnJLHCYkQ3WTZQkSEwoYGHc",
            "12mENAcc8ZhZbR6hv7LGm3jV7PwbYeF8Xk",
            "1A3NpABFd6YHvwr1ti1r8brU3BzQuV2Nr4",
            "1Gn6nWAoZrpmtV9zuNbyivWvRBpcygWaQX",
            "1M5i5P3DhtDbnvSTfmnUbcrTVgF8GDWQW9"
        ]
        CHANGE_ADDRESSES = [
            "1iiAbyBTh1J69UzD1JcrfW8JSVJ9ve9gT",
            "146wnqmsQNYCZ6AXRCqLkzZyGM1ZU6nr3F",
            "1Mwexajvia3s8AcaGUkyEg9ZZJPJeTbKTZ"
        ]
        wallet = network.keys.electrum_seed(seed="00000000000000000000000000000001")
        for idx, address in enumerate(RECEIVING_ADDRESSES):
            subkey = wallet.subkey("%s/0" % idx)
            calculated_address = subkey.address()
            self.assertEqual(address, calculated_address)
            wif = subkey.wif()
            key = network.parse.wif(wif)
            self.assertEqual(key.address(), address)
        for idx, address in enumerate(CHANGE_ADDRESSES):
            subkey = wallet.subkey("%s/1" % idx)
            calculated_address = subkey.address()
            self.assertEqual(address, calculated_address)
            wif = subkey.wif()
            key = network.parse.wif(wif)
            self.assertEqual(key.address(), address)

    def test_master_public_and_private(self):
        # these addresses were generated by hand using electrum with a master public key
        # corresponding to secret exponent 1
        RECEIVING_ADDRESSES = [
            "1AYPdHLna6bKFUbeXoAEVbaXUxifUwCMay",
            "13UeuWJba5epizAKyfCfiFKY5Kbxfdxe7B",
            "19f6KJUTL5AGBRvLBGiL6Zpcx53QA7zaKT",
            "1Cm33VuSkoUETwx5nsF1wgmGqYwJZxpZdY",
            "14Z6ErkETixQMUeivsYbrdoUFns2J1iSct",
        ]
        CHANGE_ADDRESSES = [
            "1JVYsmjrqSy1BKvo1gYpNjX7AYea74nQYe",
            "1Cc7itfQaDqZK3vHYphFsySujQjBNba8mw",
            "15wrXvrAnyv3usGeQRohnnZ8tz9XAekbag",
            "1MnWCEjE5YiZpZrkP8HcXEeDqwg43RxLwu",
            "1Fgyp3PUx9AAg8yJe1zGXHP5dVC6i1tXbs",
            "12XTLd4u9jeqw4egLAUhoKLxHARCdKWkty"
        ]
        k = network.keys.private(secret_exponent=1)
        master_public_key = k.sec(is_compressed=False)[1:]

        wallet = network.keys.electrum_public(master_public_key)
        for idx, address in enumerate(RECEIVING_ADDRESSES):
            subkey = wallet.subkey("%s/0" % idx)
            calculated_address = subkey.address()
            self.assertEqual(address, calculated_address)
        for idx, address in enumerate(CHANGE_ADDRESSES):
            subkey = wallet.subkey("%s/1" % idx)
            calculated_address = subkey.address()
            self.assertEqual(address, calculated_address)

        wallet = network.keys.electrum_private(master_private_key=1)
        for idx, address in enumerate(RECEIVING_ADDRESSES):
            subkey = wallet.subkey("%s/0" % idx)
            calculated_address = subkey.address()
            self.assertEqual(address, calculated_address)
            wif = subkey.wif()
            key = network.parse.wif(wif)
            self.assertEqual(key.address(), address)
        for idx, address in enumerate(CHANGE_ADDRESSES):
            subkey = wallet.subkey("%s/1" % idx)
            calculated_address = subkey.address()
            self.assertEqual(address, calculated_address)
            wif = subkey.wif()
            key = network.parse.wif(wif)
            self.assertEqual(key.address(), address)
