# -*- coding: utf-8 -*-
"""`Concordance between TSIC2552 and ISIC3 <http://statstd.nso.go.th/classification/downloadcffile.aspx?id=94>`_.
"""
from ...types import Concordance, Standards
from ..isic3 import ISIC3
from . import TSIC2552

TSIC2552_to_ISIC3 = Concordance(
    src=TSIC2552,
    dst=ISIC3,
    concordances=[
        ((Standards.TSIC2552, "01111"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01112"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01113"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01114"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01115"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01121"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01122"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01131"), (Standards.ISIC3, "0112")),
        ((Standards.TSIC2552, "01132"), (Standards.ISIC3, "0112")),
        ((Standards.TSIC2552, "01133"), (Standards.ISIC3, "0112")),
        ((Standards.TSIC2552, "01134"), (Standards.ISIC3, "0112")),
        ((Standards.TSIC2552, "01135"), (Standards.ISIC3, "0112")),
        ((Standards.TSIC2552, "01136"), (Standards.ISIC3, "0112")),
        ((Standards.TSIC2552, "01139"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01139"), (Standards.ISIC3, "0112")),
        ((Standards.TSIC2552, "01140"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01150"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01161"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01169"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01191"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01192"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01193"), (Standards.ISIC3, "0112")),
        ((Standards.TSIC2552, "01194"), (Standards.ISIC3, "0112")),
        ((Standards.TSIC2552, "01199"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01199"), (Standards.ISIC3, "0112")),
        ((Standards.TSIC2552, "01210"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01221"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01222"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01223"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01224"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01225"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01226"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01227"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01228"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01229"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01231"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01239"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01241"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01249"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01251"), (Standards.ISIC3, "0112")),
        ((Standards.TSIC2552, "01251"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01252"), (Standards.ISIC3, "0112")),
        ((Standards.TSIC2552, "01252"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01259"), (Standards.ISIC3, "0112")),
        ((Standards.TSIC2552, "01259"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01261"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01262"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01269"), (Standards.ISIC3, "0112")),
        ((Standards.TSIC2552, "01269"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01271"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01272"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01279"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01281"), (Standards.ISIC3, "0112")),
        ((Standards.TSIC2552, "01282"), (Standards.ISIC3, "0112")),
        ((Standards.TSIC2552, "01289"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01289"), (Standards.ISIC3, "0112")),
        ((Standards.TSIC2552, "01289"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "01291"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01292"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01299"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01299"), (Standards.ISIC3, "0112")),
        ((Standards.TSIC2552, "01299"), (Standards.ISIC3, "0200")),
        ((Standards.TSIC2552, "01301"), (Standards.ISIC3, "0122")),
        ((Standards.TSIC2552, "01302"), (Standards.ISIC3, "0122")),
        ((Standards.TSIC2552, "01302"), (Standards.ISIC3, "0200")),
        ((Standards.TSIC2552, "01411"), (Standards.ISIC3, "0121")),
        ((Standards.TSIC2552, "01412"), (Standards.ISIC3, "0121")),
        ((Standards.TSIC2552, "01419"), (Standards.ISIC3, "0121")),
        ((Standards.TSIC2552, "01420"), (Standards.ISIC3, "0121")),
        ((Standards.TSIC2552, "01430"), (Standards.ISIC3, "0122")),
        ((Standards.TSIC2552, "01441"), (Standards.ISIC3, "0121")),
        ((Standards.TSIC2552, "01442"), (Standards.ISIC3, "0121")),
        ((Standards.TSIC2552, "01450"), (Standards.ISIC3, "0122")),
        ((Standards.TSIC2552, "01461"), (Standards.ISIC3, "0122")),
        ((Standards.TSIC2552, "01462"), (Standards.ISIC3, "0122")),
        ((Standards.TSIC2552, "01463"), (Standards.ISIC3, "0122")),
        ((Standards.TSIC2552, "01469"), (Standards.ISIC3, "0122")),
        ((Standards.TSIC2552, "01491"), (Standards.ISIC3, "0122")),
        ((Standards.TSIC2552, "01492"), (Standards.ISIC3, "0122")),
        ((Standards.TSIC2552, "01493"), (Standards.ISIC3, "0122")),
        ((Standards.TSIC2552, "01494"), (Standards.ISIC3, "0122")),
        ((Standards.TSIC2552, "01495"), (Standards.ISIC3, "0122")),
        ((Standards.TSIC2552, "01496"), (Standards.ISIC3, "0122")),
        ((Standards.TSIC2552, "01499"), (Standards.ISIC3, "0122")),
        ((Standards.TSIC2552, "01500"), (Standards.ISIC3, "0130")),
        ((Standards.TSIC2552, "01611"), (Standards.ISIC3, "0140")),
        ((Standards.TSIC2552, "01612"), (Standards.ISIC3, "0140")),
        ((Standards.TSIC2552, "01619"), (Standards.ISIC3, "0140")),
        ((Standards.TSIC2552, "01621"), (Standards.ISIC3, "0140")),
        ((Standards.TSIC2552, "01629"), (Standards.ISIC3, "0140")),
        ((Standards.TSIC2552, "01629"), (Standards.ISIC3, "2892")),
        ((Standards.TSIC2552, "01630"), (Standards.ISIC3, "0111")),
        ((Standards.TSIC2552, "01630"), (Standards.ISIC3, "0140")),
        ((Standards.TSIC2552, "01640"), (Standards.ISIC3, "0140")),
        ((Standards.TSIC2552, "01700"), (Standards.ISIC3, "0150")),
        ((Standards.TSIC2552, "02100"), (Standards.ISIC3, "0200")),
        ((Standards.TSIC2552, "02200"), (Standards.ISIC3, "0200")),
        ((Standards.TSIC2552, "02300"), (Standards.ISIC3, "0200")),
        ((Standards.TSIC2552, "02400"), (Standards.ISIC3, "0200")),
        ((Standards.TSIC2552, "03111"), (Standards.ISIC3, "0500")),
        ((Standards.TSIC2552, "03112"), (Standards.ISIC3, "0500")),
        ((Standards.TSIC2552, "03113"), (Standards.ISIC3, "0500")),
        ((Standards.TSIC2552, "03114"), (Standards.ISIC3, "0500")),
        ((Standards.TSIC2552, "03115"), (Standards.ISIC3, "0500")),
        ((Standards.TSIC2552, "03119"), (Standards.ISIC3, "0500")),
        ((Standards.TSIC2552, "03121"), (Standards.ISIC3, "0500")),
        ((Standards.TSIC2552, "03122"), (Standards.ISIC3, "0500")),
        ((Standards.TSIC2552, "03129"), (Standards.ISIC3, "0500")),
        ((Standards.TSIC2552, "03211"), (Standards.ISIC3, "0500")),
        ((Standards.TSIC2552, "03212"), (Standards.ISIC3, "0500")),
        ((Standards.TSIC2552, "03213"), (Standards.ISIC3, "0500")),
        ((Standards.TSIC2552, "03214"), (Standards.ISIC3, "0500")),
        ((Standards.TSIC2552, "03219"), (Standards.ISIC3, "0122")),
        ((Standards.TSIC2552, "03219"), (Standards.ISIC3, "0500")),
        ((Standards.TSIC2552, "03221"), (Standards.ISIC3, "0500")),
        ((Standards.TSIC2552, "03222"), (Standards.ISIC3, "0500")),
        ((Standards.TSIC2552, "03223"), (Standards.ISIC3, "0122")),
        ((Standards.TSIC2552, "03224"), (Standards.ISIC3, "0122")),
        ((Standards.TSIC2552, "03225"), (Standards.ISIC3, "0500")),
        ((Standards.TSIC2552, "03229"), (Standards.ISIC3, "0122")),
        ((Standards.TSIC2552, "03229"), (Standards.ISIC3, "0500")),
        ((Standards.TSIC2552, "05100"), (Standards.ISIC3, "1010")),
        ((Standards.TSIC2552, "05200"), (Standards.ISIC3, "1020")),
        ((Standards.TSIC2552, "06100"), (Standards.ISIC3, "1110")),
        ((Standards.TSIC2552, "06200"), (Standards.ISIC3, "1110")),
        ((Standards.TSIC2552, "07100"), (Standards.ISIC3, "1310")),
        ((Standards.TSIC2552, "07210"), (Standards.ISIC3, "1200")),
        ((Standards.TSIC2552, "07291"), (Standards.ISIC3, "1320")),
        ((Standards.TSIC2552, "07292"), (Standards.ISIC3, "1320")),
        ((Standards.TSIC2552, "07299"), (Standards.ISIC3, "1320")),
        ((Standards.TSIC2552, "07300"), (Standards.ISIC3, "1320")),
        ((Standards.TSIC2552, "08101"), (Standards.ISIC3, "1410")),
        ((Standards.TSIC2552, "08101"), (Standards.ISIC3, "1429")),
        ((Standards.TSIC2552, "08102"), (Standards.ISIC3, "1410")),
        ((Standards.TSIC2552, "08103"), (Standards.ISIC3, "1410")),
        ((Standards.TSIC2552, "08104"), (Standards.ISIC3, "1410")),
        ((Standards.TSIC2552, "08910"), (Standards.ISIC3, "1421")),
        ((Standards.TSIC2552, "08920"), (Standards.ISIC3, "1030")),
        ((Standards.TSIC2552, "08931"), (Standards.ISIC3, "1422")),
        ((Standards.TSIC2552, "08932"), (Standards.ISIC3, "1422")),
        ((Standards.TSIC2552, "08991"), (Standards.ISIC3, "1429")),
        ((Standards.TSIC2552, "08999"), (Standards.ISIC3, "1429")),
        ((Standards.TSIC2552, "09100"), (Standards.ISIC3, "1110")),
        ((Standards.TSIC2552, "09100"), (Standards.ISIC3, "1120")),
        ((Standards.TSIC2552, "09100"), (Standards.ISIC3, "7421")),
        ((Standards.TSIC2552, "09900"), (Standards.ISIC3, "1010")),
        ((Standards.TSIC2552, "09900"), (Standards.ISIC3, "1020")),
        ((Standards.TSIC2552, "09900"), (Standards.ISIC3, "1030")),
        ((Standards.TSIC2552, "09900"), (Standards.ISIC3, "1200")),
        ((Standards.TSIC2552, "09900"), (Standards.ISIC3, "1310")),
        ((Standards.TSIC2552, "09900"), (Standards.ISIC3, "1320")),
        ((Standards.TSIC2552, "09900"), (Standards.ISIC3, "1410")),
        ((Standards.TSIC2552, "09900"), (Standards.ISIC3, "1421")),
        ((Standards.TSIC2552, "09900"), (Standards.ISIC3, "1422")),
        ((Standards.TSIC2552, "09900"), (Standards.ISIC3, "1429")),
        ((Standards.TSIC2552, "09900"), (Standards.ISIC3, "4510")),
        ((Standards.TSIC2552, "09900"), (Standards.ISIC3, "7421")),
        ((Standards.TSIC2552, "10111"), (Standards.ISIC3, "1511")),
        ((Standards.TSIC2552, "10112"), (Standards.ISIC3, "1511")),
        ((Standards.TSIC2552, "10120"), (Standards.ISIC3, "1511")),
        ((Standards.TSIC2552, "10131"), (Standards.ISIC3, "1511")),
        ((Standards.TSIC2552, "10132"), (Standards.ISIC3, "1511")),
        ((Standards.TSIC2552, "10133"), (Standards.ISIC3, "1511")),
        ((Standards.TSIC2552, "10134"), (Standards.ISIC3, "1511")),
        ((Standards.TSIC2552, "10139"), (Standards.ISIC3, "1511")),
        ((Standards.TSIC2552, "10211"), (Standards.ISIC3, "1512")),
        ((Standards.TSIC2552, "10212"), (Standards.ISIC3, "1512")),
        ((Standards.TSIC2552, "10221"), (Standards.ISIC3, "1512")),
        ((Standards.TSIC2552, "10222"), (Standards.ISIC3, "1512")),
        ((Standards.TSIC2552, "10291"), (Standards.ISIC3, "1512")),
        ((Standards.TSIC2552, "10292"), (Standards.ISIC3, "1512")),
        ((Standards.TSIC2552, "10293"), (Standards.ISIC3, "1512")),
        ((Standards.TSIC2552, "10294"), (Standards.ISIC3, "1512")),
        ((Standards.TSIC2552, "10295"), (Standards.ISIC3, "1512")),
        ((Standards.TSIC2552, "10299"), (Standards.ISIC3, "1512")),
        ((Standards.TSIC2552, "10301"), (Standards.ISIC3, "1513")),
        ((Standards.TSIC2552, "10302"), (Standards.ISIC3, "1513")),
        ((Standards.TSIC2552, "10303"), (Standards.ISIC3, "1513")),
        ((Standards.TSIC2552, "10304"), (Standards.ISIC3, "1513")),
        ((Standards.TSIC2552, "10305"), (Standards.ISIC3, "1513")),
        ((Standards.TSIC2552, "10306"), (Standards.ISIC3, "1513")),
        ((Standards.TSIC2552, "10307"), (Standards.ISIC3, "1549")),
        ((Standards.TSIC2552, "10309"), (Standards.ISIC3, "1513")),
        ((Standards.TSIC2552, "10309"), (Standards.ISIC3, "1549")),
        ((Standards.TSIC2552, "10411"), (Standards.ISIC3, "1514")),
        ((Standards.TSIC2552, "10412"), (Standards.ISIC3, "1514")),
        ((Standards.TSIC2552, "10413"), (Standards.ISIC3, "1532")),
        ((Standards.TSIC2552, "10414"), (Standards.ISIC3, "1514")),
        ((Standards.TSIC2552, "10419"), (Standards.ISIC3, "1514")),
        ((Standards.TSIC2552, "10420"), (Standards.ISIC3, "1514")),
        ((Standards.TSIC2552, "10491"), (Standards.ISIC3, "1514")),
        ((Standards.TSIC2552, "10499"), (Standards.ISIC3, "1514")),
        ((Standards.TSIC2552, "10501"), (Standards.ISIC3, "1520")),
        ((Standards.TSIC2552, "10502"), (Standards.ISIC3, "1520")),
        ((Standards.TSIC2552, "10503"), (Standards.ISIC3, "1520")),
        ((Standards.TSIC2552, "10504"), (Standards.ISIC3, "1520")),
        ((Standards.TSIC2552, "10505"), (Standards.ISIC3, "1520")),
        ((Standards.TSIC2552, "10509"), (Standards.ISIC3, "1520")),
        ((Standards.TSIC2552, "10611"), (Standards.ISIC3, "1531")),
        ((Standards.TSIC2552, "10612"), (Standards.ISIC3, "1531")),
        ((Standards.TSIC2552, "10613"), (Standards.ISIC3, "1531")),
        ((Standards.TSIC2552, "10614"), (Standards.ISIC3, "1531")),
        ((Standards.TSIC2552, "10615"), (Standards.ISIC3, "1531")),
        ((Standards.TSIC2552, "10616"), (Standards.ISIC3, "1531")),
        ((Standards.TSIC2552, "10617"), (Standards.ISIC3, "1531")),
        ((Standards.TSIC2552, "10619"), (Standards.ISIC3, "1531")),
        ((Standards.TSIC2552, "10621"), (Standards.ISIC3, "1532")),
        ((Standards.TSIC2552, "10622"), (Standards.ISIC3, "1532")),
        ((Standards.TSIC2552, "10623"), (Standards.ISIC3, "1532")),
        ((Standards.TSIC2552, "10629"), (Standards.ISIC3, "1532")),
        ((Standards.TSIC2552, "10711"), (Standards.ISIC3, "1541")),
        ((Standards.TSIC2552, "10712"), (Standards.ISIC3, "1541")),
        ((Standards.TSIC2552, "10713"), (Standards.ISIC3, "1541")),
        ((Standards.TSIC2552, "10721"), (Standards.ISIC3, "1542")),
        ((Standards.TSIC2552, "10722"), (Standards.ISIC3, "1542")),
        ((Standards.TSIC2552, "10723"), (Standards.ISIC3, "1542")),
        ((Standards.TSIC2552, "10731"), (Standards.ISIC3, "1543")),
        ((Standards.TSIC2552, "10732"), (Standards.ISIC3, "1543")),
        ((Standards.TSIC2552, "10733"), (Standards.ISIC3, "1543")),
        ((Standards.TSIC2552, "10734"), (Standards.ISIC3, "1543")),
        ((Standards.TSIC2552, "10739"), (Standards.ISIC3, "1543")),
        ((Standards.TSIC2552, "10741"), (Standards.ISIC3, "1544")),
        ((Standards.TSIC2552, "10742"), (Standards.ISIC3, "1544")),
        ((Standards.TSIC2552, "10743"), (Standards.ISIC3, "1544")),
        ((Standards.TSIC2552, "10749"), (Standards.ISIC3, "1544")),
        ((Standards.TSIC2552, "10751"), (Standards.ISIC3, "1512")),
        ((Standards.TSIC2552, "10751"), (Standards.ISIC3, "1513")),
        ((Standards.TSIC2552, "10751"), (Standards.ISIC3, "1544")),
        ((Standards.TSIC2552, "10751"), (Standards.ISIC3, "1549")),
        ((Standards.TSIC2552, "10752"), (Standards.ISIC3, "1512")),
        ((Standards.TSIC2552, "10752"), (Standards.ISIC3, "1513")),
        ((Standards.TSIC2552, "10752"), (Standards.ISIC3, "1544")),
        ((Standards.TSIC2552, "10752"), (Standards.ISIC3, "1549")),
        ((Standards.TSIC2552, "10761"), (Standards.ISIC3, "1549")),
        ((Standards.TSIC2552, "10762"), (Standards.ISIC3, "1549")),
        ((Standards.TSIC2552, "10769"), (Standards.ISIC3, "1549")),
        ((Standards.TSIC2552, "10771"), (Standards.ISIC3, "1549")),
        ((Standards.TSIC2552, "10772"), (Standards.ISIC3, "1549")),
        ((Standards.TSIC2552, "10773"), (Standards.ISIC3, "1549")),
        ((Standards.TSIC2552, "10774"), (Standards.ISIC3, "1549")),
        ((Standards.TSIC2552, "10775"), (Standards.ISIC3, "2429")),
        ((Standards.TSIC2552, "10779"), (Standards.ISIC3, "1549")),
        ((Standards.TSIC2552, "10791"), (Standards.ISIC3, "1549")),
        ((Standards.TSIC2552, "10792"), (Standards.ISIC3, "1549")),
        ((Standards.TSIC2552, "10793"), (Standards.ISIC3, "1549")),
        ((Standards.TSIC2552, "10794"), (Standards.ISIC3, "1549")),
        ((Standards.TSIC2552, "10795"), (Standards.ISIC3, "1549")),
        ((Standards.TSIC2552, "10796"), (Standards.ISIC3, "1549")),
        ((Standards.TSIC2552, "10799"), (Standards.ISIC3, "1549")),
        ((Standards.TSIC2552, "10801"), (Standards.ISIC3, "1533")),
        ((Standards.TSIC2552, "10802"), (Standards.ISIC3, "1533")),
        ((Standards.TSIC2552, "11011"), (Standards.ISIC3, "1551")),
        ((Standards.TSIC2552, "11012"), (Standards.ISIC3, "1551")),
        ((Standards.TSIC2552, "11021"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "11021"), (Standards.ISIC3, "1552")),
        ((Standards.TSIC2552, "11022"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "11022"), (Standards.ISIC3, "1552")),
        ((Standards.TSIC2552, "11029"), (Standards.ISIC3, "0113")),
        ((Standards.TSIC2552, "11029"), (Standards.ISIC3, "1552")),
        ((Standards.TSIC2552, "11030"), (Standards.ISIC3, "1553")),
        ((Standards.TSIC2552, "11041"), (Standards.ISIC3, "1554")),
        ((Standards.TSIC2552, "11042"), (Standards.ISIC3, "1554")),
        ((Standards.TSIC2552, "11043"), (Standards.ISIC3, "1554")),
        ((Standards.TSIC2552, "11044"), (Standards.ISIC3, "1554")),
        ((Standards.TSIC2552, "11049"), (Standards.ISIC3, "1554")),
        ((Standards.TSIC2552, "12001"), (Standards.ISIC3, "1600")),
        ((Standards.TSIC2552, "12002"), (Standards.ISIC3, "1600")),
        ((Standards.TSIC2552, "12009"), (Standards.ISIC3, "1600")),
        ((Standards.TSIC2552, "13111"), (Standards.ISIC3, "1711")),
        ((Standards.TSIC2552, "13112"), (Standards.ISIC3, "1711")),
        ((Standards.TSIC2552, "13113"), (Standards.ISIC3, "1711")),
        ((Standards.TSIC2552, "13121"), (Standards.ISIC3, "1711")),
        ((Standards.TSIC2552, "13122"), (Standards.ISIC3, "1711")),
        ((Standards.TSIC2552, "13129"), (Standards.ISIC3, "1711")),
        ((Standards.TSIC2552, "13129"), (Standards.ISIC3, "2699")),
        ((Standards.TSIC2552, "13131"), (Standards.ISIC3, "1712")),
        ((Standards.TSIC2552, "13132"), (Standards.ISIC3, "1712")),
        ((Standards.TSIC2552, "13139"), (Standards.ISIC3, "1712")),
        ((Standards.TSIC2552, "13139"), (Standards.ISIC3, "1729")),
        ((Standards.TSIC2552, "13139"), (Standards.ISIC3, "1810")),
        ((Standards.TSIC2552, "13910"), (Standards.ISIC3, "1730")),
        ((Standards.TSIC2552, "13921"), (Standards.ISIC3, "1721")),
        ((Standards.TSIC2552, "13922"), (Standards.ISIC3, "1721")),
        ((Standards.TSIC2552, "13929"), (Standards.ISIC3, "1721")),
        ((Standards.TSIC2552, "13929"), (Standards.ISIC3, "3430")),
        ((Standards.TSIC2552, "13930"), (Standards.ISIC3, "1722")),
        ((Standards.TSIC2552, "13940"), (Standards.ISIC3, "1723")),
        ((Standards.TSIC2552, "13991"), (Standards.ISIC3, "1729")),
        ((Standards.TSIC2552, "13992"), (Standards.ISIC3, "1729")),
        ((Standards.TSIC2552, "13999"), (Standards.ISIC3, "1729")),
        ((Standards.TSIC2552, "13999"), (Standards.ISIC3, "3699")),
        ((Standards.TSIC2552, "14111"), (Standards.ISIC3, "1810")),
        ((Standards.TSIC2552, "14112"), (Standards.ISIC3, "1810")),
        ((Standards.TSIC2552, "14113"), (Standards.ISIC3, "1810")),
        ((Standards.TSIC2552, "14114"), (Standards.ISIC3, "1810")),
        ((Standards.TSIC2552, "14115"), (Standards.ISIC3, "1810")),
        ((Standards.TSIC2552, "14116"), (Standards.ISIC3, "1810")),
        ((Standards.TSIC2552, "14120"), (Standards.ISIC3, "1810")),
        ((Standards.TSIC2552, "14131"), (Standards.ISIC3, "1810")),
        ((Standards.TSIC2552, "14139"), (Standards.ISIC3, "1810")),
        ((Standards.TSIC2552, "14200"), (Standards.ISIC3, "1820")),
        ((Standards.TSIC2552, "14301"), (Standards.ISIC3, "1730")),
        ((Standards.TSIC2552, "14302"), (Standards.ISIC3, "1730")),
        ((Standards.TSIC2552, "15110"), (Standards.ISIC3, "1820")),
        ((Standards.TSIC2552, "15110"), (Standards.ISIC3, "1911")),
        ((Standards.TSIC2552, "15121"), (Standards.ISIC3, "1912")),
        ((Standards.TSIC2552, "15122"), (Standards.ISIC3, "1912")),
        ((Standards.TSIC2552, "15122"), (Standards.ISIC3, "3699")),
        ((Standards.TSIC2552, "15129"), (Standards.ISIC3, "1912")),
        ((Standards.TSIC2552, "15129"), (Standards.ISIC3, "1920")),
        ((Standards.TSIC2552, "15201"), (Standards.ISIC3, "1920")),
        ((Standards.TSIC2552, "15202"), (Standards.ISIC3, "1920")),
        ((Standards.TSIC2552, "15203"), (Standards.ISIC3, "1920")),
        ((Standards.TSIC2552, "15204"), (Standards.ISIC3, "1920")),
        ((Standards.TSIC2552, "15209"), (Standards.ISIC3, "1920")),
        ((Standards.TSIC2552, "16101"), (Standards.ISIC3, "2010")),
        ((Standards.TSIC2552, "16102"), (Standards.ISIC3, "2010")),
        ((Standards.TSIC2552, "16210"), (Standards.ISIC3, "2021")),
        ((Standards.TSIC2552, "16220"), (Standards.ISIC3, "2022")),
        ((Standards.TSIC2552, "16230"), (Standards.ISIC3, "2023")),
        ((Standards.TSIC2552, "16291"), (Standards.ISIC3, "2029")),
        ((Standards.TSIC2552, "16291"), (Standards.ISIC3, "3699")),
        ((Standards.TSIC2552, "16292"), (Standards.ISIC3, "2029")),
        ((Standards.TSIC2552, "16299"), (Standards.ISIC3, "1920")),
        ((Standards.TSIC2552, "16299"), (Standards.ISIC3, "2029")),
        ((Standards.TSIC2552, "16299"), (Standards.ISIC3, "3699")),
        ((Standards.TSIC2552, "17011"), (Standards.ISIC3, "2101")),
        ((Standards.TSIC2552, "17012"), (Standards.ISIC3, "2101")),
        ((Standards.TSIC2552, "17020"), (Standards.ISIC3, "2102")),
        ((Standards.TSIC2552, "17091"), (Standards.ISIC3, "1729")),
        ((Standards.TSIC2552, "17091"), (Standards.ISIC3, "2109")),
        ((Standards.TSIC2552, "17092"), (Standards.ISIC3, "2109")),
        ((Standards.TSIC2552, "17092"), (Standards.ISIC3, "2221")),
        ((Standards.TSIC2552, "17099"), (Standards.ISIC3, "2109")),
        ((Standards.TSIC2552, "17099"), (Standards.ISIC3, "3699")),
        ((Standards.TSIC2552, "18111"), (Standards.ISIC3, "2221")),
        ((Standards.TSIC2552, "18112"), (Standards.ISIC3, "2109")),
        ((Standards.TSIC2552, "18119"), (Standards.ISIC3, "2221")),
        ((Standards.TSIC2552, "18119"), (Standards.ISIC3, "2892")),
        ((Standards.TSIC2552, "18121"), (Standards.ISIC3, "2222")),
        ((Standards.TSIC2552, "18122"), (Standards.ISIC3, "2222")),
        ((Standards.TSIC2552, "18200"), (Standards.ISIC3, "2230")),
        ((Standards.TSIC2552, "19100"), (Standards.ISIC3, "2310")),
        ((Standards.TSIC2552, "19100"), (Standards.ISIC3, "2411")),
        ((Standards.TSIC2552, "19201"), (Standards.ISIC3, "2320")),
        ((Standards.TSIC2552, "19202"), (Standards.ISIC3, "2320")),
        ((Standards.TSIC2552, "19209"), (Standards.ISIC3, "1010")),
        ((Standards.TSIC2552, "19209"), (Standards.ISIC3, "1020")),
        ((Standards.TSIC2552, "19209"), (Standards.ISIC3, "2320")),
        ((Standards.TSIC2552, "20111"), (Standards.ISIC3, "2411")),
        ((Standards.TSIC2552, "20112"), (Standards.ISIC3, "2411")),
        ((Standards.TSIC2552, "20113"), (Standards.ISIC3, "2330")),
        ((Standards.TSIC2552, "20113"), (Standards.ISIC3, "2411")),
        ((Standards.TSIC2552, "20113"), (Standards.ISIC3, "2429")),
        ((Standards.TSIC2552, "20114"), (Standards.ISIC3, "1551")),
        ((Standards.TSIC2552, "20115"), (Standards.ISIC3, "2411")),
        ((Standards.TSIC2552, "20121"), (Standards.ISIC3, "2412")),
        ((Standards.TSIC2552, "20122"), (Standards.ISIC3, "2412")),
        ((Standards.TSIC2552, "20131"), (Standards.ISIC3, "2413")),
        ((Standards.TSIC2552, "20132"), (Standards.ISIC3, "2413")),
        ((Standards.TSIC2552, "20210"), (Standards.ISIC3, "2421")),
        ((Standards.TSIC2552, "20221"), (Standards.ISIC3, "2422")),
        ((Standards.TSIC2552, "20222"), (Standards.ISIC3, "2422")),
        ((Standards.TSIC2552, "20231"), (Standards.ISIC3, "2424")),
        ((Standards.TSIC2552, "20232"), (Standards.ISIC3, "2424")),
        ((Standards.TSIC2552, "20291"), (Standards.ISIC3, "2429")),
        ((Standards.TSIC2552, "20291"), (Standards.ISIC3, "3699")),
        ((Standards.TSIC2552, "20292"), (Standards.ISIC3, "2429")),
        ((Standards.TSIC2552, "20293"), (Standards.ISIC3, "2429")),
        ((Standards.TSIC2552, "20294"), (Standards.ISIC3, "2429")),
        ((Standards.TSIC2552, "20299"), (Standards.ISIC3, "2429")),
        ((Standards.TSIC2552, "20300"), (Standards.ISIC3, "2430")),
        ((Standards.TSIC2552, "21001"), (Standards.ISIC3, "2330")),
        ((Standards.TSIC2552, "21001"), (Standards.ISIC3, "2423")),
        ((Standards.TSIC2552, "21002"), (Standards.ISIC3, "2423")),
        ((Standards.TSIC2552, "22111"), (Standards.ISIC3, "2511")),
        ((Standards.TSIC2552, "22112"), (Standards.ISIC3, "2511")),
        ((Standards.TSIC2552, "22191"), (Standards.ISIC3, "2519")),
        ((Standards.TSIC2552, "22192"), (Standards.ISIC3, "2519")),
        ((Standards.TSIC2552, "22193"), (Standards.ISIC3, "2519")),
        ((Standards.TSIC2552, "22199"), (Standards.ISIC3, "1920")),
        ((Standards.TSIC2552, "22199"), (Standards.ISIC3, "2519")),
        ((Standards.TSIC2552, "22199"), (Standards.ISIC3, "3610")),
        ((Standards.TSIC2552, "22199"), (Standards.ISIC3, "3699")),
        ((Standards.TSIC2552, "22210"), (Standards.ISIC3, "2519")),
        ((Standards.TSIC2552, "22210"), (Standards.ISIC3, "2520")),
        ((Standards.TSIC2552, "22220"), (Standards.ISIC3, "2520")),
        ((Standards.TSIC2552, "22230"), (Standards.ISIC3, "2520")),
        ((Standards.TSIC2552, "22291"), (Standards.ISIC3, "2520")),
        ((Standards.TSIC2552, "22292"), (Standards.ISIC3, "2520")),
        ((Standards.TSIC2552, "22299"), (Standards.ISIC3, "1920")),
        ((Standards.TSIC2552, "22299"), (Standards.ISIC3, "2109")),
        ((Standards.TSIC2552, "22299"), (Standards.ISIC3, "2520")),
        ((Standards.TSIC2552, "22299"), (Standards.ISIC3, "3610")),
        ((Standards.TSIC2552, "22299"), (Standards.ISIC3, "3699")),
        ((Standards.TSIC2552, "23101"), (Standards.ISIC3, "2610")),
        ((Standards.TSIC2552, "23102"), (Standards.ISIC3, "2610")),
        ((Standards.TSIC2552, "23103"), (Standards.ISIC3, "2610")),
        ((Standards.TSIC2552, "23109"), (Standards.ISIC3, "2610")),
        ((Standards.TSIC2552, "23910"), (Standards.ISIC3, "2692")),
        ((Standards.TSIC2552, "23921"), (Standards.ISIC3, "2693")),
        ((Standards.TSIC2552, "23922"), (Standards.ISIC3, "2693")),
        ((Standards.TSIC2552, "23923"), (Standards.ISIC3, "2691")),
        ((Standards.TSIC2552, "23929"), (Standards.ISIC3, "2693")),
        ((Standards.TSIC2552, "23931"), (Standards.ISIC3, "2691")),
        ((Standards.TSIC2552, "23932"), (Standards.ISIC3, "2691")),
        ((Standards.TSIC2552, "23933"), (Standards.ISIC3, "2691")),
        ((Standards.TSIC2552, "23939"), (Standards.ISIC3, "2691")),
        ((Standards.TSIC2552, "23941"), (Standards.ISIC3, "2694")),
        ((Standards.TSIC2552, "23942"), (Standards.ISIC3, "2694")),
        ((Standards.TSIC2552, "23951"), (Standards.ISIC3, "2695")),
        ((Standards.TSIC2552, "23952"), (Standards.ISIC3, "2695")),
        ((Standards.TSIC2552, "23953"), (Standards.ISIC3, "2695")),
        ((Standards.TSIC2552, "23954"), (Standards.ISIC3, "2695")),
        ((Standards.TSIC2552, "23959"), (Standards.ISIC3, "2695")),
        ((Standards.TSIC2552, "23961"), (Standards.ISIC3, "2696")),
        ((Standards.TSIC2552, "23969"), (Standards.ISIC3, "2696")),
        ((Standards.TSIC2552, "23991"), (Standards.ISIC3, "2699")),
        ((Standards.TSIC2552, "23992"), (Standards.ISIC3, "2699")),
        ((Standards.TSIC2552, "23999"), (Standards.ISIC3, "2699")),
        ((Standards.TSIC2552, "24101"), (Standards.ISIC3, "2710")),
        ((Standards.TSIC2552, "24102"), (Standards.ISIC3, "2710")),
        ((Standards.TSIC2552, "24103"), (Standards.ISIC3, "2710")),
        ((Standards.TSIC2552, "24109"), (Standards.ISIC3, "2710")),
        ((Standards.TSIC2552, "24201"), (Standards.ISIC3, "2720")),
        ((Standards.TSIC2552, "24202"), (Standards.ISIC3, "2720")),
        ((Standards.TSIC2552, "24203"), (Standards.ISIC3, "2720")),
        ((Standards.TSIC2552, "24204"), (Standards.ISIC3, "2720")),
        ((Standards.TSIC2552, "24209"), (Standards.ISIC3, "2330")),
        ((Standards.TSIC2552, "24209"), (Standards.ISIC3, "2720")),
        ((Standards.TSIC2552, "24311"), (Standards.ISIC3, "2710")),
        ((Standards.TSIC2552, "24311"), (Standards.ISIC3, "2731")),
        ((Standards.TSIC2552, "24312"), (Standards.ISIC3, "2710")),
        ((Standards.TSIC2552, "24312"), (Standards.ISIC3, "2731")),
        ((Standards.TSIC2552, "24320"), (Standards.ISIC3, "2732")),
        ((Standards.TSIC2552, "25111"), (Standards.ISIC3, "2811")),
        ((Standards.TSIC2552, "25112"), (Standards.ISIC3, "2811")),
        ((Standards.TSIC2552, "25113"), (Standards.ISIC3, "2811")),
        ((Standards.TSIC2552, "25119"), (Standards.ISIC3, "2811")),
        ((Standards.TSIC2552, "25121"), (Standards.ISIC3, "2812")),
        ((Standards.TSIC2552, "25122"), (Standards.ISIC3, "2812")),
        ((Standards.TSIC2552, "25129"), (Standards.ISIC3, "2812")),
        ((Standards.TSIC2552, "25130"), (Standards.ISIC3, "2813")),
        ((Standards.TSIC2552, "25201"), (Standards.ISIC3, "2927")),
        ((Standards.TSIC2552, "25209"), (Standards.ISIC3, "2927")),
        ((Standards.TSIC2552, "25910"), (Standards.ISIC3, "2891")),
        ((Standards.TSIC2552, "25921"), (Standards.ISIC3, "2892")),
        ((Standards.TSIC2552, "25922"), (Standards.ISIC3, "2892")),
        ((Standards.TSIC2552, "25931"), (Standards.ISIC3, "2893")),
        ((Standards.TSIC2552, "25932"), (Standards.ISIC3, "2893")),
        ((Standards.TSIC2552, "25939"), (Standards.ISIC3, "2893")),
        ((Standards.TSIC2552, "25939"), (Standards.ISIC3, "2929")),
        ((Standards.TSIC2552, "25941"), (Standards.ISIC3, "2899")),
        ((Standards.TSIC2552, "25949"), (Standards.ISIC3, "2899")),
        ((Standards.TSIC2552, "25951"), (Standards.ISIC3, "2899")),
        ((Standards.TSIC2552, "25952"), (Standards.ISIC3, "2899")),
        ((Standards.TSIC2552, "25991"), (Standards.ISIC3, "2899")),
        ((Standards.TSIC2552, "25992"), (Standards.ISIC3, "2899")),
        ((Standards.TSIC2552, "25993"), (Standards.ISIC3, "2899")),
        ((Standards.TSIC2552, "25999"), (Standards.ISIC3, "2899")),
        ((Standards.TSIC2552, "25999"), (Standards.ISIC3, "3190")),
        ((Standards.TSIC2552, "25999"), (Standards.ISIC3, "3699")),
        ((Standards.TSIC2552, "26101"), (Standards.ISIC3, "3210")),
        ((Standards.TSIC2552, "26102"), (Standards.ISIC3, "3210")),
        ((Standards.TSIC2552, "26103"), (Standards.ISIC3, "3210")),
        ((Standards.TSIC2552, "26104"), (Standards.ISIC3, "2429")),
        ((Standards.TSIC2552, "26104"), (Standards.ISIC3, "3210")),
        ((Standards.TSIC2552, "26109"), (Standards.ISIC3, "2520")),
        ((Standards.TSIC2552, "26109"), (Standards.ISIC3, "3000")),
        ((Standards.TSIC2552, "26109"), (Standards.ISIC3, "3110")),
        ((Standards.TSIC2552, "26109"), (Standards.ISIC3, "3120")),
        ((Standards.TSIC2552, "26109"), (Standards.ISIC3, "3130")),
        ((Standards.TSIC2552, "26109"), (Standards.ISIC3, "3210")),
        ((Standards.TSIC2552, "26109"), (Standards.ISIC3, "3230")),
        ((Standards.TSIC2552, "26201"), (Standards.ISIC3, "3000")),
        ((Standards.TSIC2552, "26202"), (Standards.ISIC3, "3000")),
        ((Standards.TSIC2552, "26203"), (Standards.ISIC3, "3000")),
        ((Standards.TSIC2552, "26209"), (Standards.ISIC3, "3000")),
        ((Standards.TSIC2552, "26301"), (Standards.ISIC3, "3220")),
        ((Standards.TSIC2552, "26302"), (Standards.ISIC3, "3220")),
        ((Standards.TSIC2552, "26302"), (Standards.ISIC3, "3230")),
        ((Standards.TSIC2552, "26303"), (Standards.ISIC3, "3220")),
        ((Standards.TSIC2552, "26309"), (Standards.ISIC3, "3190")),
        ((Standards.TSIC2552, "26309"), (Standards.ISIC3, "3220")),
        ((Standards.TSIC2552, "26309"), (Standards.ISIC3, "3230")),
        ((Standards.TSIC2552, "26401"), (Standards.ISIC3, "3230")),
        ((Standards.TSIC2552, "26402"), (Standards.ISIC3, "3230")),
        ((Standards.TSIC2552, "26403"), (Standards.ISIC3, "3230")),
        ((Standards.TSIC2552, "26409"), (Standards.ISIC3, "3230")),
        ((Standards.TSIC2552, "26409"), (Standards.ISIC3, "3694")),
        ((Standards.TSIC2552, "26511"), (Standards.ISIC3, "3190")),
        ((Standards.TSIC2552, "26511"), (Standards.ISIC3, "3220")),
        ((Standards.TSIC2552, "26511"), (Standards.ISIC3, "3312")),
        ((Standards.TSIC2552, "26512"), (Standards.ISIC3, "3313")),
        ((Standards.TSIC2552, "26521"), (Standards.ISIC3, "3330")),
        ((Standards.TSIC2552, "26529"), (Standards.ISIC3, "3330")),
        ((Standards.TSIC2552, "26600"), (Standards.ISIC3, "3311")),
        ((Standards.TSIC2552, "26701"), (Standards.ISIC3, "3320")),
        ((Standards.TSIC2552, "26702"), (Standards.ISIC3, "3312")),
        ((Standards.TSIC2552, "26702"), (Standards.ISIC3, "3320")),
        ((Standards.TSIC2552, "26703"), (Standards.ISIC3, "3230")),
        ((Standards.TSIC2552, "26703"), (Standards.ISIC3, "3320")),
        ((Standards.TSIC2552, "26800"), (Standards.ISIC3, "2429")),
        ((Standards.TSIC2552, "27101"), (Standards.ISIC3, "3110")),
        ((Standards.TSIC2552, "27102"), (Standards.ISIC3, "3110")),
        ((Standards.TSIC2552, "27103"), (Standards.ISIC3, "3120")),
        ((Standards.TSIC2552, "27200"), (Standards.ISIC3, "3140")),
        ((Standards.TSIC2552, "27310"), (Standards.ISIC3, "3130")),
        ((Standards.TSIC2552, "27310"), (Standards.ISIC3, "3320")),
        ((Standards.TSIC2552, "27320"), (Standards.ISIC3, "3130")),
        ((Standards.TSIC2552, "27330"), (Standards.ISIC3, "2520")),
        ((Standards.TSIC2552, "27330"), (Standards.ISIC3, "3120")),
        ((Standards.TSIC2552, "27330"), (Standards.ISIC3, "3190")),
        ((Standards.TSIC2552, "27401"), (Standards.ISIC3, "3150")),
        ((Standards.TSIC2552, "27409"), (Standards.ISIC3, "3150")),
        ((Standards.TSIC2552, "27409"), (Standards.ISIC3, "3190")),
        ((Standards.TSIC2552, "27501"), (Standards.ISIC3, "2930")),
        ((Standards.TSIC2552, "27502"), (Standards.ISIC3, "2930")),
        ((Standards.TSIC2552, "27503"), (Standards.ISIC3, "2930")),
        ((Standards.TSIC2552, "27901"), (Standards.ISIC3, "3190")),
        ((Standards.TSIC2552, "27902"), (Standards.ISIC3, "3190")),
        ((Standards.TSIC2552, "27902"), (Standards.ISIC3, "3150")),
        ((Standards.TSIC2552, "27909"), (Standards.ISIC3, "2922")),
        ((Standards.TSIC2552, "27909"), (Standards.ISIC3, "2929")),
        ((Standards.TSIC2552, "27909"), (Standards.ISIC3, "3110")),
        ((Standards.TSIC2552, "27909"), (Standards.ISIC3, "3120")),
        ((Standards.TSIC2552, "27909"), (Standards.ISIC3, "3130")),
        ((Standards.TSIC2552, "27909"), (Standards.ISIC3, "3190")),
        ((Standards.TSIC2552, "27909"), (Standards.ISIC3, "3210")),
        ((Standards.TSIC2552, "28110"), (Standards.ISIC3, "2911")),
        ((Standards.TSIC2552, "28110"), (Standards.ISIC3, "2912")),
        ((Standards.TSIC2552, "28110"), (Standards.ISIC3, "3110")),
        ((Standards.TSIC2552, "28110"), (Standards.ISIC3, "3430")),
        ((Standards.TSIC2552, "28110"), (Standards.ISIC3, "3530")),
        ((Standards.TSIC2552, "28110"), (Standards.ISIC3, "3591")),
        ((Standards.TSIC2552, "28120"), (Standards.ISIC3, "2519")),
        ((Standards.TSIC2552, "28120"), (Standards.ISIC3, "2912")),
        ((Standards.TSIC2552, "28120"), (Standards.ISIC3, "2913")),
        ((Standards.TSIC2552, "28131"), (Standards.ISIC3, "2912")),
        ((Standards.TSIC2552, "28132"), (Standards.ISIC3, "2912")),
        ((Standards.TSIC2552, "28140"), (Standards.ISIC3, "2913")),
        ((Standards.TSIC2552, "28150"), (Standards.ISIC3, "2914")),
        ((Standards.TSIC2552, "28150"), (Standards.ISIC3, "2930")),
        ((Standards.TSIC2552, "28160"), (Standards.ISIC3, "2915")),
        ((Standards.TSIC2552, "28160"), (Standards.ISIC3, "3599")),
        ((Standards.TSIC2552, "28170"), (Standards.ISIC3, "2429")),
        ((Standards.TSIC2552, "28170"), (Standards.ISIC3, "2899")),
        ((Standards.TSIC2552, "28170"), (Standards.ISIC3, "3000")),
        ((Standards.TSIC2552, "28170"), (Standards.ISIC3, "3230")),
        ((Standards.TSIC2552, "28170"), (Standards.ISIC3, "3610")),
        ((Standards.TSIC2552, "28180"), (Standards.ISIC3, "2922")),
        ((Standards.TSIC2552, "28191"), (Standards.ISIC3, "2919")),
        ((Standards.TSIC2552, "28191"), (Standards.ISIC3, "2930")),
        ((Standards.TSIC2552, "28199"), (Standards.ISIC3, "2919")),
        ((Standards.TSIC2552, "28199"), (Standards.ISIC3, "2922")),
        ((Standards.TSIC2552, "28199"), (Standards.ISIC3, "3312")),
        ((Standards.TSIC2552, "28211"), (Standards.ISIC3, "2921")),
        ((Standards.TSIC2552, "28219"), (Standards.ISIC3, "2921")),
        ((Standards.TSIC2552, "28221"), (Standards.ISIC3, "2922")),
        ((Standards.TSIC2552, "28229"), (Standards.ISIC3, "2922")),
        ((Standards.TSIC2552, "28229"), (Standards.ISIC3, "3190")),
        ((Standards.TSIC2552, "28230"), (Standards.ISIC3, "2923")),
        ((Standards.TSIC2552, "28240"), (Standards.ISIC3, "2924")),
        ((Standards.TSIC2552, "28250"), (Standards.ISIC3, "2925")),
        ((Standards.TSIC2552, "28261"), (Standards.ISIC3, "2926")),
        ((Standards.TSIC2552, "28261"), (Standards.ISIC3, "2929")),
        ((Standards.TSIC2552, "28269"), (Standards.ISIC3, "2926")),
        ((Standards.TSIC2552, "28291"), (Standards.ISIC3, "2929")),
        ((Standards.TSIC2552, "28292"), (Standards.ISIC3, "2929")),
        ((Standards.TSIC2552, "28299"), (Standards.ISIC3, "2929")),
        ((Standards.TSIC2552, "28299"), (Standards.ISIC3, "3312")),
        ((Standards.TSIC2552, "28299"), (Standards.ISIC3, "3320")),
        ((Standards.TSIC2552, "28299"), (Standards.ISIC3, "3530")),
        ((Standards.TSIC2552, "28299"), (Standards.ISIC3, "3694")),
        ((Standards.TSIC2552, "28299"), (Standards.ISIC3, "3699")),
        ((Standards.TSIC2552, "29101"), (Standards.ISIC3, "3410")),
        ((Standards.TSIC2552, "29102"), (Standards.ISIC3, "3410")),
        ((Standards.TSIC2552, "29103"), (Standards.ISIC3, "3410")),
        ((Standards.TSIC2552, "29104"), (Standards.ISIC3, "3410")),
        ((Standards.TSIC2552, "29109"), (Standards.ISIC3, "3410")),
        ((Standards.TSIC2552, "29201"), (Standards.ISIC3, "3420")),
        ((Standards.TSIC2552, "29202"), (Standards.ISIC3, "3420")),
        ((Standards.TSIC2552, "29203"), (Standards.ISIC3, "3420")),
        ((Standards.TSIC2552, "29301"), (Standards.ISIC3, "3610")),
        ((Standards.TSIC2552, "29302"), (Standards.ISIC3, "3190")),
        ((Standards.TSIC2552, "29309"), (Standards.ISIC3, "3430")),
        ((Standards.TSIC2552, "30110"), (Standards.ISIC3, "3511")),
        ((Standards.TSIC2552, "30110"), (Standards.ISIC3, "3610")),
        ((Standards.TSIC2552, "30120"), (Standards.ISIC3, "3512")),
        ((Standards.TSIC2552, "30200"), (Standards.ISIC3, "3190")),
        ((Standards.TSIC2552, "30200"), (Standards.ISIC3, "3520")),
        ((Standards.TSIC2552, "30200"), (Standards.ISIC3, "3610")),
        ((Standards.TSIC2552, "30300"), (Standards.ISIC3, "2927")),
        ((Standards.TSIC2552, "30300"), (Standards.ISIC3, "3530")),
        ((Standards.TSIC2552, "30300"), (Standards.ISIC3, "3610")),
        ((Standards.TSIC2552, "30911"), (Standards.ISIC3, "3591")),
        ((Standards.TSIC2552, "30912"), (Standards.ISIC3, "3591")),
        ((Standards.TSIC2552, "30921"), (Standards.ISIC3, "3592")),
        ((Standards.TSIC2552, "30922"), (Standards.ISIC3, "3592")),
        ((Standards.TSIC2552, "30922"), (Standards.ISIC3, "3699")),
        ((Standards.TSIC2552, "30990"), (Standards.ISIC3, "3599")),
        ((Standards.TSIC2552, "31001"), (Standards.ISIC3, "3610")),
        ((Standards.TSIC2552, "31002"), (Standards.ISIC3, "3610")),
        ((Standards.TSIC2552, "31003"), (Standards.ISIC3, "3610")),
        ((Standards.TSIC2552, "31009"), (Standards.ISIC3, "3599")),
        ((Standards.TSIC2552, "31009"), (Standards.ISIC3, "3610")),
        ((Standards.TSIC2552, "32111"), (Standards.ISIC3, "3330")),
        ((Standards.TSIC2552, "32111"), (Standards.ISIC3, "3691")),
        ((Standards.TSIC2552, "32112"), (Standards.ISIC3, "3691")),
        ((Standards.TSIC2552, "32113"), (Standards.ISIC3, "3691")),
        ((Standards.TSIC2552, "32120"), (Standards.ISIC3, "3330")),
        ((Standards.TSIC2552, "32120"), (Standards.ISIC3, "3691")),
        ((Standards.TSIC2552, "32201"), (Standards.ISIC3, "3692")),
        ((Standards.TSIC2552, "32209"), (Standards.ISIC3, "3692")),
        ((Standards.TSIC2552, "32301"), (Standards.ISIC3, "3693")),
        ((Standards.TSIC2552, "32302"), (Standards.ISIC3, "3693")),
        ((Standards.TSIC2552, "32303"), (Standards.ISIC3, "3693")),
        ((Standards.TSIC2552, "32309"), (Standards.ISIC3, "1920")),
        ((Standards.TSIC2552, "32309"), (Standards.ISIC3, "3693")),
        ((Standards.TSIC2552, "32401"), (Standards.ISIC3, "3694")),
        ((Standards.TSIC2552, "32402"), (Standards.ISIC3, "3694")),
        ((Standards.TSIC2552, "32409"), (Standards.ISIC3, "3694")),
        ((Standards.TSIC2552, "32501"), (Standards.ISIC3, "1721")),
        ((Standards.TSIC2552, "32501"), (Standards.ISIC3, "2423")),
        ((Standards.TSIC2552, "32501"), (Standards.ISIC3, "2919")),
        ((Standards.TSIC2552, "32501"), (Standards.ISIC3, "3311")),
        ((Standards.TSIC2552, "32501"), (Standards.ISIC3, "3312")),
        ((Standards.TSIC2552, "32501"), (Standards.ISIC3, "3320")),
        ((Standards.TSIC2552, "32502"), (Standards.ISIC3, "2423")),
        ((Standards.TSIC2552, "32502"), (Standards.ISIC3, "3311")),
        ((Standards.TSIC2552, "32901"), (Standards.ISIC3, "3699")),
        ((Standards.TSIC2552, "32902"), (Standards.ISIC3, "3699")),
        ((Standards.TSIC2552, "32903"), (Standards.ISIC3, "1810")),
        ((Standards.TSIC2552, "32903"), (Standards.ISIC3, "1912")),
        ((Standards.TSIC2552, "32903"), (Standards.ISIC3, "2029")),
        ((Standards.TSIC2552, "32903"), (Standards.ISIC3, "2519")),
        ((Standards.TSIC2552, "32903"), (Standards.ISIC3, "2520")),
        ((Standards.TSIC2552, "32903"), (Standards.ISIC3, "2699")),
        ((Standards.TSIC2552, "32903"), (Standards.ISIC3, "2899")),
        ((Standards.TSIC2552, "32903"), (Standards.ISIC3, "3311")),
        ((Standards.TSIC2552, "32903"), (Standards.ISIC3, "3693")),
        ((Standards.TSIC2552, "32904"), (Standards.ISIC3, "3699")),
        ((Standards.TSIC2552, "32909"), (Standards.ISIC3, "2211")),
        ((Standards.TSIC2552, "32909"), (Standards.ISIC3, "3699")),
        ((Standards.TSIC2552, "33110"), (Standards.ISIC3, "2811")),
        ((Standards.TSIC2552, "33110"), (Standards.ISIC3, "2812")),
        ((Standards.TSIC2552, "33110"), (Standards.ISIC3, "2813")),
        ((Standards.TSIC2552, "33110"), (Standards.ISIC3, "2892")),
        ((Standards.TSIC2552, "33110"), (Standards.ISIC3, "2893")),
        ((Standards.TSIC2552, "33110"), (Standards.ISIC3, "2899")),
        ((Standards.TSIC2552, "33110"), (Standards.ISIC3, "2927")),
        ((Standards.TSIC2552, "33110"), (Standards.ISIC3, "2929")),
        ((Standards.TSIC2552, "33110"), (Standards.ISIC3, "3420")),
        ((Standards.TSIC2552, "33121"), (Standards.ISIC3, "2911")),
        ((Standards.TSIC2552, "33121"), (Standards.ISIC3, "2912")),
        ((Standards.TSIC2552, "33121"), (Standards.ISIC3, "2913")),
        ((Standards.TSIC2552, "33121"), (Standards.ISIC3, "2914")),
        ((Standards.TSIC2552, "33121"), (Standards.ISIC3, "2915")),
        ((Standards.TSIC2552, "33121"), (Standards.ISIC3, "2919")),
        ((Standards.TSIC2552, "33121"), (Standards.ISIC3, "3110")),
        ((Standards.TSIC2552, "33121"), (Standards.ISIC3, "3230")),
        ((Standards.TSIC2552, "33121"), (Standards.ISIC3, "7250")),
        ((Standards.TSIC2552, "33122"), (Standards.ISIC3, "2921")),
        ((Standards.TSIC2552, "33122"), (Standards.ISIC3, "2922")),
        ((Standards.TSIC2552, "33122"), (Standards.ISIC3, "2923")),
        ((Standards.TSIC2552, "33122"), (Standards.ISIC3, "2924")),
        ((Standards.TSIC2552, "33122"), (Standards.ISIC3, "2925")),
        ((Standards.TSIC2552, "33122"), (Standards.ISIC3, "2926")),
        ((Standards.TSIC2552, "33122"), (Standards.ISIC3, "2929")),
        ((Standards.TSIC2552, "33122"), (Standards.ISIC3, "3599")),
        ((Standards.TSIC2552, "33122"), (Standards.ISIC3, "3694")),
        ((Standards.TSIC2552, "33122"), (Standards.ISIC3, "3699")),
        ((Standards.TSIC2552, "33131"), (Standards.ISIC3, "3190")),
        ((Standards.TSIC2552, "33131"), (Standards.ISIC3, "3220")),
        ((Standards.TSIC2552, "33131"), (Standards.ISIC3, "3312")),
        ((Standards.TSIC2552, "33131"), (Standards.ISIC3, "3313")),
        ((Standards.TSIC2552, "33132"), (Standards.ISIC3, "3311")),
        ((Standards.TSIC2552, "33133"), (Standards.ISIC3, "3230")),
        ((Standards.TSIC2552, "33133"), (Standards.ISIC3, "3320")),
        ((Standards.TSIC2552, "33133"), (Standards.ISIC3, "5260")),
        ((Standards.TSIC2552, "33141"), (Standards.ISIC3, "3110")),
        ((Standards.TSIC2552, "33141"), (Standards.ISIC3, "3120")),
        ((Standards.TSIC2552, "33142"), (Standards.ISIC3, "3140")),
        ((Standards.TSIC2552, "33149"), (Standards.ISIC3, "2520")),
        ((Standards.TSIC2552, "33149"), (Standards.ISIC3, "2922")),
        ((Standards.TSIC2552, "33149"), (Standards.ISIC3, "2929")),
        ((Standards.TSIC2552, "33149"), (Standards.ISIC3, "3130")),
        ((Standards.TSIC2552, "33149"), (Standards.ISIC3, "3150")),
        ((Standards.TSIC2552, "33149"), (Standards.ISIC3, "3190")),
        ((Standards.TSIC2552, "33149"), (Standards.ISIC3, "3210")),
        ((Standards.TSIC2552, "33151"), (Standards.ISIC3, "3511")),
        ((Standards.TSIC2552, "33151"), (Standards.ISIC3, "3512")),
        ((Standards.TSIC2552, "33152"), (Standards.ISIC3, "3530")),
        ((Standards.TSIC2552, "33159"), (Standards.ISIC3, "3520")),
        ((Standards.TSIC2552, "33159"), (Standards.ISIC3, "3599")),
        ((Standards.TSIC2552, "33159"), (Standards.ISIC3, "6303")),
        ((Standards.TSIC2552, "33190"), (Standards.ISIC3, "1721")),
        ((Standards.TSIC2552, "33190"), (Standards.ISIC3, "1723")),
        ((Standards.TSIC2552, "33190"), (Standards.ISIC3, "2023")),
        ((Standards.TSIC2552, "33190"), (Standards.ISIC3, "2029")),
        ((Standards.TSIC2552, "33190"), (Standards.ISIC3, "2519")),
        ((Standards.TSIC2552, "33190"), (Standards.ISIC3, "2520")),
        ((Standards.TSIC2552, "33190"), (Standards.ISIC3, "2610")),
        ((Standards.TSIC2552, "33190"), (Standards.ISIC3, "2699")),
        ((Standards.TSIC2552, "33190"), (Standards.ISIC3, "3311")),
        ((Standards.TSIC2552, "33190"), (Standards.ISIC3, "3312")),
        ((Standards.TSIC2552, "33190"), (Standards.ISIC3, "3330")),
        ((Standards.TSIC2552, "33190"), (Standards.ISIC3, "3692")),
        ((Standards.TSIC2552, "33190"), (Standards.ISIC3, "3694")),
        ((Standards.TSIC2552, "33200"), (Standards.ISIC3, "2813")),
        ((Standards.TSIC2552, "33200"), (Standards.ISIC3, "2911")),
        ((Standards.TSIC2552, "33200"), (Standards.ISIC3, "2912")),
        ((Standards.TSIC2552, "33200"), (Standards.ISIC3, "2914")),
        ((Standards.TSIC2552, "33200"), (Standards.ISIC3, "2915")),
        ((Standards.TSIC2552, "33200"), (Standards.ISIC3, "2919")),
        ((Standards.TSIC2552, "33200"), (Standards.ISIC3, "2921")),
        ((Standards.TSIC2552, "33200"), (Standards.ISIC3, "2922")),
        ((Standards.TSIC2552, "33200"), (Standards.ISIC3, "2923")),
        ((Standards.TSIC2552, "33200"), (Standards.ISIC3, "2924")),
        ((Standards.TSIC2552, "33200"), (Standards.ISIC3, "2925")),
        ((Standards.TSIC2552, "33200"), (Standards.ISIC3, "2929")),
        ((Standards.TSIC2552, "33200"), (Standards.ISIC3, "3000")),
        ((Standards.TSIC2552, "33200"), (Standards.ISIC3, "3110")),
        ((Standards.TSIC2552, "33200"), (Standards.ISIC3, "3220")),
        ((Standards.TSIC2552, "33200"), (Standards.ISIC3, "3311")),
        ((Standards.TSIC2552, "33200"), (Standards.ISIC3, "3313")),
        ((Standards.TSIC2552, "33200"), (Standards.ISIC3, "4540")),
        ((Standards.TSIC2552, "35101"), (Standards.ISIC3, "4010")),
        ((Standards.TSIC2552, "35102"), (Standards.ISIC3, "4010")),
        ((Standards.TSIC2552, "35201"), (Standards.ISIC3, "4020")),
        ((Standards.TSIC2552, "35202"), (Standards.ISIC3, "4020")),
        ((Standards.TSIC2552, "35301"), (Standards.ISIC3, "4030")),
        ((Standards.TSIC2552, "35302"), (Standards.ISIC3, "4030")),
        ((Standards.TSIC2552, "36001"), (Standards.ISIC3, "4100")),
        ((Standards.TSIC2552, "36002"), (Standards.ISIC3, "4100")),
        ((Standards.TSIC2552, "36003"), (Standards.ISIC3, "4100")),
        ((Standards.TSIC2552, "36009"), (Standards.ISIC3, "4100")),
        ((Standards.TSIC2552, "37000"), (Standards.ISIC3, "9000")),
        ((Standards.TSIC2552, "38110"), (Standards.ISIC3, "9000")),
        ((Standards.TSIC2552, "38120"), (Standards.ISIC3, "2330")),
        ((Standards.TSIC2552, "38120"), (Standards.ISIC3, "9000")),
        ((Standards.TSIC2552, "38211"), (Standards.ISIC3, "9000")),
        ((Standards.TSIC2552, "38212"), (Standards.ISIC3, "9000")),
        ((Standards.TSIC2552, "38213"), (Standards.ISIC3, "2412")),
        ((Standards.TSIC2552, "38213"), (Standards.ISIC3, "9000")),
        ((Standards.TSIC2552, "38219"), (Standards.ISIC3, "9000")),
        ((Standards.TSIC2552, "38221"), (Standards.ISIC3, "2330")),
        ((Standards.TSIC2552, "38222"), (Standards.ISIC3, "9000")),
        ((Standards.TSIC2552, "38300"), (Standards.ISIC3, "3710")),
        ((Standards.TSIC2552, "38300"), (Standards.ISIC3, "3720")),
        ((Standards.TSIC2552, "39000"), (Standards.ISIC3, "4510")),
        ((Standards.TSIC2552, "39000"), (Standards.ISIC3, "9000")),
        ((Standards.TSIC2552, "41001"), (Standards.ISIC3, "4520")),
        ((Standards.TSIC2552, "41002"), (Standards.ISIC3, "4520")),
        ((Standards.TSIC2552, "42101"), (Standards.ISIC3, "4520")),
        ((Standards.TSIC2552, "42102"), (Standards.ISIC3, "4520")),
        ((Standards.TSIC2552, "42201"), (Standards.ISIC3, "4520")),
        ((Standards.TSIC2552, "42202"), (Standards.ISIC3, "4520")),
        ((Standards.TSIC2552, "42901"), (Standards.ISIC3, "4520")),
        ((Standards.TSIC2552, "42909"), (Standards.ISIC3, "4520")),
        ((Standards.TSIC2552, "42909"), (Standards.ISIC3, "7010")),
        ((Standards.TSIC2552, "43110"), (Standards.ISIC3, "4510")),
        ((Standards.TSIC2552, "43120"), (Standards.ISIC3, "4510")),
        ((Standards.TSIC2552, "43120"), (Standards.ISIC3, "4550")),
        ((Standards.TSIC2552, "43210"), (Standards.ISIC3, "4530")),
        ((Standards.TSIC2552, "43221"), (Standards.ISIC3, "4530")),
        ((Standards.TSIC2552, "43222"), (Standards.ISIC3, "4530")),
        ((Standards.TSIC2552, "43223"), (Standards.ISIC3, "4530")),
        ((Standards.TSIC2552, "43291"), (Standards.ISIC3, "4540")),
        ((Standards.TSIC2552, "43299"), (Standards.ISIC3, "4540")),
        ((Standards.TSIC2552, "43301"), (Standards.ISIC3, "4530")),
        ((Standards.TSIC2552, "43301"), (Standards.ISIC3, "4540")),
        ((Standards.TSIC2552, "43302"), (Standards.ISIC3, "4540")),
        ((Standards.TSIC2552, "43303"), (Standards.ISIC3, "4540")),
        ((Standards.TSIC2552, "43309"), (Standards.ISIC3, "4540")),
        ((Standards.TSIC2552, "43901"), (Standards.ISIC3, "4520")),
        ((Standards.TSIC2552, "43909"), (Standards.ISIC3, "4520")),
        ((Standards.TSIC2552, "43909"), (Standards.ISIC3, "4530")),
        ((Standards.TSIC2552, "43909"), (Standards.ISIC3, "4540")),
        ((Standards.TSIC2552, "43909"), (Standards.ISIC3, "4550")),
        ((Standards.TSIC2552, "45101"), (Standards.ISIC3, "5010")),
        ((Standards.TSIC2552, "45102"), (Standards.ISIC3, "5010")),
        ((Standards.TSIC2552, "45103"), (Standards.ISIC3, "5010")),
        ((Standards.TSIC2552, "45104"), (Standards.ISIC3, "5010")),
        ((Standards.TSIC2552, "45201"), (Standards.ISIC3, "5020")),
        ((Standards.TSIC2552, "45202"), (Standards.ISIC3, "5020")),
        ((Standards.TSIC2552, "45203"), (Standards.ISIC3, "5020")),
        ((Standards.TSIC2552, "45301"), (Standards.ISIC3, "5030")),
        ((Standards.TSIC2552, "45302"), (Standards.ISIC3, "5030")),
        ((Standards.TSIC2552, "45303"), (Standards.ISIC3, "5030")),
        ((Standards.TSIC2552, "45401"), (Standards.ISIC3, "5040")),
        ((Standards.TSIC2552, "45402"), (Standards.ISIC3, "5040")),
        ((Standards.TSIC2552, "45403"), (Standards.ISIC3, "5040")),
        ((Standards.TSIC2552, "45404"), (Standards.ISIC3, "5040")),
        ((Standards.TSIC2552, "45405"), (Standards.ISIC3, "5040")),
        ((Standards.TSIC2552, "46101"), (Standards.ISIC3, "5110")),
        ((Standards.TSIC2552, "46102"), (Standards.ISIC3, "5110")),
        ((Standards.TSIC2552, "46103"), (Standards.ISIC3, "5110")),
        ((Standards.TSIC2552, "46104"), (Standards.ISIC3, "5110")),
        ((Standards.TSIC2552, "46105"), (Standards.ISIC3, "5110")),
        ((Standards.TSIC2552, "46106"), (Standards.ISIC3, "5110")),
        ((Standards.TSIC2552, "46107"), (Standards.ISIC3, "5110")),
        ((Standards.TSIC2552, "46108"), (Standards.ISIC3, "5110")),
        ((Standards.TSIC2552, "46109"), (Standards.ISIC3, "5110")),
        ((Standards.TSIC2552, "46201"), (Standards.ISIC3, "5121")),
        ((Standards.TSIC2552, "46202"), (Standards.ISIC3, "5121")),
        ((Standards.TSIC2552, "46203"), (Standards.ISIC3, "5121")),
        ((Standards.TSIC2552, "46204"), (Standards.ISIC3, "5121")),
        ((Standards.TSIC2552, "46205"), (Standards.ISIC3, "5121")),
        ((Standards.TSIC2552, "46206"), (Standards.ISIC3, "5121")),
        ((Standards.TSIC2552, "46209"), (Standards.ISIC3, "5121")),
        ((Standards.TSIC2552, "46311"), (Standards.ISIC3, "5122")),
        ((Standards.TSIC2552, "46312"), (Standards.ISIC3, "5122")),
        ((Standards.TSIC2552, "46313"), (Standards.ISIC3, "5122")),
        ((Standards.TSIC2552, "46314"), (Standards.ISIC3, "5122")),
        ((Standards.TSIC2552, "46315"), (Standards.ISIC3, "5122")),
        ((Standards.TSIC2552, "46316"), (Standards.ISIC3, "5122")),
        ((Standards.TSIC2552, "46317"), (Standards.ISIC3, "5122")),
        ((Standards.TSIC2552, "46318"), (Standards.ISIC3, "5122")),
        ((Standards.TSIC2552, "46319"), (Standards.ISIC3, "5122")),
        ((Standards.TSIC2552, "46321"), (Standards.ISIC3, "5122")),
        ((Standards.TSIC2552, "46322"), (Standards.ISIC3, "5122")),
        ((Standards.TSIC2552, "46323"), (Standards.ISIC3, "5122")),
        ((Standards.TSIC2552, "46411"), (Standards.ISIC3, "5131")),
        ((Standards.TSIC2552, "46412"), (Standards.ISIC3, "5131")),
        ((Standards.TSIC2552, "46413"), (Standards.ISIC3, "5131")),
        ((Standards.TSIC2552, "46414"), (Standards.ISIC3, "5131")),
        ((Standards.TSIC2552, "46415"), (Standards.ISIC3, "5131")),
        ((Standards.TSIC2552, "46421"), (Standards.ISIC3, "5139")),
        ((Standards.TSIC2552, "46422"), (Standards.ISIC3, "5139")),
        ((Standards.TSIC2552, "46431"), (Standards.ISIC3, "5139")),
        ((Standards.TSIC2552, "46432"), (Standards.ISIC3, "5139")),
        ((Standards.TSIC2552, "46433"), (Standards.ISIC3, "5139")),
        ((Standards.TSIC2552, "46434"), (Standards.ISIC3, "5139")),
        ((Standards.TSIC2552, "46439"), (Standards.ISIC3, "5139")),
        ((Standards.TSIC2552, "46441"), (Standards.ISIC3, "5139")),
        ((Standards.TSIC2552, "46442"), (Standards.ISIC3, "5139")),
        ((Standards.TSIC2552, "46443"), (Standards.ISIC3, "5139")),
        ((Standards.TSIC2552, "46491"), (Standards.ISIC3, "5139")),
        ((Standards.TSIC2552, "46492"), (Standards.ISIC3, "5139")),
        ((Standards.TSIC2552, "46493"), (Standards.ISIC3, "5139")),
        ((Standards.TSIC2552, "46494"), (Standards.ISIC3, "5139")),
        ((Standards.TSIC2552, "46495"), (Standards.ISIC3, "5139")),
        ((Standards.TSIC2552, "46499"), (Standards.ISIC3, "5139")),
        ((Standards.TSIC2552, "46510"), (Standards.ISIC3, "5150")),
        ((Standards.TSIC2552, "46521"), (Standards.ISIC3, "5150")),
        ((Standards.TSIC2552, "46522"), (Standards.ISIC3, "5150")),
        ((Standards.TSIC2552, "46530"), (Standards.ISIC3, "5150")),
        ((Standards.TSIC2552, "46591"), (Standards.ISIC3, "5150")),
        ((Standards.TSIC2552, "46592"), (Standards.ISIC3, "5150")),
        ((Standards.TSIC2552, "46593"), (Standards.ISIC3, "5150")),
        ((Standards.TSIC2552, "46594"), (Standards.ISIC3, "5150")),
        ((Standards.TSIC2552, "46599"), (Standards.ISIC3, "5150")),
        ((Standards.TSIC2552, "46611"), (Standards.ISIC3, "5141")),
        ((Standards.TSIC2552, "46612"), (Standards.ISIC3, "5141")),
        ((Standards.TSIC2552, "46613"), (Standards.ISIC3, "5141")),
        ((Standards.TSIC2552, "46614"), (Standards.ISIC3, "5141")),
        ((Standards.TSIC2552, "46621"), (Standards.ISIC3, "5142")),
        ((Standards.TSIC2552, "46622"), (Standards.ISIC3, "5142")),
        ((Standards.TSIC2552, "46631"), (Standards.ISIC3, "5143")),
        ((Standards.TSIC2552, "46632"), (Standards.ISIC3, "5143")),
        ((Standards.TSIC2552, "46633"), (Standards.ISIC3, "5143")),
        ((Standards.TSIC2552, "46634"), (Standards.ISIC3, "5143")),
        ((Standards.TSIC2552, "46639"), (Standards.ISIC3, "5139")),
        ((Standards.TSIC2552, "46639"), (Standards.ISIC3, "5143")),
        ((Standards.TSIC2552, "46691"), (Standards.ISIC3, "5149")),
        ((Standards.TSIC2552, "46692"), (Standards.ISIC3, "5149")),
        ((Standards.TSIC2552, "46693"), (Standards.ISIC3, "5149")),
        ((Standards.TSIC2552, "46694"), (Standards.ISIC3, "5149")),
        ((Standards.TSIC2552, "46695"), (Standards.ISIC3, "5149")),
        ((Standards.TSIC2552, "46699"), (Standards.ISIC3, "5149")),
        ((Standards.TSIC2552, "46900"), (Standards.ISIC3, "5190")),
        ((Standards.TSIC2552, "47111"), (Standards.ISIC3, "5211")),
        ((Standards.TSIC2552, "47112"), (Standards.ISIC3, "5211")),
        ((Standards.TSIC2552, "47113"), (Standards.ISIC3, "5211")),
        ((Standards.TSIC2552, "47114"), (Standards.ISIC3, "5211")),
        ((Standards.TSIC2552, "47190"), (Standards.ISIC3, "5219")),
        ((Standards.TSIC2552, "47211"), (Standards.ISIC3, "5220")),
        ((Standards.TSIC2552, "47212"), (Standards.ISIC3, "5220")),
        ((Standards.TSIC2552, "47213"), (Standards.ISIC3, "5220")),
        ((Standards.TSIC2552, "47214"), (Standards.ISIC3, "5220")),
        ((Standards.TSIC2552, "47215"), (Standards.ISIC3, "5220")),
        ((Standards.TSIC2552, "47219"), (Standards.ISIC3, "5220")),
        ((Standards.TSIC2552, "47221"), (Standards.ISIC3, "5220")),
        ((Standards.TSIC2552, "47222"), (Standards.ISIC3, "5220")),
        ((Standards.TSIC2552, "47230"), (Standards.ISIC3, "5220")),
        ((Standards.TSIC2552, "47300"), (Standards.ISIC3, "5050")),
        ((Standards.TSIC2552, "47411"), (Standards.ISIC3, "5239")),
        ((Standards.TSIC2552, "47412"), (Standards.ISIC3, "5239")),
        ((Standards.TSIC2552, "47413"), (Standards.ISIC3, "5239")),
        ((Standards.TSIC2552, "47420"), (Standards.ISIC3, "5233")),
        ((Standards.TSIC2552, "47511"), (Standards.ISIC3, "5232")),
        ((Standards.TSIC2552, "47512"), (Standards.ISIC3, "5232")),
        ((Standards.TSIC2552, "47513"), (Standards.ISIC3, "5232")),
        ((Standards.TSIC2552, "47521"), (Standards.ISIC3, "5234")),
        ((Standards.TSIC2552, "47522"), (Standards.ISIC3, "5234")),
        ((Standards.TSIC2552, "47523"), (Standards.ISIC3, "5234")),
        ((Standards.TSIC2552, "47524"), (Standards.ISIC3, "5234")),
        ((Standards.TSIC2552, "47525"), (Standards.ISIC3, "5234")),
        ((Standards.TSIC2552, "47530"), (Standards.ISIC3, "5233")),
        ((Standards.TSIC2552, "47530"), (Standards.ISIC3, "5239")),
        ((Standards.TSIC2552, "47591"), (Standards.ISIC3, "5233")),
        ((Standards.TSIC2552, "47592"), (Standards.ISIC3, "5233")),
        ((Standards.TSIC2552, "47593"), (Standards.ISIC3, "5233")),
        ((Standards.TSIC2552, "47594"), (Standards.ISIC3, "5233")),
        ((Standards.TSIC2552, "47595"), (Standards.ISIC3, "5233")),
        ((Standards.TSIC2552, "47599"), (Standards.ISIC3, "5233")),
        ((Standards.TSIC2552, "47611"), (Standards.ISIC3, "5239")),
        ((Standards.TSIC2552, "47612"), (Standards.ISIC3, "5239")),
        ((Standards.TSIC2552, "47620"), (Standards.ISIC3, "5233")),
        ((Standards.TSIC2552, "47630"), (Standards.ISIC3, "5239")),
        ((Standards.TSIC2552, "47640"), (Standards.ISIC3, "5239")),
        ((Standards.TSIC2552, "47691"), (Standards.ISIC3, "5239")),
        ((Standards.TSIC2552, "47699"), (Standards.ISIC3, "5239")),
        ((Standards.TSIC2552, "47711"), (Standards.ISIC3, "5232")),
        ((Standards.TSIC2552, "47712"), (Standards.ISIC3, "5232")),
        ((Standards.TSIC2552, "47713"), (Standards.ISIC3, "5232")),
        ((Standards.TSIC2552, "47721"), (Standards.ISIC3, "5231")),
        ((Standards.TSIC2552, "47722"), (Standards.ISIC3, "5231")),
        ((Standards.TSIC2552, "47723"), (Standards.ISIC3, "5231")),
        ((Standards.TSIC2552, "47731"), (Standards.ISIC3, "5239")),
        ((Standards.TSIC2552, "47732"), (Standards.ISIC3, "5239")),
        ((Standards.TSIC2552, "47733"), (Standards.ISIC3, "5239")),
        ((Standards.TSIC2552, "47734"), (Standards.ISIC3, "5239")),
        ((Standards.TSIC2552, "47735"), (Standards.ISIC3, "5239")),
        ((Standards.TSIC2552, "47739"), (Standards.ISIC3, "5239")),
        ((Standards.TSIC2552, "47741"), (Standards.ISIC3, "5240")),
        ((Standards.TSIC2552, "47742"), (Standards.ISIC3, "5240")),
        ((Standards.TSIC2552, "47743"), (Standards.ISIC3, "5240")),
        ((Standards.TSIC2552, "47744"), (Standards.ISIC3, "5240")),
        ((Standards.TSIC2552, "47745"), (Standards.ISIC3, "5240")),
        ((Standards.TSIC2552, "47749"), (Standards.ISIC3, "5240")),
        ((Standards.TSIC2552, "47811"), (Standards.ISIC3, "5252")),
        ((Standards.TSIC2552, "47812"), (Standards.ISIC3, "5252")),
        ((Standards.TSIC2552, "47813"), (Standards.ISIC3, "5252")),
        ((Standards.TSIC2552, "47821"), (Standards.ISIC3, "5252")),
        ((Standards.TSIC2552, "47822"), (Standards.ISIC3, "5252")),
        ((Standards.TSIC2552, "47891"), (Standards.ISIC3, "5252")),
        ((Standards.TSIC2552, "47892"), (Standards.ISIC3, "5252")),
        ((Standards.TSIC2552, "47893"), (Standards.ISIC3, "5252")),
        ((Standards.TSIC2552, "47894"), (Standards.ISIC3, "5252")),
        ((Standards.TSIC2552, "47895"), (Standards.ISIC3, "5252")),
        ((Standards.TSIC2552, "47896"), (Standards.ISIC3, "5252")),
        ((Standards.TSIC2552, "47897"), (Standards.ISIC3, "5252")),
        ((Standards.TSIC2552, "47899"), (Standards.ISIC3, "5252")),
        ((Standards.TSIC2552, "47911"), (Standards.ISIC3, "5251")),
        ((Standards.TSIC2552, "47912"), (Standards.ISIC3, "5251")),
        ((Standards.TSIC2552, "47912"), (Standards.ISIC3, "5259")),
        ((Standards.TSIC2552, "47991"), (Standards.ISIC3, "5259")),
        ((Standards.TSIC2552, "47999"), (Standards.ISIC3, "5259")),
        ((Standards.TSIC2552, "49110"), (Standards.ISIC3, "6010")),
        ((Standards.TSIC2552, "49120"), (Standards.ISIC3, "6010")),
        ((Standards.TSIC2552, "49201"), (Standards.ISIC3, "6021")),
        ((Standards.TSIC2552, "49202"), (Standards.ISIC3, "6021")),
        ((Standards.TSIC2552, "49203"), (Standards.ISIC3, "6021")),
        ((Standards.TSIC2552, "49204"), (Standards.ISIC3, "6021")),
        ((Standards.TSIC2552, "49209"), (Standards.ISIC3, "6021")),
        ((Standards.TSIC2552, "49310"), (Standards.ISIC3, "6021")),
        ((Standards.TSIC2552, "49321"), (Standards.ISIC3, "6022")),
        ((Standards.TSIC2552, "49322"), (Standards.ISIC3, "6022")),
        ((Standards.TSIC2552, "49329"), (Standards.ISIC3, "6022")),
        ((Standards.TSIC2552, "49329"), (Standards.ISIC3, "9241")),
        ((Standards.TSIC2552, "49331"), (Standards.ISIC3, "6023")),
        ((Standards.TSIC2552, "49332"), (Standards.ISIC3, "6023")),
        ((Standards.TSIC2552, "49333"), (Standards.ISIC3, "6023")),
        ((Standards.TSIC2552, "49334"), (Standards.ISIC3, "6023")),
        ((Standards.TSIC2552, "49339"), (Standards.ISIC3, "6023")),
        ((Standards.TSIC2552, "49400"), (Standards.ISIC3, "6030")),
        ((Standards.TSIC2552, "50111"), (Standards.ISIC3, "6110")),
        ((Standards.TSIC2552, "50112"), (Standards.ISIC3, "6110")),
        ((Standards.TSIC2552, "50119"), (Standards.ISIC3, "6110")),
        ((Standards.TSIC2552, "50121"), (Standards.ISIC3, "6110")),
        ((Standards.TSIC2552, "50122"), (Standards.ISIC3, "6110")),
        ((Standards.TSIC2552, "50211"), (Standards.ISIC3, "6120")),
        ((Standards.TSIC2552, "50212"), (Standards.ISIC3, "6120")),
        ((Standards.TSIC2552, "50219"), (Standards.ISIC3, "6120")),
        ((Standards.TSIC2552, "50221"), (Standards.ISIC3, "6120")),
        ((Standards.TSIC2552, "50222"), (Standards.ISIC3, "6120")),
        ((Standards.TSIC2552, "51101"), (Standards.ISIC3, "6210")),
        ((Standards.TSIC2552, "51102"), (Standards.ISIC3, "6220")),
        ((Standards.TSIC2552, "51201"), (Standards.ISIC3, "6210")),
        ((Standards.TSIC2552, "51202"), (Standards.ISIC3, "6220")),
        ((Standards.TSIC2552, "52101"), (Standards.ISIC3, "6302")),
        ((Standards.TSIC2552, "52102"), (Standards.ISIC3, "6302")),
        ((Standards.TSIC2552, "52109"), (Standards.ISIC3, "6302")),
        ((Standards.TSIC2552, "52211"), (Standards.ISIC3, "6010")),
        ((Standards.TSIC2552, "52211"), (Standards.ISIC3, "6303")),
        ((Standards.TSIC2552, "52212"), (Standards.ISIC3, "6303")),
        ((Standards.TSIC2552, "52213"), (Standards.ISIC3, "6303")),
        ((Standards.TSIC2552, "52214"), (Standards.ISIC3, "5020")),
        ((Standards.TSIC2552, "52219"), (Standards.ISIC3, "6303")),
        ((Standards.TSIC2552, "52221"), (Standards.ISIC3, "6303")),
        ((Standards.TSIC2552, "52229"), (Standards.ISIC3, "6303")),
        ((Standards.TSIC2552, "52231"), (Standards.ISIC3, "6303")),
        ((Standards.TSIC2552, "52239"), (Standards.ISIC3, "6303")),
        ((Standards.TSIC2552, "52241"), (Standards.ISIC3, "6301")),
        ((Standards.TSIC2552, "52242"), (Standards.ISIC3, "6301")),
        ((Standards.TSIC2552, "52291"), (Standards.ISIC3, "6309")),
        ((Standards.TSIC2552, "52292"), (Standards.ISIC3, "6309")),
        ((Standards.TSIC2552, "52293"), (Standards.ISIC3, "6309")),
        ((Standards.TSIC2552, "52299"), (Standards.ISIC3, "6309")),
        ((Standards.TSIC2552, "53100"), (Standards.ISIC3, "6411")),
        ((Standards.TSIC2552, "53200"), (Standards.ISIC3, "6412")),
        ((Standards.TSIC2552, "55101"), (Standards.ISIC3, "5510")),
        ((Standards.TSIC2552, "55102"), (Standards.ISIC3, "5510")),
        ((Standards.TSIC2552, "55103"), (Standards.ISIC3, "5510")),
        ((Standards.TSIC2552, "55109"), (Standards.ISIC3, "5510")),
        ((Standards.TSIC2552, "55200"), (Standards.ISIC3, "5510")),
        ((Standards.TSIC2552, "55901"), (Standards.ISIC3, "5510")),
        ((Standards.TSIC2552, "55909"), (Standards.ISIC3, "5510")),
        ((Standards.TSIC2552, "56101"), (Standards.ISIC3, "5520")),
        ((Standards.TSIC2552, "56101"), (Standards.ISIC3, "8532")),
        ((Standards.TSIC2552, "56102"), (Standards.ISIC3, "5520")),
        ((Standards.TSIC2552, "56103"), (Standards.ISIC3, "5520")),
        ((Standards.TSIC2552, "56210"), (Standards.ISIC3, "5520")),
        ((Standards.TSIC2552, "56291"), (Standards.ISIC3, "5520")),
        ((Standards.TSIC2552, "56292"), (Standards.ISIC3, "5520")),
        ((Standards.TSIC2552, "56299"), (Standards.ISIC3, "5520")),
        ((Standards.TSIC2552, "56301"), (Standards.ISIC3, "5520")),
        ((Standards.TSIC2552, "56302"), (Standards.ISIC3, "5520")),
        ((Standards.TSIC2552, "56303"), (Standards.ISIC3, "5520")),
        ((Standards.TSIC2552, "56304"), (Standards.ISIC3, "5520")),
        ((Standards.TSIC2552, "58111"), (Standards.ISIC3, "2221")),
        ((Standards.TSIC2552, "58112"), (Standards.ISIC3, "2221")),
        ((Standards.TSIC2552, "58113"), (Standards.ISIC3, "7240")),
        ((Standards.TSIC2552, "58114"), (Standards.ISIC3, "2221")),
        ((Standards.TSIC2552, "58121"), (Standards.ISIC3, "2221")),
        ((Standards.TSIC2552, "58122"), (Standards.ISIC3, "7240")),
        ((Standards.TSIC2552, "58131"), (Standards.ISIC3, "2212")),
        ((Standards.TSIC2552, "58132"), (Standards.ISIC3, "2212")),
        ((Standards.TSIC2552, "58132"), (Standards.ISIC3, "2219")),
        ((Standards.TSIC2552, "58133"), (Standards.ISIC3, "7240")),
        ((Standards.TSIC2552, "58134"), (Standards.ISIC3, "2212")),
        ((Standards.TSIC2552, "58191"), (Standards.ISIC3, "2219")),
        ((Standards.TSIC2552, "58192"), (Standards.ISIC3, "7240")),
        ((Standards.TSIC2552, "58193"), (Standards.ISIC3, "2219")),
        ((Standards.TSIC2552, "58201"), (Standards.ISIC3, "7220")),
        ((Standards.TSIC2552, "58201"), (Standards.ISIC3, "7240")),
        ((Standards.TSIC2552, "58202"), (Standards.ISIC3, "7220")),
        ((Standards.TSIC2552, "58202"), (Standards.ISIC3, "7240")),
        ((Standards.TSIC2552, "58203"), (Standards.ISIC3, "7220")),
        ((Standards.TSIC2552, "59111"), (Standards.ISIC3, "9211")),
        ((Standards.TSIC2552, "59112"), (Standards.ISIC3, "9213")),
        ((Standards.TSIC2552, "59121"), (Standards.ISIC3, "9211")),
        ((Standards.TSIC2552, "59122"), (Standards.ISIC3, "9211")),
        ((Standards.TSIC2552, "59129"), (Standards.ISIC3, "9211")),
        ((Standards.TSIC2552, "59129"), (Standards.ISIC3, "9231")),
        ((Standards.TSIC2552, "59131"), (Standards.ISIC3, "9211")),
        ((Standards.TSIC2552, "59132"), (Standards.ISIC3, "9211")),
        ((Standards.TSIC2552, "59140"), (Standards.ISIC3, "9212")),
        ((Standards.TSIC2552, "59201"), (Standards.ISIC3, "9249")),
        ((Standards.TSIC2552, "59202"), (Standards.ISIC3, "2211")),
        ((Standards.TSIC2552, "59202"), (Standards.ISIC3, "2213")),
        ((Standards.TSIC2552, "59202"), (Standards.ISIC3, "7240")),
        ((Standards.TSIC2552, "59203"), (Standards.ISIC3, "2213")),
        ((Standards.TSIC2552, "60101"), (Standards.ISIC3, "9213")),
        ((Standards.TSIC2552, "60102"), (Standards.ISIC3, "7240")),
        ((Standards.TSIC2552, "60201"), (Standards.ISIC3, "9213")),
        ((Standards.TSIC2552, "60202"), (Standards.ISIC3, "9213")),
        ((Standards.TSIC2552, "60203"), (Standards.ISIC3, "7240")),
        ((Standards.TSIC2552, "61101"), (Standards.ISIC3, "6420")),
        ((Standards.TSIC2552, "61102"), (Standards.ISIC3, "6420")),
        ((Standards.TSIC2552, "61109"), (Standards.ISIC3, "6420")),
        ((Standards.TSIC2552, "61109"), (Standards.ISIC3, "9309")),
        ((Standards.TSIC2552, "61201"), (Standards.ISIC3, "6420")),
        ((Standards.TSIC2552, "61202"), (Standards.ISIC3, "6420")),
        ((Standards.TSIC2552, "61209"), (Standards.ISIC3, "6420")),
        ((Standards.TSIC2552, "61301"), (Standards.ISIC3, "6420")),
        ((Standards.TSIC2552, "61302"), (Standards.ISIC3, "6420")),
        ((Standards.TSIC2552, "61900"), (Standards.ISIC3, "6420")),
        ((Standards.TSIC2552, "62011"), (Standards.ISIC3, "7220")),
        ((Standards.TSIC2552, "62012"), (Standards.ISIC3, "7220")),
        ((Standards.TSIC2552, "62021"), (Standards.ISIC3, "7210")),
        ((Standards.TSIC2552, "62022"), (Standards.ISIC3, "7220")),
        ((Standards.TSIC2552, "62023"), (Standards.ISIC3, "7230")),
        ((Standards.TSIC2552, "62090"), (Standards.ISIC3, "7290")),
        ((Standards.TSIC2552, "63111"), (Standards.ISIC3, "7230")),
        ((Standards.TSIC2552, "63112"), (Standards.ISIC3, "7230")),
        ((Standards.TSIC2552, "63120"), (Standards.ISIC3, "7240")),
        ((Standards.TSIC2552, "63911"), (Standards.ISIC3, "9220")),
        ((Standards.TSIC2552, "63912"), (Standards.ISIC3, "9220")),
        ((Standards.TSIC2552, "63990"), (Standards.ISIC3, "7499")),
        ((Standards.TSIC2552, "64110"), (Standards.ISIC3, "6511")),
        ((Standards.TSIC2552, "64191"), (Standards.ISIC3, "6519")),
        ((Standards.TSIC2552, "64192"), (Standards.ISIC3, "6519")),
        ((Standards.TSIC2552, "64193"), (Standards.ISIC3, "6519")),
        ((Standards.TSIC2552, "64194"), (Standards.ISIC3, "6519")),
        ((Standards.TSIC2552, "64195"), (Standards.ISIC3, "6519")),
        ((Standards.TSIC2552, "64195"), (Standards.ISIC3, "6719")),
        ((Standards.TSIC2552, "64201"), (Standards.ISIC3, "6599")),
        ((Standards.TSIC2552, "64202"), (Standards.ISIC3, "6599")),
        ((Standards.TSIC2552, "64301"), (Standards.ISIC3, "6599")),
        ((Standards.TSIC2552, "64302"), (Standards.ISIC3, "6599")),
        ((Standards.TSIC2552, "64309"), (Standards.ISIC3, "6599")),
        ((Standards.TSIC2552, "64911"), (Standards.ISIC3, "6591")),
        ((Standards.TSIC2552, "64912"), (Standards.ISIC3, "6591")),
        ((Standards.TSIC2552, "64913"), (Standards.ISIC3, "6591")),
        ((Standards.TSIC2552, "64921"), (Standards.ISIC3, "6592")),
        ((Standards.TSIC2552, "64922"), (Standards.ISIC3, "6592")),
        ((Standards.TSIC2552, "64923"), (Standards.ISIC3, "6592")),
        ((Standards.TSIC2552, "64924"), (Standards.ISIC3, "6592")),
        ((Standards.TSIC2552, "64925"), (Standards.ISIC3, "5240")),
        ((Standards.TSIC2552, "64929"), (Standards.ISIC3, "6592")),
        ((Standards.TSIC2552, "64991"), (Standards.ISIC3, "6592")),
        ((Standards.TSIC2552, "64991"), (Standards.ISIC3, "6599")),
        ((Standards.TSIC2552, "64992"), (Standards.ISIC3, "6599")),
        ((Standards.TSIC2552, "64999"), (Standards.ISIC3, "6599")),
        ((Standards.TSIC2552, "65110"), (Standards.ISIC3, "6601")),
        ((Standards.TSIC2552, "65110"), (Standards.ISIC3, "6603")),
        ((Standards.TSIC2552, "65120"), (Standards.ISIC3, "6603")),
        ((Standards.TSIC2552, "65200"), (Standards.ISIC3, "6601")),
        ((Standards.TSIC2552, "65200"), (Standards.ISIC3, "6603")),
        ((Standards.TSIC2552, "65300"), (Standards.ISIC3, "6602")),
        ((Standards.TSIC2552, "66111"), (Standards.ISIC3, "6711")),
        ((Standards.TSIC2552, "66112"), (Standards.ISIC3, "6711")),
        ((Standards.TSIC2552, "66113"), (Standards.ISIC3, "6711")),
        ((Standards.TSIC2552, "66121"), (Standards.ISIC3, "6712")),
        ((Standards.TSIC2552, "66122"), (Standards.ISIC3, "6712")),
        ((Standards.TSIC2552, "66123"), (Standards.ISIC3, "6719")),
        ((Standards.TSIC2552, "66191"), (Standards.ISIC3, "6719")),
        ((Standards.TSIC2552, "66192"), (Standards.ISIC3, "6719")),
        ((Standards.TSIC2552, "66193"), (Standards.ISIC3, "6719")),
        ((Standards.TSIC2552, "66199"), (Standards.ISIC3, "6599")),
        ((Standards.TSIC2552, "66199"), (Standards.ISIC3, "6719")),
        ((Standards.TSIC2552, "66210"), (Standards.ISIC3, "6720")),
        ((Standards.TSIC2552, "66221"), (Standards.ISIC3, "6720")),
        ((Standards.TSIC2552, "66222"), (Standards.ISIC3, "6720")),
        ((Standards.TSIC2552, "66290"), (Standards.ISIC3, "6720")),
        ((Standards.TSIC2552, "66301"), (Standards.ISIC3, "6712")),
        ((Standards.TSIC2552, "66302"), (Standards.ISIC3, "6602")),
        ((Standards.TSIC2552, "68101"), (Standards.ISIC3, "7010")),
        ((Standards.TSIC2552, "68102"), (Standards.ISIC3, "7010")),
        ((Standards.TSIC2552, "68103"), (Standards.ISIC3, "7010")),
        ((Standards.TSIC2552, "68103"), (Standards.ISIC3, "7514")),
        ((Standards.TSIC2552, "68104"), (Standards.ISIC3, "7010")),
        ((Standards.TSIC2552, "68104"), (Standards.ISIC3, "7514")),
        ((Standards.TSIC2552, "68201"), (Standards.ISIC3, "7020")),
        ((Standards.TSIC2552, "68201"), (Standards.ISIC3, "7514")),
        ((Standards.TSIC2552, "68202"), (Standards.ISIC3, "7020")),
        ((Standards.TSIC2552, "68202"), (Standards.ISIC3, "7514")),
        ((Standards.TSIC2552, "69100"), (Standards.ISIC3, "7411")),
        ((Standards.TSIC2552, "69200"), (Standards.ISIC3, "7412")),
        ((Standards.TSIC2552, "70100"), (Standards.ISIC3, "7414")),
        ((Standards.TSIC2552, "70201"), (Standards.ISIC3, "7414")),
        ((Standards.TSIC2552, "70202"), (Standards.ISIC3, "7414")),
        ((Standards.TSIC2552, "70209"), (Standards.ISIC3, "7414")),
        ((Standards.TSIC2552, "71101"), (Standards.ISIC3, "7421")),
        ((Standards.TSIC2552, "71102"), (Standards.ISIC3, "7421")),
        ((Standards.TSIC2552, "71103"), (Standards.ISIC3, "7421")),
        ((Standards.TSIC2552, "71201"), (Standards.ISIC3, "7422")),
        ((Standards.TSIC2552, "71202"), (Standards.ISIC3, "7422")),
        ((Standards.TSIC2552, "71209"), (Standards.ISIC3, "7422")),
        ((Standards.TSIC2552, "72101"), (Standards.ISIC3, "7310")),
        ((Standards.TSIC2552, "72102"), (Standards.ISIC3, "7310")),
        ((Standards.TSIC2552, "72109"), (Standards.ISIC3, "7310")),
        ((Standards.TSIC2552, "72200"), (Standards.ISIC3, "7310")),
        ((Standards.TSIC2552, "72200"), (Standards.ISIC3, "7320")),
        ((Standards.TSIC2552, "73101"), (Standards.ISIC3, "7430")),
        ((Standards.TSIC2552, "73101"), (Standards.ISIC3, "7499")),
        ((Standards.TSIC2552, "73102"), (Standards.ISIC3, "7430")),
        ((Standards.TSIC2552, "73200"), (Standards.ISIC3, "7413")),
        ((Standards.TSIC2552, "74101"), (Standards.ISIC3, "7499")),
        ((Standards.TSIC2552, "74109"), (Standards.ISIC3, "7421")),
        ((Standards.TSIC2552, "74109"), (Standards.ISIC3, "7499")),
        ((Standards.TSIC2552, "74200"), (Standards.ISIC3, "7494")),
        ((Standards.TSIC2552, "74200"), (Standards.ISIC3, "7499")),
        ((Standards.TSIC2552, "74200"), (Standards.ISIC3, "9220")),
        ((Standards.TSIC2552, "74901"), (Standards.ISIC3, "7499")),
        ((Standards.TSIC2552, "74902"), (Standards.ISIC3, "7421")),
        ((Standards.TSIC2552, "74909"), (Standards.ISIC3, "6309")),
        ((Standards.TSIC2552, "74909"), (Standards.ISIC3, "7421")),
        ((Standards.TSIC2552, "74909"), (Standards.ISIC3, "7414")),
        ((Standards.TSIC2552, "74909"), (Standards.ISIC3, "7492")),
        ((Standards.TSIC2552, "74909"), (Standards.ISIC3, "7499")),
        ((Standards.TSIC2552, "75000"), (Standards.ISIC3, "8520")),
        ((Standards.TSIC2552, "77101"), (Standards.ISIC3, "7111")),
        ((Standards.TSIC2552, "77109"), (Standards.ISIC3, "7111")),
        ((Standards.TSIC2552, "77210"), (Standards.ISIC3, "7130")),
        ((Standards.TSIC2552, "77220"), (Standards.ISIC3, "7130")),
        ((Standards.TSIC2552, "77291"), (Standards.ISIC3, "7130")),
        ((Standards.TSIC2552, "77299"), (Standards.ISIC3, "7130")),
        ((Standards.TSIC2552, "77301"), (Standards.ISIC3, "7111")),
        ((Standards.TSIC2552, "77302"), (Standards.ISIC3, "7112")),
        ((Standards.TSIC2552, "77303"), (Standards.ISIC3, "7113")),
        ((Standards.TSIC2552, "77304"), (Standards.ISIC3, "7121")),
        ((Standards.TSIC2552, "77305"), (Standards.ISIC3, "7122")),
        ((Standards.TSIC2552, "77306"), (Standards.ISIC3, "7123")),
        ((Standards.TSIC2552, "77309"), (Standards.ISIC3, "7129")),
        ((Standards.TSIC2552, "77309"), (Standards.ISIC3, "7130")),
        ((Standards.TSIC2552, "77400"), (Standards.ISIC3, "6599")),
        ((Standards.TSIC2552, "78101"), (Standards.ISIC3, "9249")),
        ((Standards.TSIC2552, "78109"), (Standards.ISIC3, "7491")),
        ((Standards.TSIC2552, "78200"), (Standards.ISIC3, "7491")),
        ((Standards.TSIC2552, "78300"), (Standards.ISIC3, "7491")),
        ((Standards.TSIC2552, "79110"), (Standards.ISIC3, "6304")),
        ((Standards.TSIC2552, "79120"), (Standards.ISIC3, "6304")),
        ((Standards.TSIC2552, "79901"), (Standards.ISIC3, "6304")),
        ((Standards.TSIC2552, "79909"), (Standards.ISIC3, "6304")),
        ((Standards.TSIC2552, "79909"), (Standards.ISIC3, "7513")),
        ((Standards.TSIC2552, "79909"), (Standards.ISIC3, "9214")),
        ((Standards.TSIC2552, "79909"), (Standards.ISIC3, "9219")),
        ((Standards.TSIC2552, "79909"), (Standards.ISIC3, "9241")),
        ((Standards.TSIC2552, "80100"), (Standards.ISIC3, "7492")),
        ((Standards.TSIC2552, "80200"), (Standards.ISIC3, "5260")),
        ((Standards.TSIC2552, "80200"), (Standards.ISIC3, "7492")),
        ((Standards.TSIC2552, "80300"), (Standards.ISIC3, "7492")),
        ((Standards.TSIC2552, "81100"), (Standards.ISIC3, "7020")),
        ((Standards.TSIC2552, "81210"), (Standards.ISIC3, "7493")),
        ((Standards.TSIC2552, "81291"), (Standards.ISIC3, "7493")),
        ((Standards.TSIC2552, "81292"), (Standards.ISIC3, "7493")),
        ((Standards.TSIC2552, "81293"), (Standards.ISIC3, "7493")),
        ((Standards.TSIC2552, "81299"), (Standards.ISIC3, "7493")),
        ((Standards.TSIC2552, "81299"), (Standards.ISIC3, "9000")),
        ((Standards.TSIC2552, "81300"), (Standards.ISIC3, "0140")),
        ((Standards.TSIC2552, "81300"), (Standards.ISIC3, "9000")),
        ((Standards.TSIC2552, "82110"), (Standards.ISIC3, "7499")),
        ((Standards.TSIC2552, "82191"), (Standards.ISIC3, "7499")),
        ((Standards.TSIC2552, "82199"), (Standards.ISIC3, "6411")),
        ((Standards.TSIC2552, "82199"), (Standards.ISIC3, "7499")),
        ((Standards.TSIC2552, "82200"), (Standards.ISIC3, "7499")),
        ((Standards.TSIC2552, "82301"), (Standards.ISIC3, "7499")),
        ((Standards.TSIC2552, "82302"), (Standards.ISIC3, "7499")),
        ((Standards.TSIC2552, "82911"), (Standards.ISIC3, "7499")),
        ((Standards.TSIC2552, "82912"), (Standards.ISIC3, "7499")),
        ((Standards.TSIC2552, "82920"), (Standards.ISIC3, "7495")),
        ((Standards.TSIC2552, "82990"), (Standards.ISIC3, "7499")),
        ((Standards.TSIC2552, "84111"), (Standards.ISIC3, "7511")),
        ((Standards.TSIC2552, "84114"), (Standards.ISIC3, "7514")),
        ((Standards.TSIC2552, "84121"), (Standards.ISIC3, "7512")),
        ((Standards.TSIC2552, "84122"), (Standards.ISIC3, "7512")),
        ((Standards.TSIC2552, "84123"), (Standards.ISIC3, "7512")),
        ((Standards.TSIC2552, "84124"), (Standards.ISIC3, "7512")),
        ((Standards.TSIC2552, "84131"), (Standards.ISIC3, "7513")),
        ((Standards.TSIC2552, "84132"), (Standards.ISIC3, "7513")),
        ((Standards.TSIC2552, "84133"), (Standards.ISIC3, "7513")),
        ((Standards.TSIC2552, "84134"), (Standards.ISIC3, "7513")),
        ((Standards.TSIC2552, "84135"), (Standards.ISIC3, "7513")),
        ((Standards.TSIC2552, "84136"), (Standards.ISIC3, "7513")),
        ((Standards.TSIC2552, "84137"), (Standards.ISIC3, "7513")),
        ((Standards.TSIC2552, "84210"), (Standards.ISIC3, "7521")),
        ((Standards.TSIC2552, "84220"), (Standards.ISIC3, "7522")),
        ((Standards.TSIC2552, "84231"), (Standards.ISIC3, "7523")),
        ((Standards.TSIC2552, "84232"), (Standards.ISIC3, "7523")),
        ((Standards.TSIC2552, "84233"), (Standards.ISIC3, "7523")),
        ((Standards.TSIC2552, "84300"), (Standards.ISIC3, "7530")),
        ((Standards.TSIC2552, "85101"), (Standards.ISIC3, "8010")),
        ((Standards.TSIC2552, "85102"), (Standards.ISIC3, "8010")),
        ((Standards.TSIC2552, "85103"), (Standards.ISIC3, "8010")),
        ((Standards.TSIC2552, "85103"), (Standards.ISIC3, "8090")),
        ((Standards.TSIC2552, "85211"), (Standards.ISIC3, "8021")),
        ((Standards.TSIC2552, "85212"), (Standards.ISIC3, "8021")),
        ((Standards.TSIC2552, "85213"), (Standards.ISIC3, "8021")),
        ((Standards.TSIC2552, "85213"), (Standards.ISIC3, "8090")),
        ((Standards.TSIC2552, "85220"), (Standards.ISIC3, "8022")),
        ((Standards.TSIC2552, "85220"), (Standards.ISIC3, "8090")),
        ((Standards.TSIC2552, "85301"), (Standards.ISIC3, "8030")),
        ((Standards.TSIC2552, "85302"), (Standards.ISIC3, "8030")),
        ((Standards.TSIC2552, "85303"), (Standards.ISIC3, "8030")),
        ((Standards.TSIC2552, "85410"), (Standards.ISIC3, "9241")),
        ((Standards.TSIC2552, "85410"), (Standards.ISIC3, "9309")),
        ((Standards.TSIC2552, "85421"), (Standards.ISIC3, "9219")),
        ((Standards.TSIC2552, "85422"), (Standards.ISIC3, "8090")),
        ((Standards.TSIC2552, "85423"), (Standards.ISIC3, "8090")),
        ((Standards.TSIC2552, "85429"), (Standards.ISIC3, "8090")),
        ((Standards.TSIC2552, "85491"), (Standards.ISIC3, "8090")),
        ((Standards.TSIC2552, "85492"), (Standards.ISIC3, "8090")),
        ((Standards.TSIC2552, "85493"), (Standards.ISIC3, "8090")),
        ((Standards.TSIC2552, "85494"), (Standards.ISIC3, "8090")),
        ((Standards.TSIC2552, "85495"), (Standards.ISIC3, "8090")),
        ((Standards.TSIC2552, "85496"), (Standards.ISIC3, "8090")),
        ((Standards.TSIC2552, "85497"), (Standards.ISIC3, "8090")),
        ((Standards.TSIC2552, "85499"), (Standards.ISIC3, "8090")),
        ((Standards.TSIC2552, "85499"), (Standards.ISIC3, "9241")),
        ((Standards.TSIC2552, "85500"), (Standards.ISIC3, "7414")),
        ((Standards.TSIC2552, "85500"), (Standards.ISIC3, "7499")),
        ((Standards.TSIC2552, "85500"), (Standards.ISIC3, "8532")),
        ((Standards.TSIC2552, "85601"), (Standards.ISIC3, "8010")),
        ((Standards.TSIC2552, "85602"), (Standards.ISIC3, "8010")),
        ((Standards.TSIC2552, "86101"), (Standards.ISIC3, "8511")),
        ((Standards.TSIC2552, "86102"), (Standards.ISIC3, "8511")),
        ((Standards.TSIC2552, "86201"), (Standards.ISIC3, "8512")),
        ((Standards.TSIC2552, "86202"), (Standards.ISIC3, "8512")),
        ((Standards.TSIC2552, "86203"), (Standards.ISIC3, "8512")),
        ((Standards.TSIC2552, "86901"), (Standards.ISIC3, "8519")),
        ((Standards.TSIC2552, "86902"), (Standards.ISIC3, "8519")),
        ((Standards.TSIC2552, "86903"), (Standards.ISIC3, "8519")),
        ((Standards.TSIC2552, "86909"), (Standards.ISIC3, "8519")),
        ((Standards.TSIC2552, "87100"), (Standards.ISIC3, "8519")),
        ((Standards.TSIC2552, "87201"), (Standards.ISIC3, "8519")),
        ((Standards.TSIC2552, "87201"), (Standards.ISIC3, "8531")),
        ((Standards.TSIC2552, "87202"), (Standards.ISIC3, "8519")),
        ((Standards.TSIC2552, "87202"), (Standards.ISIC3, "8531")),
        ((Standards.TSIC2552, "87203"), (Standards.ISIC3, "8519")),
        ((Standards.TSIC2552, "87203"), (Standards.ISIC3, "8531")),
        ((Standards.TSIC2552, "87301"), (Standards.ISIC3, "8519")),
        ((Standards.TSIC2552, "87301"), (Standards.ISIC3, "8531")),
        ((Standards.TSIC2552, "87302"), (Standards.ISIC3, "8531")),
        ((Standards.TSIC2552, "87303"), (Standards.ISIC3, "8531")),
        ((Standards.TSIC2552, "87901"), (Standards.ISIC3, "8531")),
        ((Standards.TSIC2552, "87902"), (Standards.ISIC3, "8531")),
        ((Standards.TSIC2552, "87909"), (Standards.ISIC3, "8531")),
        ((Standards.TSIC2552, "88101"), (Standards.ISIC3, "8532")),
        ((Standards.TSIC2552, "88102"), (Standards.ISIC3, "8532")),
        ((Standards.TSIC2552, "88901"), (Standards.ISIC3, "8532")),
        ((Standards.TSIC2552, "88909"), (Standards.ISIC3, "7521")),
        ((Standards.TSIC2552, "88909"), (Standards.ISIC3, "8532")),
        ((Standards.TSIC2552, "90001"), (Standards.ISIC3, "9214")),
        ((Standards.TSIC2552, "90001"), (Standards.ISIC3, "9220")),
        ((Standards.TSIC2552, "90002"), (Standards.ISIC3, "9214")),
        ((Standards.TSIC2552, "90002"), (Standards.ISIC3, "9219")),
        ((Standards.TSIC2552, "91011"), (Standards.ISIC3, "9231")),
        ((Standards.TSIC2552, "91012"), (Standards.ISIC3, "7514")),
        ((Standards.TSIC2552, "91012"), (Standards.ISIC3, "9231")),
        ((Standards.TSIC2552, "91021"), (Standards.ISIC3, "9232")),
        ((Standards.TSIC2552, "91022"), (Standards.ISIC3, "9232")),
        ((Standards.TSIC2552, "91031"), (Standards.ISIC3, "9233")),
        ((Standards.TSIC2552, "91032"), (Standards.ISIC3, "9233")),
        ((Standards.TSIC2552, "92001"), (Standards.ISIC3, "9249")),
        ((Standards.TSIC2552, "92009"), (Standards.ISIC3, "9249")),
        ((Standards.TSIC2552, "93111"), (Standards.ISIC3, "9241")),
        ((Standards.TSIC2552, "93112"), (Standards.ISIC3, "9241")),
        ((Standards.TSIC2552, "93120"), (Standards.ISIC3, "9241")),
        ((Standards.TSIC2552, "93191"), (Standards.ISIC3, "9241")),
        ((Standards.TSIC2552, "93192"), (Standards.ISIC3, "9241")),
        ((Standards.TSIC2552, "93199"), (Standards.ISIC3, "9241")),
        ((Standards.TSIC2552, "93199"), (Standards.ISIC3, "9249")),
        ((Standards.TSIC2552, "93210"), (Standards.ISIC3, "9219")),
        ((Standards.TSIC2552, "93291"), (Standards.ISIC3, "9249")),
        ((Standards.TSIC2552, "93292"), (Standards.ISIC3, "9219")),
        ((Standards.TSIC2552, "93292"), (Standards.ISIC3, "9249")),
        ((Standards.TSIC2552, "93293"), (Standards.ISIC3, "9249")),
        ((Standards.TSIC2552, "93299"), (Standards.ISIC3, "9219")),
        ((Standards.TSIC2552, "93299"), (Standards.ISIC3, "9249")),
        ((Standards.TSIC2552, "94110"), (Standards.ISIC3, "9111")),
        ((Standards.TSIC2552, "94120"), (Standards.ISIC3, "9112")),
        ((Standards.TSIC2552, "94200"), (Standards.ISIC3, "9120")),
        ((Standards.TSIC2552, "94910"), (Standards.ISIC3, "9191")),
        ((Standards.TSIC2552, "94920"), (Standards.ISIC3, "9192")),
        ((Standards.TSIC2552, "94991"), (Standards.ISIC3, "6599")),
        ((Standards.TSIC2552, "94991"), (Standards.ISIC3, "9199")),
        ((Standards.TSIC2552, "94992"), (Standards.ISIC3, "6599")),
        ((Standards.TSIC2552, "94992"), (Standards.ISIC3, "9199")),
        ((Standards.TSIC2552, "94993"), (Standards.ISIC3, "6599")),
        ((Standards.TSIC2552, "94993"), (Standards.ISIC3, "9199")),
        ((Standards.TSIC2552, "94994"), (Standards.ISIC3, "6599")),
        ((Standards.TSIC2552, "94994"), (Standards.ISIC3, "9199")),
        ((Standards.TSIC2552, "94999"), (Standards.ISIC3, "0150")),
        ((Standards.TSIC2552, "94999"), (Standards.ISIC3, "6599")),
        ((Standards.TSIC2552, "94999"), (Standards.ISIC3, "9199")),
        ((Standards.TSIC2552, "95110"), (Standards.ISIC3, "7250")),
        ((Standards.TSIC2552, "95120"), (Standards.ISIC3, "3220")),
        ((Standards.TSIC2552, "95120"), (Standards.ISIC3, "5260")),
        ((Standards.TSIC2552, "95210"), (Standards.ISIC3, "3230")),
        ((Standards.TSIC2552, "95210"), (Standards.ISIC3, "5260")),
        ((Standards.TSIC2552, "95220"), (Standards.ISIC3, "5260")),
        ((Standards.TSIC2552, "95230"), (Standards.ISIC3, "5260")),
        ((Standards.TSIC2552, "95240"), (Standards.ISIC3, "3610")),
        ((Standards.TSIC2552, "95240"), (Standards.ISIC3, "5260")),
        ((Standards.TSIC2552, "95291"), (Standards.ISIC3, "5260")),
        ((Standards.TSIC2552, "95292"), (Standards.ISIC3, "5260")),
        ((Standards.TSIC2552, "95293"), (Standards.ISIC3, "5260")),
        ((Standards.TSIC2552, "95294"), (Standards.ISIC3, "5260")),
        ((Standards.TSIC2552, "95295"), (Standards.ISIC3, "5260")),
        ((Standards.TSIC2552, "95299"), (Standards.ISIC3, "1712")),
        ((Standards.TSIC2552, "95299"), (Standards.ISIC3, "2892")),
        ((Standards.TSIC2552, "95299"), (Standards.ISIC3, "5260")),
        ((Standards.TSIC2552, "96101"), (Standards.ISIC3, "9309")),
        ((Standards.TSIC2552, "96103"), (Standards.ISIC3, "9302")),
        ((Standards.TSIC2552, "96104"), (Standards.ISIC3, "9302")),
        ((Standards.TSIC2552, "96109"), (Standards.ISIC3, "9309")),
        ((Standards.TSIC2552, "96201"), (Standards.ISIC3, "9301")),
        ((Standards.TSIC2552, "96202"), (Standards.ISIC3, "9301")),
        ((Standards.TSIC2552, "96203"), (Standards.ISIC3, "9301")),
        ((Standards.TSIC2552, "96301"), (Standards.ISIC3, "9303")),
        ((Standards.TSIC2552, "96302"), (Standards.ISIC3, "0140")),
        ((Standards.TSIC2552, "96303"), (Standards.ISIC3, "7494")),
        ((Standards.TSIC2552, "96303"), (Standards.ISIC3, "9309")),
        ((Standards.TSIC2552, "96304"), (Standards.ISIC3, "9309")),
        ((Standards.TSIC2552, "96305"), (Standards.ISIC3, "9309")),
        ((Standards.TSIC2552, "96309"), (Standards.ISIC3, "9309")),
        ((Standards.TSIC2552, "97000"), (Standards.ISIC3, "9500")),
        ((Standards.TSIC2552, "99001"), (Standards.ISIC3, "9900")),
        ((Standards.TSIC2552, "99009"), (Standards.ISIC3, "9900")),
    ],
)
