"""`Concordance between SSIC2020 and ISIC4 <https://www.singstat.gov.sg/-/media/files/standards_and_classifications/industrial_classification/correspondence-tables-between-ssic2020-isicrev4.ashx>`_."""
from ...types import Concordance, Standards
from ..isic4 import ISIC4
from . import SSIC2020

SSIC2020_to_ISIC4 = Concordance(
    src=SSIC2020,
    dst=ISIC4,
    concordances=[
        ((Standards.SSIC2020, "01111"), (Standards.ISIC4, "0113")),
        ((Standards.SSIC2020, "01112"), (Standards.ISIC4, "0113")),
        ((Standards.SSIC2020, "01113"), (Standards.ISIC4, "0113")),
        ((Standards.SSIC2020, "01119"), (Standards.ISIC4, "0111")),
        ((Standards.SSIC2020, "01119"), (Standards.ISIC4, "0112")),
        ((Standards.SSIC2020, "01120"), (Standards.ISIC4, "0113")),
        ((Standards.SSIC2020, "01130"), (Standards.ISIC4, "0121")),
        ((Standards.SSIC2020, "01130"), (Standards.ISIC4, "0122")),
        ((Standards.SSIC2020, "01130"), (Standards.ISIC4, "0123")),
        ((Standards.SSIC2020, "01130"), (Standards.ISIC4, "0124")),
        ((Standards.SSIC2020, "01130"), (Standards.ISIC4, "0125")),
        ((Standards.SSIC2020, "01141"), (Standards.ISIC4, "0130")),
        ((Standards.SSIC2020, "01142"), (Standards.ISIC4, "0130")),
        ((Standards.SSIC2020, "01149"), (Standards.ISIC4, "0130")),
        ((Standards.SSIC2020, "01190"), (Standards.ISIC4, "0114")),
        ((Standards.SSIC2020, "01190"), (Standards.ISIC4, "0115")),
        ((Standards.SSIC2020, "01190"), (Standards.ISIC4, "0116")),
        ((Standards.SSIC2020, "01190"), (Standards.ISIC4, "0119")),
        ((Standards.SSIC2020, "01190"), (Standards.ISIC4, "0126")),
        ((Standards.SSIC2020, "01190"), (Standards.ISIC4, "0127")),
        ((Standards.SSIC2020, "01190"), (Standards.ISIC4, "0128")),
        ((Standards.SSIC2020, "01190"), (Standards.ISIC4, "0129")),
        ((Standards.SSIC2020, "01411"), (Standards.ISIC4, "0145")),
        ((Standards.SSIC2020, "01412"), (Standards.ISIC4, "0141")),
        ((Standards.SSIC2020, "01413"), (Standards.ISIC4, "0144")),
        ((Standards.SSIC2020, "01421"), (Standards.ISIC4, "0146")),
        ((Standards.SSIC2020, "01422"), (Standards.ISIC4, "0146")),
        ((Standards.SSIC2020, "01423"), (Standards.ISIC4, "0146")),
        ((Standards.SSIC2020, "01424"), (Standards.ISIC4, "0146")),
        ((Standards.SSIC2020, "01491"), (Standards.ISIC4, "0149")),
        ((Standards.SSIC2020, "01492"), (Standards.ISIC4, "0149")),
        ((Standards.SSIC2020, "01493"), (Standards.ISIC4, "0321")),
        ((Standards.SSIC2020, "01494"), (Standards.ISIC4, "0322")),
        ((Standards.SSIC2020, "01499"), (Standards.ISIC4, "0142")),
        ((Standards.SSIC2020, "01499"), (Standards.ISIC4, "0143")),
        ((Standards.SSIC2020, "01499"), (Standards.ISIC4, "0149")),
        ((Standards.SSIC2020, "01500"), (Standards.ISIC4, "0150")),
        ((Standards.SSIC2020, "01600"), (Standards.ISIC4, "0161")),
        ((Standards.SSIC2020, "01600"), (Standards.ISIC4, "0162")),
        ((Standards.SSIC2020, "01600"), (Standards.ISIC4, "0163")),
        ((Standards.SSIC2020, "01600"), (Standards.ISIC4, "0164")),
        ((Standards.SSIC2020, "02000"), (Standards.ISIC4, "0210")),
        ((Standards.SSIC2020, "02000"), (Standards.ISIC4, "0220")),
        ((Standards.SSIC2020, "02000"), (Standards.ISIC4, "0230")),
        ((Standards.SSIC2020, "02000"), (Standards.ISIC4, "0240")),
        ((Standards.SSIC2020, "03101"), (Standards.ISIC4, "0311")),
        ((Standards.SSIC2020, "03101"), (Standards.ISIC4, "0312")),
        ((Standards.SSIC2020, "03102"), (Standards.ISIC4, "0311")),
        ((Standards.SSIC2020, "03103"), (Standards.ISIC4, "0311")),
        ((Standards.SSIC2020, "03103"), (Standards.ISIC4, "0312")),
        ((Standards.SSIC2020, "03109"), (Standards.ISIC4, "0311")),
        ((Standards.SSIC2020, "03109"), (Standards.ISIC4, "0312")),
        ((Standards.SSIC2020, "03201"), (Standards.ISIC4, "0321")),
        ((Standards.SSIC2020, "03201"), (Standards.ISIC4, "0322")),
        ((Standards.SSIC2020, "03202"), (Standards.ISIC4, "0321")),
        ((Standards.SSIC2020, "03202"), (Standards.ISIC4, "0322")),
        ((Standards.SSIC2020, "03209"), (Standards.ISIC4, "0321")),
        ((Standards.SSIC2020, "03209"), (Standards.ISIC4, "0322")),
        ((Standards.SSIC2020, "08101"), (Standards.ISIC4, "0810")),
        ((Standards.SSIC2020, "08102"), (Standards.ISIC4, "0810")),
        ((Standards.SSIC2020, "08900"), (Standards.ISIC4, "0510")),
        ((Standards.SSIC2020, "08900"), (Standards.ISIC4, "0520")),
        ((Standards.SSIC2020, "08900"), (Standards.ISIC4, "0710")),
        ((Standards.SSIC2020, "08900"), (Standards.ISIC4, "0721")),
        ((Standards.SSIC2020, "08900"), (Standards.ISIC4, "0729")),
        ((Standards.SSIC2020, "08900"), (Standards.ISIC4, "0891")),
        ((Standards.SSIC2020, "08900"), (Standards.ISIC4, "0892")),
        ((Standards.SSIC2020, "08900"), (Standards.ISIC4, "0893")),
        ((Standards.SSIC2020, "08900"), (Standards.ISIC4, "0899")),
        ((Standards.SSIC2020, "09001"), (Standards.ISIC4, "0610")),
        ((Standards.SSIC2020, "09001"), (Standards.ISIC4, "0620")),
        ((Standards.SSIC2020, "09002"), (Standards.ISIC4, "0910")),
        ((Standards.SSIC2020, "09002"), (Standards.ISIC4, "0990")),
        ((Standards.SSIC2020, "10101"), (Standards.ISIC4, "1010")),
        ((Standards.SSIC2020, "10102"), (Standards.ISIC4, "1010")),
        ((Standards.SSIC2020, "10103"), (Standards.ISIC4, "1010")),
        ((Standards.SSIC2020, "10104"), (Standards.ISIC4, "1010")),
        ((Standards.SSIC2020, "10109"), (Standards.ISIC4, "1010")),
        ((Standards.SSIC2020, "10200"), (Standards.ISIC4, "1020")),
        ((Standards.SSIC2020, "10301"), (Standards.ISIC4, "1030")),
        ((Standards.SSIC2020, "10302"), (Standards.ISIC4, "1030")),
        ((Standards.SSIC2020, "10303"), (Standards.ISIC4, "1030")),
        ((Standards.SSIC2020, "10401"), (Standards.ISIC4, "1040")),
        ((Standards.SSIC2020, "10402"), (Standards.ISIC4, "1040")),
        ((Standards.SSIC2020, "10409"), (Standards.ISIC4, "1040")),
        ((Standards.SSIC2020, "10501"), (Standards.ISIC4, "1050")),
        ((Standards.SSIC2020, "10502"), (Standards.ISIC4, "1050")),
        ((Standards.SSIC2020, "10503"), (Standards.ISIC4, "1050")),
        ((Standards.SSIC2020, "10509"), (Standards.ISIC4, "1050")),
        ((Standards.SSIC2020, "10611"), (Standards.ISIC4, "1061")),
        ((Standards.SSIC2020, "10612"), (Standards.ISIC4, "1061")),
        ((Standards.SSIC2020, "10613"), (Standards.ISIC4, "1061")),
        ((Standards.SSIC2020, "10619"), (Standards.ISIC4, "1061")),
        ((Standards.SSIC2020, "10620"), (Standards.ISIC4, "1062")),
        ((Standards.SSIC2020, "10711"), (Standards.ISIC4, "1071")),
        ((Standards.SSIC2020, "10712"), (Standards.ISIC4, "1071")),
        ((Standards.SSIC2020, "10719"), (Standards.ISIC4, "1071")),
        ((Standards.SSIC2020, "10720"), (Standards.ISIC4, "1072")),
        ((Standards.SSIC2020, "10731"), (Standards.ISIC4, "1073")),
        ((Standards.SSIC2020, "10732"), (Standards.ISIC4, "1073")),
        ((Standards.SSIC2020, "10733"), (Standards.ISIC4, "1073")),
        ((Standards.SSIC2020, "10740"), (Standards.ISIC4, "1074")),
        ((Standards.SSIC2020, "10750"), (Standards.ISIC4, "1075")),
        ((Standards.SSIC2020, "10761"), (Standards.ISIC4, "1079")),
        ((Standards.SSIC2020, "10762"), (Standards.ISIC4, "1079")),
        ((Standards.SSIC2020, "10763"), (Standards.ISIC4, "1079")),
        ((Standards.SSIC2020, "10764"), (Standards.ISIC4, "1079")),
        ((Standards.SSIC2020, "10765"), (Standards.ISIC4, "1079")),
        ((Standards.SSIC2020, "10791"), (Standards.ISIC4, "1079")),
        ((Standards.SSIC2020, "10792"), (Standards.ISIC4, "1079")),
        ((Standards.SSIC2020, "10793"), (Standards.ISIC4, "1079")),
        ((Standards.SSIC2020, "10794"), (Standards.ISIC4, "1079")),
        ((Standards.SSIC2020, "10799"), (Standards.ISIC4, "1079")),
        ((Standards.SSIC2020, "10800"), (Standards.ISIC4, "1080")),
        ((Standards.SSIC2020, "11010"), (Standards.ISIC4, "1101")),
        ((Standards.SSIC2020, "11020"), (Standards.ISIC4, "1102")),
        ((Standards.SSIC2020, "11030"), (Standards.ISIC4, "1103")),
        ((Standards.SSIC2020, "11041"), (Standards.ISIC4, "1104")),
        ((Standards.SSIC2020, "11042"), (Standards.ISIC4, "1104")),
        ((Standards.SSIC2020, "11043"), (Standards.ISIC4, "1104")),
        ((Standards.SSIC2020, "12001"), (Standards.ISIC4, "1200")),
        ((Standards.SSIC2020, "12009"), (Standards.ISIC4, "1200")),
        ((Standards.SSIC2020, "13100"), (Standards.ISIC4, "1311")),
        ((Standards.SSIC2020, "13100"), (Standards.ISIC4, "1312")),
        ((Standards.SSIC2020, "13100"), (Standards.ISIC4, "1313")),
        ((Standards.SSIC2020, "13910"), (Standards.ISIC4, "1391")),
        ((Standards.SSIC2020, "13921"), (Standards.ISIC4, "1392")),
        ((Standards.SSIC2020, "13922"), (Standards.ISIC4, "1392")),
        ((Standards.SSIC2020, "13929"), (Standards.ISIC4, "1392")),
        ((Standards.SSIC2020, "13930"), (Standards.ISIC4, "1393")),
        ((Standards.SSIC2020, "13940"), (Standards.ISIC4, "1394")),
        ((Standards.SSIC2020, "13990"), (Standards.ISIC4, "1399")),
        ((Standards.SSIC2020, "14101"), (Standards.ISIC4, "1410")),
        ((Standards.SSIC2020, "14102"), (Standards.ISIC4, "1410")),
        ((Standards.SSIC2020, "14103"), (Standards.ISIC4, "1410")),
        ((Standards.SSIC2020, "14109"), (Standards.ISIC4, "1410")),
        ((Standards.SSIC2020, "14200"), (Standards.ISIC4, "1420")),
        ((Standards.SSIC2020, "14301"), (Standards.ISIC4, "1430")),
        ((Standards.SSIC2020, "14302"), (Standards.ISIC4, "1430")),
        ((Standards.SSIC2020, "14309"), (Standards.ISIC4, "1430")),
        ((Standards.SSIC2020, "15110"), (Standards.ISIC4, "1511")),
        ((Standards.SSIC2020, "15121"), (Standards.ISIC4, "1512")),
        ((Standards.SSIC2020, "15122"), (Standards.ISIC4, "1512")),
        ((Standards.SSIC2020, "15129"), (Standards.ISIC4, "1512")),
        ((Standards.SSIC2020, "15200"), (Standards.ISIC4, "1520")),
        ((Standards.SSIC2020, "16101"), (Standards.ISIC4, "1610")),
        ((Standards.SSIC2020, "16102"), (Standards.ISIC4, "1610")),
        ((Standards.SSIC2020, "16109"), (Standards.ISIC4, "1610")),
        ((Standards.SSIC2020, "16211"), (Standards.ISIC4, "1621")),
        ((Standards.SSIC2020, "16219"), (Standards.ISIC4, "1621")),
        ((Standards.SSIC2020, "16291"), (Standards.ISIC4, "1622")),
        ((Standards.SSIC2020, "16292"), (Standards.ISIC4, "1629")),
        ((Standards.SSIC2020, "16293"), (Standards.ISIC4, "1623")),
        ((Standards.SSIC2020, "16294"), (Standards.ISIC4, "1629")),
        ((Standards.SSIC2020, "16295"), (Standards.ISIC4, "1629")),
        ((Standards.SSIC2020, "16299"), (Standards.ISIC4, "1629")),
        ((Standards.SSIC2020, "17010"), (Standards.ISIC4, "1701")),
        ((Standards.SSIC2020, "17021"), (Standards.ISIC4, "1702")),
        ((Standards.SSIC2020, "17022"), (Standards.ISIC4, "1702")),
        ((Standards.SSIC2020, "17091"), (Standards.ISIC4, "1709")),
        ((Standards.SSIC2020, "17092"), (Standards.ISIC4, "1709")),
        ((Standards.SSIC2020, "17093"), (Standards.ISIC4, "1709")),
        ((Standards.SSIC2020, "17094"), (Standards.ISIC4, "1709")),
        ((Standards.SSIC2020, "17099"), (Standards.ISIC4, "1709")),
        ((Standards.SSIC2020, "18111"), (Standards.ISIC4, "1811")),
        ((Standards.SSIC2020, "18112"), (Standards.ISIC4, "1811")),
        ((Standards.SSIC2020, "18113"), (Standards.ISIC4, "1811")),
        ((Standards.SSIC2020, "18114"), (Standards.ISIC4, "1811")),
        ((Standards.SSIC2020, "18115"), (Standards.ISIC4, "1811")),
        ((Standards.SSIC2020, "18119"), (Standards.ISIC4, "1811")),
        ((Standards.SSIC2020, "18121"), (Standards.ISIC4, "1812")),
        ((Standards.SSIC2020, "18122"), (Standards.ISIC4, "1812")),
        ((Standards.SSIC2020, "18129"), (Standards.ISIC4, "1812")),
        ((Standards.SSIC2020, "18200"), (Standards.ISIC4, "1820")),
        ((Standards.SSIC2020, "19100"), (Standards.ISIC4, "1910")),
        ((Standards.SSIC2020, "19201"), (Standards.ISIC4, "1920")),
        ((Standards.SSIC2020, "19202"), (Standards.ISIC4, "1920")),
        ((Standards.SSIC2020, "19209"), (Standards.ISIC4, "1920")),
        ((Standards.SSIC2020, "20111"), (Standards.ISIC4, "2011")),
        ((Standards.SSIC2020, "20112"), (Standards.ISIC4, "2011")),
        ((Standards.SSIC2020, "20113"), (Standards.ISIC4, "2011")),
        ((Standards.SSIC2020, "20114"), (Standards.ISIC4, "2011")),
        ((Standards.SSIC2020, "20119"), (Standards.ISIC4, "2011")),
        ((Standards.SSIC2020, "20120"), (Standards.ISIC4, "2012")),
        ((Standards.SSIC2020, "20131"), (Standards.ISIC4, "2013")),
        ((Standards.SSIC2020, "20132"), (Standards.ISIC4, "2013")),
        ((Standards.SSIC2020, "20133"), (Standards.ISIC4, "2013")),
        ((Standards.SSIC2020, "20210"), (Standards.ISIC4, "2021")),
        ((Standards.SSIC2020, "20221"), (Standards.ISIC4, "2022")),
        ((Standards.SSIC2020, "20222"), (Standards.ISIC4, "2022")),
        ((Standards.SSIC2020, "20229"), (Standards.ISIC4, "2022")),
        ((Standards.SSIC2020, "20231"), (Standards.ISIC4, "2023")),
        ((Standards.SSIC2020, "20232"), (Standards.ISIC4, "2023")),
        ((Standards.SSIC2020, "20233"), (Standards.ISIC4, "2023")),
        ((Standards.SSIC2020, "20234"), (Standards.ISIC4, "2023")),
        ((Standards.SSIC2020, "20241"), (Standards.ISIC4, "2029")),
        ((Standards.SSIC2020, "20242"), (Standards.ISIC4, "2029")),
        ((Standards.SSIC2020, "20249"), (Standards.ISIC4, "2029")),
        ((Standards.SSIC2020, "20291"), (Standards.ISIC4, "2029")),
        ((Standards.SSIC2020, "20292"), (Standards.ISIC4, "2029")),
        ((Standards.SSIC2020, "20293"), (Standards.ISIC4, "2029")),
        ((Standards.SSIC2020, "20294"), (Standards.ISIC4, "2029")),
        ((Standards.SSIC2020, "20295"), (Standards.ISIC4, "2029")),
        ((Standards.SSIC2020, "20296"), (Standards.ISIC4, "2029")),
        ((Standards.SSIC2020, "20297"), (Standards.ISIC4, "2029")),
        ((Standards.SSIC2020, "20298"), (Standards.ISIC4, "2029")),
        ((Standards.SSIC2020, "20299"), (Standards.ISIC4, "2029")),
        ((Standards.SSIC2020, "20300"), (Standards.ISIC4, "2030")),
        ((Standards.SSIC2020, "21011"), (Standards.ISIC4, "2100")),
        ((Standards.SSIC2020, "21012"), (Standards.ISIC4, "2100")),
        ((Standards.SSIC2020, "21013"), (Standards.ISIC4, "2100")),
        ((Standards.SSIC2020, "21021"), (Standards.ISIC4, "2100")),
        ((Standards.SSIC2020, "21022"), (Standards.ISIC4, "2100")),
        ((Standards.SSIC2020, "21023"), (Standards.ISIC4, "2100")),
        ((Standards.SSIC2020, "21030"), (Standards.ISIC4, "2100")),
        ((Standards.SSIC2020, "22111"), (Standards.ISIC4, "2219")),
        ((Standards.SSIC2020, "22112"), (Standards.ISIC4, "2219")),
        ((Standards.SSIC2020, "22119"), (Standards.ISIC4, "2219")),
        ((Standards.SSIC2020, "22121"), (Standards.ISIC4, "2211")),
        ((Standards.SSIC2020, "22122"), (Standards.ISIC4, "2211")),
        ((Standards.SSIC2020, "22191"), (Standards.ISIC4, "2219")),
        ((Standards.SSIC2020, "22192"), (Standards.ISIC4, "2219")),
        ((Standards.SSIC2020, "22193"), (Standards.ISIC4, "2219")),
        ((Standards.SSIC2020, "22194"), (Standards.ISIC4, "2219")),
        ((Standards.SSIC2020, "22199"), (Standards.ISIC4, "2219")),
        ((Standards.SSIC2020, "22211"), (Standards.ISIC4, "2220")),
        ((Standards.SSIC2020, "22212"), (Standards.ISIC4, "2220")),
        ((Standards.SSIC2020, "22213"), (Standards.ISIC4, "2220")),
        ((Standards.SSIC2020, "22214"), (Standards.ISIC4, "2220")),
        ((Standards.SSIC2020, "22215"), (Standards.ISIC4, "2220")),
        ((Standards.SSIC2020, "22216"), (Standards.ISIC4, "2220")),
        ((Standards.SSIC2020, "22217"), (Standards.ISIC4, "2220")),
        ((Standards.SSIC2020, "22218"), (Standards.ISIC4, "2220")),
        ((Standards.SSIC2020, "22219"), (Standards.ISIC4, "2220")),
        ((Standards.SSIC2020, "22220"), (Standards.ISIC4, "2220")),
        ((Standards.SSIC2020, "23100"), (Standards.ISIC4, "2310")),
        ((Standards.SSIC2020, "23911"), (Standards.ISIC4, "2391")),
        ((Standards.SSIC2020, "23912"), (Standards.ISIC4, "2391")),
        ((Standards.SSIC2020, "23912"), (Standards.ISIC4, "2392")),
        ((Standards.SSIC2020, "23919"), (Standards.ISIC4, "2391")),
        ((Standards.SSIC2020, "23919"), (Standards.ISIC4, "2392")),
        ((Standards.SSIC2020, "23931"), (Standards.ISIC4, "2393")),
        ((Standards.SSIC2020, "23939"), (Standards.ISIC4, "2393")),
        ((Standards.SSIC2020, "23940"), (Standards.ISIC4, "2394")),
        ((Standards.SSIC2020, "23951"), (Standards.ISIC4, "2395")),
        ((Standards.SSIC2020, "23959"), (Standards.ISIC4, "2395")),
        ((Standards.SSIC2020, "23960"), (Standards.ISIC4, "2396")),
        ((Standards.SSIC2020, "23991"), (Standards.ISIC4, "2399")),
        ((Standards.SSIC2020, "23992"), (Standards.ISIC4, "2399")),
        ((Standards.SSIC2020, "23993"), (Standards.ISIC4, "2399")),
        ((Standards.SSIC2020, "23994"), (Standards.ISIC4, "2399")),
        ((Standards.SSIC2020, "23995"), (Standards.ISIC4, "2399")),
        ((Standards.SSIC2020, "23999"), (Standards.ISIC4, "2399")),
        ((Standards.SSIC2020, "24101"), (Standards.ISIC4, "2410")),
        ((Standards.SSIC2020, "24102"), (Standards.ISIC4, "2410")),
        ((Standards.SSIC2020, "24109"), (Standards.ISIC4, "2410")),
        ((Standards.SSIC2020, "24201"), (Standards.ISIC4, "2420")),
        ((Standards.SSIC2020, "24202"), (Standards.ISIC4, "2420")),
        ((Standards.SSIC2020, "24209"), (Standards.ISIC4, "2420")),
        ((Standards.SSIC2020, "24310"), (Standards.ISIC4, "2431")),
        ((Standards.SSIC2020, "24310"), (Standards.ISIC4, "2591")),
        ((Standards.SSIC2020, "24320"), (Standards.ISIC4, "2432")),
        ((Standards.SSIC2020, "24320"), (Standards.ISIC4, "2591")),
        ((Standards.SSIC2020, "25111"), (Standards.ISIC4, "2511")),
        ((Standards.SSIC2020, "25112"), (Standards.ISIC4, "2511")),
        ((Standards.SSIC2020, "25113"), (Standards.ISIC4, "2511")),
        ((Standards.SSIC2020, "25113"), (Standards.ISIC4, "3311")),
        ((Standards.SSIC2020, "25114"), (Standards.ISIC4, "2511")),
        ((Standards.SSIC2020, "25119"), (Standards.ISIC4, "2511")),
        ((Standards.SSIC2020, "25120"), (Standards.ISIC4, "2512")),
        ((Standards.SSIC2020, "25120"), (Standards.ISIC4, "3311")),
        ((Standards.SSIC2020, "25131"), (Standards.ISIC4, "2513")),
        ((Standards.SSIC2020, "25131"), (Standards.ISIC4, "3311")),
        ((Standards.SSIC2020, "25139"), (Standards.ISIC4, "2513")),
        ((Standards.SSIC2020, "25139"), (Standards.ISIC4, "3311")),
        ((Standards.SSIC2020, "25200"), (Standards.ISIC4, "2520")),
        ((Standards.SSIC2020, "25200"), (Standards.ISIC4, "3311")),
        ((Standards.SSIC2020, "25911"), (Standards.ISIC4, "2591")),
        ((Standards.SSIC2020, "25912"), (Standards.ISIC4, "2591")),
        ((Standards.SSIC2020, "25913"), (Standards.ISIC4, "2591")),
        ((Standards.SSIC2020, "25914"), (Standards.ISIC4, "2591")),
        ((Standards.SSIC2020, "25919"), (Standards.ISIC4, "2591")),
        ((Standards.SSIC2020, "25921"), (Standards.ISIC4, "2592")),
        ((Standards.SSIC2020, "25922"), (Standards.ISIC4, "2592")),
        ((Standards.SSIC2020, "25923"), (Standards.ISIC4, "2592")),
        ((Standards.SSIC2020, "25924"), (Standards.ISIC4, "2592")),
        ((Standards.SSIC2020, "25929"), (Standards.ISIC4, "2592")),
        ((Standards.SSIC2020, "25931"), (Standards.ISIC4, "2593")),
        ((Standards.SSIC2020, "25932"), (Standards.ISIC4, "2593")),
        ((Standards.SSIC2020, "25939"), (Standards.ISIC4, "2593")),
        ((Standards.SSIC2020, "25941"), (Standards.ISIC4, "2599")),
        ((Standards.SSIC2020, "25949"), (Standards.ISIC4, "2599")),
        ((Standards.SSIC2020, "25951"), (Standards.ISIC4, "2599")),
        ((Standards.SSIC2020, "25952"), (Standards.ISIC4, "2599")),
        ((Standards.SSIC2020, "25959"), (Standards.ISIC4, "2599")),
        ((Standards.SSIC2020, "25991"), (Standards.ISIC4, "2599")),
        ((Standards.SSIC2020, "25992"), (Standards.ISIC4, "2599")),
        ((Standards.SSIC2020, "25993"), (Standards.ISIC4, "2599")),
        ((Standards.SSIC2020, "25994"), (Standards.ISIC4, "2599")),
        ((Standards.SSIC2020, "25995"), (Standards.ISIC4, "2599")),
        ((Standards.SSIC2020, "25996"), (Standards.ISIC4, "2599")),
        ((Standards.SSIC2020, "25997"), (Standards.ISIC4, "2599")),
        ((Standards.SSIC2020, "25998"), (Standards.ISIC4, "2599")),
        ((Standards.SSIC2020, "25999"), (Standards.ISIC4, "2599")),
        ((Standards.SSIC2020, "25999"), (Standards.ISIC4, "3311")),
        ((Standards.SSIC2020, "26111"), (Standards.ISIC4, "2610")),
        ((Standards.SSIC2020, "26112"), (Standards.ISIC4, "2610")),
        ((Standards.SSIC2020, "26113"), (Standards.ISIC4, "2610")),
        ((Standards.SSIC2020, "26114"), (Standards.ISIC4, "2610")),
        ((Standards.SSIC2020, "26115"), (Standards.ISIC4, "2610")),
        ((Standards.SSIC2020, "26119"), (Standards.ISIC4, "2610")),
        ((Standards.SSIC2020, "26121"), (Standards.ISIC4, "2610")),
        ((Standards.SSIC2020, "26122"), (Standards.ISIC4, "2610")),
        ((Standards.SSIC2020, "26123"), (Standards.ISIC4, "2610")),
        ((Standards.SSIC2020, "26124"), (Standards.ISIC4, "2610")),
        ((Standards.SSIC2020, "26125"), (Standards.ISIC4, "2610")),
        ((Standards.SSIC2020, "26126"), (Standards.ISIC4, "2610")),
        ((Standards.SSIC2020, "26129"), (Standards.ISIC4, "2610")),
        ((Standards.SSIC2020, "26201"), (Standards.ISIC4, "2620")),
        ((Standards.SSIC2020, "26202"), (Standards.ISIC4, "2620")),
        ((Standards.SSIC2020, "26203"), (Standards.ISIC4, "2620")),
        ((Standards.SSIC2020, "26204"), (Standards.ISIC4, "2620")),
        ((Standards.SSIC2020, "26209"), (Standards.ISIC4, "2620")),
        ((Standards.SSIC2020, "26301"), (Standards.ISIC4, "2630")),
        ((Standards.SSIC2020, "26302"), (Standards.ISIC4, "2630")),
        ((Standards.SSIC2020, "26303"), (Standards.ISIC4, "2630")),
        ((Standards.SSIC2020, "26304"), (Standards.ISIC4, "2630")),
        ((Standards.SSIC2020, "26309"), (Standards.ISIC4, "2630")),
        ((Standards.SSIC2020, "26400"), (Standards.ISIC4, "2640")),
        ((Standards.SSIC2020, "26511"), (Standards.ISIC4, "2651")),
        ((Standards.SSIC2020, "26511"), (Standards.ISIC4, "3313")),
        ((Standards.SSIC2020, "26512"), (Standards.ISIC4, "2651")),
        ((Standards.SSIC2020, "26512"), (Standards.ISIC4, "3313")),
        ((Standards.SSIC2020, "26513"), (Standards.ISIC4, "2651")),
        ((Standards.SSIC2020, "26513"), (Standards.ISIC4, "3313")),
        ((Standards.SSIC2020, "26521"), (Standards.ISIC4, "2652")),
        ((Standards.SSIC2020, "26522"), (Standards.ISIC4, "2652")),
        ((Standards.SSIC2020, "26523"), (Standards.ISIC4, "2652")),
        ((Standards.SSIC2020, "26524"), (Standards.ISIC4, "2652")),
        ((Standards.SSIC2020, "26601"), (Standards.ISIC4, "2660")),
        ((Standards.SSIC2020, "26601"), (Standards.ISIC4, "3313")),
        ((Standards.SSIC2020, "26602"), (Standards.ISIC4, "2660")),
        ((Standards.SSIC2020, "26602"), (Standards.ISIC4, "3313")),
        ((Standards.SSIC2020, "26701"), (Standards.ISIC4, "2670")),
        ((Standards.SSIC2020, "26701"), (Standards.ISIC4, "3313")),
        ((Standards.SSIC2020, "26709"), (Standards.ISIC4, "2670")),
        ((Standards.SSIC2020, "26709"), (Standards.ISIC4, "3313")),
        ((Standards.SSIC2020, "26801"), (Standards.ISIC4, "2680")),
        ((Standards.SSIC2020, "26802"), (Standards.ISIC4, "2680")),
        ((Standards.SSIC2020, "27101"), (Standards.ISIC4, "2710")),
        ((Standards.SSIC2020, "27101"), (Standards.ISIC4, "3314")),
        ((Standards.SSIC2020, "27102"), (Standards.ISIC4, "2710")),
        ((Standards.SSIC2020, "27102"), (Standards.ISIC4, "3314")),
        ((Standards.SSIC2020, "27103"), (Standards.ISIC4, "2710")),
        ((Standards.SSIC2020, "27103"), (Standards.ISIC4, "3314")),
        ((Standards.SSIC2020, "27104"), (Standards.ISIC4, "2710")),
        ((Standards.SSIC2020, "27104"), (Standards.ISIC4, "3314")),
        ((Standards.SSIC2020, "27109"), (Standards.ISIC4, "2710")),
        ((Standards.SSIC2020, "27109"), (Standards.ISIC4, "3314")),
        ((Standards.SSIC2020, "27201"), (Standards.ISIC4, "2720")),
        ((Standards.SSIC2020, "27201"), (Standards.ISIC4, "3314")),
        ((Standards.SSIC2020, "27202"), (Standards.ISIC4, "2720")),
        ((Standards.SSIC2020, "27202"), (Standards.ISIC4, "3314")),
        ((Standards.SSIC2020, "27321"), (Standards.ISIC4, "2731")),
        ((Standards.SSIC2020, "27321"), (Standards.ISIC4, "2732")),
        ((Standards.SSIC2020, "27321"), (Standards.ISIC4, "3314")),
        ((Standards.SSIC2020, "27322"), (Standards.ISIC4, "2732")),
        ((Standards.SSIC2020, "27322"), (Standards.ISIC4, "3314")),
        ((Standards.SSIC2020, "27323"), (Standards.ISIC4, "2732")),
        ((Standards.SSIC2020, "27323"), (Standards.ISIC4, "3314")),
        ((Standards.SSIC2020, "27324"), (Standards.ISIC4, "2732")),
        ((Standards.SSIC2020, "27324"), (Standards.ISIC4, "3314")),
        ((Standards.SSIC2020, "27329"), (Standards.ISIC4, "2732")),
        ((Standards.SSIC2020, "27329"), (Standards.ISIC4, "3314")),
        ((Standards.SSIC2020, "27330"), (Standards.ISIC4, "2733")),
        ((Standards.SSIC2020, "27330"), (Standards.ISIC4, "3314")),
        ((Standards.SSIC2020, "27400"), (Standards.ISIC4, "2740")),
        ((Standards.SSIC2020, "27400"), (Standards.ISIC4, "3314")),
        ((Standards.SSIC2020, "27501"), (Standards.ISIC4, "2750")),
        ((Standards.SSIC2020, "27509"), (Standards.ISIC4, "2750")),
        ((Standards.SSIC2020, "27901"), (Standards.ISIC4, "2790")),
        ((Standards.SSIC2020, "27902"), (Standards.ISIC4, "2790")),
        ((Standards.SSIC2020, "28111"), (Standards.ISIC4, "2811")),
        ((Standards.SSIC2020, "28111"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28112"), (Standards.ISIC4, "2811")),
        ((Standards.SSIC2020, "28112"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28121"), (Standards.ISIC4, "2812")),
        ((Standards.SSIC2020, "28121"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28122"), (Standards.ISIC4, "2813")),
        ((Standards.SSIC2020, "28122"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28129"), (Standards.ISIC4, "2813")),
        ((Standards.SSIC2020, "28129"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28141"), (Standards.ISIC4, "2814")),
        ((Standards.SSIC2020, "28142"), (Standards.ISIC4, "2814")),
        ((Standards.SSIC2020, "28142"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28150"), (Standards.ISIC4, "2815")),
        ((Standards.SSIC2020, "28150"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28161"), (Standards.ISIC4, "2816")),
        ((Standards.SSIC2020, "28161"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28162"), (Standards.ISIC4, "2816")),
        ((Standards.SSIC2020, "28162"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28169"), (Standards.ISIC4, "2816")),
        ((Standards.SSIC2020, "28169"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28171"), (Standards.ISIC4, "2817")),
        ((Standards.SSIC2020, "28171"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28172"), (Standards.ISIC4, "2817")),
        ((Standards.SSIC2020, "28172"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28181"), (Standards.ISIC4, "2816")),
        ((Standards.SSIC2020, "28181"), (Standards.ISIC4, "2829")),
        ((Standards.SSIC2020, "28181"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28182"), (Standards.ISIC4, "2816")),
        ((Standards.SSIC2020, "28182"), (Standards.ISIC4, "2829")),
        ((Standards.SSIC2020, "28182"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28189"), (Standards.ISIC4, "2816")),
        ((Standards.SSIC2020, "28189"), (Standards.ISIC4, "2829")),
        ((Standards.SSIC2020, "28189"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28191"), (Standards.ISIC4, "2819")),
        ((Standards.SSIC2020, "28191"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28192"), (Standards.ISIC4, "2819")),
        ((Standards.SSIC2020, "28192"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28192"), (Standards.ISIC4, "3319")),
        ((Standards.SSIC2020, "28193"), (Standards.ISIC4, "2819")),
        ((Standards.SSIC2020, "28193"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28194"), (Standards.ISIC4, "2819")),
        ((Standards.SSIC2020, "28194"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28194"), (Standards.ISIC4, "3319")),
        ((Standards.SSIC2020, "28195"), (Standards.ISIC4, "2819")),
        ((Standards.SSIC2020, "28195"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28195"), (Standards.ISIC4, "3319")),
        ((Standards.SSIC2020, "28199"), (Standards.ISIC4, "2818")),
        ((Standards.SSIC2020, "28199"), (Standards.ISIC4, "2819")),
        ((Standards.SSIC2020, "28199"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28199"), (Standards.ISIC4, "3319")),
        ((Standards.SSIC2020, "28210"), (Standards.ISIC4, "2821")),
        ((Standards.SSIC2020, "28210"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28221"), (Standards.ISIC4, "2822")),
        ((Standards.SSIC2020, "28221"), (Standards.ISIC4, "2823")),
        ((Standards.SSIC2020, "28221"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28222"), (Standards.ISIC4, "2822")),
        ((Standards.SSIC2020, "28222"), (Standards.ISIC4, "2823")),
        ((Standards.SSIC2020, "28222"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28223"), (Standards.ISIC4, "2822")),
        ((Standards.SSIC2020, "28223"), (Standards.ISIC4, "2823")),
        ((Standards.SSIC2020, "28223"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28224"), (Standards.ISIC4, "2822")),
        ((Standards.SSIC2020, "28224"), (Standards.ISIC4, "2823")),
        ((Standards.SSIC2020, "28224"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28225"), (Standards.ISIC4, "2822")),
        ((Standards.SSIC2020, "28225"), (Standards.ISIC4, "2823")),
        ((Standards.SSIC2020, "28225"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28229"), (Standards.ISIC4, "2822")),
        ((Standards.SSIC2020, "28229"), (Standards.ISIC4, "2823")),
        ((Standards.SSIC2020, "28229"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28241"), (Standards.ISIC4, "2824")),
        ((Standards.SSIC2020, "28241"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28242"), (Standards.ISIC4, "2824")),
        ((Standards.SSIC2020, "28242"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28243"), (Standards.ISIC4, "2824")),
        ((Standards.SSIC2020, "28243"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28249"), (Standards.ISIC4, "2824")),
        ((Standards.SSIC2020, "28249"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28251"), (Standards.ISIC4, "2825")),
        ((Standards.SSIC2020, "28251"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28252"), (Standards.ISIC4, "2825")),
        ((Standards.SSIC2020, "28252"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28253"), (Standards.ISIC4, "2825")),
        ((Standards.SSIC2020, "28253"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28260"), (Standards.ISIC4, "2826")),
        ((Standards.SSIC2020, "28260"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28271"), (Standards.ISIC4, "2829")),
        ((Standards.SSIC2020, "28271"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28272"), (Standards.ISIC4, "2829")),
        ((Standards.SSIC2020, "28272"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28273"), (Standards.ISIC4, "2829")),
        ((Standards.SSIC2020, "28273"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28274"), (Standards.ISIC4, "2829")),
        ((Standards.SSIC2020, "28274"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28291"), (Standards.ISIC4, "2829")),
        ((Standards.SSIC2020, "28291"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28292"), (Standards.ISIC4, "2829")),
        ((Standards.SSIC2020, "28292"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28293"), (Standards.ISIC4, "2829")),
        ((Standards.SSIC2020, "28293"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28294"), (Standards.ISIC4, "2829")),
        ((Standards.SSIC2020, "28294"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28299"), (Standards.ISIC4, "2829")),
        ((Standards.SSIC2020, "28299"), (Standards.ISIC4, "3312")),
        ((Standards.SSIC2020, "28300"), (Standards.ISIC4, "3320")),
        ((Standards.SSIC2020, "29100"), (Standards.ISIC4, "2910")),
        ((Standards.SSIC2020, "29200"), (Standards.ISIC4, "2920")),
        ((Standards.SSIC2020, "29300"), (Standards.ISIC4, "2930")),
        ((Standards.SSIC2020, "30110"), (Standards.ISIC4, "3011")),
        ((Standards.SSIC2020, "30110"), (Standards.ISIC4, "3315")),
        ((Standards.SSIC2020, "30120"), (Standards.ISIC4, "3012")),
        ((Standards.SSIC2020, "30120"), (Standards.ISIC4, "3315")),
        ((Standards.SSIC2020, "30200"), (Standards.ISIC4, "3020")),
        ((Standards.SSIC2020, "30200"), (Standards.ISIC4, "3315")),
        ((Standards.SSIC2020, "30301"), (Standards.ISIC4, "3030")),
        ((Standards.SSIC2020, "30302"), (Standards.ISIC4, "3030")),
        ((Standards.SSIC2020, "30302"), (Standards.ISIC4, "3315")),
        ((Standards.SSIC2020, "30400"), (Standards.ISIC4, "3040")),
        ((Standards.SSIC2020, "30400"), (Standards.ISIC4, "3315")),
        ((Standards.SSIC2020, "30910"), (Standards.ISIC4, "3091")),
        ((Standards.SSIC2020, "30920"), (Standards.ISIC4, "3092")),
        ((Standards.SSIC2020, "30990"), (Standards.ISIC4, "3099")),
        ((Standards.SSIC2020, "31001"), (Standards.ISIC4, "3100")),
        ((Standards.SSIC2020, "31002"), (Standards.ISIC4, "3100")),
        ((Standards.SSIC2020, "31003"), (Standards.ISIC4, "3100")),
        ((Standards.SSIC2020, "31004"), (Standards.ISIC4, "3100")),
        ((Standards.SSIC2020, "31005"), (Standards.ISIC4, "3100")),
        ((Standards.SSIC2020, "31006"), (Standards.ISIC4, "3100")),
        ((Standards.SSIC2020, "31009"), (Standards.ISIC4, "3100")),
        ((Standards.SSIC2020, "32111"), (Standards.ISIC4, "3211")),
        ((Standards.SSIC2020, "32112"), (Standards.ISIC4, "3211")),
        ((Standards.SSIC2020, "32119"), (Standards.ISIC4, "3211")),
        ((Standards.SSIC2020, "32120"), (Standards.ISIC4, "3212")),
        ((Standards.SSIC2020, "32200"), (Standards.ISIC4, "3220")),
        ((Standards.SSIC2020, "32300"), (Standards.ISIC4, "3230")),
        ((Standards.SSIC2020, "32400"), (Standards.ISIC4, "3240")),
        ((Standards.SSIC2020, "32501"), (Standards.ISIC4, "2660")),
        ((Standards.SSIC2020, "32501"), (Standards.ISIC4, "3250")),
        ((Standards.SSIC2020, "32502"), (Standards.ISIC4, "3250")),
        ((Standards.SSIC2020, "32503"), (Standards.ISIC4, "3250")),
        ((Standards.SSIC2020, "32504"), (Standards.ISIC4, "3250")),
        ((Standards.SSIC2020, "32509"), (Standards.ISIC4, "3250")),
        ((Standards.SSIC2020, "32901"), (Standards.ISIC4, "3290")),
        ((Standards.SSIC2020, "32909"), (Standards.ISIC4, "3290")),
        ((Standards.SSIC2020, "35101"), (Standards.ISIC4, "3510")),
        ((Standards.SSIC2020, "35102"), (Standards.ISIC4, "3510")),
        ((Standards.SSIC2020, "35103"), (Standards.ISIC4, "3510")),
        ((Standards.SSIC2020, "35104"), (Standards.ISIC4, "3510")),
        ((Standards.SSIC2020, "35201"), (Standards.ISIC4, "3520")),
        ((Standards.SSIC2020, "35201"), (Standards.ISIC4, "5221")),
        ((Standards.SSIC2020, "35202"), (Standards.ISIC4, "3520")),
        ((Standards.SSIC2020, "35203"), (Standards.ISIC4, "3520")),
        ((Standards.SSIC2020, "35300"), (Standards.ISIC4, "3530")),
        ((Standards.SSIC2020, "36000"), (Standards.ISIC4, "3600")),
        ((Standards.SSIC2020, "37000"), (Standards.ISIC4, "3700")),
        ((Standards.SSIC2020, "38100"), (Standards.ISIC4, "3811")),
        ((Standards.SSIC2020, "38100"), (Standards.ISIC4, "3812")),
        ((Standards.SSIC2020, "38200"), (Standards.ISIC4, "3821")),
        ((Standards.SSIC2020, "38200"), (Standards.ISIC4, "3822")),
        ((Standards.SSIC2020, "38200"), (Standards.ISIC4, "3900")),
        ((Standards.SSIC2020, "38301"), (Standards.ISIC4, "3830")),
        ((Standards.SSIC2020, "38309"), (Standards.ISIC4, "3830")),
        ((Standards.SSIC2020, "41001"), (Standards.ISIC4, "4100")),
        ((Standards.SSIC2020, "41002"), (Standards.ISIC4, "4100")),
        ((Standards.SSIC2020, "41009"), (Standards.ISIC4, "4100")),
        ((Standards.SSIC2020, "42101"), (Standards.ISIC4, "4210")),
        ((Standards.SSIC2020, "42102"), (Standards.ISIC4, "4210")),
        ((Standards.SSIC2020, "42103"), (Standards.ISIC4, "4210")),
        ((Standards.SSIC2020, "42201"), (Standards.ISIC4, "4220")),
        ((Standards.SSIC2020, "42202"), (Standards.ISIC4, "4220")),
        ((Standards.SSIC2020, "42901"), (Standards.ISIC4, "4290")),
        ((Standards.SSIC2020, "42902"), (Standards.ISIC4, "4290")),
        ((Standards.SSIC2020, "42903"), (Standards.ISIC4, "4290")),
        ((Standards.SSIC2020, "42909"), (Standards.ISIC4, "4290")),
        ((Standards.SSIC2020, "43110"), (Standards.ISIC4, "4311")),
        ((Standards.SSIC2020, "43121"), (Standards.ISIC4, "4312")),
        ((Standards.SSIC2020, "43122"), (Standards.ISIC4, "4312")),
        ((Standards.SSIC2020, "43129"), (Standards.ISIC4, "4312")),
        ((Standards.SSIC2020, "43210"), (Standards.ISIC4, "4321")),
        ((Standards.SSIC2020, "43220"), (Standards.ISIC4, "4322")),
        ((Standards.SSIC2020, "43291"), (Standards.ISIC4, "4329")),
        ((Standards.SSIC2020, "43292"), (Standards.ISIC4, "4329")),
        ((Standards.SSIC2020, "43293"), (Standards.ISIC4, "4329")),
        ((Standards.SSIC2020, "43294"), (Standards.ISIC4, "4329")),
        ((Standards.SSIC2020, "43295"), (Standards.ISIC4, "4329")),
        ((Standards.SSIC2020, "43296"), (Standards.ISIC4, "4329")),
        ((Standards.SSIC2020, "43299"), (Standards.ISIC4, "4329")),
        ((Standards.SSIC2020, "43301"), (Standards.ISIC4, "4330")),
        ((Standards.SSIC2020, "43302"), (Standards.ISIC4, "4330")),
        ((Standards.SSIC2020, "43303"), (Standards.ISIC4, "4330")),
        ((Standards.SSIC2020, "43304"), (Standards.ISIC4, "4330")),
        ((Standards.SSIC2020, "43305"), (Standards.ISIC4, "4330")),
        ((Standards.SSIC2020, "43306"), (Standards.ISIC4, "4330")),
        ((Standards.SSIC2020, "43307"), (Standards.ISIC4, "4330")),
        ((Standards.SSIC2020, "43309"), (Standards.ISIC4, "4330")),
        ((Standards.SSIC2020, "43901"), (Standards.ISIC4, "4390")),
        ((Standards.SSIC2020, "43902"), (Standards.ISIC4, "4390")),
        ((Standards.SSIC2020, "43903"), (Standards.ISIC4, "4390")),
        ((Standards.SSIC2020, "43904"), (Standards.ISIC4, "1622")),
        ((Standards.SSIC2020, "43904"), (Standards.ISIC4, "2395")),
        ((Standards.SSIC2020, "43904"), (Standards.ISIC4, "2511")),
        ((Standards.SSIC2020, "43904"), (Standards.ISIC4, "4390")),
        ((Standards.SSIC2020, "43905"), (Standards.ISIC4, "4390")),
        ((Standards.SSIC2020, "43906"), (Standards.ISIC4, "4390")),
        ((Standards.SSIC2020, "43907"), (Standards.ISIC4, "1622")),
        ((Standards.SSIC2020, "43907"), (Standards.ISIC4, "2395")),
        ((Standards.SSIC2020, "43907"), (Standards.ISIC4, "2511")),
        ((Standards.SSIC2020, "43907"), (Standards.ISIC4, "4390")),
        ((Standards.SSIC2020, "43909"), (Standards.ISIC4, "4390")),
        ((Standards.SSIC2020, "46100"), (Standards.ISIC4, "4610")),
        ((Standards.SSIC2020, "46211"), (Standards.ISIC4, "4620")),
        ((Standards.SSIC2020, "46212"), (Standards.ISIC4, "4620")),
        ((Standards.SSIC2020, "46213"), (Standards.ISIC4, "4620")),
        ((Standards.SSIC2020, "46219"), (Standards.ISIC4, "4620")),
        ((Standards.SSIC2020, "46219"), (Standards.ISIC4, "4669")),
        ((Standards.SSIC2020, "46221"), (Standards.ISIC4, "4669")),
        ((Standards.SSIC2020, "46222"), (Standards.ISIC4, "4630")),
        ((Standards.SSIC2020, "46223"), (Standards.ISIC4, "4630")),
        ((Standards.SSIC2020, "46224"), (Standards.ISIC4, "4630")),
        ((Standards.SSIC2020, "46225"), (Standards.ISIC4, "4630")),
        ((Standards.SSIC2020, "46229"), (Standards.ISIC4, "4620")),
        ((Standards.SSIC2020, "46229"), (Standards.ISIC4, "4669")),
        ((Standards.SSIC2020, "46301"), (Standards.ISIC4, "4630")),
        ((Standards.SSIC2020, "46302"), (Standards.ISIC4, "4630")),
        ((Standards.SSIC2020, "46303"), (Standards.ISIC4, "4630")),
        ((Standards.SSIC2020, "46304"), (Standards.ISIC4, "4630")),
        ((Standards.SSIC2020, "46305"), (Standards.ISIC4, "4630")),
        ((Standards.SSIC2020, "46306"), (Standards.ISIC4, "4630")),
        ((Standards.SSIC2020, "46307"), (Standards.ISIC4, "4630")),
        ((Standards.SSIC2020, "46308"), (Standards.ISIC4, "4630")),
        ((Standards.SSIC2020, "46309"), (Standards.ISIC4, "4630")),
        ((Standards.SSIC2020, "46411"), (Standards.ISIC4, "4620")),
        ((Standards.SSIC2020, "46411"), (Standards.ISIC4, "4641")),
        ((Standards.SSIC2020, "46411"), (Standards.ISIC4, "4669")),
        ((Standards.SSIC2020, "46412"), (Standards.ISIC4, "4641")),
        ((Standards.SSIC2020, "46413"), (Standards.ISIC4, "4641")),
        ((Standards.SSIC2020, "46414"), (Standards.ISIC4, "4641")),
        ((Standards.SSIC2020, "46415"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46416"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46421"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46422"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46423"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46424"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46429"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46431"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46432"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46433"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46434"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46435"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46436"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46437"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46439"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46441"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46442"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46443"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46444"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46449"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46451"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46452"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46453"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46459"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46461"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46462"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46471"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46472"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46473"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46474"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46479"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46491"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46492"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46499"), (Standards.ISIC4, "4649")),
        ((Standards.SSIC2020, "46499"), (Standards.ISIC4, "4669")),
        ((Standards.SSIC2020, "46511"), (Standards.ISIC4, "4651")),
        ((Standards.SSIC2020, "46512"), (Standards.ISIC4, "4651")),
        ((Standards.SSIC2020, "46513"), (Standards.ISIC4, "4651")),
        ((Standards.SSIC2020, "46514"), (Standards.ISIC4, "4651")),
        ((Standards.SSIC2020, "46521"), (Standards.ISIC4, "4652")),
        ((Standards.SSIC2020, "46522"), (Standards.ISIC4, "4652")),
        ((Standards.SSIC2020, "46523"), (Standards.ISIC4, "4652")),
        ((Standards.SSIC2020, "46530"), (Standards.ISIC4, "4653")),
        ((Standards.SSIC2020, "46541"), (Standards.ISIC4, "4659")),
        ((Standards.SSIC2020, "46542"), (Standards.ISIC4, "4659")),
        ((Standards.SSIC2020, "46543"), (Standards.ISIC4, "4659")),
        ((Standards.SSIC2020, "46544"), (Standards.ISIC4, "4659")),
        ((Standards.SSIC2020, "46549"), (Standards.ISIC4, "4659")),
        ((Standards.SSIC2020, "46551"), (Standards.ISIC4, "4659")),
        ((Standards.SSIC2020, "46552"), (Standards.ISIC4, "4659")),
        ((Standards.SSIC2020, "46559"), (Standards.ISIC4, "4659")),
        ((Standards.SSIC2020, "46561"), (Standards.ISIC4, "4510")),
        ((Standards.SSIC2020, "46562"), (Standards.ISIC4, "4540")),
        ((Standards.SSIC2020, "46563"), (Standards.ISIC4, "4530")),
        ((Standards.SSIC2020, "46591"), (Standards.ISIC4, "4659")),
        ((Standards.SSIC2020, "46592"), (Standards.ISIC4, "4659")),
        ((Standards.SSIC2020, "46593"), (Standards.ISIC4, "4659")),
        ((Standards.SSIC2020, "46594"), (Standards.ISIC4, "4659")),
        ((Standards.SSIC2020, "46595"), (Standards.ISIC4, "4659")),
        ((Standards.SSIC2020, "46599"), (Standards.ISIC4, "4659")),
        ((Standards.SSIC2020, "46610"), (Standards.ISIC4, "4661")),
        ((Standards.SSIC2020, "46620"), (Standards.ISIC4, "4662")),
        ((Standards.SSIC2020, "46631"), (Standards.ISIC4, "4663")),
        ((Standards.SSIC2020, "46632"), (Standards.ISIC4, "4663")),
        ((Standards.SSIC2020, "46633"), (Standards.ISIC4, "4663")),
        ((Standards.SSIC2020, "46634"), (Standards.ISIC4, "4663")),
        ((Standards.SSIC2020, "46635"), (Standards.ISIC4, "4663")),
        ((Standards.SSIC2020, "46639"), (Standards.ISIC4, "4663")),
        ((Standards.SSIC2020, "46641"), (Standards.ISIC4, "4669")),
        ((Standards.SSIC2020, "46642"), (Standards.ISIC4, "4669")),
        ((Standards.SSIC2020, "46643"), (Standards.ISIC4, "4669")),
        ((Standards.SSIC2020, "46649"), (Standards.ISIC4, "4669")),
        ((Standards.SSIC2020, "46651"), (Standards.ISIC4, "4669")),
        ((Standards.SSIC2020, "46659"), (Standards.ISIC4, "4669")),
        ((Standards.SSIC2020, "46661"), (Standards.ISIC4, "4669")),
        ((Standards.SSIC2020, "46662"), (Standards.ISIC4, "4669")),
        ((Standards.SSIC2020, "46900"), (Standards.ISIC4, "4690")),
        ((Standards.SSIC2020, "47101"), (Standards.ISIC4, "4711")),
        ((Standards.SSIC2020, "47101"), (Standards.ISIC4, "4719")),
        ((Standards.SSIC2020, "47101"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47101"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47102"), (Standards.ISIC4, "4711")),
        ((Standards.SSIC2020, "47102"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47102"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47103"), (Standards.ISIC4, "4719")),
        ((Standards.SSIC2020, "47103"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47103"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47109"), (Standards.ISIC4, "4719")),
        ((Standards.SSIC2020, "47109"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47109"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47211"), (Standards.ISIC4, "4721")),
        ((Standards.SSIC2020, "47211"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47211"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47212"), (Standards.ISIC4, "4721")),
        ((Standards.SSIC2020, "47212"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47212"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47213"), (Standards.ISIC4, "4721")),
        ((Standards.SSIC2020, "47213"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47213"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47214"), (Standards.ISIC4, "4721")),
        ((Standards.SSIC2020, "47214"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47214"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47219"), (Standards.ISIC4, "4721")),
        ((Standards.SSIC2020, "47219"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47219"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47220"), (Standards.ISIC4, "4722")),
        ((Standards.SSIC2020, "47220"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47220"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47230"), (Standards.ISIC4, "4723")),
        ((Standards.SSIC2020, "47230"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47230"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47311"), (Standards.ISIC4, "4510")),
        ((Standards.SSIC2020, "47311"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47311"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47312"), (Standards.ISIC4, "4540")),
        ((Standards.SSIC2020, "47312"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47312"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47313"), (Standards.ISIC4, "4530")),
        ((Standards.SSIC2020, "47313"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47313"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47314"), (Standards.ISIC4, "4530")),
        ((Standards.SSIC2020, "47314"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47314"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47320"), (Standards.ISIC4, "4730")),
        ((Standards.SSIC2020, "47320"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47320"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47411"), (Standards.ISIC4, "4741")),
        ((Standards.SSIC2020, "47411"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47411"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47412"), (Standards.ISIC4, "4741")),
        ((Standards.SSIC2020, "47412"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47412"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47413"), (Standards.ISIC4, "4741")),
        ((Standards.SSIC2020, "47413"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47413"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47414"), (Standards.ISIC4, "4741")),
        ((Standards.SSIC2020, "47414"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47414"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47415"), (Standards.ISIC4, "4741")),
        ((Standards.SSIC2020, "47415"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47415"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47420"), (Standards.ISIC4, "4742")),
        ((Standards.SSIC2020, "47420"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47420"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47510"), (Standards.ISIC4, "4751")),
        ((Standards.SSIC2020, "47510"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47510"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47521"), (Standards.ISIC4, "4752")),
        ((Standards.SSIC2020, "47521"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47521"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47522"), (Standards.ISIC4, "4752")),
        ((Standards.SSIC2020, "47522"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47522"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47529"), (Standards.ISIC4, "4752")),
        ((Standards.SSIC2020, "47529"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47529"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47531"), (Standards.ISIC4, "4759")),
        ((Standards.SSIC2020, "47531"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47531"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47532"), (Standards.ISIC4, "4753")),
        ((Standards.SSIC2020, "47532"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47532"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47533"), (Standards.ISIC4, "4759")),
        ((Standards.SSIC2020, "47533"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47533"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47534"), (Standards.ISIC4, "4759")),
        ((Standards.SSIC2020, "47534"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47534"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47535"), (Standards.ISIC4, "4759")),
        ((Standards.SSIC2020, "47535"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47535"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47536"), (Standards.ISIC4, "4759")),
        ((Standards.SSIC2020, "47536"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47536"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47537"), (Standards.ISIC4, "4759")),
        ((Standards.SSIC2020, "47537"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47537"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47539"), (Standards.ISIC4, "4759")),
        ((Standards.SSIC2020, "47539"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47539"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47610"), (Standards.ISIC4, "4761")),
        ((Standards.SSIC2020, "47610"), (Standards.ISIC4, "4774")),
        ((Standards.SSIC2020, "47610"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47610"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47620"), (Standards.ISIC4, "4762")),
        ((Standards.SSIC2020, "47620"), (Standards.ISIC4, "4774")),
        ((Standards.SSIC2020, "47620"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47620"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47630"), (Standards.ISIC4, "4763")),
        ((Standards.SSIC2020, "47630"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47630"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47640"), (Standards.ISIC4, "4764")),
        ((Standards.SSIC2020, "47640"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47640"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47711"), (Standards.ISIC4, "4771")),
        ((Standards.SSIC2020, "47711"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47711"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47712"), (Standards.ISIC4, "4771")),
        ((Standards.SSIC2020, "47712"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47712"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47713"), (Standards.ISIC4, "4771")),
        ((Standards.SSIC2020, "47713"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47713"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47714"), (Standards.ISIC4, "4771")),
        ((Standards.SSIC2020, "47714"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47714"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47715"), (Standards.ISIC4, "4771")),
        ((Standards.SSIC2020, "47715"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47715"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47719"), (Standards.ISIC4, "4771")),
        ((Standards.SSIC2020, "47719"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47719"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47721"), (Standards.ISIC4, "4772")),
        ((Standards.SSIC2020, "47721"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47721"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47722"), (Standards.ISIC4, "4772")),
        ((Standards.SSIC2020, "47722"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47722"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47723"), (Standards.ISIC4, "4772")),
        ((Standards.SSIC2020, "47723"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47723"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47729"), (Standards.ISIC4, "4772")),
        ((Standards.SSIC2020, "47729"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47729"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47731"), (Standards.ISIC4, "4773")),
        ((Standards.SSIC2020, "47731"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47731"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47732"), (Standards.ISIC4, "4773")),
        ((Standards.SSIC2020, "47732"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47732"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47733"), (Standards.ISIC4, "4773")),
        ((Standards.SSIC2020, "47733"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47733"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47739"), (Standards.ISIC4, "4773")),
        ((Standards.SSIC2020, "47739"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47739"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47741"), (Standards.ISIC4, "4773")),
        ((Standards.SSIC2020, "47741"), (Standards.ISIC4, "4774")),
        ((Standards.SSIC2020, "47741"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47741"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47742"), (Standards.ISIC4, "4773")),
        ((Standards.SSIC2020, "47742"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47742"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47743"), (Standards.ISIC4, "4773")),
        ((Standards.SSIC2020, "47743"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47743"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47744"), (Standards.ISIC4, "4773")),
        ((Standards.SSIC2020, "47744"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47744"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47745"), (Standards.ISIC4, "4773")),
        ((Standards.SSIC2020, "47745"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47745"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47746"), (Standards.ISIC4, "4773")),
        ((Standards.SSIC2020, "47746"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47746"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47749"), (Standards.ISIC4, "4773")),
        ((Standards.SSIC2020, "47749"), (Standards.ISIC4, "4774")),
        ((Standards.SSIC2020, "47749"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47749"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47751"), (Standards.ISIC4, "4773")),
        ((Standards.SSIC2020, "47751"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47751"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47752"), (Standards.ISIC4, "4773")),
        ((Standards.SSIC2020, "47752"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47752"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47759"), (Standards.ISIC4, "4773")),
        ((Standards.SSIC2020, "47759"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47759"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47761"), (Standards.ISIC4, "4773")),
        ((Standards.SSIC2020, "47761"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47761"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47762"), (Standards.ISIC4, "4773")),
        ((Standards.SSIC2020, "47762"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47762"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47769"), (Standards.ISIC4, "4773")),
        ((Standards.SSIC2020, "47769"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47769"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47770"), (Standards.ISIC4, "4774")),
        ((Standards.SSIC2020, "47770"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "47770"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "47801"), (Standards.ISIC4, "4781")),
        ((Standards.SSIC2020, "47802"), (Standards.ISIC4, "4781")),
        ((Standards.SSIC2020, "47802"), (Standards.ISIC4, "4782")),
        ((Standards.SSIC2020, "47802"), (Standards.ISIC4, "4789")),
        ((Standards.SSIC2020, "49101"), (Standards.ISIC4, "4911")),
        ((Standards.SSIC2020, "49101"), (Standards.ISIC4, "4912")),
        ((Standards.SSIC2020, "49102"), (Standards.ISIC4, "4911")),
        ((Standards.SSIC2020, "49211"), (Standards.ISIC4, "4921")),
        ((Standards.SSIC2020, "49212"), (Standards.ISIC4, "4922")),
        ((Standards.SSIC2020, "49213"), (Standards.ISIC4, "4922")),
        ((Standards.SSIC2020, "49214"), (Standards.ISIC4, "4921")),
        ((Standards.SSIC2020, "49214"), (Standards.ISIC4, "4922")),
        ((Standards.SSIC2020, "49215"), (Standards.ISIC4, "4922")),
        ((Standards.SSIC2020, "49220"), (Standards.ISIC4, "4922")),
        ((Standards.SSIC2020, "49231"), (Standards.ISIC4, "4923")),
        ((Standards.SSIC2020, "49232"), (Standards.ISIC4, "4923")),
        ((Standards.SSIC2020, "49233"), (Standards.ISIC4, "4923")),
        ((Standards.SSIC2020, "49300"), (Standards.ISIC4, "4930")),
        ((Standards.SSIC2020, "50011"), (Standards.ISIC4, "5011")),
        ((Standards.SSIC2020, "50012"), (Standards.ISIC4, "5011")),
        ((Standards.SSIC2020, "50012"), (Standards.ISIC4, "5021")),
        ((Standards.SSIC2020, "50013"), (Standards.ISIC4, "5011")),
        ((Standards.SSIC2020, "50013"), (Standards.ISIC4, "5021")),
        ((Standards.SSIC2020, "50014"), (Standards.ISIC4, "5011")),
        ((Standards.SSIC2020, "50014"), (Standards.ISIC4, "5021")),
        ((Standards.SSIC2020, "50021"), (Standards.ISIC4, "5012")),
        ((Standards.SSIC2020, "50021"), (Standards.ISIC4, "5022")),
        ((Standards.SSIC2020, "50022"), (Standards.ISIC4, "5012")),
        ((Standards.SSIC2020, "50022"), (Standards.ISIC4, "5022")),
        ((Standards.SSIC2020, "50023"), (Standards.ISIC4, "5012")),
        ((Standards.SSIC2020, "51001"), (Standards.ISIC4, "5110")),
        ((Standards.SSIC2020, "51002"), (Standards.ISIC4, "5120")),
        ((Standards.SSIC2020, "51003"), (Standards.ISIC4, "5110")),
        ((Standards.SSIC2020, "51004"), (Standards.ISIC4, "5120")),
        ((Standards.SSIC2020, "51005"), (Standards.ISIC4, "5110")),
        ((Standards.SSIC2020, "51005"), (Standards.ISIC4, "5120")),
        ((Standards.SSIC2020, "52101"), (Standards.ISIC4, "5210")),
        ((Standards.SSIC2020, "52102"), (Standards.ISIC4, "5210")),
        ((Standards.SSIC2020, "52103"), (Standards.ISIC4, "5210")),
        ((Standards.SSIC2020, "52109"), (Standards.ISIC4, "5210")),
        ((Standards.SSIC2020, "52211"), (Standards.ISIC4, "5221")),
        ((Standards.SSIC2020, "52212"), (Standards.ISIC4, "5221")),
        ((Standards.SSIC2020, "52219"), (Standards.ISIC4, "5221")),
        ((Standards.SSIC2020, "52221"), (Standards.ISIC4, "5222")),
        ((Standards.SSIC2020, "52222"), (Standards.ISIC4, "5222")),
        ((Standards.SSIC2020, "52223"), (Standards.ISIC4, "5222")),
        ((Standards.SSIC2020, "52224"), (Standards.ISIC4, "5222")),
        ((Standards.SSIC2020, "52225"), (Standards.ISIC4, "5222")),
        ((Standards.SSIC2020, "52226"), (Standards.ISIC4, "5222")),
        ((Standards.SSIC2020, "52227"), (Standards.ISIC4, "5222")),
        ((Standards.SSIC2020, "52229"), (Standards.ISIC4, "5222")),
        ((Standards.SSIC2020, "52231"), (Standards.ISIC4, "5223")),
        ((Standards.SSIC2020, "52232"), (Standards.ISIC4, "5223")),
        ((Standards.SSIC2020, "52233"), (Standards.ISIC4, "5223")),
        ((Standards.SSIC2020, "52234"), (Standards.ISIC4, "5223")),
        ((Standards.SSIC2020, "52239"), (Standards.ISIC4, "5223")),
        ((Standards.SSIC2020, "52241"), (Standards.ISIC4, "5224")),
        ((Standards.SSIC2020, "52242"), (Standards.ISIC4, "5224")),
        ((Standards.SSIC2020, "52243"), (Standards.ISIC4, "5224")),
        ((Standards.SSIC2020, "52251"), (Standards.ISIC4, "7490")),
        ((Standards.SSIC2020, "52252"), (Standards.ISIC4, "7490")),
        ((Standards.SSIC2020, "52291"), (Standards.ISIC4, "5224")),
        ((Standards.SSIC2020, "52292"), (Standards.ISIC4, "5229")),
        ((Standards.SSIC2020, "53100"), (Standards.ISIC4, "5310")),
        ((Standards.SSIC2020, "53200"), (Standards.ISIC4, "5320")),
        ((Standards.SSIC2020, "55101"), (Standards.ISIC4, "5510")),
        ((Standards.SSIC2020, "55102"), (Standards.ISIC4, "5510")),
        ((Standards.SSIC2020, "55103"), (Standards.ISIC4, "5510")),
        ((Standards.SSIC2020, "55900"), (Standards.ISIC4, "5520")),
        ((Standards.SSIC2020, "55900"), (Standards.ISIC4, "5590")),
        ((Standards.SSIC2020, "56111"), (Standards.ISIC4, "5610")),
        ((Standards.SSIC2020, "56112"), (Standards.ISIC4, "5610")),
        ((Standards.SSIC2020, "56112"), (Standards.ISIC4, "5630")),
        ((Standards.SSIC2020, "56121"), (Standards.ISIC4, "5610")),
        ((Standards.SSIC2020, "56121"), (Standards.ISIC4, "5630")),
        ((Standards.SSIC2020, "56122"), (Standards.ISIC4, "5610")),
        ((Standards.SSIC2020, "56122"), (Standards.ISIC4, "5629")),
        ((Standards.SSIC2020, "56122"), (Standards.ISIC4, "5630")),
        ((Standards.SSIC2020, "56123"), (Standards.ISIC4, "5610")),
        ((Standards.SSIC2020, "56123"), (Standards.ISIC4, "5630")),
        ((Standards.SSIC2020, "56130"), (Standards.ISIC4, "5630")),
        ((Standards.SSIC2020, "56140"), (Standards.ISIC4, "5610")),
        ((Standards.SSIC2020, "56140"), (Standards.ISIC4, "5630")),
        ((Standards.SSIC2020, "56200"), (Standards.ISIC4, "5621")),
        ((Standards.SSIC2020, "56200"), (Standards.ISIC4, "5629")),
        ((Standards.SSIC2020, "58110"), (Standards.ISIC4, "5811")),
        ((Standards.SSIC2020, "58110"), (Standards.ISIC4, "5920")),
        ((Standards.SSIC2020, "58120"), (Standards.ISIC4, "5812")),
        ((Standards.SSIC2020, "58131"), (Standards.ISIC4, "5813")),
        ((Standards.SSIC2020, "58132"), (Standards.ISIC4, "5813")),
        ((Standards.SSIC2020, "58190"), (Standards.ISIC4, "5819")),
        ((Standards.SSIC2020, "58201"), (Standards.ISIC4, "5820")),
        ((Standards.SSIC2020, "58202"), (Standards.ISIC4, "5820")),
        ((Standards.SSIC2020, "59111"), (Standards.ISIC4, "5911")),
        ((Standards.SSIC2020, "59112"), (Standards.ISIC4, "5911")),
        ((Standards.SSIC2020, "59113"), (Standards.ISIC4, "5911")),
        ((Standards.SSIC2020, "59114"), (Standards.ISIC4, "5911")),
        ((Standards.SSIC2020, "59119"), (Standards.ISIC4, "5911")),
        ((Standards.SSIC2020, "59120"), (Standards.ISIC4, "5912")),
        ((Standards.SSIC2020, "59131"), (Standards.ISIC4, "5913")),
        ((Standards.SSIC2020, "59132"), (Standards.ISIC4, "5913")),
        ((Standards.SSIC2020, "59139"), (Standards.ISIC4, "5913")),
        ((Standards.SSIC2020, "59140"), (Standards.ISIC4, "5914")),
        ((Standards.SSIC2020, "59201"), (Standards.ISIC4, "5920")),
        ((Standards.SSIC2020, "59202"), (Standards.ISIC4, "5920")),
        ((Standards.SSIC2020, "60100"), (Standards.ISIC4, "6010")),
        ((Standards.SSIC2020, "60200"), (Standards.ISIC4, "6020")),
        ((Standards.SSIC2020, "61011"), (Standards.ISIC4, "6110")),
        ((Standards.SSIC2020, "61012"), (Standards.ISIC4, "6120")),
        ((Standards.SSIC2020, "61013"), (Standards.ISIC4, "6130")),
        ((Standards.SSIC2020, "61091"), (Standards.ISIC4, "6110")),
        ((Standards.SSIC2020, "61091"), (Standards.ISIC4, "6120")),
        ((Standards.SSIC2020, "61091"), (Standards.ISIC4, "6130")),
        ((Standards.SSIC2020, "61092"), (Standards.ISIC4, "6110")),
        ((Standards.SSIC2020, "61092"), (Standards.ISIC4, "6120")),
        ((Standards.SSIC2020, "61092"), (Standards.ISIC4, "6130")),
        ((Standards.SSIC2020, "61099"), (Standards.ISIC4, "6190")),
        ((Standards.SSIC2020, "62011"), (Standards.ISIC4, "6201")),
        ((Standards.SSIC2020, "62012"), (Standards.ISIC4, "6201")),
        ((Standards.SSIC2020, "62013"), (Standards.ISIC4, "6201")),
        ((Standards.SSIC2020, "62021"), (Standards.ISIC4, "6202")),
        ((Standards.SSIC2020, "62022"), (Standards.ISIC4, "6202")),
        ((Standards.SSIC2020, "62023"), (Standards.ISIC4, "6202")),
        ((Standards.SSIC2020, "62090"), (Standards.ISIC4, "6209")),
        ((Standards.SSIC2020, "63111"), (Standards.ISIC4, "6311")),
        ((Standards.SSIC2020, "63112"), (Standards.ISIC4, "6311")),
        ((Standards.SSIC2020, "63119"), (Standards.ISIC4, "6311")),
        ((Standards.SSIC2020, "63120"), (Standards.ISIC4, "6312")),
        ((Standards.SSIC2020, "63201"), (Standards.ISIC4, "4610")),
        ((Standards.SSIC2020, "63201"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "63201"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "63201"), (Standards.ISIC4, "5819")),
        ((Standards.SSIC2020, "63202"), (Standards.ISIC4, "5819")),
        ((Standards.SSIC2020, "63202"), (Standards.ISIC4, "8690")),
        ((Standards.SSIC2020, "63203"), (Standards.ISIC4, "5819")),
        ((Standards.SSIC2020, "63203"), (Standards.ISIC4, "8550")),
        ((Standards.SSIC2020, "63204"), (Standards.ISIC4, "5819")),
        ((Standards.SSIC2020, "63204"), (Standards.ISIC4, "7911")),
        ((Standards.SSIC2020, "63204"), (Standards.ISIC4, "7912")),
        ((Standards.SSIC2020, "63204"), (Standards.ISIC4, "7990")),
        ((Standards.SSIC2020, "63205"), (Standards.ISIC4, "5819")),
        ((Standards.SSIC2020, "63205"), (Standards.ISIC4, "6820")),
        ((Standards.SSIC2020, "63209"), (Standards.ISIC4, "4390")),
        ((Standards.SSIC2020, "63209"), (Standards.ISIC4, "5819")),
        ((Standards.SSIC2020, "63209"), (Standards.ISIC4, "6910")),
        ((Standards.SSIC2020, "63209"), (Standards.ISIC4, "6920")),
        ((Standards.SSIC2020, "63209"), (Standards.ISIC4, "7710")),
        ((Standards.SSIC2020, "63209"), (Standards.ISIC4, "7729")),
        ((Standards.SSIC2020, "63209"), (Standards.ISIC4, "7730")),
        ((Standards.SSIC2020, "63209"), (Standards.ISIC4, "7810")),
        ((Standards.SSIC2020, "63209"), (Standards.ISIC4, "7820")),
        ((Standards.SSIC2020, "63209"), (Standards.ISIC4, "8121")),
        ((Standards.SSIC2020, "63209"), (Standards.ISIC4, "8129")),
        ((Standards.SSIC2020, "63209"), (Standards.ISIC4, "9529")),
        ((Standards.SSIC2020, "63209"), (Standards.ISIC4, "9609")),
        ((Standards.SSIC2020, "63901"), (Standards.ISIC4, "6391")),
        ((Standards.SSIC2020, "63909"), (Standards.ISIC4, "6399")),
        ((Standards.SSIC2020, "64110"), (Standards.ISIC4, "6411")),
        ((Standards.SSIC2020, "64120"), (Standards.ISIC4, "6419")),
        ((Standards.SSIC2020, "64130"), (Standards.ISIC4, "6419")),
        ((Standards.SSIC2020, "64140"), (Standards.ISIC4, "6419")),
        ((Standards.SSIC2020, "64150"), (Standards.ISIC4, "6419")),
        ((Standards.SSIC2020, "64190"), (Standards.ISIC4, "6419")),
        ((Standards.SSIC2020, "64201"), (Standards.ISIC4, "6420")),
        ((Standards.SSIC2020, "64202"), (Standards.ISIC4, "6420")),
        ((Standards.SSIC2020, "64300"), (Standards.ISIC4, "6430")),
        ((Standards.SSIC2020, "64910"), (Standards.ISIC4, "6491")),
        ((Standards.SSIC2020, "64921"), (Standards.ISIC4, "6492")),
        ((Standards.SSIC2020, "64922"), (Standards.ISIC4, "6492")),
        ((Standards.SSIC2020, "64923"), (Standards.ISIC4, "6492")),
        ((Standards.SSIC2020, "64924"), (Standards.ISIC4, "6492")),
        ((Standards.SSIC2020, "64925"), (Standards.ISIC4, "6492")),
        ((Standards.SSIC2020, "64929"), (Standards.ISIC4, "6492")),
        ((Standards.SSIC2020, "64991"), (Standards.ISIC4, "6499")),
        ((Standards.SSIC2020, "64992"), (Standards.ISIC4, "6499")),
        ((Standards.SSIC2020, "64993"), (Standards.ISIC4, "6499")),
        ((Standards.SSIC2020, "64994"), (Standards.ISIC4, "6499")),
        ((Standards.SSIC2020, "64999"), (Standards.ISIC4, "6499")),
        ((Standards.SSIC2020, "65110"), (Standards.ISIC4, "6511")),
        ((Standards.SSIC2020, "65121"), (Standards.ISIC4, "6512")),
        ((Standards.SSIC2020, "65122"), (Standards.ISIC4, "6512")),
        ((Standards.SSIC2020, "65123"), (Standards.ISIC4, "6512")),
        ((Standards.SSIC2020, "65124"), (Standards.ISIC4, "6512")),
        ((Standards.SSIC2020, "65201"), (Standards.ISIC4, "6520")),
        ((Standards.SSIC2020, "65202"), (Standards.ISIC4, "6520")),
        ((Standards.SSIC2020, "65301"), (Standards.ISIC4, "6530")),
        ((Standards.SSIC2020, "65302"), (Standards.ISIC4, "6530")),
        ((Standards.SSIC2020, "66110"), (Standards.ISIC4, "6611")),
        ((Standards.SSIC2020, "66121"), (Standards.ISIC4, "6612")),
        ((Standards.SSIC2020, "66122"), (Standards.ISIC4, "6612")),
        ((Standards.SSIC2020, "66123"), (Standards.ISIC4, "6612")),
        ((Standards.SSIC2020, "66124"), (Standards.ISIC4, "6612")),
        ((Standards.SSIC2020, "66125"), (Standards.ISIC4, "6612")),
        ((Standards.SSIC2020, "66126"), (Standards.ISIC4, "6612")),
        ((Standards.SSIC2020, "66129"), (Standards.ISIC4, "6612")),
        ((Standards.SSIC2020, "66191"), (Standards.ISIC4, "6619")),
        ((Standards.SSIC2020, "66192"), (Standards.ISIC4, "6619")),
        ((Standards.SSIC2020, "66193"), (Standards.ISIC4, "6619")),
        ((Standards.SSIC2020, "66194"), (Standards.ISIC4, "6619")),
        ((Standards.SSIC2020, "66195"), (Standards.ISIC4, "6619")),
        ((Standards.SSIC2020, "66199"), (Standards.ISIC4, "6619")),
        ((Standards.SSIC2020, "66210"), (Standards.ISIC4, "6621")),
        ((Standards.SSIC2020, "66221"), (Standards.ISIC4, "6622")),
        ((Standards.SSIC2020, "66222"), (Standards.ISIC4, "6622")),
        ((Standards.SSIC2020, "66291"), (Standards.ISIC4, "6629")),
        ((Standards.SSIC2020, "66292"), (Standards.ISIC4, "6629")),
        ((Standards.SSIC2020, "66299"), (Standards.ISIC4, "6629")),
        ((Standards.SSIC2020, "66301"), (Standards.ISIC4, "6630")),
        ((Standards.SSIC2020, "66302"), (Standards.ISIC4, "6630")),
        ((Standards.SSIC2020, "66303"), (Standards.ISIC4, "6630")),
        ((Standards.SSIC2020, "66304"), (Standards.ISIC4, "6630")),
        ((Standards.SSIC2020, "66305"), (Standards.ISIC4, "6630")),
        ((Standards.SSIC2020, "66306"), (Standards.ISIC4, "6630")),
        ((Standards.SSIC2020, "66307"), (Standards.ISIC4, "6630")),
        ((Standards.SSIC2020, "66309"), (Standards.ISIC4, "6630")),
        ((Standards.SSIC2020, "68101"), (Standards.ISIC4, "4100")),
        ((Standards.SSIC2020, "68101"), (Standards.ISIC4, "6810")),
        ((Standards.SSIC2020, "68102"), (Standards.ISIC4, "6810")),
        ((Standards.SSIC2020, "68103"), (Standards.ISIC4, "6810")),
        ((Standards.SSIC2020, "68104"), (Standards.ISIC4, "6810")),
        ((Standards.SSIC2020, "68105"), (Standards.ISIC4, "6810")),
        ((Standards.SSIC2020, "68106"), (Standards.ISIC4, "6810")),
        ((Standards.SSIC2020, "68201"), (Standards.ISIC4, "6820")),
        ((Standards.SSIC2020, "68202"), (Standards.ISIC4, "6820")),
        ((Standards.SSIC2020, "68203"), (Standards.ISIC4, "6820")),
        ((Standards.SSIC2020, "68203"), (Standards.ISIC4, "8110")),
        ((Standards.SSIC2020, "68209"), (Standards.ISIC4, "6820")),
        ((Standards.SSIC2020, "69101"), (Standards.ISIC4, "6910")),
        ((Standards.SSIC2020, "69102"), (Standards.ISIC4, "6910")),
        ((Standards.SSIC2020, "69201"), (Standards.ISIC4, "6920")),
        ((Standards.SSIC2020, "69202"), (Standards.ISIC4, "6920")),
        ((Standards.SSIC2020, "70101"), (Standards.ISIC4, "7010")),
        ((Standards.SSIC2020, "70102"), (Standards.ISIC4, "7010")),
        ((Standards.SSIC2020, "70201"), (Standards.ISIC4, "7020")),
        ((Standards.SSIC2020, "70202"), (Standards.ISIC4, "7020")),
        ((Standards.SSIC2020, "70203"), (Standards.ISIC4, "7020")),
        ((Standards.SSIC2020, "70204"), (Standards.ISIC4, "7020")),
        ((Standards.SSIC2020, "70205"), (Standards.ISIC4, "7020")),
        ((Standards.SSIC2020, "70206"), (Standards.ISIC4, "7020")),
        ((Standards.SSIC2020, "70209"), (Standards.ISIC4, "7020")),
        ((Standards.SSIC2020, "71111"), (Standards.ISIC4, "7110")),
        ((Standards.SSIC2020, "71112"), (Standards.ISIC4, "7110")),
        ((Standards.SSIC2020, "71113"), (Standards.ISIC4, "7110")),
        ((Standards.SSIC2020, "71114"), (Standards.ISIC4, "7110")),
        ((Standards.SSIC2020, "71119"), (Standards.ISIC4, "7110")),
        ((Standards.SSIC2020, "71121"), (Standards.ISIC4, "7110")),
        ((Standards.SSIC2020, "71122"), (Standards.ISIC4, "7110")),
        ((Standards.SSIC2020, "71123"), (Standards.ISIC4, "7110")),
        ((Standards.SSIC2020, "71124"), (Standards.ISIC4, "7110")),
        ((Standards.SSIC2020, "71125"), (Standards.ISIC4, "7110")),
        ((Standards.SSIC2020, "71126"), (Standards.ISIC4, "7110")),
        ((Standards.SSIC2020, "71129"), (Standards.ISIC4, "7110")),
        ((Standards.SSIC2020, "71200"), (Standards.ISIC4, "7120")),
        ((Standards.SSIC2020, "72101"), (Standards.ISIC4, "7210")),
        ((Standards.SSIC2020, "72102"), (Standards.ISIC4, "7210")),
        ((Standards.SSIC2020, "72103"), (Standards.ISIC4, "7210")),
        ((Standards.SSIC2020, "72104"), (Standards.ISIC4, "7210")),
        ((Standards.SSIC2020, "72105"), (Standards.ISIC4, "7210")),
        ((Standards.SSIC2020, "72106"), (Standards.ISIC4, "7210")),
        ((Standards.SSIC2020, "72109"), (Standards.ISIC4, "7210")),
        ((Standards.SSIC2020, "72200"), (Standards.ISIC4, "7220")),
        ((Standards.SSIC2020, "73100"), (Standards.ISIC4, "7310")),
        ((Standards.SSIC2020, "73200"), (Standards.ISIC4, "7320")),
        ((Standards.SSIC2020, "74111"), (Standards.ISIC4, "7410")),
        ((Standards.SSIC2020, "74112"), (Standards.ISIC4, "7410")),
        ((Standards.SSIC2020, "74113"), (Standards.ISIC4, "7410")),
        ((Standards.SSIC2020, "74119"), (Standards.ISIC4, "7410")),
        ((Standards.SSIC2020, "74191"), (Standards.ISIC4, "7410")),
        ((Standards.SSIC2020, "74192"), (Standards.ISIC4, "7410")),
        ((Standards.SSIC2020, "74193"), (Standards.ISIC4, "7410")),
        ((Standards.SSIC2020, "74194"), (Standards.ISIC4, "7410")),
        ((Standards.SSIC2020, "74199"), (Standards.ISIC4, "7410")),
        ((Standards.SSIC2020, "74200"), (Standards.ISIC4, "7420")),
        ((Standards.SSIC2020, "74901"), (Standards.ISIC4, "7490")),
        ((Standards.SSIC2020, "74902"), (Standards.ISIC4, "7490")),
        ((Standards.SSIC2020, "74903"), (Standards.ISIC4, "7490")),
        ((Standards.SSIC2020, "74904"), (Standards.ISIC4, "7490")),
        ((Standards.SSIC2020, "74905"), (Standards.ISIC4, "7490")),
        ((Standards.SSIC2020, "74909"), (Standards.ISIC4, "7490")),
        ((Standards.SSIC2020, "75000"), (Standards.ISIC4, "7500")),
        ((Standards.SSIC2020, "77101"), (Standards.ISIC4, "7710")),
        ((Standards.SSIC2020, "77102"), (Standards.ISIC4, "7721")),
        ((Standards.SSIC2020, "77109"), (Standards.ISIC4, "7710")),
        ((Standards.SSIC2020, "77210"), (Standards.ISIC4, "7721")),
        ((Standards.SSIC2020, "77220"), (Standards.ISIC4, "7722")),
        ((Standards.SSIC2020, "77291"), (Standards.ISIC4, "7729")),
        ((Standards.SSIC2020, "77292"), (Standards.ISIC4, "7729")),
        ((Standards.SSIC2020, "77299"), (Standards.ISIC4, "7729")),
        ((Standards.SSIC2020, "77310"), (Standards.ISIC4, "7730")),
        ((Standards.SSIC2020, "77320"), (Standards.ISIC4, "7730")),
        ((Standards.SSIC2020, "77330"), (Standards.ISIC4, "7730")),
        ((Standards.SSIC2020, "77341"), (Standards.ISIC4, "7730")),
        ((Standards.SSIC2020, "77342"), (Standards.ISIC4, "7730")),
        ((Standards.SSIC2020, "77391"), (Standards.ISIC4, "7730")),
        ((Standards.SSIC2020, "77392"), (Standards.ISIC4, "7730")),
        ((Standards.SSIC2020, "77399"), (Standards.ISIC4, "7730")),
        ((Standards.SSIC2020, "77400"), (Standards.ISIC4, "7740")),
        ((Standards.SSIC2020, "78101"), (Standards.ISIC4, "7810")),
        ((Standards.SSIC2020, "78101"), (Standards.ISIC4, "7820")),
        ((Standards.SSIC2020, "78102"), (Standards.ISIC4, "7810")),
        ((Standards.SSIC2020, "78102"), (Standards.ISIC4, "7820")),
        ((Standards.SSIC2020, "78103"), (Standards.ISIC4, "7810")),
        ((Standards.SSIC2020, "78103"), (Standards.ISIC4, "7820")),
        ((Standards.SSIC2020, "78104"), (Standards.ISIC4, "7810")),
        ((Standards.SSIC2020, "78300"), (Standards.ISIC4, "7830")),
        ((Standards.SSIC2020, "79101"), (Standards.ISIC4, "7911")),
        ((Standards.SSIC2020, "79101"), (Standards.ISIC4, "7912")),
        ((Standards.SSIC2020, "79102"), (Standards.ISIC4, "7911")),
        ((Standards.SSIC2020, "79102"), (Standards.ISIC4, "7912")),
        ((Standards.SSIC2020, "79200"), (Standards.ISIC4, "7990")),
        ((Standards.SSIC2020, "80100"), (Standards.ISIC4, "8010")),
        ((Standards.SSIC2020, "80100"), (Standards.ISIC4, "8020")),
        ((Standards.SSIC2020, "80200"), (Standards.ISIC4, "8030")),
        ((Standards.SSIC2020, "81211"), (Standards.ISIC4, "8121")),
        ((Standards.SSIC2020, "81211"), (Standards.ISIC4, "8129")),
        ((Standards.SSIC2020, "81212"), (Standards.ISIC4, "8121")),
        ((Standards.SSIC2020, "81291"), (Standards.ISIC4, "8129")),
        ((Standards.SSIC2020, "81292"), (Standards.ISIC4, "8129")),
        ((Standards.SSIC2020, "81299"), (Standards.ISIC4, "8129")),
        ((Standards.SSIC2020, "81300"), (Standards.ISIC4, "8130")),
        ((Standards.SSIC2020, "82110"), (Standards.ISIC4, "8211")),
        ((Standards.SSIC2020, "82191"), (Standards.ISIC4, "8219")),
        ((Standards.SSIC2020, "82192"), (Standards.ISIC4, "8219")),
        ((Standards.SSIC2020, "82199"), (Standards.ISIC4, "8219")),
        ((Standards.SSIC2020, "82200"), (Standards.ISIC4, "8220")),
        ((Standards.SSIC2020, "82301"), (Standards.ISIC4, "8230")),
        ((Standards.SSIC2020, "82302"), (Standards.ISIC4, "8230")),
        ((Standards.SSIC2020, "82303"), (Standards.ISIC4, "8230")),
        ((Standards.SSIC2020, "82304"), (Standards.ISIC4, "8230")),
        ((Standards.SSIC2020, "82911"), (Standards.ISIC4, "8291")),
        ((Standards.SSIC2020, "82912"), (Standards.ISIC4, "8291")),
        ((Standards.SSIC2020, "82920"), (Standards.ISIC4, "8292")),
        ((Standards.SSIC2020, "82991"), (Standards.ISIC4, "4510")),
        ((Standards.SSIC2020, "82991"), (Standards.ISIC4, "4774")),
        ((Standards.SSIC2020, "82991"), (Standards.ISIC4, "4791")),
        ((Standards.SSIC2020, "82991"), (Standards.ISIC4, "4799")),
        ((Standards.SSIC2020, "82991"), (Standards.ISIC4, "8299")),
        ((Standards.SSIC2020, "82999"), (Standards.ISIC4, "8299")),
        ((Standards.SSIC2020, "84110"), (Standards.ISIC4, "8411")),
        ((Standards.SSIC2020, "84120"), (Standards.ISIC4, "8412")),
        ((Standards.SSIC2020, "84120"), (Standards.ISIC4, "8413")),
        ((Standards.SSIC2020, "84210"), (Standards.ISIC4, "8421")),
        ((Standards.SSIC2020, "84221"), (Standards.ISIC4, "8422")),
        ((Standards.SSIC2020, "84229"), (Standards.ISIC4, "8422")),
        ((Standards.SSIC2020, "84231"), (Standards.ISIC4, "8423")),
        ((Standards.SSIC2020, "84232"), (Standards.ISIC4, "8423")),
        ((Standards.SSIC2020, "84233"), (Standards.ISIC4, "8423")),
        ((Standards.SSIC2020, "84234"), (Standards.ISIC4, "8423")),
        ((Standards.SSIC2020, "84235"), (Standards.ISIC4, "8423")),
        ((Standards.SSIC2020, "84239"), (Standards.ISIC4, "8423")),
        ((Standards.SSIC2020, "85101"), (Standards.ISIC4, "8510")),
        ((Standards.SSIC2020, "85102"), (Standards.ISIC4, "8510")),
        ((Standards.SSIC2020, "85211"), (Standards.ISIC4, "8521")),
        ((Standards.SSIC2020, "85212"), (Standards.ISIC4, "8530")),
        ((Standards.SSIC2020, "85213"), (Standards.ISIC4, "8521")),
        ((Standards.SSIC2020, "85213"), (Standards.ISIC4, "8530")),
        ((Standards.SSIC2020, "85220"), (Standards.ISIC4, "8522")),
        ((Standards.SSIC2020, "85230"), (Standards.ISIC4, "8510")),
        ((Standards.SSIC2020, "85230"), (Standards.ISIC4, "8521")),
        ((Standards.SSIC2020, "85230"), (Standards.ISIC4, "8530")),
        ((Standards.SSIC2020, "85240"), (Standards.ISIC4, "8510")),
        ((Standards.SSIC2020, "85240"), (Standards.ISIC4, "8521")),
        ((Standards.SSIC2020, "85240"), (Standards.ISIC4, "8530")),
        ((Standards.SSIC2020, "85250"), (Standards.ISIC4, "8521")),
        ((Standards.SSIC2020, "85250"), (Standards.ISIC4, "8530")),
        ((Standards.SSIC2020, "85301"), (Standards.ISIC4, "8530")),
        ((Standards.SSIC2020, "85302"), (Standards.ISIC4, "8530")),
        ((Standards.SSIC2020, "85303"), (Standards.ISIC4, "8530")),
        ((Standards.SSIC2020, "85304"), (Standards.ISIC4, "8530")),
        ((Standards.SSIC2020, "85401"), (Standards.ISIC4, "8549")),
        ((Standards.SSIC2020, "85402"), (Standards.ISIC4, "8549")),
        ((Standards.SSIC2020, "85403"), (Standards.ISIC4, "8549")),
        ((Standards.SSIC2020, "85404"), (Standards.ISIC4, "8549")),
        ((Standards.SSIC2020, "85405"), (Standards.ISIC4, "8549")),
        ((Standards.SSIC2020, "85406"), (Standards.ISIC4, "8549")),
        ((Standards.SSIC2020, "85407"), (Standards.ISIC4, "8541")),
        ((Standards.SSIC2020, "85408"), (Standards.ISIC4, "8542")),
        ((Standards.SSIC2020, "85409"), (Standards.ISIC4, "8549")),
        ((Standards.SSIC2020, "85501"), (Standards.ISIC4, "8550")),
        ((Standards.SSIC2020, "85502"), (Standards.ISIC4, "8550")),
        ((Standards.SSIC2020, "85509"), (Standards.ISIC4, "8550")),
        ((Standards.SSIC2020, "86101"), (Standards.ISIC4, "8610")),
        ((Standards.SSIC2020, "86102"), (Standards.ISIC4, "8610")),
        ((Standards.SSIC2020, "86109"), (Standards.ISIC4, "8610")),
        ((Standards.SSIC2020, "86201"), (Standards.ISIC4, "8620")),
        ((Standards.SSIC2020, "86202"), (Standards.ISIC4, "8620")),
        ((Standards.SSIC2020, "86203"), (Standards.ISIC4, "8620")),
        ((Standards.SSIC2020, "86204"), (Standards.ISIC4, "8620")),
        ((Standards.SSIC2020, "86901"), (Standards.ISIC4, "8690")),
        ((Standards.SSIC2020, "86902"), (Standards.ISIC4, "8690")),
        ((Standards.SSIC2020, "86903"), (Standards.ISIC4, "8690")),
        ((Standards.SSIC2020, "86904"), (Standards.ISIC4, "8690")),
        ((Standards.SSIC2020, "86905"), (Standards.ISIC4, "8690")),
        ((Standards.SSIC2020, "86909"), (Standards.ISIC4, "8690")),
        ((Standards.SSIC2020, "87010"), (Standards.ISIC4, "8710")),
        ((Standards.SSIC2020, "87021"), (Standards.ISIC4, "8730")),
        ((Standards.SSIC2020, "87022"), (Standards.ISIC4, "8790")),
        ((Standards.SSIC2020, "87029"), (Standards.ISIC4, "8720")),
        ((Standards.SSIC2020, "87029"), (Standards.ISIC4, "8790")),
        ((Standards.SSIC2020, "88101"), (Standards.ISIC4, "8810")),
        ((Standards.SSIC2020, "88102"), (Standards.ISIC4, "8810")),
        ((Standards.SSIC2020, "88911"), (Standards.ISIC4, "8890")),
        ((Standards.SSIC2020, "88912"), (Standards.ISIC4, "8890")),
        ((Standards.SSIC2020, "88913"), (Standards.ISIC4, "8890")),
        ((Standards.SSIC2020, "88919"), (Standards.ISIC4, "8890")),
        ((Standards.SSIC2020, "88920"), (Standards.ISIC4, "8890")),
        ((Standards.SSIC2020, "88991"), (Standards.ISIC4, "8890")),
        ((Standards.SSIC2020, "88992"), (Standards.ISIC4, "8890")),
        ((Standards.SSIC2020, "88999"), (Standards.ISIC4, "8890")),
        ((Standards.SSIC2020, "90001"), (Standards.ISIC4, "9000")),
        ((Standards.SSIC2020, "90002"), (Standards.ISIC4, "9000")),
        ((Standards.SSIC2020, "90003"), (Standards.ISIC4, "9000")),
        ((Standards.SSIC2020, "90009"), (Standards.ISIC4, "9000")),
        ((Standards.SSIC2020, "91010"), (Standards.ISIC4, "9101")),
        ((Standards.SSIC2020, "91021"), (Standards.ISIC4, "9102")),
        ((Standards.SSIC2020, "91029"), (Standards.ISIC4, "9000")),
        ((Standards.SSIC2020, "91029"), (Standards.ISIC4, "9102")),
        ((Standards.SSIC2020, "91030"), (Standards.ISIC4, "9103")),
        ((Standards.SSIC2020, "92001"), (Standards.ISIC4, "9200")),
        ((Standards.SSIC2020, "92002"), (Standards.ISIC4, "9200")),
        ((Standards.SSIC2020, "93111"), (Standards.ISIC4, "9311")),
        ((Standards.SSIC2020, "93119"), (Standards.ISIC4, "9311")),
        ((Standards.SSIC2020, "93120"), (Standards.ISIC4, "9312")),
        ((Standards.SSIC2020, "93120"), (Standards.ISIC4, "9319")),
        ((Standards.SSIC2020, "93201"), (Standards.ISIC4, "9321")),
        ((Standards.SSIC2020, "93202"), (Standards.ISIC4, "9329")),
        ((Standards.SSIC2020, "93203"), (Standards.ISIC4, "9329")),
        ((Standards.SSIC2020, "93204"), (Standards.ISIC4, "9329")),
        ((Standards.SSIC2020, "93209"), (Standards.ISIC4, "9329")),
        ((Standards.SSIC2020, "94110"), (Standards.ISIC4, "9411")),
        ((Standards.SSIC2020, "94120"), (Standards.ISIC4, "9412")),
        ((Standards.SSIC2020, "94200"), (Standards.ISIC4, "9420")),
        ((Standards.SSIC2020, "94911"), (Standards.ISIC4, "9491")),
        ((Standards.SSIC2020, "94912"), (Standards.ISIC4, "9491")),
        ((Standards.SSIC2020, "94913"), (Standards.ISIC4, "9491")),
        ((Standards.SSIC2020, "94914"), (Standards.ISIC4, "9491")),
        ((Standards.SSIC2020, "94919"), (Standards.ISIC4, "9491")),
        ((Standards.SSIC2020, "94920"), (Standards.ISIC4, "9492")),
        ((Standards.SSIC2020, "94991"), (Standards.ISIC4, "9499")),
        ((Standards.SSIC2020, "94992"), (Standards.ISIC4, "9499")),
        ((Standards.SSIC2020, "94993"), (Standards.ISIC4, "9499")),
        ((Standards.SSIC2020, "94994"), (Standards.ISIC4, "9499")),
        ((Standards.SSIC2020, "94995"), (Standards.ISIC4, "9499")),
        ((Standards.SSIC2020, "94999"), (Standards.ISIC4, "9499")),
        ((Standards.SSIC2020, "95110"), (Standards.ISIC4, "9511")),
        ((Standards.SSIC2020, "95120"), (Standards.ISIC4, "9512")),
        ((Standards.SSIC2020, "95210"), (Standards.ISIC4, "9521")),
        ((Standards.SSIC2020, "95220"), (Standards.ISIC4, "9522")),
        ((Standards.SSIC2020, "95230"), (Standards.ISIC4, "9523")),
        ((Standards.SSIC2020, "95240"), (Standards.ISIC4, "9524")),
        ((Standards.SSIC2020, "95291"), (Standards.ISIC4, "9529")),
        ((Standards.SSIC2020, "95292"), (Standards.ISIC4, "9529")),
        ((Standards.SSIC2020, "95293"), (Standards.ISIC4, "9529")),
        ((Standards.SSIC2020, "95299"), (Standards.ISIC4, "9529")),
        ((Standards.SSIC2020, "95301"), (Standards.ISIC4, "4520")),
        ((Standards.SSIC2020, "95301"), (Standards.ISIC4, "4540")),
        ((Standards.SSIC2020, "95302"), (Standards.ISIC4, "4520")),
        ((Standards.SSIC2020, "95302"), (Standards.ISIC4, "4540")),
        ((Standards.SSIC2020, "95303"), (Standards.ISIC4, "4520")),
        ((Standards.SSIC2020, "95303"), (Standards.ISIC4, "4540")),
        ((Standards.SSIC2020, "96011"), (Standards.ISIC4, "9601")),
        ((Standards.SSIC2020, "96012"), (Standards.ISIC4, "9601")),
        ((Standards.SSIC2020, "96021"), (Standards.ISIC4, "9602")),
        ((Standards.SSIC2020, "96022"), (Standards.ISIC4, "9609")),
        ((Standards.SSIC2020, "96023"), (Standards.ISIC4, "9609")),
        ((Standards.SSIC2020, "96024"), (Standards.ISIC4, "9609")),
        ((Standards.SSIC2020, "96029"), (Standards.ISIC4, "9609")),
        ((Standards.SSIC2020, "96030"), (Standards.ISIC4, "9603")),
        ((Standards.SSIC2020, "96040"), (Standards.ISIC4, "9609")),
        ((Standards.SSIC2020, "96091"), (Standards.ISIC4, "9609")),
        ((Standards.SSIC2020, "96092"), (Standards.ISIC4, "9609")),
        ((Standards.SSIC2020, "96093"), (Standards.ISIC4, "9609")),
        ((Standards.SSIC2020, "96094"), (Standards.ISIC4, "9609")),
        ((Standards.SSIC2020, "96095"), (Standards.ISIC4, "9609")),
        ((Standards.SSIC2020, "96099"), (Standards.ISIC4, "9609")),
        ((Standards.SSIC2020, "97001"), (Standards.ISIC4, "9700")),
        ((Standards.SSIC2020, "97002"), (Standards.ISIC4, "9700")),
        ((Standards.SSIC2020, "99010"), (Standards.ISIC4, "9900")),
        ((Standards.SSIC2020, "99020"), (Standards.ISIC4, "9900")),
        ((Standards.SSIC2020, "99090"), (Standards.ISIC4, "9900")),
    ],
)
