# -*- coding: utf-8 -*-
"""`SSIC2020 Standard <https://www.singstat.gov.sg/standards/standards-and-classifications/ssic>`_."""

from ...types import Category, Classification, Standard, Standards

SSIC2020 = Standard(
    standard=Standards.SSIC2020,
    classes=[
        Classification("A", "AGRICULTURE AND FISHING", Category.SECTION),
        Classification("01", "AGRICULTURE AND RELATED SERVICE ACTIVITIES", Category.DIVISION),
        Classification("011", "GROWING OF CROPS, MARKET GARDENING AND HORTICULTURE", Category.GROUP),
        Classification("0111", "Growing of Food Crops (Non-Hydroponics)", Category.CLASS),
        Classification("01111", "Growing of leafy and fruit vegetables", Category.SUBCLASS),
        Classification("01112", "Growing of mushrooms", Category.SUBCLASS),
        Classification("01113", "Growing of root crops", Category.SUBCLASS),
        Classification("01119", "Growing of food crops (non-hydroponics) n.e.c.", Category.SUBCLASS),
        Classification("0112", "Growing of Food Crops (Hydroponics)", Category.CLASS),
        Classification("01120", "Growing of leafy and fruit vegetables (hydroponics)", Category.SUBCLASS),
        Classification("0113", "Growing of Fruits", Category.CLASS),
        Classification("01130", "Growing of fruits", Category.SUBCLASS),
        Classification("0114", "Growing of Nursery Products", Category.CLASS),
        Classification("01141", "Growing of orchids", Category.SUBCLASS),
        Classification("01142", "Growing of ornamental plants", Category.SUBCLASS),
        Classification("01149", "Growing of nursery products n.e.c.", Category.SUBCLASS),
        Classification("0119", "Growing of Other Crops", Category.CLASS),
        Classification("01190", "Growing of other crops", Category.SUBCLASS),
        Classification("014", "ANIMAL PRODUCTION", Category.GROUP),
        Classification("0141", "Livestock Production (except Poultry and Animal Specialties)", Category.CLASS),
        Classification("01411", "Pig farms", Category.SUBCLASS),
        Classification("01412", "Cattle farms (including dairy cattle)", Category.SUBCLASS),
        Classification("01413", "Goat farms (including goat's milk production)", Category.SUBCLASS),
        Classification("0142", "Poultry Farms and Hatcheries", Category.CLASS),
        Classification("01421", "Poultry breeding/hatcheries", Category.SUBCLASS),
        Classification("01422", "Broiler farms (chickens reared for meat)", Category.SUBCLASS),
        Classification("01423", "Layer farms (chickens reared for eggs)", Category.SUBCLASS),
        Classification("01424", "Duck farms", Category.SUBCLASS),
        Classification("0149", "Other Animal Production", Category.CLASS),
        Classification("01491", "Dog breeding", Category.SUBCLASS),
        Classification("01492", "Bird breeding", Category.SUBCLASS),
        Classification("01493", "Crocodile farms", Category.SUBCLASS),
        Classification("01494", "Frog farms", Category.SUBCLASS),
        Classification("01499", "Other animal production n.e.c.", Category.SUBCLASS),
        Classification("015", "GROWING OF CROPS COMBINED WITH ANIMAL PRODUCTION (MIXED FARMING)", Category.GROUP),
        Classification("0150", "Growing of Crops Combined with Animal Production (Mixed Farming)", Category.CLASS),
        Classification("01500", "Growing of crops combined with animal production (mixed farming)", Category.SUBCLASS),
        Classification(
            "016", "AGRICULTURAL AND ANIMAL HUSBANDRY SERVICE ACTIVITIES EXCEPT VETERINARY ACTIVITIES", Category.GROUP
        ),
        Classification(
            "0160",
            "Agricultural and Animal Husbandry Service Activities (except Veterinary Activities)",
            Category.CLASS,
        ),
        Classification(
            "01600",
            "Agricultural and animal husbandry service activities except veterinary activities",
            Category.SUBCLASS,
        ),
        Classification("02", "FORESTRY, LOGGING AND RELATED SERVICE ACTIVITIES", Category.DIVISION),
        Classification("020", "FORESTRY, LOGGING AND RELATED SERVICE ACTIVITIES", Category.GROUP),
        Classification("0200", "Forestry, Logging and Related Service Activities", Category.CLASS),
        Classification("02000", "Forestry, logging and related service activities", Category.SUBCLASS),
        Classification(
            "03",
            "FISHING, OPERATION OF FISH HATCHERIES AND FISH FARMS; SERVICE ACTIVITIES INCIDENTAL TO FISHING",
            Category.DIVISION,
        ),
        Classification("031", "FISHING", Category.GROUP),
        Classification("0310", "Fishing", Category.CLASS),
        Classification("03101", "Fishing in kelongs", Category.SUBCLASS),
        Classification("03102", "Ocean fishing except fishing in kelongs", Category.SUBCLASS),
        Classification("03103", "Coastal fishing except fishing in kelongs", Category.SUBCLASS),
        Classification("03109", "Fishing n.e.c.", Category.SUBCLASS),
        Classification("032", "OPERATION OF FISH HATCHERIES AND FISH FARMS", Category.GROUP),
        Classification("0320", "Fish Farming", Category.CLASS),
        Classification("03201", "Food fish farms", Category.SUBCLASS),
        Classification("03202", "Ornamental fish farms", Category.SUBCLASS),
        Classification(
            "03209",
            "Operation of fish hatcheries and fish farms n.e.c. (including turtle, prawn, crab, mussel farms)",
            Category.SUBCLASS,
        ),
        Classification("B", "MINING AND QUARRYING", Category.SECTION),
        Classification("08", "MINING AND QUARRYING", Category.DIVISION),
        Classification("081", "QUARRYING OF STONE, SAND AND CLAY", Category.GROUP),
        Classification("0810", "Quarrying of Stone, Sand and Clay", Category.CLASS),
        Classification("08101", "Stone quarrying", Category.SUBCLASS),
        Classification("08102", "Quarrying of sand and clay", Category.SUBCLASS),
        Classification("089", "OTHER MINING AND QUARRYING", Category.GROUP),
        Classification("0890", "Other Mining and Quarrying", Category.CLASS),
        Classification("08900", "Other mining and quarrying", Category.SUBCLASS),
        Classification(
            "09",
            "SERVICE ACTIVITIES INCIDENTAL TO OIL AND GAS EXTRACTION (EXCLUDING SURVEYING AND ENGINEERING DESIGN AND CONSULTANCY SERVICES SUPPORTING MINING, OIL AND GAS EXTRACTION AND OFFSHORE EXPLORATION ACTIVITIES)",
            Category.DIVISION,
        ),
        Classification(
            "090",
            "SERVICE ACTIVITIES INCIDENTAL TO OIL AND GAS EXTRACTION (EXCLUDING SURVEYING AND ENGINEERING DESIGN AND CONSULTANCY SERVICES SUPPORTING MINING, OIL AND GAS EXTRACTION AND OFFSHORE EXPLORATION ACTIVITIES)",
            Category.GROUP,
        ),
        Classification(
            "0900",
            "Service Activities Incidental to Oil and Gas Extraction (excluding Surveying and Engineering Design and Consultancy Services Supporting Mining, Oil and Gas Extraction and Offshore Exploration Activities)",
            Category.CLASS,
        ),
        Classification("09001", "Crude petroleum and natural gas production", Category.SUBCLASS),
        Classification(
            "09002",
            "Service activities incidental to oil and gas extraction (excluding surveying and engineering design and consultancy services supporting mining, oil and gas extraction and offshore exploration activities)",
            Category.SUBCLASS,
        ),
        Classification("C", "MANUFACTURING", Category.SECTION),
        Classification("10", "MANUFACTURE OF FOOD PRODUCTS", Category.DIVISION),
        Classification("101", "PROCESSING AND PRESERVING OF MEAT", Category.GROUP),
        Classification("1010", "Processing and Preserving of Meat", Category.CLASS),
        Classification("10101", "Slaughtering of livestock and poultry", Category.SUBCLASS),
        Classification("10102", "Manufacture of sausage", Category.SUBCLASS),
        Classification(
            "10103",
            "Preparing, canning and preserving of livestock and livestock products (including lard and other edible animal fats)",
            Category.SUBCLASS,
        ),
        Classification("10104", "Preparing, canning and preserving of poultry and poultry products", Category.SUBCLASS),
        Classification("10109", "Processing and preserving of meat and meat products n.e.c.", Category.SUBCLASS),
        Classification("102", "PROCESSING AND PRESERVING OF SEAFOOD", Category.GROUP),
        Classification("1020", "Processing and Preserving of Seafood", Category.CLASS),
        Classification("10200", "Processing and preserving of seafood", Category.SUBCLASS),
        Classification("103", "PROCESSING AND PRESERVING OF FRUITS AND VEGETABLES", Category.GROUP),
        Classification("1030", "Processing and Preserving of Fruits and Vegetables", Category.CLASS),
        Classification("10301", "Manufacture of jams (including fruit jelly)", Category.SUBCLASS),
        Classification("10302", "Other canning and preserving of fruits and fruit juices", Category.SUBCLASS),
        Classification(
            "10303",
            "Other canning and preserving of vegetables and vegetable juices (including pickles)",
            Category.SUBCLASS,
        ),
        Classification("104", "MANUFACTURE OF VEGETABLE AND ANIMAL OILS AND FATS", Category.GROUP),
        Classification("1040", "Manufacture of Vegetable and Animal Oils and Fats", Category.CLASS),
        Classification("10401", "Manufacture of edible vegetable and animal oils and fats", Category.SUBCLASS),
        Classification("10402", "Manufacture of inedible vegetable and animal oils and fats", Category.SUBCLASS),
        Classification("10409", "Manufacture of vegetable and animal oils and fats n.e.c.", Category.SUBCLASS),
        Classification("105", "MANUFACTURE OF DAIRY PRODUCTS", Category.GROUP),
        Classification("1050", "Manufacture of Dairy Products", Category.CLASS),
        Classification(
            "10501",
            "Manufacture of condensed and evaporated milk (including pasteurising and bottling of fluid milk)",
            Category.SUBCLASS,
        ),
        Classification("10502", "Manufacture of milk powder", Category.SUBCLASS),
        Classification("10503", "Manufacture of ice-cream", Category.SUBCLASS),
        Classification(
            "10509",
            "Manufacture of dairy products n.e.c. (e.g. butter, cheese, ice-cream mixes and powder, yoghurt)",
            Category.SUBCLASS,
        ),
        Classification("106", "MANUFACTURE OF GRAIN MILL PRODUCTS, STARCHES AND STARCH PRODUCTS", Category.GROUP),
        Classification("1061", "Manufacture of Grain Mill Products", Category.CLASS),
        Classification("10611", "Rice milling", Category.SUBCLASS),
        Classification("10612", "Wheat milling", Category.SUBCLASS),
        Classification("10613", "Provision of milling services", Category.SUBCLASS),
        Classification("10619", "Manufacture of grain mill products n.e.c.", Category.SUBCLASS),
        Classification("1062", "Manufacture of Starches and Starch Products", Category.CLASS),
        Classification("10620", "Manufacture of starches and starch products", Category.SUBCLASS),
        Classification("107", "MANUFACTURE OF OTHER FOOD PRODUCTS", Category.GROUP),
        Classification("1071", "Manufacture of Bakery Products", Category.CLASS),
        Classification("10711", "Manufacture of biscuits (including wafers and cones)", Category.SUBCLASS),
        Classification(
            "10712",
            "Manufacture of bread, cakes and confectionery (excluding frozen bakery products)",
            Category.SUBCLASS,
        ),
        Classification("10719", "Manufacture of bakery products n.e.c.", Category.SUBCLASS),
        Classification("1072", "Manufacture of Sugar", Category.CLASS),
        Classification("10720", "Manufacture of sugar and sugar products", Category.SUBCLASS),
        Classification("1073", "Manufacture of Cocoa, Chocolate and Non-chocolate Confectionery", Category.CLASS),
        Classification("10731", "Manufacture of cocoa and chocolate powder from beans", Category.SUBCLASS),
        Classification("10732", "Manufacture of chocolate and chocolate products", Category.SUBCLASS),
        Classification(
            "10733",
            "Manufacture of non-chocolate confectionery (e.g. sweets, toffees, crystallised fruits, chewing gums)",
            Category.SUBCLASS,
        ),
        Classification(
            "1074", "Manufacture of Macaroni, Noodles, Vermicelli and Other Related Products", Category.CLASS
        ),
        Classification(
            "10740", "Manufacture of macaroni, noodles, vermicelli and other related products", Category.SUBCLASS
        ),
        Classification("1075", "Manufacture of Prepared Meals and Dishes", Category.CLASS),
        Classification("10750", "Manufacture of cooked-food preparations (e.g. frozen dinners)", Category.SUBCLASS),
        Classification("1076", "Manufacture of Coffee, Tea and Related Products", Category.CLASS),
        Classification("10761", "Manufacture of instant beverages", Category.SUBCLASS),
        Classification("10762", "Processing of coffee seeds", Category.SUBCLASS),
        Classification("10763", "Manufacture of coffee powder", Category.SUBCLASS),
        Classification("10764", "Manufacture of tea (including processing of tea leaves)", Category.SUBCLASS),
        Classification("10765", "Manufacture of non-dairy creamer", Category.SUBCLASS),
        Classification("1079", "Manufacture of Other Food Products n.e.c.", Category.CLASS),
        Classification(
            "10791",
            "Manufacture of sauces including soya bean sauce (e.g. tomato sauce, chilli sauce)",
            Category.SUBCLASS,
        ),
        Classification(
            "10792", "Manufacture of soya bean products except soya bean sauce and soya bean milk", Category.SUBCLASS
        ),
        Classification(
            "10793",
            "Manufacture and processing of spices (including curry powder and spice extracts)",
            Category.SUBCLASS,
        ),
        Classification(
            "10794",
            "Manufacture of chips, crackers and other titbits (excluding biscuits and confectionery)",
            Category.SUBCLASS,
        ),
        Classification(
            "10799",
            "Manufacture of other food products n.e.c. (except food chemicals and additives)",
            Category.SUBCLASS,
        ),
        Classification("108", "MANUFACTURE OF PREPARED ANIMAL FEEDS", Category.GROUP),
        Classification("1080", "Manufacture of Prepared Animal Feeds", Category.CLASS),
        Classification(
            "10800", "Manufacture of prepared animal feeds (including additives for animal feed)", Category.SUBCLASS
        ),
        Classification("11", "MANUFACTURE OF BEVERAGES", Category.DIVISION),
        Classification("110", "MANUFACTURE OF BEVERAGES", Category.GROUP),
        Classification("1101", "Distilling, Rectifying and Blending of Spirits", Category.CLASS),
        Classification(
            "11010",
            "Distilling, rectifying and blending of spirits; ethyl alcohol production from fermented materials (including samsu and Chinese liquors)",
            Category.SUBCLASS,
        ),
        Classification("1102", "Manufacture of Wines", Category.CLASS),
        Classification("11020", "Manufacture of wines", Category.SUBCLASS),
        Classification("1103", "Manufacture of Malt Liquors and Malt", Category.CLASS),
        Classification("11030", "Manufacture of malt liquors and malt (e.g. beer and stout)", Category.SUBCLASS),
        Classification(
            "1104", "Manufacture of Soft Drinks, Production of Mineral Waters and Other Bottled Waters", Category.CLASS
        ),
        Classification(
            "11041",
            "Manufacture of soft drinks, production of mineral waters (including carbonated waters, soya bean milk, barley water, chrysanthemum water)",
            Category.SUBCLASS,
        ),
        Classification(
            "11042", "Manufacture of cordials, syrups and composite concentrates for beverages", Category.SUBCLASS
        ),
        Classification("11043", "Manufacture of ice except dry ice", Category.SUBCLASS),
        Classification("12", "MANUFACTURE OF TOBACCO PRODUCTS", Category.DIVISION),
        Classification("120", "MANUFACTURE OF TOBACCO PRODUCTS", Category.GROUP),
        Classification("1200", "Manufacture of Tobacco Products", Category.CLASS),
        Classification("12001", "Manufacture of cigarettes", Category.SUBCLASS),
        Classification(
            "12009", "Manufacture of tobacco products n.e.c. (e.g. cigars, loose tobacco)", Category.SUBCLASS
        ),
        Classification("13", "MANUFACTURE OF TEXTILES", Category.DIVISION),
        Classification("131", "SPINNING, WEAVING AND FINISHING OF TEXTILES", Category.GROUP),
        Classification("1310", "Spinning, Weaving and Finishing of Textiles", Category.CLASS),
        Classification("13100", "Spinning, weaving and finishing of textiles", Category.SUBCLASS),
        Classification("139", "MANUFACTURE OF OTHER TEXTILES", Category.GROUP),
        Classification("1391", "Manufacture of Knitted and Crocheted Fabrics", Category.CLASS),
        Classification("13910", "Manufacture of knitted and crocheted fabrics and laces", Category.SUBCLASS),
        Classification("1392", "Manufacture of Made-Up Textile Articles except Apparel", Category.CLASS),
        Classification("13921", "Manufacture of curtains, pillow cases, bed sheets and bed spreads", Category.SUBCLASS),
        Classification(
            "13922", "Manufacture of other made-up house furnishings (e.g. napkins, table cloths)", Category.SUBCLASS
        ),
        Classification(
            "13929",
            "Manufacture of made-up textile articles except apparel n.e.c. (e.g. scrolls, flags and sails, banners, canvas products, cushions, pillows)",
            Category.SUBCLASS,
        ),
        Classification("1393", "Manufacture of Carpets and Rugs", Category.CLASS),
        Classification("13930", "Manufacture of carpets and rugs", Category.SUBCLASS),
        Classification("1394", "Manufacture of Cordage, Rope, Twine and Netting", Category.CLASS),
        Classification("13940", "Manufacture of cordage, rope, twine and netting", Category.SUBCLASS),
        Classification("1399", "Manufacture of Other Textiles n.e.c.", Category.CLASS),
        Classification("13990", "Manufacture of other textiles n.e.c. (e.g. upholstery filling)", Category.SUBCLASS),
        Classification(
            "14",
            "MANUFACTURE OF WEARING APPAREL; MANUFACTURE OF ARTICLES OF FUR; MANUFACTURE OF KNITTED AND CROCHETED APPAREL",
            Category.DIVISION,
        ),
        Classification("141", "MANUFACTURE OF WEARING APPAREL", Category.GROUP),
        Classification("1410", "Manufacture of Wearing Apparel except Fur Apparel", Category.CLASS),
        Classification("14101", "Manufacture of outer garments", Category.SUBCLASS),
        Classification("14102", "Manufacture of brassieres and other undergarments", Category.SUBCLASS),
        Classification("14103", "Tailoring and dressmaking (to individual order)", Category.SUBCLASS),
        Classification(
            "14109",
            "Manufacture of wearing apparel except fur apparel n.e.c. (e.g. songkoks, caps, gloves and mittens, garters, handkerchiefs, raincoats, shawls and hair nets)",
            Category.SUBCLASS,
        ),
        Classification("142", "MANUFACTURE OF ARTICLES OF FUR", Category.GROUP),
        Classification("1420", "Manufacture of Articles of Fur", Category.CLASS),
        Classification(
            "14200",
            "Manufacture of fur apparel and articles of fur (e.g. fur rugs, mats and cushions)",
            Category.SUBCLASS,
        ),
        Classification("143", "MANUFACTURE OF KNITTED AND CROCHETED APPAREL", Category.GROUP),
        Classification("1430", "Manufacture of Knitted and Crocheted Apparel", Category.CLASS),
        Classification("14301", "Manufacture of socks, stockings and other hosiery", Category.SUBCLASS),
        Classification(
            "14302",
            "Manufacture of briefs, singlets and other knitted or crocheted wear (e.g. pullovers, cardigans)",
            Category.SUBCLASS,
        ),
        Classification("14309", "Manufacture of knitted and crocheted apparel n.e.c.", Category.SUBCLASS),
        Classification(
            "15",
            "TANNING AND DRESSING OF LEATHER; DRESSING AND DYEING OF FUR; MANUFACTURE OF FOOTWEAR",
            Category.DIVISION,
        ),
        Classification("151", "TANNING AND DRESSING OF LEATHER; DRESSING AND DYEING", Category.GROUP),
        Classification("1511", "Tanning and Dressing of Leather; Dressing and Dyeing of Fur", Category.CLASS),
        Classification("15110", "Tanning and dressing of leather; dressing and dyeing of fur", Category.SUBCLASS),
        Classification("1512", "Manufacture of Luggage, Handbags and the Like; Saddlery and Harness", Category.CLASS),
        Classification("15121", "Manufacture of luggage, bags, brief cases and the like", Category.SUBCLASS),
        Classification("15122", "Manufacture of handbags", Category.SUBCLASS),
        Classification(
            "15129",
            "Manufacture of saddlery, harness and articles of leather n.e.c. (e.g. coin purses, key cases)",
            Category.SUBCLASS,
        ),
        Classification("152", "MANUFACTURE OF FOOTWEAR", Category.GROUP),
        Classification("1520", "Manufacture of Footwear", Category.CLASS),
        Classification("15200", "Manufacture of footwear", Category.SUBCLASS),
        Classification(
            "16",
            "MANUFACTURE OF WOOD AND OF PRODUCTS OF WOOD AND CORK, EXCEPT FURNITURE; MANUFACTURE OF ARTICLES OF STRAW AND PLAITING MATERIALS",
            Category.DIVISION,
        ),
        Classification("161", "SAWMILLING AND PLANING OF WOOD", Category.GROUP),
        Classification("1610", "Sawmilling and Planing of Wood", Category.CLASS),
        Classification("16101", "Sawmilling", Category.SUBCLASS),
        Classification("16102", "Preservation of wood", Category.SUBCLASS),
        Classification("16109", "Sawmilling and planing of wood n.e.c.", Category.SUBCLASS),
        Classification("162", "MANUFACTURE OF PRODUCTS OF WOOD, CORK, STRAW AND PLAITING MATERIALS", Category.GROUP),
        Classification("1621", "Manufacture of Veneer, Plywood and Wood-Based Panels", Category.CLASS),
        Classification("16211", "Manufacture of plywood and veneer", Category.SUBCLASS),
        Classification(
            "16219", "Manufacture of laminboard, particle board and other panels and boards n.e.c.", Category.SUBCLASS
        ),
        Classification(
            "1629",
            "Manufacture of Other Products of Wood and Articles of Cork, Straw and Plaiting Materials",
            Category.CLASS,
        ),
        Classification(
            "16291",
            "Manufacture of wooden window, door and other millwork, except prefabricated wooden building structures",
            Category.SUBCLASS,
        ),
        Classification(
            "16292", "Manufacture of household and kitchen wooden ware except wooden footwear", Category.SUBCLASS
        ),
        Classification("16293", "Manufacture of wooden containers", Category.SUBCLASS),
        Classification("16294", "Manufacture of attap and attap products", Category.SUBCLASS),
        Classification("16295", "Rattan processing", Category.SUBCLASS),
        Classification(
            "16299",
            "Manufacture of other products of wood and articles of cork, straw and plaiting materials n.e.c.",
            Category.SUBCLASS,
        ),
        Classification("17", "MANUFACTURE OF PAPER AND PAPER PRODUCTS", Category.DIVISION),
        Classification("170", "MANUFACTURE OF PAPER AND PAPER PRODUCTS", Category.GROUP),
        Classification("1701", "Manufacture of Pulp, Paper and Paperboard", Category.CLASS),
        Classification("17010", "Manufacture of pulp, paper and paperboard", Category.SUBCLASS),
        Classification(
            "1702",
            "Manufacture of Corrugated Paper and Paperboard and of Containers of Paper and Paperboard",
            Category.CLASS,
        ),
        Classification("17021", "Manufacture of corrugated paper and paperboard", Category.SUBCLASS),
        Classification("17022", "Manufacture of containers and boxes of paper and paperboard", Category.SUBCLASS),
        Classification("1709", "Manufacture of Other Articles of Paper and Paperboard", Category.CLASS),
        Classification(
            "17091",
            "Manufacture of joss paper and other related ceremonial paper products (including effigies and other funeral paper goods and Chinese lanterns)",
            Category.SUBCLASS,
        ),
        Classification(
            "17092",
            "Manufacture of sanitary towels, toilet paper, paper towels, disposable diapers and related paper products",
            Category.SUBCLASS,
        ),
        Classification("17093", "Manufacture of paper cups, plates and utensils", Category.SUBCLASS),
        Classification("17094", "Manufacture of cards, envelopes and stationery, unprinted", Category.SUBCLASS),
        Classification(
            "17099",
            "Manufacture of other articles of paper and paperboard n.e.c. (e.g. papier mache, wallpaper)",
            Category.SUBCLASS,
        ),
        Classification("18", "PRINTING AND REPRODUCTION OF RECORDED MEDIA", Category.DIVISION),
        Classification("181", "PRINTING AND SERVICE ACTIVITIES RELATED TO PRINTING", Category.GROUP),
        Classification("1811", "Printing", Category.CLASS),
        Classification("18111", "Printing of newspapers", Category.SUBCLASS),
        Classification("18112", "Printing of periodicals, books and magazines", Category.SUBCLASS),
        Classification(
            "18113",
            "Commercial printing (e.g. printing of brochures, cards, envelopes, labels and stationery)",
            Category.SUBCLASS,
        ),
        Classification("18114", "Printing of continuous and fan-fold forms", Category.SUBCLASS),
        Classification("18115", "Silk screen printing (including metal printing)", Category.SUBCLASS),
        Classification("18119", "Printing n.e.c.", Category.SUBCLASS),
        Classification("1812", "Service Activities Related to Printing", Category.CLASS),
        Classification("18121", "Bookbinding (e.g. book packaging)", Category.SUBCLASS),
        Classification("18122", "Colour separation", Category.SUBCLASS),
        Classification(
            "18129", "Service activities related to printing n.e.c. (including plate-making)", Category.SUBCLASS
        ),
        Classification("182", "REPRODUCTION OF RECORDED MEDIA", Category.GROUP),
        Classification("1820", "Reproduction of Recorded Media", Category.CLASS),
        Classification(
            "18200",
            "Reproduction of recorded media (including reproduction of phonograph records, recorded magnetic tapes, compact discs and non-customised software)",
            Category.SUBCLASS,
        ),
        Classification("19", "MANUFACTURE OF COKE AND REFINED PETROLEUM PRODUCTS", Category.DIVISION),
        Classification("191", "MANUFACTURE OF COKE OVEN PRODUCTS", Category.GROUP),
        Classification("1910", "Manufacture of Coke Oven Products", Category.CLASS),
        Classification("19100", "Manufacture of coke oven products", Category.SUBCLASS),
        Classification("192", "MANUFACTURE OF REFINED PETROLEUM PRODUCTS", Category.GROUP),
        Classification("1920", "Manufacture of Refined Petroleum Products", Category.CLASS),
        Classification("19201", "Petroleum refineries", Category.SUBCLASS),
        Classification("19202", "Manufacture of petroleum lubricating oil", Category.SUBCLASS),
        Classification("19209", "Manufacture of refined petroleum products n.e.c.", Category.SUBCLASS),
        Classification("20", "MANUFACTURE OF CHEMICALS AND CHEMICAL PRODUCTS", Category.DIVISION),
        Classification(
            "201",
            "MANUFACTURE OF BASIC CHEMICALS, FERTILISERS AND NITROGEN COMPOUNDS, PLASTICS AND SYNTHETIC RUBBER IN PRIMARY FORMS",
            Category.GROUP,
        ),
        Classification("2011", "Manufacture of Basic Chemicals", Category.CLASS),
        Classification("20111", "Manufacture of industrial gases and dry ice", Category.SUBCLASS),
        Classification("20112", "Manufacture of basic industrial acids and alkalis", Category.SUBCLASS),
        Classification("20113", "Manufacture of basic chemicals except fertilisers and nitrogen", Category.SUBCLASS),
        Classification("20114", "Manufacture of solvents", Category.SUBCLASS),
        Classification("20119", "Manufacture of basic chemicals n.e.c.", Category.SUBCLASS),
        Classification("2012", "Manufacture of Fertilisers and Nitrogen Compounds", Category.CLASS),
        Classification("20120", "Manufacture of fertilisers and nitrogen compounds", Category.SUBCLASS),
        Classification(
            "2013", "Manufacture of Petrochemicals; Plastic and Synthetic Rubber in Primary Forms", Category.CLASS
        ),
        Classification(
            "20131",
            "Manufacture of petrochemical primary products (e.g. olefins, aromatics, basic building blocks)",
            Category.SUBCLASS,
        ),
        Classification(
            "20132",
            "Manufacture of derivatives and intermediates produced from basic building blocks (e.g. acetyls, acrylics, oxochemicals, styrene, phenolic, ethylene oxide derivatives and polymers)",
            Category.SUBCLASS,
        ),
        Classification("20133", "Manufacture of synthetic rubber", Category.SUBCLASS),
        Classification("202", "MANUFACTURE OF OTHER CHEMICAL PRODUCTS", Category.GROUP),
        Classification("2021", "Manufacture of Pesticides and Other Agro-Chemical Products", Category.CLASS),
        Classification(
            "20210",
            "Manufacture of pesticides and other agro-chemical products (including insecticides, herbicides and disinfectants)",
            Category.SUBCLASS,
        ),
        Classification(
            "2022", "Manufacture of Paints, Varnishes and Similar Coatings, Printing Ink and Mastics", Category.CLASS
        ),
        Classification("20221", "Manufacture of paints", Category.SUBCLASS),
        Classification("20222", "Manufacture of varnishes and lacquers (including enamels)", Category.SUBCLASS),
        Classification(
            "20229", "Manufacture of paints, varnishes and similar coatings and mastics n.e.c.", Category.SUBCLASS
        ),
        Classification(
            "2023",
            "Manufacture of Soap and Detergents, Cleaning and Polishing Preparations, Perfumes and Toilet Preparations",
            Category.CLASS,
        ),
        Classification(
            "20231", "Manufacture of soap, detergents, washing and other cleaning preparations", Category.SUBCLASS
        ),
        Classification("20232", "Manufacture of perfumes and fragrances", Category.SUBCLASS),
        Classification("20233", "Manufacture of cosmetics and toiletries", Category.SUBCLASS),
        Classification("20234", "Manufacture of waxes and polishes and deodorising preparations", Category.SUBCLASS),
        Classification("2024", "Manufacture of Additives", Category.CLASS),
        Classification(
            "20241",
            "Manufacture of food chemicals and additives (e.g. flavours, preservatives and colourings)",
            Category.SUBCLASS,
        ),
        Classification(
            "20242", "Manufacture of additives for mineral oil (e.g. lubricant and fuel additives)", Category.SUBCLASS
        ),
        Classification("20249", "Manufacture of additives n.e.c.", Category.SUBCLASS),
        Classification("2029", "Manufacture of Other Chemical Products n.e.c.", Category.CLASS),
        Classification(
            "20291", "Manufacture of epoxy moulding compounds and phenolic moulding compounds", Category.SUBCLASS
        ),
        Classification(
            "20292", "Manufacture of ultrapure electronic chemicals, materials and laminates", Category.SUBCLASS
        ),
        Classification(
            "20293", "Manufacture of water treatment, waste treatment and oilfield chemicals", Category.SUBCLASS
        ),
        Classification("20294", "Manufacture of inks, dyestuffs, pigments and carbon black", Category.SUBCLASS),
        Classification("20295", "Manufacture of photographic film, paper, plate and chemicals", Category.SUBCLASS),
        Classification("20296", "Manufacture of adhesives and sealants", Category.SUBCLASS),
        Classification("20297", "Manufacture of catalysts and catalyst regeneration", Category.SUBCLASS),
        Classification("20298", "Manufacture of biofuels", Category.SUBCLASS),
        Classification(
            "20299",
            "Manufacture of other chemical products n.e.c. (e.g. gelatin and derivatives, laundry blue, explosives, processed salts, industrial starch, incense and joss sticks, camphor products)",
            Category.SUBCLASS,
        ),
        Classification("203", "MANUFACTURE OF MAN-MADE FIBRES", Category.GROUP),
        Classification("2030", "Manufacture of Man-Made Fibres", Category.CLASS),
        Classification("20300", "Manufacture of man-made fibres except glass", Category.SUBCLASS),
        Classification("21", "MANUFACTURE OF PHARMACEUTICALS AND BIOLOGICAL PRODUCTS", Category.DIVISION),
        Classification("210", "MANUFACTURE OF PHARMACEUTICALS AND BIOLOGICAL PRODUCTS", Category.GROUP),
        Classification("2101", "Manufacture of Pharmaceutical Products", Category.CLASS),
        Classification(
            "21011", "Manufacture of pharmaceutical intermediates and fine chemicals for human use", Category.SUBCLASS
        ),
        Classification(
            "21012",
            "Manufacture of pharmaceutical products and preparations for human use (e.g. tableted products)",
            Category.SUBCLASS,
        ),
        Classification("21013", "Manufacture of pharmaceutical products for veterinary use", Category.SUBCLASS),
        Classification("2102", "Manufacture of Biological Products", Category.CLASS),
        Classification("21021", "Manufacture of vaccines for human use", Category.SUBCLASS),
        Classification(
            "21022", "Manufacture of other biological products and preparations for human use", Category.SUBCLASS
        ),
        Classification(
            "21023", "Manufacture of biological products and preparations for veterinary use", Category.SUBCLASS
        ),
        Classification("2103", "Manufacture of Traditional Chinese Medicine", Category.CLASS),
        Classification("21030", "Manufacture of Traditional Chinese Medicine", Category.SUBCLASS),
        Classification("22", "MANUFACTURE OF RUBBER AND PLASTIC PRODUCTS", Category.DIVISION),
        Classification("221", "MANUFACTURE OF RUBBER PRODUCTS", Category.GROUP),
        Classification("2211", "Processing of Natural Rubber and Gums", Category.CLASS),
        Classification("22111", "Processing of rubber (including processing of rubber latex)", Category.SUBCLASS),
        Classification("22112", "Grading and packing of rubber", Category.SUBCLASS),
        Classification("22119", "Processing of natural gums n.e.c. (e.g. gum damar, jelutong)", Category.SUBCLASS),
        Classification(
            "2212", "Manufacture of Rubber Tyres and Tubes, Retreading and Rebuilding of Rubber Tyres", Category.CLASS
        ),
        Classification("22121", "Manufacture of tyres and tubes", Category.SUBCLASS),
        Classification("22122", "Retreading and vulcanising of tyres", Category.SUBCLASS),
        Classification("2219", "Manufacture of Other Rubber Products except Rubber Footwear and Toys", Category.CLASS),
        Classification(
            "22191", "Manufacture of foam rubber products (excluding foam rubber mattresses)", Category.SUBCLASS
        ),
        Classification("22192", "Manufacture of rubber automotive parts", Category.SUBCLASS),
        Classification("22193", "Manufacture of industrial and mechanical rubber goods", Category.SUBCLASS),
        Classification("22194", "Manufacture of rubber floorings", Category.SUBCLASS),
        Classification(
            "22199", "Manufacture of other rubber products n.e.c. (except rubber footwear and toys)", Category.SUBCLASS
        ),
        Classification("222", "MANUFACTURE OF PLASTIC PRODUCTS", Category.GROUP),
        Classification("2221", "Manufacture of Plastic Products except Plastic Footwear and Toys", Category.CLASS),
        Classification(
            "22211",
            "Manufacture of plastic tableware, household and kitchen ware (excluding disposable utensils)",
            Category.SUBCLASS,
        ),
        Classification("22212", "Manufacture of styrofoam and plastic disposable utensils", Category.SUBCLASS),
        Classification(
            "22213",
            "Manufacture of plastic sheet, film and articles thereof (e.g. polythene and polypropylene bags)",
            Category.SUBCLASS,
        ),
        Classification(
            "22214",
            "Manufacture of plastic bottles, boxes and containers (except for household use)",
            Category.SUBCLASS,
        ),
        Classification("22215", "Manufacture of plastic pipes and tubes", Category.SUBCLASS),
        Classification("22216", "Manufacture of plastic precision engineering parts", Category.SUBCLASS),
        Classification("22217", "Manufacture of PVC files, holders and albums", Category.SUBCLASS),
        Classification("22218", "Manufacture of plastic cable ties", Category.SUBCLASS),
        Classification(
            "22219", "Manufacture of plastic products n.e.c. (except plastic footwear and toys)", Category.SUBCLASS
        ),
        Classification("2222", "Plastic Product Services", Category.CLASS),
        Classification("22220", "Plastic product services", Category.SUBCLASS),
        Classification("23", "MANUFACTURE OF OTHER NON-METALLIC MINERAL PRODUCTS", Category.DIVISION),
        Classification("231", "MANUFACTURE OF GLASS AND GLASS PRODUCTS", Category.GROUP),
        Classification("2310", "Manufacture of Glass and Glass Products", Category.CLASS),
        Classification(
            "23100", "Manufacture of glass and glass products (including yarn of glass fibres)", Category.SUBCLASS
        ),
        Classification("239", "MANUFACTURE OF OTHER NON-METALLIC MINERAL PRODUCTS N.E.C.", Category.GROUP),
        Classification("2391", "Manufacture of Clay Products", Category.CLASS),
        Classification("23911", "Manufacture of bricks", Category.SUBCLASS),
        Classification(
            "23912",
            "Manufacture of tiles, pipes and channels (including clay roofing, wall and floor tiles, and earthen and glazed pipes)",
            Category.SUBCLASS,
        ),
        Classification("23919", "Manufacture of clay products n.e.c.", Category.SUBCLASS),
        Classification("2393", "Manufacture of Other Porcelain and Ceramic Products", Category.CLASS),
        Classification(
            "23931",
            "Manufacture of plumbing fixtures and fittings of vitreous china, china and earthenware (e.g. sinks, closets, bowls)",
            Category.SUBCLASS,
        ),
        Classification("23939", "Manufacture of other porcelain and ceramic products n.e.c.", Category.SUBCLASS),
        Classification("2394", "Manufacture of Cement, Lime and Plaster", Category.CLASS),
        Classification("23940", "Manufacture of cement, lime and plaster", Category.SUBCLASS),
        Classification("2395", "Manufacture of Articles of Concrete, Cement and Plaster", Category.CLASS),
        Classification("23951", "Manufacture of ready-mix concrete", Category.SUBCLASS),
        Classification(
            "23959",
            "Manufacture of articles of concrete, cement and plaster n.e.c. (except precast concrete components)",
            Category.SUBCLASS,
        ),
        Classification("2396", "Cutting, Shaping and Finishing of Stone", Category.CLASS),
        Classification(
            "23960",
            "Cutting, shaping and finishing of stone (including tomb-stones and furniture of stone or marble)",
            Category.SUBCLASS,
        ),
        Classification("2399", "Manufacture of Other Non-Metallic Mineral Products n.e.c.", Category.CLASS),
        Classification("23991", "Manufacture of asbestos products except asbestos paper", Category.SUBCLASS),
        Classification("23992", "Manufacture of fibreglass and fibreglass products", Category.SUBCLASS),
        Classification(
            "23993",
            "Manufacture of other insulation products (e.g. ceramic IC packages, refractory materials, rock wool products, insulation services)",
            Category.SUBCLASS,
        ),
        Classification(
            "23994",
            "Manufacture of non-structural pre-cast components (e.g. lightweight partitions, secondary roof slabs)",
            Category.SUBCLASS,
        ),
        Classification("23995", "Manufacture of asphalt premix", Category.SUBCLASS),
        Classification(
            "23999",
            "Manufacture of other non-metallic mineral products n.e.c. (e.g. graphite products)",
            Category.SUBCLASS,
        ),
        Classification("24", "MANUFACTURE OF BASIC METALS", Category.DIVISION),
        Classification("241", "MANUFACTURE OF BASIC IRON AND STEEL", Category.GROUP),
        Classification("2410", "Manufacture of Basic Iron and Steel", Category.CLASS),
        Classification("24101", "Iron and steel rolling mills", Category.SUBCLASS),
        Classification("24102", "Manufacture of ferrous metal alloys", Category.SUBCLASS),
        Classification("24109", "Manufacture of basic iron and steel n.e.c. (including smelting)", Category.SUBCLASS),
        Classification("242", "MANUFACTURE OF BASIC PRECIOUS AND NON-FERROUS METALS", Category.GROUP),
        Classification("2420", "Manufacture of Basic Precious and Non-Ferrous Metals", Category.CLASS),
        Classification("24201", "Tin smelting", Category.SUBCLASS),
        Classification("24202", "Manufacture of non-ferrous metal alloys", Category.SUBCLASS),
        Classification("24209", "Manufacture of basic precious and non-ferrous metals n.e.c.", Category.SUBCLASS),
        Classification("243", "CASTING OF METALS", Category.GROUP),
        Classification("2431", "Casting of Iron and Steel", Category.CLASS),
        Classification("24310", "Iron and steel foundries", Category.SUBCLASS),
        Classification("2432", "Casting of Non-Ferrous Metals", Category.CLASS),
        Classification("24320", "Non-ferrous metal foundries", Category.SUBCLASS),
        Classification(
            "25", "MANUFACTURE OF FABRICATED METAL PRODUCTS EXCEPT MACHINERY AND EQUIPMENT", Category.DIVISION
        ),
        Classification(
            "251", "MANUFACTURE OF STRUCTURAL METAL PRODUCTS, TANKS, RESERVOIRS AND STEAM GENERATORS", Category.GROUP
        ),
        Classification("2511", "Manufacture of Structural Metal Products", Category.CLASS),
        Classification(
            "25111", "Manufacture of metal doors, window and door frames, grilles and gratings", Category.SUBCLASS
        ),
        Classification("25112", "Manufacture of metal strips and slabs (e.g. awnings)", Category.SUBCLASS),
        Classification("25113", "Manufacture of metal pipes and tubes", Category.SUBCLASS),
        Classification("25114", "Manufacture of steel structural component", Category.SUBCLASS),
        Classification(
            "25119",
            "Manufacture of structural metal products n.e.c. (e.g. metal sections, corrugated sheets)",
            Category.SUBCLASS,
        ),
        Classification("2512", "Manufacture and Repair of Tanks, Reservoirs and Containers of Metal", Category.CLASS),
        Classification(
            "25120",
            "Manufacture and repair of tanks, reservoirs and containers of metal (e.g. metal cylinders, storage vessels and containers for compressed or liquefied gas)",
            Category.SUBCLASS,
        ),
        Classification(
            "2513",
            "Manufacture and Repair of Steam Generators except Central Heating Hot Water Boilers",
            Category.CLASS,
        ),
        Classification(
            "25131",
            "Manufacture and repair of heating boilers, radiators and correctors (including parts)",
            Category.SUBCLASS,
        ),
        Classification(
            "25139",
            "Manufacture and repair of steam generators n.e.c. (except central heating hot water boilers)",
            Category.SUBCLASS,
        ),
        Classification("252", "MANUFACTURE OF WEAPONS AND AMMUNITION", Category.GROUP),
        Classification("2520", "Manufacture and Repair of Weapons and Ammunition", Category.CLASS),
        Classification(
            "25200",
            "Manufacture and repair of weapons and ammunition (e.g. ordnance and accessories)",
            Category.SUBCLASS,
        ),
        Classification(
            "259", "MANUFACTURE OF OTHER FABRICATED METAL PRODUCTS; METALWORKING SERVICE ACTIVITIES", Category.GROUP
        ),
        Classification(
            "2591", "Forging, Pressing, Stamping and Roll-Forming of Metal; Powder Metallurgy", Category.CLASS
        ),
        Classification("25911", "Iron and steel and non-ferrous forgings", Category.SUBCLASS),
        Classification("25912", "Manufacture of metal caps (e.g. crown corks)", Category.SUBCLASS),
        Classification("25913", "Manufacture of leadframe", Category.SUBCLASS),
        Classification("25914", "Metal stampings except metal caps", Category.SUBCLASS),
        Classification("25919", "Pressing and roll-forming of metal and powder metallurgy n.e.c.", Category.SUBCLASS),
        Classification("2592", "Treatment and Coating of Metals", Category.CLASS),
        Classification("25921", "Electroplating and plating of metals and formed products", Category.SUBCLASS),
        Classification("25922", "Polishing of metals and formed products", Category.SUBCLASS),
        Classification("25923", "Rustproofing of metals and formed products", Category.SUBCLASS),
        Classification("25924", "Heat treatment for metals", Category.SUBCLASS),
        Classification("25929", "Metal product services n.e.c.", Category.SUBCLASS),
        Classification("2593", "Manufacture of Cutlery, Hand Tools and General Hardware", Category.CLASS),
        Classification("25931", "Manufacture of table, kitchen and other cutlery", Category.SUBCLASS),
        Classification("25932", "Manufacture of hand and edge tools", Category.SUBCLASS),
        Classification(
            "25939",
            "Manufacture of general hardware (including blacksmith shops) n.e.c. (e.g. locks and keys, hinges, clamps, hooks)",
            Category.SUBCLASS,
        ),
        Classification("2594", "Manufacture of Metal Wire and Cable Products", Category.CLASS),
        Classification(
            "25941", "Manufacture of uninsulated wire (e.g. electronic component wire, bonding wire)", Category.SUBCLASS
        ),
        Classification("25949", "Manufacture of metal wire and cable products n.e.c.", Category.SUBCLASS),
        Classification("2595", "Manufacture of Metal Cans, Containers and Related Products", Category.CLASS),
        Classification("25951", "Manufacture of tinplate cans", Category.SUBCLASS),
        Classification(
            "25952",
            "Manufacture of other tinplate and zinc articles (e.g. pails, buckets, dustbins)",
            Category.SUBCLASS,
        ),
        Classification(
            "25959",
            "Manufacture of metal cans, containers and related products n.e.c. (e.g. barrels, steel drums, kegs)",
            Category.SUBCLASS,
        ),
        Classification("2599", "Manufacture of Other Fabricated Metal Products n.e.c.", Category.CLASS),
        Classification(
            "25991",
            "Manufacture of sanitary ware of enamelled iron and metal and plumbers' ware of brass",
            Category.SUBCLASS,
        ),
        Classification(
            "25992",
            "Manufacture of plumbing, heating and related products (including parts) except electric",
            Category.SUBCLASS,
        ),
        Classification(
            "25993", "Manufacture of bolts, nuts, rivets, fasteners and screw machine products", Category.SUBCLASS
        ),
        Classification("25994", "Manufacture of pipe fittings", Category.SUBCLASS),
        Classification("25995", "Manufacture of springs", Category.SUBCLASS),
        Classification(
            "25996",
            "Manufacture of kitchen and household utensils (e.g. steel shelf, showcase counters, kitchen trolleys display racks, sink bowls and other customised kitchen equipment)",
            Category.SUBCLASS,
        ),
        Classification("25997", "Manufacture of metal precision components", Category.SUBCLASS),
        Classification("25998", "Slitting, shearing and pasting of metal sheeting", Category.SUBCLASS),
        Classification(
            "25999",
            "Manufacture of other fabricated metal products n.e.c. (including voice coil magnets)",
            Category.SUBCLASS,
        ),
        Classification("26", "MANUFACTURE OF COMPUTER, ELECTRONIC AND OPTICAL PRODUCTS", Category.DIVISION),
        Classification("261", "MANUFACTURE OF ELECTRONIC COMPONENTS AND BOARDS", Category.GROUP),
        Classification("2611", "Manufacture of Semiconductor Devices", Category.CLASS),
        Classification(
            "26111",
            "Manufacture of discrete devices (e.g. diodes, light-emitting diodes, transistors and rectifiers)",
            Category.SUBCLASS,
        ),
        Classification("26112", "Semiconductor wafer fabrication", Category.SUBCLASS),
        Classification("26113", "Assembly and testing of semiconductors", Category.SUBCLASS),
        Classification("26114", "Manufacture of solar wafers", Category.SUBCLASS),
        Classification("26115", "Manufacture of solar cells", Category.SUBCLASS),
        Classification("26119", "Manufacture of semiconductor devices n.e.c.", Category.SUBCLASS),
        Classification("2612", "Manufacture of Other Electronic Components and Boards", Category.CLASS),
        Classification("26121", "Manufacture of capacitors", Category.SUBCLASS),
        Classification("26122", "Manufacture of printed circuit boards without electronic parts", Category.SUBCLASS),
        Classification("26123", "Manufacture of printed circuit boards with electronic parts", Category.SUBCLASS),
        Classification(
            "26124",
            "Manufacture of piezo-electric devices (e.g. quartz crystals, quartz crystal filters, delay lines)",
            Category.SUBCLASS,
        ),
        Classification(
            "26125", "Manufacture of electronic display devices except light emitting diodes", Category.SUBCLASS
        ),
        Classification("26126", "Manufacture of electronic connectors", Category.SUBCLASS),
        Classification("26129", "Manufacture of other electronic components and boards n.e.c.", Category.SUBCLASS),
        Classification("262", "MANUFACTURE OF COMPUTERS AND PERIPHERAL EQUIPMENT", Category.GROUP),
        Classification("2620", "Manufacture of Computers and Peripheral Equipment", Category.CLASS),
        Classification(
            "26201",
            "Manufacture of computers and data processing equipment except computer peripheral equipment",
            Category.SUBCLASS,
        ),
        Classification(
            "26202",
            "Manufacture of disk drives (including CD-ROM drives, DVD-ROM drives, optical drives, flash drives, tape drives, solid state drives, storage subsystems)",
            Category.SUBCLASS,
        ),
        Classification("26203", "Manufacture of printers", Category.SUBCLASS),
        Classification(
            "26204", "Manufacture of smart cards and related products (e.g. smart card readers)", Category.SUBCLASS
        ),
        Classification("26209", "Manufacture of computers and peripheral equipment n.e.c.", Category.SUBCLASS),
        Classification("263", "MANUFACTURE OF COMMUNICATIONS EQUIPMENT", Category.GROUP),
        Classification("2630", "Manufacture of Communications Equipment", Category.CLASS),
        Classification(
            "26301",
            "Manufacture of telecommunications apparatus (e.g. PBX equipment, telephones except cellular)",
            Category.SUBCLASS,
        ),
        Classification("26302", "Manufacture of networking products (e.g. routers, switches)", Category.SUBCLASS),
        Classification(
            "26303", "Manufacture of wireless communications equipment (e.g. cellular phones)", Category.SUBCLASS
        ),
        Classification(
            "26304",
            "Manufacture of electronic security systems (including electronic sensors, burglar and fire alarm systems)",
            Category.SUBCLASS,
        ),
        Classification("26309", "Manufacture of communications equipment n.e.c.", Category.SUBCLASS),
        Classification("264", "MANUFACTURE OF CONSUMER ELECTRONICS", Category.GROUP),
        Classification("2640", "Manufacture of Consumer Electronics", Category.CLASS),
        Classification("26400", "Manufacture of consumer electronics", Category.SUBCLASS),
        Classification(
            "265",
            "MANUFACTURE OF MEASURING, TESTING, NAVIGATING AND CONTROL EQUIPMENT; WATCHES AND CLOCKS",
            Category.GROUP,
        ),
        Classification(
            "2651", "Manufacture and Repair of Measuring, Testing, Navigating and Control Equipment", Category.CLASS
        ),
        Classification("26511", "Manufacture and repair of engineering and scientific instruments", Category.SUBCLASS),
        Classification("26512", "Manufacture and repair of measuring devices (e.g. meters)", Category.SUBCLASS),
        Classification(
            "26513", "Manufacture and repair of process control equipment and related products", Category.SUBCLASS
        ),
        Classification("2652", "Manufacture of Watches and Clocks", Category.CLASS),
        Classification("26521", "Manufacture of fully electronic watches and clocks", Category.SUBCLASS),
        Classification(
            "26522",
            "Manufacture of electro-mechanical watches and clocks (e.g. watches and clocks with moving parts and battery)",
            Category.SUBCLASS,
        ),
        Classification("26523", "Manufacture of mechanical watches and clocks", Category.SUBCLASS),
        Classification("26524", "Manufacture of parts and accessories for watches and clocks", Category.SUBCLASS),
        Classification(
            "266", "MANUFACTURE OF IRRADIATION, ELECTROMEDICAL AND ELECTROTHERAPEUTIC EQUIPMENT", Category.GROUP
        ),
        Classification(
            "2660",
            "Manufacture and Repair of Irradiation, Electromedical and Electrotherapeutic Equipment",
            Category.CLASS,
        ),
        Classification("26601", "Manufacture and repair of electrotherapeutic devices", Category.SUBCLASS),
        Classification(
            "26602",
            "Manufacture and repair of irradiation and electromedical equipment and instruments",
            Category.SUBCLASS,
        ),
        Classification("267", "MANUFACTURE OF OPTICAL INSTRUMENTS AND PHOTOGRAPHIC EQUIPMENT", Category.GROUP),
        Classification("2670", "Manufacture of Optical Instruments and Photographic Equipment", Category.CLASS),
        Classification(
            "26701", "Manufacture of photographic equipment and parts (including lenses)", Category.SUBCLASS
        ),
        Classification(
            "26709", "Manufacture of optical instruments and photographic equipment n.e.c.", Category.SUBCLASS
        ),
        Classification("268", "MANUFACTURE OF MAGNETIC AND OPTICAL MEDIA", Category.GROUP),
        Classification("2680", "Manufacture of Magnetic and Optical Media", Category.CLASS),
        Classification("26801", "Manufacture of disk media", Category.SUBCLASS),
        Classification(
            "26802",
            "Manufacture of blank magnetic tapes, diskettes, Blu-ray technology discs, CDs, DVDs and VCDs",
            Category.SUBCLASS,
        ),
        Classification("27", "MANUFACTURE OF ELECTRICAL EQUIPMENT", Category.DIVISION),
        Classification(
            "271",
            "MANUFACTURE OF ELECTRIC MOTORS, GENERATORS, TRANSFORMERS, ELECTRICITY DISTRIBUTION AND CONTROL APPARATUS",
            Category.GROUP,
        ),
        Classification(
            "2710",
            "Manufacture and Repair of Electric Motors, Generators, Transformers, Electricity Distribution and Control Apparatus",
            Category.CLASS,
        ),
        Classification("27101", "Manufacture and repair of electric motors", Category.SUBCLASS),
        Classification("27102", "Manufacture and repair of electric generators", Category.SUBCLASS),
        Classification("27103", "Manufacture and repair of transformers", Category.SUBCLASS),
        Classification(
            "27104",
            "Manufacture and repair of switchgear and switchboard apparatus (including switches, circuit breakers and electrical control panels)",
            Category.SUBCLASS,
        ),
        Classification(
            "27109",
            "Manufacture and repair of electric motors, generators, transformers and electricity distribution and control apparatus n.e.c. (e.g. busbar trunking)",
            Category.SUBCLASS,
        ),
        Classification("272", "MANUFACTURE OF BATTERIES AND ACCUMULATORS", Category.GROUP),
        Classification("2720", "Manufacture of Batteries and Accumulators", Category.CLASS),
        Classification("27201", "Manufacture of primary batteries", Category.SUBCLASS),
        Classification("27202", "Manufacture of secondary batteries", Category.SUBCLASS),
        Classification("273", "MANUFACTURE OF WIRING AND WIRING DEVICES", Category.GROUP),
        Classification("2732", "Manufacture of Electronic and Electric Wires and Cables", Category.CLASS),
        Classification("27321", "Manufacture of telecommunications cables and wires", Category.SUBCLASS),
        Classification("27322", "Manufacture of electric power cables and wires", Category.SUBCLASS),
        Classification(
            "27323", "Manufacture of enamelled wires (used for winding of motors, transformers etc)", Category.SUBCLASS
        ),
        Classification("27324", "Manufacture of wire and cable assemblies and harnesses", Category.SUBCLASS),
        Classification(
            "27329", "Manufacture of other electronic and electric wires and cables n.e.c.", Category.SUBCLASS
        ),
        Classification("2733", "Manufacture and Repair of Wiring Devices", Category.CLASS),
        Classification("27330", "Manufacture and repair of wiring devices", Category.SUBCLASS),
        Classification("274", "MANUFACTURE OF ELECTRIC LIGHTING EQUIPMENT", Category.GROUP),
        Classification("2740", "Manufacture and Repair of Electric Lighting Equipment", Category.CLASS),
        Classification(
            "27400",
            "Manufacture and repair of electric lamps and lighting equipment (including silver reflectors, fittings and parts)",
            Category.SUBCLASS,
        ),
        Classification("275", "MANUFACTURE OF DOMESTIC APPLIANCES", Category.GROUP),
        Classification("2750", "Manufacture of Domestic Appliances", Category.CLASS),
        Classification(
            "27501",
            "Manufacture of electrical household appliances (e.g. refrigerators, hot plates, toasters, food mixers, cookers, hair dryers, fans, shavers)",
            Category.SUBCLASS,
        ),
        Classification(
            "27509",
            "Manufacture of domestic appliances n.e.c. (e.g. non-electric cooking ranges, grates, stoves)",
            Category.SUBCLASS,
        ),
        Classification("279", "MANUFACTURE OF OTHER ELECTRICAL EQUIPMENT", Category.GROUP),
        Classification("2790", "Manufacture of Other Electrical Equipment", Category.CLASS),
        Classification("27901", "Manufacture of fuel cells", Category.SUBCLASS),
        Classification(
            "27902",
            "Manufacture of electrical machinery, apparatus, appliances and supplies (including sound or visual signalling apparatus, electrical insulators except porcelain or glass)",
            Category.SUBCLASS,
        ),
        Classification("28", "MANUFACTURE OF MACHINERY AND EQUIPMENT", Category.DIVISION),
        Classification("281", "MANUFACTURE OF GENERAL PURPOSE MACHINERY", Category.GROUP),
        Classification(
            "2811",
            "Manufacture and Repair of Engines and Turbines except Aircraft, Vehicle and Cycle Engines",
            Category.CLASS,
        ),
        Classification(
            "28111",
            "Manufacture and repair of engines and turbines except aircraft, vehicle, cycle and marine engines",
            Category.SUBCLASS,
        ),
        Classification("28112", "Manufacture and repair of marine engine", Category.SUBCLASS),
        Classification("2812", "Manufacture and Repair of Pumps, Compressors, Taps and Valves", Category.CLASS),
        Classification(
            "28121", "Manufacture and repair of pumps (e.g. hydraulic pumps, drainage pumps)", Category.SUBCLASS
        ),
        Classification("28122", "Manufacture and repair of taps, cocks and valves", Category.SUBCLASS),
        Classification(
            "28129", "Manufacture and repair of pumps, compressors, taps and valves n.e.c.", Category.SUBCLASS
        ),
        Classification("2814", "Manufacture of Bearings, Gears, Gearing and Driving Elements", Category.CLASS),
        Classification("28141", "Manufacture of bearings (including disc and ball bearings)", Category.SUBCLASS),
        Classification("28142", "Manufacture and repair of gears, gearing and driving elements", Category.SUBCLASS),
        Classification("2815", "Manufacture and Repair of Ovens, Furnaces and Furnace Burners", Category.CLASS),
        Classification("28150", "Manufacture and repair of ovens, furnaces and furnace burners", Category.SUBCLASS),
        Classification("2816", "Manufacture and Repair of Lifting and Handling Equipment", Category.CLASS),
        Classification(
            "28161", "Manufacture and repair of lifting and hoisting machinery except electrical", Category.SUBCLASS
        ),
        Classification("28162", "Manufacture and repair of lifts and escalators", Category.SUBCLASS),
        Classification(
            "28169",
            "Manufacture and repair of lifting and handling equipment n.e.c. (including conveying systems and industrial automated systems)",
            Category.SUBCLASS,
        ),
        Classification(
            "2817",
            "Manufacture and Repair of Office Machinery and Equipment (except Computers and Peripheral Equipment)",
            Category.CLASS,
        ),
        Classification(
            "28171",
            "Manufacture of office machinery and equipment (except computers and peripheral equipment)",
            Category.SUBCLASS,
        ),
        Classification("28172", "Repair and maintenance of office machinery and equipment", Category.SUBCLASS),
        Classification("2818", "Manufacture and Repair of Robots", Category.CLASS),
        Classification(
            "28181",
            "Manufacture and repair of industrial robots (including Automated Guided Vehicles (AGVs))",
            Category.SUBCLASS,
        ),
        Classification("28182", "Manufacture and repair of service robots", Category.SUBCLASS),
        Classification("28189", "Manufacture and repair of robots n.e.c.", Category.SUBCLASS),
        Classification("2819", "Manufacture and Repair of Other General Purpose Machinery", Category.CLASS),
        Classification(
            "28191",
            "Manufacture and repair of refrigerating, air-conditioning and ventilating machinery and equipment except household refrigerators",
            Category.SUBCLASS,
        ),
        Classification(
            "28192",
            "Manufacture and repair of separation/mixing equipment (e.g. filters, separators, mixers)",
            Category.SUBCLASS,
        ),
        Classification("28193", "Manufacture and repair of solar modules and panels", Category.SUBCLASS),
        Classification(
            "28194",
            "Manufacture and repair of welding and soldering equipment (including arc welding electrodes)",
            Category.SUBCLASS,
        ),
        Classification("28195", "Manufacture and repair of packaging machinery", Category.SUBCLASS),
        Classification(
            "28199",
            "Manufacture and repair of other general purpose machinery and equipment except electrical and electronic n.e.c.",
            Category.SUBCLASS,
        ),
        Classification("282", "MANUFACTURE OF SPECIAL PURPOSE MACHINERY", Category.GROUP),
        Classification("2821", "Manufacture and Repair of Agricultural and Forestry Machinery", Category.CLASS),
        Classification("28210", "Manufacture and repair of agricultural and forestry machinery", Category.SUBCLASS),
        Classification("2822", "Manufacture and Repair of Metal-Forming Machinery and Machine Tools", Category.CLASS),
        Classification(
            "28221",
            "Manufacture and repair of machinery and machine-tools - metal cutting types (e.g. lathes, milling machines, shaping machines)",
            Category.SUBCLASS,
        ),
        Classification(
            "28222",
            "Manufacture and repair of machinery and machine-tools - metal forming types (e.g. forging press, cold heading machines, press breaks)",
            Category.SUBCLASS,
        ),
        Classification("28223", "Manufacture of dies, moulds, tools, jigs and fixtures", Category.SUBCLASS),
        Classification(
            "28224",
            "Manufacture of machine tool accessories (e.g. small cutting tools, precision measuring tools and other attachments such as tool holders)",
            Category.SUBCLASS,
        ),
        Classification(
            "28225",
            "Manufacture and repair of metal additive manufacturing (AM) equipment (including metal powder)",
            Category.SUBCLASS,
        ),
        Classification(
            "28229",
            "Manufacture and repair of metal-forming machinery and machine tools n.e.c. (including metalworking machinery)",
            Category.SUBCLASS,
        ),
        Classification(
            "2824", "Manufacture and Repair of Machinery for Mining, Quarrying and Construction", Category.CLASS
        ),
        Classification("28241", "Manufacture and repair of oil rigs", Category.SUBCLASS),
        Classification(
            "28242",
            "Manufacture and repair of other oilfield and gasfield machinery and equipment (e.g. derricks, tool joints)",
            Category.SUBCLASS,
        ),
        Classification("28243", "Manufacture and repair of construction machinery and parts", Category.SUBCLASS),
        Classification(
            "28249",
            "Manufacture and repair of machinery for mining, quarrying and construction n.e.c.",
            Category.SUBCLASS,
        ),
        Classification(
            "2825", "Manufacture and Repair of Machinery for Food, Beverage and Tobacco Processing", Category.CLASS
        ),
        Classification("28251", "Manufacture and repair of machinery for food products processing", Category.SUBCLASS),
        Classification("28252", "Manufacture and repair of machinery for beverage production", Category.SUBCLASS),
        Classification("28253", "Manufacture and repair of machinery for tobacco processing", Category.SUBCLASS),
        Classification(
            "2826", "Manufacture and Repair of Machinery for Textile, Apparel and Leather Production", Category.CLASS
        ),
        Classification(
            "28260",
            "Manufacture and repair of machinery for textile, apparel and leather production",
            Category.SUBCLASS,
        ),
        Classification("2827", "Manufacture and Repair of Semiconductor Related Equipment", Category.CLASS),
        Classification("28271", "Manufacture of probe cards", Category.SUBCLASS),
        Classification("28272", "Manufacture of bonding tools", Category.SUBCLASS),
        Classification(
            "28273",
            "Manufacture and repair of semiconductor assembly and testing equipment (including computer burn-in system)",
            Category.SUBCLASS,
        ),
        Classification("28274", "Manufacture and repair of semiconductor foundry equipment", Category.SUBCLASS),
        Classification("2829", "Manufacture and Repair of Other Special Purpose Machinery", Category.CLASS),
        Classification("28291", "Manufacture and repair of water/waste water treatment equipment", Category.SUBCLASS),
        Classification("28292", "Manufacture and repair of plastic processing machinery", Category.SUBCLASS),
        Classification("28293", "Manufacture and repair of woodworking machinery", Category.SUBCLASS),
        Classification(
            "28294", "Manufacture and repair of polymer additive manufacturing (AM) equipment", Category.SUBCLASS
        ),
        Classification(
            "28299",
            "Manufacture and repair of other special purpose machinery n.e.c. (including plating equipment, industrial paint mixers and chemical mixing equipment)",
            Category.SUBCLASS,
        ),
        Classification("283", "INSTALLATION OF INDUSTRIAL MACHINERY AND EQUIPMENT", Category.GROUP),
        Classification("2830", "Installation of Industrial Machinery and Equipment", Category.CLASS),
        Classification(
            "28300",
            "Installation of industrial machinery and equipment, mechanical engineering works",
            Category.SUBCLASS,
        ),
        Classification("29", "MANUFACTURE OF MOTOR VEHICLES, TRAILERS AND SEMI-TRAILERS", Category.DIVISION),
        Classification("291", "MANUFACTURE OF MOTOR VEHICLES, TRAILERS AND SEMI-TRAILERS", Category.GROUP),
        Classification("2910", "Manufacture of Motor Vehicles", Category.CLASS),
        Classification("29100", "Manufacture and assembly of motor vehicles", Category.SUBCLASS),
        Classification(
            "292",
            "MANUFACTURE OF MOTOR VEHICLE BODIES (COACHWORK, Category.GROUP), TRAILERS AND SEMI-TRAILERS",
            Category.GROUP,
        ),
        Classification(
            "2920",
            "Manufacture of Motor Vehicle Bodies (Coachwork, Category.CLASS), Trailers and Semi-Trailers",
            Category.CLASS,
        ),
        Classification(
            "29200",
            "Manufacture of motor vehicle bodies (coachwork, Category.SUBCLASS), trailers and semi-trailers",
            Category.SUBCLASS,
        ),
        Classification("293", "MANUFACTURE OF PARTS AND ACCESSORIES FOR MOTOR VEHICLES", Category.GROUP),
        Classification("2930", "Manufacture of Parts and Accessories for Motor Vehicles", Category.CLASS),
        Classification(
            "29300",
            "Manufacture of parts and accessories for motor vehicles (e.g. engine parts, brakes, clutches, axles, gear boxes)",
            Category.SUBCLASS,
        ),
        Classification("30", "MANUFACTURE OF OTHER TRANSPORT EQUIPMENT", Category.DIVISION),
        Classification("301", "BUILDING AND REPAIRING OF SHIPS AND BOATS", Category.GROUP),
        Classification("3011", "Building and Repairing of Ships and Floating Structures", Category.CLASS),
        Classification(
            "30110",
            "Building and repairing of ships, tankers and other ocean-going vessels (including conversion of ships into off-shore structures)",
            Category.SUBCLASS,
        ),
        Classification("3012", "Building of Pleasure Boats and Sporting Boats", Category.CLASS),
        Classification("30120", "Building and repair of pleasure crafts, lighters and boats", Category.SUBCLASS),
        Classification("302", "MANUFACTURE OF RAILWAY LOCOMOTIVES AND ROLLING STOCK", Category.GROUP),
        Classification("3020", "Manufacture of Railway Locomotives and Rolling Stock", Category.CLASS),
        Classification(
            "30200",
            "Manufacture and repair of railway and tramway locomotives and rolling stock (including specialised parts except engines, electric motors and signalling equipment)",
            Category.SUBCLASS,
        ),
        Classification("303", "MANUFACTURE OF AIR AND SPACECRAFT AND RELATED MACHINERY", Category.GROUP),
        Classification("3030", "Manufacture of Air and Spacecraft and Related Machinery", Category.CLASS),
        Classification(
            "30301",
            "Manufacture and assembly of aircraft and spacecraft (including aircraft engines and other parts)",
            Category.SUBCLASS,
        ),
        Classification(
            "30302",
            "Repair and servicing of aircraft and spacecraft (including aircraft engines and other parts)",
            Category.SUBCLASS,
        ),
        Classification("304", "MANUFACTURE OF MILITARY FIGHTING VEHICLES", Category.GROUP),
        Classification("3040", "Manufacture of Military Fighting Vehicles", Category.CLASS),
        Classification("30400", "Manufacture of military fighting vehicles", Category.SUBCLASS),
        Classification("309", "MANUFACTURE OF OTHER TRANSPORT EQUIPMENT N.E.C.", Category.GROUP),
        Classification("3091", "Manufacture of Motorcycles", Category.CLASS),
        Classification(
            "30910",
            "Manufacture and assembly of motorcycles and scooters (including engines and other parts and accessories)",
            Category.SUBCLASS,
        ),
        Classification("3092", "Manufacture of Bicycles and Invalid Carriages", Category.CLASS),
        Classification(
            "30920",
            "Manufacture and assembly of bicycles, tricycles, trishaws and invalid carriages (including parts and accessories)",
            Category.SUBCLASS,
        ),
        Classification("3099", "Manufacture of Other Transport Equipment n.e.c.", Category.CLASS),
        Classification(
            "30990", "Manufacture of other transport equipment n.e.c. (e.g. carts, wagons)", Category.SUBCLASS
        ),
        Classification("31", "MANUFACTURE OF FURNITURE", Category.DIVISION),
        Classification("310", "MANUFACTURE OF FURNITURE", Category.GROUP),
        Classification("3100", "Manufacture of Furniture", Category.CLASS),
        Classification(
            "31001", "Manufacture of furniture and fixtures of wood (including upholstery)", Category.SUBCLASS
        ),
        Classification("31002", "Manufacture of furniture of rattan and cane", Category.SUBCLASS),
        Classification("31003", "Manufacture of furniture and fixtures primarily of metal", Category.SUBCLASS),
        Classification(
            "31004",
            "Manufacture of furniture of other materials except primarily of stone, ceramic or concrete",
            Category.SUBCLASS,
        ),
        Classification("31005", "Manufacture of window and door screens and shades", Category.SUBCLASS),
        Classification("31006", "Manufacture of mattresses including those of foam rubber", Category.SUBCLASS),
        Classification("31009", "Manufacture of furniture n.e.c.", Category.SUBCLASS),
        Classification("32", "OTHER MANUFACTURING", Category.DIVISION),
        Classification("321", "MANUFACTURE OF JEWELLERY, BIJOUTERIE AND RELATED ARTICLES", Category.GROUP),
        Classification("3211", "Manufacture of Jewellery and Related Articles", Category.CLASS),
        Classification("32111", "Manufacture of jewellery except costume jewellery", Category.SUBCLASS),
        Classification("32112", "Manufacture of pewter ware", Category.SUBCLASS),
        Classification(
            "32119",
            "Manufacture of jewellery and related articles n.e.c. (except costume jewellery)",
            Category.SUBCLASS,
        ),
        Classification("3212", "Manufacture of Costume Jewellery and Related Articles", Category.CLASS),
        Classification("32120", "Manufacture of costume jewellery and related articles", Category.SUBCLASS),
        Classification("322", "MANUFACTURE OF MUSICAL INSTRUMENTS", Category.GROUP),
        Classification("3220", "Manufacture of Musical Instruments", Category.CLASS),
        Classification("32200", "Manufacture of musical instruments", Category.SUBCLASS),
        Classification("323", "MANUFACTURE OF SPORTS GOODS", Category.GROUP),
        Classification("3230", "Manufacture of Sports Goods", Category.CLASS),
        Classification(
            "32300",
            "Manufacture of sporting and athletic goods (including gym, diving and underwater equipment)",
            Category.SUBCLASS,
        ),
        Classification("324", "MANUFACTURE OF GAMES AND TOYS", Category.GROUP),
        Classification("3240", "Manufacture of Games and Toys", Category.CLASS),
        Classification("32400", "Manufacture of games and toys", Category.SUBCLASS),
        Classification("325", "MANUFACTURE OF MEDICAL AND DENTAL INSTRUMENTS AND SUPPLIES", Category.GROUP),
        Classification("3250", "Manufacture of Medical and Dental Instruments and Supplies", Category.CLASS),
        Classification(
            "32501",
            "Manufacture of medical research and clinical diagnostic instruments and supplies (e.g. reagents)",
            Category.SUBCLASS,
        ),
        Classification(
            "32502",
            "Manufacture of medical disposables and surgical supplies (e.g. test kits, syringes, tubes, fluid administration sets)",
            Category.SUBCLASS,
        ),
        Classification(
            "32503",
            "Manufacture of implantables and artificial limbs (e.g. heart valves, stents, orthopaedic implants)",
            Category.SUBCLASS,
        ),
        Classification(
            "32504", "Manufacture of ophthalmic goods (e.g. spectacles, contact lenses and parts)", Category.SUBCLASS
        ),
        Classification(
            "32509", "Manufacture of medical and dental tools, instruments and supplies n.e.c.", Category.SUBCLASS
        ),
        Classification("329", "OTHER MANUFACTURING N.E.C.", Category.GROUP),
        Classification("3290", "Other Manufacturing n.e.c.", Category.CLASS),
        Classification(
            "32901", "Manufacture of signs and advertising displays (including neon-lighting)", Category.SUBCLASS
        ),
        Classification("32909", "Other manufacturing industries n.e.c.", Category.SUBCLASS),
        Classification("D", "ELECTRICITY, GAS, STEAM AND AIR-CONDITIONING SUPPLY", Category.SECTION),
        Classification("35", "ELECTRICITY, GAS, STEAM AND AIR-CONDITIONING SUPPLY", Category.DIVISION),
        Classification("351", "ELECTRIC POWER GENERATION, TRANSMISSION AND DISTRIBUTION", Category.GROUP),
        Classification("3510", "Electric Power Generation, Transmission and Distribution", Category.CLASS),
        Classification("35101", "Generation of electricity by fossil fuels", Category.SUBCLASS),
        Classification(
            "35102", "Generation of electricity by other sources (e.g. solar power, biofuels etc)", Category.SUBCLASS
        ),
        Classification("35103", "Transmission, distribution and sale of electricity", Category.SUBCLASS),
        Classification("35104", "Other related services (e.g. electricity brokers, meter reading)", Category.SUBCLASS),
        Classification("352", "MANUFACTURE OF GAS; DISTRIBUTION OF GASEOUS FUELS THROUGH MAINS", Category.GROUP),
        Classification("3520", "Manufacture of Gas; Distribution of Gaseous Fuels Through Mains", Category.CLASS),
        Classification("35201", "Manufacture of gas; distribution of gaseous fuels through mains", Category.SUBCLASS),
        Classification("35202", "Processing of natural gas", Category.SUBCLASS),
        Classification("35203", "Other related services (e.g. arranging for sale of natural gas)", Category.SUBCLASS),
        Classification("353", "SUPPLY OF AIR OR WATER FOR COOLING OR HEATING PURPOSES", Category.GROUP),
        Classification("3530", "Supply of Air or Water for Cooling or Heating Purposes", Category.CLASS),
        Classification("35300", "Supply of air or water for cooling or heating purposes", Category.SUBCLASS),
        Classification("E", "WATER SUPPLY; SEWERAGE, WASTE MANAGEMENT AND REMEDIATION ACTIVITIES", Category.SECTION),
        Classification("36", "WATER COLLECTION, TREATMENT AND SUPPLY", Category.DIVISION),
        Classification("360", "WATER COLLECTION, TREATMENT AND SUPPLY", Category.GROUP),
        Classification("3600", "Water Collection, Treatment and Supply", Category.CLASS),
        Classification(
            "36000",
            "Collection, purification and distribution of water (including desalination of water)",
            Category.SUBCLASS,
        ),
        Classification("37", "SEWERAGE", Category.DIVISION),
        Classification("370", "SEWERAGE", Category.GROUP),
        Classification("3700", "Sewerage", Category.CLASS),
        Classification("37000", "Operation of sewer systems (including sewer treatment facilities)", Category.SUBCLASS),
        Classification(
            "38", "WASTE COLLECTION, TREATMENT AND DISPOSAL ACTIVITIES; MATERIALS RECOVERY", Category.DIVISION
        ),
        Classification("381", "WASTE COLLECTION", Category.GROUP),
        Classification("3810", "Collection of Waste", Category.CLASS),
        Classification("38100", "Collection of waste", Category.SUBCLASS),
        Classification("382", "WASTE TREATMENT AND DISPOSAL", Category.GROUP),
        Classification("3820", "Treatment and Disposal of Waste (including Remediation Activities)", Category.CLASS),
        Classification(
            "38200", "Treatment and disposal of waste (including remediation activities)", Category.SUBCLASS
        ),
        Classification("383", "MATERIALS RECOVERY", Category.GROUP),
        Classification("3830", "Materials Recovery", Category.CLASS),
        Classification("38301", "Recycling of metal waste and scrap", Category.SUBCLASS),
        Classification(
            "38309", "Recycling of non-metal waste n.e.c. (e.g. marine clay and oil sludge)", Category.SUBCLASS
        ),
        Classification("F", "CONSTRUCTION", Category.SECTION),
        Classification("41", "CONSTRUCTION OF BUILDINGS", Category.DIVISION),
        Classification("410", "CONSTRUCTION OF BUILDINGS", Category.GROUP),
        Classification("4100", "Construction of Buildings", Category.CLASS),
        Classification(
            "41001", "General contractors (building construction including major upgrading works)", Category.SUBCLASS
        ),
        Classification("41002", "Structural repair contractors", Category.SUBCLASS),
        Classification("41009", "Building construction n.e.c.", Category.SUBCLASS),
        Classification("42", "CIVIL ENGINEERING", Category.DIVISION),
        Classification("421", "CONSTRUCTION OF ROADS AND RAILWAYS", Category.GROUP),
        Classification("4210", "Construction of Roads and Railways", Category.CLASS),
        Classification("42101", "General contractors (non-building construction)", Category.SUBCLASS),
        Classification("42102", "Road and railway construction", Category.SUBCLASS),
        Classification("42103", "Bridge, tunnel, viaduct and expressway construction", Category.SUBCLASS),
        Classification("422", "CONSTRUCTION OF UTILITY PROJECTS", Category.GROUP),
        Classification("4220", "Construction of Utility Projects", Category.CLASS),
        Classification("42201", "Water and gas pipe-line and sewer construction", Category.SUBCLASS),
        Classification("42202", "Communications and power line construction", Category.SUBCLASS),
        Classification("429", "CONSTRUCTION OF OTHER CIVIL ENGINEERING PROJECTS", Category.GROUP),
        Classification("4290", "Construction of Other Civil Engineering Projects", Category.CLASS),
        Classification("42901", "Land reclamation works", Category.SUBCLASS),
        Classification("42902", "Dam and drainage construction", Category.SUBCLASS),
        Classification("42903", "Marine construction (e.g. harbours, piers, docks, wharves)", Category.SUBCLASS),
        Classification(
            "42909",
            "Construction of other civil engineering projects n.e.c. (e.g. playground systems)",
            Category.SUBCLASS,
        ),
        Classification("43", "SPECIALISED CONSTRUCTION ACTIVITIES", Category.DIVISION),
        Classification("431", "DEMOLITION AND SITE PREPARATION", Category.GROUP),
        Classification("4311", "Demolition", Category.CLASS),
        Classification("43110", "Wrecking and demolition works", Category.SUBCLASS),
        Classification("4312", "Site Preparation", Category.CLASS),
        Classification(
            "43121",
            "Soil investigation, treatment and stabilisation (including grouting and guniting)",
            Category.SUBCLASS,
        ),
        Classification("43122", "Excavation and earthmoving works", Category.SUBCLASS),
        Classification("43129", "Site preparation n.e.c.", Category.SUBCLASS),
        Classification("432", "ELECTRICITY, PLUMBING AND CONSTRUCTION INSTALLATION ACTIVITIES", Category.GROUP),
        Classification("4321", "Electrical Installation", Category.CLASS),
        Classification("43210", "Electrical works", Category.SUBCLASS),
        Classification("4322", "Plumbing, Heat and Air-Conditioning Installation", Category.CLASS),
        Classification(
            "43220", "Installation of plumbing, heating (non-electric) and air-conditioning systems", Category.SUBCLASS
        ),
        Classification("4329", "Other Construction Installation", Category.CLASS),
        Classification(
            "43291",
            "Installation and erection of building equipment (e.g. lifts, escalators, travellators)",
            Category.SUBCLASS,
        ),
        Classification("43292", "Installation of fire protection and security alarm systems", Category.SUBCLASS),
        Classification("43293", "Installation of building automated systems for remote monitoring", Category.SUBCLASS),
        Classification("43294", "Installation of awning and window shades", Category.SUBCLASS),
        Classification(
            "43295", "Installation of thermal and sound insulation (including solar control films)", Category.SUBCLASS
        ),
        Classification("43296", "Signcraft installation", Category.SUBCLASS),
        Classification("43299", "Other construction installation n.e.c.", Category.SUBCLASS),
        Classification("433", "BUILDING COMPLETION AND FINISHING", Category.GROUP),
        Classification("4330", "Building Completion and Finishing", Category.CLASS),
        Classification("43301", "Renovation contractors", Category.SUBCLASS),
        Classification("43302", "Tile setting and plastering", Category.SUBCLASS),
        Classification("43303", "Joinery and other woodworks (e.g. laminated or parquet flooring)", Category.SUBCLASS),
        Classification("43304", "Painting and decorating", Category.SUBCLASS),
        Classification(
            "43305", "Glass and glazing works (including mirror and shower screen installation)", Category.SUBCLASS
        ),
        Classification("43306", "Curtain walling/cladding works", Category.SUBCLASS),
        Classification("43307", "Installation of doors, gates, grilles and windows", Category.SUBCLASS),
        Classification("43309", "Building completion and finishing n.e.c.", Category.SUBCLASS),
        Classification("439", "OTHER SPECIALISED CONSTRUCTION ACTIVITIES", Category.GROUP),
        Classification("4390", "Other Specialised Construction Activities", Category.CLASS),
        Classification(
            "43901", "Foundation works (including micropiling, conventional piling and underpinning)", Category.SUBCLASS
        ),
        Classification("43902", "Brick laying, stone setting and cement works", Category.SUBCLASS),
        Classification("43903", "Roofing works (including timber carcassing)", Category.SUBCLASS),
        Classification("43904", "Production of pre-cast components", Category.SUBCLASS),
        Classification("43905", "Scaffolding works", Category.SUBCLASS),
        Classification("43906", "Sandblasting/Shotblasting works (except ships)", Category.SUBCLASS),
        Classification(
            "43907", "Production of Prefabricated Prefinished Volumetric Construction (PPVC) modules", Category.SUBCLASS
        ),
        Classification(
            "43909",
            "Other specialised construction and related activities n.e.c. (excluding online marketplaces)",
            Category.SUBCLASS,
        ),
        Classification("G", "WHOLESALE AND RETAIL TRADE", Category.SECTION),
        Classification("46", "WHOLESALE TRADE", Category.DIVISION),
        Classification("461", "WHOLESALE ON A FEE OR COMMISSION BASIS", Category.GROUP),
        Classification("4610", "Wholesale on a Fee or Commission Basis", Category.CLASS),
        Classification(
            "46100", "Wholesale on a fee or commission basis (excluding online marketplaces)", Category.SUBCLASS
        ),
        Classification("462", "WHOLESALE OF AGRICULTURAL RAW MATERIALS AND LIVE ANIMALS", Category.GROUP),
        Classification(
            "4621", "Wholesale of Agricultural Raw Materials and Live Animals except Tropical Produce", Category.CLASS
        ),
        Classification("46211", "Wholesale of cut flowers and plants", Category.SUBCLASS),
        Classification("46212", "Wholesale of aquarium fishes (including food and accessories)", Category.SUBCLASS),
        Classification(
            "46213", "Wholesale of pet birds and animals (including food and accessories)", Category.SUBCLASS
        ),
        Classification(
            "46219",
            "Wholesale of agricultural raw materials and live animals n.e.c. (excluding tropical produce)",
            Category.SUBCLASS,
        ),
        Classification("4622", "Wholesale of Tropical Produce", Category.CLASS),
        Classification("46221", "Wholesale of rubber (including rubber brokers)", Category.SUBCLASS),
        Classification("46222", "Wholesale of pepper and other spices", Category.SUBCLASS),
        Classification("46223", "Wholesale of coffee, cocoa and tea", Category.SUBCLASS),
        Classification("46224", "Wholesale of coconut", Category.SUBCLASS),
        Classification("46225", "Wholesale of palm oil", Category.SUBCLASS),
        Classification("46229", "Wholesale of tropical produce n.e.c.", Category.SUBCLASS),
        Classification("463", "WHOLESALE OF FOOD, BEVERAGES AND TOBACCO", Category.GROUP),
        Classification("4630", "Wholesale of Food, Beverages and Tobacco", Category.CLASS),
        Classification("46301", "Wholesale of fruits and vegetables (including fresh and frozen)", Category.SUBCLASS),
        Classification(
            "46302",
            "Wholesale of livestock, meat, poultry, eggs and seafood (including fresh and frozen)",
            Category.SUBCLASS,
        ),
        Classification(
            "46303",
            "Wholesale of a general line (wide range) of groceries (e.g. cereals, sugar, edible oils, sauces and dairy products)",
            Category.SUBCLASS,
        ),
        Classification("46304", "Wholesale of confectionery and bakery products", Category.SUBCLASS),
        Classification("46305", "Wholesale of ice-cream", Category.SUBCLASS),
        Classification("46306", "Wholesale of health supplements", Category.SUBCLASS),
        Classification("46307", "Wholesale of liquor, soft drinks and beverages", Category.SUBCLASS),
        Classification("46308", "Wholesale of tobacco products", Category.SUBCLASS),
        Classification(
            "46309", "Wholesale of food, beverages and tobacco n.e.c. (including dried or canned)", Category.SUBCLASS
        ),
        Classification("464", "WHOLESALE OF HOUSEHOLD GOODS", Category.GROUP),
        Classification("4641", "Wholesale of Textiles, Clothing, Footwear and Leather Goods", Category.CLASS),
        Classification("46411", "Wholesale of textiles and leathers", Category.SUBCLASS),
        Classification("46412", "Wholesale of adults' clothing", Category.SUBCLASS),
        Classification(
            "46413",
            "Wholesale of children and infants’ clothing (including products and accessories for infants)",
            Category.SUBCLASS,
        ),
        Classification("46414", "Wholesale of footwear", Category.SUBCLASS),
        Classification("46415", "Wholesale of bags, luggage and travel accessories", Category.SUBCLASS),
        Classification(
            "46416",
            "Wholesale of sewing and clothing accessories (e.g. button, thread, lace, zip, belt, tie)",
            Category.SUBCLASS,
        ),
        Classification("4642", "Wholesale of Personal Effects", Category.CLASS),
        Classification("46421", "Wholesale of jewellery made from precious metals and stones", Category.SUBCLASS),
        Classification("46422", "Wholesale of costume jewellery", Category.SUBCLASS),
        Classification("46423", "Wholesale of watches and clocks", Category.SUBCLASS),
        Classification("46424", "Wholesale of cosmetics and toiletries", Category.SUBCLASS),
        Classification("46429", "Wholesale of personal effects n.e.c.", Category.SUBCLASS),
        Classification(
            "4643", "Wholesale of Furniture, Home Furnishings and Other Household Equipment", Category.CLASS
        ),
        Classification("46431", "Wholesale of furniture (including mattresses, cushions)", Category.SUBCLASS),
        Classification("46432", "Wholesale of furnishings (including curtains, carpets, wallpaper)", Category.SUBCLASS),
        Classification("46433", "Wholesale of lighting and lighting accessories", Category.SUBCLASS),
        Classification("46434", "Wholesale of crockery, cutlery and kitchen utensils", Category.SUBCLASS),
        Classification(
            "46435",
            "Wholesale of household electrical appliances and equipment (including household air-conditioners)",
            Category.SUBCLASS,
        ),
        Classification(
            "46436",
            "Wholesale of audio and video equipment except electrical and electronic components (e.g. radio and television sets, sound reproducing and recording equipment)",
            Category.SUBCLASS,
        ),
        Classification("46437", "Wholesale of musical instruments and scores", Category.SUBCLASS),
        Classification(
            "46439", "Wholesale of furniture, home furnishings and other household equipment n.e.c.", Category.SUBCLASS
        ),
        Classification("4644", "Wholesale of Sporting and Other Recreational Goods", Category.CLASS),
        Classification(
            "46441",
            "Wholesale of sporting goods and equipment (including bicycles and healthcare equipment)",
            Category.SUBCLASS,
        ),
        Classification(
            "46442", "Wholesale of music and video recordings (e.g. DVDs, Blu-ray discs)", Category.SUBCLASS
        ),
        Classification("46443", "Wholesale of toys and games", Category.SUBCLASS),
        Classification(
            "46444",
            "Wholesale of computer games (including electronic games and video game consoles)",
            Category.SUBCLASS,
        ),
        Classification("46449", "Wholesale of sporting and other recreational goods n.e.c.", Category.SUBCLASS),
        Classification("4645", "Wholesale of Handicrafts and Fancy Goods", Category.CLASS),
        Classification("46451", "Wholesale of antiques and works of art", Category.SUBCLASS),
        Classification("46452", "Wholesale of handicrafts and gifts", Category.SUBCLASS),
        Classification("46453", "Wholesale of artificial flowers and plants", Category.SUBCLASS),
        Classification("46459", "Wholesale of handicrafts and fancy goods n.e.c.", Category.SUBCLASS),
        Classification("4646", "Wholesale of Medicinal and Pharmaceutical Products", Category.CLASS),
        Classification("46461", "Wholesale of medicinal and pharmaceutical products (Western)", Category.SUBCLASS),
        Classification("46462", "Wholesale of medicine and herbs (other than Western)", Category.SUBCLASS),
        Classification(
            "4647",
            "Wholesale of Paper, Paper-Related Products, Stationery, Cellophane Products and Packaging Materials",
            Category.CLASS,
        ),
        Classification("46471", "Wholesale of paper and paper products", Category.SUBCLASS),
        Classification("46472", "Wholesale of packaging materials", Category.SUBCLASS),
        Classification("46473", "Wholesale of stationery", Category.SUBCLASS),
        Classification("46474", "Wholesale of books and magazines", Category.SUBCLASS),
        Classification(
            "46479", "Wholesale of paper, paper and cellophane products and stationery n.e.c.", Category.SUBCLASS
        ),
        Classification("4649", "Wholesale of Other Household Goods", Category.CLASS),
        Classification(
            "46491", "Wholesale of optical equipment and supplies (excluding binoculars)", Category.SUBCLASS
        ),
        Classification(
            "46492", "Wholesale of photographic equipment and supplies (including binoculars)", Category.SUBCLASS
        ),
        Classification("46499", "Wholesale of other household goods n.e.c.", Category.SUBCLASS),
        Classification("465", "WHOLESALE OF MACHINERY, EQUIPMENT AND SUPPLIES", Category.GROUP),
        Classification("4651", "Wholesale of Computers, Computer Peripheral Equipment and Software", Category.CLASS),
        Classification(
            "46511",
            "Wholesale of computer hardware and peripheral equipment (except cybersecurity related hardware and peripheral equipment)",
            Category.SUBCLASS,
        ),
        Classification(
            "46512", "Wholesale of computer software (except games and cybersecurity software)", Category.SUBCLASS
        ),
        Classification(
            "46513", "Wholesale of computer accessories (e.g. memory cards, computer cables)", Category.SUBCLASS
        ),
        Classification(
            "46514", "Wholesale of cybersecurity software, hardware and peripheral equipment", Category.SUBCLASS
        ),
        Classification("4652", "Wholesale of Electronic and Telecommunications Equipment and Parts", Category.CLASS),
        Classification("46521", "Wholesale of telecommunications equipment (excluding handphones)", Category.SUBCLASS),
        Classification("46522", "Wholesale of electronic components", Category.SUBCLASS),
        Classification(
            "46523",
            "Wholesale of handphones, handphone peripheral equipment and other telecommunications equipment",
            Category.SUBCLASS,
        ),
        Classification("4653", "Wholesale of Agricultural Machinery, Equipment and Supplies", Category.CLASS),
        Classification("46530", "Wholesale of agricultural machinery, equipment and supplies", Category.SUBCLASS),
        Classification(
            "4654", "Wholesale of Industrial, Construction and Related Machinery and Equipment", Category.CLASS
        ),
        Classification(
            "46541", "Wholesale of industrial machinery and equipment (e.g. industrial crane)", Category.SUBCLASS
        ),
        Classification("46542", "Wholesale of construction equipment (e.g. concrete mixer)", Category.SUBCLASS),
        Classification(
            "46543",
            "Wholesale of lifts, escalators and industrial and office air-conditioning equipment",
            Category.SUBCLASS,
        ),
        Classification("46544", "Wholesale of electrical and wiring accessories", Category.SUBCLASS),
        Classification(
            "46549",
            "Wholesale of industrial, construction and related machinery and equipment n.e.c.",
            Category.SUBCLASS,
        ),
        Classification(
            "4655", "Wholesale of Transport Equipment except Motor Vehicles and Motorcycles", Category.CLASS
        ),
        Classification(
            "46551",
            "Wholesale of marine equipment and accessories (including marine navigational equipment and radar)",
            Category.SUBCLASS,
        ),
        Classification(
            "46552",
            "Wholesale of aircraft equipment and supplies (including aeronautical equipment)",
            Category.SUBCLASS,
        ),
        Classification(
            "46559", "Wholesale of transport equipment except motor vehicles and motorcycles n.e.c.", Category.SUBCLASS
        ),
        Classification("4656", "Wholesale of Motor Vehicles, Parts and Accessories", Category.CLASS),
        Classification("46561", "Wholesale of motor vehicles except motorcycles and scooters", Category.SUBCLASS),
        Classification("46562", "Wholesale of motorcycles and scooters", Category.SUBCLASS),
        Classification("46563", "Wholesale of parts and accessories for vehicles", Category.SUBCLASS),
        Classification("4659", "Wholesale of Other Machinery and Equipment", Category.CLASS),
        Classification(
            "46591", "Wholesale of office machines and equipment (including accessories)", Category.SUBCLASS
        ),
        Classification(
            "46592", "Wholesale of medical, professional, scientific and precision equipment", Category.SUBCLASS
        ),
        Classification(
            "46593", "Wholesale of commercial food service equipment (e.g. hotel kitchen equipment)", Category.SUBCLASS
        ),
        Classification(
            "46594",
            "Wholesale of service establishment equipment and supplies (e.g. beauty salon equipment)",
            Category.SUBCLASS,
        ),
        Classification("46595", "Wholesale of security and safety equipment", Category.SUBCLASS),
        Classification("46599", "Wholesale of other machinery and equipment n.e.c.", Category.SUBCLASS),
        Classification("466", "OTHER SPECIALISED WHOLESALE", Category.GROUP),
        Classification("4661", "Wholesale of Fuels and Related Products", Category.CLASS),
        Classification("46610", "Wholesale of fuels and related products", Category.SUBCLASS),
        Classification("4662", "Wholesale of Metals and Metal Ores", Category.CLASS),
        Classification(
            "46620", "Wholesale of metals and metal ores (e.g. steel pipes) except general hardware", Category.SUBCLASS
        ),
        Classification(
            "4663",
            "Wholesale of Construction Materials, Hardware, Plumbing and Heating Equipment and Supplies",
            Category.CLASS,
        ),
        Classification("46631", "Wholesale of logs, sawn timber, plywood and related products", Category.SUBCLASS),
        Classification("46632", "Wholesale of general hardware (e.g. locks, hinges)", Category.SUBCLASS),
        Classification(
            "46633", "Wholesale of structural clay and concrete products (e.g. mosaic tiles, bricks)", Category.SUBCLASS
        ),
        Classification("46634", "Wholesale of paints (including varnishes and supplies)", Category.SUBCLASS),
        Classification("46635", "Wholesale of glass", Category.SUBCLASS),
        Classification(
            "46639",
            "Wholesale of construction materials, hardware, plumbing and heating equipment and supplies n.e.c. (e.g. cement, sand)",
            Category.SUBCLASS,
        ),
        Classification("4664", "Wholesale of Chemicals and Chemical Products", Category.CLASS),
        Classification("46641", "Wholesale of basic industrial chemicals (except fertilisers)", Category.SUBCLASS),
        Classification("46642", "Wholesale of chemical fertilisers", Category.SUBCLASS),
        Classification("46643", "Wholesale of petrochemical products", Category.SUBCLASS),
        Classification("46649", "Wholesale of chemicals and chemical products n.e.c.", Category.SUBCLASS),
        Classification("4665", "Wholesale of Other Intermediate Products, Waste and Scrap", Category.CLASS),
        Classification("46651", "Wholesale of scrap, junk and waste dealers", Category.SUBCLASS),
        Classification("46659", "Wholesale of other intermediate products, waste and scrap n.e.c.", Category.SUBCLASS),
        Classification("4666", "Ship Chandlers and Ship Bunkering", Category.CLASS),
        Classification("46661", "Ship chandlers", Category.SUBCLASS),
        Classification("46662", "Ship bunkering", Category.SUBCLASS),
        Classification("469", "NON-SPECIALISED WHOLESALE TRADE", Category.GROUP),
        Classification("4690", "Non-specialised Wholesale Trade", Category.CLASS),
        Classification("46900", "Wholesale trade of a variety of goods without a dominant product", Category.SUBCLASS),
        Classification("47", "RETAIL TRADE", Category.DIVISION),
        Classification("471", "RETAIL SALE IN NON-SPECIALISED STORES", Category.GROUP),
        Classification("4710", "Retail Sale in Non-Specialised Stores", Category.CLASS),
        Classification("47101", "Supermarkets and hypermarkets", Category.SUBCLASS),
        Classification("47102", "Mini-marts, convenience stores and provision shops", Category.SUBCLASS),
        Classification("47103", "Department stores", Category.SUBCLASS),
        Classification("47109", "Retail sale in other non-specialised stores n.e.c.", Category.SUBCLASS),
        Classification("472", "RETAIL SALE OF FOOD, BEVERAGES AND TOBACCO IN SPECIALISED STORES", Category.GROUP),
        Classification("4721", "Retail Sale of Food in Specialised Stores", Category.CLASS),
        Classification("47211", "Retail sale of fruits and vegetables", Category.SUBCLASS),
        Classification("47212", "Retail sale of meat, poultry, eggs and seafood", Category.SUBCLASS),
        Classification(
            "47213", "Retail sale of confectionery and bakery products (not manufactured on site)", Category.SUBCLASS
        ),
        Classification("47214", "Retail sale of health supplements", Category.SUBCLASS),
        Classification("47219", "Retail sale of food n.e.c.", Category.SUBCLASS),
        Classification("4722", "Retail Sale of Beverages in Specialised Stores", Category.CLASS),
        Classification("47220", "Retail sale of beverages", Category.SUBCLASS),
        Classification("4723", "Retail Sale of Tobacco Products in Specialised Stores", Category.CLASS),
        Classification("47230", "Retail sale of tobacco products", Category.SUBCLASS),
        Classification(
            "473",
            "RETAIL SALE OF MOTOR VEHICLES, PARTS, ACCESSORIES AND AUTOMOTIVE FUEL IN SPECIALISED STORES",
            Category.GROUP,
        ),
        Classification(
            "4731", "Retail Sale of Motor Vehicles, Parts and Accessories in Specialised Stores", Category.CLASS
        ),
        Classification("47311", "Retail sale of motor vehicles except motorcycles and scooters", Category.SUBCLASS),
        Classification("47312", "Retail sale of motorcycles and scooters", Category.SUBCLASS),
        Classification("47313", "Retail sale of tyres and batteries", Category.SUBCLASS),
        Classification("47314", "Retail sale of spare parts and accessories for motor vehicles", Category.SUBCLASS),
        Classification("4732", "Retail Sale of Automotive Fuel in Specialised Stores", Category.CLASS),
        Classification(
            "47320", "Retail sale of automotive fuel (e.g. petrol kiosks, CNG refilling stations)", Category.SUBCLASS
        ),
        Classification(
            "474", "RETAIL SALE OF INFORMATION AND COMMUNICATIONS EQUIPMENT IN SPECIALISED STORES", Category.GROUP
        ),
        Classification(
            "4741",
            "Retail Sale of Computers, Peripheral Equipment, Software and Telecommunications Equipment in Specialised Stores",
            Category.CLASS,
        ),
        Classification("47411", "Retail sale of handphones and peripheral equipment", Category.SUBCLASS),
        Classification(
            "47412",
            "Retail sale of computer hardware (including handheld computers) and peripheral equipment, and computer software (except games and cybersecurity hardware and software)",
            Category.SUBCLASS,
        ),
        Classification(
            "47413",
            "Retail sale of computer games (including electronic games and video game consoles)",
            Category.SUBCLASS,
        ),
        Classification(
            "47414",
            "Retail sale of computer and office equipment consumables (e.g. printer cartridges)",
            Category.SUBCLASS,
        ),
        Classification(
            "47415", "Retail sale of cybersecurity software, hardware and peripheral equipment", Category.SUBCLASS
        ),
        Classification("4742", "Retail Sale of Audio and Video Equipment in Specialised Stores", Category.CLASS),
        Classification(
            "47420",
            "Retail sale of audio and video equipment (e.g. radio and television sets, sound reproducing and recording equipment)",
            Category.SUBCLASS,
        ),
        Classification("475", "RETAIL SALE OF OTHER HOUSEHOLD EQUIPMENT IN SPECIALISED STORES", Category.GROUP),
        Classification("4751", "Retail Sale of Textiles in Specialised Stores", Category.CLASS),
        Classification("47510", "Retail sale of textiles", Category.SUBCLASS),
        Classification("4752", "Retail Sale of Hardware, Paint and Glass in Specialised Stores", Category.CLASS),
        Classification("47521", "Retail sale of paints", Category.SUBCLASS),
        Classification("47522", "Retail sale of hardware (e.g. chains, changkols, axes)", Category.SUBCLASS),
        Classification(
            "47529",
            "Retail sale of hardware, paint and glass n.e.c. (e.g. wood, glass, sanitary ware, Do-It-Yourself materials)",
            Category.SUBCLASS,
        ),
        Classification(
            "4753",
            "Retail Sale of Electrical Household Appliances, Furniture, Lighting Equipment and Other Household Articles in Specialised Stores",
            Category.CLASS,
        ),
        Classification("47531", "Retail sale of furniture (including mattresses, cushions)", Category.SUBCLASS),
        Classification("47532", "Retail sale of furnishings (e.g. curtains, carpets, pillow cases)", Category.SUBCLASS),
        Classification("47533", "Retail sale of lighting and lighting accessories", Category.SUBCLASS),
        Classification("47534", "Retail sale of crockery, cutlery and kitchen utensils", Category.SUBCLASS),
        Classification(
            "47535",
            "Retail sale of household electrical appliances and equipment (e.g. vacuum cleaners, washing machines, refrigerators)",
            Category.SUBCLASS,
        ),
        Classification("47536", "Retail sale of musical instruments and scores", Category.SUBCLASS),
        Classification("47537", "Retail sale of security and safety equipment", Category.SUBCLASS),
        Classification(
            "47539",
            "Retail sale of electrical household appliances, furniture, lighting equipment and other household articles n.e.c.",
            Category.SUBCLASS,
        ),
        Classification("476", "RETAIL SALE OF CULTURAL AND RECREATION GOODS IN SPECIALISED STORES", Category.GROUP),
        Classification("4761", "Retail Sale of Books, Newspapers and Stationery in Specialised Stores", Category.CLASS),
        Classification(
            "47610", "Retail sale of books, newspapers and stationery (including newsvendors)", Category.SUBCLASS
        ),
        Classification("4762", "Retail Sale of Music and Video Recordings in Specialised Stores", Category.CLASS),
        Classification(
            "47620", "Retail sale of music and video recordings (e.g. DVDs, Blu-ray discs)", Category.SUBCLASS
        ),
        Classification("4763", "Retail Sale of Sporting Equipment in Specialised Stores", Category.CLASS),
        Classification(
            "47630",
            "Retail sale of sports apparel and equipment (including bicycles, boats and healthcare equipment)",
            Category.SUBCLASS,
        ),
        Classification("4764", "Retail Sale of Games and Toys in Specialised Stores", Category.CLASS),
        Classification("47640", "Retail sale of games and toys", Category.SUBCLASS),
        Classification("477", "RETAIL SALE OF OTHER GOODS IN SPECIALISED STORES", Category.GROUP),
        Classification(
            "4771", "Retail Sale of Clothing, Footwear and Leather Articles in Specialised Stores", Category.CLASS
        ),
        Classification("47711", "Retail sale of clothing for adults", Category.SUBCLASS),
        Classification(
            "47712",
            "Retail sale of children and infants’ clothing (including products and accessories for infants)",
            Category.SUBCLASS,
        ),
        Classification("47713", "Retail sale of footwear", Category.SUBCLASS),
        Classification("47714", "Retail sale of bags, luggage and travel accessories", Category.SUBCLASS),
        Classification(
            "47715",
            "Retail sale of sewing and clothing accessories (e.g. button, thread, lace, zip, belt, tie)",
            Category.SUBCLASS,
        ),
        Classification("47719", "Retail sale of clothing, footwear and leather articles n.e.c.", Category.SUBCLASS),
        Classification(
            "4772",
            "Retail Sale of Pharmaceutical and Medical Goods, Cosmetics and Toilet Articles in Specialised Stores",
            Category.CLASS,
        ),
        Classification(
            "47721", "Retail sale of cosmetics and toiletries (including skin care products)", Category.SUBCLASS
        ),
        Classification("47722", "Pharmacies and drug stores (Western)", Category.SUBCLASS),
        Classification("47723", "Chinese medicine shops", Category.SUBCLASS),
        Classification("47729", "Retail sale of pharmaceutical and medical goods n.e.c.", Category.SUBCLASS),
        Classification("4773", "Retail Sale of Personal Effects in Specialised Stores", Category.CLASS),
        Classification("47731", "Retail sale of jewellery made from precious metals and stones", Category.SUBCLASS),
        Classification("47732", "Retail sale of costume jewellery", Category.SUBCLASS),
        Classification("47733", "Retail sale of watches and clocks", Category.SUBCLASS),
        Classification("47739", "Retail sale of personal effects n.e.c.", Category.SUBCLASS),
        Classification(
            "4774",
            "Retail Sale of Handicrafts and Fancy Goods, Flowers, Plants and Pet Animals in Specialised Stores",
            Category.CLASS,
        ),
        Classification("47741", "Retail sale of antiques and works of art", Category.SUBCLASS),
        Classification("47742", "Retail sale of handicrafts, collectibles and gifts", Category.SUBCLASS),
        Classification("47743", "Retail sale of cut flowers (including wreaths)", Category.SUBCLASS),
        Classification("47744", "Retail sale of artificial flowers and plants", Category.SUBCLASS),
        Classification("47745", "Retail sale of aquarium fishes (including food and accessories)", Category.SUBCLASS),
        Classification(
            "47746", "Retail sale of pet birds and animals (including food and accessories)", Category.SUBCLASS
        ),
        Classification(
            "47749",
            "Retail sale of handicrafts and fancy goods, flowers, plants and pet animals n.e.c.",
            Category.SUBCLASS,
        ),
        Classification("4775", "Retail Sale of Optical and Photographic Goods in Specialised Stores", Category.CLASS),
        Classification("47751", "Retail sale of spectacles and other optical goods", Category.SUBCLASS),
        Classification("47752", "Retail sale of cameras and other photographic goods", Category.SUBCLASS),
        Classification("47759", "Retail sale of optical and photographic goods n.e.c.", Category.SUBCLASS),
        Classification("4776", "Retail Sale of Other Goods in Specialised Stores", Category.CLASS),
        Classification("47761", "Retail sale of joss paper and other ceremonial products", Category.SUBCLASS),
        Classification("47762", "Retail sale of liquefied petroleum gas (LPG)", Category.SUBCLASS),
        Classification("47769", "Retail sale of specific commodities n.e.c.", Category.SUBCLASS),
        Classification("4777", "Retail Sale of Second-Hand Goods in Stores", Category.CLASS),
        Classification("47770", "Retail sale of second-hand goods in stores", Category.SUBCLASS),
        Classification("478", "RETAIL SALE VIA STALLS AND MARKETS", Category.GROUP),
        Classification(
            "4780", "Retail Sale via Stalls and Markets of Uncooked Food and Other Commodities", Category.CLASS
        ),
        Classification("47801", "Stalls (including pushcarts) selling uncooked food", Category.SUBCLASS),
        Classification(
            "47802",
            "Stalls (including pushcarts) selling other commodities (other than uncooked food)",
            Category.SUBCLASS,
        ),
        Classification("H", "TRANSPORTATION AND STORAGE", Category.SECTION),
        Classification("49", "LAND TRANSPORT AND TRANSPORT VIA PIPELINES", Category.DIVISION),
        Classification("491", "TRANSPORT VIA RAILWAYS", Category.GROUP),
        Classification("4910", "Passenger and Freight Rail Transport", Category.CLASS),
        Classification("49101", "Railroad services", Category.SUBCLASS),
        Classification("49102", "Mass rapid transit systems (including light rail)", Category.SUBCLASS),
        Classification("492", "OTHER LAND TRANSPORT", Category.GROUP),
        Classification("4921", "Passenger Land Transport", Category.CLASS),
        Classification("49211", "Public bus services (scheduled services)", Category.SUBCLASS),
        Classification("49212", "Chartered bus services (including school buses)", Category.SUBCLASS),
        Classification("49213", "Inter-country bus services", Category.SUBCLASS),
        Classification("49214", "Street-hail and ride-hail service providers", Category.SUBCLASS),
        Classification(
            "49215",
            "Rental and leasing of cars with driver (excluding street-hail and ride-hail service providers)",
            Category.SUBCLASS,
        ),
        Classification("4922", "Aerial Cableways", Category.CLASS),
        Classification("49220", "Aerial cableways (including cable car services)", Category.SUBCLASS),
        Classification("4923", "Freight Land Transport", Category.CLASS),
        Classification("49231", "Freight transport by road", Category.SUBCLASS),
        Classification("49232", "Moving services", Category.SUBCLASS),
        Classification(
            "49233",
            "Rental and leasing of freight land transport vehicle (e.g. lorries and trucks) with driver",
            Category.SUBCLASS,
        ),
        Classification("493", "TRANSPORT VIA PIPELINES", Category.GROUP),
        Classification("4930", "Transport via Pipelines", Category.CLASS),
        Classification("49300", "Transport via pipelines", Category.SUBCLASS),
        Classification("50", "WATER TRANSPORT", Category.DIVISION),
        Classification("500", "WATER TRANSPORT", Category.GROUP),
        Classification("5001", "Passenger Water Transport", Category.CLASS),
        Classification("50011", "International cruise services", Category.SUBCLASS),
        Classification(
            "50012", "Other sight-seeing cruise services (e.g. harbour and river cruises)", Category.SUBCLASS
        ),
        Classification("50013", "Passenger ferry services", Category.SUBCLASS),
        Classification("50014", "Chartering of ships and boats with crew (passenger)", Category.SUBCLASS),
        Classification("5002", "Freight Water Transport", Category.CLASS),
        Classification(
            "50021",
            "Shipping companies, including chartering of ships and boats with crew (freight)",
            Category.SUBCLASS,
        ),
        Classification(
            "50022", "Operators and charterers of barges, tugboats and bumboats (freight)", Category.SUBCLASS
        ),
        Classification("50023", "Branches of foreign shipping lines", Category.SUBCLASS),
        Classification("51", "AIR TRANSPORT", Category.DIVISION),
        Classification("510", "AIR TRANSPORT", Category.GROUP),
        Classification("5100", "Air Transport", Category.CLASS),
        Classification("51001", "Airlines (passenger)", Category.SUBCLASS),
        Classification("51002", "Airlines (freight)", Category.SUBCLASS),
        Classification("51003", "Branches of foreign airlines (passenger)", Category.SUBCLASS),
        Classification("51004", "Branches of foreign airlines (freight)", Category.SUBCLASS),
        Classification("51005", "Aircraft chartering with operator", Category.SUBCLASS),
        Classification("52", "WAREHOUSING AND SUPPORT ACTIVITIES FOR TRANSPORTATION", Category.DIVISION),
        Classification("521", "WAREHOUSING AND STORAGE", Category.GROUP),
        Classification("5210", "Warehousing and Storage", Category.CLASS),
        Classification("52101", "General warehousing", Category.SUBCLASS),
        Classification("52102", "Refrigerated warehousing and storage", Category.SUBCLASS),
        Classification("52103", "Storage for dangerous goods", Category.SUBCLASS),
        Classification(
            "52109",
            "Specialised storage n.e.c. (e.g. wine warehousing, document storage and warehousing)",
            Category.SUBCLASS,
        ),
        Classification("522", "SUPPORT ACTIVITIES FOR TRANSPORTATION", Category.GROUP),
        Classification("5221", "Supporting Services to Land Transport", Category.CLASS),
        Classification("52211", "Carpark management and operation services", Category.SUBCLASS),
        Classification("52212", "Motor vehicle towing services", Category.SUBCLASS),
        Classification("52219", "Supporting services to land transport n.e.c.", Category.SUBCLASS),
        Classification("5222", "Supporting Services to Water Transport", Category.CLASS),
        Classification("52221", "Representative offices of foreign shipping lines", Category.SUBCLASS),
        Classification("52222", "Shipping agencies (freight)", Category.SUBCLASS),
        Classification("52223", "Port operators", Category.SUBCLASS),
        Classification("52224", "Lighterage services", Category.SUBCLASS),
        Classification("52225", "Salvaging of distressed vessels and cargos", Category.SUBCLASS),
        Classification("52226", "Ship management services", Category.SUBCLASS),
        Classification("52227", "Ship brokering services", Category.SUBCLASS),
        Classification("52229", "Supporting services to water transport n.e.c.", Category.SUBCLASS),
        Classification("5223", "Supporting Services to Air Transport", Category.CLASS),
        Classification("52231", "Representative offices of foreign airlines", Category.SUBCLASS),
        Classification("52232", "Airline agencies (freight)", Category.SUBCLASS),
        Classification("52233", "Airport operation services", Category.SUBCLASS),
        Classification("52234", "Airport terminal services (e.g. ground service activities)", Category.SUBCLASS),
        Classification("52239", "Supporting services to air transport n.e.c.", Category.SUBCLASS),
        Classification("5224", "Cargo Handling", Category.CLASS),
        Classification("52241", "Container depot services", Category.SUBCLASS),
        Classification("52242", "Crane services for all industries except construction", Category.SUBCLASS),
        Classification("52243", "Stevedoring services", Category.SUBCLASS),
        Classification("5225", "Marine Surveying Services and Classification Societies", Category.CLASS),
        Classification("52251", "Classification societies", Category.SUBCLASS),
        Classification("52252", "Marine surveying services other than classification societies", Category.SUBCLASS),
        Classification("5229", "Other Transportation Support Activities", Category.CLASS),
        Classification("52291", "Cargo surveying services", Category.SUBCLASS),
        Classification("52292", "Freight transport arrangement", Category.SUBCLASS),
        Classification("53", "POSTAL AND COURIER ACTIVITIES", Category.DIVISION),
        Classification("531", "POSTAL ACTIVITIES", Category.GROUP),
        Classification("5310", "National Post Activities", Category.CLASS),
        Classification("53100", "National post activities (e.g. postal services)", Category.SUBCLASS),
        Classification("532", "COURIER ACTIVITIES", Category.GROUP),
        Classification("5320", "Courier Activities Other than National Post Activities", Category.CLASS),
        Classification("53200", "Courier activities other than national post activities", Category.SUBCLASS),
        Classification("I", "ACCOMMODATION AND FOOD SERVICE ACTIVITIES", Category.SECTION),
        Classification("55", "ACCOMMODATION", Category.DIVISION),
        Classification("551", "SHORT TERM ACCOMMODATION ACTIVITIES", Category.GROUP),
        Classification("5510", "Short Term Accommodation Activities", Category.CLASS),
        Classification("55101", "Hotels", Category.SUBCLASS),
        Classification("55102", "Chalets", Category.SUBCLASS),
        Classification("55103", "Short term accommodation activities other than hotels and chalets", Category.SUBCLASS),
        Classification("559", "HOSTELS AND DORMITORIES FOR STUDENTS, WORKERS AND OTHER INDIVIDUALS", Category.GROUP),
        Classification("5590", "Hostels and dormitories for students, workers and other individuals", Category.CLASS),
        Classification(
            "55900", "Hostels and dormitories for students, workers and other individuals", Category.SUBCLASS
        ),
        Classification("56", "FOOD AND BEVERAGE SERVICE ACTIVITIES", Category.DIVISION),
        Classification("561", "RESTAURANTS, CAFES, FOOD COURTS, FOOD KIOSKS AND BARS", Category.GROUP),
        Classification("5611", "Restaurants and Cafes", Category.CLASS),
        Classification("56111", "Restaurants", Category.SUBCLASS),
        Classification("56112", "Cafes", Category.SUBCLASS),
        Classification("5612", "Fast Food Outlets, Food Courts and Food Kiosks", Category.CLASS),
        Classification("56121", "Fast food outlets", Category.SUBCLASS),
        Classification(
            "56122", "Food courts, coffee shops and canteens (with mainly food and beverage income)", Category.SUBCLASS
        ),
        Classification("56123", "Food kiosks mainly for takeaway and delivery", Category.SUBCLASS),
        Classification("5613", "Pubs", Category.CLASS),
        Classification("56130", "Pubs", Category.SUBCLASS),
        Classification("5614", "Stalls Selling Cooked Food and Prepared Drinks", Category.CLASS),
        Classification(
            "56140",
            "Stalls selling cooked food and prepared drinks (including stalls at food courts and mobile food hawkers)",
            Category.SUBCLASS,
        ),
        Classification("562", "FOOD CATERERS", Category.GROUP),
        Classification("5620", "Food Caterers", Category.CLASS),
        Classification("56200", "Food caterers", Category.SUBCLASS),
        Classification("J", "INFORMATION AND COMMUNICATIONS", Category.SECTION),
        Classification("58", "PUBLISHING ACTIVITIES", Category.DIVISION),
        Classification("581", "PUBLISHING OF BOOKS, PERIODICALS AND OTHER PUBLISHING ACTIVITIES", Category.GROUP),
        Classification("5811", "Book Publishing", Category.CLASS),
        Classification(
            "58110", "Publishing of books, brochures, musical books and other publications", Category.SUBCLASS
        ),
        Classification("5812", "Publishing of Directories and Mailing Lists", Category.CLASS),
        Classification(
            "58120", "Publishing of directories and mailing lists (including financial databases)", Category.SUBCLASS
        ),
        Classification("5813", "Publishing of News, Journals and Periodicals", Category.CLASS),
        Classification("58131", "Publishing of news", Category.SUBCLASS),
        Classification("58132", "Publishing of journals, periodicals and magazines", Category.SUBCLASS),
        Classification("5819", "Other Publishing Activities", Category.CLASS),
        Classification("58190", "Other publishing activities (excluding online marketplaces)", Category.SUBCLASS),
        Classification("582", "SOFTWARE PUBLISHING", Category.GROUP),
        Classification("5820", "Software Publishing", Category.CLASS),
        Classification("58201", "Publishing of games software/applications", Category.SUBCLASS),
        Classification("58202", "Publishing of software/applications (non-games)", Category.SUBCLASS),
        Classification(
            "59",
            "MOVIE, VIDEO, TELEVISION AND OTHER PROGRAMME PRODUCTION, SOUND RECORDING AND MUSIC PUBLISHING ACTIVITIES",
            Category.DIVISION,
        ),
        Classification("591", "MOVIE, VIDEO, TELEVISION AND OTHER PROGRAMME PRODUCTION ACTIVITIES", Category.GROUP),
        Classification("5911", "Movie, Video, Television and Other Programme Production Activities", Category.CLASS),
        Classification("59111", "Movie production", Category.SUBCLASS),
        Classification("59112", "Production of advertisements, corporate videos and event videos", Category.SUBCLASS),
        Classification(
            "59113",
            "Production of dramas, variety shows and documentaries (including production of television programme)",
            Category.SUBCLASS,
        ),
        Classification("59114", "Animation production", Category.SUBCLASS),
        Classification(
            "59119", "Movie, video, television and other programme production activities n.e.c.", Category.SUBCLASS
        ),
        Classification(
            "5912", "Movie, Video, Television and Other Programme Post-Production Activities", Category.CLASS
        ),
        Classification(
            "59120",
            "Movie, video, television and other programme post-production activities (including remastering)",
            Category.SUBCLASS,
        ),
        Classification("5913", "Movie, Video, Television and Other Programme Distribution Activities", Category.CLASS),
        Classification("59131", "Movie distribution", Category.SUBCLASS),
        Classification(
            "59132",
            "Distribution of television programmes (e.g. dramas, variety shows and documentaries)",
            Category.SUBCLASS,
        ),
        Classification(
            "59139", "Movie, video, television and other programme distribution activities n.e.c.", Category.SUBCLASS
        ),
        Classification("5914", "Movie Projection Activities", Category.CLASS),
        Classification("59140", "Movie projection activities (including cinemas)", Category.SUBCLASS),
        Classification("592", "SOUND RECORDING AND MUSIC PUBLISHING ACTIVITIES", Category.GROUP),
        Classification("5920", "Sound Recording and Music Publishing Activities", Category.CLASS),
        Classification("59201", "Sound recording production", Category.SUBCLASS),
        Classification("59202", "Music publishing and distribution activities", Category.SUBCLASS),
        Classification("60", "RADIO AND TELEVISION BROADCASTING ACTIVITIES", Category.DIVISION),
        Classification("601", "RADIO PROGRAMME PRODUCTION AND BROADCASTING", Category.GROUP),
        Classification("6010", "Radio Programme Production and Broadcasting", Category.CLASS),
        Classification("60100", "Radio programme production and broadcasting", Category.SUBCLASS),
        Classification("602", "TELEVISION PROGRAMMING AND BROADCASTING", Category.GROUP),
        Classification("6020", "Television Programming and Broadcasting", Category.CLASS),
        Classification(
            "60200",
            "Television programming and broadcasting (including cable, satellite, terrestrial television, internet and mobile)",
            Category.SUBCLASS,
        ),
        Classification("61", "TELECOMMUNICATIONS", Category.DIVISION),
        Classification("610", "TELECOMMUNICATIONS", Category.GROUP),
        Classification("6101", "Telecommunications Network Operation", Category.CLASS),
        Classification(
            "61011",
            "Wired telecommunications network operation (including fixed-line, fibre optics, local/international PSTN and leased circuits)",
            Category.SUBCLASS,
        ),
        Classification(
            "61012", "Mobile cellular and other wireless telecommunications network operation", Category.SUBCLASS
        ),
        Classification("61013", "Satellite telecommunications network operation", Category.SUBCLASS),
        Classification("6109", "Other Telecommunications Activities", Category.CLASS),
        Classification(
            "61091",
            "Telecommunications resellers/third party telecommunications providers (including value-added network operators)",
            Category.SUBCLASS,
        ),
        Classification("61092", "Internet access providers, include ISPs", Category.SUBCLASS),
        Classification(
            "61099",
            "Other telecommunications activities n.e.c. (e.g. provision of VoIP (Voice over Internet Protocol services))",
            Category.SUBCLASS,
        ),
        Classification(
            "62", "COMPUTER PROGRAMMING, INFORMATION TECHNOLOGY CONSULTANCY AND RELATED ACTIVITIES", Category.DIVISION
        ),
        Classification(
            "620", "COMPUTER PROGRAMMING, INFORMATION TECHNOLOGY CONSULTANCY AND RELATED ACTIVITIES", Category.GROUP
        ),
        Classification("6201", "Computer Programming Activities", Category.CLASS),
        Classification(
            "62011", "Development of software and applications (except games and cybersecurity)", Category.SUBCLASS
        ),
        Classification("62012", "Development of computer games", Category.SUBCLASS),
        Classification("62013", "Development of software for cybersecurity", Category.SUBCLASS),
        Classification(
            "6202", "Information Technology Consultancy and Computer Facilities Management Activities", Category.CLASS
        ),
        Classification("62021", "Information technology consultancy (except cybersecurity)", Category.SUBCLASS),
        Classification("62022", "Information technology cybersecurity consultancy", Category.SUBCLASS),
        Classification("62023", "Computer facilities management activities", Category.SUBCLASS),
        Classification("6209", "Other Information Technology and Computer Service Activities", Category.CLASS),
        Classification(
            "62090",
            "Other information technology and computer service activities (e.g. disaster recovery services)",
            Category.SUBCLASS,
        ),
        Classification("63", "INFORMATION SERVICE ACTIVITIES AND ONLINE MARKETPLACES", Category.DIVISION),
        Classification(
            "631", "DATA ANALYTICS, PROCESSING, HOSTING AND RELATED ACTIVITIES; INTERNET SEARCH ENGINES", Category.GROUP
        ),
        Classification("6311", "Data Analytics Processing, Hosting and Related Activities", Category.CLASS),
        Classification("63111", "Data centres", Category.SUBCLASS),
        Classification("63112", "Hosting services by non-data centres", Category.SUBCLASS),
        Classification("63119", "Data analytics, processing and related activities n.e.c.", Category.SUBCLASS),
        Classification("6312", "Internet Search Engines", Category.CLASS),
        Classification("63120", "Internet search engines", Category.SUBCLASS),
        Classification("632", "ONLINE MARKETPLACES", Category.GROUP),
        Classification("6320", "Online Marketplaces", Category.CLASS),
        Classification("63201", "Online marketplaces for goods (including food)", Category.SUBCLASS),
        Classification("63202", "Online marketplaces for health services", Category.SUBCLASS),
        Classification("63203", "Online marketplaces for education services", Category.SUBCLASS),
        Classification("63204", "Online marketplaces for travel services", Category.SUBCLASS),
        Classification("63205", "Online marketplaces for real estate services", Category.SUBCLASS),
        Classification("63209", "Online marketplaces for services n.e.c.", Category.SUBCLASS),
        Classification("639", "OTHER INFORMATION SERVICE ACTIVITIES", Category.GROUP),
        Classification("6390", "Other Information Service Activities", Category.CLASS),
        Classification("63901", "News agency activities", Category.SUBCLASS),
        Classification("63909", "Other information service activities n.e.c.", Category.SUBCLASS),
        Classification("K", "FINANCIAL AND INSURANCE ACTIVITIES", Category.SECTION),
        Classification("64", "FINANCIAL SERVICE ACTIVITIES, EXCEPT INSURANCE AND PENSION FUNDING", Category.DIVISION),
        Classification("641", "MONETARY INTERMEDIATION", Category.GROUP),
        Classification("6411", "Central Bank", Category.CLASS),
        Classification("64110", "Central bank", Category.SUBCLASS),
        Classification("6412", "Full Banks", Category.CLASS),
        Classification("64120", "Full banks", Category.SUBCLASS),
        Classification("6413", "Wholesale Banks", Category.CLASS),
        Classification("64130", "Wholesale banks", Category.SUBCLASS),
        Classification("6414", "Merchant Banks", Category.CLASS),
        Classification("64140", "Merchant banks", Category.SUBCLASS),
        Classification("6415", "Finance Companies", Category.CLASS),
        Classification("64150", "Finance companies (with deposit taking functions)", Category.SUBCLASS),
        Classification("6419", "Other Monetary Intermediation", Category.CLASS),
        Classification("64190", "Other monetary intermediation", Category.SUBCLASS),
        Classification("642", "ACTIVITIES OF HOLDING COMPANIES", Category.GROUP),
        Classification("6420", "Activities of Holding Companies", Category.CLASS),
        Classification(
            "64201", "Bank/Financial holding companies (including insurance holding company)", Category.SUBCLASS
        ),
        Classification("64202", "Other holding companies", Category.SUBCLASS),
        Classification("643", "TRUSTS, FUNDS AND SIMILAR FINANCIAL ENTITIES", Category.GROUP),
        Classification("6430", "Trusts, Funds and Similar Financial Entities", Category.CLASS),
        Classification(
            "64300",
            "Trusts, funds and similar financial entities (e.g. collective portfolio investment funds (excluding those with rental income))",
            Category.SUBCLASS,
        ),
        Classification(
            "649",
            "OTHER FINANCIAL SERVICES ACTIVITIES, EXCEPT INSURANCE AND PENSION FUNDING ACTIVITIES",
            Category.GROUP,
        ),
        Classification("6491", "Financial Leasing", Category.CLASS),
        Classification("64910", "Financial leasing companies", Category.SUBCLASS),
        Classification("6492", "Other Credit Granting", Category.CLASS),
        Classification("64921", "Thrift and loan societies and credit associations", Category.SUBCLASS),
        Classification("64922", "Credit card services", Category.SUBCLASS),
        Classification("64923", "Mutual benefits organisations", Category.SUBCLASS),
        Classification("64924", "Money-lending", Category.SUBCLASS),
        Classification("64925", "Pawnbrokerage", Category.SUBCLASS),
        Classification("64929", "Other credit agencies n.e.c. (e.g. motor finance)", Category.SUBCLASS),
        Classification(
            "6499",
            "Financial Service Activities, except Insurance and Pension Funding Activities n.e.c.",
            Category.CLASS,
        ),
        Classification("64991", "Factoring companies", Category.SUBCLASS),
        Classification("64992", "Representative offices of foreign banks", Category.SUBCLASS),
        Classification("64993", "Remittance services", Category.SUBCLASS),
        Classification("64994", "Treasury centres", Category.SUBCLASS),
        Classification(
            "64999",
            "Other financial service activities, except insurance and pension funding activities n.e.c.",
            Category.SUBCLASS,
        ),
        Classification("65", "INSURANCE, REINSURANCE, PROVIDENT FUNDING AND PENSION FUNDING", Category.DIVISION),
        Classification("651", "INSURANCE UNDERWRITING", Category.GROUP),
        Classification("6511", "Life Insurance (Insurance Underwriting)", Category.CLASS),
        Classification("65110", "Life insurance", Category.SUBCLASS),
        Classification("6512", "General Insurance (Insurance Underwriting)", Category.CLASS),
        Classification("65121", "Marine insurance", Category.SUBCLASS),
        Classification("65122", "Captive insurance", Category.SUBCLASS),
        Classification("65123", "Import, export and credit insurance", Category.SUBCLASS),
        Classification(
            "65124", "General insurance (except marine and import, export & credit insurance)", Category.SUBCLASS
        ),
        Classification("652", "REINSURANCE UNDERWRITING", Category.GROUP),
        Classification("6520", "Reinsurance", Category.CLASS),
        Classification("65201", "Life reinsurance", Category.SUBCLASS),
        Classification("65202", "General reinsurance", Category.SUBCLASS),
        Classification("653", "PROVIDENT AND PENSION FUNDING", Category.GROUP),
        Classification("6530", "Provident and Pension Funding", Category.CLASS),
        Classification("65301", "Provident funding", Category.SUBCLASS),
        Classification("65302", "Pension funding", Category.SUBCLASS),
        Classification("66", "ACTIVITIES AUXILIARY TO FINANCIAL SERVICE AND INSURANCE ACTIVITIES", Category.DIVISION),
        Classification(
            "661",
            "ACTIVITIES AUXILIARY TO FINANCIAL SERVICE ACTIVITIES, EXCEPT INSURANCE AND PENSION FUNDING",
            Category.GROUP,
        ),
        Classification("6611", "Securities and commodities exchange", Category.CLASS),
        Classification("66110", "Securities and commodities exchange", Category.SUBCLASS),
        Classification("6612", "Security and Commodity Contracts Brokerage", Category.CLASS),
        Classification("66121", "Stock, share and bond brokers and dealers", Category.SUBCLASS),
        Classification("66122", "Foreign exchange brokers and dealers", Category.SUBCLASS),
        Classification("66123", "Gold bullion brokers and dealers", Category.SUBCLASS),
        Classification("66124", "Commodity (excluding gold) and futures brokers and dealers", Category.SUBCLASS),
        Classification("66125", "Carbon credit brokers/traders", Category.SUBCLASS),
        Classification("66126", "Money-changing services", Category.SUBCLASS),
        Classification(
            "66129", "Security dealings and commodity contracts brokerage activities n.e.c.", Category.SUBCLASS
        ),
        Classification("6619", "Other Activities Auxiliary to Financial Service Activities", Category.CLASS),
        Classification(
            "66191",
            "Trustee, fiduciary and custody services firms (including nominee companies, trustees and REIT trustees)",
            Category.SUBCLASS,
        ),
        Classification("66192", "Corporate finance advisory services", Category.SUBCLASS),
        Classification("66193", "Clearing and settlement of financial instruments", Category.SUBCLASS),
        Classification(
            "66194",
            "Activities auxiliary to fund management activities (e.g. independent fund administration firms)",
            Category.SUBCLASS,
        ),
        Classification("66195", "Transaction/Payment processing services", Category.SUBCLASS),
        Classification(
            "66199",
            "Other activities auxiliary to financial service activities n.e.c. (e.g. mortgage advisory firms)",
            Category.SUBCLASS,
        ),
        Classification("662", "ACTIVITIES AUXILIARY TO INSURANCE AND PENSION FUNDING", Category.GROUP),
        Classification("6621", "Risk and Damage Evaluation", Category.CLASS),
        Classification(
            "66210", "Risk and damage evaluation (e.g. loss adjusting, claims adjusting)", Category.SUBCLASS
        ),
        Classification("6622", "Activities of Insurance Intermediaries", Category.CLASS),
        Classification(
            "66221", "Insurance agencies and agents (including financial planning services)", Category.SUBCLASS
        ),
        Classification("66222", "Insurance brokers", Category.SUBCLASS),
        Classification("6629", "Other Activities Auxiliary to Insurance and Pension Funding", Category.CLASS),
        Classification(
            "66291", "Representative offices of foreign insurers and professional reinsurers", Category.SUBCLASS
        ),
        Classification("66292", "Captive managers", Category.SUBCLASS),
        Classification(
            "66299",
            "Other activities auxiliary to insurance and pension funding n.e.c. (e.g. activities of actuaries)",
            Category.SUBCLASS,
        ),
        Classification("663", "FUND MANAGEMENT ACTIVITIES", Category.GROUP),
        Classification("6630", "Fund Management Activities", Category.CLASS),
        Classification("66301", "Traditional/Long-only asset/Portfolio management", Category.SUBCLASS),
        Classification("66302", "Hedge fund management", Category.SUBCLASS),
        Classification(
            "66303",
            "Property fund management (including REIT management and direct property fund management)",
            Category.SUBCLASS,
        ),
        Classification("66304", "Private equity firms", Category.SUBCLASS),
        Classification("66305", "Venture capital activities", Category.SUBCLASS),
        Classification(
            "66306",
            "Single/Multiple family offices activities (e.g. managing investments and trusts for a single or multiple families)",
            Category.SUBCLASS,
        ),
        Classification("66307", "Private debt funds", Category.SUBCLASS),
        Classification("66309", "Fund management activities n.e.c.", Category.SUBCLASS),
        Classification("L", "REAL ESTATE ACTIVITIES", Category.SECTION),
        Classification("68", "REAL ESTATE ACTIVITIES", Category.DIVISION),
        Classification("681", "REAL ESTATE ACTIVITIES WITH OWN OR LEASED PROPERTY", Category.GROUP),
        Classification("6810", "Real Estate Activities with Own or Leased Property", Category.CLASS),
        Classification("68101", "Real estate developers", Category.SUBCLASS),
        Classification("68102", "Operating of serviced apartments", Category.SUBCLASS),
        Classification(
            "68103",
            "Letting of self-owned or leased real estate property except food courts, coffee shops and canteens (e.g. office/exhibition space, shopping mall, self-storage facilities)",
            Category.SUBCLASS,
        ),
        Classification(
            "68104",
            "Letting and operating of self-owned or leased food courts, coffee shops and canteens (with mainly rental income)",
            Category.SUBCLASS,
        ),
        Classification("68105", "Collective portfolio investment funds with rental income", Category.SUBCLASS),
        Classification(
            "68106",
            "Management of self-owned strata titled property (i.e. Management Corporation Strata Title)",
            Category.SUBCLASS,
        ),
        Classification("682", "REAL ESTATE ACTIVITIES ON A FEE OR COMMISSION BASIS", Category.GROUP),
        Classification("6820", "Real Estate Activities on a Fee or Commission Basis", Category.CLASS),
        Classification("68201", "Real estate agencies and valuation services", Category.SUBCLASS),
        Classification("68202", "Town councils", Category.SUBCLASS),
        Classification(
            "68203",
            "Residential (other than town councils, Category.SUBCLASS), commercial and industrial real estate management",
            Category.SUBCLASS,
        ),
        Classification(
            "68209",
            "Real estate activities on a fee or commission basis n.e.c. (excluding online marketplaces)",
            Category.SUBCLASS,
        ),
        Classification("M", "PROFESSIONAL, SCIENTIFIC AND TECHNICAL ACTIVITIES", Category.SECTION),
        Classification("69", "LEGAL AND ACCOUNTING ACTIVITIES", Category.DIVISION),
        Classification("691", "LEGAL ACTIVITIES", Category.GROUP),
        Classification("6910", "Legal Activities", Category.CLASS),
        Classification("69101", "Legal activities (excluding online marketplaces)", Category.SUBCLASS),
        Classification(
            "69102", "Arbitration and mediation services (excluding online marketplaces)", Category.SUBCLASS
        ),
        Classification("692", "ACCOUNTING, BOOK-KEEPING AND AUDITING ACTIVITIES; TAX CONSULTANCY", Category.GROUP),
        Classification("6920", "Accounting, Book-Keeping and Auditing Activities; Tax Consultancy", Category.CLASS),
        Classification("69201", "Accounting and auditing services (excluding online marketplaces)", Category.SUBCLASS),
        Classification("69202", "Book-keeping services (excluding online marketplaces)", Category.SUBCLASS),
        Classification("70", "ACTIVITIES OF HEAD OFFICES; MANAGEMENT CONSULTANCY ACTIVITIES", Category.DIVISION),
        Classification(
            "701",
            "ACTIVITIES OF HEAD OFFICES; CENTRALISED ADMINISTRATIVE OFFICES AND BUSINESS REPRESENTATIVE OFFICES",
            Category.GROUP,
        ),
        Classification(
            "7010",
            "Activities of Head Offices; Centralised Administrative Offices and Business Representative Offices",
            Category.CLASS,
        ),
        Classification(
            "70101",
            "Activities of head and regional head offices; Centralised administrative offices and subsidiary management offices",
            Category.SUBCLASS,
        ),
        Classification("70102", "Business representative offices", Category.SUBCLASS),
        Classification("702", "MANAGEMENT CONSULTANCY ACTIVITIES", Category.GROUP),
        Classification("7020", "Management Consultancy Activities", Category.CLASS),
        Classification("70201", "Management consultancy services", Category.SUBCLASS),
        Classification("70202", "Management consultancy services for healthcare organisations", Category.SUBCLASS),
        Classification("70203", "Management consultancy services for hotels", Category.SUBCLASS),
        Classification("70204", "Human resource consultancy services", Category.SUBCLASS),
        Classification("70205", "Public relations, marketing and brand consultancy services", Category.SUBCLASS),
        Classification("70206", "Port, shipping and maritime-related consultancy services", Category.SUBCLASS),
        Classification("70209", "Management consultancy services n.e.c.", Category.SUBCLASS),
        Classification(
            "71", "ARCHITECTURAL AND ENGINEERING ACTIVITIES; TECHNICAL TESTING AND ANALYSIS", Category.DIVISION
        ),
        Classification(
            "711", "ARCHITECTURAL AND ENGINEERING ACTIVITIES AND RELATED TECHNICAL CONSULTANCY", Category.GROUP
        ),
        Classification("7111", "Architectural and Surveying Activities", Category.CLASS),
        Classification("71111", "Architectural services", Category.SUBCLASS),
        Classification("71112", "Landscape design and landscape architecture", Category.SUBCLASS),
        Classification("71113", "Quantity surveying services", Category.SUBCLASS),
        Classification("71114", "Land surveying services", Category.SUBCLASS),
        Classification(
            "71119",
            "Other surveying services n.e.c. (e.g. geophysical, geologic, seismic, hydrographic surveying services)",
            Category.SUBCLASS,
        ),
        Classification("7112", "Engineering Design and Consultancy Activities", Category.CLASS),
        Classification("71121", "General building engineering design and consultancy services", Category.SUBCLASS),
        Classification(
            "71122", "Process and industrial plant engineering design and consultancy services", Category.SUBCLASS
        ),
        Classification(
            "71123",
            "Engineering design and consultancy services in energy management and clean energy systems",
            Category.SUBCLASS,
        ),
        Classification(
            "71124",
            "Environmental engineering design and consultancy services (except clean energy)",
            Category.SUBCLASS,
        ),
        Classification("71125", "Infrastructure engineering design and consultancy services", Category.SUBCLASS),
        Classification(
            "71126",
            "Engineering design and consultancy services supporting mining, oil and gas extraction and offshore exploration activities",
            Category.SUBCLASS,
        ),
        Classification("71129", "Engineering design and consultancy activities n.e.c.", Category.SUBCLASS),
        Classification("712", "TECHNICAL TESTING AND ANALYSIS SERVICES", Category.GROUP),
        Classification("7120", "Technical Testing and Analysis Services", Category.CLASS),
        Classification(
            "71200",
            "Technical testing and analysis services (including certification of products and services)",
            Category.SUBCLASS,
        ),
        Classification("72", "SCIENTIFIC RESEARCH AND DEVELOPMENT", Category.DIVISION),
        Classification(
            "721", "RESEARCH AND EXPERIMENTAL DEVELOPMENT ON NATURAL SCIENCES AND ENGINEERING", Category.GROUP
        ),
        Classification(
            "7210", "Research and Experimental Development on Natural Sciences and Engineering", Category.CLASS
        ),
        Classification(
            "72101",
            "Research and experimental development on biotechnology (excluding medical science)",
            Category.SUBCLASS,
        ),
        Classification(
            "72102",
            "Research and experimental development on electronics (excluding medical science)",
            Category.SUBCLASS,
        ),
        Classification(
            "72103", "Research and experimental development on chemicals (excluding medical science)", Category.SUBCLASS
        ),
        Classification("72104", "Research and experimental development on engineering", Category.SUBCLASS),
        Classification(
            "72105",
            "Research and experimental development on environment and clean technologies (excluding biotechnology)",
            Category.SUBCLASS,
        ),
        Classification("72106", "Research and experimental development on medical science", Category.SUBCLASS),
        Classification("72109", "Research and experimental development on natural sciences n.e.c.", Category.SUBCLASS),
        Classification(
            "722", "RESEARCH AND EXPERIMENTAL DEVELOPMENT ON SOCIAL SCIENCES AND HUMANITIES", Category.GROUP
        ),
        Classification(
            "7220", "Research and Experimental Development on Social Sciences and Humanities", Category.CLASS
        ),
        Classification(
            "72200", "Research and experimental development on social sciences and humanities", Category.SUBCLASS
        ),
        Classification("73", "ADVERTISING AND MARKET RESEARCH", Category.DIVISION),
        Classification("731", "ADVERTISING", Category.GROUP),
        Classification("7310", "Advertising", Category.CLASS),
        Classification("73100", "Advertising activities", Category.SUBCLASS),
        Classification("732", "MARKET RESEARCH AND PUBLIC OPINION POLLING", Category.GROUP),
        Classification("7320", "Market Research and Public Opinion Polling", Category.CLASS),
        Classification("73200", "Market research and public opinion polling", Category.SUBCLASS),
        Classification("74", "OTHER PROFESSIONAL, SCIENTIFIC AND TECHNICAL ACTIVITIES", Category.DIVISION),
        Classification("741", "SPECIALISED DESIGN ACTIVITIES", Category.GROUP),
        Classification("7411", "Industrial Design Activities", Category.CLASS),
        Classification("74111", "Electronics-related industrial design services", Category.SUBCLASS),
        Classification("74112", "Transport-related industrial design services", Category.SUBCLASS),
        Classification("74113", "Furniture design services", Category.SUBCLASS),
        Classification("74119", "Industrial design activities n.e.c.", Category.SUBCLASS),
        Classification("7419", "Other Specialised Design Activities", Category.CLASS),
        Classification("74191", "Interior design services", Category.SUBCLASS),
        Classification("74192", "Art and graphic design services", Category.SUBCLASS),
        Classification("74193", "Fashion (including accessories) design services", Category.SUBCLASS),
        Classification("74194", "Exhibition stand design services", Category.SUBCLASS),
        Classification("74199", "Other specialised design activities n.e.c.", Category.SUBCLASS),
        Classification("742", "PHOTOGRAPHIC ACTIVITIES", Category.GROUP),
        Classification("7420", "Photographic Activities", Category.CLASS),
        Classification("74200", "Photographic activities", Category.SUBCLASS),
        Classification("749", "PROFESSIONAL, SCIENTIFIC AND TECHNICAL ACTIVITIES N.E.C.", Category.GROUP),
        Classification("7490", "Professional, Scientific and Technical Activities n.e.c.", Category.CLASS),
        Classification("74901", "Translation services", Category.SUBCLASS),
        Classification(
            "74902", "Brokerage and consultancy services of intellectual property assets", Category.SUBCLASS
        ),
        Classification("74903", "Agrotechnology consultancy services", Category.SUBCLASS),
        Classification("74904", "Carbon consultancy services", Category.SUBCLASS),
        Classification("74905", "Agents for artistes, athletes, models and other performers", Category.SUBCLASS),
        Classification("74909", "Other professional, scientific and technical activities n.e.c.", Category.SUBCLASS),
        Classification("75", "VETERINARY ACTIVITIES", Category.DIVISION),
        Classification("750", "VETERINARY ACTIVITIES", Category.GROUP),
        Classification("7500", "Veterinary Activities", Category.CLASS),
        Classification("75000", "Veterinary activities", Category.SUBCLASS),
        Classification("N", "ADMINISTRATIVE AND SUPPORT SERVICE ACTIVITIES", Category.SECTION),
        Classification("77", "RENTAL AND LEASING ACTIVITIES", Category.DIVISION),
        Classification("771", "RENTING AND LEASING OF LAND TRANSPORT EQUIPMENT", Category.GROUP),
        Classification("7710", "Renting and Leasing of Land Transport Equipment", Category.CLASS),
        Classification(
            "77101",
            "Renting and leasing of private cars without driver (excluding online marketplaces)",
            Category.SUBCLASS,
        ),
        Classification("77102", "Renting and leasing of bicycles and inline/roller skates", Category.SUBCLASS),
        Classification(
            "77109",
            "Renting and leasing of land transport equipment (except cars) without driver n.e.c. (excluding online marketplaces)",
            Category.SUBCLASS,
        ),
        Classification("772", "RENTING AND LEASING OF PERSONAL AND HOUSEHOLD GOODS", Category.GROUP),
        Classification("7721", "Renting and Leasing of Recreational and Sports Goods", Category.CLASS),
        Classification("77210", "Renting and leasing of recreational and sports goods", Category.SUBCLASS),
        Classification("7722", "Renting of VCDs and DVDs", Category.CLASS),
        Classification("77220", "Renting of VCDs and DVDs", Category.SUBCLASS),
        Classification("7729", "Renting and Leasing of Other Personal and Household Goods", Category.CLASS),
        Classification(
            "77291",
            "Renting and leasing of furniture, utensils and electronic equipment for household use",
            Category.SUBCLASS,
        ),
        Classification("77292", "Renting of attire (e.g. costumes)", Category.SUBCLASS),
        Classification(
            "77299",
            "Renting and leasing of other personal and household goods n.e.c. (excluding online marketplaces)",
            Category.SUBCLASS,
        ),
        Classification("773", "RENTING AND LEASING OF OTHER MACHINERY, EQUIPMENT AND TANGIBLE GOODS", Category.GROUP),
        Classification("7731", "Renting of Water Transport Equipment", Category.CLASS),
        Classification(
            "77310",
            "Renting of water transport equipment without operator (e.g. commercial boats and ships without operator)",
            Category.SUBCLASS,
        ),
        Classification("7732", "Renting of Air Transport Equipment", Category.CLASS),
        Classification(
            "77320",
            "Renting of air transport equipment without operator (e.g. airplanes without operator)",
            Category.SUBCLASS,
        ),
        Classification("7733", "Renting of Construction and Civil Engineering Machinery and Equipment", Category.CLASS),
        Classification(
            "77330", "Renting of construction and civil engineering machinery and equipment", Category.SUBCLASS
        ),
        Classification("7734", "Renting of Office Machinery and Equipment (including Computers)", Category.CLASS),
        Classification("77341", "Renting of computers and peripheral equipment", Category.SUBCLASS),
        Classification("77342", "Renting of office machinery and equipment", Category.SUBCLASS),
        Classification("7739", "Renting of Machinery, Equipment and Tangible Goods n.e.c.", Category.CLASS),
        Classification(
            "77391",
            "Renting and leasing of professional radio and television sets and sound reproducing and recording equipment",
            Category.SUBCLASS,
        ),
        Classification("77392", "Renting of industrial machinery and equipment", Category.SUBCLASS),
        Classification(
            "77399",
            "Renting of other machinery, equipment and tangible goods n.e.c. (excluding online marketplaces)",
            Category.SUBCLASS,
        ),
        Classification("774", "LEASING OF NON-FINANCIAL INTANGIBLE ASSETS", Category.GROUP),
        Classification("7740", "Leasing of Non-Financial Intangible Assets", Category.CLASS),
        Classification(
            "77400",
            "Leasing of non-financial intangible assets (e.g. patents, trade marks, brand names etc)",
            Category.SUBCLASS,
        ),
        Classification("78", "EMPLOYMENT ACTIVITIES", Category.DIVISION),
        Classification("781", "EMPLOYMENT AND RECRUITMENT AGENCIES", Category.GROUP),
        Classification("7810", "Employment and Recruitment Agencies", Category.CLASS),
        Classification("78101", "IT manpower contracting services", Category.SUBCLASS),
        Classification("78102", "Manpower contracting services (excluding IT manpower)", Category.SUBCLASS),
        Classification(
            "78103", "Domestic worker employment placement agencies (excluding online marketplaces)", Category.SUBCLASS
        ),
        Classification(
            "78104",
            "Employment agencies (excluding domestic worker employment placement agencies and online marketplaces)",
            Category.SUBCLASS,
        ),
        Classification("783", "MANAGEMENT OF HUMAN RESOURCE FUNCTIONS", Category.GROUP),
        Classification("7830", "Management of Human Resource Functions", Category.CLASS),
        Classification("78300", "Management of human resource functions", Category.SUBCLASS),
        Classification("79", "TRAVEL AGENCIES, TOUR OPERATORS AND TIMESHARING SERVICE ACTIVITIES", Category.DIVISION),
        Classification("791", "TRAVEL AGENCIES AND TOUR OPERATORS ACTIVITIES", Category.GROUP),
        Classification("7910", "Travel Agencies and Tour Operators Activities", Category.CLASS),
        Classification("79101", "Travel agencies and tour operators (mainly inbound)", Category.SUBCLASS),
        Classification("79102", "Travel agencies and tour operators (mainly outbound)", Category.SUBCLASS),
        Classification("792", "TIMESHARING SERVICE ACTIVITIES", Category.GROUP),
        Classification("7920", "Timesharing Service Activities", Category.CLASS),
        Classification("79200", "Timesharing service activities", Category.SUBCLASS),
        Classification("80", "SECURITY AND INVESTIGATION ACTIVITIES", Category.DIVISION),
        Classification("801", "PRIVATE SECURITY ACTIVITIES", Category.GROUP),
        Classification("8010", "Private Security Activities", Category.CLASS),
        Classification("80100", "Private security activities", Category.SUBCLASS),
        Classification("802", "DETECTIVE AND INVESTIGATION ACTIVITIES", Category.GROUP),
        Classification("8020", "Detective and Investigation Activities", Category.CLASS),
        Classification("80200", "Detective and investigation activities", Category.SUBCLASS),
        Classification("81", "CLEANING AND LANDSCAPE MAINTENANCE ACTIVITIES", Category.DIVISION),
        Classification("812", "CLEANING ACTIVITIES", Category.GROUP),
        Classification("8121", "General Cleaning Services", Category.CLASS),
        Classification(
            "81211",
            "General cleaning services (including cleaning of public areas, offices and factories) except household cleaning and online marketplaces",
            Category.SUBCLASS,
        ),
        Classification(
            "81212", "Domestic/Household cleaning services (excluding online marketplaces)", Category.SUBCLASS
        ),
        Classification("8129", "Other Cleaning Services", Category.CLASS),
        Classification("81291", "Pest control services not in connection with agriculture", Category.SUBCLASS),
        Classification("81292", "Cleaning of swimming pools, spas and fountains", Category.SUBCLASS),
        Classification("81299", "Other cleaning services n.e.c. (excluding online marketplaces)", Category.SUBCLASS),
        Classification("813", "LANDSCAPE PLANTING, CARE AND MAINTENANCE SERVICE ACTIVITIES", Category.GROUP),
        Classification("8130", "Landscape Planting, Care and Maintenance Service Activities", Category.CLASS),
        Classification(
            "81300",
            "Landscape planting, care and maintenance service activities (e.g. garden installation and maintenance, grass cutting, tree felling, pruning)",
            Category.SUBCLASS,
        ),
        Classification(
            "82", "OFFICE ADMINISTRATIVE, OFFICE SUPPORT AND OTHER BUSINESS SUPPORT ACTIVITIES", Category.DIVISION
        ),
        Classification("821", "OFFICE ADMINISTRATIVE AND SUPPORT ACTIVITIES", Category.GROUP),
        Classification("8211", "Combined Office Administrative Service Activities", Category.CLASS),
        Classification(
            "82110",
            "Office administrative services on a fee or contract basis (e.g. billing and record keeping)",
            Category.SUBCLASS,
        ),
        Classification(
            "8219", "Photocopying, Document Preparation and Other Specialised Office Support Activities", Category.CLASS
        ),
        Classification("82191", "Stenographic and secretarial services", Category.SUBCLASS),
        Classification("82192", "Duplicating and photo-copying services", Category.SUBCLASS),
        Classification("82199", "Other specialised office support activities n.e.c.", Category.SUBCLASS),
        Classification("822", "ACTIVITIES OF CALL CENTRES", Category.GROUP),
        Classification("8220", "Activities of Call Centres", Category.CLASS),
        Classification("82200", "Call centres", Category.SUBCLASS),
        Classification("823", "CONVENTION, TRADE SHOW, CONCERT AND OTHER EVENT ORGANISERS", Category.GROUP),
        Classification("8230", "Convention, Trade Show, Concert and Other Event Organisers", Category.CLASS),
        Classification("82301", "Exhibition organisers", Category.SUBCLASS),
        Classification("82302", "Convention/Conference organisers", Category.SUBCLASS),
        Classification("82303", "Event/Concert organisers", Category.SUBCLASS),
        Classification("82304", "Exhibition stand contractors", Category.SUBCLASS),
        Classification("829", "BUSINESS SUPPORT SERVICE ACTIVITIES N.E.C.", Category.GROUP),
        Classification("8291", "Activities of Collection Agencies and Credit Bureaus", Category.CLASS),
        Classification("82911", "Debt collection services", Category.SUBCLASS),
        Classification("82912", "Credit rating agencies", Category.SUBCLASS),
        Classification("8292", "Packaging Activities", Category.CLASS),
        Classification("82920", "Packaging activities", Category.SUBCLASS),
        Classification("8299", "Other Business Support Service Activities n.e.c.", Category.CLASS),
        Classification("82991", "Activities of auction houses", Category.SUBCLASS),
        Classification(
            "82999",
            "Other business support service activities (e.g. administration of loyalty programmes)",
            Category.SUBCLASS,
        ),
        Classification("O", "PUBLIC ADMINISTRATION AND DEFENCE", Category.SECTION),
        Classification("84", "PUBLIC ADMINISTRATION AND DEFENCE", Category.DIVISION),
        Classification(
            "841", "ADMINISTRATION OF THE STATE AND THE ECONOMIC AND SOCIAL POLICY OF THE COMMUNITY", Category.GROUP
        ),
        Classification("8411", "General Public Administration", Category.CLASS),
        Classification(
            "84110",
            "Executive, legislative and other general public administration (e.g. Istana, parliament, tax authority)",
            Category.SUBCLASS,
        ),
        Classification("8412", "Public Administration of Economic and Social Programmes", Category.CLASS),
        Classification("84120", "Public administration of economic and social programmes", Category.SUBCLASS),
        Classification("842", "PROVISION OF SERVICES TO THE COMMUNITY AS A WHOLE", Category.GROUP),
        Classification("8421", "Foreign Affairs", Category.CLASS),
        Classification("84210", "Foreign affairs", Category.SUBCLASS),
        Classification("8422", "Defence Activities", Category.CLASS),
        Classification("84221", "Armed forces", Category.SUBCLASS),
        Classification("84229", "Defence activities n.e.c.", Category.SUBCLASS),
        Classification("8423", "Public Order and Safety Activities", Category.CLASS),
        Classification("84231", "Judiciary and related services", Category.SUBCLASS),
        Classification("84232", "Police", Category.SUBCLASS),
        Classification("84233", "Prisons", Category.SUBCLASS),
        Classification("84234", "Other places of detention, correction and rehabilitation", Category.SUBCLASS),
        Classification("84235", "Civil defence", Category.SUBCLASS),
        Classification("84239", "Public order and safety activities n.e.c.", Category.SUBCLASS),
        Classification("P", "EDUCATION", Category.SECTION),
        Classification("85", "EDUCATION", Category.DIVISION),
        Classification("851", "PRE-PRIMARY AND PRIMARY EDUCATION", Category.GROUP),
        Classification("8510", "Pre-Primary and Primary Education", Category.CLASS),
        Classification("85101", "Nurseries and kindergartens", Category.SUBCLASS),
        Classification("85102", "Primary schools", Category.SUBCLASS),
        Classification("852", "SECONDARY AND POST-SECONDARY NON-TERTIARY EDUCATION", Category.GROUP),
        Classification("8521", "General Secondary and Post-Secondary Non-Tertiary Education", Category.CLASS),
        Classification(
            "85211", "Secondary schools including combined primary and secondary schools", Category.SUBCLASS
        ),
        Classification(
            "85212",
            "Junior colleges and centralised pre-university institutes (post-secondary non-tertiary) including combined secondary schools and post-secondary non-tertiary schools",
            Category.SUBCLASS,
        ),
        Classification(
            "85213",
            "Commercial schools offering general secondary and post-secondary non-tertiary education programmes",
            Category.SUBCLASS,
        ),
        Classification(
            "8522", "Technical and Vocational (Secondary and Post-Secondary Non-Tertiary) Education", Category.CLASS
        ),
        Classification(
            "85220", "Technical and vocational secondary and post-secondary non-tertiary education", Category.SUBCLASS
        ),
        Classification("8523", "International and Foreign System Schools", Category.CLASS),
        Classification("85230", "International and foreign system schools", Category.SUBCLASS),
        Classification("8524", "Schools for Special Needs", Category.CLASS),
        Classification("85240", "Schools for special needs", Category.SUBCLASS),
        Classification("8525", "Specialised Education Schools", Category.CLASS),
        Classification("85250", "Specialised education schools", Category.SUBCLASS),
        Classification("853", "HIGHER EDUCATION", Category.GROUP),
        Classification("8530", "Higher Education", Category.CLASS),
        Classification("85301", "Polytechnics", Category.SUBCLASS),
        Classification("85302", "Universities", Category.SUBCLASS),
        Classification("85303", "Teachers' training institute", Category.SUBCLASS),
        Classification("85304", "Commercial schools offering higher education programmes", Category.SUBCLASS),
        Classification("854", "OTHER EDUCATION", Category.GROUP),
        Classification("8540", "Other Education", Category.CLASS),
        Classification(
            "85401",
            "Training courses for construction, real estate, security and investigation services, cleaning, landscaping, waste management and pest management",
            Category.SUBCLASS,
        ),
        Classification("85407", "Training courses for sports and games", Category.SUBCLASS),
        Classification("85408", "Training courses for music, dancing, art, speech and drama", Category.SUBCLASS),
        Classification(
            "85402", "Training courses for healthcare, education, community and social services", Category.SUBCLASS
        ),
        Classification("85409", "Training courses n.e.c.", Category.SUBCLASS),
        Classification("85406", "Training courses for wholesale trade, logistics and transport", Category.SUBCLASS),
        Classification(
            "85403",
            "Training courses for food and beverage, retail and accommodation, tour operators, travel agencies & travel-related reservation services",
            Category.SUBCLASS,
        ),
        Classification("85404", "Training courses for manufacturing", Category.SUBCLASS),
        Classification(
            "85405",
            "Training courses for information and communications, finance and professional services",
            Category.SUBCLASS,
        ),
        Classification("855", "EDUCATIONAL SUPPORT SERVICES", Category.GROUP),
        Classification("8550", "Educational Support Services", Category.CLASS),
        Classification("85501", "Student recruitment agencies", Category.SUBCLASS),
        Classification("85502", "Examination and accreditation agencies for education services", Category.SUBCLASS),
        Classification(
            "85509", "Educational support services n.e.c. (excluding online marketplaces)", Category.SUBCLASS
        ),
        Classification("Q", "HEALTH AND SOCIAL SERVICES", Category.SECTION),
        Classification("86", "HEALTH SERVICES", Category.DIVISION),
        Classification("861", "HOSPITAL ACTIVITIES", Category.GROUP),
        Classification("8610", "Hospital Activities", Category.CLASS),
        Classification("86101", "Acute hospitals", Category.SUBCLASS),
        Classification("86102", "Community hospitals", Category.SUBCLASS),
        Classification("86109", "Other hospitals n.e.c. (e.g. psychiatric hospital)", Category.SUBCLASS),
        Classification("862", "MEDICAL AND DENTAL PRACTICE ACTIVITIES", Category.GROUP),
        Classification("8620", "Medical and Dental Practice Activities", Category.CLASS),
        Classification("86201", "Clinics and other general medical services (Western)", Category.SUBCLASS),
        Classification("86202", "Clinics and other general medical services (Non-Western)", Category.SUBCLASS),
        Classification("86203", "Specialised medical services (including day surgical centres)", Category.SUBCLASS),
        Classification("86204", "Dental services", Category.SUBCLASS),
        Classification("869", "OTHER HEALTH SERVICES", Category.GROUP),
        Classification("8690", "Other Health Services", Category.CLASS),
        Classification("86901", "Medical laboratories (e.g. blood analysis laboratories)", Category.SUBCLASS),
        Classification("86902", "Medical diagnostic imaging centres (e.g. X-ray services)", Category.SUBCLASS),
        Classification("86903", "Ambulance and medical evacuation services", Category.SUBCLASS),
        Classification("86904", "Home healthcare services", Category.SUBCLASS),
        Classification("86905", "Dialysis services", Category.SUBCLASS),
        Classification("86909", "Other health services n.e.c. (excluding online marketplaces)", Category.SUBCLASS),
        Classification("87", "RESIDENTIAL CARE SERVICES", Category.DIVISION),
        Classification("870", "RESIDENTIAL CARE SERVICES", Category.GROUP),
        Classification("8701", "Residential Nursing Care Facilities", Category.CLASS),
        Classification(
            "87010", "Nursing and personal care facilities (including nursing homes and hospices)", Category.SUBCLASS
        ),
        Classification("8702", "Other Residential Care Services", Category.CLASS),
        Classification(
            "87021", "Residential care services for the elderly (e.g. home for the aged)", Category.SUBCLASS
        ),
        Classification(
            "87022", "Residential care services for children (e.g. children’s homes, orphanages)", Category.SUBCLASS
        ),
        Classification("87029", "Other residential care services n.e.c.", Category.SUBCLASS),
        Classification("88", "SOCIAL SERVICES WITHOUT ACCOMMODATION", Category.DIVISION),
        Classification("881", "SOCIAL SERVICES WITHOUT ACCOMMODATION FOR THE ELDERLY AND DISABLED", Category.GROUP),
        Classification("8810", "Social Services Without Accommodation for the Elderly and Disabled", Category.CLASS),
        Classification(
            "88101",
            "Social services for the elderly (e.g. befriender services, meal services, drop-in centres)",
            Category.SUBCLASS,
        ),
        Classification(
            "88102",
            "Social services for persons with disabilities (e.g. day activity centres for people with disabilities)",
            Category.SUBCLASS,
        ),
        Classification("889", "OTHER SOCIAL SERVICES WITHOUT ACCOMMODATION", Category.GROUP),
        Classification(
            "8891", "Social Services Without Accommodation for Children, Youth and Families", Category.CLASS
        ),
        Classification(
            "88911", "Child care services for pre-school children (including infant care services)", Category.SUBCLASS
        ),
        Classification(
            "88912",
            "Child/Student care services for school-going children (e.g. before and after-school care centres, student care centres)",
            Category.SUBCLASS,
        ),
        Classification(
            "88913",
            "Social services for children and youths (e.g. youth outreach services, adoption services)",
            Category.SUBCLASS,
        ),
        Classification(
            "88919", "Social services without accommodation for children, youth and families n.e.c.", Category.SUBCLASS
        ),
        Classification("8892", "Community Activities", Category.CLASS),
        Classification("88920", "Community development councils and grassroots organisations", Category.SUBCLASS),
        Classification("8899", "Social Services Without Accommodation n.e.c.", Category.CLASS),
        Classification("88991", "Job training and vocational rehabilitation services", Category.SUBCLASS),
        Classification(
            "88992", "Charitable and other supporting activities aimed at humanitarian work", Category.SUBCLASS
        ),
        Classification("88999", "Other social services without accommodation n.e.c.", Category.SUBCLASS),
        Classification("R", "ARTS, ENTERTAINMENT AND RECREATION", Category.SECTION),
        Classification("90", "CREATIVE, ARTS AND ENTERTAINMENT ACTIVITIES", Category.DIVISION),
        Classification("900", "CREATIVE, ARTS AND ENTERTAINMENT ACTIVITIES", Category.GROUP),
        Classification("9000", "Creative, Arts and Entertainment Activities", Category.CLASS),
        Classification("90001", "Production of live stage presentations", Category.SUBCLASS),
        Classification("90002", "Performing arts venue operation", Category.SUBCLASS),
        Classification("90003", "Orchestras, musical bands, choirs and dance groups", Category.SUBCLASS),
        Classification(
            "90009",
            "Dramatic arts, music and other arts production-related activities n.e.c. (e.g. stage, lighting and sound services)",
            Category.SUBCLASS,
        ),
        Classification("91", "LIBRARIES, ARCHIVES, MUSEUMS AND OTHER CULTURAL ACTIVITIES", Category.DIVISION),
        Classification("910", "LIBRARIES, ARCHIVES, MUSEUMS AND OTHER CULTURAL ACTIVITIES", Category.GROUP),
        Classification("9101", "Libraries and Archives Activities", Category.CLASS),
        Classification("91010", "Libraries and archives activities", Category.SUBCLASS),
        Classification("9102", "Museums Activities and Operation of Historical Sites and Buildings", Category.CLASS),
        Classification("91021", "Museums", Category.SUBCLASS),
        Classification(
            "91029",
            "Preservation of historical sites, buildings, artefacts and paintings, cultural villages and other related activities n.e.c.",
            Category.SUBCLASS,
        ),
        Classification("9103", "Botanical and Zoological Gardens and Nature Reserves Activities", Category.CLASS),
        Classification("91030", "Botanical and zoological gardens and nature reserves activities", Category.SUBCLASS),
        Classification("92", "GAMBLING AND BETTING ACTIVITIES", Category.DIVISION),
        Classification("920", "GAMBLING AND BETTING ACTIVITIES", Category.GROUP),
        Classification("9200", "Gambling and Betting Activities", Category.CLASS),
        Classification("92001", "Horse-racing and other betting activities", Category.SUBCLASS),
        Classification("92002", "Casinos", Category.SUBCLASS),
        Classification("93", "SPORTS ACTIVITIES AND AMUSEMENT AND RECREATION ACTIVITIES", Category.DIVISION),
        Classification("931", "SPORTS ACTIVITIES", Category.GROUP),
        Classification("9311", "Operation of Sports Facilities", Category.CLASS),
        Classification("93111", "Fitness centres and gymnasiums", Category.SUBCLASS),
        Classification(
            "93119",
            "Operation of sports facilities n.e.c. (e.g. bowling alleys, tennis centres, billiard halls, football stadium)",
            Category.SUBCLASS,
        ),
        Classification("9312", "Activities of Sports Clubs/Associations and Related Activities", Category.CLASS),
        Classification("93120", "Activities of sports clubs/associations and related activities", Category.SUBCLASS),
        Classification("932", "OTHER AMUSEMENT AND RECREATION ACTIVITIES", Category.GROUP),
        Classification("9320", "Other Amusement and Recreation Activities", Category.CLASS),
        Classification("93201", "Amusement theme parks", Category.SUBCLASS),
        Classification(
            "93202", "Game arcade, online game aggregator, LAN game operators and gaming centres", Category.SUBCLASS
        ),
        Classification("93203", "Night clubs, discotheques, dance clubs and karaoke lounges", Category.SUBCLASS),
        Classification("93204", "Recreation clubs (including country clubs)", Category.SUBCLASS),
        Classification(
            "93209",
            "Other amusement and recreation activities n.e.c. (including recreation parks/beaches and recreational fishing)",
            Category.SUBCLASS,
        ),
        Classification("S", "OTHER SERVICE ACTIVITIES", Category.SECTION),
        Classification("94", "ACTIVITIES OF MEMBERSHIP ORGANISATIONS", Category.DIVISION),
        Classification(
            "941", "ACTIVITIES OF BUSINESS, EMPLOYERS AND PROFESSIONAL MEMBERSHIP ORGANISATIONS", Category.GROUP
        ),
        Classification("9411", "Activities of Business and Employers' Membership Organisations", Category.CLASS),
        Classification("94110", "Activities of business and employers' membership organisations", Category.SUBCLASS),
        Classification("9412", "Activities of Professional Membership Organisations", Category.CLASS),
        Classification(
            "94120",
            "Activities of professional membership organisations (e.g. medical associations, law societies, accountancy bodies)",
            Category.SUBCLASS,
        ),
        Classification("942", "ACTIVITIES OF TRADE UNIONS", Category.GROUP),
        Classification("9420", "Activities of Trade Unions", Category.CLASS),
        Classification("94200", "Activities of trade unions", Category.SUBCLASS),
        Classification("949", "ACTIVITIES OF OTHER MEMBERSHIP ORGANISATIONS", Category.GROUP),
        Classification("9491", "Activities of Religious Organisations", Category.CLASS),
        Classification("94911", "Churches", Category.SUBCLASS),
        Classification("94912", "Mosques", Category.SUBCLASS),
        Classification("94913", "Buddhist/Taoist temples", Category.SUBCLASS),
        Classification("94914", "Hindu/Sikh temples", Category.SUBCLASS),
        Classification("94919", "Activities of religious organisations n.e.c.", Category.SUBCLASS),
        Classification("9492", "Activities of Political Organisations", Category.CLASS),
        Classification("94920", "Activities of political organisations", Category.SUBCLASS),
        Classification("9499", "Activities of Other Membership Organisations n.e.c.", Category.CLASS),
        Classification("94991", "Philanthropic trusts, foundations and related activities", Category.SUBCLASS),
        Classification("94992", "Ethnic associations (including clan associations, huay kuans)", Category.SUBCLASS),
        Classification(
            "94993",
            "Associations for hobbies, recreational, cultural and extra-curricular activities (e.g. scouts/girl guides association, book clubs and photo, music, art and craft clubs)",
            Category.SUBCLASS,
        ),
        Classification(
            "94994",
            "Student/Alumni bodies and related associations (e.g. parent-teacher associations, old boys' associations)",
            Category.SUBCLASS,
        ),
        Classification("94995", "Organisations for the protection of the environment and animals", Category.SUBCLASS),
        Classification("94999", "Activities of other membership organisations n.e.c.", Category.SUBCLASS),
        Classification("95", "REPAIR OF COMPUTERS, PERSONAL AND HOUSEHOLD GOODS AND VEHICLES", Category.DIVISION),
        Classification("951", "REPAIR OF COMPUTERS AND COMMUNICATIONS EQUIPMENT", Category.GROUP),
        Classification("9511", "Repair of Computers and Peripheral Equipment", Category.CLASS),
        Classification(
            "95110",
            "Repair and maintenance of computer hardware, data processing equipment and computer peripherals",
            Category.SUBCLASS,
        ),
        Classification("9512", "Repair of Communications Equipment", Category.CLASS),
        Classification(
            "95120", "Repair of communications equipment (e.g. mobile phones and fax machines)", Category.SUBCLASS
        ),
        Classification("952", "REPAIR OF PERSONAL AND HOUSEHOLD GOODS", Category.GROUP),
        Classification("9521", "Repair of Consumer Electronics", Category.CLASS),
        Classification(
            "95210",
            "Repair of audio and video equipment (e.g. television sets, speakers and DVD players)",
            Category.SUBCLASS,
        ),
        Classification("9522", "Repair of Household Appliances and Home and Garden Equipment", Category.CLASS),
        Classification(
            "95220",
            "Repair of domestic electrical/electronic appliances except audio and video equipment (e.g. refrigerators, washing machines and room air-conditioners)",
            Category.SUBCLASS,
        ),
        Classification("9523", "Repair of Footwear and Leather Goods", Category.CLASS),
        Classification("95230", "Repair of footwear and leather goods", Category.SUBCLASS),
        Classification("9524", "Repair of Furniture and Home Furnishings", Category.CLASS),
        Classification(
            "95240",
            "Repair and restoration of cabinets, furniture, upholstery, window shades and other fixtures",
            Category.SUBCLASS,
        ),
        Classification("9529", "Repair of Other Personal and Household Goods", Category.CLASS),
        Classification("95291", "Repair of bicycles and tricycles", Category.SUBCLASS),
        Classification("95292", "Repair of watches and clocks", Category.SUBCLASS),
        Classification("95293", "Repair of jewellery", Category.SUBCLASS),
        Classification(
            "95299",
            "Repair of other personal and household goods n.e.c. (excluding online marketplaces)",
            Category.SUBCLASS,
        ),
        Classification("953", "REPAIR AND MAINTENANCE (INCLUDING INSPECTION) OF VEHICLES", Category.GROUP),
        Classification("9530", "Repair and Maintenance (including Inspection) of Vehicles", Category.CLASS),
        Classification(
            "95301",
            "Repair and maintenance of motor vehicles (including installation of parts & accessories)",
            Category.SUBCLASS,
        ),
        Classification("95302", "Car washing and related services", Category.SUBCLASS),
        Classification("95303", "Vehicle inspection and valuation services", Category.SUBCLASS),
        Classification("96", "OTHER PERSONAL SERVICE ACTIVITIES", Category.DIVISION),
        Classification("960", "OTHER PERSONAL SERVICE ACTIVITIES", Category.GROUP),
        Classification("9601", "Washing and (Dry-) Cleaning of Textile and Fur Products", Category.CLASS),
        Classification("96011", "Laundry and dry cleaning services except self-operated laundries", Category.SUBCLASS),
        Classification("96012", "Self-operated laundries", Category.SUBCLASS),
        Classification("9602", "Hairdressing, Beauty and Other Personal Care Services", Category.CLASS),
        Classification("96021", "Hairdressing salons/shops (including barber shops)", Category.SUBCLASS),
        Classification(
            "96022", "Beauty salons and spas (including slimming, skin care and hair care centres)", Category.SUBCLASS
        ),
        Classification("96023", "Manicure and pedicure services", Category.SUBCLASS),
        Classification("96024", "Massage parlours and foot reflexology", Category.SUBCLASS),
        Classification(
            "96029", "Beauty and other personal care services n.e.c. (excluding online marketplaces)", Category.SUBCLASS
        ),
        Classification("9603", "Funeral and Related Activities", Category.CLASS),
        Classification(
            "96030",
            "Funeral and related activities (including embalming, cremating and cemetery services, upkeep of cemeteries)",
            Category.SUBCLASS,
        ),
        Classification("9604", "Wedding and Related Activities", Category.CLASS),
        Classification(
            "96040", "Wedding and related activities (including bridal studios and wedding planners)", Category.SUBCLASS
        ),
        Classification("9609", "Other Personal Service Activities n.e.c.", Category.CLASS),
        Classification("96091", "Friendship, match-making and dating services", Category.SUBCLASS),
        Classification("96092", "Social escort services", Category.SUBCLASS),
        Classification("96093", "Astrology, palmistry and other fortune telling services", Category.SUBCLASS),
        Classification("96094", "Training of pets and animals", Category.SUBCLASS),
        Classification("96095", "Care services for pets and animals", Category.SUBCLASS),
        Classification(
            "96099", "Other personal service activities n.e.c. (excluding online marketplaces)", Category.SUBCLASS
        ),
        Classification("T", "ACTIVITIES OF HOUSEHOLDS AS EMPLOYERS OF DOMESTIC PERSONNEL", Category.SECTION),
        Classification("97", "ACTIVITIES OF HOUSEHOLDS AS EMPLOYERS OF DOMESTIC PERSONNEL", Category.DIVISION),
        Classification("970", "ACTIVITIES OF HOUSEHOLDS AS EMPLOYERS OF DOMESTIC PERSONNEL", Category.GROUP),
        Classification("9700", "Activities of Households as Employers of Domestic Personnel", Category.CLASS),
        Classification("97001", "Activities of households as employers of domestic workers", Category.SUBCLASS),
        Classification(
            "97002",
            "Activities of households as employers of other domestic personnel (e.g. housekeepers)",
            Category.SUBCLASS,
        ),
        Classification("U", "ACTIVITIES OF EXTRA-TERRITORIAL ORGANISATIONS AND BODIES", Category.SECTION),
        Classification("99", "ACTIVITIES OF EXTRA-TERRITORIAL ORGANISATIONS AND BODIES", Category.DIVISION),
        Classification("990", "ACTIVITIES OF EXTRA-TERRITORIAL ORGANISATIONS AND BODIES", Category.GROUP),
        Classification("9901", "Foreign Embassies and Trade Representative Offices", Category.CLASS),
        Classification("99010", "Foreign embassies and trade representative offices", Category.SUBCLASS),
        Classification("9902", "Foreign Armed Forces", Category.CLASS),
        Classification("99020", "Foreign armed forces", Category.SUBCLASS),
        Classification("9909", "Other Extra-territorial Organisations and Bodies", Category.CLASS),
        Classification("99090", "Other extra-territorial organisations and bodies", Category.SUBCLASS),
    ],
)
