"""`SIC Standard <https://www.ehso.com/siccodes.php>`_.
"""
from ...types import Category, Classification, Standard, Standards

SIC = Standard(
    standard=Standards.SIC,
    classes=[
        Classification("A", "AGRICULTURE, FORESTRY, AND FISHING", Category.SECTION),
        Classification("01", "AGRICULTURAL PRODUCTION-CROPS", Category.DIVISION),
        Classification("011", "CASH GRAINS", Category.GROUP),
        Classification("0111", "WHEAT", Category.CLASS),
        Classification("0112", "RICE", Category.CLASS),
        Classification("0115", "CORN", Category.CLASS),
        Classification("0116", "SOYBEANS", Category.CLASS),
        Classification("0119", "CASH GRAINS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("013", "FIELD CROPS, EXCEPT CASH GRAINS", Category.GROUP),
        Classification("0131", "COTTON", Category.CLASS),
        Classification("0132", "TOBACCO", Category.CLASS),
        Classification("0133", "SUGARCANE AND SUGAR BEETS", Category.CLASS),
        Classification("0134", "IRISH POTATOES", Category.CLASS),
        Classification("0139", "FIELD CROPS, EXCEPT CASH GRAINS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("016", "VEGETABLES AND MELONS", Category.GROUP),
        Classification("0161", "VEGETABLES AND MELONS", Category.CLASS),
        Classification("017", "FRUITS AND TREE NUTS", Category.GROUP),
        Classification("0171", "BERRY CROPS", Category.CLASS),
        Classification("0172", "GRAPES", Category.CLASS),
        Classification("0173", "TREE NUTS", Category.CLASS),
        Classification("0174", "CITRUS FRUITS", Category.CLASS),
        Classification("0175", "DECIDUOUS TREE FRUITS", Category.CLASS),
        Classification("0179", "FRUITS AND TREE NUTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("018", "HORTICULTURAL SPECIALTIES", Category.GROUP),
        Classification("0181", "ORNAMENTAL FLORICULTURE AND NURSERY PRODUCTS", Category.CLASS),
        Classification("0182", "FOOD CROPS GROWN UNDER COVER", Category.CLASS),
        Classification("019", "GENERAL FARMS, PRIMARILY CROP", Category.GROUP),
        Classification("0191", "GENERAL FARMS, PRIMARILY CROP", Category.CLASS),
        Classification("02", "AGRICULTURAL PRODUCTION-LIVESTOCK AND ANIMAL SPECIALTIES", Category.DIVISION),
        Classification("021", "LIVESTOCK, EXCEPT DAIRY AND POULTRY", Category.GROUP),
        Classification("0211", "BEEF CATTLE FEEDLOTS", Category.CLASS),
        Classification("0212", "BEEF CATTLE, EXCEPT FEEDLOTS", Category.CLASS),
        Classification("0213", "HOGS", Category.CLASS),
        Classification("0214", "SHEEP AND GOATS", Category.CLASS),
        Classification("0219", "GENERAL LIVESTOCK, EXCEPT DAIRY AND POULTRY", Category.CLASS),
        Classification("024", "DAIRY FARMS", Category.GROUP),
        Classification("0241", "DAIRY FARMS", Category.CLASS),
        Classification("025", "POULTRY AND EGGS", Category.GROUP),
        Classification("0251", "BROILER, FRYER, AND ROASTER CHICKENS", Category.CLASS),
        Classification("0252", "CHICKEN EGGS", Category.CLASS),
        Classification("0253", "TURKEYS AND TURKEY EGGS", Category.CLASS),
        Classification("0254", "POULTRY HATCHERIES", Category.CLASS),
        Classification("0259", "POULTRY AND EGGS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("027", "ANIMAL SPECIALTIES", Category.GROUP),
        Classification("0271", "FUR-BEARING ANIMALS AND RABBITS", Category.CLASS),
        Classification("0272", "HORSES AND OTHER EQUINES", Category.CLASS),
        Classification("0273", "ANIMAL AQUACULTURE", Category.CLASS),
        Classification("0279", "ANIMAL SPECIALTIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("029", "GENERAL FARMS, PRIMARILY LIVESTOCK AND ANIMAL SPECIALTIES", Category.GROUP),
        Classification("0291", "GENERAL FARMS, PRIMARILY LIVESTOCK AND ANIMAL SPECIALTIES", Category.CLASS),
        Classification("07", "AGRICULTURAL SERVICES", Category.DIVISION),
        Classification("071", "SOIL PREPARATION SERVICES", Category.GROUP),
        Classification("0711", "SOIL PREPARATION SERVICES", Category.CLASS),
        Classification("072", "CROP SERVICES", Category.GROUP),
        Classification("0721", "CROP PLANTING, CULTIVATING, AND PROTECTING", Category.CLASS),
        Classification("0722", "CROP HARVESTING, PRIMARILY BY MACHINE", Category.CLASS),
        Classification("0723", "CROP PREPARATION SERVICES FOR MARKET, EXCEPT COTTON GINNING", Category.CLASS),
        Classification("0724", "COTTON GINNING", Category.CLASS),
        Classification("074", "VETERINARY SERVICES", Category.GROUP),
        Classification("0741", "VETERINARY SERVICES FOR LIVESTOCK", Category.CLASS),
        Classification("0742", "VETERINARY SERVICES FOR ANIMAL SPECIALTIES", Category.CLASS),
        Classification("075", "ANIMAL SERVICES, EXCEPT VETERINARY", Category.GROUP),
        Classification("0751", "LIVESTOCK SERVICES, EXCEPT VETERINARY", Category.CLASS),
        Classification("0752", "ANIMAL SPECIALTY SERVICES, EXCEPT VETERINARY", Category.CLASS),
        Classification("076", "FARM LABOR AND MANAGEMENT SERVICES", Category.GROUP),
        Classification("0761", "FARM LABOR CONTRACTORS AND CREW LEADERS", Category.CLASS),
        Classification("0762", "FARM MANAGEMENT SERVICES", Category.CLASS),
        Classification("078", "LANDSCAPE AND HORTICULTURAL SERVICES", Category.GROUP),
        Classification("0781", "LANDSCAPE COUNSELING AND PLANNING", Category.CLASS),
        Classification("0782", "LAWN AND GARDEN SERVICES", Category.CLASS),
        Classification("0783", "ORNAMENTAL SHRUB AND TREE SERVICES", Category.CLASS),
        Classification("08", "FORESTRY", Category.DIVISION),
        Classification("081", "TIMBER TRACTS", Category.GROUP),
        Classification("0811", "TIMBER TRACTS", Category.CLASS),
        Classification("083", "FOREST NURSERIES AND GATHERING OF FOREST PRODUCTS", Category.GROUP),
        Classification("0831", "FOREST NURSERIES AND GATHERING OF FOREST PRODUCTS", Category.CLASS),
        Classification("085", "FORESTRY SERVICES", Category.GROUP),
        Classification("0851", "FORESTRY SERVICES", Category.CLASS),
        Classification("09", "FISHING, HUNTING, AND TRAPPING", Category.DIVISION),
        Classification("091", "COMMERCIAL FISHING", Category.GROUP),
        Classification("0912", "FINFISH", Category.CLASS),
        Classification("0913", "SHELLFISH", Category.CLASS),
        Classification("0919", "MISCELLANEOUS MARINE PRODUCTS", Category.CLASS),
        Classification("092", "FISH HATCHERIES AND PRESERVES", Category.GROUP),
        Classification("0921", "FISH HATCHERIES AND PRESERVES", Category.CLASS),
        Classification("097", "HUNTING AND TRAPPING, AND GAME PROPAGATION", Category.GROUP),
        Classification("0971", "HUNTING AND TRAPPING, AND GAME PROPAGATION", Category.CLASS),
        Classification("B", "MINING", Category.SECTION),
        Classification("10", "METAL MINING", Category.DIVISION),
        Classification("101", "IRON ORES", Category.GROUP),
        Classification("1011", "IRON ORES", Category.CLASS),
        Classification("102", "COPPER ORES", Category.GROUP),
        Classification("1021", "COPPER ORES", Category.CLASS),
        Classification("103", "LEAD AND ZINC ORES", Category.GROUP),
        Classification("1031", "LEAD AND ZINC ORES", Category.CLASS),
        Classification("104", "GOLD AND SILVER ORES", Category.GROUP),
        Classification("1041", "GOLD ORES", Category.CLASS),
        Classification("1044", "SILVER ORES", Category.CLASS),
        Classification("106", "FERROALLOY ORES, EXCEPT VANADIUM", Category.GROUP),
        Classification("1061", "FERROALLOY ORES, EXCEPT VANADIUM", Category.CLASS),
        Classification("108", "METAL MINING SERVICES", Category.GROUP),
        Classification("1081", "METAL MINING SERVICES", Category.CLASS),
        Classification("109", "MISCELLANEOUS METAL ORES", Category.GROUP),
        Classification("1094", "URANIUM-RADIUM-VANADIUM ORES", Category.CLASS),
        Classification("1099", "MISCELLANEOUS METAL ORES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("12", "COAL MINING", Category.DIVISION),
        Classification("122", "BITUMINOUS COAL AND LIGNITE MINING", Category.GROUP),
        Classification("1221", "BITUMINOUS COAL AND LIGNITE SURFACE MINING", Category.CLASS),
        Classification("1222", "BITUMINOUS COAL UNDERGROUND MINING", Category.CLASS),
        Classification("123", "ANTHRACITE MINING", Category.GROUP),
        Classification("1231", "ANTHRACITE MINING", Category.CLASS),
        Classification("124", "COAL MINING SERVICES", Category.GROUP),
        Classification("1241", "COAL MINING SERVICES", Category.CLASS),
        Classification("13", "OIL AND GAS EXTRACTION", Category.DIVISION),
        Classification("131", "CRUDE PETROLEUM AND NATURAL GAS", Category.GROUP),
        Classification("1311", "CRUDE PETROLEUM AND NATURAL GAS", Category.CLASS),
        Classification("132", "NATURAL GAS LIQUIDS", Category.GROUP),
        Classification("1321", "NATURAL GAS LIQUIDS", Category.CLASS),
        Classification("138", "OIL AND GAS FIELD SERVICES", Category.GROUP),
        Classification("1381", "DRILLING OIL AND GAS WELLS", Category.CLASS),
        Classification("1382", "OIL AND GAS FIELD EXPLORATION SERVICES", Category.CLASS),
        Classification("1389", "OIL AND GAS FIELD SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("14", "MINING AND QUARRYING OF NONMETALLIC MINERALS, EXCEPT FUELS", Category.DIVISION),
        Classification("141", "DIMENSION STONE", Category.GROUP),
        Classification("1411", "DIMENSION STONE", Category.CLASS),
        Classification("142", "CRUSHED AND BROKEN STONE, INCLUDING RIPRAP", Category.GROUP),
        Classification("1422", "CRUSHED AND BROKEN LIMESTONE", Category.CLASS),
        Classification("1423", "CRUSHED AND BROKEN GRANITE", Category.CLASS),
        Classification("1429", "CRUSHED AND BROKEN STONE, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("144", "SAND AND GRAVEL", Category.GROUP),
        Classification("1442", "CONSTRUCTION SAND AND GRAVEL", Category.CLASS),
        Classification("1446", "INDUSTRIAL SAND", Category.CLASS),
        Classification("145", "CLAY, CERAMIC, AND REFRACTORY MINERALS", Category.GROUP),
        Classification("1455", "KAOLIN AND BALL CLAY", Category.CLASS),
        Classification("1459", "CLAY, CERAMIC, AND REFRACTORY MINERALS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("147", "CHEMICAL AND FERTILIZER MINERAL MINING", Category.GROUP),
        Classification("1474", "POTASH, SODA, AND BORATE MINERALS", Category.CLASS),
        Classification("1475", "PHOSPHATE ROCK", Category.CLASS),
        Classification("1479", "CHEMICAL AND FERTILIZER MINERAL MINING, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("148", "NONMETALLIC MINERALS SERVICES, EXCEPT FUELS", Category.GROUP),
        Classification("1481", "NONMETALLIC MINERALS SERVICES, EXCEPT FUELS", Category.CLASS),
        Classification("149", "MISCELLANEOUS NONMETALLIC MINERALS, EXCEPT FUELS", Category.GROUP),
        Classification("1499", "MISCELLANEOUS NONMETALLIC MINERALS, EXCEPT FUELS", Category.CLASS),
        Classification("C", "CONSTRUCTION", Category.SECTION),
        Classification("15", "BUILDING CONSTRUCTION-GENERAL CONTRACTORS AND OPERATIVE BUILDERS", Category.DIVISION),
        Classification("152", "GENERAL BUILDING CONTRACTORS-RESIDENTIAL BUILDINGS", Category.GROUP),
        Classification("1521", "GENERAL CONTRACTORS-SINGLE-FAMILY HOUSES", Category.CLASS),
        Classification("1522", "GENERAL CONTRACTORS-RESIDENTIAL BUILDINGS, OTHER THAN SINGLE-FAMI", Category.CLASS),
        Classification("153", "OPERATIVE BUILDERS", Category.GROUP),
        Classification("1531", "OPERATIVE BUILDERS", Category.CLASS),
        Classification("154", "GENERAL BUILDING CONTRACTORS-NONRESIDENTIAL BUILDINGS", Category.GROUP),
        Classification("1541", "GENERAL CONTRACTORS-INDUSTRIAL BUILDINGS AND WAREHOUSES", Category.CLASS),
        Classification("1542", "GENERAL CONTRACTORS-NONRESIDENTIAL BUILDINGS, OTHER THAN INDUSTRI", Category.CLASS),
        Classification("16", "HEAVY CONSTRUCTION OTHER THAN BUILDING CONSTRUCTION-CONTRACTORS", Category.DIVISION),
        Classification("161", "HIGHWAY AND STREET CONSTRUCTION, EXCEPT ELEVATED HIGHWAYS", Category.GROUP),
        Classification("1611", "HIGHWAY AND STREET CONSTRUCTION, EXCEPT ELEVATED HIGHWAYS", Category.CLASS),
        Classification("162", "HEAVY CONSTRUCTION, EXCEPT HIGHWAY AND STREET CONSTRUCTION", Category.GROUP),
        Classification("1622", "BRIDGE, TUNNEL, AND ELEVATED HIGHWAY CONSTRUCTION", Category.CLASS),
        Classification("1623", "WATER, SEWER, PIPELINE, AND COMMUNICATIONS AND POWER LINE CONSTRU", Category.CLASS),
        Classification("1629", "HEAVY CONSTRUCTION, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("17", "CONSTRUCTION-SPECIAL TRADE CONTRACTORS", Category.DIVISION),
        Classification("171", "PLUMBING, HEATING AND AIR-CONDITIONING", Category.GROUP),
        Classification("1711", "PLUMBING, HEATING AND AIR-CONDITIONING", Category.CLASS),
        Classification("172", "PAINTING AND PAPER HANGING", Category.GROUP),
        Classification("1721", "PAINTING AND PAPER HANGING", Category.CLASS),
        Classification("173", "ELECTRICAL WORK", Category.GROUP),
        Classification("1731", "ELECTRICAL WORK", Category.CLASS),
        Classification("174", "MASONRY, STONEWORK, TILE SETTING, AND PLASTERING", Category.GROUP),
        Classification("1741", "MASONRY, STONE SETTING, AND OTHER STONE WORK", Category.CLASS),
        Classification("1742", "PLASTERING, DRYWALL, ACOUSTICAL, AND INSULATION WORK", Category.CLASS),
        Classification("1743", "TERRAZZO, TILE, MARBLE, AND MOSAIC WORK", Category.CLASS),
        Classification("175", "CARPENTRY AND FLOOR WORK", Category.GROUP),
        Classification("1751", "CARPENTRY WORK", Category.CLASS),
        Classification("1752", "FLOOR LAYING AND OTHER FLOOR WORK, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("176", "ROOFING, SIDING, AND SHEET METAL WORK", Category.GROUP),
        Classification("1761", "ROOFING, SIDING, AND SHEET METAL WORK", Category.CLASS),
        Classification("177", "CONCRETE WORK", Category.GROUP),
        Classification("1771", "CONCRETE WORK", Category.CLASS),
        Classification("178", "WATER WELL DRILLING", Category.GROUP),
        Classification("1781", "WATER WELL DRILLING", Category.CLASS),
        Classification("179", "MISCELLANEOUS SPECIAL TRADE CONTRACTORS", Category.GROUP),
        Classification("1791", "STRUCTURAL STEEL ERECTION", Category.CLASS),
        Classification("1793", "GLASS AND GLAZING WORK", Category.CLASS),
        Classification("1793", "GLASS INSTALLATION, EXCEPT AUTOMOTIVE-CONTRACTORS", Category.CLASS),
        Classification("1794", "EXCAVATION WORK", Category.CLASS),
        Classification("1795", "WRECKING AND DEMOLITION WORK", Category.CLASS),
        Classification("1796", "INSTALLATION OR ERECTION OF BUILDING EQUIPMENT, NOT ELSEWHERE CLA", Category.CLASS),
        Classification("1799", "SPECIAL TRADE CONTRACTORS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("D", "MANUFACTURING", Category.SECTION),
        Classification("20", "FOOD AND KINDRED PRODUCTS", Category.DIVISION),
        Classification("201", "MEAT PRODUCTS", Category.GROUP),
        Classification("2011", "MEAT PACKING PLANTS", Category.CLASS),
        Classification("2013", "SAUSAGES AND OTHER PREPARED MEAT PRODUCTS", Category.CLASS),
        Classification("2015", "POULTRY SLAUGHTERING AND PROCESSING", Category.CLASS),
        Classification("202", "DAIRY PRODUCTS", Category.GROUP),
        Classification("2021", "CREAMERY BUTTER", Category.CLASS),
        Classification("2022", "NATURAL, PROCESSED, AND IMITATION CHEESE", Category.CLASS),
        Classification("2023", "DRY, CONDENSED, AND EVAPORATED DAIRY PRODUCTS", Category.CLASS),
        Classification("2024", "ICE CREAM AND FROZEN DESSERTS", Category.CLASS),
        Classification("2026", "FLUID MILK", Category.CLASS),
        Classification("203", "CANNED, FROZEN, AND PRESERVED FRUITS, VEGETABLES, AND FOOD SPECIAL", Category.GROUP),
        Classification("2032", "CANNED SPECIALTIES", Category.CLASS),
        Classification("2033", "CANNED FRUITS, VEGETABLES, PRESERVES, JAMS, AND JELLIES", Category.CLASS),
        Classification("2034", "DRIED AND DEHYDRATED FRUITS, VEGETABLES, AND SOUP MIXES", Category.CLASS),
        Classification("2035", "PICKLED FRUITS AND VEGETABLES, VEGETABLE SAUCES AND SEASONINGS, A", Category.CLASS),
        Classification("2037", "FROZEN FRUITS, FRUIT JUICES, AND VEGETABLES", Category.CLASS),
        Classification("2038", "FROZEN SPECIALTIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("204", "GRAIN MILL PRODUCTS", Category.GROUP),
        Classification("2041", "FLOUR AND OTHER GRAIN MILL PRODUCTS", Category.CLASS),
        Classification("2043", "CEREAL BREAKFAST FOODS", Category.CLASS),
        Classification("2044", "RICE MILLING", Category.CLASS),
        Classification("2045", "PREPARED FLOUR MIXES AND DOUGHS", Category.CLASS),
        Classification("2046", "WET CORN MILLING", Category.CLASS),
        Classification("2047", "DOG AND CAT FOOD", Category.CLASS),
        Classification("2048", "PREPARED FEEDS AND FEED INGREDIENTS FOR ANIMALS AND FOWLS, EXCEPT", Category.CLASS),
        Classification("205", "BAKERY PRODUCTS", Category.GROUP),
        Classification("2051", "BREAD AND OTHER BAKERY PRODUCTS, EXCEPT COOKIES AND CRACKERS", Category.CLASS),
        Classification("2052", "COOKIES AND CRACKERS", Category.CLASS),
        Classification("2053", "FROZEN BAKERY PRODUCTS, EXCEPT BREAD", Category.CLASS),
        Classification("206", "SUGAR AND CONFECTIONERY PRODUCTS", Category.GROUP),
        Classification("2061", "CANE SUGAR, EXCEPT REFINING", Category.CLASS),
        Classification("2062", "CANE SUGAR REFINING", Category.CLASS),
        Classification("2063", "BEET SUGAR", Category.CLASS),
        Classification("2064", "CANDY AND OTHER CONFECTIONERY PRODUCTS", Category.CLASS),
        Classification("2066", "CHOCOLATE AND COCOA PRODUCTS", Category.CLASS),
        Classification("2067", "CHEWING GUM", Category.CLASS),
        Classification("2068", "SALTED AND ROASTED NUTS AND SEEDS", Category.CLASS),
        Classification("207", "FATS AND OILS", Category.GROUP),
        Classification("2074", "COTTONSEED OIL MILLS", Category.CLASS),
        Classification("2075", "SOYBEAN OIL MILLS", Category.CLASS),
        Classification("2076", "VEGETABLE OIL MILLS, EXCEPT CORN, COTTONSEED, AND SOYBEAN", Category.CLASS),
        Classification("2077", "ANIMAL AND MARINE FATS AND OILS", Category.CLASS),
        Classification("2079", "SHORTENING, TABLE OILS, MARGARINE, AND OTHER EDIBLE FATS AND OILS", Category.CLASS),
        Classification("208", "BEVERAGES", Category.GROUP),
        Classification("2082", "MALT BEVERAGES", Category.CLASS),
        Classification("2083", "MALT", Category.CLASS),
        Classification("2084", "WINES, BRANDY, AND BRANDY SPIRITS", Category.CLASS),
        Classification("2085", "DISTILLED AND BLENDED LIQUORS", Category.CLASS),
        Classification("2086", "BOTTLED AND CANNED SOFT DRINKS AND CARBONATED WATERS", Category.CLASS),
        Classification("2087", "FLAVORING EXTRACTS AND FLAVORING SYRUPS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("209", "MISCELLANEOUS FOOD PREPARATIONS AND KINDRED PRODUCTS", Category.GROUP),
        Classification("2091", "CANNED AND CURED FISH AND SEAFOODS", Category.CLASS),
        Classification("2092", "PREPARED FRESH OR FROZEN FISH AND SEAFOODS", Category.CLASS),
        Classification("2095", "ROASTED COFFEE", Category.CLASS),
        Classification("2096", "POTATO CHIPS, CORN CHIPS, AND SIMILAR SNACKS", Category.CLASS),
        Classification("2097", "MANUFACTURED ICE", Category.CLASS),
        Classification("2098", "MACARONI, SPAGHETTI, VERMICELLI, AND NOODLES", Category.CLASS),
        Classification("2099", "FOOD PREPARATIONS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("21", "TOBACCO PRODUCTS", Category.DIVISION),
        Classification("211", "CIGARETTES", Category.GROUP),
        Classification("2111", "CIGARETTES", Category.CLASS),
        Classification("212", "CIGARS", Category.GROUP),
        Classification("2121", "CIGARS", Category.CLASS),
        Classification("213", "CHEWING AND SMOKING TOBACCO AND SNUFF", Category.GROUP),
        Classification("2131", "CHEWING AND SMOKING TOBACCO AND SNUFF", Category.CLASS),
        Classification("214", "TOBACCO STEMMING AND REDRYING", Category.GROUP),
        Classification("2141", "TOBACCO STEMMING AND REDRYING", Category.CLASS),
        Classification("22", "TEXTILE MILL PRODUCTS", Category.DIVISION),
        Classification("221", "BROADWOVEN FABRIC MILLS, COTTON", Category.GROUP),
        Classification("2211", "BROADWOVEN FABRIC MILLS, COTTON", Category.CLASS),
        Classification("222", "BROADWOVEN FABRIC MILLS, MANMADE FIBER AND SILK", Category.GROUP),
        Classification("2221", "BROADWOVEN FABRIC MILLS, MANMADE FIBER AND SILK", Category.CLASS),
        Classification("223", "BROADWOVEN FABRIC MILLS, WOOL (INCLUDING DYEING AND FINISHING)", Category.GROUP),
        Classification("2231", "BROADWOVEN FABRIC MILLS, WOOL (INCLUDING DYEING AND FINISHING)", Category.CLASS),
        Classification("224", "NARROW FABRIC AND OTHER SMALLWARES MILLS: COTTON, WOOL, SILK, AND", Category.GROUP),
        Classification("2241", "NARROW FABRIC AND OTHER SMALLWARES MILLS: COTTON, WOOL, SILK, AND", Category.CLASS),
        Classification("225", "KNITTING MILLS", Category.GROUP),
        Classification("2251", "WOMEN'S FULL-LENGTH AND KNEE-LENGTH HOSIERY, EXCEPT SOCKS", Category.CLASS),
        Classification("2252", "HOSIERY, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("2253", "KNIT OUTERWEAR MILLS", Category.CLASS),
        Classification("2254", "KNIT UNDERWEAR AND NIGHTWEAR MILLS", Category.CLASS),
        Classification("2257", "WEFT KNIT FABRIC MILLS", Category.CLASS),
        Classification("2258", "LACE AND WARP KNIT FABRIC MILLS", Category.CLASS),
        Classification("2259", "KNITTING MILLS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("226", "DYEING AND FINISHING TEXTILES, EXCEPT WOOL FABRICS AND KNIT GOODS", Category.GROUP),
        Classification("2261", "FINISHERS OF BROADWOVEN FABRICS OF COTTON", Category.CLASS),
        Classification("2262", "FINISHERS OF BROADWOVEN FABRICS OF MANMADE FIBER AND SILK", Category.CLASS),
        Classification("2269", "FINISHERS OF TEXTILES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("227", "CARPETS AND RUGS", Category.GROUP),
        Classification("2273", "CARPETS AND RUGS", Category.CLASS),
        Classification("228", "YARN AND THREAD MILLS", Category.GROUP),
        Classification("2281", "YARN SPINNING MILLS", Category.CLASS),
        Classification("2282", "YARN TEXTURIZING, THROWING, TWISTING, AND WINDING MILLS", Category.CLASS),
        Classification("2282", "ACETATE FILAMENT YARN: THROWING, TWISTING, WINDING, OR SPOOLING", Category.CLASS),
        Classification("2284", "THREAD MILLS", Category.CLASS),
        Classification("229", "MISCELLANEOUS TEXTILE GOODS", Category.GROUP),
        Classification("2295", "COATED FABRICS, NOT RUBBERIZED", Category.CLASS),
        Classification("2296", "TIRE CORD AND FABRICS", Category.CLASS),
        Classification("2297", "NONWOVEN FABRICS", Category.CLASS),
        Classification("2298", "CORDAGE AND TWINE", Category.CLASS),
        Classification("2299", "TEXTILE GOODS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification(
            "23", "APPAREL AND OTHER FINISHED PRODUCTS MADE FROM FABRICS AND SIMILAR MATERIAL", Category.DIVISION
        ),
        Classification("231", "MEN'S AND BOYS' SUITS, COATS, AND OVERCOATS", Category.GROUP),
        Classification("2311", "MEN'S AND BOYS' SUITS, COATS, AND OVERCOATS", Category.CLASS),
        Classification("232", "MEN'S AND BOYS' FURNISHINGS, WORK CLOTHING, AND ALLIED GARMENTS", Category.GROUP),
        Classification("2321", "MEN'S AND BOYS' SHIRTS, EXCEPT WORK SHIRTS", Category.CLASS),
        Classification("2322", "MEN'S AND BOYS' UNDERWEAR AND NIGHTWEAR", Category.CLASS),
        Classification("2323", "MEN'S AND BOYS' NECKWEAR", Category.CLASS),
        Classification("2325", "MEN'S AND BOYS' SEPARATE TROUSERS AND SLACKS", Category.CLASS),
        Classification("2326", "MEN'S AND BOYS' WORK CLOTHING", Category.CLASS),
        Classification("2329", "MEN'S AND BOYS' CLOTHING, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("233", "WOMEN'S, MISSES', AND JUNIORS' OUTERWEAR", Category.GROUP),
        Classification("2331", "WOMEN'S, MISSES', AND JUNIORS' BLOUSES AND SHIRTS", Category.CLASS),
        Classification("2335", "WOMEN'S, MISSES', AND JUNIORS' DRESSES", Category.CLASS),
        Classification("2337", "WOMEN'S, MISSES', AND JUNIORS' SUITS, SKIRTS, AND COATS", Category.CLASS),
        Classification("2339", "WOMEN'S, MISSES', AND JUNIORS' OUTERWEAR, NOT ELSEWHERE CLASSIFIE", Category.CLASS),
        Classification("234", "WOMEN'S, MISSES', CHILDREN'S, AND INFANTS' UNDERGARMENTS", Category.GROUP),
        Classification("2341", "WOMEN'S, MISSES', CHILDREN'S, AND INFANTS' UNDERWEAR AND NIGHTWEA", Category.CLASS),
        Classification("2342", "BRASSIERES, GIRDLES, AND ALLIED GARMENTS", Category.CLASS),
        Classification("235", "HATS, CAPS, AND MILLINERY", Category.GROUP),
        Classification("2353", "HATS, CAPS, AND MILLINERY", Category.CLASS),
        Classification("236", "GIRLS', CHILDREN'S, AND INFANTS' OUTERWEAR", Category.GROUP),
        Classification("2361", "GIRLS', CHILDREN'S, AND INFANTS' DRESSES, BLOUSES, AND SHIRTS", Category.CLASS),
        Classification("2369", "GIRLS', CHILDREN'S, AND INFANTS' OUTERWEAR, NOT ELSEWHERE CLASSIF", Category.CLASS),
        Classification("237", "FUR GOODS", Category.GROUP),
        Classification("2371", "FUR GOODS", Category.CLASS),
        Classification("238", "MISCELLANEOUS APPAREL AND ACCESSORIES", Category.GROUP),
        Classification("2381", "DRESS AND WORK GLOVES, EXCEPT KNIT AND ALL-LEATHER", Category.CLASS),
        Classification("2384", "ROBES AND DRESSING GOWNS", Category.CLASS),
        Classification("2385", "WATERPROOF OUTERWEAR", Category.CLASS),
        Classification("2386", "LEATHER AND SHEEP-LINED CLOTHING", Category.CLASS),
        Classification("2387", "APPAREL BELTS", Category.CLASS),
        Classification("2389", "APPAREL AND ACCESSORIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("239", "MISCELLANEOUS FABRICATED TEXTILE PRODUCTS", Category.GROUP),
        Classification("2391", "CURTAINS AND DRAPERIES", Category.CLASS),
        Classification("2392", "HOUSEFURNISHINGS, EXCEPT CURTAINS AND DRAPERIES", Category.CLASS),
        Classification("2393", "TEXTILE BAGS", Category.CLASS),
        Classification("2394", "CANVAS AND RELATED PRODUCTS", Category.CLASS),
        Classification("2395", "PLEATING, DECORATIVE AND NOVELTY STITCHING, AND TUCKING FOR THE T", Category.CLASS),
        Classification("2396", "AUTOMOTIVE TRIMMINGS, APPAREL FINDINGS, AND RELATED PRODUCTS", Category.CLASS),
        Classification("2397", "SCHIFFLI MACHINE EMBROIDERIES", Category.CLASS),
        Classification("2399", "FABRICATED TEXTILE PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("24", "LUMBER AND WOOD PRODUCTS, EXCEPT FURNITURE", Category.DIVISION),
        Classification("241", "LOGGING", Category.GROUP),
        Classification("2411", "LOGGING", Category.CLASS),
        Classification("242", "SAWMILLS AND PLANING MILLS", Category.GROUP),
        Classification("2421", "SAWMILLS AND PLANING MILLS, GENERAL", Category.CLASS),
        Classification("2426", "HARDWOOD DIMENSION AND FLOORING MILLS", Category.CLASS),
        Classification("2429", "SPECIAL PRODUCT SAWMILLS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("243", "MILLWORK, VENEER, PLYWOOD, AND STRUCTURAL WOOD MEMBERS", Category.GROUP),
        Classification("2431", "MILLWORK", Category.CLASS),
        Classification("2434", "WOOD KITCHEN CABINETS", Category.CLASS),
        Classification("2435", "HARDWOOD VENEER AND PLYWOOD", Category.CLASS),
        Classification("2436", "SOFTWOOD VENEER AND PLYWOOD", Category.CLASS),
        Classification("2439", "STRUCTURAL WOOD MEMBERS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("244", "WOOD CONTAINERS", Category.GROUP),
        Classification("2441", "NAILED AND LOCK CORNER WOOD BOXES AND SHOOK", Category.CLASS),
        Classification("2448", "WOOD PALLETS AND SKIDS", Category.CLASS),
        Classification("2449", "WOOD CONTAINERS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("245", "WOOD BUILDINGS AND MOBILE HOMES", Category.GROUP),
        Classification("2451", "MOBILE HOMES", Category.CLASS),
        Classification("2452", "PREFABRICATED WOOD BUILDINGS AND COMPONENTS", Category.CLASS),
        Classification("249", "MISCELLANEOUS WOOD PRODUCTS", Category.GROUP),
        Classification("2491", "WOOD PRESERVING", Category.CLASS),
        Classification("2493", "RECONSTITUTED WOOD PRODUCTS", Category.CLASS),
        Classification("2499", "WOOD PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("25", "FURNITURE AND FIXTURES", Category.DIVISION),
        Classification("251", "HOUSEHOLD FURNITURE", Category.GROUP),
        Classification("2511", "WOOD HOUSEHOLD FURNITURE, EXCEPT UPHOLSTERED", Category.CLASS),
        Classification("2512", "WOOD HOUSEHOLD FURNITURE, UPHOLSTERED", Category.CLASS),
        Classification("2514", "METAL HOUSEHOLD FURNITURE", Category.CLASS),
        Classification("2515", "MATTRESSES, FOUNDATIONS, AND CONVERTIBLE BEDS", Category.CLASS),
        Classification("2517", "WOOD TELEVISION, RADIO, PHONOGRAPH, AND SEWING MACHINE CABINETS", Category.CLASS),
        Classification("2519", "HOUSEHOLD FURNITURE, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("252", "OFFICE FURNITURE", Category.GROUP),
        Classification("2521", "WOOD OFFICE FURNITURE", Category.CLASS),
        Classification("2522", "OFFICE FURNITURE, EXCEPT WOOD", Category.CLASS),
        Classification("253", "PUBLIC BUILDING AND RELATED FURNITURE", Category.GROUP),
        Classification("2531", "PUBLIC BUILDING AND RELATED FURNITURE", Category.CLASS),
        Classification("254", "PARTITIONS, SHELVING, LOCKERS, AND OFFICE AND STORE FIXTURES", Category.GROUP),
        Classification("2541", "WOOD OFFICE AND STORE FIXTURES, PARTITIONS, SHELVING, AND LOCKERS", Category.CLASS),
        Classification("2542", "OFFICE AND STORE FIXTURES, PARTITIONS, SHELVING, AND LOCKERS, EXC", Category.CLASS),
        Classification("259", "MISCELLANEOUS FURNITURE AND FIXTURES", Category.GROUP),
        Classification("2591", "DRAPERY HARDWARE AND WINDOW BLINDS AND SHADES", Category.CLASS),
        Classification("2599", "FURNITURE AND FIXTURES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("26", "PAPER AND ALLIED PRODUCTS", Category.DIVISION),
        Classification("261", "PULP MILLS", Category.GROUP),
        Classification("2611", "PULP MILLS", Category.CLASS),
        Classification("262", "PAPER MILLS", Category.GROUP),
        Classification("2621", "PAPER MILLS", Category.CLASS),
        Classification("263", "PAPERBOARD MILLS", Category.GROUP),
        Classification("2631", "PAPERBOARD MILLS", Category.CLASS),
        Classification("265", "PAPERBOARD CONTAINERS AND BOXES", Category.GROUP),
        Classification("2652", "SETUP PAPERBOARD BOXES", Category.CLASS),
        Classification("2653", "CORRUGATED AND SOLID FIBER BOXES", Category.CLASS),
        Classification("2655", "FIBER CANS, TUBES, DRUMS, AND SIMILAR PRODUCTS", Category.CLASS),
        Classification("2656", "SANITARY FOOD CONTAINERS, EXCEPT FOLDING", Category.CLASS),
        Classification("2657", "FOLDING PAPERBOARD BOXES, INCLUDING SANITARY", Category.CLASS),
        Classification("267", "CONVERTED PAPER AND PAPERBOARD PRODUCTS, EXCEPT CONTAINERS AND BOX", Category.GROUP),
        Classification("2671", "PACKAGING PAPER AND PLASTICS FILM, COATED AND LAMINATED", Category.CLASS),
        Classification("2672", "COATED AND LAMINATED PAPER, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("2673", "PLASTICS, FOIL, AND COATED PAPER BAGS", Category.CLASS),
        Classification("2674", "UNCOATED PAPER AND MULTIWALL BAGS", Category.CLASS),
        Classification("2675", "DIE-CUT PAPER AND PAPERBOARD AND CARDBOARD", Category.CLASS),
        Classification("2676", "SANITARY PAPER PRODUCTS", Category.CLASS),
        Classification("2677", "ENVELOPES", Category.CLASS),
        Classification("2678", "STATIONERY, TABLETS, AND RELATED PRODUCTS", Category.CLASS),
        Classification("2679", "CONVERTED PAPER AND PAPERBOARD PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("27", "PRINTING, PUBLISHING, AND ALLIED INDUSTRIES", Category.DIVISION),
        Classification("271", "NEWSPAPERS: PUBLISHING, OR PUBLISHING AND PRINTING", Category.GROUP),
        Classification("2711", "NEWSPAPERS: PUBLISHING, OR PUBLISHING AND PRINTING", Category.CLASS),
        Classification("272", "PERIODICALS: PUBLISHING, OR PUBLISHING AND PRINTING", Category.GROUP),
        Classification("2721", "PERIODICALS: PUBLISHING, OR PUBLISHING AND PRINTING", Category.CLASS),
        Classification("273", "BOOKS", Category.GROUP),
        Classification("2731", "BOOKS: PUBLISHING, OR PUBLISHING AND PRINTING", Category.CLASS),
        Classification("2732", "BOOK PRINTING", Category.CLASS),
        Classification("274", "MISCELLANEOUS PUBLISHING", Category.GROUP),
        Classification("2741", "MISCELLANEOUS PUBLISHING", Category.CLASS),
        Classification("275", "COMMERCIAL PRINTING", Category.GROUP),
        Classification("2752", "COMMERCIAL PRINTING, LITHOGRAPHIC", Category.CLASS),
        Classification("2754", "COMMERCIAL PRINTING, GRAVURE", Category.CLASS),
        Classification("2759", "COMMERCIAL PRINTING, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("276", "MANIFOLD BUSINESS FORMS", Category.GROUP),
        Classification("2761", "MANIFOLD BUSINESS FORMS", Category.CLASS),
        Classification("277", "GREETING CARDS", Category.GROUP),
        Classification("2771", "GREETING CARDS", Category.CLASS),
        Classification("278", "BLANKBOOKS, LOOSELEAF BINDERS, AND BOOKBINDING AND RELATED WORK", Category.GROUP),
        Classification("2782", "BLANKBOOKS, LOOSELEAF BINDERS AND DEVICES", Category.CLASS),
        Classification("2789", "BOOKBINDING AND RELATED WORK", Category.CLASS),
        Classification("279", "SERVICE INDUSTRIES FOR THE PRINTING TRADE", Category.GROUP),
        Classification("2791", "TYPESETTING", Category.CLASS),
        Classification("2796", "PLATEMAKING AND RELATED SERVICES", Category.CLASS),
        Classification("28", "CHEMICALS AND ALLIED PRODUCTS", Category.DIVISION),
        Classification("281", "INDUSTRIAL INORGANIC CHEMICALS", Category.GROUP),
        Classification("2812", "ALKALIES AND CHLORINE", Category.CLASS),
        Classification("2813", "INDUSTRIAL GASES", Category.CLASS),
        Classification("2816", "INORGANIC PIGMENTS", Category.CLASS),
        Classification("2819", "INDUSTRIAL INORGANIC CHEMICALS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("282", "PLASTICS MATERIALS AND SYNTHETIC RESINS, SYNTHETIC RUBBER, CELLULO", Category.GROUP),
        Classification("2821", "PLASTICS MATERIALS, SYNTHETIC RESINS, AND NONVULCANIZABLE ELASTOM", Category.CLASS),
        Classification("2822", "SYNTHETIC RUBBER (VULCANIZABLE ELASTOMERS)", Category.CLASS),
        Classification("2823", "CELLULOSIC MANMADE FIBERS", Category.CLASS),
        Classification("2824", "MANMADE ORGANIC FIBERS, EXCEPT CELLULOSIC", Category.CLASS),
        Classification("283", "DRUGS", Category.GROUP),
        Classification("2833", "MEDICINAL CHEMICALS AND BOTANICAL PRODUCTS", Category.CLASS),
        Classification("2834", "PHARMACEUTICAL PREPARATIONS", Category.CLASS),
        Classification("2835", "IN VITRO AND IN VIVO DIAGNOSTIC SUBSTANCES", Category.CLASS),
        Classification("2836", "BIOLOGICAL PRODUCTS, EXCEPT DIAGNOSTIC SUBSTANCES", Category.CLASS),
        Classification("284", "SOAP, DETERGENTS, AND CLEANING PREPARATIONS; PERFUMES, COSMETICS", Category.GROUP),
        Classification("2841", "SOAP AND OTHER DETERGENTS, EXCEPT SPECIALTY CLEANERS", Category.CLASS),
        Classification("2842", "SPECIALTY CLEANING, POLISHING, AND SANITATION PREPARATIONS", Category.CLASS),
        Classification("2843", "SURFACE ACTIVE AGENTS, FINISHING AGENTS, SULFONATED OILS, AND ASS", Category.CLASS),
        Classification("2844", "PERFUMES, COSMETICS, AND OTHER TOILET PREPARATIONS", Category.CLASS),
        Classification("285", "PAINTS, VARNISHES, LACQUERS, ENAMELS, AND ALLIED PRODUCTS", Category.GROUP),
        Classification("2851", "PAINTS, VARNISHES, LACQUERS, ENAMELS, AND ALLIED PRODUCTS", Category.CLASS),
        Classification("286", "INDUSTRIAL ORGANIC CHEMICALS", Category.GROUP),
        Classification("2861", "GUM AND WOOD CHEMICALS", Category.CLASS),
        Classification("2865", "CYCLIC ORGANIC CRUDES AND INTERMEDIATES, AND ORGANIC DYES AND PIG", Category.CLASS),
        Classification("2869", "INDUSTRIAL ORGANIC CHEMICALS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("287", "AGRICULTURAL CHEMICALS", Category.GROUP),
        Classification("2873", "NITROGENOUS FERTILIZERS", Category.CLASS),
        Classification("2874", "PHOSPHATIC FERTILIZERS", Category.CLASS),
        Classification("2875", "FERTILIZERS, MIXING ONLY", Category.CLASS),
        Classification("2879", "PESTICIDES AND AGRICULTURAL CHEMICALS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("289", "MISCELLANEOUS CHEMICAL PRODUCTS", Category.GROUP),
        Classification("2891", "ADHESIVES AND SEALANTS", Category.CLASS),
        Classification("2892", "EXPLOSIVES", Category.CLASS),
        Classification("2893", "PRINTING INK", Category.CLASS),
        Classification("2895", "CARBON BLACK", Category.CLASS),
        Classification("2899", "CHEMICALS AND CHEMICAL PREPARATIONS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("29", "PETROLEUM REFINING AND RELATED INDUSTRIES", Category.DIVISION),
        Classification("291", "PETROLEUM REFINING", Category.GROUP),
        Classification("2911", "PETROLEUM REFINING", Category.CLASS),
        Classification("295", "ASPHALT PAVING AND ROOFING MATERIALS", Category.GROUP),
        Classification("2951", "ASPHALT PAVING MIXTURES AND BLOCKS", Category.CLASS),
        Classification("2952", "ASPHALT FELTS AND COATINGS", Category.CLASS),
        Classification("299", "MISCELLANEOUS PRODUCTS OF PETROLEUM AND COAL", Category.GROUP),
        Classification("2992", "LUBRICATING OILS AND GREASES", Category.CLASS),
        Classification("2999", "PRODUCTS OF PETROLEUM AND COAL, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("30", "RUBBER AND MISCELLANEOUS PLASTICS PRODUCTS", Category.DIVISION),
        Classification("301", "TIRES AND INNER TUBES", Category.GROUP),
        Classification("3011", "TIRES AND INNER TUBES", Category.CLASS),
        Classification("302", "RUBBER AND PLASTICS FOOTWEAR", Category.GROUP),
        Classification("3021", "RUBBER AND PLASTICS FOOTWEAR", Category.CLASS),
        Classification("305", "GASKETS, PACKING, AND SEALING DEVICES AND RUBBER AND PLASTICS HOSE", Category.GROUP),
        Classification("3052", "RUBBER AND PLASTICS HOSE AND BELTING", Category.CLASS),
        Classification("3053", "GASKETS, PACKING, AND SEALING DEVICES", Category.CLASS),
        Classification("306", "FABRICATED RUBBER PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("3061", "MOLDED, EXTRUDED, AND LATHE-CUT MECHANICAL RUBBER GOODS", Category.CLASS),
        Classification("3069", "FABRICATED RUBBER PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("308", "MISCELLANEOUS PLASTICS PRODUCTS", Category.GROUP),
        Classification("3081", "UNSUPPORTED PLASTICS FILM AND SHEET", Category.CLASS),
        Classification("3082", "UNSUPPORTED PLASTICS PROFILE SHAPES", Category.CLASS),
        Classification("3083", "LAMINATED PLASTICS PLATE, SHEET, AND PROFILE SHAPES", Category.CLASS),
        Classification("3084", "PLASTICS PIPE", Category.CLASS),
        Classification("3085", "PLASTICS BOTTLES", Category.CLASS),
        Classification("3086", "PLASTICS FOAM PRODUCTS", Category.CLASS),
        Classification("3087", "CUSTOM COMPOUNDING OF PURCHASED PLASTICS RESINS", Category.CLASS),
        Classification("3088", "PLASTICS PLUMBING FIXTURES", Category.CLASS),
        Classification("3089", "PLASTICS PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("31", "LEATHER AND LEATHER PRODUCTS", Category.DIVISION),
        Classification("311", "LEATHER TANNING AND FINISHING", Category.GROUP),
        Classification("3111", "LEATHER TANNING AND FINISHING", Category.CLASS),
        Classification("313", "BOOT AND SHOE CUT STOCK AND FINDINGS", Category.GROUP),
        Classification("3131", "BOOT AND SHOE CUT STOCK AND FINDINGS", Category.CLASS),
        Classification("314", "FOOTWEAR, EXCEPT RUBBER", Category.GROUP),
        Classification("3142", "HOUSE SLIPPERS", Category.CLASS),
        Classification("3143", "MEN'S FOOTWEAR, EXCEPT ATHLETIC", Category.CLASS),
        Classification("3144", "WOMEN'S FOOTWEAR, EXCEPT ATHLETIC", Category.CLASS),
        Classification("3149", "FOOTWEAR, EXCEPT RUBBER, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("315", "LEATHER GLOVES AND MITTENS", Category.GROUP),
        Classification("3151", "LEATHER GLOVES AND MITTENS", Category.CLASS),
        Classification("316", "LUGGAGE", Category.GROUP),
        Classification("3161", "LUGGAGE", Category.CLASS),
        Classification("317", "HANDBAGS AND OTHER PERSONAL LEATHER GOODS", Category.GROUP),
        Classification("3171", "WOMEN'S HANDBAGS AND PURSES", Category.CLASS),
        Classification("3172", "PERSONAL LEATHER GOODS, EXCEPT WOMEN'S HANDBAGS AND PURSES", Category.CLASS),
        Classification("319", "LEATHER GOODS, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("3199", "LEATHER GOODS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("32", "STONE, CLAY, GLASS, AND CONCRETE PRODUCTS", Category.DIVISION),
        Classification("321", "FLAT GLASS", Category.GROUP),
        Classification("3211", "FLAT GLASS", Category.CLASS),
        Classification("322", "GLASS AND GLASSWARE, PRESSED OR BLOWN", Category.GROUP),
        Classification("3221", "GLASS CONTAINERS", Category.CLASS),
        Classification("3229", "PRESSED AND BLOWN GLASS AND GLASSWARE, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("323", "GLASS PRODUCTS, MADE OF PURCHASED GLASS", Category.GROUP),
        Classification("3231", "GLASS PRODUCTS, MADE OF PURCHASED GLASS", Category.CLASS),
        Classification("324", "CEMENT, HYDRAULIC", Category.GROUP),
        Classification("3241", "CEMENT, HYDRAULIC", Category.CLASS),
        Classification("325", "STRUCTURAL CLAY PRODUCTS", Category.GROUP),
        Classification("3251", "BRICK AND STRUCTURAL CLAY TILE", Category.CLASS),
        Classification("3253", "CERAMIC WALL AND FLOOR TILE", Category.CLASS),
        Classification("3255", "CLAY REFRACTORIES", Category.CLASS),
        Classification("3259", "STRUCTURAL CLAY PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("326", "POTTERY AND RELATED PRODUCTS", Category.GROUP),
        Classification("3261", "VITREOUS CHINA PLUMBING FIXTURES AND CHINA AND EARTHENWARE FITTIN", Category.CLASS),
        Classification("3262", "VITREOUS CHINA TABLE AND KITCHEN ARTICLES", Category.CLASS),
        Classification("3263", "FINE EARTHENWARE (WHITEWARE) TABLE AND KITCHEN ARTICLES", Category.CLASS),
        Classification("3264", "PORCELAIN ELECTRICAL SUPPLIES", Category.CLASS),
        Classification("3269", "POTTERY PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("327", "CONCRETE, GYPSUM, AND PLASTER PRODUCTS", Category.GROUP),
        Classification("3271", "CONCRETE BLOCK AND BRICK", Category.CLASS),
        Classification("3272", "CONCRETE PRODUCTS, EXCEPT BLOCK AND BRICK", Category.CLASS),
        Classification("3273", "READY-MIXED CONCRETE", Category.CLASS),
        Classification("3274", "LIME", Category.CLASS),
        Classification("3275", "GYPSUM PRODUCTS", Category.CLASS),
        Classification("328", "CUT STONE AND STONE PRODUCTS", Category.GROUP),
        Classification("3281", "CUT STONE AND STONE PRODUCTS", Category.CLASS),
        Classification("329", "ABRASIVE, ASBESTOS, AND MISCELLANEOUS NONMETALLIC MINERAL PRODUCTS", Category.GROUP),
        Classification("3291", "ABRASIVE PRODUCTS", Category.CLASS),
        Classification("3292", "ASBESTOS PRODUCTS", Category.CLASS),
        Classification("3295", "MINERALS AND EARTHS, GROUND OR OTHERWISE TREATED", Category.CLASS),
        Classification("3296", "MINERAL WOOL", Category.CLASS),
        Classification("3297", "NONCLAY REFRACTORIES", Category.CLASS),
        Classification("3299", "NONMETALLIC MINERAL PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("33", "PRIMARY METAL INDUSTRIES", Category.DIVISION),
        Classification("331", "STEEL WORKS, BLAST FURNACES, AND ROLLING AND FINISHING MILLS", Category.GROUP),
        Classification("3312", "STEEL WORKS, BLAST FURNACES (INCLUDING COKE OVENS), AND ROLLING M", Category.CLASS),
        Classification("3313", "ELECTROMETALLURGICAL PRODUCTS, EXCEPT STEEL", Category.CLASS),
        Classification("3315", "STEEL WIREDRAWING AND STEEL NAILS AND SPIKES", Category.CLASS),
        Classification("3316", "COLD-ROLLED STEEL SHEET, STRIP, AND BARS", Category.CLASS),
        Classification("3317", "STEEL PIPE AND TUBES", Category.CLASS),
        Classification("332", "IRON AND STEEL FOUNDRIES", Category.GROUP),
        Classification("3321", "GRAY AND DUCTILE IRON FOUNDRIES", Category.CLASS),
        Classification("3322", "MALLEABLE IRON FOUNDRIES", Category.CLASS),
        Classification("3324", "STEEL INVESTMENT FOUNDRIES", Category.CLASS),
        Classification("3325", "STEEL FOUNDRIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("333", "PRIMARY SMELTING AND REFINING OF NONFERROUS METALS", Category.GROUP),
        Classification("3331", "PRIMARY SMELTING AND REFINING OF COPPER", Category.CLASS),
        Classification("3334", "PRIMARY PRODUCTION OF ALUMINUM", Category.CLASS),
        Classification("3339", "PRIMARY SMELTING AND REFINING OF NONFERROUS METALS, EXCEPT COPPER", Category.CLASS),
        Classification("334", "SECONDARY SMELTING AND REFINING OF NONFERROUS METALS", Category.GROUP),
        Classification("3341", "SECONDARY SMELTING AND REFINING OF NONFERROUS METALS", Category.CLASS),
        Classification("335", "ROLLING, DRAWING, AND EXTRUDING OF NONFERROUS METALS", Category.GROUP),
        Classification("3351", "ROLLING, DRAWING, AND EXTRUDING OF COPPER", Category.CLASS),
        Classification("3353", "ALUMINUM SHEET, PLATE, AND FOIL", Category.CLASS),
        Classification("3354", "ALUMINUM EXTRUDED PRODUCTS", Category.CLASS),
        Classification("3355", "ALUMINUM ROLLING AND DRAWING, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("3356", "ROLLING, DRAWING, AND EXTRUDING OF NONFERROUS METALS, EXCEPT COPP", Category.CLASS),
        Classification("3357", "DRAWING AND INSULATING OF NONFERROUS WIRE", Category.CLASS),
        Classification("336", "NONFERROUS FOUNDRIES (CASTINGS)", Category.GROUP),
        Classification("3363", "ALUMINUM DIE-CASTINGS", Category.CLASS),
        Classification("3364", "NONFERROUS DIE-CASTINGS, EXCEPT ALUMINUM", Category.CLASS),
        Classification("3365", "ALUMINUM FOUNDRIES", Category.CLASS),
        Classification("3366", "COPPER FOUNDRIES", Category.CLASS),
        Classification("3369", "NONFERROUS FOUNDRIES, EXCEPT ALUMINUM AND COPPER", Category.CLASS),
        Classification("339", "MISCELLANEOUS PRIMARY METAL PRODUCTS", Category.GROUP),
        Classification("3398", "METAL HEAT TREATING", Category.CLASS),
        Classification("3399", "PRIMARY METAL PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification(
            "34", "FABRICATED METAL PRODUCTS, EXCEPT MACHINERY AND TRANSPORTATION EQUIPMENT", Category.DIVISION
        ),
        Classification("341", "METAL CANS AND SHIPPING CONTAINERS", Category.GROUP),
        Classification("3411", "METAL CANS", Category.CLASS),
        Classification("3412", "METAL SHIPPING BARRELS, DRUMS, KEGS, AND PAILS", Category.CLASS),
        Classification("342", "CUTLERY, HANDTOOLS, AND GENERAL HARDWARE", Category.GROUP),
        Classification("3421", "CUTLERY", Category.CLASS),
        Classification("3423", "HAND AND EDGE TOOLS, EXCEPT MACHINE TOOLS AND HANDSAWS", Category.CLASS),
        Classification("3425", "SAW BLADES AND HANDSAWS", Category.CLASS),
        Classification("3429", "HARDWARE, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("343", "HEATING EQUIPMENT, EXCEPT ELECTRIC AND WARM AIR; AND PLUMBING FIXT", Category.GROUP),
        Classification("3431", "ENAMELED IRON AND METAL SANITARY WARE", Category.CLASS),
        Classification("3432", "PLUMBING FIXTURE FITTINGS AND TRIM", Category.CLASS),
        Classification("3433", "HEATING EQUIPMENT, EXCEPT ELECTRIC AND WARM AIR FURNACES", Category.CLASS),
        Classification("344", "FABRICATED STRUCTURAL METAL PRODUCTS", Category.GROUP),
        Classification("3441", "FABRICATED STRUCTURAL METAL", Category.CLASS),
        Classification("3442", "METAL DOORS, SASH, FRAMES, MOLDING, AND TRIM", Category.CLASS),
        Classification("3443", "FABRICATED PLATE WORK (BOILER SHOPS)", Category.CLASS),
        Classification("3444", "SHEET METALWORK", Category.CLASS),
        Classification("3446", "ARCHITECTURAL AND ORNAMENTAL METALWORK", Category.CLASS),
        Classification("3448", "PREFABRICATED METAL BUILDINGS AND COMPONENTS", Category.CLASS),
        Classification("3449", "MISCELLANEOUS STRUCTURAL METALWORK", Category.CLASS),
        Classification("345", "SCREW MACHINE PRODUCTS, AND BOLTS, NUTS, SCREWS, RIVETS, AND WASHE", Category.GROUP),
        Classification("3451", "SCREW MACHINE PRODUCTS", Category.CLASS),
        Classification("3452", "BOLTS, NUTS, SCREWS, RIVETS, AND WASHERS", Category.CLASS),
        Classification("346", "METAL FORGINGS AND STAMPINGS", Category.GROUP),
        Classification("3462", "IRON AND STEEL FORGINGS", Category.CLASS),
        Classification("3463", "NONFERROUS FORGINGS", Category.CLASS),
        Classification("3465", "AUTOMOTIVE STAMPINGS", Category.CLASS),
        Classification("3466", "CROWNS AND CLOSURES", Category.CLASS),
        Classification("3469", "METAL STAMPINGS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("347", "COATING, ENGRAVING, AND ALLIED SERVICES", Category.GROUP),
        Classification("3471", "ELECTROPLATING, PLATING, POLISHING, ANODIZING, AND COLORING", Category.CLASS),
        Classification("3479", "COATING, ENGRAVING, AND ALLIED SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("348", "ORDNANCE AND ACCESSORIES, EXCEPT VEHICLES AND GUIDED MISSILES", Category.GROUP),
        Classification("3482", "SMALL ARMS AMMUNITION", Category.CLASS),
        Classification("3483", "AMMUNITION, EXCEPT FOR SMALL ARMS", Category.CLASS),
        Classification("3484", "SMALL ARMS", Category.CLASS),
        Classification("3489", "ORDNANCE AND ACCESSORIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("349", "MISCELLANEOUS FABRICATED METAL PRODUCTS", Category.GROUP),
        Classification("3491", "INDUSTRIAL VALVES", Category.CLASS),
        Classification("3492", "FLUID POWER VALVES AND HOSE FITTINGS", Category.CLASS),
        Classification("3493", "STEEL SPRINGS, EXCEPT WIRE", Category.CLASS),
        Classification("3494", "VALVES AND PIPE FITTINGS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("3495", "WIRE SPRINGS", Category.CLASS),
        Classification("3496", "MISCELLANEOUS FABRICATED WIRE PRODUCTS", Category.CLASS),
        Classification("3497", "METAL FOIL AND LEAF", Category.CLASS),
        Classification("3498", "FABRICATED PIPE AND PIPE FITTINGS", Category.CLASS),
        Classification("3499", "FABRICATED METAL PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("35", "INDUSTRIAL AND COMMERCIAL MACHINERY AND COMPUTER EQUIPMENT", Category.DIVISION),
        Classification("351", "ENGINES AND TURBINES", Category.GROUP),
        Classification("3511", "STEAM, GAS, AND HYDRAULIC TURBINES, AND TURBINE GENERATOR SET UNI", Category.CLASS),
        Classification("3519", "INTERNAL COMBUSTION ENGINES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("352", "FARM AND GARDEN MACHINERY AND EQUIPMENT", Category.GROUP),
        Classification("3523", "FARM MACHINERY AND EQUIPMENT", Category.CLASS),
        Classification("3524", "LAWN AND GARDEN TRACTORS AND HOME LAWN AND GARDEN EQUIPMENT", Category.CLASS),
        Classification("3524", "BLOWERS, RESIDENTIAL LAWN", Category.CLASS),
        Classification("353", "CONSTRUCTION, MINING, AND MATERIALS HANDLING MACHINERY AND EQUIPME", Category.GROUP),
        Classification("3531", "CONSTRUCTION MACHINERY AND EQUIPMENT", Category.CLASS),
        Classification("3532", "MINING MACHINERY AND EQUIPMENT, EXCEPT OIL AND GAS FIELD MACHINER", Category.CLASS),
        Classification("3533", "OIL AND GAS FIELD MACHINERY AND EQUIPMENT", Category.CLASS),
        Classification("3534", "ELEVATORS AND MOVING STAIRWAYS", Category.CLASS),
        Classification("3535", "CONVEYORS AND CONVEYING EQUIPMENT", Category.CLASS),
        Classification("3536", "OVERHEAD TRAVELING CRANES, HOISTS, AND MONORAIL SYSTEMS", Category.CLASS),
        Classification("3537", "INDUSTRIAL TRUCKS, TRACTORS, TRAILERS, AND STACKERS", Category.CLASS),
        Classification("354", "METALWORKING MACHINERY AND EQUIPMENT", Category.GROUP),
        Classification("3541", "MACHINE TOOLS, METAL CUTTING TYPES", Category.CLASS),
        Classification("3542", "MACHINE TOOLS, METAL FORMING TYPES", Category.CLASS),
        Classification("3543", "INDUSTRIAL PATTERNS", Category.CLASS),
        Classification("3544", "SPECIAL DIES AND TOOLS, DIE SETS, JIGS AND FIXTURES, AND INDUSTRI", Category.CLASS),
        Classification("3545", "CUTTING TOOLS, MACHINE TOOL ACCESSORIES, AND MACHINISTS' PRECISIO", Category.CLASS),
        Classification("3546", "POWER-DRIVEN HANDTOOLS", Category.CLASS),
        Classification("3547", "ROLLING MILL MACHINERY AND EQUIPMENT", Category.CLASS),
        Classification("3548", "ELECTRIC AND GAS WELDING AND SOLDERING EQUIPMENT", Category.CLASS),
        Classification("3549", "METALWORKING MACHINERY, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("355", "SPECIAL INDUSTRY MACHINERY, EXCEPT METALWORKING MACHINERY", Category.GROUP),
        Classification("3552", "TEXTILE MACHINERY", Category.CLASS),
        Classification("3553", "WOODWORKING MACHINERY", Category.CLASS),
        Classification("3554", "PAPER INDUSTRIES MACHINERY", Category.CLASS),
        Classification("3555", "PRINTING TRADES MACHINERY AND EQUIPMENT", Category.CLASS),
        Classification("3556", "FOOD PRODUCTS MACHINERY", Category.CLASS),
        Classification("3559", "SPECIAL INDUSTRY MACHINERY, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("356", "GENERAL INDUSTRIAL MACHINERY AND EQUIPMENT", Category.GROUP),
        Classification("3561", "PUMPS AND PUMPING EQUIPMENT", Category.CLASS),
        Classification("3562", "BALL AND ROLLER BEARINGS", Category.CLASS),
        Classification("3563", "AIR AND GAS COMPRESSORS", Category.CLASS),
        Classification("3564", "INDUSTRIAL AND COMMERCIAL FANS AND BLOWERS AND AIR PURIFICATION E", Category.CLASS),
        Classification("3565", "PACKAGING MACHINERY", Category.CLASS),
        Classification("3566", "SPEED CHANGERS, INDUSTRIAL HIGH-SPEED DRIVES, AND GEARS", Category.CLASS),
        Classification("3567", "INDUSTRIAL PROCESS FURNACES AND OVENS", Category.CLASS),
        Classification("3568", "MECHANICAL POWER TRANSMISSION EQUIPMENT, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("3569", "GENERAL INDUSTRIAL MACHINERY AND EQUIPMENT, NOT ELSEWHERE CLASSIF", Category.CLASS),
        Classification("357", "COMPUTER AND OFFICE EQUIPMENT", Category.GROUP),
        Classification("3571", "ELECTRONIC COMPUTERS", Category.CLASS),
        Classification("3572", "COMPUTER STORAGE DEVICES", Category.CLASS),
        Classification("3575", "COMPUTER TERMINALS", Category.CLASS),
        Classification("3577", "COMPUTER PERIPHERAL EQUIPMENT, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("3578", "CALCULATING AND ACCOUNTING MACHINES, EXCEPT ELECTRONIC COMPUTERS", Category.CLASS),
        Classification("3579", "OFFICE MACHINES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("358", "REFRIGERATION AND SERVICE INDUSTRY MACHINERY", Category.GROUP),
        Classification("3581", "AUTOMATIC VENDING MACHINES", Category.CLASS),
        Classification("3582", "COMMERCIAL LAUNDRY, DRYCLEANING, AND PRESSING MACHINES", Category.CLASS),
        Classification("3585", "AIR-CONDITIONING AND WARM AIR HEATING EQUIPMENT AND COMMERCIAL AN", Category.CLASS),
        Classification("3586", "MEASURING AND DISPENSING PUMPS", Category.CLASS),
        Classification("3589", "SERVICE INDUSTRY MACHINERY, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("359", "MISCELLANEOUS INDUSTRIAL AND COMMERCIAL MACHINERY AND EQUIPMENT", Category.GROUP),
        Classification("3592", "CARBURETORS, PISTONS, PISTON RINGS, AND VALVES", Category.CLASS),
        Classification("3593", "FLUID POWER CYLINDERS AND ACTUATORS", Category.CLASS),
        Classification("3594", "FLUID POWER PUMPS AND MOTORS", Category.CLASS),
        Classification("3596", "SCALES AND BALANCES, EXCEPT LABORATORY", Category.CLASS),
        Classification("3599", "INDUSTRIAL AND COMMERCIAL MACHINERY AND EQUIPMENT, NOT ELSEWHERE", Category.CLASS),
        Classification(
            "36", "ELECTRONIC AND OTHER ELECTRICAL EQUIPMENT AND COMPONENTS, EXCEPT COMPUTER", Category.DIVISION
        ),
        Classification("361", "ELECTRIC TRANSMISSION AND DISTRIBUTION EQUIPMENT", Category.GROUP),
        Classification("3612", "POWER, DISTRIBUTION, AND SPECIALTY TRANSFORMERS", Category.CLASS),
        Classification("3613", "SWITCHGEAR AND SWITCHBOARD APPARATUS", Category.CLASS),
        Classification("362", "ELECTRICAL INDUSTRIAL APPARATUS", Category.GROUP),
        Classification("3621", "MOTORS AND GENERATORS", Category.CLASS),
        Classification("3624", "CARBON AND GRAPHITE PRODUCTS", Category.CLASS),
        Classification("3625", "RELAYS AND INDUSTRIAL CONTROLS", Category.CLASS),
        Classification("3629", "ELECTRICAL INDUSTRIAL APPARATUS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("363", "HOUSEHOLD APPLIANCES", Category.GROUP),
        Classification("3631", "HOUSEHOLD COOKING EQUIPMENT", Category.CLASS),
        Classification("3632", "HOUSEHOLD REFRIGERATORS AND HOME AND FARM FREEZERS", Category.CLASS),
        Classification("3633", "HOUSEHOLD LAUNDRY EQUIPMENT", Category.CLASS),
        Classification("3634", "ELECTRIC HOUSEWARES AND FANS", Category.CLASS),
        Classification("3635", "HOUSEHOLD VACUUM CLEANERS", Category.CLASS),
        Classification("3639", "HOUSEHOLD APPLIANCES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("364", "ELECTRIC LIGHTING AND WIRING EQUIPMENT", Category.GROUP),
        Classification("3641", "ELECTRIC LAMP BULBS AND TUBES", Category.CLASS),
        Classification("3643", "CURRENT-CARRYING WIRING DEVICES", Category.CLASS),
        Classification("3644", "NONCURRENT-CARRYING WIRING DEVICES", Category.CLASS),
        Classification("3645", "RESIDENTIAL ELECTRIC LIGHTING FIXTURES", Category.CLASS),
        Classification("3646", "COMMERCIAL, INDUSTRIAL, AND INSTITUTIONAL ELECTRIC LIGHTING FIXTU", Category.CLASS),
        Classification("3647", "VEHICULAR LIGHTING EQUIPMENT", Category.CLASS),
        Classification("3648", "LIGHTING EQUIPMENT, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("365", "HOUSEHOLD AUDIO AND VIDEO EQUIPMENT, AND AUDIO RECORDINGS", Category.GROUP),
        Classification("3651", "HOUSEHOLD AUDIO AND VIDEO EQUIPMENT", Category.CLASS),
        Classification("3652", "PHONOGRAPH RECORDS AND PRERECORDED AUDIO TAPES AND DISKS", Category.CLASS),
        Classification("366", "COMMUNICATIONS EQUIPMENT", Category.GROUP),
        Classification("3661", "TELEPHONE AND TELEGRAPH APPARATUS", Category.CLASS),
        Classification("3663", "RADIO AND TELEVISION BROADCASTING AND COMMUNICATIONS EQUIPMENT", Category.CLASS),
        Classification("3669", "COMMUNICATIONS EQUIPMENT, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("367", "ELECTRONIC COMPONENTS AND ACCESSORIES", Category.GROUP),
        Classification("3671", "ELECTRON TUBES", Category.CLASS),
        Classification("3672", "PRINTED CIRCUIT BOARDS", Category.CLASS),
        Classification("3674", "SEMICONDUCTORS AND RELATED DEVICES", Category.CLASS),
        Classification("3675", "ELECTRONIC CAPACITORS", Category.CLASS),
        Classification("3676", "ELECTRONIC RESISTORS", Category.CLASS),
        Classification("3677", "ELECTRONIC COILS, TRANSFORMERS, AND OTHER INDUCTORS", Category.CLASS),
        Classification("3678", "ELECTRONIC CONNECTORS", Category.CLASS),
        Classification("3679", "ELECTRONIC COMPONENTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("369", "MISCELLANEOUS ELECTRICAL MACHINERY, EQUIPMENT, AND SUPPLIES", Category.GROUP),
        Classification("3691", "STORAGE BATTERIES", Category.CLASS),
        Classification("3692", "PRIMARY BATTERIES, DRY AND WET", Category.CLASS),
        Classification("3694", "ELECTRICAL EQUIPMENT FOR INTERNAL COMBUSTION ENGINES", Category.CLASS),
        Classification("3695", "MAGNETIC AND OPTICAL RECORDING MEDIA", Category.CLASS),
        Classification("3699", "ELECTRICAL MACHINERY, EQUIPMENT, AND SUPPLIES, NOT ELSEWHERE CLAS", Category.CLASS),
        Classification("37", "TRANSPORTATION EQUIPMENT", Category.DIVISION),
        Classification("371", "MOTOR VEHICLES AND MOTOR VEHICLE EQUIPMENT", Category.GROUP),
        Classification("3711", "MOTOR VEHICLES AND PASSENGER CAR BODIES", Category.CLASS),
        Classification("3713", "TRUCK AND BUS BODIES", Category.CLASS),
        Classification("3714", "MOTOR VEHICLE PARTS AND ACCESSORIES", Category.CLASS),
        Classification("3715", "TRUCK TRAILERS", Category.CLASS),
        Classification("3716", "MOTOR HOMES", Category.CLASS),
        Classification("372", "AIRCRAFT AND PARTS", Category.GROUP),
        Classification("3721", "AIRCRAFT", Category.CLASS),
        Classification("3724", "AIRCRAFT ENGINES AND ENGINE PARTS", Category.CLASS),
        Classification("3728", "AIRCRAFT PARTS AND AUXILIARY EQUIPMENT, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("373", "SHIP AND BOAT BUILDING AND REPAIRING", Category.GROUP),
        Classification("3731", "SHIP BUILDING AND REPAIRING", Category.CLASS),
        Classification("3732", "BOAT BUILDING AND REPAIRING", Category.CLASS),
        Classification("374", "RAILROAD EQUIPMENT", Category.GROUP),
        Classification("3743", "RAILROAD EQUIPMENT", Category.CLASS),
        Classification("375", "MOTORCYCLES, BICYCLES, AND PARTS", Category.GROUP),
        Classification("3751", "MOTORCYCLES, BICYCLES, AND PARTS", Category.CLASS),
        Classification("376", "GUIDED MISSILES AND SPACE VEHICLES AND PARTS", Category.GROUP),
        Classification("3761", "GUIDED MISSILES AND SPACE VEHICLES", Category.CLASS),
        Classification("3764", "GUIDED MISSILE AND SPACE VEHICLE PROPULSION UNITS AND PROPULSION", Category.CLASS),
        Classification("3769", "GUIDED MISSILE AND SPACE VEHICLE PARTS AND AUXILIARY EQUIPMENT, N", Category.CLASS),
        Classification("379", "MISCELLANEOUS TRANSPORTATION EQUIPMENT", Category.GROUP),
        Classification("3792", "TRAVEL TRAILERS AND CAMPERS", Category.CLASS),
        Classification("3795", "TANKS AND TANK COMPONENTS", Category.CLASS),
        Classification("3799", "TRANSPORTATION EQUIPMENT, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification(
            "38", "MEASURING, ANALYZING AND CONTROLLING INSTRUMENTS; PHOTOGRAPHIC, MEDICAL AN", Category.DIVISION
        ),
        Classification("381", "SEARCH, DETECTION, NAVIGATION, GUIDANCE, AERONAUTICAL, AND NAUTICA", Category.GROUP),
        Classification("3812", "SEARCH, DETECTION, NAVIGATION, GUIDANCE, AERONAUTICAL, AND NAUTIC", Category.CLASS),
        Classification("382", "LABORATORY APPARATUS AND ANALYTICAL, OPTICAL, MEASURING, AND CONTR", Category.GROUP),
        Classification("3821", "LABORATORY APPARATUS AND FURNITURE", Category.CLASS),
        Classification("3822", "AUTOMATIC CONTROLS FOR REGULATING RESIDENTIAL AND COMMERCIAL ENVI", Category.CLASS),
        Classification("3823", "INDUSTRIAL INSTRUMENTS FOR MEASUREMENT, DISPLAY, AND CONTROL OF P", Category.CLASS),
        Classification("3824", "TOTALIZING FLUID METERS AND COUNTING DEVICES", Category.CLASS),
        Classification("3825", "INSTRUMENTS FOR MEASURING AND TESTING OF ELECTRICITY AND ELECTRIC", Category.CLASS),
        Classification("3826", "LABORATORY ANALYTICAL INSTRUMENTS", Category.CLASS),
        Classification("3827", "OPTICAL INSTRUMENTS AND LENSES", Category.CLASS),
        Classification("3829", "MEASURING AND CONTROLLING DEVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("384", "SURGICAL, MEDICAL, AND DENTAL INSTRUMENTS AND SUPPLIES", Category.GROUP),
        Classification("3841", "SURGICAL AND MEDICAL INSTRUMENTS AND APPARATUS", Category.CLASS),
        Classification("3842", "ORTHOPEDIC, PROSTHETIC, AND SURGICAL APPLIANCES AND SUPPLIES", Category.CLASS),
        Classification("3843", "DENTAL EQUIPMENT AND SUPPLIES", Category.CLASS),
        Classification("3844", "X-RAY APPARATUS AND TUBES AND RELATED IRRADIATION APPARATUS", Category.CLASS),
        Classification("3845", "ELECTROMEDICAL AND ELECTROTHERAPEUTIC APPARATUS", Category.CLASS),
        Classification("385", "OPHTHALMIC GOODS", Category.GROUP),
        Classification("3851", "OPHTHALMIC GOODS", Category.CLASS),
        Classification("386", "PHOTOGRAPHIC EQUIPMENT AND SUPPLIES", Category.GROUP),
        Classification("3861", "PHOTOGRAPHIC EQUIPMENT AND SUPPLIES", Category.CLASS),
        Classification("387", "WATCHES, CLOCKS, CLOCKWORK OPERATED DEVICES, AND PARTS", Category.GROUP),
        Classification("3873", "WATCHES, CLOCKS, CLOCKWORK OPERATED DEVICES, AND PARTS", Category.CLASS),
        Classification("39", "MISCELLANEOUS MANUFACTURING INDUSTRIES", Category.DIVISION),
        Classification("391", "JEWELRY, SILVERWARE, AND PLATED WARE", Category.GROUP),
        Classification("3911", "JEWELRY, PRECIOUS METAL", Category.CLASS),
        Classification("3914", "SILVERWARE, PLATED WARE, AND STAINLESS STEEL WARE", Category.CLASS),
        Classification("3915", "JEWELERS' FINDINGS AND MATERIALS, AND LAPIDARY WORK", Category.CLASS),
        Classification("393", "MUSICAL INSTRUMENTS", Category.GROUP),
        Classification("3931", "MUSICAL INSTRUMENTS", Category.CLASS),
        Classification("394", "DOLLS, TOYS, GAMES AND SPORTING AND ATHLETIC GOODS", Category.GROUP),
        Classification("3942", "DOLLS AND STUFFED TOYS", Category.CLASS),
        Classification("3944", "GAMES, TOYS, AND CHILDREN'S VEHICLES, EXCEPT DOLLS AND BICYCLES", Category.CLASS),
        Classification("3949", "SPORTING AND ATHLETIC GOODS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("395", "PENS, PENCILS, AND OTHER ARTISTS' MATERIALS", Category.GROUP),
        Classification("3951", "PENS, MECHANICAL PENCILS, AND PARTS", Category.CLASS),
        Classification("3952", "LEAD PENCILS, CRAYONS, AND ARTISTS' MATERIALS", Category.CLASS),
        Classification("3953", "MARKING DEVICES", Category.CLASS),
        Classification("3955", "CARBON PAPER AND INKED RIBBONS", Category.CLASS),
        Classification("396", "COSTUME JEWELRY, COSTUME NOVELTIES, BUTTONS, AND MISCELLANEOUS NOT", Category.GROUP),
        Classification("3961", "COSTUME JEWELRY AND COSTUME NOVELTIES, EXCEPT PRECIOUS METAL", Category.CLASS),
        Classification("3965", "FASTENERS, BUTTONS, NEEDLES, AND PINS", Category.CLASS),
        Classification("399", "MISCELLANEOUS MANUFACTURING INDUSTRIES", Category.GROUP),
        Classification("3991", "BROOMS AND BRUSHES", Category.CLASS),
        Classification("3993", "SIGNS AND ADVERTISING SPECIALTIES", Category.CLASS),
        Classification("3995", "BURIAL CASKETS", Category.CLASS),
        Classification("3996", "LINOLEUM, ASPHALTED-FELT-BASE, AND OTHER HARD SURFACE FLOOR COVER", Category.CLASS),
        Classification("3999", "MANUFACTURING INDUSTRIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("E", "TRANSPORTATION, COMMUNICATIONS, ELECTRIC, GAS, AND SANITARY SERVICE", Category.SECTION),
        Classification("40", "RAILROAD TRANSPORTATION", Category.DIVISION),
        Classification("401", "RAILROADS", Category.GROUP),
        Classification("4011", "RAILROADS, LINE-HAUL OPERATING", Category.CLASS),
        Classification("4013", "RAILROAD SWITCHING AND TERMINAL ESTABLISHMENTS", Category.CLASS),
        Classification(
            "41", "LOCAL AND SUBURBAN TRANSIT AND INTERURBAN HIGHWAY PASSENGER TRANSPORTATION", Category.DIVISION
        ),
        Classification("411", "LOCAL AND SUBURBAN PASSENGER TRANSPORTATION", Category.GROUP),
        Classification("4111", "LOCAL AND SUBURBAN TRANSIT", Category.CLASS),
        Classification("4119", "LOCAL PASSENGER TRANSPORTATION, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("412", "TAXICABS", Category.GROUP),
        Classification("4121", "TAXICABS", Category.CLASS),
        Classification("413", "INTERCITY AND RURAL BUS TRANSPORTATION", Category.GROUP),
        Classification("4131", "INTERCITY AND RURAL BUS TRANSPORTATION", Category.CLASS),
        Classification("414", "BUS CHARTER SERVICE", Category.GROUP),
        Classification("4141", "LOCAL BUS CHARTER SERVICE", Category.CLASS),
        Classification("4142", "BUS CHARTER SERVICE, EXCEPT LOCAL", Category.CLASS),
        Classification("415", "SCHOOL BUSES", Category.GROUP),
        Classification("4151", "SCHOOL BUSES", Category.CLASS),
        Classification("417", "TERMINAL AND SERVICE FACILITIES FOR MOTOR VEHICLE PASSENGER TRANSP", Category.GROUP),
        Classification("4173", "TERMINAL AND SERVICE FACILITIES FOR MOTOR VEHICLE PASSENGER TRANS", Category.CLASS),
        Classification("42", "MOTOR FREIGHT TRANSPORTATION AND WAREHOUSING", Category.DIVISION),
        Classification("421", "TRUCKING AND COURIER SERVICES, EXCEPT AIR", Category.GROUP),
        Classification("4212", "LOCAL TRUCKING WITHOUT STORAGE", Category.CLASS),
        Classification("4213", "TRUCKING, EXCEPT LOCAL", Category.CLASS),
        Classification("4214", "LOCAL TRUCKING WITH STORAGE", Category.CLASS),
        Classification("4215", "COURIER SERVICES, EXCEPT BY AIR", Category.CLASS),
        Classification("422", "PUBLIC WAREHOUSING AND STORAGE", Category.GROUP),
        Classification("4221", "FARM PRODUCT WAREHOUSING AND STORAGE", Category.CLASS),
        Classification("4222", "REFRIGERATED WAREHOUSING AND STORAGE", Category.CLASS),
        Classification("4225", "GENERAL WAREHOUSING AND STORAGE", Category.CLASS),
        Classification("4226", "SPECIAL WAREHOUSING AND STORAGE, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("423", "TERMINAL AND JOINT TERMINAL MAINTENANCE FACILITIES FOR MOTOR FREIG", Category.GROUP),
        Classification("4231", "TERMINAL AND JOINT TERMINAL MAINTENANCE FACILITIES FOR MOTOR FREI", Category.CLASS),
        Classification("43", "UNITED STATES POSTAL SERVICE", Category.DIVISION),
        Classification("431", "UNITED STATES POSTAL SERVICE", Category.GROUP),
        Classification("4311", "UNITED STATES POSTAL SERVICE", Category.CLASS),
        Classification("44", "WATER TRANSPORTATION", Category.DIVISION),
        Classification("441", "DEEP SEA FOREIGN TRANSPORTATION OF FREIGHT", Category.GROUP),
        Classification("4412", "DEEP SEA FOREIGN TRANSPORTATION OF FREIGHT", Category.CLASS),
        Classification("442", "DEEP SEA DOMESTIC TRANSPORTATION OF FREIGHT", Category.GROUP),
        Classification("4424", "DEEP SEA DOMESTIC TRANSPORTATION OF FREIGHT", Category.CLASS),
        Classification("443", "FREIGHT TRANSPORTATION ON THE GREAT LAKES&die;ST. LAWRENCE SEAWAY", Category.GROUP),
        Classification("4432", "FREIGHT TRANSPORTATION ON THE GREAT LAKES&die;ST. LAWRENCE SEAWAY", Category.CLASS),
        Classification("444", "WATER TRANSPORTATION OF FREIGHT, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("4449", "WATER TRANSPORTATION OF FREIGHT, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("448", "WATER TRANSPORTATION OF PASSENGERS", Category.GROUP),
        Classification("4481", "DEEP SEA TRANSPORTATION OF PASSENGERS, EXCEPT BY FERRY", Category.CLASS),
        Classification("4482", "FERRIES", Category.CLASS),
        Classification("4489", "WATER TRANSPORTATION OF PASSENGERS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("449", "SERVICES INCIDENTAL TO WATER TRANSPORTATION", Category.GROUP),
        Classification("4491", "MARINE CARGO HANDLING", Category.CLASS),
        Classification("4492", "TOWING AND TUGBOAT SERVICES", Category.CLASS),
        Classification("4493", "MARINAS", Category.CLASS),
        Classification("4499", "WATER TRANSPORTATION SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("45", "TRANSPORTATION BY AIR", Category.DIVISION),
        Classification("451", "AIR TRANSPORTATION, SCHEDULED, AND AIR COURIER SERVICES", Category.GROUP),
        Classification("4512", "AIR TRANSPORTATION, SCHEDULED", Category.CLASS),
        Classification("4513", "AIR COURIER SERVICES", Category.CLASS),
        Classification("452", "AIR TRANSPORTATION, NONSCHEDULED", Category.GROUP),
        Classification("4522", "AIR TRANSPORTATION, NONSCHEDULED", Category.CLASS),
        Classification("458", "AIRPORTS, FLYING FIELDS, AND AIRPORT TERMINAL SERVICES", Category.GROUP),
        Classification("4581", "AIRPORTS, FLYING FIELDS, AND AIRPORT TERMINAL SERVICES", Category.CLASS),
        Classification("46", "PIPELINES, EXCEPT NATURAL GAS", Category.DIVISION),
        Classification("461", "PIPELINES, EXCEPT NATURAL GAS", Category.GROUP),
        Classification("4612", "CRUDE PETROLEUM PIPELINES", Category.CLASS),
        Classification("4613", "REFINED PETROLEUM PIPELINES", Category.CLASS),
        Classification("4619", "PIPELINES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("47", "TRANSPORTATION SERVICES", Category.DIVISION),
        Classification("472", "ARRANGEMENT OF PASSENGER TRANSPORTATION", Category.GROUP),
        Classification("4724", "TRAVEL AGENCIES", Category.CLASS),
        Classification("4725", "TOUR OPERATORS", Category.CLASS),
        Classification("4729", "ARRANGEMENT OF PASSENGER TRANSPORTATION, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("473", "ARRANGEMENT OF TRANSPORTATION OF FREIGHT AND CARGO", Category.GROUP),
        Classification("4731", "ARRANGEMENT OF TRANSPORTATION OF FREIGHT AND CARGO", Category.CLASS),
        Classification("474", "RENTAL OF RAILROAD CARS", Category.GROUP),
        Classification("4741", "RENTAL OF RAILROAD CARS", Category.CLASS),
        Classification("478", "MISCELLANEOUS SERVICES INCIDENTAL TO TRANSPORTATION", Category.GROUP),
        Classification("4783", "PACKING AND CRATING", Category.CLASS),
        Classification("4785", "FIXED FACILITIES AND INSPECTION AND WEIGHING SERVICES FOR MOTOR V", Category.CLASS),
        Classification("4785", "CARGO CHECKERS AND SURVEYORS, MARINE", Category.CLASS),
        Classification("4789", "TRANSPORTATION SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("48", "COMMUNICATIONS", Category.DIVISION),
        Classification("481", "TELEPHONE COMMUNICATIONS", Category.GROUP),
        Classification("4812", "RADIOTELEPHONE COMMUNICATIONS", Category.CLASS),
        Classification("4813", "TELEPHONE COMMUNICATIONS, EXCEPT RADIOTELEPHONE", Category.CLASS),
        Classification("482", "TELEGRAPH AND OTHER MESSAGE COMMUNICATIONS", Category.GROUP),
        Classification("4822", "TELEGRAPH AND OTHER MESSAGE COMMUNICATIONS", Category.CLASS),
        Classification("483", "RADIO AND TELEVISION BROADCASTING STATIONS", Category.GROUP),
        Classification("4832", "RADIO BROADCASTING STATIONS", Category.CLASS),
        Classification("4833", "TELEVISION BROADCASTING STATIONS", Category.CLASS),
        Classification("484", "CABLE AND OTHER PAY TELEVISION SERVICES", Category.GROUP),
        Classification("4841", "CABLE AND OTHER PAY TELEVISION SERVICES", Category.CLASS),
        Classification("489", "COMMUNICATIONS SERVICES, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("4899", "COMMUNICATIONS SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("49", "ELECTRIC, GAS, AND SANITARY SERVICES", Category.DIVISION),
        Classification("491", "ELECTRIC SERVICES", Category.GROUP),
        Classification("4911", "ELECTRIC SERVICES", Category.CLASS),
        Classification("492", "GAS PRODUCTION AND DISTRIBUTION", Category.GROUP),
        Classification("4922", "NATURAL GAS TRANSMISSION", Category.CLASS),
        Classification("4923", "NATURAL GAS TRANSMISSION AND DISTRIBUTION", Category.CLASS),
        Classification("4924", "NATURAL GAS DISTRIBUTION", Category.CLASS),
        Classification("4925", "MIXED, MANUFACTURED, OR LIQUEFIED PETROLEUM GAS PRODUCTION AND/OR", Category.CLASS),
        Classification("493", "COMBINATION ELECTRIC AND GAS, AND OTHER UTILITY SERVICES", Category.GROUP),
        Classification("4931", "ELECTRIC AND OTHER SERVICES COMBINED", Category.CLASS),
        Classification("4932", "GAS AND OTHER SERVICES COMBINED", Category.CLASS),
        Classification("4939", "COMBINATION UTILITIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("494", "WATER SUPPLY", Category.GROUP),
        Classification("4941", "WATER SUPPLY", Category.CLASS),
        Classification("495", "SANITARY SERVICES", Category.GROUP),
        Classification("4952", "SEWERAGE SYSTEMS", Category.CLASS),
        Classification("4953", "REFUSE SYSTEMS", Category.CLASS),
        Classification("4959", "SANITARY SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("496", "STEAM AND AIR-CONDITIONING SUPPLY", Category.GROUP),
        Classification("4961", "STEAM AND AIR-CONDITIONING SUPPLY", Category.CLASS),
        Classification("497", "IRRIGATION SYSTEMS", Category.GROUP),
        Classification("4971", "IRRIGATION SYSTEMS", Category.CLASS),
        Classification("F", "WHOLESALE TRADE", Category.SECTION),
        Classification("50", "WHOLESALE TRADE&die;DURABLE GOODS", Category.DIVISION),
        Classification("501", "MOTOR VEHICLES AND MOTOR VEHICLE PARTS AND SUPPLIES", Category.GROUP),
        Classification("5012", "AUTOMOBILES AND OTHER MOTOR VEHICLES", Category.CLASS),
        Classification("5013", "MOTOR VEHICLE SUPPLIES AND NEW PARTS", Category.CLASS),
        Classification("5014", "TIRES AND TUBES", Category.CLASS),
        Classification("5015", "MOTOR VEHICLE PARTS, USED", Category.CLASS),
        Classification("502", "FURNITURE AND HOMEFURNISHINGS", Category.GROUP),
        Classification("5021", "FURNITURE", Category.CLASS),
        Classification("5023", "HOMEFURNISHINGS", Category.CLASS),
        Classification("503", "LUMBER AND OTHER CONSTRUCTION MATERIALS", Category.GROUP),
        Classification("5031", "LUMBER, PLYWOOD, MILLWORK, AND WOOD PANELS", Category.CLASS),
        Classification("5032", "BRICK, STONE, AND RELATED CONSTRUCTION MATERIALS", Category.CLASS),
        Classification("5033", "ROOFING, SIDING, AND INSULATION MATERIALS", Category.CLASS),
        Classification("5039", "CONSTRUCTION MATERIALS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("504", "PROFESSIONAL AND COMMERCIAL EQUIPMENT AND SUPPLIES", Category.GROUP),
        Classification("5043", "PHOTOGRAPHIC EQUIPMENT AND SUPPLIES", Category.CLASS),
        Classification("5044", "OFFICE EQUIPMENT", Category.CLASS),
        Classification("5045", "COMPUTERS AND COMPUTER PERIPHERAL EQUIPMENT AND SOFTWARE", Category.CLASS),
        Classification("5046", "COMMERCIAL EQUIPMENT, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("5047", "MEDICAL, DENTAL, AND HOSPITAL EQUIPMENT AND SUPPLIES", Category.CLASS),
        Classification("5048", "OPHTHALMIC GOODS", Category.CLASS),
        Classification("5049", "PROFESSIONAL EQUIPMENT AND SUPPLIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("505", "METALS AND MINERALS, EXCEPT PETROLEUM", Category.GROUP),
        Classification("5051", "METALS SERVICE CENTERS AND OFFICES", Category.CLASS),
        Classification("5052", "COAL AND OTHER MINERALS AND ORES", Category.CLASS),
        Classification("506", "ELECTRICAL GOODS", Category.GROUP),
        Classification("5063", "ELECTRICAL APPARATUS AND EQUIPMENT, WIRING SUPPLIES, AND CONSTRUC", Category.CLASS),
        Classification("5064", "ELECTRICAL APPLIANCES, TELEVISION AND RADIO SETS", Category.CLASS),
        Classification("5065", "ELECTRONIC PARTS AND EQUIPMENT, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("507", "HARDWARE, AND PLUMBING AND HEATING EQUIPMENT AND SUPPLIES", Category.GROUP),
        Classification("5072", "HARDWARE", Category.CLASS),
        Classification("5074", "PLUMBING AND HEATING EQUIPMENT AND SUPPLIES (HYDRONICS)", Category.CLASS),
        Classification("5075", "WARM AIR HEATING AND AIR-CONDITIONING EQUIPMENT AND SUPPLIES", Category.CLASS),
        Classification("5078", "REFRIGERATION EQUIPMENT AND SUPPLIES", Category.CLASS),
        Classification("508", "MACHINERY, EQUIPMENT, AND SUPPLIES", Category.GROUP),
        Classification("5082", "CONSTRUCTION AND MINING (EXCEPT PETROLEUM) MACHINERY AND EQUIPMEN", Category.CLASS),
        Classification("5083", "FARM AND GARDEN MACHINERY AND EQUIPMENT", Category.CLASS),
        Classification("5084", "INDUSTRIAL MACHINERY AND EQUIPMENT", Category.CLASS),
        Classification("5085", "INDUSTRIAL SUPPLIES", Category.CLASS),
        Classification("5087", "SERVICE ESTABLISHMENT EQUIPMENT AND SUPPLIES", Category.CLASS),
        Classification("5088", "TRANSPORTATION EQUIPMENT AND SUPPLIES, EXCEPT MOTOR VEHICLES", Category.CLASS),
        Classification("509", "MISCELLANEOUS DURABLE GOODS", Category.GROUP),
        Classification("5091", "SPORTING AND RECREATIONAL GOODS AND SUPPLIES", Category.CLASS),
        Classification("5092", "TOYS AND HOBBY GOODS AND SUPPLIES", Category.CLASS),
        Classification("5093", "SCRAP AND WASTE MATERIALS", Category.CLASS),
        Classification("5094", "JEWELRY, WATCHES, PRECIOUS STONES, AND PRECIOUS METALS", Category.CLASS),
        Classification("5099", "DURABLE GOODS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("51", "WHOLESALE TRADE&die;NONDURABLE GOODS", Category.DIVISION),
        Classification("511", "PAPER AND PAPER PRODUCTS", Category.GROUP),
        Classification("5111", "PRINTING AND WRITING PAPER", Category.CLASS),
        Classification("5112", "STATIONERY AND OFFICE SUPPLIES", Category.CLASS),
        Classification("5113", "INDUSTRIAL AND PERSONAL SERVICE PAPER", Category.CLASS),
        Classification("512", "DRUGS, DRUG PROPRIETARIES, AND DRUGGISTS' SUNDRIES", Category.GROUP),
        Classification("5122", "DRUGS, DRUG PROPRIETARIES, AND DRUGGISTS' SUNDRIES", Category.CLASS),
        Classification("513", "APPAREL, PIECE GOODS, AND NOTIONS", Category.GROUP),
        Classification("5131", "PIECE GOODS, NOTIONS, AND OTHER DRY GOODS", Category.CLASS),
        Classification("5136", "MEN'S AND BOYS' CLOTHING AND FURNISHINGS", Category.CLASS),
        Classification("5137", "WOMEN'S, CHILDREN'S, AND INFANTS' CLOTHING AND ACCESSORIES", Category.CLASS),
        Classification("5139", "FOOTWEAR", Category.CLASS),
        Classification("514", "GROCERIES AND RELATED PRODUCTS", Category.GROUP),
        Classification("5141", "GROCERIES, GENERAL LINE", Category.CLASS),
        Classification("5142", "PACKAGED FROZEN FOODS", Category.CLASS),
        Classification("5143", "DAIRY PRODUCTS, EXCEPT DRIED OR CANNED", Category.CLASS),
        Classification("5144", "POULTRY AND POULTRY PRODUCTS", Category.CLASS),
        Classification("5145", "CONFECTIONERY", Category.CLASS),
        Classification("5146", "FISH AND SEAFOODS", Category.CLASS),
        Classification("5147", "MEATS AND MEAT PRODUCTS", Category.CLASS),
        Classification("5148", "FRESH FRUITS AND VEGETABLES", Category.CLASS),
        Classification("5149", "GROCERIES AND RELATED PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("515", "FARM-PRODUCT RAW MATERIALS", Category.GROUP),
        Classification("5153", "GRAIN AND FIELD BEANS", Category.CLASS),
        Classification("5154", "LIVESTOCK", Category.CLASS),
        Classification("5159", "FARM-PRODUCT RAW MATERIALS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("516", "CHEMICALS AND ALLIED PRODUCTS", Category.GROUP),
        Classification("5162", "PLASTICS MATERIALS AND BASIC FORMS AND SHAPES", Category.CLASS),
        Classification("5169", "CHEMICALS AND ALLIED PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("517", "PETROLEUM AND PETROLEUM PRODUCTS", Category.GROUP),
        Classification("5171", "PETROLEUM BULK STATIONS AND TERMINALS", Category.CLASS),
        Classification("5172", "PETROLEUM AND PETROLEUM PRODUCTS WHOLESALERS, EXCEPT BULK STATION", Category.CLASS),
        Classification("518", "BEER, WINE, AND DISTILLED ALCOHOLIC BEVERAGES", Category.GROUP),
        Classification("5181", "BEER AND ALE", Category.CLASS),
        Classification("5182", "WINE AND DISTILLED ALCOHOLIC BEVERAGES", Category.CLASS),
        Classification("519", "MISCELLANEOUS NONDURABLE GOODS", Category.GROUP),
        Classification("5191", "FARM SUPPLIES", Category.CLASS),
        Classification("5192", "BOOKS, PERIODICALS, AND NEWSPAPERS", Category.CLASS),
        Classification("5193", "FLOWERS, NURSERY STOCK, AND FLORISTS' SUPPLIES", Category.CLASS),
        Classification("5194", "TOBACCO AND TOBACCO PRODUCTS", Category.CLASS),
        Classification("5198", "PAINTS, VARNISHES, AND SUPPLIES", Category.CLASS),
        Classification("5199", "NONDURABLE GOODS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("G", "RETAIL TRADE", Category.SECTION),
        Classification("52", "BUILDING MATERIALS, HARDWARE, GARDEN SUPPLY, AND MOBILE HOME DEALERS", Category.DIVISION),
        Classification("521", "LUMBER AND OTHER BUILDING MATERIALS DEALERS", Category.GROUP),
        Classification("5211", "LUMBER AND OTHER BUILDING MATERIALS DEALERS", Category.CLASS),
        Classification("523", "PAINT, GLASS, AND WALLPAPER STORES", Category.GROUP),
        Classification("5231", "PAINT, GLASS, AND WALLPAPER STORES", Category.CLASS),
        Classification("525", "HARDWARE STORES", Category.GROUP),
        Classification("5251", "HARDWARE STORES", Category.CLASS),
        Classification("526", "RETAIL NURSERIES, LAWN AND GARDEN SUPPLY STORES", Category.GROUP),
        Classification("5261", "RETAIL NURSERIES, LAWN AND GARDEN SUPPLY STORES", Category.CLASS),
        Classification("527", "MOBILE HOME DEALERS", Category.GROUP),
        Classification("5271", "MOBILE HOME DEALERS", Category.CLASS),
        Classification("53", "GENERAL MERCHANDISE STORES", Category.DIVISION),
        Classification("531", "DEPARTMENT STORES", Category.GROUP),
        Classification("5311", "DEPARTMENT STORES", Category.CLASS),
        Classification("533", "VARIETY STORES", Category.GROUP),
        Classification("5331", "VARIETY STORES", Category.CLASS),
        Classification("539", "MISCELLANEOUS GENERAL MERCHANDISE STORES", Category.GROUP),
        Classification("5399", "MISCELLANEOUS GENERAL MERCHANDISE STORES", Category.CLASS),
        Classification("54", "FOOD STORES", Category.DIVISION),
        Classification("541", "GROCERY STORES", Category.GROUP),
        Classification("5411", "GROCERY STORES", Category.CLASS),
        Classification("542", "MEAT AND FISH (SEAFOOD) MARKETS, INCLUDING FREEZER PROVISIONERS", Category.GROUP),
        Classification("5421", "MEAT AND FISH (SEAFOOD) MARKETS, INCLUDING FREEZER PROVISIONERS", Category.CLASS),
        Classification("543", "FRUIT AND VEGETABLE MARKETS", Category.GROUP),
        Classification("5431", "FRUIT AND VEGETABLE MARKETS", Category.CLASS),
        Classification("544", "CANDY, NUT, AND CONFECTIONERY STORES", Category.GROUP),
        Classification("5441", "CANDY, NUT, AND CONFECTIONERY STORES", Category.CLASS),
        Classification("545", "DAIRY PRODUCTS STORES", Category.GROUP),
        Classification("5451", "DAIRY PRODUCTS STORES", Category.CLASS),
        Classification("546", "RETAIL BAKERIES", Category.GROUP),
        Classification("5461", "RETAIL BAKERIES", Category.CLASS),
        Classification("549", "MISCELLANEOUS FOOD STORES", Category.GROUP),
        Classification("5499", "MISCELLANEOUS FOOD STORES", Category.CLASS),
        Classification("55", "AUTOMOTIVE DEALERS AND GASOLINE SERVICE STATIONS", Category.DIVISION),
        Classification("551", "MOTOR VEHICLE DEALERS (NEW AND USED)", Category.GROUP),
        Classification("5511", "MOTOR VEHICLE DEALERS (NEW AND USED)", Category.CLASS),
        Classification("552", "MOTOR VEHICLE DEALERS (USED ONLY)", Category.GROUP),
        Classification("5521", "MOTOR VEHICLE DEALERS (USED ONLY)", Category.CLASS),
        Classification("553", "AUTO AND HOME SUPPLY STORES", Category.GROUP),
        Classification("5531", "AUTO AND HOME SUPPLY STORES", Category.CLASS),
        Classification("554", "GASOLINE SERVICE STATIONS", Category.GROUP),
        Classification("5541", "GASOLINE SERVICE STATIONS", Category.CLASS),
        Classification("555", "BOAT DEALERS", Category.GROUP),
        Classification("5551", "BOAT DEALERS", Category.CLASS),
        Classification("556", "RECREATIONAL VEHICLE DEALERS", Category.GROUP),
        Classification("5561", "RECREATIONAL VEHICLE DEALERS", Category.CLASS),
        Classification("557", "MOTORCYCLE DEALERS", Category.GROUP),
        Classification("5571", "MOTORCYCLE DEALERS", Category.CLASS),
        Classification("559", "AUTOMOTIVE DEALERS, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("5599", "AUTOMOTIVE DEALERS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("56", "APPAREL AND ACCESSORY STORES", Category.DIVISION),
        Classification("561", "MEN'S AND BOYS' CLOTHING AND ACCESSORY STORES", Category.GROUP),
        Classification("5611", "MEN'S AND BOYS' CLOTHING AND ACCESSORY STORES", Category.CLASS),
        Classification("562", "WOMEN'S CLOTHING STORES", Category.GROUP),
        Classification("5621", "WOMEN'S CLOTHING STORES", Category.CLASS),
        Classification("563", "WOMEN'S ACCESSORY AND SPECIALTY STORES", Category.GROUP),
        Classification("5632", "WOMEN'S ACCESSORY AND SPECIALTY STORES", Category.CLASS),
        Classification("564", "CHILDREN'S AND INFANTS' WEAR STORES", Category.GROUP),
        Classification("5641", "CHILDREN'S AND INFANTS' WEAR STORES", Category.CLASS),
        Classification("565", "FAMILY CLOTHING STORES", Category.GROUP),
        Classification("5651", "FAMILY CLOTHING STORES", Category.CLASS),
        Classification("566", "SHOE STORES", Category.GROUP),
        Classification("5661", "SHOE STORES", Category.CLASS),
        Classification("569", "MISCELLANEOUS APPAREL AND ACCESSORY STORES", Category.GROUP),
        Classification("5699", "MISCELLANEOUS APPAREL AND ACCESSORY STORES", Category.CLASS),
        Classification("57", "HOME FURNITURE, FURNISHINGS, AND EQUIPMENT STORES", Category.DIVISION),
        Classification("571", "HOME FURNITURE AND FURNISHINGS STORES", Category.GROUP),
        Classification("5712", "FURNITURE STORES", Category.CLASS),
        Classification("5713", "FLOOR COVERING STORES", Category.CLASS),
        Classification("5714", "DRAPERY, CURTAIN, AND UPHOLSTERY STORES", Category.CLASS),
        Classification("5719", "MISCELLANEOUS HOMEFURNISHINGS STORES", Category.CLASS),
        Classification("572", "HOUSEHOLD APPLIANCE STORES", Category.GROUP),
        Classification("5722", "HOUSEHOLD APPLIANCE STORES", Category.CLASS),
        Classification("573", "RADIO, TELEVISION, CONSUMER ELECTRONICS, AND MUSIC STORES", Category.GROUP),
        Classification("5731", "RADIO, TELEVISION, AND CONSUMER ELECTRONICS STORES", Category.CLASS),
        Classification("5734", "COMPUTER AND COMPUTER SOFTWARE STORES", Category.CLASS),
        Classification("5735", "RECORD AND PRERECORDED TAPE STORES", Category.CLASS),
        Classification("5736", "MUSICAL INSTRUMENT STORES", Category.CLASS),
        Classification("58", "EATING AND DRINKING PLACES", Category.DIVISION),
        Classification("581", "EATING AND DRINKING PLACES", Category.GROUP),
        Classification("5812", "EATING PLACES", Category.CLASS),
        Classification("5813", "DRINKING PLACES (ALCOHOLIC BEVERAGES)", Category.CLASS),
        Classification("59", "MISCELLANEOUS RETAIL", Category.DIVISION),
        Classification("591", "DRUG STORES AND PROPRIETARY STORES", Category.GROUP),
        Classification("5912", "DRUG STORES AND PROPRIETARY STORES", Category.CLASS),
        Classification("592", "LIQUOR STORES", Category.GROUP),
        Classification("5921", "LIQUOR STORES", Category.CLASS),
        Classification("593", "USED MERCHANDISE STORES", Category.GROUP),
        Classification("5932", "USED MERCHANDISE STORES", Category.CLASS),
        Classification("594", "MISCELLANEOUS SHOPPING GOODS STORES", Category.GROUP),
        Classification("5941", "SPORTING GOODS STORES AND BICYCLE SHOPS", Category.CLASS),
        Classification("5942", "BOOK STORES", Category.CLASS),
        Classification("5943", "STATIONERY STORES", Category.CLASS),
        Classification("5944", "JEWELRY STORES", Category.CLASS),
        Classification("5945", "HOBBY, TOY, AND GAME SHOPS", Category.CLASS),
        Classification("5946", "CAMERA AND PHOTOGRAPHIC SUPPLY STORES", Category.CLASS),
        Classification("5947", "GIFT, NOVELTY, AND SOUVENIR SHOPS", Category.CLASS),
        Classification("5948", "LUGGAGE AND LEATHER GOODS STORES", Category.CLASS),
        Classification("5949", "SEWING, NEEDLEWORK, AND PIECE GOODS STORES", Category.CLASS),
        Classification("596", "NONSTORE RETAILERS", Category.GROUP),
        Classification("5961", "CATALOG AND MAIL-ORDER HOUSES", Category.CLASS),
        Classification("5962", "AUTOMATIC MERCHANDISING MACHINE OPERATORS", Category.CLASS),
        Classification("5963", "DIRECT SELLING ESTABLISHMENTS", Category.CLASS),
        Classification("598", "FUEL DEALERS", Category.GROUP),
        Classification("5983", "FUEL OIL DEALERS", Category.CLASS),
        Classification("5984", "LIQUEFIED PETROLEUM GAS (BOTTLED GAS) DEALERS", Category.CLASS),
        Classification("5989", "FUEL DEALERS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("599", "RETAIL STORES, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("5992", "FLORISTS", Category.CLASS),
        Classification("5993", "TOBACCO STORES AND STANDS", Category.CLASS),
        Classification("5994", "NEWS DEALERS AND NEWSSTANDS", Category.CLASS),
        Classification("5995", "OPTICAL GOODS STORES", Category.CLASS),
        Classification("5999", "MISCELLANEOUS RETAIL STORES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("H", "FINANCE, INSURANCE, AND REAL ESTATE", Category.SECTION),
        Classification("60", "DEPOSITORY INSTITUTIONS", Category.DIVISION),
        Classification("601", "CENTRAL RESERVE DEPOSITORY INSTITUTIONS", Category.GROUP),
        Classification("6011", "FEDERAL RESERVE BANKS", Category.CLASS),
        Classification("6019", "CENTRAL RESERVE DEPOSITORY INSTITUTIONS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("602", "COMMERCIAL BANKS", Category.GROUP),
        Classification("6021", "NATIONAL COMMERCIAL BANKS", Category.CLASS),
        Classification("6022", "STATE COMMERCIAL BANKS", Category.CLASS),
        Classification("6029", "COMMERCIAL BANKS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("603", "SAVINGS INSTITUTIONS", Category.GROUP),
        Classification("6035", "SAVINGS INSTITUTIONS, FEDERALLY CHARTERED", Category.CLASS),
        Classification("6036", "SAVINGS INSTITUTIONS, NOT FEDERALLY CHARTERED", Category.CLASS),
        Classification("606", "CREDIT UNIONS", Category.GROUP),
        Classification("6061", "CREDIT UNIONS, FEDERALLY CHARTERED", Category.CLASS),
        Classification("6062", "CREDIT UNIONS, NOT FEDERALLY CHARTERED", Category.CLASS),
        Classification("608", "FOREIGN BANKING AND BRANCHES AND AGENCIES OF FOREIGN BANKS", Category.GROUP),
        Classification("6081", "BRANCHES AND AGENCIES OF FOREIGN BANKS", Category.CLASS),
        Classification("6082", "FOREIGN TRADE AND INTERNATIONAL BANKING INSTITUTIONS", Category.CLASS),
        Classification("609", "FUNCTIONS RELATED TO DEPOSITORY BANKING", Category.GROUP),
        Classification("6091", "NONDEPOSIT TRUST FACILITIES", Category.CLASS),
        Classification("6099", "FUNCTIONS RELATED TO DEPOSITORY BANKING, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("61", "NONDEPOSITORY CREDIT INSTITUTIONS", Category.DIVISION),
        Classification("611", "FEDERAL AND FEDERALLY-SPONSORED CREDIT AGENCIES", Category.GROUP),
        Classification("6111", "FEDERAL AND FEDERALLY-SPONSORED CREDIT AGENCIES", Category.CLASS),
        Classification("614", "PERSONAL CREDIT INSTITUTIONS", Category.GROUP),
        Classification("6141", "PERSONAL CREDIT INSTITUTIONS", Category.CLASS),
        Classification("615", "BUSINESS CREDIT INSTITUTIONS", Category.GROUP),
        Classification("6153", "SHORT-TERM BUSINESS CREDIT INSTITUTIONS, EXCEPT AGRICULTURAL", Category.CLASS),
        Classification("6159", "MISCELLANEOUS BUSINESS CREDIT INSTITUTIONS", Category.CLASS),
        Classification("616", "MORTGAGE BANKERS AND BROKERS", Category.GROUP),
        Classification("6162", "MORTGAGE BANKERS AND LOAN CORRESPONDENTS", Category.CLASS),
        Classification("6163", "LOAN BROKERS", Category.CLASS),
        Classification("62", "SECURITY AND COMMODITY BROKERS, DEALERS, EXCHANGES, AND SERVICES", Category.DIVISION),
        Classification("621", "SECURITY BROKERS, DEALERS, AND FLOTATION COMPANIES", Category.GROUP),
        Classification("6211", "SECURITY BROKERS, DEALERS, AND FLOTATION COMPANIES", Category.CLASS),
        Classification("622", "COMMODITY CONTRACTS BROKERS AND DEALERS", Category.GROUP),
        Classification("6221", "COMMODITY CONTRACTS BROKERS AND DEALERS", Category.CLASS),
        Classification("623", "SECURITY AND COMMODITY EXCHANGES", Category.GROUP),
        Classification("6231", "SECURITY AND COMMODITY EXCHANGES", Category.CLASS),
        Classification("628", "SERVICES ALLIED WITH THE EXCHANGE OF SECURITIES OR COMMODITIES", Category.GROUP),
        Classification("6282", "INVESTMENT ADVICE", Category.CLASS),
        Classification("6289", "SERVICES ALLIED WITH THE EXCHANGE OF SECURITIES OR COMMODITIES, N", Category.CLASS),
        Classification("63", "INSURANCE CARRIERS", Category.DIVISION),
        Classification("631", "LIFE INSURANCE", Category.GROUP),
        Classification("6311", "LIFE INSURANCE", Category.CLASS),
        Classification("632", "ACCIDENT AND HEALTH INSURANCE AND MEDICAL SERVICE PLANS", Category.GROUP),
        Classification("6321", "ACCIDENT AND HEALTH INSURANCE", Category.CLASS),
        Classification("6324", "HOSPITAL AND MEDICAL SERVICE PLANS", Category.CLASS),
        Classification("633", "FIRE, MARINE, AND CASUALTY INSURANCE", Category.GROUP),
        Classification("6331", "FIRE, MARINE, AND CASUALTY INSURANCE", Category.CLASS),
        Classification("635", "SURETY INSURANCE", Category.GROUP),
        Classification("6351", "SURETY INSURANCE", Category.CLASS),
        Classification("636", "TITLE INSURANCE", Category.GROUP),
        Classification("6361", "TITLE INSURANCE", Category.CLASS),
        Classification("637", "PENSION, HEALTH, AND WELFARE FUNDS", Category.GROUP),
        Classification("6371", "PENSION, HEALTH, AND WELFARE FUNDS", Category.CLASS),
        Classification("639", "INSURANCE CARRIERS, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("6399", "INSURANCE CARRIERS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("64", "INSURANCE AGENTS, BROKERS, AND SERVICE", Category.DIVISION),
        Classification("641", "INSURANCE AGENTS, BROKERS, AND SERVICE", Category.GROUP),
        Classification("6411", "INSURANCE AGENTS, BROKERS, AND SERVICE", Category.CLASS),
        Classification("65", "REAL ESTATE", Category.DIVISION),
        Classification("651", "REAL ESTATE OPERATORS (EXCEPT DEVELOPERS) AND LESSORS", Category.GROUP),
        Classification("6512", "OPERATORS OF NONRESIDENTIAL BUILDINGS", Category.CLASS),
        Classification("6513", "OPERATORS OF APARTMENT BUILDINGS", Category.CLASS),
        Classification("6514", "OPERATORS OF DWELLINGS OTHER THAN APARTMENT BUILDINGS", Category.CLASS),
        Classification("6515", "OPERATORS OF RESIDENTIAL MOBILE HOME SITES", Category.CLASS),
        Classification("6517", "LESSORS OF RAILROAD PROPERTY", Category.CLASS),
        Classification("6519", "LESSORS OF REAL PROPERTY, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("653", "REAL ESTATE AGENTS AND MANAGERS", Category.GROUP),
        Classification("6531", "REAL ESTATE AGENTS AND MANAGERS", Category.CLASS),
        Classification("654", "TITLE ABSTRACT OFFICES", Category.GROUP),
        Classification("6541", "TITLE ABSTRACT OFFICES", Category.CLASS),
        Classification("655", "LAND SUBDIVIDERS AND DEVELOPERS", Category.GROUP),
        Classification("6552", "LAND SUBDIVIDERS AND DEVELOPERS, EXCEPT CEMETERIES", Category.CLASS),
        Classification("6553", "CEMETERY SUBDIVIDERS AND DEVELOPERS", Category.CLASS),
        Classification("67", "HOLDING AND OTHER INVESTMENT OFFICES", Category.DIVISION),
        Classification("671", "HOLDING OFFICES", Category.GROUP),
        Classification("6712", "OFFICES OF BANK HOLDING COMPANIES", Category.CLASS),
        Classification("6719", "OFFICES OF HOLDING COMPANIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("672", "INVESTMENT OFFICES", Category.GROUP),
        Classification("6722", "MANAGEMENT INVESTMENT OFFICES, OPEN-END", Category.CLASS),
        Classification("6726", "UNIT INVESTMENT TRUSTS, FACE-AMOUNT CERTIFICATE OFFICES, AND CLOS", Category.CLASS),
        Classification("673", "TRUSTS", Category.GROUP),
        Classification("6732", "EDUCATIONAL, RELIGIOUS, AND CHARITABLE TRUSTS", Category.CLASS),
        Classification("6733", "TRUSTS, EXCEPT EDUCATIONAL, RELIGIOUS, AND CHARITABLE", Category.CLASS),
        Classification("679", "MISCELLANEOUS INVESTING", Category.GROUP),
        Classification("6792", "OIL ROYALTY TRADERS", Category.CLASS),
        Classification("6794", "PATENT OWNERS AND LESSORS", Category.CLASS),
        Classification("6798", "REAL ESTATE INVESTMENT TRUSTS", Category.CLASS),
        Classification("6799", "INVESTORS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("I", "SERVICES", Category.SECTION),
        Classification("70", "HOTELS, ROOMING HOUSES, CAMPS, AND OTHER LODGING PLACES", Category.DIVISION),
        Classification("701", "HOTELS AND MOTELS", Category.GROUP),
        Classification("7011", "HOTELS AND MOTELS", Category.CLASS),
        Classification("702", "ROOMING AND BOARDING HOUSES", Category.GROUP),
        Classification("7021", "ROOMING AND BOARDING HOUSES", Category.CLASS),
        Classification("703", "CAMPS AND RECREATIONAL VEHICLE PARKS", Category.GROUP),
        Classification("7032", "SPORTING AND RECREATIONAL CAMPS", Category.CLASS),
        Classification("7033", "RECREATIONAL VEHICLE PARKS AND CAMPSITES", Category.CLASS),
        Classification("704", "ORGANIZATION HOTELS AND LODGING HOUSES, ON MEMBERSHIP BASIS", Category.GROUP),
        Classification("7041", "ORGANIZATION HOTELS AND LODGING HOUSES, ON MEMBERSHIP BASIS", Category.CLASS),
        Classification("72", "PERSONAL SERVICES", Category.DIVISION),
        Classification("721", "LAUNDRY, CLEANING, AND GARMENT SERVICES", Category.GROUP),
        Classification("7211", "POWER LAUNDRIES, FAMILY AND COMMERCIAL", Category.CLASS),
        Classification("7212", "GARMENT PRESSING, AND AGENTS FOR LAUNDRIES AND DRYCLEANERS", Category.CLASS),
        Classification("7213", "LINEN SUPPLY", Category.CLASS),
        Classification("7215", "COIN-OPERATED LAUNDRIES AND DRYCLEANING", Category.CLASS),
        Classification("7216", "DRYCLEANING PLANTS, EXCEPT RUG CLEANING", Category.CLASS),
        Classification("7217", "CARPET AND UPHOLSTERY CLEANING", Category.CLASS),
        Classification("7218", "INDUSTRIAL LAUNDERERS", Category.CLASS),
        Classification("7219", "LAUNDRY AND GARMENT SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("722", "PHOTOGRAPHIC STUDIOS, PORTRAIT", Category.GROUP),
        Classification("7221", "PHOTOGRAPHIC STUDIOS, PORTRAIT", Category.CLASS),
        Classification("723", "BEAUTY SHOPS", Category.GROUP),
        Classification("7231", "BEAUTY SHOPS", Category.CLASS),
        Classification("724", "BARBER SHOPS", Category.GROUP),
        Classification("7241", "BARBER SHOPS", Category.CLASS),
        Classification("725", "SHOE REPAIR SHOPS AND SHOESHINE PARLORS", Category.GROUP),
        Classification("7251", "SHOE REPAIR SHOPS AND SHOESHINE PARLORS", Category.CLASS),
        Classification("726", "FUNERAL SERVICE AND CREMATORIES", Category.GROUP),
        Classification("7261", "FUNERAL SERVICE AND CREMATORIES", Category.CLASS),
        Classification("729", "MISCELLANEOUS PERSONAL SERVICES", Category.GROUP),
        Classification("7291", "TAX RETURN PREPARATION SERVICES", Category.CLASS),
        Classification("7299", "MISCELLANEOUS PERSONAL SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("73", "BUSINESS SERVICES", Category.DIVISION),
        Classification("731", "ADVERTISING", Category.GROUP),
        Classification("7311", "ADVERTISING AGENCIES", Category.CLASS),
        Classification("7312", "OUTDOOR ADVERTISING SERVICES", Category.CLASS),
        Classification("7313", "RADIO, TELEVISION, AND PUBLISHERS' ADVERTISING REPRESENTATIVES", Category.CLASS),
        Classification("7319", "ADVERTISING, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("732", "CONSUMER CREDIT REPORTING AGENCIES, MERCANTILE REPORTING AGENCIES", Category.GROUP),
        Classification("7322", "ADJUSTMENT AND COLLECTION SERVICES", Category.CLASS),
        Classification("7323", "CREDIT REPORTING SERVICES", Category.CLASS),
        Classification("733", "MAILING, REPRODUCTION, COMMERCIAL ART AND PHOTOGRAPHY, AND STENOGR", Category.GROUP),
        Classification("7331", "DIRECT MAIL ADVERTISING SERVICES", Category.CLASS),
        Classification("7334", "PHOTOCOPYING AND DUPLICATING SERVICES", Category.CLASS),
        Classification("7335", "COMMERCIAL PHOTOGRAPHY", Category.CLASS),
        Classification("7336", "COMMERCIAL ART AND GRAPHIC DESIGN", Category.CLASS),
        Classification("7338", "SECRETARIAL AND COURT REPORTING SERVICES", Category.CLASS),
        Classification("734", "SERVICES TO DWELLINGS AND OTHER BUILDINGS", Category.GROUP),
        Classification("7342", "DISINFECTING AND PEST CONTROL SERVICES", Category.CLASS),
        Classification("7349", "BUILDING CLEANING AND MAINTENANCE SERVICES, NOT ELSEWHERE CLASSIF", Category.CLASS),
        Classification("735", "MISCELLANEOUS EQUIPMENT RENTAL AND LEASING", Category.GROUP),
        Classification("7352", "MEDICAL EQUIPMENT RENTAL AND LEASING", Category.CLASS),
        Classification("7353", "HEAVY CONSTRUCTION EQUIPMENT RENTAL AND LEASING", Category.CLASS),
        Classification("7359", "EQUIPMENT RENTAL AND LEASING, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("736", "PERSONNEL SUPPLY SERVICES", Category.GROUP),
        Classification("7361", "EMPLOYMENT AGENCIES", Category.CLASS),
        Classification("7363", "HELP SUPPLY SERVICES", Category.CLASS),
        Classification("737", "COMPUTER PROGRAMMING, DATA PROCESSING, AND OTHER COMPUTER RELATED", Category.GROUP),
        Classification("7371", "COMPUTER PROGRAMMING SERVICES", Category.CLASS),
        Classification("7372", "PREPACKAGED SOFTWARE", Category.CLASS),
        Classification("7373", "COMPUTER INTEGRATED SYSTEMS DESIGN", Category.CLASS),
        Classification("7374", "COMPUTER PROCESSING AND DATA PREPARATION AND PROCESSING SERVICES", Category.CLASS),
        Classification("7375", "INFORMATION RETRIEVAL SERVICES", Category.CLASS),
        Classification("7376", "COMPUTER FACILITIES MANAGEMENT SERVICES", Category.CLASS),
        Classification("7377", "COMPUTER RENTAL AND LEASING", Category.CLASS),
        Classification("7378", "COMPUTER MAINTENANCE AND REPAIR", Category.CLASS),
        Classification("7379", "COMPUTER RELATED SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("738", "MISCELLANEOUS BUSINESS SERVICES", Category.GROUP),
        Classification("7381", "DETECTIVE, GUARD, AND ARMORED CAR SERVICES", Category.CLASS),
        Classification("7382", "SECURITY SYSTEMS SERVICES", Category.CLASS),
        Classification("7383", "NEWS SYNDICATES", Category.CLASS),
        Classification("7384", "PHOTOFINISHING LABORATORIES", Category.CLASS),
        Classification("7389", "BUSINESS SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("75", "AUTOMOTIVE REPAIR, SERVICES, AND PARKING", Category.DIVISION),
        Classification("751", "AUTOMOTIVE RENTAL AND LEASING, WITHOUT DRIVERS", Category.GROUP),
        Classification("7513", "TRUCK RENTAL AND LEASING, WITHOUT DRIVERS", Category.CLASS),
        Classification("7514", "PASSENGER CAR RENTAL", Category.CLASS),
        Classification("7515", "PASSENGER CAR LEASING", Category.CLASS),
        Classification("7519", "UTILITY TRAILER AND RECREATIONAL VEHICLE RENTAL", Category.CLASS),
        Classification("752", "AUTOMOBILE PARKING", Category.GROUP),
        Classification("7521", "AUTOMOBILE PARKING", Category.CLASS),
        Classification("753", "AUTOMOTIVE REPAIR SHOPS", Category.GROUP),
        Classification("7532", "TOP, BODY, AND UPHOLSTERY REPAIR SHOPS AND PAINT SHOPS", Category.CLASS),
        Classification("7533", "AUTOMOTIVE EXHAUST SYSTEM REPAIR SHOPS", Category.CLASS),
        Classification("7534", "TIRE RETREADING AND REPAIR SHOPS", Category.CLASS),
        Classification("7536", "AUTOMOTIVE GLASS REPLACEMENT SHOPS", Category.CLASS),
        Classification("7537", "AUTOMOTIVE TRANSMISSION REPAIR SHOPS", Category.CLASS),
        Classification("7538", "GENERAL AUTOMOTIVE REPAIR SHOPS", Category.CLASS),
        Classification("7539", "AUTOMOTIVE REPAIR SHOPS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("754", "AUTOMOTIVE SERVICES, EXCEPT REPAIR", Category.GROUP),
        Classification("7542", "CARWASHES", Category.CLASS),
        Classification("7549", "AUTOMOTIVE SERVICES, EXCEPT REPAIR AND CARWASHES", Category.CLASS),
        Classification("76", "MISCELLANEOUS REPAIR SERVICES", Category.DIVISION),
        Classification("762", "ELECTRICAL REPAIR SHOPS", Category.GROUP),
        Classification("7622", "RADIO AND TELEVISION REPAIR SHOPS", Category.CLASS),
        Classification("7623", "REFRIGERATION AND AIR-CONDITIONING SERVICE AND REPAIR SHOPS", Category.CLASS),
        Classification("7629", "ELECTRICAL AND ELECTRONIC REPAIR SHOPS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("763", "WATCH, CLOCK, AND JEWELRY REPAIR", Category.GROUP),
        Classification("7631", "WATCH, CLOCK, AND JEWELRY REPAIR", Category.CLASS),
        Classification("764", "REUPHOLSTERY AND FURNITURE REPAIR", Category.GROUP),
        Classification("7641", "REUPHOLSTERY AND FURNITURE REPAIR", Category.CLASS),
        Classification("769", "MISCELLANEOUS REPAIR SHOPS AND RELATED SERVICES", Category.GROUP),
        Classification("7692", "WELDING REPAIR", Category.CLASS),
        Classification("7694", "ARMATURE REWINDING SHOPS", Category.CLASS),
        Classification("7699", "REPAIR SHOPS AND RELATED SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("78", "MOTION PICTURES", Category.DIVISION),
        Classification("781", "MOTION PICTURE PRODUCTION AND ALLIED SERVICES", Category.GROUP),
        Classification("7812", "MOTION PICTURE AND VIDEO TAPE PRODUCTION", Category.CLASS),
        Classification("7819", "SERVICES ALLIED TO MOTION PICTURE PRODUCTION", Category.CLASS),
        Classification("782", "MOTION PICTURE DISTRIBUTION AND ALLIED SERVICES", Category.GROUP),
        Classification("7822", "MOTION PICTURE AND VIDEO TAPE DISTRIBUTION", Category.CLASS),
        Classification("7829", "SERVICES ALLIED TO MOTION PICTURE DISTRIBUTION", Category.CLASS),
        Classification("783", "MOTION PICTURE THEATERS", Category.GROUP),
        Classification("7832", "MOTION PICTURE THEATERS, EXCEPT DRIVE-IN", Category.CLASS),
        Classification("7833", "DRIVE-IN MOTION PICTURE THEATERS", Category.CLASS),
        Classification("784", "VIDEO TAPE RENTAL", Category.GROUP),
        Classification("7841", "VIDEO TAPE RENTAL", Category.CLASS),
        Classification("79", "AMUSEMENT AND RECREATION SERVICES", Category.DIVISION),
        Classification("791", "DANCE STUDIOS, SCHOOLS, AND HALLS", Category.GROUP),
        Classification("7911", "DANCE STUDIOS, SCHOOLS, AND HALLS", Category.CLASS),
        Classification("792", "THEATRICAL PRODUCERS (EXCEPT MOTION PICTURE), BANDS, ORCHESTRAS, A", Category.GROUP),
        Classification("7922", "THEATRICAL PRODUCERS (EXCEPT MOTION PICTURE) AND MISCELLANEOUS TH", Category.CLASS),
        Classification("7929", "BANDS, ORCHESTRAS, ACTORS, AND OTHER ENTERTAINERS AND ENTERTAINME", Category.CLASS),
        Classification("793", "BOWLING CENTERS", Category.GROUP),
        Classification("7933", "BOWLING CENTERS", Category.CLASS),
        Classification("794", "COMMERCIAL SPORTS", Category.GROUP),
        Classification("7941", "PROFESSIONAL SPORTS CLUBS AND PROMOTERS", Category.CLASS),
        Classification("7948", "RACING, INCLUDING TRACK OPERATION", Category.CLASS),
        Classification("799", "MISCELLANEOUS AMUSEMENT AND RECREATION SERVICES", Category.GROUP),
        Classification("7991", "PHYSICAL FITNESS FACILITIES", Category.CLASS),
        Classification("7992", "PUBLIC GOLF COURSES", Category.CLASS),
        Classification("7993", "COIN-OPERATED AMUSEMENT DEVICES", Category.CLASS),
        Classification("7996", "AMUSEMENT PARKS", Category.CLASS),
        Classification("7997", "MEMBERSHIP SPORTS AND RECREATION CLUBS", Category.CLASS),
        Classification("7999", "AMUSEMENT AND RECREATION SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("80", "HEALTH SERVICES", Category.DIVISION),
        Classification("801", "OFFICES AND CLINICS OF DOCTORS OF MEDICINE", Category.GROUP),
        Classification("8011", "OFFICES AND CLINICS OF DOCTORS OF MEDICINE", Category.CLASS),
        Classification("802", "OFFICES AND CLINICS OF DENTISTS", Category.GROUP),
        Classification("8021", "OFFICES AND CLINICS OF DENTISTS", Category.CLASS),
        Classification("803", "OFFICES AND CLINICS OF DOCTORS OF OSTEOPATHY", Category.GROUP),
        Classification("8031", "OFFICES AND CLINICS OF DOCTORS OF OSTEOPATHY", Category.CLASS),
        Classification("804", "OFFICES AND CLINICS OF OTHER HEALTH PRACTITIONERS", Category.GROUP),
        Classification("8041", "OFFICES AND CLINICS OF CHIROPRACTORS", Category.CLASS),
        Classification("8042", "OFFICES AND CLINICS OF OPTOMETRISTS", Category.CLASS),
        Classification("8043", "OFFICES AND CLINICS OF PODIATRISTS", Category.CLASS),
        Classification("8049", "OFFICES AND CLINICS OF HEALTH PRACTITIONERS, NOT ELSEWHERE CLASSI", Category.CLASS),
        Classification("805", "NURSING AND PERSONAL CARE FACILITIES", Category.GROUP),
        Classification("8051", "SKILLED NURSING CARE FACILITIES", Category.CLASS),
        Classification("8052", "INTERMEDIATE CARE FACILITIES", Category.CLASS),
        Classification("8059", "NURSING AND PERSONAL CARE FACILITIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("806", "HOSPITALS", Category.GROUP),
        Classification("8062", "GENERAL MEDICAL AND SURGICAL HOSPITALS", Category.CLASS),
        Classification("8063", "PSYCHIATRIC HOSPITALS", Category.CLASS),
        Classification("8069", "SPECIALTY HOSPITALS, EXCEPT PSYCHIATRIC", Category.CLASS),
        Classification("807", "MEDICAL AND DENTAL LABORATORIES", Category.GROUP),
        Classification("8071", "MEDICAL LABORATORIES", Category.CLASS),
        Classification("8072", "DENTAL LABORATORIES", Category.CLASS),
        Classification("808", "HOME HEALTH CARE SERVICES", Category.GROUP),
        Classification("8082", "HOME HEALTH CARE SERVICES", Category.CLASS),
        Classification("809", "MISCELLANEOUS HEALTH AND ALLIED SERVICES, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("8092", "KIDNEY DIALYSIS CENTERS", Category.CLASS),
        Classification("8093", "SPECIALTY OUTPATIENT FACILITIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("8099", "HEALTH AND ALLIED SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("81", "LEGAL SERVICES", Category.DIVISION),
        Classification("811", "LEGAL SERVICES", Category.GROUP),
        Classification("8111", "LEGAL SERVICES", Category.CLASS),
        Classification("82", "EDUCATIONAL SERVICES", Category.DIVISION),
        Classification("821", "ELEMENTARY AND SECONDARY SCHOOLS", Category.GROUP),
        Classification("8211", "ELEMENTARY AND SECONDARY SCHOOLS", Category.CLASS),
        Classification("822", "COLLEGES, UNIVERSITIES, PROFESSIONAL SCHOOLS, AND JUNIOR COLLEGES", Category.GROUP),
        Classification("8221", "COLLEGES, UNIVERSITIES, AND PROFESSIONAL SCHOOLS", Category.CLASS),
        Classification("8222", "JUNIOR COLLEGES AND TECHNICAL INSTITUTES", Category.CLASS),
        Classification("823", "LIBRARIES", Category.GROUP),
        Classification("8231", "LIBRARIES", Category.CLASS),
        Classification("824", "VOCATIONAL SCHOOLS", Category.GROUP),
        Classification("8243", "DATA PROCESSING SCHOOLS", Category.CLASS),
        Classification("8244", "BUSINESS AND SECRETARIAL SCHOOLS", Category.CLASS),
        Classification("8249", "VOCATIONAL SCHOOLS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("829", "SCHOOLS AND EDUCATIONAL SERVICES, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("8299", "SCHOOLS AND EDUCATIONAL SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("83", "SOCIAL SERVICES", Category.DIVISION),
        Classification("832", "INDIVIDUAL AND FAMILY SOCIAL SERVICES", Category.GROUP),
        Classification("8322", "INDIVIDUAL AND FAMILY SOCIAL SERVICES", Category.CLASS),
        Classification("833", "JOB TRAINING AND VOCATIONAL REHABILITATION SERVICES", Category.GROUP),
        Classification("8331", "JOB TRAINING AND VOCATIONAL REHABILITATION SERVICES", Category.CLASS),
        Classification("835", "CHILD DAY CARE SERVICES", Category.GROUP),
        Classification("8351", "CHILD DAY CARE SERVICES", Category.CLASS),
        Classification("836", "RESIDENTIAL CARE", Category.GROUP),
        Classification("8361", "RESIDENTIAL CARE", Category.CLASS),
        Classification("839", "SOCIAL SERVICES, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("8399", "SOCIAL SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("84", "MUSEUMS, ART GALLERIES, AND BOTANICAL AND ZOOLOGICAL GARDENS", Category.DIVISION),
        Classification("841", "MUSEUMS AND ART GALLERIES", Category.GROUP),
        Classification("8412", "MUSEUMS AND ART GALLERIES", Category.CLASS),
        Classification("842", "ARBORETA AND BOTANICAL OR ZOOLOGICAL GARDENS", Category.GROUP),
        Classification("8422", "ARBORETA AND BOTANICAL OR ZOOLOGICAL GARDENS", Category.CLASS),
        Classification("86", "MEMBERSHIP ORGANIZATIONS", Category.DIVISION),
        Classification("861", "BUSINESS ASSOCIATIONS", Category.GROUP),
        Classification("8611", "BUSINESS ASSOCIATIONS", Category.CLASS),
        Classification("862", "PROFESSIONAL MEMBERSHIP ORGANIZATIONS", Category.GROUP),
        Classification("8621", "PROFESSIONAL MEMBERSHIP ORGANIZATIONS", Category.CLASS),
        Classification("863", "LABOR UNIONS AND SIMILAR LABOR ORGANIZATIONS", Category.GROUP),
        Classification("8631", "LABOR UNIONS AND SIMILAR LABOR ORGANIZATIONS", Category.CLASS),
        Classification("864", "CIVIC, SOCIAL, AND FRATERNAL ASSOCIATIONS", Category.GROUP),
        Classification("8641", "CIVIC, SOCIAL, AND FRATERNAL ASSOCIATIONS", Category.CLASS),
        Classification("865", "POLITICAL ORGANIZATIONS", Category.GROUP),
        Classification("8651", "POLITICAL ORGANIZATIONS", Category.CLASS),
        Classification("866", "RELIGIOUS ORGANIZATIONS", Category.GROUP),
        Classification("8661", "RELIGIOUS ORGANIZATIONS", Category.CLASS),
        Classification("869", "MEMBERSHIP ORGANIZATIONS, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("8699", "MEMBERSHIP ORGANIZATIONS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("87", "ENGINEERING, ACCOUNTING, RESEARCH, MANAGEMENT, AND RELATED SERVICES", Category.DIVISION),
        Classification("871", "ENGINEERING, ARCHITECTURAL, AND SURVEYING SERVICES", Category.GROUP),
        Classification("8711", "ENGINEERING SERVICES", Category.CLASS),
        Classification("8712", "ARCHITECTURAL SERVICES", Category.CLASS),
        Classification("8713", "SURVEYING SERVICES", Category.CLASS),
        Classification("872", "ACCOUNTING, AUDITING, AND BOOKKEEPING SERVICES", Category.GROUP),
        Classification("8721", "ACCOUNTING, AUDITING, AND BOOKKEEPING SERVICES", Category.CLASS),
        Classification("873", "RESEARCH, DEVELOPMENT, AND TESTING SERVICES", Category.GROUP),
        Classification("8731", "COMMERCIAL PHYSICAL AND BIOLOGICAL RESEARCH", Category.CLASS),
        Classification("8732", "COMMERCIAL ECONOMIC, SOCIOLOGICAL, AND EDUCATIONAL RESEARCH", Category.CLASS),
        Classification("8733", "NONCOMMERCIAL RESEARCH ORGANIZATIONS", Category.CLASS),
        Classification("8734", "TESTING LABORATORIES", Category.CLASS),
        Classification("874", "MANAGEMENT AND PUBLIC RELATIONS SERVICES", Category.GROUP),
        Classification("8741", "MANAGEMENT SERVICES", Category.CLASS),
        Classification("8742", "MANAGEMENT CONSULTING SERVICES", Category.CLASS),
        Classification("8743", "PUBLIC RELATIONS SERVICES", Category.CLASS),
        Classification("8744", "FACILITIES SUPPORT MANAGEMENT SERVICES", Category.CLASS),
        Classification("8748", "BUSINESS CONSULTING SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("88", "PRIVATE HOUSEHOLDS", Category.DIVISION),
        Classification("881", "PRIVATE HOUSEHOLDS", Category.GROUP),
        Classification("8811", "PRIVATE HOUSEHOLDS", Category.CLASS),
        Classification("89", "SERVICES, NOT ELSEWHERE CLASSIFIED", Category.DIVISION),
        Classification("899", "SERVICES, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("8999", "SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("J", "PUBLIC ADMINISTRATION", Category.SECTION),
        Classification("91", "EXECUTIVE, LEGISLATIVE, AND GENERAL GOVERNMENT, EXCEPT FINANCE", Category.DIVISION),
        Classification("911", "EXECUTIVE OFFICES", Category.GROUP),
        Classification("9111", "EXECUTIVE OFFICES", Category.CLASS),
        Classification("912", "LEGISLATIVE BODIES", Category.GROUP),
        Classification("9121", "LEGISLATIVE BODIES", Category.CLASS),
        Classification("913", "EXECUTIVE AND LEGISLATIVE OFFICES COMBINED", Category.GROUP),
        Classification("9131", "EXECUTIVE AND LEGISLATIVE OFFICES COMBINED", Category.CLASS),
        Classification("919", "GENERAL GOVERNMENT, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("9199", "GENERAL GOVERNMENT, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("92", "JUSTICE, PUBLIC ORDER, AND SAFETY", Category.DIVISION),
        Classification("921", "COURTS", Category.GROUP),
        Classification("9211", "COURTS", Category.CLASS),
        Classification("922", "PUBLIC ORDER AND SAFETY", Category.GROUP),
        Classification("9221", "POLICE PROTECTION", Category.CLASS),
        Classification("9222", "LEGAL COUNSEL AND PROSECUTION", Category.CLASS),
        Classification("9223", "CORRECTIONAL INSTITUTIONS", Category.CLASS),
        Classification("9224", "FIRE PROTECTION", Category.CLASS),
        Classification("9229", "PUBLIC ORDER AND SAFETY, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("93", "PUBLIC FINANCE, TAXATION, AND MONETARY POLICY", Category.DIVISION),
        Classification("931", "PUBLIC FINANCE, TAXATION, AND MONETARY POLICY", Category.GROUP),
        Classification("9311", "PUBLIC FINANCE, TAXATION, AND MONETARY POLICY", Category.CLASS),
        Classification("94", "ADMINISTRATION OF HUMAN RESOURCE PROGRAMS", Category.DIVISION),
        Classification("941", "ADMINISTRATION OF EDUCATIONAL PROGRAMS", Category.GROUP),
        Classification("9411", "ADMINISTRATION OF EDUCATIONAL PROGRAMS", Category.CLASS),
        Classification("943", "ADMINISTRATION OF PUBLIC HEALTH PROGRAMS", Category.GROUP),
        Classification("9431", "ADMINISTRATION OF PUBLIC HEALTH PROGRAMS", Category.CLASS),
        Classification("944", "ADMINISTRATION OF SOCIAL, HUMAN RESOURCE AND INCOME MAINTENANCE PR", Category.GROUP),
        Classification("9441", "ADMINISTRATION OF SOCIAL, HUMAN RESOURCE AND INCOME MAINTENANCE P", Category.CLASS),
        Classification("945", "ADMINISTRATION OF VETERANS' AFFAIRS, EXCEPT HEALTH AND INSURANCE", Category.GROUP),
        Classification("9451", "ADMINISTRATION OF VETERANS' AFFAIRS, EXCEPT HEALTH AND INSURANCE", Category.CLASS),
        Classification("95", "ADMINISTRATION OF ENVIRONMENTAL QUALITY AND HOUSING PROGRAMS", Category.DIVISION),
        Classification("951", "ADMINISTRATION OF ENVIRONMENTAL QUALITY PROGRAMS", Category.GROUP),
        Classification("9511", "AIR AND WATER RESOURCE AND SOLID WASTE MANAGEMENT", Category.CLASS),
        Classification("9512", "LAND, MINERAL, WILDLIFE, AND FOREST CONSERVATION", Category.CLASS),
        Classification("953", "ADMINISTRATION OF HOUSING AND URBAN DEVELOPMENT PROGRAMS", Category.GROUP),
        Classification("9531", "ADMINISTRATION OF HOUSING PROGRAMS", Category.CLASS),
        Classification("9532", "ADMINISTRATION OF URBAN PLANNING AND COMMUNITY AND RURAL DEVELOPM", Category.CLASS),
        Classification("96", "ADMINISTRATION OF ECONOMIC PROGRAMS", Category.DIVISION),
        Classification("961", "ADMINISTRATION OF GENERAL ECONOMIC PROGRAMS", Category.GROUP),
        Classification("9611", "ADMINISTRATION OF GENERAL ECONOMIC PROGRAMS", Category.CLASS),
        Classification("962", "REGULATION AND ADMINISTRATION OF TRANSPORTATION PROGRAMS", Category.GROUP),
        Classification("9621", "REGULATION AND ADMINISTRATION OF TRANSPORTATION PROGRAMS", Category.CLASS),
        Classification("963", "REGULATION AND ADMINISTRATION OF COMMUNICATIONS, ELECTRIC, GAS, AN", Category.GROUP),
        Classification("9631", "REGULATION AND ADMINISTRATION OF COMMUNICATIONS, ELECTRIC, GAS, A", Category.CLASS),
        Classification("964", "REGULATION OF AGRICULTURAL MARKETING AND COMMODITIES", Category.GROUP),
        Classification("9641", "REGULATION OF AGRICULTURAL MARKETING AND COMMODITIES", Category.CLASS),
        Classification("965", "REGULATION, LICENSING, AND INSPECTION OF MISCELLANEOUS COMMERCIAL", Category.GROUP),
        Classification("9651", "REGULATION, LICENSING, AND INSPECTION OF MISCELLANEOUS COMMERCIAL", Category.CLASS),
        Classification("966", "SPACE RESEARCH AND TECHNOLOGY", Category.GROUP),
        Classification("9661", "SPACE RESEARCH AND TECHNOLOGY", Category.CLASS),
        Classification("97", "NATIONAL SECURITY AND INTERNATIONAL AFFAIRS", Category.DIVISION),
        Classification("971", "NATIONAL SECURITY", Category.GROUP),
        Classification("9711", "NATIONAL SECURITY", Category.CLASS),
        Classification("972", "INTERNATIONAL AFFAIRS", Category.GROUP),
        Classification("9721", "INTERNATIONAL AFFAIRS", Category.CLASS),
        Classification("K", "NONCLASSIFIABLE ESTABLISHMENTS", Category.SECTION),
        Classification("99", "NONCLASSIFIABLE ESTABLISHMENTS", Category.DIVISION),
        Classification("999", "NONCLASSIFIABLE ESTABLISHMENTS", Category.GROUP),
        Classification("9999", "NONCLASSIFIABLE ESTABLISHMENTS", Category.CLASS),
        Classification("A", "AGRICULTURE, FORESTRY, AND FISHING", Category.SECTION),
        Classification("01", "AGRICULTURAL PRODUCTION-CROPS", Category.DIVISION),
        Classification("011", "CASH GRAINS", Category.GROUP),
        Classification("0111", "WHEAT", Category.CLASS),
        Classification("0112", "RICE", Category.CLASS),
        Classification("0115", "CORN", Category.CLASS),
        Classification("0116", "SOYBEANS", Category.CLASS),
        Classification("0119", "CASH GRAINS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("013", "FIELD CROPS, EXCEPT CASH GRAINS", Category.GROUP),
        Classification("0131", "COTTON", Category.CLASS),
        Classification("0132", "TOBACCO", Category.CLASS),
        Classification("0133", "SUGARCANE AND SUGAR BEETS", Category.CLASS),
        Classification("0134", "IRISH POTATOES", Category.CLASS),
        Classification("0139", "FIELD CROPS, EXCEPT CASH GRAINS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("016", "VEGETABLES AND MELONS", Category.GROUP),
        Classification("0161", "VEGETABLES AND MELONS", Category.CLASS),
        Classification("017", "FRUITS AND TREE NUTS", Category.GROUP),
        Classification("0171", "BERRY CROPS", Category.CLASS),
        Classification("0172", "GRAPES", Category.CLASS),
        Classification("0173", "TREE NUTS", Category.CLASS),
        Classification("0174", "CITRUS FRUITS", Category.CLASS),
        Classification("0175", "DECIDUOUS TREE FRUITS", Category.CLASS),
        Classification("0179", "FRUITS AND TREE NUTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("018", "HORTICULTURAL SPECIALTIES", Category.GROUP),
        Classification("0181", "ORNAMENTAL FLORICULTURE AND NURSERY PRODUCTS", Category.CLASS),
        Classification("0182", "FOOD CROPS GROWN UNDER COVER", Category.CLASS),
        Classification("019", "GENERAL FARMS, PRIMARILY CROP", Category.GROUP),
        Classification("0191", "GENERAL FARMS, PRIMARILY CROP", Category.CLASS),
        Classification("02", "AGRICULTURAL PRODUCTION-LIVESTOCK AND ANIMAL SPECIALTIES", Category.DIVISION),
        Classification("021", "LIVESTOCK, EXCEPT DAIRY AND POULTRY", Category.GROUP),
        Classification("0211", "BEEF CATTLE FEEDLOTS", Category.CLASS),
        Classification("0212", "BEEF CATTLE, EXCEPT FEEDLOTS", Category.CLASS),
        Classification("0213", "HOGS", Category.CLASS),
        Classification("0214", "SHEEP AND GOATS", Category.CLASS),
        Classification("0219", "GENERAL LIVESTOCK, EXCEPT DAIRY AND POULTRY", Category.CLASS),
        Classification("024", "DAIRY FARMS", Category.GROUP),
        Classification("0241", "DAIRY FARMS", Category.CLASS),
        Classification("025", "POULTRY AND EGGS", Category.GROUP),
        Classification("0251", "BROILER, FRYER, AND ROASTER CHICKENS", Category.CLASS),
        Classification("0252", "CHICKEN EGGS", Category.CLASS),
        Classification("0253", "TURKEYS AND TURKEY EGGS", Category.CLASS),
        Classification("0254", "POULTRY HATCHERIES", Category.CLASS),
        Classification("0259", "POULTRY AND EGGS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("027", "ANIMAL SPECIALTIES", Category.GROUP),
        Classification("0271", "FUR-BEARING ANIMALS AND RABBITS", Category.CLASS),
        Classification("0272", "HORSES AND OTHER EQUINES", Category.CLASS),
        Classification("0273", "ANIMAL AQUACULTURE", Category.CLASS),
        Classification("0279", "ANIMAL SPECIALTIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("029", "GENERAL FARMS, PRIMARILY LIVESTOCK AND ANIMAL SPECIALTIES", Category.GROUP),
        Classification("0291", "GENERAL FARMS, PRIMARILY LIVESTOCK AND ANIMAL SPECIALTIES", Category.CLASS),
        Classification("07", "AGRICULTURAL SERVICES", Category.DIVISION),
        Classification("071", "SOIL PREPARATION SERVICES", Category.GROUP),
        Classification("0711", "SOIL PREPARATION SERVICES", Category.CLASS),
        Classification("072", "CROP SERVICES", Category.GROUP),
        Classification("0721", "CROP PLANTING, CULTIVATING, AND PROTECTING", Category.CLASS),
        Classification("0722", "CROP HARVESTING, PRIMARILY BY MACHINE", Category.CLASS),
        Classification("0723", "CROP PREPARATION SERVICES FOR MARKET, EXCEPT COTTON GINNING", Category.CLASS),
        Classification("0724", "COTTON GINNING", Category.CLASS),
        Classification("074", "VETERINARY SERVICES", Category.GROUP),
        Classification("0741", "VETERINARY SERVICES FOR LIVESTOCK", Category.CLASS),
        Classification("0742", "VETERINARY SERVICES FOR ANIMAL SPECIALTIES", Category.CLASS),
        Classification("075", "ANIMAL SERVICES, EXCEPT VETERINARY", Category.GROUP),
        Classification("0751", "LIVESTOCK SERVICES, EXCEPT VETERINARY", Category.CLASS),
        Classification("0752", "ANIMAL SPECIALTY SERVICES, EXCEPT VETERINARY", Category.CLASS),
        Classification("076", "FARM LABOR AND MANAGEMENT SERVICES", Category.GROUP),
        Classification("0761", "FARM LABOR CONTRACTORS AND CREW LEADERS", Category.CLASS),
        Classification("0762", "FARM MANAGEMENT SERVICES", Category.CLASS),
        Classification("078", "LANDSCAPE AND HORTICULTURAL SERVICES", Category.GROUP),
        Classification("0781", "LANDSCAPE COUNSELING AND PLANNING", Category.CLASS),
        Classification("0782", "LAWN AND GARDEN SERVICES", Category.CLASS),
        Classification("0783", "ORNAMENTAL SHRUB AND TREE SERVICES", Category.CLASS),
        Classification("08", "FORESTRY", Category.DIVISION),
        Classification("081", "TIMBER TRACTS", Category.GROUP),
        Classification("0811", "TIMBER TRACTS", Category.CLASS),
        Classification("083", "FOREST NURSERIES AND GATHERING OF FOREST PRODUCTS", Category.GROUP),
        Classification("0831", "FOREST NURSERIES AND GATHERING OF FOREST PRODUCTS", Category.CLASS),
        Classification("085", "FORESTRY SERVICES", Category.GROUP),
        Classification("0851", "FORESTRY SERVICES", Category.CLASS),
        Classification("09", "FISHING, HUNTING, AND TRAPPING", Category.DIVISION),
        Classification("091", "COMMERCIAL FISHING", Category.GROUP),
        Classification("0912", "FINFISH", Category.CLASS),
        Classification("0913", "SHELLFISH", Category.CLASS),
        Classification("0919", "MISCELLANEOUS MARINE PRODUCTS", Category.CLASS),
        Classification("092", "FISH HATCHERIES AND PRESERVES", Category.GROUP),
        Classification("0921", "FISH HATCHERIES AND PRESERVES", Category.CLASS),
        Classification("097", "HUNTING AND TRAPPING, AND GAME PROPAGATION", Category.GROUP),
        Classification("0971", "HUNTING AND TRAPPING, AND GAME PROPAGATION", Category.CLASS),
        Classification("B", "MINING", Category.SECTION),
        Classification("10", "METAL MINING", Category.DIVISION),
        Classification("101", "IRON ORES", Category.GROUP),
        Classification("1011", "IRON ORES", Category.CLASS),
        Classification("102", "COPPER ORES", Category.GROUP),
        Classification("1021", "COPPER ORES", Category.CLASS),
        Classification("103", "LEAD AND ZINC ORES", Category.GROUP),
        Classification("1031", "LEAD AND ZINC ORES", Category.CLASS),
        Classification("104", "GOLD AND SILVER ORES", Category.GROUP),
        Classification("1041", "GOLD ORES", Category.CLASS),
        Classification("1044", "SILVER ORES", Category.CLASS),
        Classification("106", "FERROALLOY ORES, EXCEPT VANADIUM", Category.GROUP),
        Classification("1061", "FERROALLOY ORES, EXCEPT VANADIUM", Category.CLASS),
        Classification("108", "METAL MINING SERVICES", Category.GROUP),
        Classification("1081", "METAL MINING SERVICES", Category.CLASS),
        Classification("109", "MISCELLANEOUS METAL ORES", Category.GROUP),
        Classification("1094", "URANIUM-RADIUM-VANADIUM ORES", Category.CLASS),
        Classification("1099", "MISCELLANEOUS METAL ORES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("12", "COAL MINING", Category.DIVISION),
        Classification("122", "BITUMINOUS COAL AND LIGNITE MINING", Category.GROUP),
        Classification("1221", "BITUMINOUS COAL AND LIGNITE SURFACE MINING", Category.CLASS),
        Classification("1222", "BITUMINOUS COAL UNDERGROUND MINING", Category.CLASS),
        Classification("123", "ANTHRACITE MINING", Category.GROUP),
        Classification("1231", "ANTHRACITE MINING", Category.CLASS),
        Classification("124", "COAL MINING SERVICES", Category.GROUP),
        Classification("1241", "COAL MINING SERVICES", Category.CLASS),
        Classification("13", "OIL AND GAS EXTRACTION", Category.DIVISION),
        Classification("131", "CRUDE PETROLEUM AND NATURAL GAS", Category.GROUP),
        Classification("1311", "CRUDE PETROLEUM AND NATURAL GAS", Category.CLASS),
        Classification("132", "NATURAL GAS LIQUIDS", Category.GROUP),
        Classification("1321", "NATURAL GAS LIQUIDS", Category.CLASS),
        Classification("138", "OIL AND GAS FIELD SERVICES", Category.GROUP),
        Classification("1381", "DRILLING OIL AND GAS WELLS", Category.CLASS),
        Classification("1382", "OIL AND GAS FIELD EXPLORATION SERVICES", Category.CLASS),
        Classification("1389", "OIL AND GAS FIELD SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("14", "MINING AND QUARRYING OF NONMETALLIC MINERALS, EXCEPT FUELS", Category.DIVISION),
        Classification("141", "DIMENSION STONE", Category.GROUP),
        Classification("1411", "DIMENSION STONE", Category.CLASS),
        Classification("142", "CRUSHED AND BROKEN STONE, INCLUDING RIPRAP", Category.GROUP),
        Classification("1422", "CRUSHED AND BROKEN LIMESTONE", Category.CLASS),
        Classification("1423", "CRUSHED AND BROKEN GRANITE", Category.CLASS),
        Classification("1429", "CRUSHED AND BROKEN STONE, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("144", "SAND AND GRAVEL", Category.GROUP),
        Classification("1442", "CONSTRUCTION SAND AND GRAVEL", Category.CLASS),
        Classification("1446", "INDUSTRIAL SAND", Category.CLASS),
        Classification("145", "CLAY, CERAMIC, AND REFRACTORY MINERALS", Category.GROUP),
        Classification("1455", "KAOLIN AND BALL CLAY", Category.CLASS),
        Classification("1459", "CLAY, CERAMIC, AND REFRACTORY MINERALS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("147", "CHEMICAL AND FERTILIZER MINERAL MINING", Category.GROUP),
        Classification("1474", "POTASH, SODA, AND BORATE MINERALS", Category.CLASS),
        Classification("1475", "PHOSPHATE ROCK", Category.CLASS),
        Classification("1479", "CHEMICAL AND FERTILIZER MINERAL MINING, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("148", "NONMETALLIC MINERALS SERVICES, EXCEPT FUELS", Category.GROUP),
        Classification("1481", "NONMETALLIC MINERALS SERVICES, EXCEPT FUELS", Category.CLASS),
        Classification("149", "MISCELLANEOUS NONMETALLIC MINERALS, EXCEPT FUELS", Category.GROUP),
        Classification("1499", "MISCELLANEOUS NONMETALLIC MINERALS, EXCEPT FUELS", Category.CLASS),
        Classification("C", "CONSTRUCTION", Category.SECTION),
        Classification("15", "BUILDING CONSTRUCTION-GENERAL CONTRACTORS AND OPERATIVE BUILDERS", Category.DIVISION),
        Classification("152", "GENERAL BUILDING CONTRACTORS-RESIDENTIAL BUILDINGS", Category.GROUP),
        Classification("1521", "GENERAL CONTRACTORS-SINGLE-FAMILY HOUSES", Category.CLASS),
        Classification("1522", "GENERAL CONTRACTORS-RESIDENTIAL BUILDINGS, OTHER THAN SINGLE-FAMI", Category.CLASS),
        Classification("153", "OPERATIVE BUILDERS", Category.GROUP),
        Classification("1531", "OPERATIVE BUILDERS", Category.CLASS),
        Classification("154", "GENERAL BUILDING CONTRACTORS-NONRESIDENTIAL BUILDINGS", Category.GROUP),
        Classification("1541", "GENERAL CONTRACTORS-INDUSTRIAL BUILDINGS AND WAREHOUSES", Category.CLASS),
        Classification("1542", "GENERAL CONTRACTORS-NONRESIDENTIAL BUILDINGS, OTHER THAN INDUSTRI", Category.CLASS),
        Classification("16", "HEAVY CONSTRUCTION OTHER THAN BUILDING CONSTRUCTION-CONTRACTORS", Category.DIVISION),
        Classification("161", "HIGHWAY AND STREET CONSTRUCTION, EXCEPT ELEVATED HIGHWAYS", Category.GROUP),
        Classification("1611", "HIGHWAY AND STREET CONSTRUCTION, EXCEPT ELEVATED HIGHWAYS", Category.CLASS),
        Classification("162", "HEAVY CONSTRUCTION, EXCEPT HIGHWAY AND STREET CONSTRUCTION", Category.GROUP),
        Classification("1622", "BRIDGE, TUNNEL, AND ELEVATED HIGHWAY CONSTRUCTION", Category.CLASS),
        Classification("1623", "WATER, SEWER, PIPELINE, AND COMMUNICATIONS AND POWER LINE CONSTRU", Category.CLASS),
        Classification("1629", "HEAVY CONSTRUCTION, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("17", "CONSTRUCTION-SPECIAL TRADE CONTRACTORS", Category.DIVISION),
        Classification("171", "PLUMBING, HEATING AND AIR-CONDITIONING", Category.GROUP),
        Classification("1711", "PLUMBING, HEATING AND AIR-CONDITIONING", Category.CLASS),
        Classification("172", "PAINTING AND PAPER HANGING", Category.GROUP),
        Classification("1721", "PAINTING AND PAPER HANGING", Category.CLASS),
        Classification("173", "ELECTRICAL WORK", Category.GROUP),
        Classification("1731", "ELECTRICAL WORK", Category.CLASS),
        Classification("174", "MASONRY, STONEWORK, TILE SETTING, AND PLASTERING", Category.GROUP),
        Classification("1741", "MASONRY, STONE SETTING, AND OTHER STONE WORK", Category.CLASS),
        Classification("1742", "PLASTERING, DRYWALL, ACOUSTICAL, AND INSULATION WORK", Category.CLASS),
        Classification("1743", "TERRAZZO, TILE, MARBLE, AND MOSAIC WORK", Category.CLASS),
        Classification("175", "CARPENTRY AND FLOOR WORK", Category.GROUP),
        Classification("1751", "CARPENTRY WORK", Category.CLASS),
        Classification("1752", "FLOOR LAYING AND OTHER FLOOR WORK, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("176", "ROOFING, SIDING, AND SHEET METAL WORK", Category.GROUP),
        Classification("1761", "ROOFING, SIDING, AND SHEET METAL WORK", Category.CLASS),
        Classification("177", "CONCRETE WORK", Category.GROUP),
        Classification("1771", "CONCRETE WORK", Category.CLASS),
        Classification("178", "WATER WELL DRILLING", Category.GROUP),
        Classification("1781", "WATER WELL DRILLING", Category.CLASS),
        Classification("179", "MISCELLANEOUS SPECIAL TRADE CONTRACTORS", Category.GROUP),
        Classification("1791", "STRUCTURAL STEEL ERECTION", Category.CLASS),
        Classification("1793", "GLASS AND GLAZING WORK", Category.CLASS),
        Classification("1793", "GLASS INSTALLATION, EXCEPT AUTOMOTIVE-CONTRACTORS", Category.CLASS),
        Classification("1794", "EXCAVATION WORK", Category.CLASS),
        Classification("1795", "WRECKING AND DEMOLITION WORK", Category.CLASS),
        Classification("1796", "INSTALLATION OR ERECTION OF BUILDING EQUIPMENT, NOT ELSEWHERE CLA", Category.CLASS),
        Classification("1799", "SPECIAL TRADE CONTRACTORS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("D", "MANUFACTURING", Category.SECTION),
        Classification("20", "FOOD AND KINDRED PRODUCTS", Category.DIVISION),
        Classification("201", "MEAT PRODUCTS", Category.GROUP),
        Classification("2011", "MEAT PACKING PLANTS", Category.CLASS),
        Classification("2013", "SAUSAGES AND OTHER PREPARED MEAT PRODUCTS", Category.CLASS),
        Classification("2015", "POULTRY SLAUGHTERING AND PROCESSING", Category.CLASS),
        Classification("202", "DAIRY PRODUCTS", Category.GROUP),
        Classification("2021", "CREAMERY BUTTER", Category.CLASS),
        Classification("2022", "NATURAL, PROCESSED, AND IMITATION CHEESE", Category.CLASS),
        Classification("2023", "DRY, CONDENSED, AND EVAPORATED DAIRY PRODUCTS", Category.CLASS),
        Classification("2024", "ICE CREAM AND FROZEN DESSERTS", Category.CLASS),
        Classification("2026", "FLUID MILK", Category.CLASS),
        Classification("203", "CANNED, FROZEN, AND PRESERVED FRUITS, VEGETABLES, AND FOOD SPECIAL", Category.GROUP),
        Classification("2032", "CANNED SPECIALTIES", Category.CLASS),
        Classification("2033", "CANNED FRUITS, VEGETABLES, PRESERVES, JAMS, AND JELLIES", Category.CLASS),
        Classification("2034", "DRIED AND DEHYDRATED FRUITS, VEGETABLES, AND SOUP MIXES", Category.CLASS),
        Classification("2035", "PICKLED FRUITS AND VEGETABLES, VEGETABLE SAUCES AND SEASONINGS, A", Category.CLASS),
        Classification("2037", "FROZEN FRUITS, FRUIT JUICES, AND VEGETABLES", Category.CLASS),
        Classification("2038", "FROZEN SPECIALTIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("204", "GRAIN MILL PRODUCTS", Category.GROUP),
        Classification("2041", "FLOUR AND OTHER GRAIN MILL PRODUCTS", Category.CLASS),
        Classification("2043", "CEREAL BREAKFAST FOODS", Category.CLASS),
        Classification("2044", "RICE MILLING", Category.CLASS),
        Classification("2045", "PREPARED FLOUR MIXES AND DOUGHS", Category.CLASS),
        Classification("2046", "WET CORN MILLING", Category.CLASS),
        Classification("2047", "DOG AND CAT FOOD", Category.CLASS),
        Classification("2048", "PREPARED FEEDS AND FEED INGREDIENTS FOR ANIMALS AND FOWLS, EXCEPT", Category.CLASS),
        Classification("205", "BAKERY PRODUCTS", Category.GROUP),
        Classification("2051", "BREAD AND OTHER BAKERY PRODUCTS, EXCEPT COOKIES AND CRACKERS", Category.CLASS),
        Classification("2052", "COOKIES AND CRACKERS", Category.CLASS),
        Classification("2053", "FROZEN BAKERY PRODUCTS, EXCEPT BREAD", Category.CLASS),
        Classification("206", "SUGAR AND CONFECTIONERY PRODUCTS", Category.GROUP),
        Classification("2061", "CANE SUGAR, EXCEPT REFINING", Category.CLASS),
        Classification("2062", "CANE SUGAR REFINING", Category.CLASS),
        Classification("2063", "BEET SUGAR", Category.CLASS),
        Classification("2064", "CANDY AND OTHER CONFECTIONERY PRODUCTS", Category.CLASS),
        Classification("2066", "CHOCOLATE AND COCOA PRODUCTS", Category.CLASS),
        Classification("2067", "CHEWING GUM", Category.CLASS),
        Classification("2068", "SALTED AND ROASTED NUTS AND SEEDS", Category.CLASS),
        Classification("207", "FATS AND OILS", Category.GROUP),
        Classification("2074", "COTTONSEED OIL MILLS", Category.CLASS),
        Classification("2075", "SOYBEAN OIL MILLS", Category.CLASS),
        Classification("2076", "VEGETABLE OIL MILLS, EXCEPT CORN, COTTONSEED, AND SOYBEAN", Category.CLASS),
        Classification("2077", "ANIMAL AND MARINE FATS AND OILS", Category.CLASS),
        Classification("2079", "SHORTENING, TABLE OILS, MARGARINE, AND OTHER EDIBLE FATS AND OILS", Category.CLASS),
        Classification("208", "BEVERAGES", Category.GROUP),
        Classification("2082", "MALT BEVERAGES", Category.CLASS),
        Classification("2083", "MALT", Category.CLASS),
        Classification("2084", "WINES, BRANDY, AND BRANDY SPIRITS", Category.CLASS),
        Classification("2085", "DISTILLED AND BLENDED LIQUORS", Category.CLASS),
        Classification("2086", "BOTTLED AND CANNED SOFT DRINKS AND CARBONATED WATERS", Category.CLASS),
        Classification("2087", "FLAVORING EXTRACTS AND FLAVORING SYRUPS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("209", "MISCELLANEOUS FOOD PREPARATIONS AND KINDRED PRODUCTS", Category.GROUP),
        Classification("2091", "CANNED AND CURED FISH AND SEAFOODS", Category.CLASS),
        Classification("2092", "PREPARED FRESH OR FROZEN FISH AND SEAFOODS", Category.CLASS),
        Classification("2095", "ROASTED COFFEE", Category.CLASS),
        Classification("2096", "POTATO CHIPS, CORN CHIPS, AND SIMILAR SNACKS", Category.CLASS),
        Classification("2097", "MANUFACTURED ICE", Category.CLASS),
        Classification("2098", "MACARONI, SPAGHETTI, VERMICELLI, AND NOODLES", Category.CLASS),
        Classification("2099", "FOOD PREPARATIONS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("21", "TOBACCO PRODUCTS", Category.DIVISION),
        Classification("211", "CIGARETTES", Category.GROUP),
        Classification("2111", "CIGARETTES", Category.CLASS),
        Classification("212", "CIGARS", Category.GROUP),
        Classification("2121", "CIGARS", Category.CLASS),
        Classification("213", "CHEWING AND SMOKING TOBACCO AND SNUFF", Category.GROUP),
        Classification("2131", "CHEWING AND SMOKING TOBACCO AND SNUFF", Category.CLASS),
        Classification("214", "TOBACCO STEMMING AND REDRYING", Category.GROUP),
        Classification("2141", "TOBACCO STEMMING AND REDRYING", Category.CLASS),
        Classification("22", "TEXTILE MILL PRODUCTS", Category.DIVISION),
        Classification("221", "BROADWOVEN FABRIC MILLS, COTTON", Category.GROUP),
        Classification("2211", "BROADWOVEN FABRIC MILLS, COTTON", Category.CLASS),
        Classification("222", "BROADWOVEN FABRIC MILLS, MANMADE FIBER AND SILK", Category.GROUP),
        Classification("2221", "BROADWOVEN FABRIC MILLS, MANMADE FIBER AND SILK", Category.CLASS),
        Classification("223", "BROADWOVEN FABRIC MILLS, WOOL (INCLUDING DYEING AND FINISHING)", Category.GROUP),
        Classification("2231", "BROADWOVEN FABRIC MILLS, WOOL (INCLUDING DYEING AND FINISHING)", Category.CLASS),
        Classification("224", "NARROW FABRIC AND OTHER SMALLWARES MILLS: COTTON, WOOL, SILK, AND", Category.GROUP),
        Classification("2241", "NARROW FABRIC AND OTHER SMALLWARES MILLS: COTTON, WOOL, SILK, AND", Category.CLASS),
        Classification("225", "KNITTING MILLS", Category.GROUP),
        Classification("2251", "WOMEN'S FULL-LENGTH AND KNEE-LENGTH HOSIERY, EXCEPT SOCKS", Category.CLASS),
        Classification("2252", "HOSIERY, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("2253", "KNIT OUTERWEAR MILLS", Category.CLASS),
        Classification("2254", "KNIT UNDERWEAR AND NIGHTWEAR MILLS", Category.CLASS),
        Classification("2257", "WEFT KNIT FABRIC MILLS", Category.CLASS),
        Classification("2258", "LACE AND WARP KNIT FABRIC MILLS", Category.CLASS),
        Classification("2259", "KNITTING MILLS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("226", "DYEING AND FINISHING TEXTILES, EXCEPT WOOL FABRICS AND KNIT GOODS", Category.GROUP),
        Classification("2261", "FINISHERS OF BROADWOVEN FABRICS OF COTTON", Category.CLASS),
        Classification("2262", "FINISHERS OF BROADWOVEN FABRICS OF MANMADE FIBER AND SILK", Category.CLASS),
        Classification("2269", "FINISHERS OF TEXTILES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("227", "CARPETS AND RUGS", Category.GROUP),
        Classification("2273", "CARPETS AND RUGS", Category.CLASS),
        Classification("228", "YARN AND THREAD MILLS", Category.GROUP),
        Classification("2281", "YARN SPINNING MILLS", Category.CLASS),
        Classification("2282", "YARN TEXTURIZING, THROWING, TWISTING, AND WINDING MILLS", Category.CLASS),
        Classification("2282", "ACETATE FILAMENT YARN: THROWING, TWISTING, WINDING, OR SPOOLING", Category.CLASS),
        Classification("2284", "THREAD MILLS", Category.CLASS),
        Classification("229", "MISCELLANEOUS TEXTILE GOODS", Category.GROUP),
        Classification("2295", "COATED FABRICS, NOT RUBBERIZED", Category.CLASS),
        Classification("2296", "TIRE CORD AND FABRICS", Category.CLASS),
        Classification("2297", "NONWOVEN FABRICS", Category.CLASS),
        Classification("2298", "CORDAGE AND TWINE", Category.CLASS),
        Classification("2299", "TEXTILE GOODS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification(
            "23", "APPAREL AND OTHER FINISHED PRODUCTS MADE FROM FABRICS AND SIMILAR MATERIAL", Category.DIVISION
        ),
        Classification("231", "MEN'S AND BOYS' SUITS, COATS, AND OVERCOATS", Category.GROUP),
        Classification("2311", "MEN'S AND BOYS' SUITS, COATS, AND OVERCOATS", Category.CLASS),
        Classification("232", "MEN'S AND BOYS' FURNISHINGS, WORK CLOTHING, AND ALLIED GARMENTS", Category.GROUP),
        Classification("2321", "MEN'S AND BOYS' SHIRTS, EXCEPT WORK SHIRTS", Category.CLASS),
        Classification("2322", "MEN'S AND BOYS' UNDERWEAR AND NIGHTWEAR", Category.CLASS),
        Classification("2323", "MEN'S AND BOYS' NECKWEAR", Category.CLASS),
        Classification("2325", "MEN'S AND BOYS' SEPARATE TROUSERS AND SLACKS", Category.CLASS),
        Classification("2326", "MEN'S AND BOYS' WORK CLOTHING", Category.CLASS),
        Classification("2329", "MEN'S AND BOYS' CLOTHING, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("233", "WOMEN'S, MISSES', AND JUNIORS' OUTERWEAR", Category.GROUP),
        Classification("2331", "WOMEN'S, MISSES', AND JUNIORS' BLOUSES AND SHIRTS", Category.CLASS),
        Classification("2335", "WOMEN'S, MISSES', AND JUNIORS' DRESSES", Category.CLASS),
        Classification("2337", "WOMEN'S, MISSES', AND JUNIORS' SUITS, SKIRTS, AND COATS", Category.CLASS),
        Classification("2339", "WOMEN'S, MISSES', AND JUNIORS' OUTERWEAR, NOT ELSEWHERE CLASSIFIE", Category.CLASS),
        Classification("234", "WOMEN'S, MISSES', CHILDREN'S, AND INFANTS' UNDERGARMENTS", Category.GROUP),
        Classification("2341", "WOMEN'S, MISSES', CHILDREN'S, AND INFANTS' UNDERWEAR AND NIGHTWEA", Category.CLASS),
        Classification("2342", "BRASSIERES, GIRDLES, AND ALLIED GARMENTS", Category.CLASS),
        Classification("235", "HATS, CAPS, AND MILLINERY", Category.GROUP),
        Classification("2353", "HATS, CAPS, AND MILLINERY", Category.CLASS),
        Classification("236", "GIRLS', CHILDREN'S, AND INFANTS' OUTERWEAR", Category.GROUP),
        Classification("2361", "GIRLS', CHILDREN'S, AND INFANTS' DRESSES, BLOUSES, AND SHIRTS", Category.CLASS),
        Classification("2369", "GIRLS', CHILDREN'S, AND INFANTS' OUTERWEAR, NOT ELSEWHERE CLASSIF", Category.CLASS),
        Classification("237", "FUR GOODS", Category.GROUP),
        Classification("2371", "FUR GOODS", Category.CLASS),
        Classification("238", "MISCELLANEOUS APPAREL AND ACCESSORIES", Category.GROUP),
        Classification("2381", "DRESS AND WORK GLOVES, EXCEPT KNIT AND ALL-LEATHER", Category.CLASS),
        Classification("2384", "ROBES AND DRESSING GOWNS", Category.CLASS),
        Classification("2385", "WATERPROOF OUTERWEAR", Category.CLASS),
        Classification("2386", "LEATHER AND SHEEP-LINED CLOTHING", Category.CLASS),
        Classification("2387", "APPAREL BELTS", Category.CLASS),
        Classification("2389", "APPAREL AND ACCESSORIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("239", "MISCELLANEOUS FABRICATED TEXTILE PRODUCTS", Category.GROUP),
        Classification("2391", "CURTAINS AND DRAPERIES", Category.CLASS),
        Classification("2392", "HOUSEFURNISHINGS, EXCEPT CURTAINS AND DRAPERIES", Category.CLASS),
        Classification("2393", "TEXTILE BAGS", Category.CLASS),
        Classification("2394", "CANVAS AND RELATED PRODUCTS", Category.CLASS),
        Classification("2395", "PLEATING, DECORATIVE AND NOVELTY STITCHING, AND TUCKING FOR THE T", Category.CLASS),
        Classification("2396", "AUTOMOTIVE TRIMMINGS, APPAREL FINDINGS, AND RELATED PRODUCTS", Category.CLASS),
        Classification("2397", "SCHIFFLI MACHINE EMBROIDERIES", Category.CLASS),
        Classification("2399", "FABRICATED TEXTILE PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("24", "LUMBER AND WOOD PRODUCTS, EXCEPT FURNITURE", Category.DIVISION),
        Classification("241", "LOGGING", Category.GROUP),
        Classification("2411", "LOGGING", Category.CLASS),
        Classification("242", "SAWMILLS AND PLANING MILLS", Category.GROUP),
        Classification("2421", "SAWMILLS AND PLANING MILLS, GENERAL", Category.CLASS),
        Classification("2426", "HARDWOOD DIMENSION AND FLOORING MILLS", Category.CLASS),
        Classification("2429", "SPECIAL PRODUCT SAWMILLS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("243", "MILLWORK, VENEER, PLYWOOD, AND STRUCTURAL WOOD MEMBERS", Category.GROUP),
        Classification("2431", "MILLWORK", Category.CLASS),
        Classification("2434", "WOOD KITCHEN CABINETS", Category.CLASS),
        Classification("2435", "HARDWOOD VENEER AND PLYWOOD", Category.CLASS),
        Classification("2436", "SOFTWOOD VENEER AND PLYWOOD", Category.CLASS),
        Classification("2439", "STRUCTURAL WOOD MEMBERS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("244", "WOOD CONTAINERS", Category.GROUP),
        Classification("2441", "NAILED AND LOCK CORNER WOOD BOXES AND SHOOK", Category.CLASS),
        Classification("2448", "WOOD PALLETS AND SKIDS", Category.CLASS),
        Classification("2449", "WOOD CONTAINERS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("245", "WOOD BUILDINGS AND MOBILE HOMES", Category.GROUP),
        Classification("2451", "MOBILE HOMES", Category.CLASS),
        Classification("2452", "PREFABRICATED WOOD BUILDINGS AND COMPONENTS", Category.CLASS),
        Classification("249", "MISCELLANEOUS WOOD PRODUCTS", Category.GROUP),
        Classification("2491", "WOOD PRESERVING", Category.CLASS),
        Classification("2493", "RECONSTITUTED WOOD PRODUCTS", Category.CLASS),
        Classification("2499", "WOOD PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("25", "FURNITURE AND FIXTURES", Category.DIVISION),
        Classification("251", "HOUSEHOLD FURNITURE", Category.GROUP),
        Classification("2511", "WOOD HOUSEHOLD FURNITURE, EXCEPT UPHOLSTERED", Category.CLASS),
        Classification("2512", "WOOD HOUSEHOLD FURNITURE, UPHOLSTERED", Category.CLASS),
        Classification("2514", "METAL HOUSEHOLD FURNITURE", Category.CLASS),
        Classification("2515", "MATTRESSES, FOUNDATIONS, AND CONVERTIBLE BEDS", Category.CLASS),
        Classification("2517", "WOOD TELEVISION, RADIO, PHONOGRAPH, AND SEWING MACHINE CABINETS", Category.CLASS),
        Classification("2519", "HOUSEHOLD FURNITURE, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("252", "OFFICE FURNITURE", Category.GROUP),
        Classification("2521", "WOOD OFFICE FURNITURE", Category.CLASS),
        Classification("2522", "OFFICE FURNITURE, EXCEPT WOOD", Category.CLASS),
        Classification("253", "PUBLIC BUILDING AND RELATED FURNITURE", Category.GROUP),
        Classification("2531", "PUBLIC BUILDING AND RELATED FURNITURE", Category.CLASS),
        Classification("254", "PARTITIONS, SHELVING, LOCKERS, AND OFFICE AND STORE FIXTURES", Category.GROUP),
        Classification("2541", "WOOD OFFICE AND STORE FIXTURES, PARTITIONS, SHELVING, AND LOCKERS", Category.CLASS),
        Classification("2542", "OFFICE AND STORE FIXTURES, PARTITIONS, SHELVING, AND LOCKERS, EXC", Category.CLASS),
        Classification("259", "MISCELLANEOUS FURNITURE AND FIXTURES", Category.GROUP),
        Classification("2591", "DRAPERY HARDWARE AND WINDOW BLINDS AND SHADES", Category.CLASS),
        Classification("2599", "FURNITURE AND FIXTURES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("26", "PAPER AND ALLIED PRODUCTS", Category.DIVISION),
        Classification("261", "PULP MILLS", Category.GROUP),
        Classification("2611", "PULP MILLS", Category.CLASS),
        Classification("262", "PAPER MILLS", Category.GROUP),
        Classification("2621", "PAPER MILLS", Category.CLASS),
        Classification("263", "PAPERBOARD MILLS", Category.GROUP),
        Classification("2631", "PAPERBOARD MILLS", Category.CLASS),
        Classification("265", "PAPERBOARD CONTAINERS AND BOXES", Category.GROUP),
        Classification("2652", "SETUP PAPERBOARD BOXES", Category.CLASS),
        Classification("2653", "CORRUGATED AND SOLID FIBER BOXES", Category.CLASS),
        Classification("2655", "FIBER CANS, TUBES, DRUMS, AND SIMILAR PRODUCTS", Category.CLASS),
        Classification("2656", "SANITARY FOOD CONTAINERS, EXCEPT FOLDING", Category.CLASS),
        Classification("2657", "FOLDING PAPERBOARD BOXES, INCLUDING SANITARY", Category.CLASS),
        Classification("267", "CONVERTED PAPER AND PAPERBOARD PRODUCTS, EXCEPT CONTAINERS AND BOX", Category.GROUP),
        Classification("2671", "PACKAGING PAPER AND PLASTICS FILM, COATED AND LAMINATED", Category.CLASS),
        Classification("2672", "COATED AND LAMINATED PAPER, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("2673", "PLASTICS, FOIL, AND COATED PAPER BAGS", Category.CLASS),
        Classification("2674", "UNCOATED PAPER AND MULTIWALL BAGS", Category.CLASS),
        Classification("2675", "DIE-CUT PAPER AND PAPERBOARD AND CARDBOARD", Category.CLASS),
        Classification("2676", "SANITARY PAPER PRODUCTS", Category.CLASS),
        Classification("2677", "ENVELOPES", Category.CLASS),
        Classification("2678", "STATIONERY, TABLETS, AND RELATED PRODUCTS", Category.CLASS),
        Classification("2679", "CONVERTED PAPER AND PAPERBOARD PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("27", "PRINTING, PUBLISHING, AND ALLIED INDUSTRIES", Category.DIVISION),
        Classification("271", "NEWSPAPERS: PUBLISHING, OR PUBLISHING AND PRINTING", Category.GROUP),
        Classification("2711", "NEWSPAPERS: PUBLISHING, OR PUBLISHING AND PRINTING", Category.CLASS),
        Classification("272", "PERIODICALS: PUBLISHING, OR PUBLISHING AND PRINTING", Category.GROUP),
        Classification("2721", "PERIODICALS: PUBLISHING, OR PUBLISHING AND PRINTING", Category.CLASS),
        Classification("273", "BOOKS", Category.GROUP),
        Classification("2731", "BOOKS: PUBLISHING, OR PUBLISHING AND PRINTING", Category.CLASS),
        Classification("2732", "BOOK PRINTING", Category.CLASS),
        Classification("274", "MISCELLANEOUS PUBLISHING", Category.GROUP),
        Classification("2741", "MISCELLANEOUS PUBLISHING", Category.CLASS),
        Classification("275", "COMMERCIAL PRINTING", Category.GROUP),
        Classification("2752", "COMMERCIAL PRINTING, LITHOGRAPHIC", Category.CLASS),
        Classification("2754", "COMMERCIAL PRINTING, GRAVURE", Category.CLASS),
        Classification("2759", "COMMERCIAL PRINTING, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("276", "MANIFOLD BUSINESS FORMS", Category.GROUP),
        Classification("2761", "MANIFOLD BUSINESS FORMS", Category.CLASS),
        Classification("277", "GREETING CARDS", Category.GROUP),
        Classification("2771", "GREETING CARDS", Category.CLASS),
        Classification("278", "BLANKBOOKS, LOOSELEAF BINDERS, AND BOOKBINDING AND RELATED WORK", Category.GROUP),
        Classification("2782", "BLANKBOOKS, LOOSELEAF BINDERS AND DEVICES", Category.CLASS),
        Classification("2789", "BOOKBINDING AND RELATED WORK", Category.CLASS),
        Classification("279", "SERVICE INDUSTRIES FOR THE PRINTING TRADE", Category.GROUP),
        Classification("2791", "TYPESETTING", Category.CLASS),
        Classification("2796", "PLATEMAKING AND RELATED SERVICES", Category.CLASS),
        Classification("28", "CHEMICALS AND ALLIED PRODUCTS", Category.DIVISION),
        Classification("281", "INDUSTRIAL INORGANIC CHEMICALS", Category.GROUP),
        Classification("2812", "ALKALIES AND CHLORINE", Category.CLASS),
        Classification("2813", "INDUSTRIAL GASES", Category.CLASS),
        Classification("2816", "INORGANIC PIGMENTS", Category.CLASS),
        Classification("2819", "INDUSTRIAL INORGANIC CHEMICALS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("282", "PLASTICS MATERIALS AND SYNTHETIC RESINS, SYNTHETIC RUBBER, CELLULO", Category.GROUP),
        Classification("2821", "PLASTICS MATERIALS, SYNTHETIC RESINS, AND NONVULCANIZABLE ELASTOM", Category.CLASS),
        Classification("2822", "SYNTHETIC RUBBER (VULCANIZABLE ELASTOMERS)", Category.CLASS),
        Classification("2823", "CELLULOSIC MANMADE FIBERS", Category.CLASS),
        Classification("2824", "MANMADE ORGANIC FIBERS, EXCEPT CELLULOSIC", Category.CLASS),
        Classification("283", "DRUGS", Category.GROUP),
        Classification("2833", "MEDICINAL CHEMICALS AND BOTANICAL PRODUCTS", Category.CLASS),
        Classification("2834", "PHARMACEUTICAL PREPARATIONS", Category.CLASS),
        Classification("2835", "IN VITRO AND IN VIVO DIAGNOSTIC SUBSTANCES", Category.CLASS),
        Classification("2836", "BIOLOGICAL PRODUCTS, EXCEPT DIAGNOSTIC SUBSTANCES", Category.CLASS),
        Classification("284", "SOAP, DETERGENTS, AND CLEANING PREPARATIONS; PERFUMES, COSMETICS", Category.GROUP),
        Classification("2841", "SOAP AND OTHER DETERGENTS, EXCEPT SPECIALTY CLEANERS", Category.CLASS),
        Classification("2842", "SPECIALTY CLEANING, POLISHING, AND SANITATION PREPARATIONS", Category.CLASS),
        Classification("2843", "SURFACE ACTIVE AGENTS, FINISHING AGENTS, SULFONATED OILS, AND ASS", Category.CLASS),
        Classification("2844", "PERFUMES, COSMETICS, AND OTHER TOILET PREPARATIONS", Category.CLASS),
        Classification("285", "PAINTS, VARNISHES, LACQUERS, ENAMELS, AND ALLIED PRODUCTS", Category.GROUP),
        Classification("2851", "PAINTS, VARNISHES, LACQUERS, ENAMELS, AND ALLIED PRODUCTS", Category.CLASS),
        Classification("286", "INDUSTRIAL ORGANIC CHEMICALS", Category.GROUP),
        Classification("2861", "GUM AND WOOD CHEMICALS", Category.CLASS),
        Classification("2865", "CYCLIC ORGANIC CRUDES AND INTERMEDIATES, AND ORGANIC DYES AND PIG", Category.CLASS),
        Classification("2869", "INDUSTRIAL ORGANIC CHEMICALS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("287", "AGRICULTURAL CHEMICALS", Category.GROUP),
        Classification("2873", "NITROGENOUS FERTILIZERS", Category.CLASS),
        Classification("2874", "PHOSPHATIC FERTILIZERS", Category.CLASS),
        Classification("2875", "FERTILIZERS, MIXING ONLY", Category.CLASS),
        Classification("2879", "PESTICIDES AND AGRICULTURAL CHEMICALS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("289", "MISCELLANEOUS CHEMICAL PRODUCTS", Category.GROUP),
        Classification("2891", "ADHESIVES AND SEALANTS", Category.CLASS),
        Classification("2892", "EXPLOSIVES", Category.CLASS),
        Classification("2893", "PRINTING INK", Category.CLASS),
        Classification("2895", "CARBON BLACK", Category.CLASS),
        Classification("2899", "CHEMICALS AND CHEMICAL PREPARATIONS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("29", "PETROLEUM REFINING AND RELATED INDUSTRIES", Category.DIVISION),
        Classification("291", "PETROLEUM REFINING", Category.GROUP),
        Classification("2911", "PETROLEUM REFINING", Category.CLASS),
        Classification("295", "ASPHALT PAVING AND ROOFING MATERIALS", Category.GROUP),
        Classification("2951", "ASPHALT PAVING MIXTURES AND BLOCKS", Category.CLASS),
        Classification("2952", "ASPHALT FELTS AND COATINGS", Category.CLASS),
        Classification("299", "MISCELLANEOUS PRODUCTS OF PETROLEUM AND COAL", Category.GROUP),
        Classification("2992", "LUBRICATING OILS AND GREASES", Category.CLASS),
        Classification("2999", "PRODUCTS OF PETROLEUM AND COAL, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("30", "RUBBER AND MISCELLANEOUS PLASTICS PRODUCTS", Category.DIVISION),
        Classification("301", "TIRES AND INNER TUBES", Category.GROUP),
        Classification("3011", "TIRES AND INNER TUBES", Category.CLASS),
        Classification("302", "RUBBER AND PLASTICS FOOTWEAR", Category.GROUP),
        Classification("3021", "RUBBER AND PLASTICS FOOTWEAR", Category.CLASS),
        Classification("305", "GASKETS, PACKING, AND SEALING DEVICES AND RUBBER AND PLASTICS HOSE", Category.GROUP),
        Classification("3052", "RUBBER AND PLASTICS HOSE AND BELTING", Category.CLASS),
        Classification("3053", "GASKETS, PACKING, AND SEALING DEVICES", Category.CLASS),
        Classification("306", "FABRICATED RUBBER PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("3061", "MOLDED, EXTRUDED, AND LATHE-CUT MECHANICAL RUBBER GOODS", Category.CLASS),
        Classification("3069", "FABRICATED RUBBER PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("308", "MISCELLANEOUS PLASTICS PRODUCTS", Category.GROUP),
        Classification("3081", "UNSUPPORTED PLASTICS FILM AND SHEET", Category.CLASS),
        Classification("3082", "UNSUPPORTED PLASTICS PROFILE SHAPES", Category.CLASS),
        Classification("3083", "LAMINATED PLASTICS PLATE, SHEET, AND PROFILE SHAPES", Category.CLASS),
        Classification("3084", "PLASTICS PIPE", Category.CLASS),
        Classification("3085", "PLASTICS BOTTLES", Category.CLASS),
        Classification("3086", "PLASTICS FOAM PRODUCTS", Category.CLASS),
        Classification("3087", "CUSTOM COMPOUNDING OF PURCHASED PLASTICS RESINS", Category.CLASS),
        Classification("3088", "PLASTICS PLUMBING FIXTURES", Category.CLASS),
        Classification("3089", "PLASTICS PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("31", "LEATHER AND LEATHER PRODUCTS", Category.DIVISION),
        Classification("311", "LEATHER TANNING AND FINISHING", Category.GROUP),
        Classification("3111", "LEATHER TANNING AND FINISHING", Category.CLASS),
        Classification("313", "BOOT AND SHOE CUT STOCK AND FINDINGS", Category.GROUP),
        Classification("3131", "BOOT AND SHOE CUT STOCK AND FINDINGS", Category.CLASS),
        Classification("314", "FOOTWEAR, EXCEPT RUBBER", Category.GROUP),
        Classification("3142", "HOUSE SLIPPERS", Category.CLASS),
        Classification("3143", "MEN'S FOOTWEAR, EXCEPT ATHLETIC", Category.CLASS),
        Classification("3144", "WOMEN'S FOOTWEAR, EXCEPT ATHLETIC", Category.CLASS),
        Classification("3149", "FOOTWEAR, EXCEPT RUBBER, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("315", "LEATHER GLOVES AND MITTENS", Category.GROUP),
        Classification("3151", "LEATHER GLOVES AND MITTENS", Category.CLASS),
        Classification("316", "LUGGAGE", Category.GROUP),
        Classification("3161", "LUGGAGE", Category.CLASS),
        Classification("317", "HANDBAGS AND OTHER PERSONAL LEATHER GOODS", Category.GROUP),
        Classification("3171", "WOMEN'S HANDBAGS AND PURSES", Category.CLASS),
        Classification("3172", "PERSONAL LEATHER GOODS, EXCEPT WOMEN'S HANDBAGS AND PURSES", Category.CLASS),
        Classification("319", "LEATHER GOODS, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("3199", "LEATHER GOODS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("32", "STONE, CLAY, GLASS, AND CONCRETE PRODUCTS", Category.DIVISION),
        Classification("321", "FLAT GLASS", Category.GROUP),
        Classification("3211", "FLAT GLASS", Category.CLASS),
        Classification("322", "GLASS AND GLASSWARE, PRESSED OR BLOWN", Category.GROUP),
        Classification("3221", "GLASS CONTAINERS", Category.CLASS),
        Classification("3229", "PRESSED AND BLOWN GLASS AND GLASSWARE, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("323", "GLASS PRODUCTS, MADE OF PURCHASED GLASS", Category.GROUP),
        Classification("3231", "GLASS PRODUCTS, MADE OF PURCHASED GLASS", Category.CLASS),
        Classification("324", "CEMENT, HYDRAULIC", Category.GROUP),
        Classification("3241", "CEMENT, HYDRAULIC", Category.CLASS),
        Classification("325", "STRUCTURAL CLAY PRODUCTS", Category.GROUP),
        Classification("3251", "BRICK AND STRUCTURAL CLAY TILE", Category.CLASS),
        Classification("3253", "CERAMIC WALL AND FLOOR TILE", Category.CLASS),
        Classification("3255", "CLAY REFRACTORIES", Category.CLASS),
        Classification("3259", "STRUCTURAL CLAY PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("326", "POTTERY AND RELATED PRODUCTS", Category.GROUP),
        Classification("3261", "VITREOUS CHINA PLUMBING FIXTURES AND CHINA AND EARTHENWARE FITTIN", Category.CLASS),
        Classification("3262", "VITREOUS CHINA TABLE AND KITCHEN ARTICLES", Category.CLASS),
        Classification("3263", "FINE EARTHENWARE (WHITEWARE) TABLE AND KITCHEN ARTICLES", Category.CLASS),
        Classification("3264", "PORCELAIN ELECTRICAL SUPPLIES", Category.CLASS),
        Classification("3269", "POTTERY PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("327", "CONCRETE, GYPSUM, AND PLASTER PRODUCTS", Category.GROUP),
        Classification("3271", "CONCRETE BLOCK AND BRICK", Category.CLASS),
        Classification("3272", "CONCRETE PRODUCTS, EXCEPT BLOCK AND BRICK", Category.CLASS),
        Classification("3273", "READY-MIXED CONCRETE", Category.CLASS),
        Classification("3274", "LIME", Category.CLASS),
        Classification("3275", "GYPSUM PRODUCTS", Category.CLASS),
        Classification("328", "CUT STONE AND STONE PRODUCTS", Category.GROUP),
        Classification("3281", "CUT STONE AND STONE PRODUCTS", Category.CLASS),
        Classification("329", "ABRASIVE, ASBESTOS, AND MISCELLANEOUS NONMETALLIC MINERAL PRODUCTS", Category.GROUP),
        Classification("3291", "ABRASIVE PRODUCTS", Category.CLASS),
        Classification("3292", "ASBESTOS PRODUCTS", Category.CLASS),
        Classification("3295", "MINERALS AND EARTHS, GROUND OR OTHERWISE TREATED", Category.CLASS),
        Classification("3296", "MINERAL WOOL", Category.CLASS),
        Classification("3297", "NONCLAY REFRACTORIES", Category.CLASS),
        Classification("3299", "NONMETALLIC MINERAL PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("33", "PRIMARY METAL INDUSTRIES", Category.DIVISION),
        Classification("331", "STEEL WORKS, BLAST FURNACES, AND ROLLING AND FINISHING MILLS", Category.GROUP),
        Classification("3312", "STEEL WORKS, BLAST FURNACES (INCLUDING COKE OVENS), AND ROLLING M", Category.CLASS),
        Classification("3313", "ELECTROMETALLURGICAL PRODUCTS, EXCEPT STEEL", Category.CLASS),
        Classification("3315", "STEEL WIREDRAWING AND STEEL NAILS AND SPIKES", Category.CLASS),
        Classification("3316", "COLD-ROLLED STEEL SHEET, STRIP, AND BARS", Category.CLASS),
        Classification("3317", "STEEL PIPE AND TUBES", Category.CLASS),
        Classification("332", "IRON AND STEEL FOUNDRIES", Category.GROUP),
        Classification("3321", "GRAY AND DUCTILE IRON FOUNDRIES", Category.CLASS),
        Classification("3322", "MALLEABLE IRON FOUNDRIES", Category.CLASS),
        Classification("3324", "STEEL INVESTMENT FOUNDRIES", Category.CLASS),
        Classification("3325", "STEEL FOUNDRIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("333", "PRIMARY SMELTING AND REFINING OF NONFERROUS METALS", Category.GROUP),
        Classification("3331", "PRIMARY SMELTING AND REFINING OF COPPER", Category.CLASS),
        Classification("3334", "PRIMARY PRODUCTION OF ALUMINUM", Category.CLASS),
        Classification("3339", "PRIMARY SMELTING AND REFINING OF NONFERROUS METALS, EXCEPT COPPER", Category.CLASS),
        Classification("334", "SECONDARY SMELTING AND REFINING OF NONFERROUS METALS", Category.GROUP),
        Classification("3341", "SECONDARY SMELTING AND REFINING OF NONFERROUS METALS", Category.CLASS),
        Classification("335", "ROLLING, DRAWING, AND EXTRUDING OF NONFERROUS METALS", Category.GROUP),
        Classification("3351", "ROLLING, DRAWING, AND EXTRUDING OF COPPER", Category.CLASS),
        Classification("3353", "ALUMINUM SHEET, PLATE, AND FOIL", Category.CLASS),
        Classification("3354", "ALUMINUM EXTRUDED PRODUCTS", Category.CLASS),
        Classification("3355", "ALUMINUM ROLLING AND DRAWING, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("3356", "ROLLING, DRAWING, AND EXTRUDING OF NONFERROUS METALS, EXCEPT COPP", Category.CLASS),
        Classification("3357", "DRAWING AND INSULATING OF NONFERROUS WIRE", Category.CLASS),
        Classification("336", "NONFERROUS FOUNDRIES (CASTINGS)", Category.GROUP),
        Classification("3363", "ALUMINUM DIE-CASTINGS", Category.CLASS),
        Classification("3364", "NONFERROUS DIE-CASTINGS, EXCEPT ALUMINUM", Category.CLASS),
        Classification("3365", "ALUMINUM FOUNDRIES", Category.CLASS),
        Classification("3366", "COPPER FOUNDRIES", Category.CLASS),
        Classification("3369", "NONFERROUS FOUNDRIES, EXCEPT ALUMINUM AND COPPER", Category.CLASS),
        Classification("339", "MISCELLANEOUS PRIMARY METAL PRODUCTS", Category.GROUP),
        Classification("3398", "METAL HEAT TREATING", Category.CLASS),
        Classification("3399", "PRIMARY METAL PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification(
            "34", "FABRICATED METAL PRODUCTS, EXCEPT MACHINERY AND TRANSPORTATION EQUIPMENT", Category.DIVISION
        ),
        Classification("341", "METAL CANS AND SHIPPING CONTAINERS", Category.GROUP),
        Classification("3411", "METAL CANS", Category.CLASS),
        Classification("3412", "METAL SHIPPING BARRELS, DRUMS, KEGS, AND PAILS", Category.CLASS),
        Classification("342", "CUTLERY, HANDTOOLS, AND GENERAL HARDWARE", Category.GROUP),
        Classification("3421", "CUTLERY", Category.CLASS),
        Classification("3423", "HAND AND EDGE TOOLS, EXCEPT MACHINE TOOLS AND HANDSAWS", Category.CLASS),
        Classification("3425", "SAW BLADES AND HANDSAWS", Category.CLASS),
        Classification("3429", "HARDWARE, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("343", "HEATING EQUIPMENT, EXCEPT ELECTRIC AND WARM AIR; AND PLUMBING FIXT", Category.GROUP),
        Classification("3431", "ENAMELED IRON AND METAL SANITARY WARE", Category.CLASS),
        Classification("3432", "PLUMBING FIXTURE FITTINGS AND TRIM", Category.CLASS),
        Classification("3433", "HEATING EQUIPMENT, EXCEPT ELECTRIC AND WARM AIR FURNACES", Category.CLASS),
        Classification("344", "FABRICATED STRUCTURAL METAL PRODUCTS", Category.GROUP),
        Classification("3441", "FABRICATED STRUCTURAL METAL", Category.CLASS),
        Classification("3442", "METAL DOORS, SASH, FRAMES, MOLDING, AND TRIM", Category.CLASS),
        Classification("3443", "FABRICATED PLATE WORK (BOILER SHOPS)", Category.CLASS),
        Classification("3444", "SHEET METALWORK", Category.CLASS),
        Classification("3446", "ARCHITECTURAL AND ORNAMENTAL METALWORK", Category.CLASS),
        Classification("3448", "PREFABRICATED METAL BUILDINGS AND COMPONENTS", Category.CLASS),
        Classification("3449", "MISCELLANEOUS STRUCTURAL METALWORK", Category.CLASS),
        Classification("345", "SCREW MACHINE PRODUCTS, AND BOLTS, NUTS, SCREWS, RIVETS, AND WASHE", Category.GROUP),
        Classification("3451", "SCREW MACHINE PRODUCTS", Category.CLASS),
        Classification("3452", "BOLTS, NUTS, SCREWS, RIVETS, AND WASHERS", Category.CLASS),
        Classification("346", "METAL FORGINGS AND STAMPINGS", Category.GROUP),
        Classification("3462", "IRON AND STEEL FORGINGS", Category.CLASS),
        Classification("3463", "NONFERROUS FORGINGS", Category.CLASS),
        Classification("3465", "AUTOMOTIVE STAMPINGS", Category.CLASS),
        Classification("3466", "CROWNS AND CLOSURES", Category.CLASS),
        Classification("3469", "METAL STAMPINGS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("347", "COATING, ENGRAVING, AND ALLIED SERVICES", Category.GROUP),
        Classification("3471", "ELECTROPLATING, PLATING, POLISHING, ANODIZING, AND COLORING", Category.CLASS),
        Classification("3479", "COATING, ENGRAVING, AND ALLIED SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("348", "ORDNANCE AND ACCESSORIES, EXCEPT VEHICLES AND GUIDED MISSILES", Category.GROUP),
        Classification("3482", "SMALL ARMS AMMUNITION", Category.CLASS),
        Classification("3483", "AMMUNITION, EXCEPT FOR SMALL ARMS", Category.CLASS),
        Classification("3484", "SMALL ARMS", Category.CLASS),
        Classification("3489", "ORDNANCE AND ACCESSORIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("349", "MISCELLANEOUS FABRICATED METAL PRODUCTS", Category.GROUP),
        Classification("3491", "INDUSTRIAL VALVES", Category.CLASS),
        Classification("3492", "FLUID POWER VALVES AND HOSE FITTINGS", Category.CLASS),
        Classification("3493", "STEEL SPRINGS, EXCEPT WIRE", Category.CLASS),
        Classification("3494", "VALVES AND PIPE FITTINGS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("3495", "WIRE SPRINGS", Category.CLASS),
        Classification("3496", "MISCELLANEOUS FABRICATED WIRE PRODUCTS", Category.CLASS),
        Classification("3497", "METAL FOIL AND LEAF", Category.CLASS),
        Classification("3498", "FABRICATED PIPE AND PIPE FITTINGS", Category.CLASS),
        Classification("3499", "FABRICATED METAL PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("35", "INDUSTRIAL AND COMMERCIAL MACHINERY AND COMPUTER EQUIPMENT", Category.DIVISION),
        Classification("351", "ENGINES AND TURBINES", Category.GROUP),
        Classification("3511", "STEAM, GAS, AND HYDRAULIC TURBINES, AND TURBINE GENERATOR SET UNI", Category.CLASS),
        Classification("3519", "INTERNAL COMBUSTION ENGINES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("352", "FARM AND GARDEN MACHINERY AND EQUIPMENT", Category.GROUP),
        Classification("3523", "FARM MACHINERY AND EQUIPMENT", Category.CLASS),
        Classification("3524", "LAWN AND GARDEN TRACTORS AND HOME LAWN AND GARDEN EQUIPMENT", Category.CLASS),
        Classification("3524", "BLOWERS, RESIDENTIAL LAWN", Category.CLASS),
        Classification("353", "CONSTRUCTION, MINING, AND MATERIALS HANDLING MACHINERY AND EQUIPME", Category.GROUP),
        Classification("3531", "CONSTRUCTION MACHINERY AND EQUIPMENT", Category.CLASS),
        Classification("3532", "MINING MACHINERY AND EQUIPMENT, EXCEPT OIL AND GAS FIELD MACHINER", Category.CLASS),
        Classification("3533", "OIL AND GAS FIELD MACHINERY AND EQUIPMENT", Category.CLASS),
        Classification("3534", "ELEVATORS AND MOVING STAIRWAYS", Category.CLASS),
        Classification("3535", "CONVEYORS AND CONVEYING EQUIPMENT", Category.CLASS),
        Classification("3536", "OVERHEAD TRAVELING CRANES, HOISTS, AND MONORAIL SYSTEMS", Category.CLASS),
        Classification("3537", "INDUSTRIAL TRUCKS, TRACTORS, TRAILERS, AND STACKERS", Category.CLASS),
        Classification("354", "METALWORKING MACHINERY AND EQUIPMENT", Category.GROUP),
        Classification("3541", "MACHINE TOOLS, METAL CUTTING TYPES", Category.CLASS),
        Classification("3542", "MACHINE TOOLS, METAL FORMING TYPES", Category.CLASS),
        Classification("3543", "INDUSTRIAL PATTERNS", Category.CLASS),
        Classification("3544", "SPECIAL DIES AND TOOLS, DIE SETS, JIGS AND FIXTURES, AND INDUSTRI", Category.CLASS),
        Classification("3545", "CUTTING TOOLS, MACHINE TOOL ACCESSORIES, AND MACHINISTS' PRECISIO", Category.CLASS),
        Classification("3546", "POWER-DRIVEN HANDTOOLS", Category.CLASS),
        Classification("3547", "ROLLING MILL MACHINERY AND EQUIPMENT", Category.CLASS),
        Classification("3548", "ELECTRIC AND GAS WELDING AND SOLDERING EQUIPMENT", Category.CLASS),
        Classification("3549", "METALWORKING MACHINERY, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("355", "SPECIAL INDUSTRY MACHINERY, EXCEPT METALWORKING MACHINERY", Category.GROUP),
        Classification("3552", "TEXTILE MACHINERY", Category.CLASS),
        Classification("3553", "WOODWORKING MACHINERY", Category.CLASS),
        Classification("3554", "PAPER INDUSTRIES MACHINERY", Category.CLASS),
        Classification("3555", "PRINTING TRADES MACHINERY AND EQUIPMENT", Category.CLASS),
        Classification("3556", "FOOD PRODUCTS MACHINERY", Category.CLASS),
        Classification("3559", "SPECIAL INDUSTRY MACHINERY, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("356", "GENERAL INDUSTRIAL MACHINERY AND EQUIPMENT", Category.GROUP),
        Classification("3561", "PUMPS AND PUMPING EQUIPMENT", Category.CLASS),
        Classification("3562", "BALL AND ROLLER BEARINGS", Category.CLASS),
        Classification("3563", "AIR AND GAS COMPRESSORS", Category.CLASS),
        Classification("3564", "INDUSTRIAL AND COMMERCIAL FANS AND BLOWERS AND AIR PURIFICATION E", Category.CLASS),
        Classification("3565", "PACKAGING MACHINERY", Category.CLASS),
        Classification("3566", "SPEED CHANGERS, INDUSTRIAL HIGH-SPEED DRIVES, AND GEARS", Category.CLASS),
        Classification("3567", "INDUSTRIAL PROCESS FURNACES AND OVENS", Category.CLASS),
        Classification("3568", "MECHANICAL POWER TRANSMISSION EQUIPMENT, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("3569", "GENERAL INDUSTRIAL MACHINERY AND EQUIPMENT, NOT ELSEWHERE CLASSIF", Category.CLASS),
        Classification("357", "COMPUTER AND OFFICE EQUIPMENT", Category.GROUP),
        Classification("3571", "ELECTRONIC COMPUTERS", Category.CLASS),
        Classification("3572", "COMPUTER STORAGE DEVICES", Category.CLASS),
        Classification("3575", "COMPUTER TERMINALS", Category.CLASS),
        Classification("3577", "COMPUTER PERIPHERAL EQUIPMENT, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("3578", "CALCULATING AND ACCOUNTING MACHINES, EXCEPT ELECTRONIC COMPUTERS", Category.CLASS),
        Classification("3579", "OFFICE MACHINES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("358", "REFRIGERATION AND SERVICE INDUSTRY MACHINERY", Category.GROUP),
        Classification("3581", "AUTOMATIC VENDING MACHINES", Category.CLASS),
        Classification("3582", "COMMERCIAL LAUNDRY, DRYCLEANING, AND PRESSING MACHINES", Category.CLASS),
        Classification("3585", "AIR-CONDITIONING AND WARM AIR HEATING EQUIPMENT AND COMMERCIAL AN", Category.CLASS),
        Classification("3586", "MEASURING AND DISPENSING PUMPS", Category.CLASS),
        Classification("3589", "SERVICE INDUSTRY MACHINERY, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("359", "MISCELLANEOUS INDUSTRIAL AND COMMERCIAL MACHINERY AND EQUIPMENT", Category.GROUP),
        Classification("3592", "CARBURETORS, PISTONS, PISTON RINGS, AND VALVES", Category.CLASS),
        Classification("3593", "FLUID POWER CYLINDERS AND ACTUATORS", Category.CLASS),
        Classification("3594", "FLUID POWER PUMPS AND MOTORS", Category.CLASS),
        Classification("3596", "SCALES AND BALANCES, EXCEPT LABORATORY", Category.CLASS),
        Classification("3599", "INDUSTRIAL AND COMMERCIAL MACHINERY AND EQUIPMENT, NOT ELSEWHERE", Category.CLASS),
        Classification(
            "36", "ELECTRONIC AND OTHER ELECTRICAL EQUIPMENT AND COMPONENTS, EXCEPT COMPUTER", Category.DIVISION
        ),
        Classification("361", "ELECTRIC TRANSMISSION AND DISTRIBUTION EQUIPMENT", Category.GROUP),
        Classification("3612", "POWER, DISTRIBUTION, AND SPECIALTY TRANSFORMERS", Category.CLASS),
        Classification("3613", "SWITCHGEAR AND SWITCHBOARD APPARATUS", Category.CLASS),
        Classification("362", "ELECTRICAL INDUSTRIAL APPARATUS", Category.GROUP),
        Classification("3621", "MOTORS AND GENERATORS", Category.CLASS),
        Classification("3624", "CARBON AND GRAPHITE PRODUCTS", Category.CLASS),
        Classification("3625", "RELAYS AND INDUSTRIAL CONTROLS", Category.CLASS),
        Classification("3629", "ELECTRICAL INDUSTRIAL APPARATUS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("363", "HOUSEHOLD APPLIANCES", Category.GROUP),
        Classification("3631", "HOUSEHOLD COOKING EQUIPMENT", Category.CLASS),
        Classification("3632", "HOUSEHOLD REFRIGERATORS AND HOME AND FARM FREEZERS", Category.CLASS),
        Classification("3633", "HOUSEHOLD LAUNDRY EQUIPMENT", Category.CLASS),
        Classification("3634", "ELECTRIC HOUSEWARES AND FANS", Category.CLASS),
        Classification("3635", "HOUSEHOLD VACUUM CLEANERS", Category.CLASS),
        Classification("3639", "HOUSEHOLD APPLIANCES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("364", "ELECTRIC LIGHTING AND WIRING EQUIPMENT", Category.GROUP),
        Classification("3641", "ELECTRIC LAMP BULBS AND TUBES", Category.CLASS),
        Classification("3643", "CURRENT-CARRYING WIRING DEVICES", Category.CLASS),
        Classification("3644", "NONCURRENT-CARRYING WIRING DEVICES", Category.CLASS),
        Classification("3645", "RESIDENTIAL ELECTRIC LIGHTING FIXTURES", Category.CLASS),
        Classification("3646", "COMMERCIAL, INDUSTRIAL, AND INSTITUTIONAL ELECTRIC LIGHTING FIXTU", Category.CLASS),
        Classification("3647", "VEHICULAR LIGHTING EQUIPMENT", Category.CLASS),
        Classification("3648", "LIGHTING EQUIPMENT, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("365", "HOUSEHOLD AUDIO AND VIDEO EQUIPMENT, AND AUDIO RECORDINGS", Category.GROUP),
        Classification("3651", "HOUSEHOLD AUDIO AND VIDEO EQUIPMENT", Category.CLASS),
        Classification("3652", "PHONOGRAPH RECORDS AND PRERECORDED AUDIO TAPES AND DISKS", Category.CLASS),
        Classification("366", "COMMUNICATIONS EQUIPMENT", Category.GROUP),
        Classification("3661", "TELEPHONE AND TELEGRAPH APPARATUS", Category.CLASS),
        Classification("3663", "RADIO AND TELEVISION BROADCASTING AND COMMUNICATIONS EQUIPMENT", Category.CLASS),
        Classification("3669", "COMMUNICATIONS EQUIPMENT, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("367", "ELECTRONIC COMPONENTS AND ACCESSORIES", Category.GROUP),
        Classification("3671", "ELECTRON TUBES", Category.CLASS),
        Classification("3672", "PRINTED CIRCUIT BOARDS", Category.CLASS),
        Classification("3674", "SEMICONDUCTORS AND RELATED DEVICES", Category.CLASS),
        Classification("3675", "ELECTRONIC CAPACITORS", Category.CLASS),
        Classification("3676", "ELECTRONIC RESISTORS", Category.CLASS),
        Classification("3677", "ELECTRONIC COILS, TRANSFORMERS, AND OTHER INDUCTORS", Category.CLASS),
        Classification("3678", "ELECTRONIC CONNECTORS", Category.CLASS),
        Classification("3679", "ELECTRONIC COMPONENTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("369", "MISCELLANEOUS ELECTRICAL MACHINERY, EQUIPMENT, AND SUPPLIES", Category.GROUP),
        Classification("3691", "STORAGE BATTERIES", Category.CLASS),
        Classification("3692", "PRIMARY BATTERIES, DRY AND WET", Category.CLASS),
        Classification("3694", "ELECTRICAL EQUIPMENT FOR INTERNAL COMBUSTION ENGINES", Category.CLASS),
        Classification("3695", "MAGNETIC AND OPTICAL RECORDING MEDIA", Category.CLASS),
        Classification("3699", "ELECTRICAL MACHINERY, EQUIPMENT, AND SUPPLIES, NOT ELSEWHERE CLAS", Category.CLASS),
        Classification("37", "TRANSPORTATION EQUIPMENT", Category.DIVISION),
        Classification("371", "MOTOR VEHICLES AND MOTOR VEHICLE EQUIPMENT", Category.GROUP),
        Classification("3711", "MOTOR VEHICLES AND PASSENGER CAR BODIES", Category.CLASS),
        Classification("3713", "TRUCK AND BUS BODIES", Category.CLASS),
        Classification("3714", "MOTOR VEHICLE PARTS AND ACCESSORIES", Category.CLASS),
        Classification("3715", "TRUCK TRAILERS", Category.CLASS),
        Classification("3716", "MOTOR HOMES", Category.CLASS),
        Classification("372", "AIRCRAFT AND PARTS", Category.GROUP),
        Classification("3721", "AIRCRAFT", Category.CLASS),
        Classification("3724", "AIRCRAFT ENGINES AND ENGINE PARTS", Category.CLASS),
        Classification("3728", "AIRCRAFT PARTS AND AUXILIARY EQUIPMENT, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("373", "SHIP AND BOAT BUILDING AND REPAIRING", Category.GROUP),
        Classification("3731", "SHIP BUILDING AND REPAIRING", Category.CLASS),
        Classification("3732", "BOAT BUILDING AND REPAIRING", Category.CLASS),
        Classification("374", "RAILROAD EQUIPMENT", Category.GROUP),
        Classification("3743", "RAILROAD EQUIPMENT", Category.CLASS),
        Classification("375", "MOTORCYCLES, BICYCLES, AND PARTS", Category.GROUP),
        Classification("3751", "MOTORCYCLES, BICYCLES, AND PARTS", Category.CLASS),
        Classification("376", "GUIDED MISSILES AND SPACE VEHICLES AND PARTS", Category.GROUP),
        Classification("3761", "GUIDED MISSILES AND SPACE VEHICLES", Category.CLASS),
        Classification("3764", "GUIDED MISSILE AND SPACE VEHICLE PROPULSION UNITS AND PROPULSION", Category.CLASS),
        Classification("3769", "GUIDED MISSILE AND SPACE VEHICLE PARTS AND AUXILIARY EQUIPMENT, N", Category.CLASS),
        Classification("379", "MISCELLANEOUS TRANSPORTATION EQUIPMENT", Category.GROUP),
        Classification("3792", "TRAVEL TRAILERS AND CAMPERS", Category.CLASS),
        Classification("3795", "TANKS AND TANK COMPONENTS", Category.CLASS),
        Classification("3799", "TRANSPORTATION EQUIPMENT, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification(
            "38", "MEASURING, ANALYZING AND CONTROLLING INSTRUMENTS; PHOTOGRAPHIC, MEDICAL AN", Category.DIVISION
        ),
        Classification("381", "SEARCH, DETECTION, NAVIGATION, GUIDANCE, AERONAUTICAL, AND NAUTICA", Category.GROUP),
        Classification("3812", "SEARCH, DETECTION, NAVIGATION, GUIDANCE, AERONAUTICAL, AND NAUTIC", Category.CLASS),
        Classification("382", "LABORATORY APPARATUS AND ANALYTICAL, OPTICAL, MEASURING, AND CONTR", Category.GROUP),
        Classification("3821", "LABORATORY APPARATUS AND FURNITURE", Category.CLASS),
        Classification("3822", "AUTOMATIC CONTROLS FOR REGULATING RESIDENTIAL AND COMMERCIAL ENVI", Category.CLASS),
        Classification("3823", "INDUSTRIAL INSTRUMENTS FOR MEASUREMENT, DISPLAY, AND CONTROL OF P", Category.CLASS),
        Classification("3824", "TOTALIZING FLUID METERS AND COUNTING DEVICES", Category.CLASS),
        Classification("3825", "INSTRUMENTS FOR MEASURING AND TESTING OF ELECTRICITY AND ELECTRIC", Category.CLASS),
        Classification("3826", "LABORATORY ANALYTICAL INSTRUMENTS", Category.CLASS),
        Classification("3827", "OPTICAL INSTRUMENTS AND LENSES", Category.CLASS),
        Classification("3829", "MEASURING AND CONTROLLING DEVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("384", "SURGICAL, MEDICAL, AND DENTAL INSTRUMENTS AND SUPPLIES", Category.GROUP),
        Classification("3841", "SURGICAL AND MEDICAL INSTRUMENTS AND APPARATUS", Category.CLASS),
        Classification("3842", "ORTHOPEDIC, PROSTHETIC, AND SURGICAL APPLIANCES AND SUPPLIES", Category.CLASS),
        Classification("3843", "DENTAL EQUIPMENT AND SUPPLIES", Category.CLASS),
        Classification("3844", "X-RAY APPARATUS AND TUBES AND RELATED IRRADIATION APPARATUS", Category.CLASS),
        Classification("3845", "ELECTROMEDICAL AND ELECTROTHERAPEUTIC APPARATUS", Category.CLASS),
        Classification("385", "OPHTHALMIC GOODS", Category.GROUP),
        Classification("3851", "OPHTHALMIC GOODS", Category.CLASS),
        Classification("386", "PHOTOGRAPHIC EQUIPMENT AND SUPPLIES", Category.GROUP),
        Classification("3861", "PHOTOGRAPHIC EQUIPMENT AND SUPPLIES", Category.CLASS),
        Classification("387", "WATCHES, CLOCKS, CLOCKWORK OPERATED DEVICES, AND PARTS", Category.GROUP),
        Classification("3873", "WATCHES, CLOCKS, CLOCKWORK OPERATED DEVICES, AND PARTS", Category.CLASS),
        Classification("39", "MISCELLANEOUS MANUFACTURING INDUSTRIES", Category.DIVISION),
        Classification("391", "JEWELRY, SILVERWARE, AND PLATED WARE", Category.GROUP),
        Classification("3911", "JEWELRY, PRECIOUS METAL", Category.CLASS),
        Classification("3914", "SILVERWARE, PLATED WARE, AND STAINLESS STEEL WARE", Category.CLASS),
        Classification("3915", "JEWELERS' FINDINGS AND MATERIALS, AND LAPIDARY WORK", Category.CLASS),
        Classification("393", "MUSICAL INSTRUMENTS", Category.GROUP),
        Classification("3931", "MUSICAL INSTRUMENTS", Category.CLASS),
        Classification("394", "DOLLS, TOYS, GAMES AND SPORTING AND ATHLETIC GOODS", Category.GROUP),
        Classification("3942", "DOLLS AND STUFFED TOYS", Category.CLASS),
        Classification("3944", "GAMES, TOYS, AND CHILDREN'S VEHICLES, EXCEPT DOLLS AND BICYCLES", Category.CLASS),
        Classification("3949", "SPORTING AND ATHLETIC GOODS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("395", "PENS, PENCILS, AND OTHER ARTISTS' MATERIALS", Category.GROUP),
        Classification("3951", "PENS, MECHANICAL PENCILS, AND PARTS", Category.CLASS),
        Classification("3952", "LEAD PENCILS, CRAYONS, AND ARTISTS' MATERIALS", Category.CLASS),
        Classification("3953", "MARKING DEVICES", Category.CLASS),
        Classification("3955", "CARBON PAPER AND INKED RIBBONS", Category.CLASS),
        Classification("396", "COSTUME JEWELRY, COSTUME NOVELTIES, BUTTONS, AND MISCELLANEOUS NOT", Category.GROUP),
        Classification("3961", "COSTUME JEWELRY AND COSTUME NOVELTIES, EXCEPT PRECIOUS METAL", Category.CLASS),
        Classification("3965", "FASTENERS, BUTTONS, NEEDLES, AND PINS", Category.CLASS),
        Classification("399", "MISCELLANEOUS MANUFACTURING INDUSTRIES", Category.GROUP),
        Classification("3991", "BROOMS AND BRUSHES", Category.CLASS),
        Classification("3993", "SIGNS AND ADVERTISING SPECIALTIES", Category.CLASS),
        Classification("3995", "BURIAL CASKETS", Category.CLASS),
        Classification("3996", "LINOLEUM, ASPHALTED-FELT-BASE, AND OTHER HARD SURFACE FLOOR COVER", Category.CLASS),
        Classification("3999", "MANUFACTURING INDUSTRIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("E", "TRANSPORTATION, COMMUNICATIONS, ELECTRIC, GAS, AND SANITARY SERVICE", Category.SECTION),
        Classification("40", "RAILROAD TRANSPORTATION", Category.DIVISION),
        Classification("401", "RAILROADS", Category.GROUP),
        Classification("4011", "RAILROADS, LINE-HAUL OPERATING", Category.CLASS),
        Classification("4013", "RAILROAD SWITCHING AND TERMINAL ESTABLISHMENTS", Category.CLASS),
        Classification(
            "41", "LOCAL AND SUBURBAN TRANSIT AND INTERURBAN HIGHWAY PASSENGER TRANSPORTATION", Category.DIVISION
        ),
        Classification("411", "LOCAL AND SUBURBAN PASSENGER TRANSPORTATION", Category.GROUP),
        Classification("4111", "LOCAL AND SUBURBAN TRANSIT", Category.CLASS),
        Classification("4119", "LOCAL PASSENGER TRANSPORTATION, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("412", "TAXICABS", Category.GROUP),
        Classification("4121", "TAXICABS", Category.CLASS),
        Classification("413", "INTERCITY AND RURAL BUS TRANSPORTATION", Category.GROUP),
        Classification("4131", "INTERCITY AND RURAL BUS TRANSPORTATION", Category.CLASS),
        Classification("414", "BUS CHARTER SERVICE", Category.GROUP),
        Classification("4141", "LOCAL BUS CHARTER SERVICE", Category.CLASS),
        Classification("4142", "BUS CHARTER SERVICE, EXCEPT LOCAL", Category.CLASS),
        Classification("415", "SCHOOL BUSES", Category.GROUP),
        Classification("4151", "SCHOOL BUSES", Category.CLASS),
        Classification("417", "TERMINAL AND SERVICE FACILITIES FOR MOTOR VEHICLE PASSENGER TRANSP", Category.GROUP),
        Classification("4173", "TERMINAL AND SERVICE FACILITIES FOR MOTOR VEHICLE PASSENGER TRANS", Category.CLASS),
        Classification("42", "MOTOR FREIGHT TRANSPORTATION AND WAREHOUSING", Category.DIVISION),
        Classification("421", "TRUCKING AND COURIER SERVICES, EXCEPT AIR", Category.GROUP),
        Classification("4212", "LOCAL TRUCKING WITHOUT STORAGE", Category.CLASS),
        Classification("4213", "TRUCKING, EXCEPT LOCAL", Category.CLASS),
        Classification("4214", "LOCAL TRUCKING WITH STORAGE", Category.CLASS),
        Classification("4215", "COURIER SERVICES, EXCEPT BY AIR", Category.CLASS),
        Classification("422", "PUBLIC WAREHOUSING AND STORAGE", Category.GROUP),
        Classification("4221", "FARM PRODUCT WAREHOUSING AND STORAGE", Category.CLASS),
        Classification("4222", "REFRIGERATED WAREHOUSING AND STORAGE", Category.CLASS),
        Classification("4225", "GENERAL WAREHOUSING AND STORAGE", Category.CLASS),
        Classification("4226", "SPECIAL WAREHOUSING AND STORAGE, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("423", "TERMINAL AND JOINT TERMINAL MAINTENANCE FACILITIES FOR MOTOR FREIG", Category.GROUP),
        Classification("4231", "TERMINAL AND JOINT TERMINAL MAINTENANCE FACILITIES FOR MOTOR FREI", Category.CLASS),
        Classification("43", "UNITED STATES POSTAL SERVICE", Category.DIVISION),
        Classification("431", "UNITED STATES POSTAL SERVICE", Category.GROUP),
        Classification("4311", "UNITED STATES POSTAL SERVICE", Category.CLASS),
        Classification("44", "WATER TRANSPORTATION", Category.DIVISION),
        Classification("441", "DEEP SEA FOREIGN TRANSPORTATION OF FREIGHT", Category.GROUP),
        Classification("4412", "DEEP SEA FOREIGN TRANSPORTATION OF FREIGHT", Category.CLASS),
        Classification("442", "DEEP SEA DOMESTIC TRANSPORTATION OF FREIGHT", Category.GROUP),
        Classification("4424", "DEEP SEA DOMESTIC TRANSPORTATION OF FREIGHT", Category.CLASS),
        Classification("443", "FREIGHT TRANSPORTATION ON THE GREAT LAKES&die;ST. LAWRENCE SEAWAY", Category.GROUP),
        Classification("4432", "FREIGHT TRANSPORTATION ON THE GREAT LAKES&die;ST. LAWRENCE SEAWAY", Category.CLASS),
        Classification("444", "WATER TRANSPORTATION OF FREIGHT, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("4449", "WATER TRANSPORTATION OF FREIGHT, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("448", "WATER TRANSPORTATION OF PASSENGERS", Category.GROUP),
        Classification("4481", "DEEP SEA TRANSPORTATION OF PASSENGERS, EXCEPT BY FERRY", Category.CLASS),
        Classification("4482", "FERRIES", Category.CLASS),
        Classification("4489", "WATER TRANSPORTATION OF PASSENGERS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("449", "SERVICES INCIDENTAL TO WATER TRANSPORTATION", Category.GROUP),
        Classification("4491", "MARINE CARGO HANDLING", Category.CLASS),
        Classification("4492", "TOWING AND TUGBOAT SERVICES", Category.CLASS),
        Classification("4493", "MARINAS", Category.CLASS),
        Classification("4499", "WATER TRANSPORTATION SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("45", "TRANSPORTATION BY AIR", Category.DIVISION),
        Classification("451", "AIR TRANSPORTATION, SCHEDULED, AND AIR COURIER SERVICES", Category.GROUP),
        Classification("4512", "AIR TRANSPORTATION, SCHEDULED", Category.CLASS),
        Classification("4513", "AIR COURIER SERVICES", Category.CLASS),
        Classification("452", "AIR TRANSPORTATION, NONSCHEDULED", Category.GROUP),
        Classification("4522", "AIR TRANSPORTATION, NONSCHEDULED", Category.CLASS),
        Classification("458", "AIRPORTS, FLYING FIELDS, AND AIRPORT TERMINAL SERVICES", Category.GROUP),
        Classification("4581", "AIRPORTS, FLYING FIELDS, AND AIRPORT TERMINAL SERVICES", Category.CLASS),
        Classification("46", "PIPELINES, EXCEPT NATURAL GAS", Category.DIVISION),
        Classification("461", "PIPELINES, EXCEPT NATURAL GAS", Category.GROUP),
        Classification("4612", "CRUDE PETROLEUM PIPELINES", Category.CLASS),
        Classification("4613", "REFINED PETROLEUM PIPELINES", Category.CLASS),
        Classification("4619", "PIPELINES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("47", "TRANSPORTATION SERVICES", Category.DIVISION),
        Classification("472", "ARRANGEMENT OF PASSENGER TRANSPORTATION", Category.GROUP),
        Classification("4724", "TRAVEL AGENCIES", Category.CLASS),
        Classification("4725", "TOUR OPERATORS", Category.CLASS),
        Classification("4729", "ARRANGEMENT OF PASSENGER TRANSPORTATION, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("473", "ARRANGEMENT OF TRANSPORTATION OF FREIGHT AND CARGO", Category.GROUP),
        Classification("4731", "ARRANGEMENT OF TRANSPORTATION OF FREIGHT AND CARGO", Category.CLASS),
        Classification("474", "RENTAL OF RAILROAD CARS", Category.GROUP),
        Classification("4741", "RENTAL OF RAILROAD CARS", Category.CLASS),
        Classification("478", "MISCELLANEOUS SERVICES INCIDENTAL TO TRANSPORTATION", Category.GROUP),
        Classification("4783", "PACKING AND CRATING", Category.CLASS),
        Classification("4785", "FIXED FACILITIES AND INSPECTION AND WEIGHING SERVICES FOR MOTOR V", Category.CLASS),
        Classification("4785", "CARGO CHECKERS AND SURVEYORS, MARINE", Category.CLASS),
        Classification("4789", "TRANSPORTATION SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("48", "COMMUNICATIONS", Category.DIVISION),
        Classification("481", "TELEPHONE COMMUNICATIONS", Category.GROUP),
        Classification("4812", "RADIOTELEPHONE COMMUNICATIONS", Category.CLASS),
        Classification("4813", "TELEPHONE COMMUNICATIONS, EXCEPT RADIOTELEPHONE", Category.CLASS),
        Classification("482", "TELEGRAPH AND OTHER MESSAGE COMMUNICATIONS", Category.GROUP),
        Classification("4822", "TELEGRAPH AND OTHER MESSAGE COMMUNICATIONS", Category.CLASS),
        Classification("483", "RADIO AND TELEVISION BROADCASTING STATIONS", Category.GROUP),
        Classification("4832", "RADIO BROADCASTING STATIONS", Category.CLASS),
        Classification("4833", "TELEVISION BROADCASTING STATIONS", Category.CLASS),
        Classification("484", "CABLE AND OTHER PAY TELEVISION SERVICES", Category.GROUP),
        Classification("4841", "CABLE AND OTHER PAY TELEVISION SERVICES", Category.CLASS),
        Classification("489", "COMMUNICATIONS SERVICES, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("4899", "COMMUNICATIONS SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("49", "ELECTRIC, GAS, AND SANITARY SERVICES", Category.DIVISION),
        Classification("491", "ELECTRIC SERVICES", Category.GROUP),
        Classification("4911", "ELECTRIC SERVICES", Category.CLASS),
        Classification("492", "GAS PRODUCTION AND DISTRIBUTION", Category.GROUP),
        Classification("4922", "NATURAL GAS TRANSMISSION", Category.CLASS),
        Classification("4923", "NATURAL GAS TRANSMISSION AND DISTRIBUTION", Category.CLASS),
        Classification("4924", "NATURAL GAS DISTRIBUTION", Category.CLASS),
        Classification("4925", "MIXED, MANUFACTURED, OR LIQUEFIED PETROLEUM GAS PRODUCTION AND/OR", Category.CLASS),
        Classification("493", "COMBINATION ELECTRIC AND GAS, AND OTHER UTILITY SERVICES", Category.GROUP),
        Classification("4931", "ELECTRIC AND OTHER SERVICES COMBINED", Category.CLASS),
        Classification("4932", "GAS AND OTHER SERVICES COMBINED", Category.CLASS),
        Classification("4939", "COMBINATION UTILITIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("494", "WATER SUPPLY", Category.GROUP),
        Classification("4941", "WATER SUPPLY", Category.CLASS),
        Classification("495", "SANITARY SERVICES", Category.GROUP),
        Classification("4952", "SEWERAGE SYSTEMS", Category.CLASS),
        Classification("4953", "REFUSE SYSTEMS", Category.CLASS),
        Classification("4959", "SANITARY SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("496", "STEAM AND AIR-CONDITIONING SUPPLY", Category.GROUP),
        Classification("4961", "STEAM AND AIR-CONDITIONING SUPPLY", Category.CLASS),
        Classification("497", "IRRIGATION SYSTEMS", Category.GROUP),
        Classification("4971", "IRRIGATION SYSTEMS", Category.CLASS),
        Classification("F", "WHOLESALE TRADE", Category.SECTION),
        Classification("50", "WHOLESALE TRADE&die;DURABLE GOODS", Category.DIVISION),
        Classification("501", "MOTOR VEHICLES AND MOTOR VEHICLE PARTS AND SUPPLIES", Category.GROUP),
        Classification("5012", "AUTOMOBILES AND OTHER MOTOR VEHICLES", Category.CLASS),
        Classification("5013", "MOTOR VEHICLE SUPPLIES AND NEW PARTS", Category.CLASS),
        Classification("5014", "TIRES AND TUBES", Category.CLASS),
        Classification("5015", "MOTOR VEHICLE PARTS, USED", Category.CLASS),
        Classification("502", "FURNITURE AND HOMEFURNISHINGS", Category.GROUP),
        Classification("5021", "FURNITURE", Category.CLASS),
        Classification("5023", "HOMEFURNISHINGS", Category.CLASS),
        Classification("503", "LUMBER AND OTHER CONSTRUCTION MATERIALS", Category.GROUP),
        Classification("5031", "LUMBER, PLYWOOD, MILLWORK, AND WOOD PANELS", Category.CLASS),
        Classification("5032", "BRICK, STONE, AND RELATED CONSTRUCTION MATERIALS", Category.CLASS),
        Classification("5033", "ROOFING, SIDING, AND INSULATION MATERIALS", Category.CLASS),
        Classification("5039", "CONSTRUCTION MATERIALS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("504", "PROFESSIONAL AND COMMERCIAL EQUIPMENT AND SUPPLIES", Category.GROUP),
        Classification("5043", "PHOTOGRAPHIC EQUIPMENT AND SUPPLIES", Category.CLASS),
        Classification("5044", "OFFICE EQUIPMENT", Category.CLASS),
        Classification("5045", "COMPUTERS AND COMPUTER PERIPHERAL EQUIPMENT AND SOFTWARE", Category.CLASS),
        Classification("5046", "COMMERCIAL EQUIPMENT, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("5047", "MEDICAL, DENTAL, AND HOSPITAL EQUIPMENT AND SUPPLIES", Category.CLASS),
        Classification("5048", "OPHTHALMIC GOODS", Category.CLASS),
        Classification("5049", "PROFESSIONAL EQUIPMENT AND SUPPLIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("505", "METALS AND MINERALS, EXCEPT PETROLEUM", Category.GROUP),
        Classification("5051", "METALS SERVICE CENTERS AND OFFICES", Category.CLASS),
        Classification("5052", "COAL AND OTHER MINERALS AND ORES", Category.CLASS),
        Classification("506", "ELECTRICAL GOODS", Category.GROUP),
        Classification("5063", "ELECTRICAL APPARATUS AND EQUIPMENT, WIRING SUPPLIES, AND CONSTRUC", Category.CLASS),
        Classification("5064", "ELECTRICAL APPLIANCES, TELEVISION AND RADIO SETS", Category.CLASS),
        Classification("5065", "ELECTRONIC PARTS AND EQUIPMENT, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("507", "HARDWARE, AND PLUMBING AND HEATING EQUIPMENT AND SUPPLIES", Category.GROUP),
        Classification("5072", "HARDWARE", Category.CLASS),
        Classification("5074", "PLUMBING AND HEATING EQUIPMENT AND SUPPLIES (HYDRONICS)", Category.CLASS),
        Classification("5075", "WARM AIR HEATING AND AIR-CONDITIONING EQUIPMENT AND SUPPLIES", Category.CLASS),
        Classification("5078", "REFRIGERATION EQUIPMENT AND SUPPLIES", Category.CLASS),
        Classification("508", "MACHINERY, EQUIPMENT, AND SUPPLIES", Category.GROUP),
        Classification("5082", "CONSTRUCTION AND MINING (EXCEPT PETROLEUM) MACHINERY AND EQUIPMEN", Category.CLASS),
        Classification("5083", "FARM AND GARDEN MACHINERY AND EQUIPMENT", Category.CLASS),
        Classification("5084", "INDUSTRIAL MACHINERY AND EQUIPMENT", Category.CLASS),
        Classification("5085", "INDUSTRIAL SUPPLIES", Category.CLASS),
        Classification("5087", "SERVICE ESTABLISHMENT EQUIPMENT AND SUPPLIES", Category.CLASS),
        Classification("5088", "TRANSPORTATION EQUIPMENT AND SUPPLIES, EXCEPT MOTOR VEHICLES", Category.CLASS),
        Classification("509", "MISCELLANEOUS DURABLE GOODS", Category.GROUP),
        Classification("5091", "SPORTING AND RECREATIONAL GOODS AND SUPPLIES", Category.CLASS),
        Classification("5092", "TOYS AND HOBBY GOODS AND SUPPLIES", Category.CLASS),
        Classification("5093", "SCRAP AND WASTE MATERIALS", Category.CLASS),
        Classification("5094", "JEWELRY, WATCHES, PRECIOUS STONES, AND PRECIOUS METALS", Category.CLASS),
        Classification("5099", "DURABLE GOODS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("51", "WHOLESALE TRADE&die;NONDURABLE GOODS", Category.DIVISION),
        Classification("511", "PAPER AND PAPER PRODUCTS", Category.GROUP),
        Classification("5111", "PRINTING AND WRITING PAPER", Category.CLASS),
        Classification("5112", "STATIONERY AND OFFICE SUPPLIES", Category.CLASS),
        Classification("5113", "INDUSTRIAL AND PERSONAL SERVICE PAPER", Category.CLASS),
        Classification("512", "DRUGS, DRUG PROPRIETARIES, AND DRUGGISTS' SUNDRIES", Category.GROUP),
        Classification("5122", "DRUGS, DRUG PROPRIETARIES, AND DRUGGISTS' SUNDRIES", Category.CLASS),
        Classification("513", "APPAREL, PIECE GOODS, AND NOTIONS", Category.GROUP),
        Classification("5131", "PIECE GOODS, NOTIONS, AND OTHER DRY GOODS", Category.CLASS),
        Classification("5136", "MEN'S AND BOYS' CLOTHING AND FURNISHINGS", Category.CLASS),
        Classification("5137", "WOMEN'S, CHILDREN'S, AND INFANTS' CLOTHING AND ACCESSORIES", Category.CLASS),
        Classification("5139", "FOOTWEAR", Category.CLASS),
        Classification("514", "GROCERIES AND RELATED PRODUCTS", Category.GROUP),
        Classification("5141", "GROCERIES, GENERAL LINE", Category.CLASS),
        Classification("5142", "PACKAGED FROZEN FOODS", Category.CLASS),
        Classification("5143", "DAIRY PRODUCTS, EXCEPT DRIED OR CANNED", Category.CLASS),
        Classification("5144", "POULTRY AND POULTRY PRODUCTS", Category.CLASS),
        Classification("5145", "CONFECTIONERY", Category.CLASS),
        Classification("5146", "FISH AND SEAFOODS", Category.CLASS),
        Classification("5147", "MEATS AND MEAT PRODUCTS", Category.CLASS),
        Classification("5148", "FRESH FRUITS AND VEGETABLES", Category.CLASS),
        Classification("5149", "GROCERIES AND RELATED PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("515", "FARM-PRODUCT RAW MATERIALS", Category.GROUP),
        Classification("5153", "GRAIN AND FIELD BEANS", Category.CLASS),
        Classification("5154", "LIVESTOCK", Category.CLASS),
        Classification("5159", "FARM-PRODUCT RAW MATERIALS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("516", "CHEMICALS AND ALLIED PRODUCTS", Category.GROUP),
        Classification("5162", "PLASTICS MATERIALS AND BASIC FORMS AND SHAPES", Category.CLASS),
        Classification("5169", "CHEMICALS AND ALLIED PRODUCTS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("517", "PETROLEUM AND PETROLEUM PRODUCTS", Category.GROUP),
        Classification("5171", "PETROLEUM BULK STATIONS AND TERMINALS", Category.CLASS),
        Classification("5172", "PETROLEUM AND PETROLEUM PRODUCTS WHOLESALERS, EXCEPT BULK STATION", Category.CLASS),
        Classification("518", "BEER, WINE, AND DISTILLED ALCOHOLIC BEVERAGES", Category.GROUP),
        Classification("5181", "BEER AND ALE", Category.CLASS),
        Classification("5182", "WINE AND DISTILLED ALCOHOLIC BEVERAGES", Category.CLASS),
        Classification("519", "MISCELLANEOUS NONDURABLE GOODS", Category.GROUP),
        Classification("5191", "FARM SUPPLIES", Category.CLASS),
        Classification("5192", "BOOKS, PERIODICALS, AND NEWSPAPERS", Category.CLASS),
        Classification("5193", "FLOWERS, NURSERY STOCK, AND FLORISTS' SUPPLIES", Category.CLASS),
        Classification("5194", "TOBACCO AND TOBACCO PRODUCTS", Category.CLASS),
        Classification("5198", "PAINTS, VARNISHES, AND SUPPLIES", Category.CLASS),
        Classification("5199", "NONDURABLE GOODS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("G", "RETAIL TRADE", Category.SECTION),
        Classification("52", "BUILDING MATERIALS, HARDWARE, GARDEN SUPPLY, AND MOBILE HOME DEALERS", Category.DIVISION),
        Classification("521", "LUMBER AND OTHER BUILDING MATERIALS DEALERS", Category.GROUP),
        Classification("5211", "LUMBER AND OTHER BUILDING MATERIALS DEALERS", Category.CLASS),
        Classification("523", "PAINT, GLASS, AND WALLPAPER STORES", Category.GROUP),
        Classification("5231", "PAINT, GLASS, AND WALLPAPER STORES", Category.CLASS),
        Classification("525", "HARDWARE STORES", Category.GROUP),
        Classification("5251", "HARDWARE STORES", Category.CLASS),
        Classification("526", "RETAIL NURSERIES, LAWN AND GARDEN SUPPLY STORES", Category.GROUP),
        Classification("5261", "RETAIL NURSERIES, LAWN AND GARDEN SUPPLY STORES", Category.CLASS),
        Classification("527", "MOBILE HOME DEALERS", Category.GROUP),
        Classification("5271", "MOBILE HOME DEALERS", Category.CLASS),
        Classification("53", "GENERAL MERCHANDISE STORES", Category.DIVISION),
        Classification("531", "DEPARTMENT STORES", Category.GROUP),
        Classification("5311", "DEPARTMENT STORES", Category.CLASS),
        Classification("533", "VARIETY STORES", Category.GROUP),
        Classification("5331", "VARIETY STORES", Category.CLASS),
        Classification("539", "MISCELLANEOUS GENERAL MERCHANDISE STORES", Category.GROUP),
        Classification("5399", "MISCELLANEOUS GENERAL MERCHANDISE STORES", Category.CLASS),
        Classification("54", "FOOD STORES", Category.DIVISION),
        Classification("541", "GROCERY STORES", Category.GROUP),
        Classification("5411", "GROCERY STORES", Category.CLASS),
        Classification("542", "MEAT AND FISH (SEAFOOD) MARKETS, INCLUDING FREEZER PROVISIONERS", Category.GROUP),
        Classification("5421", "MEAT AND FISH (SEAFOOD) MARKETS, INCLUDING FREEZER PROVISIONERS", Category.CLASS),
        Classification("543", "FRUIT AND VEGETABLE MARKETS", Category.GROUP),
        Classification("5431", "FRUIT AND VEGETABLE MARKETS", Category.CLASS),
        Classification("544", "CANDY, NUT, AND CONFECTIONERY STORES", Category.GROUP),
        Classification("5441", "CANDY, NUT, AND CONFECTIONERY STORES", Category.CLASS),
        Classification("545", "DAIRY PRODUCTS STORES", Category.GROUP),
        Classification("5451", "DAIRY PRODUCTS STORES", Category.CLASS),
        Classification("546", "RETAIL BAKERIES", Category.GROUP),
        Classification("5461", "RETAIL BAKERIES", Category.CLASS),
        Classification("549", "MISCELLANEOUS FOOD STORES", Category.GROUP),
        Classification("5499", "MISCELLANEOUS FOOD STORES", Category.CLASS),
        Classification("55", "AUTOMOTIVE DEALERS AND GASOLINE SERVICE STATIONS", Category.DIVISION),
        Classification("551", "MOTOR VEHICLE DEALERS (NEW AND USED)", Category.GROUP),
        Classification("5511", "MOTOR VEHICLE DEALERS (NEW AND USED)", Category.CLASS),
        Classification("552", "MOTOR VEHICLE DEALERS (USED ONLY)", Category.GROUP),
        Classification("5521", "MOTOR VEHICLE DEALERS (USED ONLY)", Category.CLASS),
        Classification("553", "AUTO AND HOME SUPPLY STORES", Category.GROUP),
        Classification("5531", "AUTO AND HOME SUPPLY STORES", Category.CLASS),
        Classification("554", "GASOLINE SERVICE STATIONS", Category.GROUP),
        Classification("5541", "GASOLINE SERVICE STATIONS", Category.CLASS),
        Classification("555", "BOAT DEALERS", Category.GROUP),
        Classification("5551", "BOAT DEALERS", Category.CLASS),
        Classification("556", "RECREATIONAL VEHICLE DEALERS", Category.GROUP),
        Classification("5561", "RECREATIONAL VEHICLE DEALERS", Category.CLASS),
        Classification("557", "MOTORCYCLE DEALERS", Category.GROUP),
        Classification("5571", "MOTORCYCLE DEALERS", Category.CLASS),
        Classification("559", "AUTOMOTIVE DEALERS, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("5599", "AUTOMOTIVE DEALERS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("56", "APPAREL AND ACCESSORY STORES", Category.DIVISION),
        Classification("561", "MEN'S AND BOYS' CLOTHING AND ACCESSORY STORES", Category.GROUP),
        Classification("5611", "MEN'S AND BOYS' CLOTHING AND ACCESSORY STORES", Category.CLASS),
        Classification("562", "WOMEN'S CLOTHING STORES", Category.GROUP),
        Classification("5621", "WOMEN'S CLOTHING STORES", Category.CLASS),
        Classification("563", "WOMEN'S ACCESSORY AND SPECIALTY STORES", Category.GROUP),
        Classification("5632", "WOMEN'S ACCESSORY AND SPECIALTY STORES", Category.CLASS),
        Classification("564", "CHILDREN'S AND INFANTS' WEAR STORES", Category.GROUP),
        Classification("5641", "CHILDREN'S AND INFANTS' WEAR STORES", Category.CLASS),
        Classification("565", "FAMILY CLOTHING STORES", Category.GROUP),
        Classification("5651", "FAMILY CLOTHING STORES", Category.CLASS),
        Classification("566", "SHOE STORES", Category.GROUP),
        Classification("5661", "SHOE STORES", Category.CLASS),
        Classification("569", "MISCELLANEOUS APPAREL AND ACCESSORY STORES", Category.GROUP),
        Classification("5699", "MISCELLANEOUS APPAREL AND ACCESSORY STORES", Category.CLASS),
        Classification("57", "HOME FURNITURE, FURNISHINGS, AND EQUIPMENT STORES", Category.DIVISION),
        Classification("571", "HOME FURNITURE AND FURNISHINGS STORES", Category.GROUP),
        Classification("5712", "FURNITURE STORES", Category.CLASS),
        Classification("5713", "FLOOR COVERING STORES", Category.CLASS),
        Classification("5714", "DRAPERY, CURTAIN, AND UPHOLSTERY STORES", Category.CLASS),
        Classification("5719", "MISCELLANEOUS HOMEFURNISHINGS STORES", Category.CLASS),
        Classification("572", "HOUSEHOLD APPLIANCE STORES", Category.GROUP),
        Classification("5722", "HOUSEHOLD APPLIANCE STORES", Category.CLASS),
        Classification("573", "RADIO, TELEVISION, CONSUMER ELECTRONICS, AND MUSIC STORES", Category.GROUP),
        Classification("5731", "RADIO, TELEVISION, AND CONSUMER ELECTRONICS STORES", Category.CLASS),
        Classification("5734", "COMPUTER AND COMPUTER SOFTWARE STORES", Category.CLASS),
        Classification("5735", "RECORD AND PRERECORDED TAPE STORES", Category.CLASS),
        Classification("5736", "MUSICAL INSTRUMENT STORES", Category.CLASS),
        Classification("58", "EATING AND DRINKING PLACES", Category.DIVISION),
        Classification("581", "EATING AND DRINKING PLACES", Category.GROUP),
        Classification("5812", "EATING PLACES", Category.CLASS),
        Classification("5813", "DRINKING PLACES (ALCOHOLIC BEVERAGES)", Category.CLASS),
        Classification("59", "MISCELLANEOUS RETAIL", Category.DIVISION),
        Classification("591", "DRUG STORES AND PROPRIETARY STORES", Category.GROUP),
        Classification("5912", "DRUG STORES AND PROPRIETARY STORES", Category.CLASS),
        Classification("592", "LIQUOR STORES", Category.GROUP),
        Classification("5921", "LIQUOR STORES", Category.CLASS),
        Classification("593", "USED MERCHANDISE STORES", Category.GROUP),
        Classification("5932", "USED MERCHANDISE STORES", Category.CLASS),
        Classification("594", "MISCELLANEOUS SHOPPING GOODS STORES", Category.GROUP),
        Classification("5941", "SPORTING GOODS STORES AND BICYCLE SHOPS", Category.CLASS),
        Classification("5942", "BOOK STORES", Category.CLASS),
        Classification("5943", "STATIONERY STORES", Category.CLASS),
        Classification("5944", "JEWELRY STORES", Category.CLASS),
        Classification("5945", "HOBBY, TOY, AND GAME SHOPS", Category.CLASS),
        Classification("5946", "CAMERA AND PHOTOGRAPHIC SUPPLY STORES", Category.CLASS),
        Classification("5947", "GIFT, NOVELTY, AND SOUVENIR SHOPS", Category.CLASS),
        Classification("5948", "LUGGAGE AND LEATHER GOODS STORES", Category.CLASS),
        Classification("5949", "SEWING, NEEDLEWORK, AND PIECE GOODS STORES", Category.CLASS),
        Classification("596", "NONSTORE RETAILERS", Category.GROUP),
        Classification("5961", "CATALOG AND MAIL-ORDER HOUSES", Category.CLASS),
        Classification("5962", "AUTOMATIC MERCHANDISING MACHINE OPERATORS", Category.CLASS),
        Classification("5963", "DIRECT SELLING ESTABLISHMENTS", Category.CLASS),
        Classification("598", "FUEL DEALERS", Category.GROUP),
        Classification("5983", "FUEL OIL DEALERS", Category.CLASS),
        Classification("5984", "LIQUEFIED PETROLEUM GAS (BOTTLED GAS) DEALERS", Category.CLASS),
        Classification("5989", "FUEL DEALERS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("599", "RETAIL STORES, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("5992", "FLORISTS", Category.CLASS),
        Classification("5993", "TOBACCO STORES AND STANDS", Category.CLASS),
        Classification("5994", "NEWS DEALERS AND NEWSSTANDS", Category.CLASS),
        Classification("5995", "OPTICAL GOODS STORES", Category.CLASS),
        Classification("5999", "MISCELLANEOUS RETAIL STORES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("H", "FINANCE, INSURANCE, AND REAL ESTATE", Category.SECTION),
        Classification("60", "DEPOSITORY INSTITUTIONS", Category.DIVISION),
        Classification("601", "CENTRAL RESERVE DEPOSITORY INSTITUTIONS", Category.GROUP),
        Classification("6011", "FEDERAL RESERVE BANKS", Category.CLASS),
        Classification("6019", "CENTRAL RESERVE DEPOSITORY INSTITUTIONS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("602", "COMMERCIAL BANKS", Category.GROUP),
        Classification("6021", "NATIONAL COMMERCIAL BANKS", Category.CLASS),
        Classification("6022", "STATE COMMERCIAL BANKS", Category.CLASS),
        Classification("6029", "COMMERCIAL BANKS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("603", "SAVINGS INSTITUTIONS", Category.GROUP),
        Classification("6035", "SAVINGS INSTITUTIONS, FEDERALLY CHARTERED", Category.CLASS),
        Classification("6036", "SAVINGS INSTITUTIONS, NOT FEDERALLY CHARTERED", Category.CLASS),
        Classification("606", "CREDIT UNIONS", Category.GROUP),
        Classification("6061", "CREDIT UNIONS, FEDERALLY CHARTERED", Category.CLASS),
        Classification("6062", "CREDIT UNIONS, NOT FEDERALLY CHARTERED", Category.CLASS),
        Classification("608", "FOREIGN BANKING AND BRANCHES AND AGENCIES OF FOREIGN BANKS", Category.GROUP),
        Classification("6081", "BRANCHES AND AGENCIES OF FOREIGN BANKS", Category.CLASS),
        Classification("6082", "FOREIGN TRADE AND INTERNATIONAL BANKING INSTITUTIONS", Category.CLASS),
        Classification("609", "FUNCTIONS RELATED TO DEPOSITORY BANKING", Category.GROUP),
        Classification("6091", "NONDEPOSIT TRUST FACILITIES", Category.CLASS),
        Classification("6099", "FUNCTIONS RELATED TO DEPOSITORY BANKING, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("61", "NONDEPOSITORY CREDIT INSTITUTIONS", Category.DIVISION),
        Classification("611", "FEDERAL AND FEDERALLY-SPONSORED CREDIT AGENCIES", Category.GROUP),
        Classification("6111", "FEDERAL AND FEDERALLY-SPONSORED CREDIT AGENCIES", Category.CLASS),
        Classification("614", "PERSONAL CREDIT INSTITUTIONS", Category.GROUP),
        Classification("6141", "PERSONAL CREDIT INSTITUTIONS", Category.CLASS),
        Classification("615", "BUSINESS CREDIT INSTITUTIONS", Category.GROUP),
        Classification("6153", "SHORT-TERM BUSINESS CREDIT INSTITUTIONS, EXCEPT AGRICULTURAL", Category.CLASS),
        Classification("6159", "MISCELLANEOUS BUSINESS CREDIT INSTITUTIONS", Category.CLASS),
        Classification("616", "MORTGAGE BANKERS AND BROKERS", Category.GROUP),
        Classification("6162", "MORTGAGE BANKERS AND LOAN CORRESPONDENTS", Category.CLASS),
        Classification("6163", "LOAN BROKERS", Category.CLASS),
        Classification("62", "SECURITY AND COMMODITY BROKERS, DEALERS, EXCHANGES, AND SERVICES", Category.DIVISION),
        Classification("621", "SECURITY BROKERS, DEALERS, AND FLOTATION COMPANIES", Category.GROUP),
        Classification("6211", "SECURITY BROKERS, DEALERS, AND FLOTATION COMPANIES", Category.CLASS),
        Classification("622", "COMMODITY CONTRACTS BROKERS AND DEALERS", Category.GROUP),
        Classification("6221", "COMMODITY CONTRACTS BROKERS AND DEALERS", Category.CLASS),
        Classification("623", "SECURITY AND COMMODITY EXCHANGES", Category.GROUP),
        Classification("6231", "SECURITY AND COMMODITY EXCHANGES", Category.CLASS),
        Classification("628", "SERVICES ALLIED WITH THE EXCHANGE OF SECURITIES OR COMMODITIES", Category.GROUP),
        Classification("6282", "INVESTMENT ADVICE", Category.CLASS),
        Classification("6289", "SERVICES ALLIED WITH THE EXCHANGE OF SECURITIES OR COMMODITIES, N", Category.CLASS),
        Classification("63", "INSURANCE CARRIERS", Category.DIVISION),
        Classification("631", "LIFE INSURANCE", Category.GROUP),
        Classification("6311", "LIFE INSURANCE", Category.CLASS),
        Classification("632", "ACCIDENT AND HEALTH INSURANCE AND MEDICAL SERVICE PLANS", Category.GROUP),
        Classification("6321", "ACCIDENT AND HEALTH INSURANCE", Category.CLASS),
        Classification("6324", "HOSPITAL AND MEDICAL SERVICE PLANS", Category.CLASS),
        Classification("633", "FIRE, MARINE, AND CASUALTY INSURANCE", Category.GROUP),
        Classification("6331", "FIRE, MARINE, AND CASUALTY INSURANCE", Category.CLASS),
        Classification("635", "SURETY INSURANCE", Category.GROUP),
        Classification("6351", "SURETY INSURANCE", Category.CLASS),
        Classification("636", "TITLE INSURANCE", Category.GROUP),
        Classification("6361", "TITLE INSURANCE", Category.CLASS),
        Classification("637", "PENSION, HEALTH, AND WELFARE FUNDS", Category.GROUP),
        Classification("6371", "PENSION, HEALTH, AND WELFARE FUNDS", Category.CLASS),
        Classification("639", "INSURANCE CARRIERS, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("6399", "INSURANCE CARRIERS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("64", "INSURANCE AGENTS, BROKERS, AND SERVICE", Category.DIVISION),
        Classification("641", "INSURANCE AGENTS, BROKERS, AND SERVICE", Category.GROUP),
        Classification("6411", "INSURANCE AGENTS, BROKERS, AND SERVICE", Category.CLASS),
        Classification("65", "REAL ESTATE", Category.DIVISION),
        Classification("651", "REAL ESTATE OPERATORS (EXCEPT DEVELOPERS) AND LESSORS", Category.GROUP),
        Classification("6512", "OPERATORS OF NONRESIDENTIAL BUILDINGS", Category.CLASS),
        Classification("6513", "OPERATORS OF APARTMENT BUILDINGS", Category.CLASS),
        Classification("6514", "OPERATORS OF DWELLINGS OTHER THAN APARTMENT BUILDINGS", Category.CLASS),
        Classification("6515", "OPERATORS OF RESIDENTIAL MOBILE HOME SITES", Category.CLASS),
        Classification("6517", "LESSORS OF RAILROAD PROPERTY", Category.CLASS),
        Classification("6519", "LESSORS OF REAL PROPERTY, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("653", "REAL ESTATE AGENTS AND MANAGERS", Category.GROUP),
        Classification("6531", "REAL ESTATE AGENTS AND MANAGERS", Category.CLASS),
        Classification("654", "TITLE ABSTRACT OFFICES", Category.GROUP),
        Classification("6541", "TITLE ABSTRACT OFFICES", Category.CLASS),
        Classification("655", "LAND SUBDIVIDERS AND DEVELOPERS", Category.GROUP),
        Classification("6552", "LAND SUBDIVIDERS AND DEVELOPERS, EXCEPT CEMETERIES", Category.CLASS),
        Classification("6553", "CEMETERY SUBDIVIDERS AND DEVELOPERS", Category.CLASS),
        Classification("67", "HOLDING AND OTHER INVESTMENT OFFICES", Category.DIVISION),
        Classification("671", "HOLDING OFFICES", Category.GROUP),
        Classification("6712", "OFFICES OF BANK HOLDING COMPANIES", Category.CLASS),
        Classification("6719", "OFFICES OF HOLDING COMPANIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("672", "INVESTMENT OFFICES", Category.GROUP),
        Classification("6722", "MANAGEMENT INVESTMENT OFFICES, OPEN-END", Category.CLASS),
        Classification("6726", "UNIT INVESTMENT TRUSTS, FACE-AMOUNT CERTIFICATE OFFICES, AND CLOS", Category.CLASS),
        Classification("673", "TRUSTS", Category.GROUP),
        Classification("6732", "EDUCATIONAL, RELIGIOUS, AND CHARITABLE TRUSTS", Category.CLASS),
        Classification("6733", "TRUSTS, EXCEPT EDUCATIONAL, RELIGIOUS, AND CHARITABLE", Category.CLASS),
        Classification("679", "MISCELLANEOUS INVESTING", Category.GROUP),
        Classification("6792", "OIL ROYALTY TRADERS", Category.CLASS),
        Classification("6794", "PATENT OWNERS AND LESSORS", Category.CLASS),
        Classification("6798", "REAL ESTATE INVESTMENT TRUSTS", Category.CLASS),
        Classification("6799", "INVESTORS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("I", "SERVICES", Category.SECTION),
        Classification("70", "HOTELS, ROOMING HOUSES, CAMPS, AND OTHER LODGING PLACES", Category.DIVISION),
        Classification("701", "HOTELS AND MOTELS", Category.GROUP),
        Classification("7011", "HOTELS AND MOTELS", Category.CLASS),
        Classification("702", "ROOMING AND BOARDING HOUSES", Category.GROUP),
        Classification("7021", "ROOMING AND BOARDING HOUSES", Category.CLASS),
        Classification("703", "CAMPS AND RECREATIONAL VEHICLE PARKS", Category.GROUP),
        Classification("7032", "SPORTING AND RECREATIONAL CAMPS", Category.CLASS),
        Classification("7033", "RECREATIONAL VEHICLE PARKS AND CAMPSITES", Category.CLASS),
        Classification("704", "ORGANIZATION HOTELS AND LODGING HOUSES, ON MEMBERSHIP BASIS", Category.GROUP),
        Classification("7041", "ORGANIZATION HOTELS AND LODGING HOUSES, ON MEMBERSHIP BASIS", Category.CLASS),
        Classification("72", "PERSONAL SERVICES", Category.DIVISION),
        Classification("721", "LAUNDRY, CLEANING, AND GARMENT SERVICES", Category.GROUP),
        Classification("7211", "POWER LAUNDRIES, FAMILY AND COMMERCIAL", Category.CLASS),
        Classification("7212", "GARMENT PRESSING, AND AGENTS FOR LAUNDRIES AND DRYCLEANERS", Category.CLASS),
        Classification("7213", "LINEN SUPPLY", Category.CLASS),
        Classification("7215", "COIN-OPERATED LAUNDRIES AND DRYCLEANING", Category.CLASS),
        Classification("7216", "DRYCLEANING PLANTS, EXCEPT RUG CLEANING", Category.CLASS),
        Classification("7217", "CARPET AND UPHOLSTERY CLEANING", Category.CLASS),
        Classification("7218", "INDUSTRIAL LAUNDERERS", Category.CLASS),
        Classification("7219", "LAUNDRY AND GARMENT SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("722", "PHOTOGRAPHIC STUDIOS, PORTRAIT", Category.GROUP),
        Classification("7221", "PHOTOGRAPHIC STUDIOS, PORTRAIT", Category.CLASS),
        Classification("723", "BEAUTY SHOPS", Category.GROUP),
        Classification("7231", "BEAUTY SHOPS", Category.CLASS),
        Classification("724", "BARBER SHOPS", Category.GROUP),
        Classification("7241", "BARBER SHOPS", Category.CLASS),
        Classification("725", "SHOE REPAIR SHOPS AND SHOESHINE PARLORS", Category.GROUP),
        Classification("7251", "SHOE REPAIR SHOPS AND SHOESHINE PARLORS", Category.CLASS),
        Classification("726", "FUNERAL SERVICE AND CREMATORIES", Category.GROUP),
        Classification("7261", "FUNERAL SERVICE AND CREMATORIES", Category.CLASS),
        Classification("729", "MISCELLANEOUS PERSONAL SERVICES", Category.GROUP),
        Classification("7291", "TAX RETURN PREPARATION SERVICES", Category.CLASS),
        Classification("7299", "MISCELLANEOUS PERSONAL SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("73", "BUSINESS SERVICES", Category.DIVISION),
        Classification("731", "ADVERTISING", Category.GROUP),
        Classification("7311", "ADVERTISING AGENCIES", Category.CLASS),
        Classification("7312", "OUTDOOR ADVERTISING SERVICES", Category.CLASS),
        Classification("7313", "RADIO, TELEVISION, AND PUBLISHERS' ADVERTISING REPRESENTATIVES", Category.CLASS),
        Classification("7319", "ADVERTISING, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("732", "CONSUMER CREDIT REPORTING AGENCIES, MERCANTILE REPORTING AGENCIES", Category.GROUP),
        Classification("7322", "ADJUSTMENT AND COLLECTION SERVICES", Category.CLASS),
        Classification("7323", "CREDIT REPORTING SERVICES", Category.CLASS),
        Classification("733", "MAILING, REPRODUCTION, COMMERCIAL ART AND PHOTOGRAPHY, AND STENOGR", Category.GROUP),
        Classification("7331", "DIRECT MAIL ADVERTISING SERVICES", Category.CLASS),
        Classification("7334", "PHOTOCOPYING AND DUPLICATING SERVICES", Category.CLASS),
        Classification("7335", "COMMERCIAL PHOTOGRAPHY", Category.CLASS),
        Classification("7336", "COMMERCIAL ART AND GRAPHIC DESIGN", Category.CLASS),
        Classification("7338", "SECRETARIAL AND COURT REPORTING SERVICES", Category.CLASS),
        Classification("734", "SERVICES TO DWELLINGS AND OTHER BUILDINGS", Category.GROUP),
        Classification("7342", "DISINFECTING AND PEST CONTROL SERVICES", Category.CLASS),
        Classification("7349", "BUILDING CLEANING AND MAINTENANCE SERVICES, NOT ELSEWHERE CLASSIF", Category.CLASS),
        Classification("735", "MISCELLANEOUS EQUIPMENT RENTAL AND LEASING", Category.GROUP),
        Classification("7352", "MEDICAL EQUIPMENT RENTAL AND LEASING", Category.CLASS),
        Classification("7353", "HEAVY CONSTRUCTION EQUIPMENT RENTAL AND LEASING", Category.CLASS),
        Classification("7359", "EQUIPMENT RENTAL AND LEASING, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("736", "PERSONNEL SUPPLY SERVICES", Category.GROUP),
        Classification("7361", "EMPLOYMENT AGENCIES", Category.CLASS),
        Classification("7363", "HELP SUPPLY SERVICES", Category.CLASS),
        Classification("737", "COMPUTER PROGRAMMING, DATA PROCESSING, AND OTHER COMPUTER RELATED", Category.GROUP),
        Classification("7371", "COMPUTER PROGRAMMING SERVICES", Category.CLASS),
        Classification("7372", "PREPACKAGED SOFTWARE", Category.CLASS),
        Classification("7373", "COMPUTER INTEGRATED SYSTEMS DESIGN", Category.CLASS),
        Classification("7374", "COMPUTER PROCESSING AND DATA PREPARATION AND PROCESSING SERVICES", Category.CLASS),
        Classification("7375", "INFORMATION RETRIEVAL SERVICES", Category.CLASS),
        Classification("7376", "COMPUTER FACILITIES MANAGEMENT SERVICES", Category.CLASS),
        Classification("7377", "COMPUTER RENTAL AND LEASING", Category.CLASS),
        Classification("7378", "COMPUTER MAINTENANCE AND REPAIR", Category.CLASS),
        Classification("7379", "COMPUTER RELATED SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("738", "MISCELLANEOUS BUSINESS SERVICES", Category.GROUP),
        Classification("7381", "DETECTIVE, GUARD, AND ARMORED CAR SERVICES", Category.CLASS),
        Classification("7382", "SECURITY SYSTEMS SERVICES", Category.CLASS),
        Classification("7383", "NEWS SYNDICATES", Category.CLASS),
        Classification("7384", "PHOTOFINISHING LABORATORIES", Category.CLASS),
        Classification("7389", "BUSINESS SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("75", "AUTOMOTIVE REPAIR, SERVICES, AND PARKING", Category.DIVISION),
        Classification("751", "AUTOMOTIVE RENTAL AND LEASING, WITHOUT DRIVERS", Category.GROUP),
        Classification("7513", "TRUCK RENTAL AND LEASING, WITHOUT DRIVERS", Category.CLASS),
        Classification("7514", "PASSENGER CAR RENTAL", Category.CLASS),
        Classification("7515", "PASSENGER CAR LEASING", Category.CLASS),
        Classification("7519", "UTILITY TRAILER AND RECREATIONAL VEHICLE RENTAL", Category.CLASS),
        Classification("752", "AUTOMOBILE PARKING", Category.GROUP),
        Classification("7521", "AUTOMOBILE PARKING", Category.CLASS),
        Classification("753", "AUTOMOTIVE REPAIR SHOPS", Category.GROUP),
        Classification("7532", "TOP, BODY, AND UPHOLSTERY REPAIR SHOPS AND PAINT SHOPS", Category.CLASS),
        Classification("7533", "AUTOMOTIVE EXHAUST SYSTEM REPAIR SHOPS", Category.CLASS),
        Classification("7534", "TIRE RETREADING AND REPAIR SHOPS", Category.CLASS),
        Classification("7536", "AUTOMOTIVE GLASS REPLACEMENT SHOPS", Category.CLASS),
        Classification("7537", "AUTOMOTIVE TRANSMISSION REPAIR SHOPS", Category.CLASS),
        Classification("7538", "GENERAL AUTOMOTIVE REPAIR SHOPS", Category.CLASS),
        Classification("7539", "AUTOMOTIVE REPAIR SHOPS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("754", "AUTOMOTIVE SERVICES, EXCEPT REPAIR", Category.GROUP),
        Classification("7542", "CARWASHES", Category.CLASS),
        Classification("7549", "AUTOMOTIVE SERVICES, EXCEPT REPAIR AND CARWASHES", Category.CLASS),
        Classification("76", "MISCELLANEOUS REPAIR SERVICES", Category.DIVISION),
        Classification("762", "ELECTRICAL REPAIR SHOPS", Category.GROUP),
        Classification("7622", "RADIO AND TELEVISION REPAIR SHOPS", Category.CLASS),
        Classification("7623", "REFRIGERATION AND AIR-CONDITIONING SERVICE AND REPAIR SHOPS", Category.CLASS),
        Classification("7629", "ELECTRICAL AND ELECTRONIC REPAIR SHOPS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("763", "WATCH, CLOCK, AND JEWELRY REPAIR", Category.GROUP),
        Classification("7631", "WATCH, CLOCK, AND JEWELRY REPAIR", Category.CLASS),
        Classification("764", "REUPHOLSTERY AND FURNITURE REPAIR", Category.GROUP),
        Classification("7641", "REUPHOLSTERY AND FURNITURE REPAIR", Category.CLASS),
        Classification("769", "MISCELLANEOUS REPAIR SHOPS AND RELATED SERVICES", Category.GROUP),
        Classification("7692", "WELDING REPAIR", Category.CLASS),
        Classification("7694", "ARMATURE REWINDING SHOPS", Category.CLASS),
        Classification("7699", "REPAIR SHOPS AND RELATED SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("78", "MOTION PICTURES", Category.DIVISION),
        Classification("781", "MOTION PICTURE PRODUCTION AND ALLIED SERVICES", Category.GROUP),
        Classification("7812", "MOTION PICTURE AND VIDEO TAPE PRODUCTION", Category.CLASS),
        Classification("7819", "SERVICES ALLIED TO MOTION PICTURE PRODUCTION", Category.CLASS),
        Classification("782", "MOTION PICTURE DISTRIBUTION AND ALLIED SERVICES", Category.GROUP),
        Classification("7822", "MOTION PICTURE AND VIDEO TAPE DISTRIBUTION", Category.CLASS),
        Classification("7829", "SERVICES ALLIED TO MOTION PICTURE DISTRIBUTION", Category.CLASS),
        Classification("783", "MOTION PICTURE THEATERS", Category.GROUP),
        Classification("7832", "MOTION PICTURE THEATERS, EXCEPT DRIVE-IN", Category.CLASS),
        Classification("7833", "DRIVE-IN MOTION PICTURE THEATERS", Category.CLASS),
        Classification("784", "VIDEO TAPE RENTAL", Category.GROUP),
        Classification("7841", "VIDEO TAPE RENTAL", Category.CLASS),
        Classification("79", "AMUSEMENT AND RECREATION SERVICES", Category.DIVISION),
        Classification("791", "DANCE STUDIOS, SCHOOLS, AND HALLS", Category.GROUP),
        Classification("7911", "DANCE STUDIOS, SCHOOLS, AND HALLS", Category.CLASS),
        Classification("792", "THEATRICAL PRODUCERS (EXCEPT MOTION PICTURE), BANDS, ORCHESTRAS, A", Category.GROUP),
        Classification("7922", "THEATRICAL PRODUCERS (EXCEPT MOTION PICTURE) AND MISCELLANEOUS TH", Category.CLASS),
        Classification("7929", "BANDS, ORCHESTRAS, ACTORS, AND OTHER ENTERTAINERS AND ENTERTAINME", Category.CLASS),
        Classification("793", "BOWLING CENTERS", Category.GROUP),
        Classification("7933", "BOWLING CENTERS", Category.CLASS),
        Classification("794", "COMMERCIAL SPORTS", Category.GROUP),
        Classification("7941", "PROFESSIONAL SPORTS CLUBS AND PROMOTERS", Category.CLASS),
        Classification("7948", "RACING, INCLUDING TRACK OPERATION", Category.CLASS),
        Classification("799", "MISCELLANEOUS AMUSEMENT AND RECREATION SERVICES", Category.GROUP),
        Classification("7991", "PHYSICAL FITNESS FACILITIES", Category.CLASS),
        Classification("7992", "PUBLIC GOLF COURSES", Category.CLASS),
        Classification("7993", "COIN-OPERATED AMUSEMENT DEVICES", Category.CLASS),
        Classification("7996", "AMUSEMENT PARKS", Category.CLASS),
        Classification("7997", "MEMBERSHIP SPORTS AND RECREATION CLUBS", Category.CLASS),
        Classification("7999", "AMUSEMENT AND RECREATION SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("80", "HEALTH SERVICES", Category.DIVISION),
        Classification("801", "OFFICES AND CLINICS OF DOCTORS OF MEDICINE", Category.GROUP),
        Classification("8011", "OFFICES AND CLINICS OF DOCTORS OF MEDICINE", Category.CLASS),
        Classification("802", "OFFICES AND CLINICS OF DENTISTS", Category.GROUP),
        Classification("8021", "OFFICES AND CLINICS OF DENTISTS", Category.CLASS),
        Classification("803", "OFFICES AND CLINICS OF DOCTORS OF OSTEOPATHY", Category.GROUP),
        Classification("8031", "OFFICES AND CLINICS OF DOCTORS OF OSTEOPATHY", Category.CLASS),
        Classification("804", "OFFICES AND CLINICS OF OTHER HEALTH PRACTITIONERS", Category.GROUP),
        Classification("8041", "OFFICES AND CLINICS OF CHIROPRACTORS", Category.CLASS),
        Classification("8042", "OFFICES AND CLINICS OF OPTOMETRISTS", Category.CLASS),
        Classification("8043", "OFFICES AND CLINICS OF PODIATRISTS", Category.CLASS),
        Classification("8049", "OFFICES AND CLINICS OF HEALTH PRACTITIONERS, NOT ELSEWHERE CLASSI", Category.CLASS),
        Classification("805", "NURSING AND PERSONAL CARE FACILITIES", Category.GROUP),
        Classification("8051", "SKILLED NURSING CARE FACILITIES", Category.CLASS),
        Classification("8052", "INTERMEDIATE CARE FACILITIES", Category.CLASS),
        Classification("8059", "NURSING AND PERSONAL CARE FACILITIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("806", "HOSPITALS", Category.GROUP),
        Classification("8062", "GENERAL MEDICAL AND SURGICAL HOSPITALS", Category.CLASS),
        Classification("8063", "PSYCHIATRIC HOSPITALS", Category.CLASS),
        Classification("8069", "SPECIALTY HOSPITALS, EXCEPT PSYCHIATRIC", Category.CLASS),
        Classification("807", "MEDICAL AND DENTAL LABORATORIES", Category.GROUP),
        Classification("8071", "MEDICAL LABORATORIES", Category.CLASS),
        Classification("8072", "DENTAL LABORATORIES", Category.CLASS),
        Classification("808", "HOME HEALTH CARE SERVICES", Category.GROUP),
        Classification("8082", "HOME HEALTH CARE SERVICES", Category.CLASS),
        Classification("809", "MISCELLANEOUS HEALTH AND ALLIED SERVICES, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("8092", "KIDNEY DIALYSIS CENTERS", Category.CLASS),
        Classification("8093", "SPECIALTY OUTPATIENT FACILITIES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("8099", "HEALTH AND ALLIED SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("81", "LEGAL SERVICES", Category.DIVISION),
        Classification("811", "LEGAL SERVICES", Category.GROUP),
        Classification("8111", "LEGAL SERVICES", Category.CLASS),
        Classification("82", "EDUCATIONAL SERVICES", Category.DIVISION),
        Classification("821", "ELEMENTARY AND SECONDARY SCHOOLS", Category.GROUP),
        Classification("8211", "ELEMENTARY AND SECONDARY SCHOOLS", Category.CLASS),
        Classification("822", "COLLEGES, UNIVERSITIES, PROFESSIONAL SCHOOLS, AND JUNIOR COLLEGES", Category.GROUP),
        Classification("8221", "COLLEGES, UNIVERSITIES, AND PROFESSIONAL SCHOOLS", Category.CLASS),
        Classification("8222", "JUNIOR COLLEGES AND TECHNICAL INSTITUTES", Category.CLASS),
        Classification("823", "LIBRARIES", Category.GROUP),
        Classification("8231", "LIBRARIES", Category.CLASS),
        Classification("824", "VOCATIONAL SCHOOLS", Category.GROUP),
        Classification("8243", "DATA PROCESSING SCHOOLS", Category.CLASS),
        Classification("8244", "BUSINESS AND SECRETARIAL SCHOOLS", Category.CLASS),
        Classification("8249", "VOCATIONAL SCHOOLS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("829", "SCHOOLS AND EDUCATIONAL SERVICES, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("8299", "SCHOOLS AND EDUCATIONAL SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("83", "SOCIAL SERVICES", Category.DIVISION),
        Classification("832", "INDIVIDUAL AND FAMILY SOCIAL SERVICES", Category.GROUP),
        Classification("8322", "INDIVIDUAL AND FAMILY SOCIAL SERVICES", Category.CLASS),
        Classification("833", "JOB TRAINING AND VOCATIONAL REHABILITATION SERVICES", Category.GROUP),
        Classification("8331", "JOB TRAINING AND VOCATIONAL REHABILITATION SERVICES", Category.CLASS),
        Classification("835", "CHILD DAY CARE SERVICES", Category.GROUP),
        Classification("8351", "CHILD DAY CARE SERVICES", Category.CLASS),
        Classification("836", "RESIDENTIAL CARE", Category.GROUP),
        Classification("8361", "RESIDENTIAL CARE", Category.CLASS),
        Classification("839", "SOCIAL SERVICES, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("8399", "SOCIAL SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("84", "MUSEUMS, ART GALLERIES, AND BOTANICAL AND ZOOLOGICAL GARDENS", Category.DIVISION),
        Classification("841", "MUSEUMS AND ART GALLERIES", Category.GROUP),
        Classification("8412", "MUSEUMS AND ART GALLERIES", Category.CLASS),
        Classification("842", "ARBORETA AND BOTANICAL OR ZOOLOGICAL GARDENS", Category.GROUP),
        Classification("8422", "ARBORETA AND BOTANICAL OR ZOOLOGICAL GARDENS", Category.CLASS),
        Classification("86", "MEMBERSHIP ORGANIZATIONS", Category.DIVISION),
        Classification("861", "BUSINESS ASSOCIATIONS", Category.GROUP),
        Classification("8611", "BUSINESS ASSOCIATIONS", Category.CLASS),
        Classification("862", "PROFESSIONAL MEMBERSHIP ORGANIZATIONS", Category.GROUP),
        Classification("8621", "PROFESSIONAL MEMBERSHIP ORGANIZATIONS", Category.CLASS),
        Classification("863", "LABOR UNIONS AND SIMILAR LABOR ORGANIZATIONS", Category.GROUP),
        Classification("8631", "LABOR UNIONS AND SIMILAR LABOR ORGANIZATIONS", Category.CLASS),
        Classification("864", "CIVIC, SOCIAL, AND FRATERNAL ASSOCIATIONS", Category.GROUP),
        Classification("8641", "CIVIC, SOCIAL, AND FRATERNAL ASSOCIATIONS", Category.CLASS),
        Classification("865", "POLITICAL ORGANIZATIONS", Category.GROUP),
        Classification("8651", "POLITICAL ORGANIZATIONS", Category.CLASS),
        Classification("866", "RELIGIOUS ORGANIZATIONS", Category.GROUP),
        Classification("8661", "RELIGIOUS ORGANIZATIONS", Category.CLASS),
        Classification("869", "MEMBERSHIP ORGANIZATIONS, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("8699", "MEMBERSHIP ORGANIZATIONS, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("87", "ENGINEERING, ACCOUNTING, RESEARCH, MANAGEMENT, AND RELATED SERVICES", Category.DIVISION),
        Classification("871", "ENGINEERING, ARCHITECTURAL, AND SURVEYING SERVICES", Category.GROUP),
        Classification("8711", "ENGINEERING SERVICES", Category.CLASS),
        Classification("8712", "ARCHITECTURAL SERVICES", Category.CLASS),
        Classification("8713", "SURVEYING SERVICES", Category.CLASS),
        Classification("872", "ACCOUNTING, AUDITING, AND BOOKKEEPING SERVICES", Category.GROUP),
        Classification("8721", "ACCOUNTING, AUDITING, AND BOOKKEEPING SERVICES", Category.CLASS),
        Classification("873", "RESEARCH, DEVELOPMENT, AND TESTING SERVICES", Category.GROUP),
        Classification("8731", "COMMERCIAL PHYSICAL AND BIOLOGICAL RESEARCH", Category.CLASS),
        Classification("8732", "COMMERCIAL ECONOMIC, SOCIOLOGICAL, AND EDUCATIONAL RESEARCH", Category.CLASS),
        Classification("8733", "NONCOMMERCIAL RESEARCH ORGANIZATIONS", Category.CLASS),
        Classification("8734", "TESTING LABORATORIES", Category.CLASS),
        Classification("874", "MANAGEMENT AND PUBLIC RELATIONS SERVICES", Category.GROUP),
        Classification("8741", "MANAGEMENT SERVICES", Category.CLASS),
        Classification("8742", "MANAGEMENT CONSULTING SERVICES", Category.CLASS),
        Classification("8743", "PUBLIC RELATIONS SERVICES", Category.CLASS),
        Classification("8744", "FACILITIES SUPPORT MANAGEMENT SERVICES", Category.CLASS),
        Classification("8748", "BUSINESS CONSULTING SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("88", "PRIVATE HOUSEHOLDS", Category.DIVISION),
        Classification("881", "PRIVATE HOUSEHOLDS", Category.GROUP),
        Classification("8811", "PRIVATE HOUSEHOLDS", Category.CLASS),
        Classification("89", "SERVICES, NOT ELSEWHERE CLASSIFIED", Category.DIVISION),
        Classification("899", "SERVICES, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("8999", "SERVICES, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("J", "PUBLIC ADMINISTRATION", Category.SECTION),
        Classification("91", "EXECUTIVE, LEGISLATIVE, AND GENERAL GOVERNMENT, EXCEPT FINANCE", Category.DIVISION),
        Classification("911", "EXECUTIVE OFFICES", Category.GROUP),
        Classification("9111", "EXECUTIVE OFFICES", Category.CLASS),
        Classification("912", "LEGISLATIVE BODIES", Category.GROUP),
        Classification("9121", "LEGISLATIVE BODIES", Category.CLASS),
        Classification("913", "EXECUTIVE AND LEGISLATIVE OFFICES COMBINED", Category.GROUP),
        Classification("9131", "EXECUTIVE AND LEGISLATIVE OFFICES COMBINED", Category.CLASS),
        Classification("919", "GENERAL GOVERNMENT, NOT ELSEWHERE CLASSIFIED", Category.GROUP),
        Classification("9199", "GENERAL GOVERNMENT, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("92", "JUSTICE, PUBLIC ORDER, AND SAFETY", Category.DIVISION),
        Classification("921", "COURTS", Category.GROUP),
        Classification("9211", "COURTS", Category.CLASS),
        Classification("922", "PUBLIC ORDER AND SAFETY", Category.GROUP),
        Classification("9221", "POLICE PROTECTION", Category.CLASS),
        Classification("9222", "LEGAL COUNSEL AND PROSECUTION", Category.CLASS),
        Classification("9223", "CORRECTIONAL INSTITUTIONS", Category.CLASS),
        Classification("9224", "FIRE PROTECTION", Category.CLASS),
        Classification("9229", "PUBLIC ORDER AND SAFETY, NOT ELSEWHERE CLASSIFIED", Category.CLASS),
        Classification("93", "PUBLIC FINANCE, TAXATION, AND MONETARY POLICY", Category.DIVISION),
        Classification("931", "PUBLIC FINANCE, TAXATION, AND MONETARY POLICY", Category.GROUP),
        Classification("9311", "PUBLIC FINANCE, TAXATION, AND MONETARY POLICY", Category.CLASS),
        Classification("94", "ADMINISTRATION OF HUMAN RESOURCE PROGRAMS", Category.DIVISION),
        Classification("941", "ADMINISTRATION OF EDUCATIONAL PROGRAMS", Category.GROUP),
        Classification("9411", "ADMINISTRATION OF EDUCATIONAL PROGRAMS", Category.CLASS),
        Classification("943", "ADMINISTRATION OF PUBLIC HEALTH PROGRAMS", Category.GROUP),
        Classification("9431", "ADMINISTRATION OF PUBLIC HEALTH PROGRAMS", Category.CLASS),
        Classification("944", "ADMINISTRATION OF SOCIAL, HUMAN RESOURCE AND INCOME MAINTENANCE PR", Category.GROUP),
        Classification("9441", "ADMINISTRATION OF SOCIAL, HUMAN RESOURCE AND INCOME MAINTENANCE P", Category.CLASS),
        Classification("945", "ADMINISTRATION OF VETERANS' AFFAIRS, EXCEPT HEALTH AND INSURANCE", Category.GROUP),
        Classification("9451", "ADMINISTRATION OF VETERANS' AFFAIRS, EXCEPT HEALTH AND INSURANCE", Category.CLASS),
        Classification("95", "ADMINISTRATION OF ENVIRONMENTAL QUALITY AND HOUSING PROGRAMS", Category.DIVISION),
        Classification("951", "ADMINISTRATION OF ENVIRONMENTAL QUALITY PROGRAMS", Category.GROUP),
        Classification("9511", "AIR AND WATER RESOURCE AND SOLID WASTE MANAGEMENT", Category.CLASS),
        Classification("9512", "LAND, MINERAL, WILDLIFE, AND FOREST CONSERVATION", Category.CLASS),
        Classification("953", "ADMINISTRATION OF HOUSING AND URBAN DEVELOPMENT PROGRAMS", Category.GROUP),
        Classification("9531", "ADMINISTRATION OF HOUSING PROGRAMS", Category.CLASS),
        Classification("9532", "ADMINISTRATION OF URBAN PLANNING AND COMMUNITY AND RURAL DEVELOPM", Category.CLASS),
        Classification("96", "ADMINISTRATION OF ECONOMIC PROGRAMS", Category.DIVISION),
        Classification("961", "ADMINISTRATION OF GENERAL ECONOMIC PROGRAMS", Category.GROUP),
        Classification("9611", "ADMINISTRATION OF GENERAL ECONOMIC PROGRAMS", Category.CLASS),
        Classification("962", "REGULATION AND ADMINISTRATION OF TRANSPORTATION PROGRAMS", Category.GROUP),
        Classification("9621", "REGULATION AND ADMINISTRATION OF TRANSPORTATION PROGRAMS", Category.CLASS),
        Classification("963", "REGULATION AND ADMINISTRATION OF COMMUNICATIONS, ELECTRIC, GAS, AN", Category.GROUP),
        Classification("9631", "REGULATION AND ADMINISTRATION OF COMMUNICATIONS, ELECTRIC, GAS, A", Category.CLASS),
        Classification("964", "REGULATION OF AGRICULTURAL MARKETING AND COMMODITIES", Category.GROUP),
        Classification("9641", "REGULATION OF AGRICULTURAL MARKETING AND COMMODITIES", Category.CLASS),
        Classification("965", "REGULATION, LICENSING, AND INSPECTION OF MISCELLANEOUS COMMERCIAL", Category.GROUP),
        Classification("9651", "REGULATION, LICENSING, AND INSPECTION OF MISCELLANEOUS COMMERCIAL", Category.CLASS),
        Classification("966", "SPACE RESEARCH AND TECHNOLOGY", Category.GROUP),
        Classification("9661", "SPACE RESEARCH AND TECHNOLOGY", Category.CLASS),
        Classification("97", "NATIONAL SECURITY AND INTERNATIONAL AFFAIRS", Category.DIVISION),
        Classification("971", "NATIONAL SECURITY", Category.GROUP),
        Classification("9711", "NATIONAL SECURITY", Category.CLASS),
        Classification("972", "INTERNATIONAL AFFAIRS", Category.GROUP),
        Classification("9721", "INTERNATIONAL AFFAIRS", Category.CLASS),
        Classification("K", "NONCLASSIFIABLE ESTABLISHMENTS", Category.SECTION),
        Classification("99", "NONCLASSIFIABLE ESTABLISHMENTS", Category.DIVISION),
        Classification("999", "NONCLASSIFIABLE ESTABLISHMENTS", Category.GROUP),
        Classification("9999", "NONCLASSIFIABLE ESTABLISHMENTS", Category.CLASS),
    ],
)
