# -*- coding: utf-8 -*-
"""`Concordance between NAF2 and NACE2 <https://www.insee.fr/fr/information/2406147>`_.

NAF2 classes map directly to NACE2 codes and NAF2 subclasses map to corresponding classes in NACE2.

    - 01.11 -> 01.11
    - 01.11Z -> 01.11
"""
from ...types import Concordance, Standards
from ..nace2 import NACE2
from . import NAF2

NAF2_to_NACE2 = Concordance(
    src=NAF2,
    dst=NACE2,
    concordances=[
        ((Standards.NAF2, "A"), (Standards.NACE2, "A")),
        ((Standards.NAF2, "01"), (Standards.NACE2, "01")),
        ((Standards.NAF2, "01.1"), (Standards.NACE2, "01.1")),
        ((Standards.NAF2, "01.11"), (Standards.NACE2, "01.11")),
        ((Standards.NAF2, "01.11Z"), (Standards.NACE2, "01.11")),
        ((Standards.NAF2, "01.12"), (Standards.NACE2, "01.12")),
        ((Standards.NAF2, "01.12Z"), (Standards.NACE2, "01.12")),
        ((Standards.NAF2, "01.13"), (Standards.NACE2, "01.13")),
        ((Standards.NAF2, "01.13Z"), (Standards.NACE2, "01.13")),
        ((Standards.NAF2, "01.14"), (Standards.NACE2, "01.14")),
        ((Standards.NAF2, "01.14Z"), (Standards.NACE2, "01.14")),
        ((Standards.NAF2, "01.15"), (Standards.NACE2, "01.15")),
        ((Standards.NAF2, "01.15Z"), (Standards.NACE2, "01.15")),
        ((Standards.NAF2, "01.16"), (Standards.NACE2, "01.16")),
        ((Standards.NAF2, "01.16Z"), (Standards.NACE2, "01.16")),
        ((Standards.NAF2, "01.19"), (Standards.NACE2, "01.19")),
        ((Standards.NAF2, "01.19Z"), (Standards.NACE2, "01.19")),
        ((Standards.NAF2, "01.2"), (Standards.NACE2, "01.2")),
        ((Standards.NAF2, "01.21"), (Standards.NACE2, "01.21")),
        ((Standards.NAF2, "01.21Z"), (Standards.NACE2, "01.21")),
        ((Standards.NAF2, "01.22"), (Standards.NACE2, "01.22")),
        ((Standards.NAF2, "01.22Z"), (Standards.NACE2, "01.22")),
        ((Standards.NAF2, "01.23"), (Standards.NACE2, "01.23")),
        ((Standards.NAF2, "01.23Z"), (Standards.NACE2, "01.23")),
        ((Standards.NAF2, "01.24"), (Standards.NACE2, "01.24")),
        ((Standards.NAF2, "01.24Z"), (Standards.NACE2, "01.24")),
        ((Standards.NAF2, "01.25"), (Standards.NACE2, "01.25")),
        ((Standards.NAF2, "01.25Z"), (Standards.NACE2, "01.25")),
        ((Standards.NAF2, "01.26"), (Standards.NACE2, "01.26")),
        ((Standards.NAF2, "01.26Z"), (Standards.NACE2, "01.26")),
        ((Standards.NAF2, "01.27"), (Standards.NACE2, "01.27")),
        ((Standards.NAF2, "01.27Z"), (Standards.NACE2, "01.27")),
        ((Standards.NAF2, "01.28"), (Standards.NACE2, "01.28")),
        ((Standards.NAF2, "01.28Z"), (Standards.NACE2, "01.28")),
        ((Standards.NAF2, "01.29"), (Standards.NACE2, "01.29")),
        ((Standards.NAF2, "01.29Z"), (Standards.NACE2, "01.29")),
        ((Standards.NAF2, "01.3"), (Standards.NACE2, "01.3")),
        ((Standards.NAF2, "01.30"), (Standards.NACE2, "01.30")),
        ((Standards.NAF2, "01.30Z"), (Standards.NACE2, "01.30")),
        ((Standards.NAF2, "01.4"), (Standards.NACE2, "01.4")),
        ((Standards.NAF2, "01.41"), (Standards.NACE2, "01.41")),
        ((Standards.NAF2, "01.41Z"), (Standards.NACE2, "01.41")),
        ((Standards.NAF2, "01.42"), (Standards.NACE2, "01.42")),
        ((Standards.NAF2, "01.42Z"), (Standards.NACE2, "01.42")),
        ((Standards.NAF2, "01.43"), (Standards.NACE2, "01.43")),
        ((Standards.NAF2, "01.43Z"), (Standards.NACE2, "01.43")),
        ((Standards.NAF2, "01.44"), (Standards.NACE2, "01.44")),
        ((Standards.NAF2, "01.44Z"), (Standards.NACE2, "01.44")),
        ((Standards.NAF2, "01.45"), (Standards.NACE2, "01.45")),
        ((Standards.NAF2, "01.45Z"), (Standards.NACE2, "01.45")),
        ((Standards.NAF2, "01.46"), (Standards.NACE2, "01.46")),
        ((Standards.NAF2, "01.46Z"), (Standards.NACE2, "01.46")),
        ((Standards.NAF2, "01.47"), (Standards.NACE2, "01.47")),
        ((Standards.NAF2, "01.47Z"), (Standards.NACE2, "01.47")),
        ((Standards.NAF2, "01.49"), (Standards.NACE2, "01.49")),
        ((Standards.NAF2, "01.49Z"), (Standards.NACE2, "01.49")),
        ((Standards.NAF2, "01.5"), (Standards.NACE2, "01.5")),
        ((Standards.NAF2, "01.50"), (Standards.NACE2, "01.50")),
        ((Standards.NAF2, "01.50Z"), (Standards.NACE2, "01.50")),
        ((Standards.NAF2, "01.6"), (Standards.NACE2, "01.6")),
        ((Standards.NAF2, "01.61"), (Standards.NACE2, "01.61")),
        ((Standards.NAF2, "01.61Z"), (Standards.NACE2, "01.61")),
        ((Standards.NAF2, "01.62"), (Standards.NACE2, "01.62")),
        ((Standards.NAF2, "01.62Z"), (Standards.NACE2, "01.62")),
        ((Standards.NAF2, "01.63"), (Standards.NACE2, "01.63")),
        ((Standards.NAF2, "01.63Z"), (Standards.NACE2, "01.63")),
        ((Standards.NAF2, "01.64"), (Standards.NACE2, "01.64")),
        ((Standards.NAF2, "01.64Z"), (Standards.NACE2, "01.64")),
        ((Standards.NAF2, "01.7"), (Standards.NACE2, "01.7")),
        ((Standards.NAF2, "01.70"), (Standards.NACE2, "01.70")),
        ((Standards.NAF2, "01.70Z"), (Standards.NACE2, "01.70")),
        ((Standards.NAF2, "02"), (Standards.NACE2, "02")),
        ((Standards.NAF2, "02.1"), (Standards.NACE2, "02.1")),
        ((Standards.NAF2, "02.10"), (Standards.NACE2, "02.10")),
        ((Standards.NAF2, "02.10Z"), (Standards.NACE2, "02.10")),
        ((Standards.NAF2, "02.2"), (Standards.NACE2, "02.2")),
        ((Standards.NAF2, "02.20"), (Standards.NACE2, "02.20")),
        ((Standards.NAF2, "02.20Z"), (Standards.NACE2, "02.20")),
        ((Standards.NAF2, "02.3"), (Standards.NACE2, "02.3")),
        ((Standards.NAF2, "02.30"), (Standards.NACE2, "02.30")),
        ((Standards.NAF2, "02.30Z"), (Standards.NACE2, "02.30")),
        ((Standards.NAF2, "02.4"), (Standards.NACE2, "02.4")),
        ((Standards.NAF2, "02.40"), (Standards.NACE2, "02.40")),
        ((Standards.NAF2, "02.40Z"), (Standards.NACE2, "02.40")),
        ((Standards.NAF2, "03"), (Standards.NACE2, "03")),
        ((Standards.NAF2, "03.1"), (Standards.NACE2, "03.1")),
        ((Standards.NAF2, "03.11"), (Standards.NACE2, "03.11")),
        ((Standards.NAF2, "03.11Z"), (Standards.NACE2, "03.11")),
        ((Standards.NAF2, "03.12"), (Standards.NACE2, "03.12")),
        ((Standards.NAF2, "03.12Z"), (Standards.NACE2, "03.12")),
        ((Standards.NAF2, "03.2"), (Standards.NACE2, "03.2")),
        ((Standards.NAF2, "03.21"), (Standards.NACE2, "03.21")),
        ((Standards.NAF2, "03.21Z"), (Standards.NACE2, "03.21")),
        ((Standards.NAF2, "03.22"), (Standards.NACE2, "03.22")),
        ((Standards.NAF2, "03.22Z"), (Standards.NACE2, "03.22")),
        ((Standards.NAF2, "B"), (Standards.NACE2, "B")),
        ((Standards.NAF2, "05"), (Standards.NACE2, "05")),
        ((Standards.NAF2, "05.1"), (Standards.NACE2, "05.1")),
        ((Standards.NAF2, "05.10"), (Standards.NACE2, "05.10")),
        ((Standards.NAF2, "05.10Z"), (Standards.NACE2, "05.10")),
        ((Standards.NAF2, "05.2"), (Standards.NACE2, "05.2")),
        ((Standards.NAF2, "05.20"), (Standards.NACE2, "05.20")),
        ((Standards.NAF2, "05.20Z"), (Standards.NACE2, "05.20")),
        ((Standards.NAF2, "06"), (Standards.NACE2, "06")),
        ((Standards.NAF2, "06.1"), (Standards.NACE2, "06.1")),
        ((Standards.NAF2, "06.10"), (Standards.NACE2, "06.10")),
        ((Standards.NAF2, "06.10Z"), (Standards.NACE2, "06.10")),
        ((Standards.NAF2, "06.2"), (Standards.NACE2, "06.2")),
        ((Standards.NAF2, "06.20"), (Standards.NACE2, "06.20")),
        ((Standards.NAF2, "06.20Z"), (Standards.NACE2, "06.20")),
        ((Standards.NAF2, "07"), (Standards.NACE2, "07")),
        ((Standards.NAF2, "07.1"), (Standards.NACE2, "07.1")),
        ((Standards.NAF2, "07.10"), (Standards.NACE2, "07.10")),
        ((Standards.NAF2, "07.10Z"), (Standards.NACE2, "07.10")),
        ((Standards.NAF2, "07.2"), (Standards.NACE2, "07.2")),
        ((Standards.NAF2, "07.21"), (Standards.NACE2, "07.21")),
        ((Standards.NAF2, "07.21Z"), (Standards.NACE2, "07.21")),
        ((Standards.NAF2, "07.29"), (Standards.NACE2, "07.29")),
        ((Standards.NAF2, "07.29Z"), (Standards.NACE2, "07.29")),
        ((Standards.NAF2, "08"), (Standards.NACE2, "08")),
        ((Standards.NAF2, "08.1"), (Standards.NACE2, "08.1")),
        ((Standards.NAF2, "08.11"), (Standards.NACE2, "08.11")),
        ((Standards.NAF2, "08.11Z"), (Standards.NACE2, "08.11")),
        ((Standards.NAF2, "08.12"), (Standards.NACE2, "08.12")),
        ((Standards.NAF2, "08.12Z"), (Standards.NACE2, "08.12")),
        ((Standards.NAF2, "08.9"), (Standards.NACE2, "08.9")),
        ((Standards.NAF2, "08.91"), (Standards.NACE2, "08.91")),
        ((Standards.NAF2, "08.91Z"), (Standards.NACE2, "08.91")),
        ((Standards.NAF2, "08.92"), (Standards.NACE2, "08.92")),
        ((Standards.NAF2, "08.92Z"), (Standards.NACE2, "08.92")),
        ((Standards.NAF2, "08.93"), (Standards.NACE2, "08.93")),
        ((Standards.NAF2, "08.93Z"), (Standards.NACE2, "08.93")),
        ((Standards.NAF2, "08.99"), (Standards.NACE2, "08.99")),
        ((Standards.NAF2, "08.99Z"), (Standards.NACE2, "08.99")),
        ((Standards.NAF2, "09"), (Standards.NACE2, "09")),
        ((Standards.NAF2, "09.1"), (Standards.NACE2, "09.1")),
        ((Standards.NAF2, "09.10"), (Standards.NACE2, "09.10")),
        ((Standards.NAF2, "09.10Z"), (Standards.NACE2, "09.10")),
        ((Standards.NAF2, "09.9"), (Standards.NACE2, "09.9")),
        ((Standards.NAF2, "09.90"), (Standards.NACE2, "09.90")),
        ((Standards.NAF2, "09.90Z"), (Standards.NACE2, "09.90")),
        ((Standards.NAF2, "C"), (Standards.NACE2, "C")),
        ((Standards.NAF2, "10"), (Standards.NACE2, "10")),
        ((Standards.NAF2, "10.1"), (Standards.NACE2, "10.1")),
        ((Standards.NAF2, "10.11"), (Standards.NACE2, "10.11")),
        ((Standards.NAF2, "10.11Z"), (Standards.NACE2, "10.11")),
        ((Standards.NAF2, "10.12"), (Standards.NACE2, "10.12")),
        ((Standards.NAF2, "10.12Z"), (Standards.NACE2, "10.12")),
        ((Standards.NAF2, "10.13"), (Standards.NACE2, "10.13")),
        ((Standards.NAF2, "10.13A"), (Standards.NACE2, "10.13")),
        ((Standards.NAF2, "10.13B"), (Standards.NACE2, "10.13")),
        ((Standards.NAF2, "10.2"), (Standards.NACE2, "10.2")),
        ((Standards.NAF2, "10.20"), (Standards.NACE2, "10.20")),
        ((Standards.NAF2, "10.20Z"), (Standards.NACE2, "10.20")),
        ((Standards.NAF2, "10.3"), (Standards.NACE2, "10.3")),
        ((Standards.NAF2, "10.31"), (Standards.NACE2, "10.31")),
        ((Standards.NAF2, "10.31Z"), (Standards.NACE2, "10.31")),
        ((Standards.NAF2, "10.32"), (Standards.NACE2, "10.32")),
        ((Standards.NAF2, "10.32Z"), (Standards.NACE2, "10.32")),
        ((Standards.NAF2, "10.39"), (Standards.NACE2, "10.39")),
        ((Standards.NAF2, "10.39A"), (Standards.NACE2, "10.39")),
        ((Standards.NAF2, "10.39B"), (Standards.NACE2, "10.39")),
        ((Standards.NAF2, "10.4"), (Standards.NACE2, "10.4")),
        ((Standards.NAF2, "10.41"), (Standards.NACE2, "10.41")),
        ((Standards.NAF2, "10.41A"), (Standards.NACE2, "10.41")),
        ((Standards.NAF2, "10.41B"), (Standards.NACE2, "10.41")),
        ((Standards.NAF2, "10.42"), (Standards.NACE2, "10.42")),
        ((Standards.NAF2, "10.42Z"), (Standards.NACE2, "10.42")),
        ((Standards.NAF2, "10.5"), (Standards.NACE2, "10.5")),
        ((Standards.NAF2, "10.51"), (Standards.NACE2, "10.51")),
        ((Standards.NAF2, "10.51A"), (Standards.NACE2, "10.51")),
        ((Standards.NAF2, "10.51B"), (Standards.NACE2, "10.51")),
        ((Standards.NAF2, "10.51C"), (Standards.NACE2, "10.51")),
        ((Standards.NAF2, "10.51D"), (Standards.NACE2, "10.51")),
        ((Standards.NAF2, "10.52"), (Standards.NACE2, "10.52")),
        ((Standards.NAF2, "10.52Z"), (Standards.NACE2, "10.52")),
        ((Standards.NAF2, "10.6"), (Standards.NACE2, "10.6")),
        ((Standards.NAF2, "10.61"), (Standards.NACE2, "10.61")),
        ((Standards.NAF2, "10.61A"), (Standards.NACE2, "10.61")),
        ((Standards.NAF2, "10.61B"), (Standards.NACE2, "10.61")),
        ((Standards.NAF2, "10.62"), (Standards.NACE2, "10.62")),
        ((Standards.NAF2, "10.62Z"), (Standards.NACE2, "10.62")),
        ((Standards.NAF2, "10.7"), (Standards.NACE2, "10.7")),
        ((Standards.NAF2, "10.71"), (Standards.NACE2, "10.71")),
        ((Standards.NAF2, "10.71A"), (Standards.NACE2, "10.71")),
        ((Standards.NAF2, "10.71B"), (Standards.NACE2, "10.71")),
        ((Standards.NAF2, "10.71C"), (Standards.NACE2, "10.71")),
        ((Standards.NAF2, "10.71D"), (Standards.NACE2, "10.71")),
        ((Standards.NAF2, "10.72"), (Standards.NACE2, "10.72")),
        ((Standards.NAF2, "10.72Z"), (Standards.NACE2, "10.72")),
        ((Standards.NAF2, "10.73"), (Standards.NACE2, "10.73")),
        ((Standards.NAF2, "10.73Z"), (Standards.NACE2, "10.73")),
        ((Standards.NAF2, "10.8"), (Standards.NACE2, "10.8")),
        ((Standards.NAF2, "10.81"), (Standards.NACE2, "10.81")),
        ((Standards.NAF2, "10.81Z"), (Standards.NACE2, "10.81")),
        ((Standards.NAF2, "10.82"), (Standards.NACE2, "10.82")),
        ((Standards.NAF2, "10.82Z"), (Standards.NACE2, "10.82")),
        ((Standards.NAF2, "10.83"), (Standards.NACE2, "10.83")),
        ((Standards.NAF2, "10.83Z"), (Standards.NACE2, "10.83")),
        ((Standards.NAF2, "10.84"), (Standards.NACE2, "10.84")),
        ((Standards.NAF2, "10.84Z"), (Standards.NACE2, "10.84")),
        ((Standards.NAF2, "10.85"), (Standards.NACE2, "10.85")),
        ((Standards.NAF2, "10.85Z"), (Standards.NACE2, "10.85")),
        ((Standards.NAF2, "10.86"), (Standards.NACE2, "10.86")),
        ((Standards.NAF2, "10.86Z"), (Standards.NACE2, "10.86")),
        ((Standards.NAF2, "10.89"), (Standards.NACE2, "10.89")),
        ((Standards.NAF2, "10.89Z"), (Standards.NACE2, "10.89")),
        ((Standards.NAF2, "10.9"), (Standards.NACE2, "10.9")),
        ((Standards.NAF2, "10.91"), (Standards.NACE2, "10.91")),
        ((Standards.NAF2, "10.91Z"), (Standards.NACE2, "10.91")),
        ((Standards.NAF2, "10.92"), (Standards.NACE2, "10.92")),
        ((Standards.NAF2, "10.92Z"), (Standards.NACE2, "10.92")),
        ((Standards.NAF2, "11"), (Standards.NACE2, "11")),
        ((Standards.NAF2, "11.0"), (Standards.NACE2, "11.0")),
        ((Standards.NAF2, "11.01"), (Standards.NACE2, "11.01")),
        ((Standards.NAF2, "11.01Z"), (Standards.NACE2, "11.01")),
        ((Standards.NAF2, "11.02"), (Standards.NACE2, "11.02")),
        ((Standards.NAF2, "11.02A"), (Standards.NACE2, "11.02")),
        ((Standards.NAF2, "11.02B"), (Standards.NACE2, "11.02")),
        ((Standards.NAF2, "11.03"), (Standards.NACE2, "11.03")),
        ((Standards.NAF2, "11.03Z"), (Standards.NACE2, "11.03")),
        ((Standards.NAF2, "11.04"), (Standards.NACE2, "11.04")),
        ((Standards.NAF2, "11.04Z"), (Standards.NACE2, "11.04")),
        ((Standards.NAF2, "11.05"), (Standards.NACE2, "11.05")),
        ((Standards.NAF2, "11.05Z"), (Standards.NACE2, "11.05")),
        ((Standards.NAF2, "11.06"), (Standards.NACE2, "11.06")),
        ((Standards.NAF2, "11.06Z"), (Standards.NACE2, "11.06")),
        ((Standards.NAF2, "11.07"), (Standards.NACE2, "11.07")),
        ((Standards.NAF2, "11.07A"), (Standards.NACE2, "11.07")),
        ((Standards.NAF2, "11.07B"), (Standards.NACE2, "11.07")),
        ((Standards.NAF2, "12"), (Standards.NACE2, "12")),
        ((Standards.NAF2, "12.0"), (Standards.NACE2, "12.0")),
        ((Standards.NAF2, "12.00"), (Standards.NACE2, "12.00")),
        ((Standards.NAF2, "12.00Z"), (Standards.NACE2, "12.00")),
        ((Standards.NAF2, "13"), (Standards.NACE2, "13")),
        ((Standards.NAF2, "13.1"), (Standards.NACE2, "13.1")),
        ((Standards.NAF2, "13.10"), (Standards.NACE2, "13.10")),
        ((Standards.NAF2, "13.10Z"), (Standards.NACE2, "13.10")),
        ((Standards.NAF2, "13.2"), (Standards.NACE2, "13.2")),
        ((Standards.NAF2, "13.20"), (Standards.NACE2, "13.20")),
        ((Standards.NAF2, "13.20Z"), (Standards.NACE2, "13.20")),
        ((Standards.NAF2, "13.3"), (Standards.NACE2, "13.3")),
        ((Standards.NAF2, "13.30"), (Standards.NACE2, "13.30")),
        ((Standards.NAF2, "13.30Z"), (Standards.NACE2, "13.30")),
        ((Standards.NAF2, "13.9"), (Standards.NACE2, "13.9")),
        ((Standards.NAF2, "13.91"), (Standards.NACE2, "13.91")),
        ((Standards.NAF2, "13.91Z"), (Standards.NACE2, "13.91")),
        ((Standards.NAF2, "13.92"), (Standards.NACE2, "13.92")),
        ((Standards.NAF2, "13.92Z"), (Standards.NACE2, "13.92")),
        ((Standards.NAF2, "13.93"), (Standards.NACE2, "13.93")),
        ((Standards.NAF2, "13.93Z"), (Standards.NACE2, "13.93")),
        ((Standards.NAF2, "13.94"), (Standards.NACE2, "13.94")),
        ((Standards.NAF2, "13.94Z"), (Standards.NACE2, "13.94")),
        ((Standards.NAF2, "13.95"), (Standards.NACE2, "13.95")),
        ((Standards.NAF2, "13.95Z"), (Standards.NACE2, "13.95")),
        ((Standards.NAF2, "13.96"), (Standards.NACE2, "13.96")),
        ((Standards.NAF2, "13.96Z"), (Standards.NACE2, "13.96")),
        ((Standards.NAF2, "13.99"), (Standards.NACE2, "13.99")),
        ((Standards.NAF2, "13.99Z"), (Standards.NACE2, "13.99")),
        ((Standards.NAF2, "14"), (Standards.NACE2, "14")),
        ((Standards.NAF2, "14.1"), (Standards.NACE2, "14.1")),
        ((Standards.NAF2, "14.11"), (Standards.NACE2, "14.11")),
        ((Standards.NAF2, "14.11Z"), (Standards.NACE2, "14.11")),
        ((Standards.NAF2, "14.12"), (Standards.NACE2, "14.12")),
        ((Standards.NAF2, "14.12Z"), (Standards.NACE2, "14.12")),
        ((Standards.NAF2, "14.13"), (Standards.NACE2, "14.13")),
        ((Standards.NAF2, "14.13Z"), (Standards.NACE2, "14.13")),
        ((Standards.NAF2, "14.14"), (Standards.NACE2, "14.14")),
        ((Standards.NAF2, "14.14Z"), (Standards.NACE2, "14.14")),
        ((Standards.NAF2, "14.19"), (Standards.NACE2, "14.19")),
        ((Standards.NAF2, "14.19Z"), (Standards.NACE2, "14.19")),
        ((Standards.NAF2, "14.2"), (Standards.NACE2, "14.2")),
        ((Standards.NAF2, "14.20"), (Standards.NACE2, "14.20")),
        ((Standards.NAF2, "14.20Z"), (Standards.NACE2, "14.20")),
        ((Standards.NAF2, "14.3"), (Standards.NACE2, "14.3")),
        ((Standards.NAF2, "14.31"), (Standards.NACE2, "14.31")),
        ((Standards.NAF2, "14.31Z"), (Standards.NACE2, "14.31")),
        ((Standards.NAF2, "14.39"), (Standards.NACE2, "14.39")),
        ((Standards.NAF2, "14.39Z"), (Standards.NACE2, "14.39")),
        ((Standards.NAF2, "15"), (Standards.NACE2, "15")),
        ((Standards.NAF2, "15.1"), (Standards.NACE2, "15.1")),
        ((Standards.NAF2, "15.11"), (Standards.NACE2, "15.11")),
        ((Standards.NAF2, "15.11Z"), (Standards.NACE2, "15.11")),
        ((Standards.NAF2, "15.12"), (Standards.NACE2, "15.12")),
        ((Standards.NAF2, "15.12Z"), (Standards.NACE2, "15.12")),
        ((Standards.NAF2, "15.2"), (Standards.NACE2, "15.2")),
        ((Standards.NAF2, "15.20"), (Standards.NACE2, "15.20")),
        ((Standards.NAF2, "15.20Z"), (Standards.NACE2, "15.20")),
        ((Standards.NAF2, "16"), (Standards.NACE2, "16")),
        ((Standards.NAF2, "16.1"), (Standards.NACE2, "16.1")),
        ((Standards.NAF2, "16.10"), (Standards.NACE2, "16.10")),
        ((Standards.NAF2, "16.10A"), (Standards.NACE2, "16.10")),
        ((Standards.NAF2, "16.10B"), (Standards.NACE2, "16.10")),
        ((Standards.NAF2, "16.2"), (Standards.NACE2, "16.2")),
        ((Standards.NAF2, "16.21"), (Standards.NACE2, "16.21")),
        ((Standards.NAF2, "16.21Z"), (Standards.NACE2, "16.21")),
        ((Standards.NAF2, "16.22"), (Standards.NACE2, "16.22")),
        ((Standards.NAF2, "16.22Z"), (Standards.NACE2, "16.22")),
        ((Standards.NAF2, "16.23"), (Standards.NACE2, "16.23")),
        ((Standards.NAF2, "16.23Z"), (Standards.NACE2, "16.23")),
        ((Standards.NAF2, "16.24"), (Standards.NACE2, "16.24")),
        ((Standards.NAF2, "16.24Z"), (Standards.NACE2, "16.24")),
        ((Standards.NAF2, "16.29"), (Standards.NACE2, "16.29")),
        ((Standards.NAF2, "16.29Z"), (Standards.NACE2, "16.29")),
        ((Standards.NAF2, "17"), (Standards.NACE2, "17")),
        ((Standards.NAF2, "17.1"), (Standards.NACE2, "17.1")),
        ((Standards.NAF2, "17.11"), (Standards.NACE2, "17.11")),
        ((Standards.NAF2, "17.11Z"), (Standards.NACE2, "17.11")),
        ((Standards.NAF2, "17.12"), (Standards.NACE2, "17.12")),
        ((Standards.NAF2, "17.12Z"), (Standards.NACE2, "17.12")),
        ((Standards.NAF2, "17.2"), (Standards.NACE2, "17.2")),
        ((Standards.NAF2, "17.21"), (Standards.NACE2, "17.21")),
        ((Standards.NAF2, "17.21A"), (Standards.NACE2, "17.21")),
        ((Standards.NAF2, "17.21B"), (Standards.NACE2, "17.21")),
        ((Standards.NAF2, "17.21C"), (Standards.NACE2, "17.21")),
        ((Standards.NAF2, "17.22"), (Standards.NACE2, "17.22")),
        ((Standards.NAF2, "17.22Z"), (Standards.NACE2, "17.22")),
        ((Standards.NAF2, "17.23"), (Standards.NACE2, "17.23")),
        ((Standards.NAF2, "17.23Z"), (Standards.NACE2, "17.23")),
        ((Standards.NAF2, "17.24"), (Standards.NACE2, "17.24")),
        ((Standards.NAF2, "17.24Z"), (Standards.NACE2, "17.24")),
        ((Standards.NAF2, "17.29"), (Standards.NACE2, "17.29")),
        ((Standards.NAF2, "17.29Z"), (Standards.NACE2, "17.29")),
        ((Standards.NAF2, "18"), (Standards.NACE2, "18")),
        ((Standards.NAF2, "18.1"), (Standards.NACE2, "18.1")),
        ((Standards.NAF2, "18.11"), (Standards.NACE2, "18.11")),
        ((Standards.NAF2, "18.11Z"), (Standards.NACE2, "18.11")),
        ((Standards.NAF2, "18.12"), (Standards.NACE2, "18.12")),
        ((Standards.NAF2, "18.12Z"), (Standards.NACE2, "18.12")),
        ((Standards.NAF2, "18.13"), (Standards.NACE2, "18.13")),
        ((Standards.NAF2, "18.13Z"), (Standards.NACE2, "18.13")),
        ((Standards.NAF2, "18.14"), (Standards.NACE2, "18.14")),
        ((Standards.NAF2, "18.14Z"), (Standards.NACE2, "18.14")),
        ((Standards.NAF2, "18.2"), (Standards.NACE2, "18.2")),
        ((Standards.NAF2, "18.20"), (Standards.NACE2, "18.20")),
        ((Standards.NAF2, "18.20Z"), (Standards.NACE2, "18.20")),
        ((Standards.NAF2, "19"), (Standards.NACE2, "19")),
        ((Standards.NAF2, "19.1"), (Standards.NACE2, "19.1")),
        ((Standards.NAF2, "19.10"), (Standards.NACE2, "19.10")),
        ((Standards.NAF2, "19.10Z"), (Standards.NACE2, "19.10")),
        ((Standards.NAF2, "19.2"), (Standards.NACE2, "19.2")),
        ((Standards.NAF2, "19.20"), (Standards.NACE2, "19.20")),
        ((Standards.NAF2, "19.20Z"), (Standards.NACE2, "19.20")),
        ((Standards.NAF2, "20"), (Standards.NACE2, "20")),
        ((Standards.NAF2, "20.1"), (Standards.NACE2, "20.1")),
        ((Standards.NAF2, "20.11"), (Standards.NACE2, "20.11")),
        ((Standards.NAF2, "20.11Z"), (Standards.NACE2, "20.11")),
        ((Standards.NAF2, "20.12"), (Standards.NACE2, "20.12")),
        ((Standards.NAF2, "20.12Z"), (Standards.NACE2, "20.12")),
        ((Standards.NAF2, "20.13"), (Standards.NACE2, "20.13")),
        ((Standards.NAF2, "20.13A"), (Standards.NACE2, "20.13")),
        ((Standards.NAF2, "20.13B"), (Standards.NACE2, "20.13")),
        ((Standards.NAF2, "20.14"), (Standards.NACE2, "20.14")),
        ((Standards.NAF2, "20.14Z"), (Standards.NACE2, "20.14")),
        ((Standards.NAF2, "20.15"), (Standards.NACE2, "20.15")),
        ((Standards.NAF2, "20.15Z"), (Standards.NACE2, "20.15")),
        ((Standards.NAF2, "20.16"), (Standards.NACE2, "20.16")),
        ((Standards.NAF2, "20.16Z"), (Standards.NACE2, "20.16")),
        ((Standards.NAF2, "20.17"), (Standards.NACE2, "20.17")),
        ((Standards.NAF2, "20.17Z"), (Standards.NACE2, "20.17")),
        ((Standards.NAF2, "20.2"), (Standards.NACE2, "20.2")),
        ((Standards.NAF2, "20.20"), (Standards.NACE2, "20.20")),
        ((Standards.NAF2, "20.20Z"), (Standards.NACE2, "20.20")),
        ((Standards.NAF2, "20.3"), (Standards.NACE2, "20.3")),
        ((Standards.NAF2, "20.30"), (Standards.NACE2, "20.30")),
        ((Standards.NAF2, "20.30Z"), (Standards.NACE2, "20.30")),
        ((Standards.NAF2, "20.4"), (Standards.NACE2, "20.4")),
        ((Standards.NAF2, "20.41"), (Standards.NACE2, "20.41")),
        ((Standards.NAF2, "20.41Z"), (Standards.NACE2, "20.41")),
        ((Standards.NAF2, "20.42"), (Standards.NACE2, "20.42")),
        ((Standards.NAF2, "20.42Z"), (Standards.NACE2, "20.42")),
        ((Standards.NAF2, "20.5"), (Standards.NACE2, "20.5")),
        ((Standards.NAF2, "20.51"), (Standards.NACE2, "20.51")),
        ((Standards.NAF2, "20.51Z"), (Standards.NACE2, "20.51")),
        ((Standards.NAF2, "20.52"), (Standards.NACE2, "20.52")),
        ((Standards.NAF2, "20.52Z"), (Standards.NACE2, "20.52")),
        ((Standards.NAF2, "20.53"), (Standards.NACE2, "20.53")),
        ((Standards.NAF2, "20.53Z"), (Standards.NACE2, "20.53")),
        ((Standards.NAF2, "20.59"), (Standards.NACE2, "20.59")),
        ((Standards.NAF2, "20.59Z"), (Standards.NACE2, "20.59")),
        ((Standards.NAF2, "20.6"), (Standards.NACE2, "20.6")),
        ((Standards.NAF2, "20.60"), (Standards.NACE2, "20.60")),
        ((Standards.NAF2, "20.60Z"), (Standards.NACE2, "20.60")),
        ((Standards.NAF2, "21"), (Standards.NACE2, "21")),
        ((Standards.NAF2, "21.1"), (Standards.NACE2, "21.1")),
        ((Standards.NAF2, "21.10"), (Standards.NACE2, "21.10")),
        ((Standards.NAF2, "21.10Z"), (Standards.NACE2, "21.10")),
        ((Standards.NAF2, "21.2"), (Standards.NACE2, "21.2")),
        ((Standards.NAF2, "21.20"), (Standards.NACE2, "21.20")),
        ((Standards.NAF2, "21.20Z"), (Standards.NACE2, "21.20")),
        ((Standards.NAF2, "22"), (Standards.NACE2, "22")),
        ((Standards.NAF2, "22.1"), (Standards.NACE2, "22.1")),
        ((Standards.NAF2, "22.11"), (Standards.NACE2, "22.11")),
        ((Standards.NAF2, "22.11Z"), (Standards.NACE2, "22.11")),
        ((Standards.NAF2, "22.19"), (Standards.NACE2, "22.19")),
        ((Standards.NAF2, "22.19Z"), (Standards.NACE2, "22.19")),
        ((Standards.NAF2, "22.2"), (Standards.NACE2, "22.2")),
        ((Standards.NAF2, "22.21"), (Standards.NACE2, "22.21")),
        ((Standards.NAF2, "22.21Z"), (Standards.NACE2, "22.21")),
        ((Standards.NAF2, "22.22"), (Standards.NACE2, "22.22")),
        ((Standards.NAF2, "22.22Z"), (Standards.NACE2, "22.22")),
        ((Standards.NAF2, "22.23"), (Standards.NACE2, "22.23")),
        ((Standards.NAF2, "22.23Z"), (Standards.NACE2, "22.23")),
        ((Standards.NAF2, "22.29"), (Standards.NACE2, "22.29")),
        ((Standards.NAF2, "22.29A"), (Standards.NACE2, "22.29")),
        ((Standards.NAF2, "22.29B"), (Standards.NACE2, "22.29")),
        ((Standards.NAF2, "23"), (Standards.NACE2, "23")),
        ((Standards.NAF2, "23.1"), (Standards.NACE2, "23.1")),
        ((Standards.NAF2, "23.11"), (Standards.NACE2, "23.11")),
        ((Standards.NAF2, "23.11Z"), (Standards.NACE2, "23.11")),
        ((Standards.NAF2, "23.12"), (Standards.NACE2, "23.12")),
        ((Standards.NAF2, "23.12Z"), (Standards.NACE2, "23.12")),
        ((Standards.NAF2, "23.13"), (Standards.NACE2, "23.13")),
        ((Standards.NAF2, "23.13Z"), (Standards.NACE2, "23.13")),
        ((Standards.NAF2, "23.14"), (Standards.NACE2, "23.14")),
        ((Standards.NAF2, "23.14Z"), (Standards.NACE2, "23.14")),
        ((Standards.NAF2, "23.19"), (Standards.NACE2, "23.19")),
        ((Standards.NAF2, "23.19Z"), (Standards.NACE2, "23.19")),
        ((Standards.NAF2, "23.2"), (Standards.NACE2, "23.2")),
        ((Standards.NAF2, "23.20"), (Standards.NACE2, "23.20")),
        ((Standards.NAF2, "23.20Z"), (Standards.NACE2, "23.20")),
        ((Standards.NAF2, "23.3"), (Standards.NACE2, "23.3")),
        ((Standards.NAF2, "23.31"), (Standards.NACE2, "23.31")),
        ((Standards.NAF2, "23.31Z"), (Standards.NACE2, "23.31")),
        ((Standards.NAF2, "23.32"), (Standards.NACE2, "23.32")),
        ((Standards.NAF2, "23.32Z"), (Standards.NACE2, "23.32")),
        ((Standards.NAF2, "23.4"), (Standards.NACE2, "23.4")),
        ((Standards.NAF2, "23.41"), (Standards.NACE2, "23.41")),
        ((Standards.NAF2, "23.41Z"), (Standards.NACE2, "23.41")),
        ((Standards.NAF2, "23.42"), (Standards.NACE2, "23.42")),
        ((Standards.NAF2, "23.42Z"), (Standards.NACE2, "23.42")),
        ((Standards.NAF2, "23.43"), (Standards.NACE2, "23.43")),
        ((Standards.NAF2, "23.43Z"), (Standards.NACE2, "23.43")),
        ((Standards.NAF2, "23.44"), (Standards.NACE2, "23.44")),
        ((Standards.NAF2, "23.44Z"), (Standards.NACE2, "23.44")),
        ((Standards.NAF2, "23.49"), (Standards.NACE2, "23.49")),
        ((Standards.NAF2, "23.49Z"), (Standards.NACE2, "23.49")),
        ((Standards.NAF2, "23.5"), (Standards.NACE2, "23.5")),
        ((Standards.NAF2, "23.51"), (Standards.NACE2, "23.51")),
        ((Standards.NAF2, "23.51Z"), (Standards.NACE2, "23.51")),
        ((Standards.NAF2, "23.52"), (Standards.NACE2, "23.52")),
        ((Standards.NAF2, "23.52Z"), (Standards.NACE2, "23.52")),
        ((Standards.NAF2, "23.6"), (Standards.NACE2, "23.6")),
        ((Standards.NAF2, "23.61"), (Standards.NACE2, "23.61")),
        ((Standards.NAF2, "23.61Z"), (Standards.NACE2, "23.61")),
        ((Standards.NAF2, "23.62"), (Standards.NACE2, "23.62")),
        ((Standards.NAF2, "23.62Z"), (Standards.NACE2, "23.62")),
        ((Standards.NAF2, "23.63"), (Standards.NACE2, "23.63")),
        ((Standards.NAF2, "23.63Z"), (Standards.NACE2, "23.63")),
        ((Standards.NAF2, "23.64"), (Standards.NACE2, "23.64")),
        ((Standards.NAF2, "23.64Z"), (Standards.NACE2, "23.64")),
        ((Standards.NAF2, "23.65"), (Standards.NACE2, "23.65")),
        ((Standards.NAF2, "23.65Z"), (Standards.NACE2, "23.65")),
        ((Standards.NAF2, "23.69"), (Standards.NACE2, "23.69")),
        ((Standards.NAF2, "23.69Z"), (Standards.NACE2, "23.69")),
        ((Standards.NAF2, "23.7"), (Standards.NACE2, "23.7")),
        ((Standards.NAF2, "23.70"), (Standards.NACE2, "23.70")),
        ((Standards.NAF2, "23.70Z"), (Standards.NACE2, "23.70")),
        ((Standards.NAF2, "23.9"), (Standards.NACE2, "23.9")),
        ((Standards.NAF2, "23.91"), (Standards.NACE2, "23.91")),
        ((Standards.NAF2, "23.91Z"), (Standards.NACE2, "23.91")),
        ((Standards.NAF2, "23.99"), (Standards.NACE2, "23.99")),
        ((Standards.NAF2, "23.99Z"), (Standards.NACE2, "23.99")),
        ((Standards.NAF2, "24"), (Standards.NACE2, "24")),
        ((Standards.NAF2, "24.1"), (Standards.NACE2, "24.1")),
        ((Standards.NAF2, "24.10"), (Standards.NACE2, "24.10")),
        ((Standards.NAF2, "24.10Z"), (Standards.NACE2, "24.10")),
        ((Standards.NAF2, "24.2"), (Standards.NACE2, "24.2")),
        ((Standards.NAF2, "24.20"), (Standards.NACE2, "24.20")),
        ((Standards.NAF2, "24.20Z"), (Standards.NACE2, "24.20")),
        ((Standards.NAF2, "24.3"), (Standards.NACE2, "24.3")),
        ((Standards.NAF2, "24.31"), (Standards.NACE2, "24.31")),
        ((Standards.NAF2, "24.31Z"), (Standards.NACE2, "24.31")),
        ((Standards.NAF2, "24.32"), (Standards.NACE2, "24.32")),
        ((Standards.NAF2, "24.32Z"), (Standards.NACE2, "24.32")),
        ((Standards.NAF2, "24.33"), (Standards.NACE2, "24.33")),
        ((Standards.NAF2, "24.33Z"), (Standards.NACE2, "24.33")),
        ((Standards.NAF2, "24.34"), (Standards.NACE2, "24.34")),
        ((Standards.NAF2, "24.34Z"), (Standards.NACE2, "24.34")),
        ((Standards.NAF2, "24.4"), (Standards.NACE2, "24.4")),
        ((Standards.NAF2, "24.41"), (Standards.NACE2, "24.41")),
        ((Standards.NAF2, "24.41Z"), (Standards.NACE2, "24.41")),
        ((Standards.NAF2, "24.42"), (Standards.NACE2, "24.42")),
        ((Standards.NAF2, "24.42Z"), (Standards.NACE2, "24.42")),
        ((Standards.NAF2, "24.43"), (Standards.NACE2, "24.43")),
        ((Standards.NAF2, "24.43Z"), (Standards.NACE2, "24.43")),
        ((Standards.NAF2, "24.44"), (Standards.NACE2, "24.44")),
        ((Standards.NAF2, "24.44Z"), (Standards.NACE2, "24.44")),
        ((Standards.NAF2, "24.45"), (Standards.NACE2, "24.45")),
        ((Standards.NAF2, "24.45Z"), (Standards.NACE2, "24.45")),
        ((Standards.NAF2, "24.46"), (Standards.NACE2, "24.46")),
        ((Standards.NAF2, "24.46Z"), (Standards.NACE2, "24.46")),
        ((Standards.NAF2, "24.5"), (Standards.NACE2, "24.5")),
        ((Standards.NAF2, "24.51"), (Standards.NACE2, "24.51")),
        ((Standards.NAF2, "24.51Z"), (Standards.NACE2, "24.51")),
        ((Standards.NAF2, "24.52"), (Standards.NACE2, "24.52")),
        ((Standards.NAF2, "24.52Z"), (Standards.NACE2, "24.52")),
        ((Standards.NAF2, "24.53"), (Standards.NACE2, "24.53")),
        ((Standards.NAF2, "24.53Z"), (Standards.NACE2, "24.53")),
        ((Standards.NAF2, "24.54"), (Standards.NACE2, "24.54")),
        ((Standards.NAF2, "24.54Z"), (Standards.NACE2, "24.54")),
        ((Standards.NAF2, "25"), (Standards.NACE2, "25")),
        ((Standards.NAF2, "25.1"), (Standards.NACE2, "25.1")),
        ((Standards.NAF2, "25.11"), (Standards.NACE2, "25.11")),
        ((Standards.NAF2, "25.11Z"), (Standards.NACE2, "25.11")),
        ((Standards.NAF2, "25.12"), (Standards.NACE2, "25.12")),
        ((Standards.NAF2, "25.12Z"), (Standards.NACE2, "25.12")),
        ((Standards.NAF2, "25.2"), (Standards.NACE2, "25.2")),
        ((Standards.NAF2, "25.21"), (Standards.NACE2, "25.21")),
        ((Standards.NAF2, "25.21Z"), (Standards.NACE2, "25.21")),
        ((Standards.NAF2, "25.29"), (Standards.NACE2, "25.29")),
        ((Standards.NAF2, "25.29Z"), (Standards.NACE2, "25.29")),
        ((Standards.NAF2, "25.3"), (Standards.NACE2, "25.3")),
        ((Standards.NAF2, "25.30"), (Standards.NACE2, "25.30")),
        ((Standards.NAF2, "25.30Z"), (Standards.NACE2, "25.30")),
        ((Standards.NAF2, "25.4"), (Standards.NACE2, "25.4")),
        ((Standards.NAF2, "25.40"), (Standards.NACE2, "25.40")),
        ((Standards.NAF2, "25.40Z"), (Standards.NACE2, "25.40")),
        ((Standards.NAF2, "25.5"), (Standards.NACE2, "25.5")),
        ((Standards.NAF2, "25.50"), (Standards.NACE2, "25.50")),
        ((Standards.NAF2, "25.50A"), (Standards.NACE2, "25.50")),
        ((Standards.NAF2, "25.50B"), (Standards.NACE2, "25.50")),
        ((Standards.NAF2, "25.6"), (Standards.NACE2, "25.6")),
        ((Standards.NAF2, "25.61"), (Standards.NACE2, "25.61")),
        ((Standards.NAF2, "25.61Z"), (Standards.NACE2, "25.61")),
        ((Standards.NAF2, "25.62"), (Standards.NACE2, "25.62")),
        ((Standards.NAF2, "25.62A"), (Standards.NACE2, "25.62")),
        ((Standards.NAF2, "25.62B"), (Standards.NACE2, "25.62")),
        ((Standards.NAF2, "25.7"), (Standards.NACE2, "25.7")),
        ((Standards.NAF2, "25.71"), (Standards.NACE2, "25.71")),
        ((Standards.NAF2, "25.71Z"), (Standards.NACE2, "25.71")),
        ((Standards.NAF2, "25.72"), (Standards.NACE2, "25.72")),
        ((Standards.NAF2, "25.72Z"), (Standards.NACE2, "25.72")),
        ((Standards.NAF2, "25.73"), (Standards.NACE2, "25.73")),
        ((Standards.NAF2, "25.73A"), (Standards.NACE2, "25.73")),
        ((Standards.NAF2, "25.73B"), (Standards.NACE2, "25.73")),
        ((Standards.NAF2, "25.9"), (Standards.NACE2, "25.9")),
        ((Standards.NAF2, "25.91"), (Standards.NACE2, "25.91")),
        ((Standards.NAF2, "25.91Z"), (Standards.NACE2, "25.91")),
        ((Standards.NAF2, "25.92"), (Standards.NACE2, "25.92")),
        ((Standards.NAF2, "25.92Z"), (Standards.NACE2, "25.92")),
        ((Standards.NAF2, "25.93"), (Standards.NACE2, "25.93")),
        ((Standards.NAF2, "25.93Z"), (Standards.NACE2, "25.93")),
        ((Standards.NAF2, "25.94"), (Standards.NACE2, "25.94")),
        ((Standards.NAF2, "25.94Z"), (Standards.NACE2, "25.94")),
        ((Standards.NAF2, "25.99"), (Standards.NACE2, "25.99")),
        ((Standards.NAF2, "25.99A"), (Standards.NACE2, "25.99")),
        ((Standards.NAF2, "25.99B"), (Standards.NACE2, "25.99")),
        ((Standards.NAF2, "26"), (Standards.NACE2, "26")),
        ((Standards.NAF2, "26.1"), (Standards.NACE2, "26.1")),
        ((Standards.NAF2, "26.11"), (Standards.NACE2, "26.11")),
        ((Standards.NAF2, "26.11Z"), (Standards.NACE2, "26.11")),
        ((Standards.NAF2, "26.12"), (Standards.NACE2, "26.12")),
        ((Standards.NAF2, "26.12Z"), (Standards.NACE2, "26.12")),
        ((Standards.NAF2, "26.2"), (Standards.NACE2, "26.2")),
        ((Standards.NAF2, "26.20"), (Standards.NACE2, "26.20")),
        ((Standards.NAF2, "26.20Z"), (Standards.NACE2, "26.20")),
        ((Standards.NAF2, "26.3"), (Standards.NACE2, "26.3")),
        ((Standards.NAF2, "26.30"), (Standards.NACE2, "26.30")),
        ((Standards.NAF2, "26.30Z"), (Standards.NACE2, "26.30")),
        ((Standards.NAF2, "26.4"), (Standards.NACE2, "26.4")),
        ((Standards.NAF2, "26.40"), (Standards.NACE2, "26.40")),
        ((Standards.NAF2, "26.40Z"), (Standards.NACE2, "26.40")),
        ((Standards.NAF2, "26.5"), (Standards.NACE2, "26.5")),
        ((Standards.NAF2, "26.51"), (Standards.NACE2, "26.51")),
        ((Standards.NAF2, "26.51A"), (Standards.NACE2, "26.51")),
        ((Standards.NAF2, "26.51B"), (Standards.NACE2, "26.51")),
        ((Standards.NAF2, "26.52"), (Standards.NACE2, "26.52")),
        ((Standards.NAF2, "26.52Z"), (Standards.NACE2, "26.52")),
        ((Standards.NAF2, "26.6"), (Standards.NACE2, "26.6")),
        ((Standards.NAF2, "26.60"), (Standards.NACE2, "26.60")),
        ((Standards.NAF2, "26.60Z"), (Standards.NACE2, "26.60")),
        ((Standards.NAF2, "26.7"), (Standards.NACE2, "26.7")),
        ((Standards.NAF2, "26.70"), (Standards.NACE2, "26.70")),
        ((Standards.NAF2, "26.70Z"), (Standards.NACE2, "26.70")),
        ((Standards.NAF2, "26.8"), (Standards.NACE2, "26.8")),
        ((Standards.NAF2, "26.80"), (Standards.NACE2, "26.80")),
        ((Standards.NAF2, "26.80Z"), (Standards.NACE2, "26.80")),
        ((Standards.NAF2, "27"), (Standards.NACE2, "27")),
        ((Standards.NAF2, "27.1"), (Standards.NACE2, "27.1")),
        ((Standards.NAF2, "27.11"), (Standards.NACE2, "27.11")),
        ((Standards.NAF2, "27.11Z"), (Standards.NACE2, "27.11")),
        ((Standards.NAF2, "27.12"), (Standards.NACE2, "27.12")),
        ((Standards.NAF2, "27.12Z"), (Standards.NACE2, "27.12")),
        ((Standards.NAF2, "27.2"), (Standards.NACE2, "27.2")),
        ((Standards.NAF2, "27.20"), (Standards.NACE2, "27.20")),
        ((Standards.NAF2, "27.20Z"), (Standards.NACE2, "27.20")),
        ((Standards.NAF2, "27.3"), (Standards.NACE2, "27.3")),
        ((Standards.NAF2, "27.31"), (Standards.NACE2, "27.31")),
        ((Standards.NAF2, "27.31Z"), (Standards.NACE2, "27.31")),
        ((Standards.NAF2, "27.32"), (Standards.NACE2, "27.32")),
        ((Standards.NAF2, "27.32Z"), (Standards.NACE2, "27.32")),
        ((Standards.NAF2, "27.33"), (Standards.NACE2, "27.33")),
        ((Standards.NAF2, "27.33Z"), (Standards.NACE2, "27.33")),
        ((Standards.NAF2, "27.4"), (Standards.NACE2, "27.4")),
        ((Standards.NAF2, "27.40"), (Standards.NACE2, "27.40")),
        ((Standards.NAF2, "27.40Z"), (Standards.NACE2, "27.40")),
        ((Standards.NAF2, "27.5"), (Standards.NACE2, "27.5")),
        ((Standards.NAF2, "27.51"), (Standards.NACE2, "27.51")),
        ((Standards.NAF2, "27.51Z"), (Standards.NACE2, "27.51")),
        ((Standards.NAF2, "27.52"), (Standards.NACE2, "27.52")),
        ((Standards.NAF2, "27.52Z"), (Standards.NACE2, "27.52")),
        ((Standards.NAF2, "27.9"), (Standards.NACE2, "27.9")),
        ((Standards.NAF2, "27.90"), (Standards.NACE2, "27.90")),
        ((Standards.NAF2, "27.90Z"), (Standards.NACE2, "27.90")),
        ((Standards.NAF2, "28"), (Standards.NACE2, "28")),
        ((Standards.NAF2, "28.1"), (Standards.NACE2, "28.1")),
        ((Standards.NAF2, "28.11"), (Standards.NACE2, "28.11")),
        ((Standards.NAF2, "28.11Z"), (Standards.NACE2, "28.11")),
        ((Standards.NAF2, "28.12"), (Standards.NACE2, "28.12")),
        ((Standards.NAF2, "28.12Z"), (Standards.NACE2, "28.12")),
        ((Standards.NAF2, "28.13"), (Standards.NACE2, "28.13")),
        ((Standards.NAF2, "28.13Z"), (Standards.NACE2, "28.13")),
        ((Standards.NAF2, "28.14"), (Standards.NACE2, "28.14")),
        ((Standards.NAF2, "28.14Z"), (Standards.NACE2, "28.14")),
        ((Standards.NAF2, "28.15"), (Standards.NACE2, "28.15")),
        ((Standards.NAF2, "28.15Z"), (Standards.NACE2, "28.15")),
        ((Standards.NAF2, "28.2"), (Standards.NACE2, "28.2")),
        ((Standards.NAF2, "28.21"), (Standards.NACE2, "28.21")),
        ((Standards.NAF2, "28.21Z"), (Standards.NACE2, "28.21")),
        ((Standards.NAF2, "28.22"), (Standards.NACE2, "28.22")),
        ((Standards.NAF2, "28.22Z"), (Standards.NACE2, "28.22")),
        ((Standards.NAF2, "28.23"), (Standards.NACE2, "28.23")),
        ((Standards.NAF2, "28.23Z"), (Standards.NACE2, "28.23")),
        ((Standards.NAF2, "28.24"), (Standards.NACE2, "28.24")),
        ((Standards.NAF2, "28.24Z"), (Standards.NACE2, "28.24")),
        ((Standards.NAF2, "28.25"), (Standards.NACE2, "28.25")),
        ((Standards.NAF2, "28.25Z"), (Standards.NACE2, "28.25")),
        ((Standards.NAF2, "28.29"), (Standards.NACE2, "28.29")),
        ((Standards.NAF2, "28.29A"), (Standards.NACE2, "28.29")),
        ((Standards.NAF2, "28.29B"), (Standards.NACE2, "28.29")),
        ((Standards.NAF2, "28.3"), (Standards.NACE2, "28.3")),
        ((Standards.NAF2, "28.30"), (Standards.NACE2, "28.30")),
        ((Standards.NAF2, "28.30Z"), (Standards.NACE2, "28.30")),
        ((Standards.NAF2, "28.4"), (Standards.NACE2, "28.4")),
        ((Standards.NAF2, "28.41"), (Standards.NACE2, "28.41")),
        ((Standards.NAF2, "28.41Z"), (Standards.NACE2, "28.41")),
        ((Standards.NAF2, "28.49"), (Standards.NACE2, "28.49")),
        ((Standards.NAF2, "28.49Z"), (Standards.NACE2, "28.49")),
        ((Standards.NAF2, "28.9"), (Standards.NACE2, "28.9")),
        ((Standards.NAF2, "28.91"), (Standards.NACE2, "28.91")),
        ((Standards.NAF2, "28.91Z"), (Standards.NACE2, "28.91")),
        ((Standards.NAF2, "28.92"), (Standards.NACE2, "28.92")),
        ((Standards.NAF2, "28.92Z"), (Standards.NACE2, "28.92")),
        ((Standards.NAF2, "28.93"), (Standards.NACE2, "28.93")),
        ((Standards.NAF2, "28.93Z"), (Standards.NACE2, "28.93")),
        ((Standards.NAF2, "28.94"), (Standards.NACE2, "28.94")),
        ((Standards.NAF2, "28.94Z"), (Standards.NACE2, "28.94")),
        ((Standards.NAF2, "28.95"), (Standards.NACE2, "28.95")),
        ((Standards.NAF2, "28.95Z"), (Standards.NACE2, "28.95")),
        ((Standards.NAF2, "28.96"), (Standards.NACE2, "28.96")),
        ((Standards.NAF2, "28.96Z"), (Standards.NACE2, "28.96")),
        ((Standards.NAF2, "28.99"), (Standards.NACE2, "28.99")),
        ((Standards.NAF2, "28.99A"), (Standards.NACE2, "28.99")),
        ((Standards.NAF2, "28.99B"), (Standards.NACE2, "28.99")),
        ((Standards.NAF2, "29"), (Standards.NACE2, "29")),
        ((Standards.NAF2, "29.1"), (Standards.NACE2, "29.1")),
        ((Standards.NAF2, "29.10"), (Standards.NACE2, "29.10")),
        ((Standards.NAF2, "29.10Z"), (Standards.NACE2, "29.10")),
        ((Standards.NAF2, "29.2"), (Standards.NACE2, "29.2")),
        ((Standards.NAF2, "29.20"), (Standards.NACE2, "29.20")),
        ((Standards.NAF2, "29.20Z"), (Standards.NACE2, "29.20")),
        ((Standards.NAF2, "29.3"), (Standards.NACE2, "29.3")),
        ((Standards.NAF2, "29.31"), (Standards.NACE2, "29.31")),
        ((Standards.NAF2, "29.31Z"), (Standards.NACE2, "29.31")),
        ((Standards.NAF2, "29.32"), (Standards.NACE2, "29.32")),
        ((Standards.NAF2, "29.32Z"), (Standards.NACE2, "29.32")),
        ((Standards.NAF2, "30"), (Standards.NACE2, "30")),
        ((Standards.NAF2, "30.1"), (Standards.NACE2, "30.1")),
        ((Standards.NAF2, "30.11"), (Standards.NACE2, "30.11")),
        ((Standards.NAF2, "30.11Z"), (Standards.NACE2, "30.11")),
        ((Standards.NAF2, "30.12"), (Standards.NACE2, "30.12")),
        ((Standards.NAF2, "30.12Z"), (Standards.NACE2, "30.12")),
        ((Standards.NAF2, "30.2"), (Standards.NACE2, "30.2")),
        ((Standards.NAF2, "30.20"), (Standards.NACE2, "30.20")),
        ((Standards.NAF2, "30.20Z"), (Standards.NACE2, "30.20")),
        ((Standards.NAF2, "30.3"), (Standards.NACE2, "30.3")),
        ((Standards.NAF2, "30.30"), (Standards.NACE2, "30.30")),
        ((Standards.NAF2, "30.30Z"), (Standards.NACE2, "30.30")),
        ((Standards.NAF2, "30.4"), (Standards.NACE2, "30.4")),
        ((Standards.NAF2, "30.40"), (Standards.NACE2, "30.40")),
        ((Standards.NAF2, "30.40Z"), (Standards.NACE2, "30.40")),
        ((Standards.NAF2, "30.9"), (Standards.NACE2, "30.9")),
        ((Standards.NAF2, "30.91"), (Standards.NACE2, "30.91")),
        ((Standards.NAF2, "30.91Z"), (Standards.NACE2, "30.91")),
        ((Standards.NAF2, "30.92"), (Standards.NACE2, "30.92")),
        ((Standards.NAF2, "30.92Z"), (Standards.NACE2, "30.92")),
        ((Standards.NAF2, "30.99"), (Standards.NACE2, "30.99")),
        ((Standards.NAF2, "30.99Z"), (Standards.NACE2, "30.99")),
        ((Standards.NAF2, "31"), (Standards.NACE2, "31")),
        ((Standards.NAF2, "31.0"), (Standards.NACE2, "31.0")),
        ((Standards.NAF2, "31.01"), (Standards.NACE2, "31.01")),
        ((Standards.NAF2, "31.01Z"), (Standards.NACE2, "31.01")),
        ((Standards.NAF2, "31.02"), (Standards.NACE2, "31.02")),
        ((Standards.NAF2, "31.02Z"), (Standards.NACE2, "31.02")),
        ((Standards.NAF2, "31.03"), (Standards.NACE2, "31.03")),
        ((Standards.NAF2, "31.03Z"), (Standards.NACE2, "31.03")),
        ((Standards.NAF2, "31.09"), (Standards.NACE2, "31.09")),
        ((Standards.NAF2, "31.09A"), (Standards.NACE2, "31.09")),
        ((Standards.NAF2, "31.09B"), (Standards.NACE2, "31.09")),
        ((Standards.NAF2, "32"), (Standards.NACE2, "32")),
        ((Standards.NAF2, "32.1"), (Standards.NACE2, "32.1")),
        ((Standards.NAF2, "32.11"), (Standards.NACE2, "32.11")),
        ((Standards.NAF2, "32.11Z"), (Standards.NACE2, "32.11")),
        ((Standards.NAF2, "32.12"), (Standards.NACE2, "32.12")),
        ((Standards.NAF2, "32.12Z"), (Standards.NACE2, "32.12")),
        ((Standards.NAF2, "32.13"), (Standards.NACE2, "32.13")),
        ((Standards.NAF2, "32.13Z"), (Standards.NACE2, "32.13")),
        ((Standards.NAF2, "32.2"), (Standards.NACE2, "32.2")),
        ((Standards.NAF2, "32.20"), (Standards.NACE2, "32.20")),
        ((Standards.NAF2, "32.20Z"), (Standards.NACE2, "32.20")),
        ((Standards.NAF2, "32.3"), (Standards.NACE2, "32.3")),
        ((Standards.NAF2, "32.30"), (Standards.NACE2, "32.30")),
        ((Standards.NAF2, "32.30Z"), (Standards.NACE2, "32.30")),
        ((Standards.NAF2, "32.4"), (Standards.NACE2, "32.4")),
        ((Standards.NAF2, "32.40"), (Standards.NACE2, "32.40")),
        ((Standards.NAF2, "32.40Z"), (Standards.NACE2, "32.40")),
        ((Standards.NAF2, "32.5"), (Standards.NACE2, "32.5")),
        ((Standards.NAF2, "32.50"), (Standards.NACE2, "32.50")),
        ((Standards.NAF2, "32.50A"), (Standards.NACE2, "32.50")),
        ((Standards.NAF2, "32.50B"), (Standards.NACE2, "32.50")),
        ((Standards.NAF2, "32.9"), (Standards.NACE2, "32.9")),
        ((Standards.NAF2, "32.91"), (Standards.NACE2, "32.91")),
        ((Standards.NAF2, "32.91Z"), (Standards.NACE2, "32.91")),
        ((Standards.NAF2, "32.99"), (Standards.NACE2, "32.99")),
        ((Standards.NAF2, "32.99Z"), (Standards.NACE2, "32.99")),
        ((Standards.NAF2, "33"), (Standards.NACE2, "33")),
        ((Standards.NAF2, "33.1"), (Standards.NACE2, "33.1")),
        ((Standards.NAF2, "33.11"), (Standards.NACE2, "33.11")),
        ((Standards.NAF2, "33.11Z"), (Standards.NACE2, "33.11")),
        ((Standards.NAF2, "33.12"), (Standards.NACE2, "33.12")),
        ((Standards.NAF2, "33.12Z"), (Standards.NACE2, "33.12")),
        ((Standards.NAF2, "33.13"), (Standards.NACE2, "33.13")),
        ((Standards.NAF2, "33.13Z"), (Standards.NACE2, "33.13")),
        ((Standards.NAF2, "33.14"), (Standards.NACE2, "33.14")),
        ((Standards.NAF2, "33.14Z"), (Standards.NACE2, "33.14")),
        ((Standards.NAF2, "33.15"), (Standards.NACE2, "33.15")),
        ((Standards.NAF2, "33.15Z"), (Standards.NACE2, "33.15")),
        ((Standards.NAF2, "33.16"), (Standards.NACE2, "33.16")),
        ((Standards.NAF2, "33.16Z"), (Standards.NACE2, "33.16")),
        ((Standards.NAF2, "33.17"), (Standards.NACE2, "33.17")),
        ((Standards.NAF2, "33.17Z"), (Standards.NACE2, "33.17")),
        ((Standards.NAF2, "33.19"), (Standards.NACE2, "33.19")),
        ((Standards.NAF2, "33.19Z"), (Standards.NACE2, "33.19")),
        ((Standards.NAF2, "33.2"), (Standards.NACE2, "33.2")),
        ((Standards.NAF2, "33.20"), (Standards.NACE2, "33.20")),
        ((Standards.NAF2, "33.20A"), (Standards.NACE2, "33.20")),
        ((Standards.NAF2, "33.20B"), (Standards.NACE2, "33.20")),
        ((Standards.NAF2, "33.20C"), (Standards.NACE2, "33.20")),
        ((Standards.NAF2, "33.20D"), (Standards.NACE2, "33.20")),
        ((Standards.NAF2, "D"), (Standards.NACE2, "D")),
        ((Standards.NAF2, "35"), (Standards.NACE2, "35")),
        ((Standards.NAF2, "35.1"), (Standards.NACE2, "35.1")),
        ((Standards.NAF2, "35.11"), (Standards.NACE2, "35.11")),
        ((Standards.NAF2, "35.11Z"), (Standards.NACE2, "35.11")),
        ((Standards.NAF2, "35.12"), (Standards.NACE2, "35.12")),
        ((Standards.NAF2, "35.12Z"), (Standards.NACE2, "35.12")),
        ((Standards.NAF2, "35.13"), (Standards.NACE2, "35.13")),
        ((Standards.NAF2, "35.13Z"), (Standards.NACE2, "35.13")),
        ((Standards.NAF2, "35.14"), (Standards.NACE2, "35.14")),
        ((Standards.NAF2, "35.14Z"), (Standards.NACE2, "35.14")),
        ((Standards.NAF2, "35.2"), (Standards.NACE2, "35.2")),
        ((Standards.NAF2, "35.21"), (Standards.NACE2, "35.21")),
        ((Standards.NAF2, "35.21Z"), (Standards.NACE2, "35.21")),
        ((Standards.NAF2, "35.22"), (Standards.NACE2, "35.22")),
        ((Standards.NAF2, "35.22Z"), (Standards.NACE2, "35.22")),
        ((Standards.NAF2, "35.23"), (Standards.NACE2, "35.23")),
        ((Standards.NAF2, "35.23Z"), (Standards.NACE2, "35.23")),
        ((Standards.NAF2, "35.3"), (Standards.NACE2, "35.3")),
        ((Standards.NAF2, "35.30"), (Standards.NACE2, "35.30")),
        ((Standards.NAF2, "35.30Z"), (Standards.NACE2, "35.30")),
        ((Standards.NAF2, "E"), (Standards.NACE2, "E")),
        ((Standards.NAF2, "36"), (Standards.NACE2, "36")),
        ((Standards.NAF2, "36.0"), (Standards.NACE2, "36.0")),
        ((Standards.NAF2, "36.00"), (Standards.NACE2, "36.00")),
        ((Standards.NAF2, "36.00Z"), (Standards.NACE2, "36.00")),
        ((Standards.NAF2, "37"), (Standards.NACE2, "37")),
        ((Standards.NAF2, "37.0"), (Standards.NACE2, "37.0")),
        ((Standards.NAF2, "37.00"), (Standards.NACE2, "37.00")),
        ((Standards.NAF2, "37.00Z"), (Standards.NACE2, "37.00")),
        ((Standards.NAF2, "38"), (Standards.NACE2, "38")),
        ((Standards.NAF2, "38.1"), (Standards.NACE2, "38.1")),
        ((Standards.NAF2, "38.11"), (Standards.NACE2, "38.11")),
        ((Standards.NAF2, "38.11Z"), (Standards.NACE2, "38.11")),
        ((Standards.NAF2, "38.12"), (Standards.NACE2, "38.12")),
        ((Standards.NAF2, "38.12Z"), (Standards.NACE2, "38.12")),
        ((Standards.NAF2, "38.2"), (Standards.NACE2, "38.2")),
        ((Standards.NAF2, "38.21"), (Standards.NACE2, "38.21")),
        ((Standards.NAF2, "38.21Z"), (Standards.NACE2, "38.21")),
        ((Standards.NAF2, "38.22"), (Standards.NACE2, "38.22")),
        ((Standards.NAF2, "38.22Z"), (Standards.NACE2, "38.22")),
        ((Standards.NAF2, "38.3"), (Standards.NACE2, "38.3")),
        ((Standards.NAF2, "38.31"), (Standards.NACE2, "38.31")),
        ((Standards.NAF2, "38.31Z"), (Standards.NACE2, "38.31")),
        ((Standards.NAF2, "38.32"), (Standards.NACE2, "38.32")),
        ((Standards.NAF2, "38.32Z"), (Standards.NACE2, "38.32")),
        ((Standards.NAF2, "39"), (Standards.NACE2, "39")),
        ((Standards.NAF2, "39.0"), (Standards.NACE2, "39.0")),
        ((Standards.NAF2, "39.00"), (Standards.NACE2, "39.00")),
        ((Standards.NAF2, "39.00Z"), (Standards.NACE2, "39.00")),
        ((Standards.NAF2, "F"), (Standards.NACE2, "F")),
        ((Standards.NAF2, "41"), (Standards.NACE2, "41")),
        ((Standards.NAF2, "41.1"), (Standards.NACE2, "41.1")),
        ((Standards.NAF2, "41.10"), (Standards.NACE2, "41.10")),
        ((Standards.NAF2, "41.10A"), (Standards.NACE2, "41.10")),
        ((Standards.NAF2, "41.10B"), (Standards.NACE2, "41.10")),
        ((Standards.NAF2, "41.10C"), (Standards.NACE2, "41.10")),
        ((Standards.NAF2, "41.10D"), (Standards.NACE2, "41.10")),
        ((Standards.NAF2, "41.2"), (Standards.NACE2, "41.2")),
        ((Standards.NAF2, "41.20"), (Standards.NACE2, "41.20")),
        ((Standards.NAF2, "41.20A"), (Standards.NACE2, "41.20")),
        ((Standards.NAF2, "41.20B"), (Standards.NACE2, "41.20")),
        ((Standards.NAF2, "42"), (Standards.NACE2, "42")),
        ((Standards.NAF2, "42.1"), (Standards.NACE2, "42.1")),
        ((Standards.NAF2, "42.11"), (Standards.NACE2, "42.11")),
        ((Standards.NAF2, "42.11Z"), (Standards.NACE2, "42.11")),
        ((Standards.NAF2, "42.12"), (Standards.NACE2, "42.12")),
        ((Standards.NAF2, "42.12Z"), (Standards.NACE2, "42.12")),
        ((Standards.NAF2, "42.13"), (Standards.NACE2, "42.13")),
        ((Standards.NAF2, "42.13A"), (Standards.NACE2, "42.13")),
        ((Standards.NAF2, "42.13B"), (Standards.NACE2, "42.13")),
        ((Standards.NAF2, "42.2"), (Standards.NACE2, "42.2")),
        ((Standards.NAF2, "42.21"), (Standards.NACE2, "42.21")),
        ((Standards.NAF2, "42.21Z"), (Standards.NACE2, "42.21")),
        ((Standards.NAF2, "42.22"), (Standards.NACE2, "42.22")),
        ((Standards.NAF2, "42.22Z"), (Standards.NACE2, "42.22")),
        ((Standards.NAF2, "42.9"), (Standards.NACE2, "42.9")),
        ((Standards.NAF2, "42.91"), (Standards.NACE2, "42.91")),
        ((Standards.NAF2, "42.91Z"), (Standards.NACE2, "42.91")),
        ((Standards.NAF2, "42.99"), (Standards.NACE2, "42.99")),
        ((Standards.NAF2, "42.99Z"), (Standards.NACE2, "42.99")),
        ((Standards.NAF2, "43"), (Standards.NACE2, "43")),
        ((Standards.NAF2, "43.1"), (Standards.NACE2, "43.1")),
        ((Standards.NAF2, "43.11"), (Standards.NACE2, "43.11")),
        ((Standards.NAF2, "43.11Z"), (Standards.NACE2, "43.11")),
        ((Standards.NAF2, "43.12"), (Standards.NACE2, "43.12")),
        ((Standards.NAF2, "43.12A"), (Standards.NACE2, "43.12")),
        ((Standards.NAF2, "43.12B"), (Standards.NACE2, "43.12")),
        ((Standards.NAF2, "43.13"), (Standards.NACE2, "43.13")),
        ((Standards.NAF2, "43.13Z"), (Standards.NACE2, "43.13")),
        ((Standards.NAF2, "43.2"), (Standards.NACE2, "43.2")),
        ((Standards.NAF2, "43.21"), (Standards.NACE2, "43.21")),
        ((Standards.NAF2, "43.21A"), (Standards.NACE2, "43.21")),
        ((Standards.NAF2, "43.21B"), (Standards.NACE2, "43.21")),
        ((Standards.NAF2, "43.22"), (Standards.NACE2, "43.22")),
        ((Standards.NAF2, "43.22A"), (Standards.NACE2, "43.22")),
        ((Standards.NAF2, "43.22B"), (Standards.NACE2, "43.22")),
        ((Standards.NAF2, "43.29"), (Standards.NACE2, "43.29")),
        ((Standards.NAF2, "43.29A"), (Standards.NACE2, "43.29")),
        ((Standards.NAF2, "43.29B"), (Standards.NACE2, "43.29")),
        ((Standards.NAF2, "43.3"), (Standards.NACE2, "43.3")),
        ((Standards.NAF2, "43.31"), (Standards.NACE2, "43.31")),
        ((Standards.NAF2, "43.31Z"), (Standards.NACE2, "43.31")),
        ((Standards.NAF2, "43.32"), (Standards.NACE2, "43.32")),
        ((Standards.NAF2, "43.32A"), (Standards.NACE2, "43.32")),
        ((Standards.NAF2, "43.32B"), (Standards.NACE2, "43.32")),
        ((Standards.NAF2, "43.32C"), (Standards.NACE2, "43.32")),
        ((Standards.NAF2, "43.33"), (Standards.NACE2, "43.33")),
        ((Standards.NAF2, "43.33Z"), (Standards.NACE2, "43.33")),
        ((Standards.NAF2, "43.34"), (Standards.NACE2, "43.34")),
        ((Standards.NAF2, "43.34Z"), (Standards.NACE2, "43.34")),
        ((Standards.NAF2, "43.39"), (Standards.NACE2, "43.39")),
        ((Standards.NAF2, "43.39Z"), (Standards.NACE2, "43.39")),
        ((Standards.NAF2, "43.9"), (Standards.NACE2, "43.9")),
        ((Standards.NAF2, "43.91"), (Standards.NACE2, "43.91")),
        ((Standards.NAF2, "43.91A"), (Standards.NACE2, "43.91")),
        ((Standards.NAF2, "43.91B"), (Standards.NACE2, "43.91")),
        ((Standards.NAF2, "43.99"), (Standards.NACE2, "43.99")),
        ((Standards.NAF2, "43.99A"), (Standards.NACE2, "43.99")),
        ((Standards.NAF2, "43.99B"), (Standards.NACE2, "43.99")),
        ((Standards.NAF2, "43.99C"), (Standards.NACE2, "43.99")),
        ((Standards.NAF2, "43.99D"), (Standards.NACE2, "43.99")),
        ((Standards.NAF2, "43.99E"), (Standards.NACE2, "43.99")),
        ((Standards.NAF2, "G"), (Standards.NACE2, "G")),
        ((Standards.NAF2, "45"), (Standards.NACE2, "45")),
        ((Standards.NAF2, "45.1"), (Standards.NACE2, "45.1")),
        ((Standards.NAF2, "45.11"), (Standards.NACE2, "45.11")),
        ((Standards.NAF2, "45.11Z"), (Standards.NACE2, "45.11")),
        ((Standards.NAF2, "45.19"), (Standards.NACE2, "45.19")),
        ((Standards.NAF2, "45.19Z"), (Standards.NACE2, "45.19")),
        ((Standards.NAF2, "45.2"), (Standards.NACE2, "45.2")),
        ((Standards.NAF2, "45.20"), (Standards.NACE2, "45.20")),
        ((Standards.NAF2, "45.20A"), (Standards.NACE2, "45.20")),
        ((Standards.NAF2, "45.20B"), (Standards.NACE2, "45.20")),
        ((Standards.NAF2, "45.3"), (Standards.NACE2, "45.3")),
        ((Standards.NAF2, "45.31"), (Standards.NACE2, "45.31")),
        ((Standards.NAF2, "45.31Z"), (Standards.NACE2, "45.31")),
        ((Standards.NAF2, "45.32"), (Standards.NACE2, "45.32")),
        ((Standards.NAF2, "45.32Z"), (Standards.NACE2, "45.32")),
        ((Standards.NAF2, "45.4"), (Standards.NACE2, "45.4")),
        ((Standards.NAF2, "45.40"), (Standards.NACE2, "45.40")),
        ((Standards.NAF2, "45.40Z"), (Standards.NACE2, "45.40")),
        ((Standards.NAF2, "46"), (Standards.NACE2, "46")),
        ((Standards.NAF2, "46.1"), (Standards.NACE2, "46.1")),
        ((Standards.NAF2, "46.11"), (Standards.NACE2, "46.11")),
        ((Standards.NAF2, "46.11Z"), (Standards.NACE2, "46.11")),
        ((Standards.NAF2, "46.12"), (Standards.NACE2, "46.12")),
        ((Standards.NAF2, "46.12A"), (Standards.NACE2, "46.12")),
        ((Standards.NAF2, "46.12B"), (Standards.NACE2, "46.12")),
        ((Standards.NAF2, "46.13"), (Standards.NACE2, "46.13")),
        ((Standards.NAF2, "46.13Z"), (Standards.NACE2, "46.13")),
        ((Standards.NAF2, "46.14"), (Standards.NACE2, "46.14")),
        ((Standards.NAF2, "46.14Z"), (Standards.NACE2, "46.14")),
        ((Standards.NAF2, "46.15"), (Standards.NACE2, "46.15")),
        ((Standards.NAF2, "46.15Z"), (Standards.NACE2, "46.15")),
        ((Standards.NAF2, "46.16"), (Standards.NACE2, "46.16")),
        ((Standards.NAF2, "46.16Z"), (Standards.NACE2, "46.16")),
        ((Standards.NAF2, "46.17"), (Standards.NACE2, "46.17")),
        ((Standards.NAF2, "46.17A"), (Standards.NACE2, "46.17")),
        ((Standards.NAF2, "46.17B"), (Standards.NACE2, "46.17")),
        ((Standards.NAF2, "46.18"), (Standards.NACE2, "46.18")),
        ((Standards.NAF2, "46.18Z"), (Standards.NACE2, "46.18")),
        ((Standards.NAF2, "46.19"), (Standards.NACE2, "46.19")),
        ((Standards.NAF2, "46.19A"), (Standards.NACE2, "46.19")),
        ((Standards.NAF2, "46.19B"), (Standards.NACE2, "46.19")),
        ((Standards.NAF2, "46.2"), (Standards.NACE2, "46.2")),
        ((Standards.NAF2, "46.21"), (Standards.NACE2, "46.21")),
        ((Standards.NAF2, "46.21Z"), (Standards.NACE2, "46.21")),
        ((Standards.NAF2, "46.22"), (Standards.NACE2, "46.22")),
        ((Standards.NAF2, "46.22Z"), (Standards.NACE2, "46.22")),
        ((Standards.NAF2, "46.23"), (Standards.NACE2, "46.23")),
        ((Standards.NAF2, "46.23Z"), (Standards.NACE2, "46.23")),
        ((Standards.NAF2, "46.24"), (Standards.NACE2, "46.24")),
        ((Standards.NAF2, "46.24Z"), (Standards.NACE2, "46.24")),
        ((Standards.NAF2, "46.3"), (Standards.NACE2, "46.3")),
        ((Standards.NAF2, "46.31"), (Standards.NACE2, "46.31")),
        ((Standards.NAF2, "46.31Z"), (Standards.NACE2, "46.31")),
        ((Standards.NAF2, "46.32"), (Standards.NACE2, "46.32")),
        ((Standards.NAF2, "46.32A"), (Standards.NACE2, "46.32")),
        ((Standards.NAF2, "46.32B"), (Standards.NACE2, "46.32")),
        ((Standards.NAF2, "46.32C"), (Standards.NACE2, "46.32")),
        ((Standards.NAF2, "46.33"), (Standards.NACE2, "46.33")),
        ((Standards.NAF2, "46.33Z"), (Standards.NACE2, "46.33")),
        ((Standards.NAF2, "46.34"), (Standards.NACE2, "46.34")),
        ((Standards.NAF2, "46.34Z"), (Standards.NACE2, "46.34")),
        ((Standards.NAF2, "46.35"), (Standards.NACE2, "46.35")),
        ((Standards.NAF2, "46.35Z"), (Standards.NACE2, "46.35")),
        ((Standards.NAF2, "46.36"), (Standards.NACE2, "46.36")),
        ((Standards.NAF2, "46.36Z"), (Standards.NACE2, "46.36")),
        ((Standards.NAF2, "46.37"), (Standards.NACE2, "46.37")),
        ((Standards.NAF2, "46.37Z"), (Standards.NACE2, "46.37")),
        ((Standards.NAF2, "46.38"), (Standards.NACE2, "46.38")),
        ((Standards.NAF2, "46.38A"), (Standards.NACE2, "46.38")),
        ((Standards.NAF2, "46.38B"), (Standards.NACE2, "46.38")),
        ((Standards.NAF2, "46.39"), (Standards.NACE2, "46.39")),
        ((Standards.NAF2, "46.39A"), (Standards.NACE2, "46.39")),
        ((Standards.NAF2, "46.39B"), (Standards.NACE2, "46.39")),
        ((Standards.NAF2, "46.4"), (Standards.NACE2, "46.4")),
        ((Standards.NAF2, "46.41"), (Standards.NACE2, "46.41")),
        ((Standards.NAF2, "46.41Z"), (Standards.NACE2, "46.41")),
        ((Standards.NAF2, "46.42"), (Standards.NACE2, "46.42")),
        ((Standards.NAF2, "46.42Z"), (Standards.NACE2, "46.42")),
        ((Standards.NAF2, "46.43"), (Standards.NACE2, "46.43")),
        ((Standards.NAF2, "46.43Z"), (Standards.NACE2, "46.43")),
        ((Standards.NAF2, "46.44"), (Standards.NACE2, "46.44")),
        ((Standards.NAF2, "46.44Z"), (Standards.NACE2, "46.44")),
        ((Standards.NAF2, "46.45"), (Standards.NACE2, "46.45")),
        ((Standards.NAF2, "46.45Z"), (Standards.NACE2, "46.45")),
        ((Standards.NAF2, "46.46"), (Standards.NACE2, "46.46")),
        ((Standards.NAF2, "46.46Z"), (Standards.NACE2, "46.46")),
        ((Standards.NAF2, "46.47"), (Standards.NACE2, "46.47")),
        ((Standards.NAF2, "46.47Z"), (Standards.NACE2, "46.47")),
        ((Standards.NAF2, "46.48"), (Standards.NACE2, "46.48")),
        ((Standards.NAF2, "46.48Z"), (Standards.NACE2, "46.48")),
        ((Standards.NAF2, "46.49"), (Standards.NACE2, "46.49")),
        ((Standards.NAF2, "46.49Z"), (Standards.NACE2, "46.49")),
        ((Standards.NAF2, "46.5"), (Standards.NACE2, "46.5")),
        ((Standards.NAF2, "46.51"), (Standards.NACE2, "46.51")),
        ((Standards.NAF2, "46.51Z"), (Standards.NACE2, "46.51")),
        ((Standards.NAF2, "46.52"), (Standards.NACE2, "46.52")),
        ((Standards.NAF2, "46.52Z"), (Standards.NACE2, "46.52")),
        ((Standards.NAF2, "46.6"), (Standards.NACE2, "46.6")),
        ((Standards.NAF2, "46.61"), (Standards.NACE2, "46.61")),
        ((Standards.NAF2, "46.61Z"), (Standards.NACE2, "46.61")),
        ((Standards.NAF2, "46.62"), (Standards.NACE2, "46.62")),
        ((Standards.NAF2, "46.62Z"), (Standards.NACE2, "46.62")),
        ((Standards.NAF2, "46.63"), (Standards.NACE2, "46.63")),
        ((Standards.NAF2, "46.63Z"), (Standards.NACE2, "46.63")),
        ((Standards.NAF2, "46.64"), (Standards.NACE2, "46.64")),
        ((Standards.NAF2, "46.64Z"), (Standards.NACE2, "46.64")),
        ((Standards.NAF2, "46.65"), (Standards.NACE2, "46.65")),
        ((Standards.NAF2, "46.65Z"), (Standards.NACE2, "46.65")),
        ((Standards.NAF2, "46.66"), (Standards.NACE2, "46.66")),
        ((Standards.NAF2, "46.66Z"), (Standards.NACE2, "46.66")),
        ((Standards.NAF2, "46.69"), (Standards.NACE2, "46.69")),
        ((Standards.NAF2, "46.69A"), (Standards.NACE2, "46.69")),
        ((Standards.NAF2, "46.69B"), (Standards.NACE2, "46.69")),
        ((Standards.NAF2, "46.69C"), (Standards.NACE2, "46.69")),
        ((Standards.NAF2, "46.7"), (Standards.NACE2, "46.7")),
        ((Standards.NAF2, "46.71"), (Standards.NACE2, "46.71")),
        ((Standards.NAF2, "46.71Z"), (Standards.NACE2, "46.71")),
        ((Standards.NAF2, "46.72"), (Standards.NACE2, "46.72")),
        ((Standards.NAF2, "46.72Z"), (Standards.NACE2, "46.72")),
        ((Standards.NAF2, "46.73"), (Standards.NACE2, "46.73")),
        ((Standards.NAF2, "46.73A"), (Standards.NACE2, "46.73")),
        ((Standards.NAF2, "46.73B"), (Standards.NACE2, "46.73")),
        ((Standards.NAF2, "46.74"), (Standards.NACE2, "46.74")),
        ((Standards.NAF2, "46.74A"), (Standards.NACE2, "46.74")),
        ((Standards.NAF2, "46.74B"), (Standards.NACE2, "46.74")),
        ((Standards.NAF2, "46.75"), (Standards.NACE2, "46.75")),
        ((Standards.NAF2, "46.75Z"), (Standards.NACE2, "46.75")),
        ((Standards.NAF2, "46.76"), (Standards.NACE2, "46.76")),
        ((Standards.NAF2, "46.76Z"), (Standards.NACE2, "46.76")),
        ((Standards.NAF2, "46.77"), (Standards.NACE2, "46.77")),
        ((Standards.NAF2, "46.77Z"), (Standards.NACE2, "46.77")),
        ((Standards.NAF2, "46.9"), (Standards.NACE2, "46.9")),
        ((Standards.NAF2, "46.90"), (Standards.NACE2, "46.90")),
        ((Standards.NAF2, "46.90Z"), (Standards.NACE2, "46.90")),
        ((Standards.NAF2, "47"), (Standards.NACE2, "47")),
        ((Standards.NAF2, "47.1"), (Standards.NACE2, "47.1")),
        ((Standards.NAF2, "47.11"), (Standards.NACE2, "47.11")),
        ((Standards.NAF2, "47.11A"), (Standards.NACE2, "47.11")),
        ((Standards.NAF2, "47.11B"), (Standards.NACE2, "47.11")),
        ((Standards.NAF2, "47.11C"), (Standards.NACE2, "47.11")),
        ((Standards.NAF2, "47.11D"), (Standards.NACE2, "47.11")),
        ((Standards.NAF2, "47.11E"), (Standards.NACE2, "47.11")),
        ((Standards.NAF2, "47.11F"), (Standards.NACE2, "47.11")),
        ((Standards.NAF2, "47.19"), (Standards.NACE2, "47.19")),
        ((Standards.NAF2, "47.19A"), (Standards.NACE2, "47.19")),
        ((Standards.NAF2, "47.19B"), (Standards.NACE2, "47.19")),
        ((Standards.NAF2, "47.2"), (Standards.NACE2, "47.2")),
        ((Standards.NAF2, "47.21"), (Standards.NACE2, "47.21")),
        ((Standards.NAF2, "47.21Z"), (Standards.NACE2, "47.21")),
        ((Standards.NAF2, "47.22"), (Standards.NACE2, "47.22")),
        ((Standards.NAF2, "47.22Z"), (Standards.NACE2, "47.22")),
        ((Standards.NAF2, "47.23"), (Standards.NACE2, "47.23")),
        ((Standards.NAF2, "47.23Z"), (Standards.NACE2, "47.23")),
        ((Standards.NAF2, "47.24"), (Standards.NACE2, "47.24")),
        ((Standards.NAF2, "47.24Z"), (Standards.NACE2, "47.24")),
        ((Standards.NAF2, "47.25"), (Standards.NACE2, "47.25")),
        ((Standards.NAF2, "47.25Z"), (Standards.NACE2, "47.25")),
        ((Standards.NAF2, "47.26"), (Standards.NACE2, "47.26")),
        ((Standards.NAF2, "47.26Z"), (Standards.NACE2, "47.26")),
        ((Standards.NAF2, "47.29"), (Standards.NACE2, "47.29")),
        ((Standards.NAF2, "47.29Z"), (Standards.NACE2, "47.29")),
        ((Standards.NAF2, "47.3"), (Standards.NACE2, "47.3")),
        ((Standards.NAF2, "47.30"), (Standards.NACE2, "47.30")),
        ((Standards.NAF2, "47.30Z"), (Standards.NACE2, "47.30")),
        ((Standards.NAF2, "47.4"), (Standards.NACE2, "47.4")),
        ((Standards.NAF2, "47.41"), (Standards.NACE2, "47.41")),
        ((Standards.NAF2, "47.41Z"), (Standards.NACE2, "47.41")),
        ((Standards.NAF2, "47.42"), (Standards.NACE2, "47.42")),
        ((Standards.NAF2, "47.42Z"), (Standards.NACE2, "47.42")),
        ((Standards.NAF2, "47.43"), (Standards.NACE2, "47.43")),
        ((Standards.NAF2, "47.43Z"), (Standards.NACE2, "47.43")),
        ((Standards.NAF2, "47.5"), (Standards.NACE2, "47.5")),
        ((Standards.NAF2, "47.51"), (Standards.NACE2, "47.51")),
        ((Standards.NAF2, "47.51Z"), (Standards.NACE2, "47.51")),
        ((Standards.NAF2, "47.52"), (Standards.NACE2, "47.52")),
        ((Standards.NAF2, "47.52A"), (Standards.NACE2, "47.52")),
        ((Standards.NAF2, "47.52B"), (Standards.NACE2, "47.52")),
        ((Standards.NAF2, "47.53"), (Standards.NACE2, "47.53")),
        ((Standards.NAF2, "47.53Z"), (Standards.NACE2, "47.53")),
        ((Standards.NAF2, "47.54"), (Standards.NACE2, "47.54")),
        ((Standards.NAF2, "47.54Z"), (Standards.NACE2, "47.54")),
        ((Standards.NAF2, "47.59"), (Standards.NACE2, "47.59")),
        ((Standards.NAF2, "47.59A"), (Standards.NACE2, "47.59")),
        ((Standards.NAF2, "47.59B"), (Standards.NACE2, "47.59")),
        ((Standards.NAF2, "47.6"), (Standards.NACE2, "47.6")),
        ((Standards.NAF2, "47.61"), (Standards.NACE2, "47.61")),
        ((Standards.NAF2, "47.61Z"), (Standards.NACE2, "47.61")),
        ((Standards.NAF2, "47.62"), (Standards.NACE2, "47.62")),
        ((Standards.NAF2, "47.62Z"), (Standards.NACE2, "47.62")),
        ((Standards.NAF2, "47.63"), (Standards.NACE2, "47.63")),
        ((Standards.NAF2, "47.63Z"), (Standards.NACE2, "47.63")),
        ((Standards.NAF2, "47.64"), (Standards.NACE2, "47.64")),
        ((Standards.NAF2, "47.64Z"), (Standards.NACE2, "47.64")),
        ((Standards.NAF2, "47.65"), (Standards.NACE2, "47.65")),
        ((Standards.NAF2, "47.65Z"), (Standards.NACE2, "47.65")),
        ((Standards.NAF2, "47.7"), (Standards.NACE2, "47.7")),
        ((Standards.NAF2, "47.71"), (Standards.NACE2, "47.71")),
        ((Standards.NAF2, "47.71Z"), (Standards.NACE2, "47.71")),
        ((Standards.NAF2, "47.72"), (Standards.NACE2, "47.72")),
        ((Standards.NAF2, "47.72A"), (Standards.NACE2, "47.72")),
        ((Standards.NAF2, "47.72B"), (Standards.NACE2, "47.72")),
        ((Standards.NAF2, "47.73"), (Standards.NACE2, "47.73")),
        ((Standards.NAF2, "47.73Z"), (Standards.NACE2, "47.73")),
        ((Standards.NAF2, "47.74"), (Standards.NACE2, "47.74")),
        ((Standards.NAF2, "47.74Z"), (Standards.NACE2, "47.74")),
        ((Standards.NAF2, "47.75"), (Standards.NACE2, "47.75")),
        ((Standards.NAF2, "47.75Z"), (Standards.NACE2, "47.75")),
        ((Standards.NAF2, "47.76"), (Standards.NACE2, "47.76")),
        ((Standards.NAF2, "47.76Z"), (Standards.NACE2, "47.76")),
        ((Standards.NAF2, "47.77"), (Standards.NACE2, "47.77")),
        ((Standards.NAF2, "47.77Z"), (Standards.NACE2, "47.77")),
        ((Standards.NAF2, "47.78"), (Standards.NACE2, "47.78")),
        ((Standards.NAF2, "47.78A"), (Standards.NACE2, "47.78")),
        ((Standards.NAF2, "47.78B"), (Standards.NACE2, "47.78")),
        ((Standards.NAF2, "47.78C"), (Standards.NACE2, "47.78")),
        ((Standards.NAF2, "47.79"), (Standards.NACE2, "47.79")),
        ((Standards.NAF2, "47.79Z"), (Standards.NACE2, "47.79")),
        ((Standards.NAF2, "47.8"), (Standards.NACE2, "47.8")),
        ((Standards.NAF2, "47.81"), (Standards.NACE2, "47.81")),
        ((Standards.NAF2, "47.81Z"), (Standards.NACE2, "47.81")),
        ((Standards.NAF2, "47.82"), (Standards.NACE2, "47.82")),
        ((Standards.NAF2, "47.82Z"), (Standards.NACE2, "47.82")),
        ((Standards.NAF2, "47.89"), (Standards.NACE2, "47.89")),
        ((Standards.NAF2, "47.89Z"), (Standards.NACE2, "47.89")),
        ((Standards.NAF2, "47.9"), (Standards.NACE2, "47.9")),
        ((Standards.NAF2, "47.91"), (Standards.NACE2, "47.91")),
        ((Standards.NAF2, "47.91A"), (Standards.NACE2, "47.91")),
        ((Standards.NAF2, "47.91B"), (Standards.NACE2, "47.91")),
        ((Standards.NAF2, "47.99"), (Standards.NACE2, "47.99")),
        ((Standards.NAF2, "47.99A"), (Standards.NACE2, "47.99")),
        ((Standards.NAF2, "47.99B"), (Standards.NACE2, "47.99")),
        ((Standards.NAF2, "H"), (Standards.NACE2, "H")),
        ((Standards.NAF2, "49"), (Standards.NACE2, "49")),
        ((Standards.NAF2, "49.1"), (Standards.NACE2, "49.1")),
        ((Standards.NAF2, "49.10"), (Standards.NACE2, "49.10")),
        ((Standards.NAF2, "49.10Z"), (Standards.NACE2, "49.10")),
        ((Standards.NAF2, "49.2"), (Standards.NACE2, "49.2")),
        ((Standards.NAF2, "49.20"), (Standards.NACE2, "49.20")),
        ((Standards.NAF2, "49.20Z"), (Standards.NACE2, "49.20")),
        ((Standards.NAF2, "49.3"), (Standards.NACE2, "49.3")),
        ((Standards.NAF2, "49.31"), (Standards.NACE2, "49.31")),
        ((Standards.NAF2, "49.31Z"), (Standards.NACE2, "49.31")),
        ((Standards.NAF2, "49.32"), (Standards.NACE2, "49.32")),
        ((Standards.NAF2, "49.32Z"), (Standards.NACE2, "49.32")),
        ((Standards.NAF2, "49.39"), (Standards.NACE2, "49.39")),
        ((Standards.NAF2, "49.39A"), (Standards.NACE2, "49.39")),
        ((Standards.NAF2, "49.39B"), (Standards.NACE2, "49.39")),
        ((Standards.NAF2, "49.39C"), (Standards.NACE2, "49.39")),
        ((Standards.NAF2, "49.4"), (Standards.NACE2, "49.4")),
        ((Standards.NAF2, "49.41"), (Standards.NACE2, "49.41")),
        ((Standards.NAF2, "49.41A"), (Standards.NACE2, "49.41")),
        ((Standards.NAF2, "49.41B"), (Standards.NACE2, "49.41")),
        ((Standards.NAF2, "49.41C"), (Standards.NACE2, "49.41")),
        ((Standards.NAF2, "49.42"), (Standards.NACE2, "49.42")),
        ((Standards.NAF2, "49.42Z"), (Standards.NACE2, "49.42")),
        ((Standards.NAF2, "49.5"), (Standards.NACE2, "49.5")),
        ((Standards.NAF2, "49.50"), (Standards.NACE2, "49.50")),
        ((Standards.NAF2, "49.50Z"), (Standards.NACE2, "49.50")),
        ((Standards.NAF2, "50"), (Standards.NACE2, "50")),
        ((Standards.NAF2, "50.1"), (Standards.NACE2, "50.1")),
        ((Standards.NAF2, "50.10"), (Standards.NACE2, "50.10")),
        ((Standards.NAF2, "50.10Z"), (Standards.NACE2, "50.10")),
        ((Standards.NAF2, "50.2"), (Standards.NACE2, "50.2")),
        ((Standards.NAF2, "50.20"), (Standards.NACE2, "50.20")),
        ((Standards.NAF2, "50.20Z"), (Standards.NACE2, "50.20")),
        ((Standards.NAF2, "50.3"), (Standards.NACE2, "50.3")),
        ((Standards.NAF2, "50.30"), (Standards.NACE2, "50.30")),
        ((Standards.NAF2, "50.30Z"), (Standards.NACE2, "50.30")),
        ((Standards.NAF2, "50.4"), (Standards.NACE2, "50.4")),
        ((Standards.NAF2, "50.40"), (Standards.NACE2, "50.40")),
        ((Standards.NAF2, "50.40Z"), (Standards.NACE2, "50.40")),
        ((Standards.NAF2, "51"), (Standards.NACE2, "51")),
        ((Standards.NAF2, "51.1"), (Standards.NACE2, "51.1")),
        ((Standards.NAF2, "51.10"), (Standards.NACE2, "51.10")),
        ((Standards.NAF2, "51.10Z"), (Standards.NACE2, "51.10")),
        ((Standards.NAF2, "51.2"), (Standards.NACE2, "51.2")),
        ((Standards.NAF2, "51.21"), (Standards.NACE2, "51.21")),
        ((Standards.NAF2, "51.21Z"), (Standards.NACE2, "51.21")),
        ((Standards.NAF2, "51.22"), (Standards.NACE2, "51.22")),
        ((Standards.NAF2, "51.22Z"), (Standards.NACE2, "51.22")),
        ((Standards.NAF2, "52"), (Standards.NACE2, "52")),
        ((Standards.NAF2, "52.1"), (Standards.NACE2, "52.1")),
        ((Standards.NAF2, "52.10"), (Standards.NACE2, "52.10")),
        ((Standards.NAF2, "52.10A"), (Standards.NACE2, "52.10")),
        ((Standards.NAF2, "52.10B"), (Standards.NACE2, "52.10")),
        ((Standards.NAF2, "52.2"), (Standards.NACE2, "52.2")),
        ((Standards.NAF2, "52.21"), (Standards.NACE2, "52.21")),
        ((Standards.NAF2, "52.21Z"), (Standards.NACE2, "52.21")),
        ((Standards.NAF2, "52.22"), (Standards.NACE2, "52.22")),
        ((Standards.NAF2, "52.22Z"), (Standards.NACE2, "52.22")),
        ((Standards.NAF2, "52.23"), (Standards.NACE2, "52.23")),
        ((Standards.NAF2, "52.23Z"), (Standards.NACE2, "52.23")),
        ((Standards.NAF2, "52.24"), (Standards.NACE2, "52.24")),
        ((Standards.NAF2, "52.24A"), (Standards.NACE2, "52.24")),
        ((Standards.NAF2, "52.24B"), (Standards.NACE2, "52.24")),
        ((Standards.NAF2, "52.29"), (Standards.NACE2, "52.29")),
        ((Standards.NAF2, "52.29A"), (Standards.NACE2, "52.29")),
        ((Standards.NAF2, "52.29B"), (Standards.NACE2, "52.29")),
        ((Standards.NAF2, "53"), (Standards.NACE2, "53")),
        ((Standards.NAF2, "53.1"), (Standards.NACE2, "53.1")),
        ((Standards.NAF2, "53.10"), (Standards.NACE2, "53.10")),
        ((Standards.NAF2, "53.10Z"), (Standards.NACE2, "53.10")),
        ((Standards.NAF2, "53.2"), (Standards.NACE2, "53.2")),
        ((Standards.NAF2, "53.20"), (Standards.NACE2, "53.20")),
        ((Standards.NAF2, "53.20Z"), (Standards.NACE2, "53.20")),
        ((Standards.NAF2, "I"), (Standards.NACE2, "I")),
        ((Standards.NAF2, "55"), (Standards.NACE2, "55")),
        ((Standards.NAF2, "55.1"), (Standards.NACE2, "55.1")),
        ((Standards.NAF2, "55.10"), (Standards.NACE2, "55.10")),
        ((Standards.NAF2, "55.10Z"), (Standards.NACE2, "55.10")),
        ((Standards.NAF2, "55.2"), (Standards.NACE2, "55.2")),
        ((Standards.NAF2, "55.20"), (Standards.NACE2, "55.20")),
        ((Standards.NAF2, "55.20Z"), (Standards.NACE2, "55.20")),
        ((Standards.NAF2, "55.3"), (Standards.NACE2, "55.3")),
        ((Standards.NAF2, "55.30"), (Standards.NACE2, "55.30")),
        ((Standards.NAF2, "55.30Z"), (Standards.NACE2, "55.30")),
        ((Standards.NAF2, "55.9"), (Standards.NACE2, "55.9")),
        ((Standards.NAF2, "55.90"), (Standards.NACE2, "55.90")),
        ((Standards.NAF2, "55.90Z"), (Standards.NACE2, "55.90")),
        ((Standards.NAF2, "56"), (Standards.NACE2, "56")),
        ((Standards.NAF2, "56.1"), (Standards.NACE2, "56.1")),
        ((Standards.NAF2, "56.10"), (Standards.NACE2, "56.10")),
        ((Standards.NAF2, "56.10A"), (Standards.NACE2, "56.10")),
        ((Standards.NAF2, "56.10B"), (Standards.NACE2, "56.10")),
        ((Standards.NAF2, "56.10C"), (Standards.NACE2, "56.10")),
        ((Standards.NAF2, "56.2"), (Standards.NACE2, "56.2")),
        ((Standards.NAF2, "56.21"), (Standards.NACE2, "56.21")),
        ((Standards.NAF2, "56.21Z"), (Standards.NACE2, "56.21")),
        ((Standards.NAF2, "56.29"), (Standards.NACE2, "56.29")),
        ((Standards.NAF2, "56.29A"), (Standards.NACE2, "56.29")),
        ((Standards.NAF2, "56.29B"), (Standards.NACE2, "56.29")),
        ((Standards.NAF2, "56.3"), (Standards.NACE2, "56.3")),
        ((Standards.NAF2, "56.30"), (Standards.NACE2, "56.30")),
        ((Standards.NAF2, "56.30Z"), (Standards.NACE2, "56.30")),
        ((Standards.NAF2, "J"), (Standards.NACE2, "J")),
        ((Standards.NAF2, "58"), (Standards.NACE2, "58")),
        ((Standards.NAF2, "58.1"), (Standards.NACE2, "58.1")),
        ((Standards.NAF2, "58.11"), (Standards.NACE2, "58.11")),
        ((Standards.NAF2, "58.11Z"), (Standards.NACE2, "58.11")),
        ((Standards.NAF2, "58.12"), (Standards.NACE2, "58.12")),
        ((Standards.NAF2, "58.12Z"), (Standards.NACE2, "58.12")),
        ((Standards.NAF2, "58.13"), (Standards.NACE2, "58.13")),
        ((Standards.NAF2, "58.13Z"), (Standards.NACE2, "58.13")),
        ((Standards.NAF2, "58.14"), (Standards.NACE2, "58.14")),
        ((Standards.NAF2, "58.14Z"), (Standards.NACE2, "58.14")),
        ((Standards.NAF2, "58.19"), (Standards.NACE2, "58.19")),
        ((Standards.NAF2, "58.19Z"), (Standards.NACE2, "58.19")),
        ((Standards.NAF2, "58.2"), (Standards.NACE2, "58.2")),
        ((Standards.NAF2, "58.21"), (Standards.NACE2, "58.21")),
        ((Standards.NAF2, "58.21Z"), (Standards.NACE2, "58.21")),
        ((Standards.NAF2, "58.29"), (Standards.NACE2, "58.29")),
        ((Standards.NAF2, "58.29A"), (Standards.NACE2, "58.29")),
        ((Standards.NAF2, "58.29B"), (Standards.NACE2, "58.29")),
        ((Standards.NAF2, "58.29C"), (Standards.NACE2, "58.29")),
        ((Standards.NAF2, "59"), (Standards.NACE2, "59")),
        ((Standards.NAF2, "59.1"), (Standards.NACE2, "59.1")),
        ((Standards.NAF2, "59.11"), (Standards.NACE2, "59.11")),
        ((Standards.NAF2, "59.11A"), (Standards.NACE2, "59.11")),
        ((Standards.NAF2, "59.11B"), (Standards.NACE2, "59.11")),
        ((Standards.NAF2, "59.11C"), (Standards.NACE2, "59.11")),
        ((Standards.NAF2, "59.12"), (Standards.NACE2, "59.12")),
        ((Standards.NAF2, "59.12Z"), (Standards.NACE2, "59.12")),
        ((Standards.NAF2, "59.13"), (Standards.NACE2, "59.13")),
        ((Standards.NAF2, "59.13A"), (Standards.NACE2, "59.13")),
        ((Standards.NAF2, "59.13B"), (Standards.NACE2, "59.13")),
        ((Standards.NAF2, "59.14"), (Standards.NACE2, "59.14")),
        ((Standards.NAF2, "59.14Z"), (Standards.NACE2, "59.14")),
        ((Standards.NAF2, "59.2"), (Standards.NACE2, "59.2")),
        ((Standards.NAF2, "59.20"), (Standards.NACE2, "59.20")),
        ((Standards.NAF2, "59.20Z"), (Standards.NACE2, "59.20")),
        ((Standards.NAF2, "60"), (Standards.NACE2, "60")),
        ((Standards.NAF2, "60.1"), (Standards.NACE2, "60.1")),
        ((Standards.NAF2, "60.10"), (Standards.NACE2, "60.10")),
        ((Standards.NAF2, "60.10Z"), (Standards.NACE2, "60.10")),
        ((Standards.NAF2, "60.2"), (Standards.NACE2, "60.2")),
        ((Standards.NAF2, "60.20"), (Standards.NACE2, "60.20")),
        ((Standards.NAF2, "60.20A"), (Standards.NACE2, "60.20")),
        ((Standards.NAF2, "60.20B"), (Standards.NACE2, "60.20")),
        ((Standards.NAF2, "61"), (Standards.NACE2, "61")),
        ((Standards.NAF2, "61.1"), (Standards.NACE2, "61.1")),
        ((Standards.NAF2, "61.10"), (Standards.NACE2, "61.10")),
        ((Standards.NAF2, "61.10Z"), (Standards.NACE2, "61.10")),
        ((Standards.NAF2, "61.2"), (Standards.NACE2, "61.2")),
        ((Standards.NAF2, "61.20"), (Standards.NACE2, "61.20")),
        ((Standards.NAF2, "61.20Z"), (Standards.NACE2, "61.20")),
        ((Standards.NAF2, "61.3"), (Standards.NACE2, "61.3")),
        ((Standards.NAF2, "61.30"), (Standards.NACE2, "61.30")),
        ((Standards.NAF2, "61.30Z"), (Standards.NACE2, "61.30")),
        ((Standards.NAF2, "61.9"), (Standards.NACE2, "61.9")),
        ((Standards.NAF2, "61.90"), (Standards.NACE2, "61.90")),
        ((Standards.NAF2, "61.90Z"), (Standards.NACE2, "61.90")),
        ((Standards.NAF2, "62"), (Standards.NACE2, "62")),
        ((Standards.NAF2, "62.0"), (Standards.NACE2, "62.0")),
        ((Standards.NAF2, "62.01"), (Standards.NACE2, "62.01")),
        ((Standards.NAF2, "62.01Z"), (Standards.NACE2, "62.01")),
        ((Standards.NAF2, "62.02"), (Standards.NACE2, "62.02")),
        ((Standards.NAF2, "62.02A"), (Standards.NACE2, "62.02")),
        ((Standards.NAF2, "62.02B"), (Standards.NACE2, "62.02")),
        ((Standards.NAF2, "62.03"), (Standards.NACE2, "62.03")),
        ((Standards.NAF2, "62.03Z"), (Standards.NACE2, "62.03")),
        ((Standards.NAF2, "62.09"), (Standards.NACE2, "62.09")),
        ((Standards.NAF2, "62.09Z"), (Standards.NACE2, "62.09")),
        ((Standards.NAF2, "63"), (Standards.NACE2, "63")),
        ((Standards.NAF2, "63.1"), (Standards.NACE2, "63.1")),
        ((Standards.NAF2, "63.11"), (Standards.NACE2, "63.11")),
        ((Standards.NAF2, "63.11Z"), (Standards.NACE2, "63.11")),
        ((Standards.NAF2, "63.12"), (Standards.NACE2, "63.12")),
        ((Standards.NAF2, "63.12Z"), (Standards.NACE2, "63.12")),
        ((Standards.NAF2, "63.9"), (Standards.NACE2, "63.9")),
        ((Standards.NAF2, "63.91"), (Standards.NACE2, "63.91")),
        ((Standards.NAF2, "63.91Z"), (Standards.NACE2, "63.91")),
        ((Standards.NAF2, "63.99"), (Standards.NACE2, "63.99")),
        ((Standards.NAF2, "63.99Z"), (Standards.NACE2, "63.99")),
        ((Standards.NAF2, "K"), (Standards.NACE2, "K")),
        ((Standards.NAF2, "64"), (Standards.NACE2, "64")),
        ((Standards.NAF2, "64.1"), (Standards.NACE2, "64.1")),
        ((Standards.NAF2, "64.11"), (Standards.NACE2, "64.11")),
        ((Standards.NAF2, "64.11Z"), (Standards.NACE2, "64.11")),
        ((Standards.NAF2, "64.19"), (Standards.NACE2, "64.19")),
        ((Standards.NAF2, "64.19Z"), (Standards.NACE2, "64.19")),
        ((Standards.NAF2, "64.2"), (Standards.NACE2, "64.2")),
        ((Standards.NAF2, "64.20"), (Standards.NACE2, "64.20")),
        ((Standards.NAF2, "64.20Z"), (Standards.NACE2, "64.20")),
        ((Standards.NAF2, "64.3"), (Standards.NACE2, "64.3")),
        ((Standards.NAF2, "64.30"), (Standards.NACE2, "64.30")),
        ((Standards.NAF2, "64.30Z"), (Standards.NACE2, "64.30")),
        ((Standards.NAF2, "64.9"), (Standards.NACE2, "64.9")),
        ((Standards.NAF2, "64.91"), (Standards.NACE2, "64.91")),
        ((Standards.NAF2, "64.91Z"), (Standards.NACE2, "64.91")),
        ((Standards.NAF2, "64.92"), (Standards.NACE2, "64.92")),
        ((Standards.NAF2, "64.92Z"), (Standards.NACE2, "64.92")),
        ((Standards.NAF2, "64.99"), (Standards.NACE2, "64.99")),
        ((Standards.NAF2, "64.99Z"), (Standards.NACE2, "64.99")),
        ((Standards.NAF2, "65"), (Standards.NACE2, "65")),
        ((Standards.NAF2, "65.1"), (Standards.NACE2, "65.1")),
        ((Standards.NAF2, "65.11"), (Standards.NACE2, "65.11")),
        ((Standards.NAF2, "65.11Z"), (Standards.NACE2, "65.11")),
        ((Standards.NAF2, "65.12"), (Standards.NACE2, "65.12")),
        ((Standards.NAF2, "65.12Z"), (Standards.NACE2, "65.12")),
        ((Standards.NAF2, "65.2"), (Standards.NACE2, "65.2")),
        ((Standards.NAF2, "65.20"), (Standards.NACE2, "65.20")),
        ((Standards.NAF2, "65.20Z"), (Standards.NACE2, "65.20")),
        ((Standards.NAF2, "65.3"), (Standards.NACE2, "65.3")),
        ((Standards.NAF2, "65.30"), (Standards.NACE2, "65.30")),
        ((Standards.NAF2, "65.30Z"), (Standards.NACE2, "65.30")),
        ((Standards.NAF2, "66"), (Standards.NACE2, "66")),
        ((Standards.NAF2, "66.1"), (Standards.NACE2, "66.1")),
        ((Standards.NAF2, "66.11"), (Standards.NACE2, "66.11")),
        ((Standards.NAF2, "66.11Z"), (Standards.NACE2, "66.11")),
        ((Standards.NAF2, "66.12"), (Standards.NACE2, "66.12")),
        ((Standards.NAF2, "66.12Z"), (Standards.NACE2, "66.12")),
        ((Standards.NAF2, "66.19"), (Standards.NACE2, "66.19")),
        ((Standards.NAF2, "66.19A"), (Standards.NACE2, "66.19")),
        ((Standards.NAF2, "66.19B"), (Standards.NACE2, "66.19")),
        ((Standards.NAF2, "66.2"), (Standards.NACE2, "66.2")),
        ((Standards.NAF2, "66.21"), (Standards.NACE2, "66.21")),
        ((Standards.NAF2, "66.21Z"), (Standards.NACE2, "66.21")),
        ((Standards.NAF2, "66.22"), (Standards.NACE2, "66.22")),
        ((Standards.NAF2, "66.22Z"), (Standards.NACE2, "66.22")),
        ((Standards.NAF2, "66.29"), (Standards.NACE2, "66.29")),
        ((Standards.NAF2, "66.29Z"), (Standards.NACE2, "66.29")),
        ((Standards.NAF2, "66.3"), (Standards.NACE2, "66.3")),
        ((Standards.NAF2, "66.30"), (Standards.NACE2, "66.30")),
        ((Standards.NAF2, "66.30Z"), (Standards.NACE2, "66.30")),
        ((Standards.NAF2, "L"), (Standards.NACE2, "L")),
        ((Standards.NAF2, "68"), (Standards.NACE2, "68")),
        ((Standards.NAF2, "68.1"), (Standards.NACE2, "68.1")),
        ((Standards.NAF2, "68.10"), (Standards.NACE2, "68.10")),
        ((Standards.NAF2, "68.10Z"), (Standards.NACE2, "68.10")),
        ((Standards.NAF2, "68.2"), (Standards.NACE2, "68.2")),
        ((Standards.NAF2, "68.20"), (Standards.NACE2, "68.20")),
        ((Standards.NAF2, "68.20A"), (Standards.NACE2, "68.20")),
        ((Standards.NAF2, "68.20B"), (Standards.NACE2, "68.20")),
        ((Standards.NAF2, "68.3"), (Standards.NACE2, "68.3")),
        ((Standards.NAF2, "68.31"), (Standards.NACE2, "68.31")),
        ((Standards.NAF2, "68.31Z"), (Standards.NACE2, "68.31")),
        ((Standards.NAF2, "68.32"), (Standards.NACE2, "68.32")),
        ((Standards.NAF2, "68.32A"), (Standards.NACE2, "68.32")),
        ((Standards.NAF2, "68.32B"), (Standards.NACE2, "68.32")),
        ((Standards.NAF2, "M"), (Standards.NACE2, "M")),
        ((Standards.NAF2, "69"), (Standards.NACE2, "69")),
        ((Standards.NAF2, "69.1"), (Standards.NACE2, "69.1")),
        ((Standards.NAF2, "69.10"), (Standards.NACE2, "69.10")),
        ((Standards.NAF2, "69.10Z"), (Standards.NACE2, "69.10")),
        ((Standards.NAF2, "69.2"), (Standards.NACE2, "69.2")),
        ((Standards.NAF2, "69.20"), (Standards.NACE2, "69.20")),
        ((Standards.NAF2, "69.20Z"), (Standards.NACE2, "69.20")),
        ((Standards.NAF2, "70"), (Standards.NACE2, "70")),
        ((Standards.NAF2, "70.1"), (Standards.NACE2, "70.1")),
        ((Standards.NAF2, "70.10"), (Standards.NACE2, "70.10")),
        ((Standards.NAF2, "70.10Z"), (Standards.NACE2, "70.10")),
        ((Standards.NAF2, "70.2"), (Standards.NACE2, "70.2")),
        ((Standards.NAF2, "70.21"), (Standards.NACE2, "70.21")),
        ((Standards.NAF2, "70.21Z"), (Standards.NACE2, "70.21")),
        ((Standards.NAF2, "70.22"), (Standards.NACE2, "70.22")),
        ((Standards.NAF2, "70.22Z"), (Standards.NACE2, "70.22")),
        ((Standards.NAF2, "71"), (Standards.NACE2, "71")),
        ((Standards.NAF2, "71.1"), (Standards.NACE2, "71.1")),
        ((Standards.NAF2, "71.11"), (Standards.NACE2, "71.11")),
        ((Standards.NAF2, "71.11Z"), (Standards.NACE2, "71.11")),
        ((Standards.NAF2, "71.12"), (Standards.NACE2, "71.12")),
        ((Standards.NAF2, "71.12A"), (Standards.NACE2, "71.12")),
        ((Standards.NAF2, "71.12B"), (Standards.NACE2, "71.12")),
        ((Standards.NAF2, "71.2"), (Standards.NACE2, "71.2")),
        ((Standards.NAF2, "71.20"), (Standards.NACE2, "71.20")),
        ((Standards.NAF2, "71.20A"), (Standards.NACE2, "71.20")),
        ((Standards.NAF2, "71.20B"), (Standards.NACE2, "71.20")),
        ((Standards.NAF2, "72"), (Standards.NACE2, "72")),
        ((Standards.NAF2, "72.1"), (Standards.NACE2, "72.1")),
        ((Standards.NAF2, "72.11"), (Standards.NACE2, "72.11")),
        ((Standards.NAF2, "72.11Z"), (Standards.NACE2, "72.11")),
        ((Standards.NAF2, "72.19"), (Standards.NACE2, "72.19")),
        ((Standards.NAF2, "72.19Z"), (Standards.NACE2, "72.19")),
        ((Standards.NAF2, "72.2"), (Standards.NACE2, "72.2")),
        ((Standards.NAF2, "72.20"), (Standards.NACE2, "72.20")),
        ((Standards.NAF2, "72.20Z"), (Standards.NACE2, "72.20")),
        ((Standards.NAF2, "73"), (Standards.NACE2, "73")),
        ((Standards.NAF2, "73.1"), (Standards.NACE2, "73.1")),
        ((Standards.NAF2, "73.11"), (Standards.NACE2, "73.11")),
        ((Standards.NAF2, "73.11Z"), (Standards.NACE2, "73.11")),
        ((Standards.NAF2, "73.12"), (Standards.NACE2, "73.12")),
        ((Standards.NAF2, "73.12Z"), (Standards.NACE2, "73.12")),
        ((Standards.NAF2, "73.2"), (Standards.NACE2, "73.2")),
        ((Standards.NAF2, "73.20"), (Standards.NACE2, "73.20")),
        ((Standards.NAF2, "73.20Z"), (Standards.NACE2, "73.20")),
        ((Standards.NAF2, "74"), (Standards.NACE2, "74")),
        ((Standards.NAF2, "74.1"), (Standards.NACE2, "74.1")),
        ((Standards.NAF2, "74.10"), (Standards.NACE2, "74.10")),
        ((Standards.NAF2, "74.10Z"), (Standards.NACE2, "74.10")),
        ((Standards.NAF2, "74.2"), (Standards.NACE2, "74.2")),
        ((Standards.NAF2, "74.20"), (Standards.NACE2, "74.20")),
        ((Standards.NAF2, "74.20Z"), (Standards.NACE2, "74.20")),
        ((Standards.NAF2, "74.3"), (Standards.NACE2, "74.3")),
        ((Standards.NAF2, "74.30"), (Standards.NACE2, "74.30")),
        ((Standards.NAF2, "74.30Z"), (Standards.NACE2, "74.30")),
        ((Standards.NAF2, "74.9"), (Standards.NACE2, "74.9")),
        ((Standards.NAF2, "74.90"), (Standards.NACE2, "74.90")),
        ((Standards.NAF2, "74.90A"), (Standards.NACE2, "74.90")),
        ((Standards.NAF2, "74.90B"), (Standards.NACE2, "74.90")),
        ((Standards.NAF2, "75"), (Standards.NACE2, "75")),
        ((Standards.NAF2, "75.0"), (Standards.NACE2, "75.0")),
        ((Standards.NAF2, "75.00"), (Standards.NACE2, "75.00")),
        ((Standards.NAF2, "75.00Z"), (Standards.NACE2, "75.00")),
        ((Standards.NAF2, "N"), (Standards.NACE2, "N")),
        ((Standards.NAF2, "77"), (Standards.NACE2, "77")),
        ((Standards.NAF2, "77.1"), (Standards.NACE2, "77.1")),
        ((Standards.NAF2, "77.11"), (Standards.NACE2, "77.11")),
        ((Standards.NAF2, "77.11A"), (Standards.NACE2, "77.11")),
        ((Standards.NAF2, "77.11B"), (Standards.NACE2, "77.11")),
        ((Standards.NAF2, "77.12"), (Standards.NACE2, "77.12")),
        ((Standards.NAF2, "77.12Z"), (Standards.NACE2, "77.12")),
        ((Standards.NAF2, "77.2"), (Standards.NACE2, "77.2")),
        ((Standards.NAF2, "77.21"), (Standards.NACE2, "77.21")),
        ((Standards.NAF2, "77.21Z"), (Standards.NACE2, "77.21")),
        ((Standards.NAF2, "77.22"), (Standards.NACE2, "77.22")),
        ((Standards.NAF2, "77.22Z"), (Standards.NACE2, "77.22")),
        ((Standards.NAF2, "77.29"), (Standards.NACE2, "77.29")),
        ((Standards.NAF2, "77.29Z"), (Standards.NACE2, "77.29")),
        ((Standards.NAF2, "77.3"), (Standards.NACE2, "77.3")),
        ((Standards.NAF2, "77.31"), (Standards.NACE2, "77.31")),
        ((Standards.NAF2, "77.31Z"), (Standards.NACE2, "77.31")),
        ((Standards.NAF2, "77.32"), (Standards.NACE2, "77.32")),
        ((Standards.NAF2, "77.32Z"), (Standards.NACE2, "77.32")),
        ((Standards.NAF2, "77.33"), (Standards.NACE2, "77.33")),
        ((Standards.NAF2, "77.33Z"), (Standards.NACE2, "77.33")),
        ((Standards.NAF2, "77.34"), (Standards.NACE2, "77.34")),
        ((Standards.NAF2, "77.34Z"), (Standards.NACE2, "77.34")),
        ((Standards.NAF2, "77.35"), (Standards.NACE2, "77.35")),
        ((Standards.NAF2, "77.35Z"), (Standards.NACE2, "77.35")),
        ((Standards.NAF2, "77.39"), (Standards.NACE2, "77.39")),
        ((Standards.NAF2, "77.39Z"), (Standards.NACE2, "77.39")),
        ((Standards.NAF2, "77.4"), (Standards.NACE2, "77.4")),
        ((Standards.NAF2, "77.40"), (Standards.NACE2, "77.40")),
        ((Standards.NAF2, "77.40Z"), (Standards.NACE2, "77.40")),
        ((Standards.NAF2, "78"), (Standards.NACE2, "78")),
        ((Standards.NAF2, "78.1"), (Standards.NACE2, "78.1")),
        ((Standards.NAF2, "78.10"), (Standards.NACE2, "78.10")),
        ((Standards.NAF2, "78.10Z"), (Standards.NACE2, "78.10")),
        ((Standards.NAF2, "78.2"), (Standards.NACE2, "78.2")),
        ((Standards.NAF2, "78.20"), (Standards.NACE2, "78.20")),
        ((Standards.NAF2, "78.20Z"), (Standards.NACE2, "78.20")),
        ((Standards.NAF2, "78.3"), (Standards.NACE2, "78.3")),
        ((Standards.NAF2, "78.30"), (Standards.NACE2, "78.30")),
        ((Standards.NAF2, "78.30Z"), (Standards.NACE2, "78.30")),
        ((Standards.NAF2, "79"), (Standards.NACE2, "79")),
        ((Standards.NAF2, "79.1"), (Standards.NACE2, "79.1")),
        ((Standards.NAF2, "79.11"), (Standards.NACE2, "79.11")),
        ((Standards.NAF2, "79.11Z"), (Standards.NACE2, "79.11")),
        ((Standards.NAF2, "79.12"), (Standards.NACE2, "79.12")),
        ((Standards.NAF2, "79.12Z"), (Standards.NACE2, "79.12")),
        ((Standards.NAF2, "79.9"), (Standards.NACE2, "79.9")),
        ((Standards.NAF2, "79.90"), (Standards.NACE2, "79.90")),
        ((Standards.NAF2, "79.90Z"), (Standards.NACE2, "79.90")),
        ((Standards.NAF2, "80"), (Standards.NACE2, "80")),
        ((Standards.NAF2, "80.1"), (Standards.NACE2, "80.1")),
        ((Standards.NAF2, "80.10"), (Standards.NACE2, "80.10")),
        ((Standards.NAF2, "80.10Z"), (Standards.NACE2, "80.10")),
        ((Standards.NAF2, "80.2"), (Standards.NACE2, "80.2")),
        ((Standards.NAF2, "80.20"), (Standards.NACE2, "80.20")),
        ((Standards.NAF2, "80.20Z"), (Standards.NACE2, "80.20")),
        ((Standards.NAF2, "80.3"), (Standards.NACE2, "80.3")),
        ((Standards.NAF2, "80.30"), (Standards.NACE2, "80.30")),
        ((Standards.NAF2, "80.30Z"), (Standards.NACE2, "80.30")),
        ((Standards.NAF2, "81"), (Standards.NACE2, "81")),
        ((Standards.NAF2, "81.1"), (Standards.NACE2, "81.1")),
        ((Standards.NAF2, "81.10"), (Standards.NACE2, "81.10")),
        ((Standards.NAF2, "81.10Z"), (Standards.NACE2, "81.10")),
        ((Standards.NAF2, "81.2"), (Standards.NACE2, "81.2")),
        ((Standards.NAF2, "81.21"), (Standards.NACE2, "81.21")),
        ((Standards.NAF2, "81.21Z"), (Standards.NACE2, "81.21")),
        ((Standards.NAF2, "81.22"), (Standards.NACE2, "81.22")),
        ((Standards.NAF2, "81.22Z"), (Standards.NACE2, "81.22")),
        ((Standards.NAF2, "81.29"), (Standards.NACE2, "81.29")),
        ((Standards.NAF2, "81.29A"), (Standards.NACE2, "81.29")),
        ((Standards.NAF2, "81.29B"), (Standards.NACE2, "81.29")),
        ((Standards.NAF2, "81.3"), (Standards.NACE2, "81.3")),
        ((Standards.NAF2, "81.30"), (Standards.NACE2, "81.30")),
        ((Standards.NAF2, "81.30Z"), (Standards.NACE2, "81.30")),
        ((Standards.NAF2, "82"), (Standards.NACE2, "82")),
        ((Standards.NAF2, "82.1"), (Standards.NACE2, "82.1")),
        ((Standards.NAF2, "82.11"), (Standards.NACE2, "82.11")),
        ((Standards.NAF2, "82.11Z"), (Standards.NACE2, "82.11")),
        ((Standards.NAF2, "82.19"), (Standards.NACE2, "82.19")),
        ((Standards.NAF2, "82.19Z"), (Standards.NACE2, "82.19")),
        ((Standards.NAF2, "82.2"), (Standards.NACE2, "82.2")),
        ((Standards.NAF2, "82.20"), (Standards.NACE2, "82.20")),
        ((Standards.NAF2, "82.20Z"), (Standards.NACE2, "82.20")),
        ((Standards.NAF2, "82.3"), (Standards.NACE2, "82.3")),
        ((Standards.NAF2, "82.30"), (Standards.NACE2, "82.30")),
        ((Standards.NAF2, "82.30Z"), (Standards.NACE2, "82.30")),
        ((Standards.NAF2, "82.9"), (Standards.NACE2, "82.9")),
        ((Standards.NAF2, "82.91"), (Standards.NACE2, "82.91")),
        ((Standards.NAF2, "82.91Z"), (Standards.NACE2, "82.91")),
        ((Standards.NAF2, "82.92"), (Standards.NACE2, "82.92")),
        ((Standards.NAF2, "82.92Z"), (Standards.NACE2, "82.92")),
        ((Standards.NAF2, "82.99"), (Standards.NACE2, "82.99")),
        ((Standards.NAF2, "82.99Z"), (Standards.NACE2, "82.99")),
        ((Standards.NAF2, "O"), (Standards.NACE2, "O")),
        ((Standards.NAF2, "84"), (Standards.NACE2, "84")),
        ((Standards.NAF2, "84.1"), (Standards.NACE2, "84.1")),
        ((Standards.NAF2, "84.11"), (Standards.NACE2, "84.11")),
        ((Standards.NAF2, "84.11Z"), (Standards.NACE2, "84.11")),
        ((Standards.NAF2, "84.12"), (Standards.NACE2, "84.12")),
        ((Standards.NAF2, "84.12Z"), (Standards.NACE2, "84.12")),
        ((Standards.NAF2, "84.13"), (Standards.NACE2, "84.13")),
        ((Standards.NAF2, "84.13Z"), (Standards.NACE2, "84.13")),
        ((Standards.NAF2, "84.2"), (Standards.NACE2, "84.2")),
        ((Standards.NAF2, "84.21"), (Standards.NACE2, "84.21")),
        ((Standards.NAF2, "84.21Z"), (Standards.NACE2, "84.21")),
        ((Standards.NAF2, "84.22"), (Standards.NACE2, "84.22")),
        ((Standards.NAF2, "84.22Z"), (Standards.NACE2, "84.22")),
        ((Standards.NAF2, "84.23"), (Standards.NACE2, "84.23")),
        ((Standards.NAF2, "84.23Z"), (Standards.NACE2, "84.23")),
        ((Standards.NAF2, "84.24"), (Standards.NACE2, "84.24")),
        ((Standards.NAF2, "84.24Z"), (Standards.NACE2, "84.24")),
        ((Standards.NAF2, "84.25"), (Standards.NACE2, "84.25")),
        ((Standards.NAF2, "84.25Z"), (Standards.NACE2, "84.25")),
        ((Standards.NAF2, "84.3"), (Standards.NACE2, "84.3")),
        ((Standards.NAF2, "84.30"), (Standards.NACE2, "84.30")),
        ((Standards.NAF2, "84.30A"), (Standards.NACE2, "84.30")),
        ((Standards.NAF2, "84.30B"), (Standards.NACE2, "84.30")),
        ((Standards.NAF2, "84.30C"), (Standards.NACE2, "84.30")),
        ((Standards.NAF2, "P"), (Standards.NACE2, "P")),
        ((Standards.NAF2, "85"), (Standards.NACE2, "85")),
        ((Standards.NAF2, "85.1"), (Standards.NACE2, "85.1")),
        ((Standards.NAF2, "85.10"), (Standards.NACE2, "85.10")),
        ((Standards.NAF2, "85.10Z"), (Standards.NACE2, "85.10")),
        ((Standards.NAF2, "85.2"), (Standards.NACE2, "85.2")),
        ((Standards.NAF2, "85.20"), (Standards.NACE2, "85.20")),
        ((Standards.NAF2, "85.20Z"), (Standards.NACE2, "85.20")),
        ((Standards.NAF2, "85.3"), (Standards.NACE2, "85.3")),
        ((Standards.NAF2, "85.31"), (Standards.NACE2, "85.31")),
        ((Standards.NAF2, "85.31Z"), (Standards.NACE2, "85.31")),
        ((Standards.NAF2, "85.32"), (Standards.NACE2, "85.32")),
        ((Standards.NAF2, "85.32Z"), (Standards.NACE2, "85.32")),
        ((Standards.NAF2, "85.4"), (Standards.NACE2, "85.4")),
        ((Standards.NAF2, "85.41"), (Standards.NACE2, "85.41")),
        ((Standards.NAF2, "85.41Z"), (Standards.NACE2, "85.41")),
        ((Standards.NAF2, "85.42"), (Standards.NACE2, "85.42")),
        ((Standards.NAF2, "85.42Z"), (Standards.NACE2, "85.42")),
        ((Standards.NAF2, "85.5"), (Standards.NACE2, "85.5")),
        ((Standards.NAF2, "85.51"), (Standards.NACE2, "85.51")),
        ((Standards.NAF2, "85.51Z"), (Standards.NACE2, "85.51")),
        ((Standards.NAF2, "85.52"), (Standards.NACE2, "85.52")),
        ((Standards.NAF2, "85.52Z"), (Standards.NACE2, "85.52")),
        ((Standards.NAF2, "85.53"), (Standards.NACE2, "85.53")),
        ((Standards.NAF2, "85.53Z"), (Standards.NACE2, "85.53")),
        ((Standards.NAF2, "85.59"), (Standards.NACE2, "85.59")),
        ((Standards.NAF2, "85.59A"), (Standards.NACE2, "85.59")),
        ((Standards.NAF2, "85.59B"), (Standards.NACE2, "85.59")),
        ((Standards.NAF2, "85.6"), (Standards.NACE2, "85.6")),
        ((Standards.NAF2, "85.60"), (Standards.NACE2, "85.60")),
        ((Standards.NAF2, "85.60Z"), (Standards.NACE2, "85.60")),
        ((Standards.NAF2, "Q"), (Standards.NACE2, "Q")),
        ((Standards.NAF2, "86"), (Standards.NACE2, "86")),
        ((Standards.NAF2, "86.1"), (Standards.NACE2, "86.1")),
        ((Standards.NAF2, "86.10"), (Standards.NACE2, "86.10")),
        ((Standards.NAF2, "86.10Z"), (Standards.NACE2, "86.10")),
        ((Standards.NAF2, "86.2"), (Standards.NACE2, "86.2")),
        ((Standards.NAF2, "86.21"), (Standards.NACE2, "86.21")),
        ((Standards.NAF2, "86.21Z"), (Standards.NACE2, "86.21")),
        ((Standards.NAF2, "86.22"), (Standards.NACE2, "86.22")),
        ((Standards.NAF2, "86.22A"), (Standards.NACE2, "86.22")),
        ((Standards.NAF2, "86.22B"), (Standards.NACE2, "86.22")),
        ((Standards.NAF2, "86.22C"), (Standards.NACE2, "86.22")),
        ((Standards.NAF2, "86.23"), (Standards.NACE2, "86.23")),
        ((Standards.NAF2, "86.23Z"), (Standards.NACE2, "86.23")),
        ((Standards.NAF2, "86.9"), (Standards.NACE2, "86.9")),
        ((Standards.NAF2, "86.90"), (Standards.NACE2, "86.90")),
        ((Standards.NAF2, "86.90A"), (Standards.NACE2, "86.90")),
        ((Standards.NAF2, "86.90B"), (Standards.NACE2, "86.90")),
        ((Standards.NAF2, "86.90C"), (Standards.NACE2, "86.90")),
        ((Standards.NAF2, "86.90D"), (Standards.NACE2, "86.90")),
        ((Standards.NAF2, "86.90E"), (Standards.NACE2, "86.90")),
        ((Standards.NAF2, "86.90F"), (Standards.NACE2, "86.90")),
        ((Standards.NAF2, "87"), (Standards.NACE2, "87")),
        ((Standards.NAF2, "87.1"), (Standards.NACE2, "87.1")),
        ((Standards.NAF2, "87.10"), (Standards.NACE2, "87.10")),
        ((Standards.NAF2, "87.10A"), (Standards.NACE2, "87.10")),
        ((Standards.NAF2, "87.10B"), (Standards.NACE2, "87.10")),
        ((Standards.NAF2, "87.10C"), (Standards.NACE2, "87.10")),
        ((Standards.NAF2, "87.2"), (Standards.NACE2, "87.2")),
        ((Standards.NAF2, "87.20"), (Standards.NACE2, "87.20")),
        ((Standards.NAF2, "87.20A"), (Standards.NACE2, "87.20")),
        ((Standards.NAF2, "87.20B"), (Standards.NACE2, "87.20")),
        ((Standards.NAF2, "87.3"), (Standards.NACE2, "87.3")),
        ((Standards.NAF2, "87.30"), (Standards.NACE2, "87.30")),
        ((Standards.NAF2, "87.30A"), (Standards.NACE2, "87.30")),
        ((Standards.NAF2, "87.30B"), (Standards.NACE2, "87.30")),
        ((Standards.NAF2, "87.9"), (Standards.NACE2, "87.9")),
        ((Standards.NAF2, "87.90"), (Standards.NACE2, "87.90")),
        ((Standards.NAF2, "87.90A"), (Standards.NACE2, "87.90")),
        ((Standards.NAF2, "87.90B"), (Standards.NACE2, "87.90")),
        ((Standards.NAF2, "88"), (Standards.NACE2, "88")),
        ((Standards.NAF2, "88.1"), (Standards.NACE2, "88.1")),
        ((Standards.NAF2, "88.10"), (Standards.NACE2, "88.10")),
        ((Standards.NAF2, "88.10A"), (Standards.NACE2, "88.10")),
        ((Standards.NAF2, "88.10B"), (Standards.NACE2, "88.10")),
        ((Standards.NAF2, "88.10C"), (Standards.NACE2, "88.10")),
        ((Standards.NAF2, "88.9"), (Standards.NACE2, "88.9")),
        ((Standards.NAF2, "88.91"), (Standards.NACE2, "88.91")),
        ((Standards.NAF2, "88.91A"), (Standards.NACE2, "88.91")),
        ((Standards.NAF2, "88.91B"), (Standards.NACE2, "88.91")),
        ((Standards.NAF2, "88.99"), (Standards.NACE2, "88.99")),
        ((Standards.NAF2, "88.99A"), (Standards.NACE2, "88.99")),
        ((Standards.NAF2, "88.99B"), (Standards.NACE2, "88.99")),
        ((Standards.NAF2, "R"), (Standards.NACE2, "R")),
        ((Standards.NAF2, "90"), (Standards.NACE2, "90")),
        ((Standards.NAF2, "90.0"), (Standards.NACE2, "90.0")),
        ((Standards.NAF2, "90.01"), (Standards.NACE2, "90.01")),
        ((Standards.NAF2, "90.01Z"), (Standards.NACE2, "90.01")),
        ((Standards.NAF2, "90.02"), (Standards.NACE2, "90.02")),
        ((Standards.NAF2, "90.02Z"), (Standards.NACE2, "90.02")),
        ((Standards.NAF2, "90.03"), (Standards.NACE2, "90.03")),
        ((Standards.NAF2, "90.03A"), (Standards.NACE2, "90.03")),
        ((Standards.NAF2, "90.03B"), (Standards.NACE2, "90.03")),
        ((Standards.NAF2, "90.04"), (Standards.NACE2, "90.04")),
        ((Standards.NAF2, "90.04Z"), (Standards.NACE2, "90.04")),
        ((Standards.NAF2, "91"), (Standards.NACE2, "91")),
        ((Standards.NAF2, "91.0"), (Standards.NACE2, "91.0")),
        ((Standards.NAF2, "91.01"), (Standards.NACE2, "91.01")),
        ((Standards.NAF2, "91.01Z"), (Standards.NACE2, "91.01")),
        ((Standards.NAF2, "91.02"), (Standards.NACE2, "91.02")),
        ((Standards.NAF2, "91.02Z"), (Standards.NACE2, "91.02")),
        ((Standards.NAF2, "91.03"), (Standards.NACE2, "91.03")),
        ((Standards.NAF2, "91.03Z"), (Standards.NACE2, "91.03")),
        ((Standards.NAF2, "91.04"), (Standards.NACE2, "91.04")),
        ((Standards.NAF2, "91.04Z"), (Standards.NACE2, "91.04")),
        ((Standards.NAF2, "92"), (Standards.NACE2, "92")),
        ((Standards.NAF2, "92.0"), (Standards.NACE2, "92.0")),
        ((Standards.NAF2, "92.00"), (Standards.NACE2, "92.00")),
        ((Standards.NAF2, "92.00Z"), (Standards.NACE2, "92.00")),
        ((Standards.NAF2, "93"), (Standards.NACE2, "93")),
        ((Standards.NAF2, "93.1"), (Standards.NACE2, "93.1")),
        ((Standards.NAF2, "93.11"), (Standards.NACE2, "93.11")),
        ((Standards.NAF2, "93.11Z"), (Standards.NACE2, "93.11")),
        ((Standards.NAF2, "93.12"), (Standards.NACE2, "93.12")),
        ((Standards.NAF2, "93.12Z"), (Standards.NACE2, "93.12")),
        ((Standards.NAF2, "93.13"), (Standards.NACE2, "93.13")),
        ((Standards.NAF2, "93.13Z"), (Standards.NACE2, "93.13")),
        ((Standards.NAF2, "93.19"), (Standards.NACE2, "93.19")),
        ((Standards.NAF2, "93.19Z"), (Standards.NACE2, "93.19")),
        ((Standards.NAF2, "93.2"), (Standards.NACE2, "93.2")),
        ((Standards.NAF2, "93.21"), (Standards.NACE2, "93.21")),
        ((Standards.NAF2, "93.21Z"), (Standards.NACE2, "93.21")),
        ((Standards.NAF2, "93.29"), (Standards.NACE2, "93.29")),
        ((Standards.NAF2, "93.29Z"), (Standards.NACE2, "93.29")),
        ((Standards.NAF2, "S"), (Standards.NACE2, "S")),
        ((Standards.NAF2, "94"), (Standards.NACE2, "94")),
        ((Standards.NAF2, "94.1"), (Standards.NACE2, "94.1")),
        ((Standards.NAF2, "94.11"), (Standards.NACE2, "94.11")),
        ((Standards.NAF2, "94.11Z"), (Standards.NACE2, "94.11")),
        ((Standards.NAF2, "94.12"), (Standards.NACE2, "94.12")),
        ((Standards.NAF2, "94.12Z"), (Standards.NACE2, "94.12")),
        ((Standards.NAF2, "94.2"), (Standards.NACE2, "94.2")),
        ((Standards.NAF2, "94.20"), (Standards.NACE2, "94.20")),
        ((Standards.NAF2, "94.20Z"), (Standards.NACE2, "94.20")),
        ((Standards.NAF2, "94.9"), (Standards.NACE2, "94.9")),
        ((Standards.NAF2, "94.91"), (Standards.NACE2, "94.91")),
        ((Standards.NAF2, "94.91Z"), (Standards.NACE2, "94.91")),
        ((Standards.NAF2, "94.92"), (Standards.NACE2, "94.92")),
        ((Standards.NAF2, "94.92Z"), (Standards.NACE2, "94.92")),
        ((Standards.NAF2, "94.99"), (Standards.NACE2, "94.99")),
        ((Standards.NAF2, "94.99Z"), (Standards.NACE2, "94.99")),
        ((Standards.NAF2, "95"), (Standards.NACE2, "95")),
        ((Standards.NAF2, "95.1"), (Standards.NACE2, "95.1")),
        ((Standards.NAF2, "95.11"), (Standards.NACE2, "95.11")),
        ((Standards.NAF2, "95.11Z"), (Standards.NACE2, "95.11")),
        ((Standards.NAF2, "95.12"), (Standards.NACE2, "95.12")),
        ((Standards.NAF2, "95.12Z"), (Standards.NACE2, "95.12")),
        ((Standards.NAF2, "95.2"), (Standards.NACE2, "95.2")),
        ((Standards.NAF2, "95.21"), (Standards.NACE2, "95.21")),
        ((Standards.NAF2, "95.21Z"), (Standards.NACE2, "95.21")),
        ((Standards.NAF2, "95.22"), (Standards.NACE2, "95.22")),
        ((Standards.NAF2, "95.22Z"), (Standards.NACE2, "95.22")),
        ((Standards.NAF2, "95.23"), (Standards.NACE2, "95.23")),
        ((Standards.NAF2, "95.23Z"), (Standards.NACE2, "95.23")),
        ((Standards.NAF2, "95.24"), (Standards.NACE2, "95.24")),
        ((Standards.NAF2, "95.24Z"), (Standards.NACE2, "95.24")),
        ((Standards.NAF2, "95.25"), (Standards.NACE2, "95.25")),
        ((Standards.NAF2, "95.25Z"), (Standards.NACE2, "95.25")),
        ((Standards.NAF2, "95.29"), (Standards.NACE2, "95.29")),
        ((Standards.NAF2, "95.29Z"), (Standards.NACE2, "95.29")),
        ((Standards.NAF2, "96"), (Standards.NACE2, "96")),
        ((Standards.NAF2, "96.0"), (Standards.NACE2, "96.0")),
        ((Standards.NAF2, "96.01"), (Standards.NACE2, "96.01")),
        ((Standards.NAF2, "96.01A"), (Standards.NACE2, "96.01")),
        ((Standards.NAF2, "96.01B"), (Standards.NACE2, "96.01")),
        ((Standards.NAF2, "96.02"), (Standards.NACE2, "96.02")),
        ((Standards.NAF2, "96.02A"), (Standards.NACE2, "96.02")),
        ((Standards.NAF2, "96.02B"), (Standards.NACE2, "96.02")),
        ((Standards.NAF2, "96.03"), (Standards.NACE2, "96.03")),
        ((Standards.NAF2, "96.03Z"), (Standards.NACE2, "96.03")),
        ((Standards.NAF2, "96.04"), (Standards.NACE2, "96.04")),
        ((Standards.NAF2, "96.04Z"), (Standards.NACE2, "96.04")),
        ((Standards.NAF2, "96.09"), (Standards.NACE2, "96.09")),
        ((Standards.NAF2, "96.09Z"), (Standards.NACE2, "96.09")),
        ((Standards.NAF2, "T"), (Standards.NACE2, "T")),
        ((Standards.NAF2, "97"), (Standards.NACE2, "97")),
        ((Standards.NAF2, "97.0"), (Standards.NACE2, "97.0")),
        ((Standards.NAF2, "97.00"), (Standards.NACE2, "97.00")),
        ((Standards.NAF2, "97.00Z"), (Standards.NACE2, "97.00")),
        ((Standards.NAF2, "98"), (Standards.NACE2, "98")),
        ((Standards.NAF2, "98.1"), (Standards.NACE2, "98.1")),
        ((Standards.NAF2, "98.10"), (Standards.NACE2, "98.10")),
        ((Standards.NAF2, "98.10Z"), (Standards.NACE2, "98.10")),
        ((Standards.NAF2, "98.2"), (Standards.NACE2, "98.2")),
        ((Standards.NAF2, "98.20"), (Standards.NACE2, "98.20")),
        ((Standards.NAF2, "98.20Z"), (Standards.NACE2, "98.20")),
        ((Standards.NAF2, "U"), (Standards.NACE2, "U")),
        ((Standards.NAF2, "99"), (Standards.NACE2, "99")),
        ((Standards.NAF2, "99.0"), (Standards.NACE2, "99.0")),
        ((Standards.NAF2, "99.00"), (Standards.NACE2, "99.00")),
        ((Standards.NAF2, "99.00Z"), (Standards.NACE2, "99.00")),
    ],
)
