# -*- coding: utf-8 -*-
"""`Concordance between NAF1 and NAF2 <https://www.insee.fr/fr/information/2579599>`_.
"""
from ...types import Concordance, Standards
from ..naf2 import NAF2
from . import NAF1

NAF1_to_NAF2 = Concordance(
    src=NAF1,
    dst=NAF2,
    concordances=[
        ((Standards.NAF1, "01.1A"), (Standards.NAF2, "01.11Z")),
        ((Standards.NAF1, "01.1A"), (Standards.NAF2, "01.12Z")),
        ((Standards.NAF1, "01.1A"), (Standards.NAF2, "01.13Z")),
        ((Standards.NAF1, "01.1A"), (Standards.NAF2, "01.14Z")),
        ((Standards.NAF1, "01.1A"), (Standards.NAF2, "01.15Z")),
        ((Standards.NAF1, "01.1A"), (Standards.NAF2, "01.16Z")),
        ((Standards.NAF1, "01.1A"), (Standards.NAF2, "01.19Z")),
        ((Standards.NAF1, "01.1A"), (Standards.NAF2, "01.26Z")),
        ((Standards.NAF1, "01.1A"), (Standards.NAF2, "01.28Z")),
        ((Standards.NAF1, "01.1A"), (Standards.NAF2, "01.29Z")),
        ((Standards.NAF1, "01.1A"), (Standards.NAF2, "01.63Z")),
        ((Standards.NAF1, "01.1A"), (Standards.NAF2, "01.64Z")),
        ((Standards.NAF1, "01.1C"), (Standards.NAF2, "01.11Z")),
        ((Standards.NAF1, "01.1C"), (Standards.NAF2, "01.13Z")),
        ((Standards.NAF1, "01.1C"), (Standards.NAF2, "01.28Z")),
        ((Standards.NAF1, "01.1C"), (Standards.NAF2, "01.64Z")),
        ((Standards.NAF1, "01.1C"), (Standards.NAF2, "02.30Z")),
        ((Standards.NAF1, "01.1D"), (Standards.NAF2, "01.13Z")),
        ((Standards.NAF1, "01.1D"), (Standards.NAF2, "01.19Z")),
        ((Standards.NAF1, "01.1D"), (Standards.NAF2, "01.25Z")),
        ((Standards.NAF1, "01.1D"), (Standards.NAF2, "01.30Z")),
        ((Standards.NAF1, "01.1D"), (Standards.NAF2, "01.64Z")),
        ((Standards.NAF1, "01.1D"), (Standards.NAF2, "02.10Z")),
        ((Standards.NAF1, "01.1F"), (Standards.NAF2, "01.22Z")),
        ((Standards.NAF1, "01.1F"), (Standards.NAF2, "01.23Z")),
        ((Standards.NAF1, "01.1F"), (Standards.NAF2, "01.24Z")),
        ((Standards.NAF1, "01.1F"), (Standards.NAF2, "01.25Z")),
        ((Standards.NAF1, "01.1F"), (Standards.NAF2, "01.26Z")),
        ((Standards.NAF1, "01.1F"), (Standards.NAF2, "01.27Z")),
        ((Standards.NAF1, "01.1F"), (Standards.NAF2, "01.28Z")),
        ((Standards.NAF1, "01.1F"), (Standards.NAF2, "01.63Z")),
        ((Standards.NAF1, "01.1F"), (Standards.NAF2, "01.64Z")),
        ((Standards.NAF1, "01.1F"), (Standards.NAF2, "02.30Z")),
        ((Standards.NAF1, "01.1F"), (Standards.NAF2, "10.41A")),
        ((Standards.NAF1, "01.1G"), (Standards.NAF2, "01.21Z")),
        ((Standards.NAF1, "01.1G"), (Standards.NAF2, "01.64Z")),
        ((Standards.NAF1, "01.1G"), (Standards.NAF2, "11.02A")),
        ((Standards.NAF1, "01.1G"), (Standards.NAF2, "11.02B")),
        ((Standards.NAF1, "01.2A"), (Standards.NAF2, "01.41Z")),
        ((Standards.NAF1, "01.2A"), (Standards.NAF2, "01.42Z")),
        ((Standards.NAF1, "01.2C"), (Standards.NAF2, "01.43Z")),
        ((Standards.NAF1, "01.2C"), (Standards.NAF2, "01.45Z")),
        ((Standards.NAF1, "01.2C"), (Standards.NAF2, "01.49Z")),
        ((Standards.NAF1, "01.2C"), (Standards.NAF2, "01.62Z")),
        ((Standards.NAF1, "01.2C"), (Standards.NAF2, "10.11Z")),
        ((Standards.NAF1, "01.2E"), (Standards.NAF2, "01.46Z")),
        ((Standards.NAF1, "01.2G"), (Standards.NAF2, "01.47Z")),
        ((Standards.NAF1, "01.2J"), (Standards.NAF2, "01.44Z")),
        ((Standards.NAF1, "01.2J"), (Standards.NAF2, "01.49Z")),
        ((Standards.NAF1, "01.2J"), (Standards.NAF2, "03.22Z")),
        ((Standards.NAF1, "01.3Z"), (Standards.NAF2, "01.50Z")),
        ((Standards.NAF1, "01.4A"), (Standards.NAF2, "01.61Z")),
        ((Standards.NAF1, "01.4A"), (Standards.NAF2, "01.63Z")),
        ((Standards.NAF1, "01.4A"), (Standards.NAF2, "10.39A")),
        ((Standards.NAF1, "01.4A"), (Standards.NAF2, "10.39B")),
        ((Standards.NAF1, "01.4B"), (Standards.NAF2, "81.30Z")),
        ((Standards.NAF1, "01.4D"), (Standards.NAF2, "01.62Z")),
        ((Standards.NAF1, "01.5Z"), (Standards.NAF2, "01.70Z")),
        ((Standards.NAF1, "01.5Z"), (Standards.NAF2, "94.99Z")),
        ((Standards.NAF1, "02.0A"), (Standards.NAF2, "01.29Z")),
        ((Standards.NAF1, "02.0A"), (Standards.NAF2, "02.10Z")),
        ((Standards.NAF1, "02.0A"), (Standards.NAF2, "02.30Z")),
        ((Standards.NAF1, "02.0B"), (Standards.NAF2, "02.20Z")),
        ((Standards.NAF1, "02.0B"), (Standards.NAF2, "16.10A")),
        ((Standards.NAF1, "02.0D"), (Standards.NAF2, "02.40Z")),
        ((Standards.NAF1, "05.0A"), (Standards.NAF2, "03.11Z")),
        ((Standards.NAF1, "05.0A"), (Standards.NAF2, "03.12Z")),
        ((Standards.NAF1, "05.0A"), (Standards.NAF2, "70.22Z")),
        ((Standards.NAF1, "05.0C"), (Standards.NAF2, "03.21Z")),
        ((Standards.NAF1, "05.0C"), (Standards.NAF2, "03.22Z")),
        ((Standards.NAF1, "10.1Z"), (Standards.NAF2, "05.10Z")),
        ((Standards.NAF1, "10.1Z"), (Standards.NAF2, "09.90Z")),
        ((Standards.NAF1, "10.1Z"), (Standards.NAF2, "19.20Z")),
        ((Standards.NAF1, "10.2Z"), (Standards.NAF2, "05.20Z")),
        ((Standards.NAF1, "10.2Z"), (Standards.NAF2, "09.90Z")),
        ((Standards.NAF1, "10.2Z"), (Standards.NAF2, "19.20Z")),
        ((Standards.NAF1, "10.3Z"), (Standards.NAF2, "08.92Z")),
        ((Standards.NAF1, "10.3Z"), (Standards.NAF2, "09.90Z")),
        ((Standards.NAF1, "10.3Z"), (Standards.NAF2, "19.20Z")),
        ((Standards.NAF1, "11.1Z"), (Standards.NAF2, "06.10Z")),
        ((Standards.NAF1, "11.1Z"), (Standards.NAF2, "06.20Z")),
        ((Standards.NAF1, "11.1Z"), (Standards.NAF2, "09.10Z")),
        ((Standards.NAF1, "11.2Z"), (Standards.NAF2, "09.10Z")),
        ((Standards.NAF1, "12.0Z"), (Standards.NAF2, "07.21Z")),
        ((Standards.NAF1, "12.0Z"), (Standards.NAF2, "09.90Z")),
        ((Standards.NAF1, "13.1Z"), (Standards.NAF2, "07.10Z")),
        ((Standards.NAF1, "13.1Z"), (Standards.NAF2, "09.90Z")),
        ((Standards.NAF1, "13.2Z"), (Standards.NAF2, "07.29Z")),
        ((Standards.NAF1, "13.2Z"), (Standards.NAF2, "09.90Z")),
        ((Standards.NAF1, "14.1A"), (Standards.NAF2, "08.11Z")),
        ((Standards.NAF1, "14.1A"), (Standards.NAF2, "09.90Z")),
        ((Standards.NAF1, "14.1C"), (Standards.NAF2, "08.11Z")),
        ((Standards.NAF1, "14.1C"), (Standards.NAF2, "09.90Z")),
        ((Standards.NAF1, "14.1E"), (Standards.NAF2, "08.11Z")),
        ((Standards.NAF1, "14.1E"), (Standards.NAF2, "09.90Z")),
        ((Standards.NAF1, "14.2A"), (Standards.NAF2, "08.12Z")),
        ((Standards.NAF1, "14.2A"), (Standards.NAF2, "09.90Z")),
        ((Standards.NAF1, "14.2C"), (Standards.NAF2, "08.12Z")),
        ((Standards.NAF1, "14.2C"), (Standards.NAF2, "09.90Z")),
        ((Standards.NAF1, "14.3Z"), (Standards.NAF2, "08.91Z")),
        ((Standards.NAF1, "14.3Z"), (Standards.NAF2, "09.90Z")),
        ((Standards.NAF1, "14.4Z"), (Standards.NAF2, "08.93Z")),
        ((Standards.NAF1, "14.4Z"), (Standards.NAF2, "09.90Z")),
        ((Standards.NAF1, "14.4Z"), (Standards.NAF2, "10.84Z")),
        ((Standards.NAF1, "14.5Z"), (Standards.NAF2, "08.99Z")),
        ((Standards.NAF1, "14.5Z"), (Standards.NAF2, "09.90Z")),
        ((Standards.NAF1, "14.5Z"), (Standards.NAF2, "38.21Z")),
        ((Standards.NAF1, "15.1A"), (Standards.NAF2, "01.49Z")),
        ((Standards.NAF1, "15.1A"), (Standards.NAF2, "10.11Z")),
        ((Standards.NAF1, "15.1C"), (Standards.NAF2, "10.11Z")),
        ((Standards.NAF1, "15.1C"), (Standards.NAF2, "10.12Z")),
        ((Standards.NAF1, "15.1E"), (Standards.NAF2, "10.13A")),
        ((Standards.NAF1, "15.1E"), (Standards.NAF2, "10.85Z")),
        ((Standards.NAF1, "15.1E"), (Standards.NAF2, "10.89Z")),
        ((Standards.NAF1, "15.1F"), (Standards.NAF2, "10.13B")),
        ((Standards.NAF1, "15.1F"), (Standards.NAF2, "10.89Z")),
        ((Standards.NAF1, "15.1F"), (Standards.NAF2, "56.10C")),
        ((Standards.NAF1, "15.2Z"), (Standards.NAF2, "10.20Z")),
        ((Standards.NAF1, "15.2Z"), (Standards.NAF2, "10.85Z")),
        ((Standards.NAF1, "15.3A"), (Standards.NAF2, "10.31Z")),
        ((Standards.NAF1, "15.3A"), (Standards.NAF2, "10.85Z")),
        ((Standards.NAF1, "15.3C"), (Standards.NAF2, "10.32Z")),
        ((Standards.NAF1, "15.3E"), (Standards.NAF2, "10.39A")),
        ((Standards.NAF1, "15.3E"), (Standards.NAF2, "10.85Z")),
        ((Standards.NAF1, "15.3F"), (Standards.NAF2, "10.39B")),
        ((Standards.NAF1, "15.3F"), (Standards.NAF2, "10.85Z")),
        ((Standards.NAF1, "15.4A"), (Standards.NAF2, "10.41A")),
        ((Standards.NAF1, "15.4C"), (Standards.NAF2, "10.41B")),
        ((Standards.NAF1, "15.4E"), (Standards.NAF2, "10.42Z")),
        ((Standards.NAF1, "15.5A"), (Standards.NAF2, "10.51A")),
        ((Standards.NAF1, "15.5B"), (Standards.NAF2, "10.51B")),
        ((Standards.NAF1, "15.5C"), (Standards.NAF2, "10.51C")),
        ((Standards.NAF1, "15.5D"), (Standards.NAF2, "10.51D")),
        ((Standards.NAF1, "15.5F"), (Standards.NAF2, "10.52Z")),
        ((Standards.NAF1, "15.6A"), (Standards.NAF2, "10.61A")),
        ((Standards.NAF1, "15.6B"), (Standards.NAF2, "10.61B")),
        ((Standards.NAF1, "15.6D"), (Standards.NAF2, "10.62Z")),
        ((Standards.NAF1, "15.6D"), (Standards.NAF2, "10.89Z")),
        ((Standards.NAF1, "15.7A"), (Standards.NAF2, "10.91Z")),
        ((Standards.NAF1, "15.7C"), (Standards.NAF2, "10.92Z")),
        ((Standards.NAF1, "15.8A"), (Standards.NAF2, "10.71A")),
        ((Standards.NAF1, "15.8A"), (Standards.NAF2, "10.85Z")),
        ((Standards.NAF1, "15.8A"), (Standards.NAF2, "10.89Z")),
        ((Standards.NAF1, "15.8B"), (Standards.NAF2, "10.71B")),
        ((Standards.NAF1, "15.8B"), (Standards.NAF2, "56.10C")),
        ((Standards.NAF1, "15.8C"), (Standards.NAF2, "10.71C")),
        ((Standards.NAF1, "15.8C"), (Standards.NAF2, "10.89Z")),
        ((Standards.NAF1, "15.8D"), (Standards.NAF2, "10.71D")),
        ((Standards.NAF1, "15.8D"), (Standards.NAF2, "10.89Z")),
        ((Standards.NAF1, "15.8F"), (Standards.NAF2, "10.72Z")),
        ((Standards.NAF1, "15.8H"), (Standards.NAF2, "10.81Z")),
        ((Standards.NAF1, "15.8K"), (Standards.NAF2, "10.82Z")),
        ((Standards.NAF1, "15.8M"), (Standards.NAF2, "10.73Z")),
        ((Standards.NAF1, "15.8M"), (Standards.NAF2, "10.85Z")),
        ((Standards.NAF1, "15.8P"), (Standards.NAF2, "10.83Z")),
        ((Standards.NAF1, "15.8R"), (Standards.NAF2, "10.84Z")),
        ((Standards.NAF1, "15.8T"), (Standards.NAF2, "10.86Z")),
        ((Standards.NAF1, "15.8V"), (Standards.NAF2, "10.85Z")),
        ((Standards.NAF1, "15.8V"), (Standards.NAF2, "10.89Z")),
        ((Standards.NAF1, "15.9A"), (Standards.NAF2, "11.01Z")),
        ((Standards.NAF1, "15.9B"), (Standards.NAF2, "11.01Z")),
        ((Standards.NAF1, "15.9D"), (Standards.NAF2, "11.01Z")),
        ((Standards.NAF1, "15.9D"), (Standards.NAF2, "20.14Z")),
        ((Standards.NAF1, "15.9F"), (Standards.NAF2, "11.02A")),
        ((Standards.NAF1, "15.9G"), (Standards.NAF2, "11.02B")),
        ((Standards.NAF1, "15.9J"), (Standards.NAF2, "11.03Z")),
        ((Standards.NAF1, "15.9L"), (Standards.NAF2, "11.04Z")),
        ((Standards.NAF1, "15.9N"), (Standards.NAF2, "11.05Z")),
        ((Standards.NAF1, "15.9Q"), (Standards.NAF2, "11.06Z")),
        ((Standards.NAF1, "15.9S"), (Standards.NAF2, "11.07A")),
        ((Standards.NAF1, "15.9T"), (Standards.NAF2, "11.07B")),
        ((Standards.NAF1, "16.0Z"), (Standards.NAF2, "12.00Z")),
        ((Standards.NAF1, "17.1A"), (Standards.NAF2, "13.10Z")),
        ((Standards.NAF1, "17.1C"), (Standards.NAF2, "13.10Z")),
        ((Standards.NAF1, "17.1E"), (Standards.NAF2, "13.10Z")),
        ((Standards.NAF1, "17.1F"), (Standards.NAF2, "13.10Z")),
        ((Standards.NAF1, "17.1H"), (Standards.NAF2, "13.10Z")),
        ((Standards.NAF1, "17.1K"), (Standards.NAF2, "13.10Z")),
        ((Standards.NAF1, "17.1M"), (Standards.NAF2, "13.10Z")),
        ((Standards.NAF1, "17.1P"), (Standards.NAF2, "13.10Z")),
        ((Standards.NAF1, "17.2A"), (Standards.NAF2, "13.20Z")),
        ((Standards.NAF1, "17.2C"), (Standards.NAF2, "13.20Z")),
        ((Standards.NAF1, "17.2E"), (Standards.NAF2, "13.20Z")),
        ((Standards.NAF1, "17.2G"), (Standards.NAF2, "13.20Z")),
        ((Standards.NAF1, "17.2J"), (Standards.NAF2, "13.20Z")),
        ((Standards.NAF1, "17.3Z"), (Standards.NAF2, "13.30Z")),
        ((Standards.NAF1, "17.4A"), (Standards.NAF2, "13.92Z")),
        ((Standards.NAF1, "17.4A"), (Standards.NAF2, "32.50A")),
        ((Standards.NAF1, "17.4B"), (Standards.NAF2, "13.92Z")),
        ((Standards.NAF1, "17.4B"), (Standards.NAF2, "32.50A")),
        ((Standards.NAF1, "17.4C"), (Standards.NAF2, "13.92Z")),
        ((Standards.NAF1, "17.4C"), (Standards.NAF2, "32.50A")),
        ((Standards.NAF1, "17.4C"), (Standards.NAF2, "33.19Z")),
        ((Standards.NAF1, "17.5A"), (Standards.NAF2, "13.93Z")),
        ((Standards.NAF1, "17.5C"), (Standards.NAF2, "13.94Z")),
        ((Standards.NAF1, "17.5C"), (Standards.NAF2, "33.19Z")),
        ((Standards.NAF1, "17.5E"), (Standards.NAF2, "13.95Z")),
        ((Standards.NAF1, "17.5G"), (Standards.NAF2, "13.96Z")),
        ((Standards.NAF1, "17.5G"), (Standards.NAF2, "13.99Z")),
        ((Standards.NAF1, "17.5G"), (Standards.NAF2, "17.22Z")),
        ((Standards.NAF1, "17.6Z"), (Standards.NAF2, "13.91Z")),
        ((Standards.NAF1, "17.7A"), (Standards.NAF2, "14.19Z")),
        ((Standards.NAF1, "17.7A"), (Standards.NAF2, "14.31Z")),
        ((Standards.NAF1, "17.7C"), (Standards.NAF2, "14.39Z")),
        ((Standards.NAF1, "18.1Z"), (Standards.NAF2, "14.11Z")),
        ((Standards.NAF1, "18.1Z"), (Standards.NAF2, "32.99Z")),
        ((Standards.NAF1, "18.2A"), (Standards.NAF2, "14.12Z")),
        ((Standards.NAF1, "18.2C"), (Standards.NAF2, "14.13Z")),
        ((Standards.NAF1, "18.2D"), (Standards.NAF2, "14.13Z")),
        ((Standards.NAF1, "18.2E"), (Standards.NAF2, "14.13Z")),
        ((Standards.NAF1, "18.2G"), (Standards.NAF2, "14.14Z")),
        ((Standards.NAF1, "18.2J"), (Standards.NAF2, "14.19Z")),
        ((Standards.NAF1, "18.2J"), (Standards.NAF2, "32.99Z")),
        ((Standards.NAF1, "18.3Z"), (Standards.NAF2, "13.20Z")),
        ((Standards.NAF1, "18.3Z"), (Standards.NAF2, "13.91Z")),
        ((Standards.NAF1, "18.3Z"), (Standards.NAF2, "14.20Z")),
        ((Standards.NAF1, "18.3Z"), (Standards.NAF2, "15.11Z")),
        ((Standards.NAF1, "19.1Z"), (Standards.NAF2, "15.11Z")),
        ((Standards.NAF1, "19.2Z"), (Standards.NAF2, "15.12Z")),
        ((Standards.NAF1, "19.3Z"), (Standards.NAF2, "15.20Z")),
        ((Standards.NAF1, "19.3Z"), (Standards.NAF2, "16.29Z")),
        ((Standards.NAF1, "19.3Z"), (Standards.NAF2, "22.19Z")),
        ((Standards.NAF1, "19.3Z"), (Standards.NAF2, "22.29B")),
        ((Standards.NAF1, "19.3Z"), (Standards.NAF2, "32.30Z")),
        ((Standards.NAF1, "20.1A"), (Standards.NAF2, "16.10A")),
        ((Standards.NAF1, "20.1B"), (Standards.NAF2, "16.10B")),
        ((Standards.NAF1, "20.2Z"), (Standards.NAF2, "16.21Z")),
        ((Standards.NAF1, "20.3Z"), (Standards.NAF2, "16.22Z")),
        ((Standards.NAF1, "20.3Z"), (Standards.NAF2, "16.23Z")),
        ((Standards.NAF1, "20.3Z"), (Standards.NAF2, "43.32A")),
        ((Standards.NAF1, "20.3Z"), (Standards.NAF2, "43.91A")),
        ((Standards.NAF1, "20.4Z"), (Standards.NAF2, "16.24Z")),
        ((Standards.NAF1, "20.4Z"), (Standards.NAF2, "33.19Z")),
        ((Standards.NAF1, "20.5A"), (Standards.NAF2, "16.29Z")),
        ((Standards.NAF1, "20.5A"), (Standards.NAF2, "32.99Z")),
        ((Standards.NAF1, "20.5A"), (Standards.NAF2, "33.19Z")),
        ((Standards.NAF1, "20.5C"), (Standards.NAF2, "16.29Z")),
        ((Standards.NAF1, "20.5C"), (Standards.NAF2, "32.99Z")),
        ((Standards.NAF1, "21.1A"), (Standards.NAF2, "17.11Z")),
        ((Standards.NAF1, "21.1C"), (Standards.NAF2, "17.12Z")),
        ((Standards.NAF1, "21.2A"), (Standards.NAF2, "17.21A")),
        ((Standards.NAF1, "21.2B"), (Standards.NAF2, "17.21B")),
        ((Standards.NAF1, "21.2C"), (Standards.NAF2, "17.21C")),
        ((Standards.NAF1, "21.2E"), (Standards.NAF2, "17.22Z")),
        ((Standards.NAF1, "21.2E"), (Standards.NAF2, "18.12Z")),
        ((Standards.NAF1, "21.2G"), (Standards.NAF2, "17.23Z")),
        ((Standards.NAF1, "21.2J"), (Standards.NAF2, "17.24Z")),
        ((Standards.NAF1, "21.2L"), (Standards.NAF2, "17.29Z")),
        ((Standards.NAF1, "21.2L"), (Standards.NAF2, "18.12Z")),
        ((Standards.NAF1, "22.1A"), (Standards.NAF2, "32.99Z")),
        ((Standards.NAF1, "22.1A"), (Standards.NAF2, "58.11Z")),
        ((Standards.NAF1, "22.1A"), (Standards.NAF2, "58.12Z")),
        ((Standards.NAF1, "22.1C"), (Standards.NAF2, "58.13Z")),
        ((Standards.NAF1, "22.1E"), (Standards.NAF2, "58.14Z")),
        ((Standards.NAF1, "22.1G"), (Standards.NAF2, "59.20Z")),
        ((Standards.NAF1, "22.1J"), (Standards.NAF2, "58.19Z")),
        ((Standards.NAF1, "22.2A"), (Standards.NAF2, "18.11Z")),
        ((Standards.NAF1, "22.2C"), (Standards.NAF2, "17.23Z")),
        ((Standards.NAF1, "22.2C"), (Standards.NAF2, "18.12Z")),
        ((Standards.NAF1, "22.2C"), (Standards.NAF2, "58.19Z")),
        ((Standards.NAF1, "22.2E"), (Standards.NAF2, "18.14Z")),
        ((Standards.NAF1, "22.2G"), (Standards.NAF2, "18.13Z")),
        ((Standards.NAF1, "22.2J"), (Standards.NAF2, "18.13Z")),
        ((Standards.NAF1, "22.3A"), (Standards.NAF2, "18.20Z")),
        ((Standards.NAF1, "22.3C"), (Standards.NAF2, "18.20Z")),
        ((Standards.NAF1, "22.3E"), (Standards.NAF2, "18.20Z")),
        ((Standards.NAF1, "23.1Z"), (Standards.NAF2, "19.10Z")),
        ((Standards.NAF1, "23.2Z"), (Standards.NAF2, "19.20Z")),
        ((Standards.NAF1, "23.3Z"), (Standards.NAF2, "20.13A")),
        ((Standards.NAF1, "23.3Z"), (Standards.NAF2, "21.20Z")),
        ((Standards.NAF1, "23.3Z"), (Standards.NAF2, "24.46Z")),
        ((Standards.NAF1, "23.3Z"), (Standards.NAF2, "38.12Z")),
        ((Standards.NAF1, "23.3Z"), (Standards.NAF2, "38.22Z")),
        ((Standards.NAF1, "24.1A"), (Standards.NAF2, "20.11Z")),
        ((Standards.NAF1, "24.1C"), (Standards.NAF2, "20.12Z")),
        ((Standards.NAF1, "24.1E"), (Standards.NAF2, "20.13B")),
        ((Standards.NAF1, "24.1G"), (Standards.NAF2, "19.10Z")),
        ((Standards.NAF1, "24.1G"), (Standards.NAF2, "20.14Z")),
        ((Standards.NAF1, "24.1J"), (Standards.NAF2, "08.91Z")),
        ((Standards.NAF1, "24.1J"), (Standards.NAF2, "20.15Z")),
        ((Standards.NAF1, "24.1L"), (Standards.NAF2, "20.16Z")),
        ((Standards.NAF1, "24.1N"), (Standards.NAF2, "20.17Z")),
        ((Standards.NAF1, "24.2Z"), (Standards.NAF2, "20.20Z")),
        ((Standards.NAF1, "24.3Z"), (Standards.NAF2, "20.30Z")),
        ((Standards.NAF1, "24.4A"), (Standards.NAF2, "21.10Z")),
        ((Standards.NAF1, "24.4C"), (Standards.NAF2, "21.20Z")),
        ((Standards.NAF1, "24.4D"), (Standards.NAF2, "21.20Z")),
        ((Standards.NAF1, "24.4D"), (Standards.NAF2, "32.50A")),
        ((Standards.NAF1, "24.5A"), (Standards.NAF2, "20.41Z")),
        ((Standards.NAF1, "24.5A"), (Standards.NAF2, "20.42Z")),
        ((Standards.NAF1, "24.5C"), (Standards.NAF2, "20.42Z")),
        ((Standards.NAF1, "24.6A"), (Standards.NAF2, "20.51Z")),
        ((Standards.NAF1, "24.6C"), (Standards.NAF2, "20.52Z")),
        ((Standards.NAF1, "24.6C"), (Standards.NAF2, "20.59Z")),
        ((Standards.NAF1, "24.6E"), (Standards.NAF2, "20.53Z")),
        ((Standards.NAF1, "24.6G"), (Standards.NAF2, "20.59Z")),
        ((Standards.NAF1, "24.6J"), (Standards.NAF2, "26.80Z")),
        ((Standards.NAF1, "24.6L"), (Standards.NAF2, "20.59Z")),
        ((Standards.NAF1, "24.6L"), (Standards.NAF2, "26.11Z")),
        ((Standards.NAF1, "24.7Z"), (Standards.NAF2, "20.60Z")),
        ((Standards.NAF1, "25.1A"), (Standards.NAF2, "22.11Z")),
        ((Standards.NAF1, "25.1C"), (Standards.NAF2, "22.11Z")),
        ((Standards.NAF1, "25.1E"), (Standards.NAF2, "22.19Z")),
        ((Standards.NAF1, "25.1E"), (Standards.NAF2, "32.50A")),
        ((Standards.NAF1, "25.1E"), (Standards.NAF2, "33.19Z")),
        ((Standards.NAF1, "25.2A"), (Standards.NAF2, "22.21Z")),
        ((Standards.NAF1, "25.2A"), (Standards.NAF2, "33.19Z")),
        ((Standards.NAF1, "25.2A"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "25.2C"), (Standards.NAF2, "22.22Z")),
        ((Standards.NAF1, "25.2E"), (Standards.NAF2, "22.23Z")),
        ((Standards.NAF1, "25.2E"), (Standards.NAF2, "27.33Z")),
        ((Standards.NAF1, "25.2E"), (Standards.NAF2, "32.30Z")),
        ((Standards.NAF1, "25.2E"), (Standards.NAF2, "43.32A")),
        ((Standards.NAF1, "25.2G"), (Standards.NAF2, "22.29A")),
        ((Standards.NAF1, "25.2G"), (Standards.NAF2, "22.29B")),
        ((Standards.NAF1, "25.2G"), (Standards.NAF2, "27.33Z")),
        ((Standards.NAF1, "25.2G"), (Standards.NAF2, "32.99Z")),
        ((Standards.NAF1, "25.2H"), (Standards.NAF2, "22.29A")),
        ((Standards.NAF1, "25.2H"), (Standards.NAF2, "33.19Z")),
        ((Standards.NAF1, "26.1A"), (Standards.NAF2, "23.11Z")),
        ((Standards.NAF1, "26.1C"), (Standards.NAF2, "23.12Z")),
        ((Standards.NAF1, "26.1E"), (Standards.NAF2, "23.13Z")),
        ((Standards.NAF1, "26.1G"), (Standards.NAF2, "23.14Z")),
        ((Standards.NAF1, "26.1J"), (Standards.NAF2, "23.19Z")),
        ((Standards.NAF1, "26.1J"), (Standards.NAF2, "33.19Z")),
        ((Standards.NAF1, "26.1J"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "26.1K"), (Standards.NAF2, "23.19Z")),
        ((Standards.NAF1, "26.2A"), (Standards.NAF2, "23.41Z")),
        ((Standards.NAF1, "26.2C"), (Standards.NAF2, "23.42Z")),
        ((Standards.NAF1, "26.2E"), (Standards.NAF2, "23.43Z")),
        ((Standards.NAF1, "26.2E"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "26.2G"), (Standards.NAF2, "23.44Z")),
        ((Standards.NAF1, "26.2J"), (Standards.NAF2, "23.49Z")),
        ((Standards.NAF1, "26.2L"), (Standards.NAF2, "23.20Z")),
        ((Standards.NAF1, "26.3Z"), (Standards.NAF2, "23.31Z")),
        ((Standards.NAF1, "26.4A"), (Standards.NAF2, "23.32Z")),
        ((Standards.NAF1, "26.4B"), (Standards.NAF2, "23.32Z")),
        ((Standards.NAF1, "26.4C"), (Standards.NAF2, "23.32Z")),
        ((Standards.NAF1, "26.4C"), (Standards.NAF2, "33.19Z")),
        ((Standards.NAF1, "26.4C"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "26.5A"), (Standards.NAF2, "23.51Z")),
        ((Standards.NAF1, "26.5C"), (Standards.NAF2, "23.52Z")),
        ((Standards.NAF1, "26.5E"), (Standards.NAF2, "23.52Z")),
        ((Standards.NAF1, "26.6A"), (Standards.NAF2, "23.61Z")),
        ((Standards.NAF1, "26.6C"), (Standards.NAF2, "23.62Z")),
        ((Standards.NAF1, "26.6E"), (Standards.NAF2, "23.63Z")),
        ((Standards.NAF1, "26.6G"), (Standards.NAF2, "23.64Z")),
        ((Standards.NAF1, "26.6J"), (Standards.NAF2, "23.65Z")),
        ((Standards.NAF1, "26.6L"), (Standards.NAF2, "23.69Z")),
        ((Standards.NAF1, "26.7Z"), (Standards.NAF2, "23.70Z")),
        ((Standards.NAF1, "26.8A"), (Standards.NAF2, "23.91Z")),
        ((Standards.NAF1, "26.8A"), (Standards.NAF2, "33.19Z")),
        ((Standards.NAF1, "26.8A"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "26.8C"), (Standards.NAF2, "23.99Z")),
        ((Standards.NAF1, "27.1Y"), (Standards.NAF2, "24.10Z")),
        ((Standards.NAF1, "27.2A"), (Standards.NAF2, "24.51Z")),
        ((Standards.NAF1, "27.2A"), (Standards.NAF2, "24.52Z")),
        ((Standards.NAF1, "27.2C"), (Standards.NAF2, "24.20Z")),
        ((Standards.NAF1, "27.3A"), (Standards.NAF2, "24.31Z")),
        ((Standards.NAF1, "27.3C"), (Standards.NAF2, "24.32Z")),
        ((Standards.NAF1, "27.3E"), (Standards.NAF2, "24.33Z")),
        ((Standards.NAF1, "27.3G"), (Standards.NAF2, "24.34Z")),
        ((Standards.NAF1, "27.4A"), (Standards.NAF2, "24.41Z")),
        ((Standards.NAF1, "27.4C"), (Standards.NAF2, "24.42Z")),
        ((Standards.NAF1, "27.4D"), (Standards.NAF2, "24.42Z")),
        ((Standards.NAF1, "27.4F"), (Standards.NAF2, "24.43Z")),
        ((Standards.NAF1, "27.4G"), (Standards.NAF2, "24.43Z")),
        ((Standards.NAF1, "27.4J"), (Standards.NAF2, "24.44Z")),
        ((Standards.NAF1, "27.4K"), (Standards.NAF2, "24.44Z")),
        ((Standards.NAF1, "27.4M"), (Standards.NAF2, "24.45Z")),
        ((Standards.NAF1, "27.5A"), (Standards.NAF2, "24.51Z")),
        ((Standards.NAF1, "27.5C"), (Standards.NAF2, "24.52Z")),
        ((Standards.NAF1, "27.5E"), (Standards.NAF2, "24.53Z")),
        ((Standards.NAF1, "27.5G"), (Standards.NAF2, "24.54Z")),
        ((Standards.NAF1, "28.1A"), (Standards.NAF2, "24.33Z")),
        ((Standards.NAF1, "28.1A"), (Standards.NAF2, "25.11Z")),
        ((Standards.NAF1, "28.1A"), (Standards.NAF2, "33.11Z")),
        ((Standards.NAF1, "28.1A"), (Standards.NAF2, "43.99B")),
        ((Standards.NAF1, "28.1C"), (Standards.NAF2, "25.12Z")),
        ((Standards.NAF1, "28.1C"), (Standards.NAF2, "43.32B")),
        ((Standards.NAF1, "28.2C"), (Standards.NAF2, "25.29Z")),
        ((Standards.NAF1, "28.2C"), (Standards.NAF2, "33.11Z")),
        ((Standards.NAF1, "28.2C"), (Standards.NAF2, "33.20A")),
        ((Standards.NAF1, "28.2D"), (Standards.NAF2, "25.21Z")),
        ((Standards.NAF1, "28.2D"), (Standards.NAF2, "33.11Z")),
        ((Standards.NAF1, "28.2D"), (Standards.NAF2, "33.20A")),
        ((Standards.NAF1, "28.3A"), (Standards.NAF2, "25.30Z")),
        ((Standards.NAF1, "28.3A"), (Standards.NAF2, "33.11Z")),
        ((Standards.NAF1, "28.3A"), (Standards.NAF2, "33.20A")),
        ((Standards.NAF1, "28.3B"), (Standards.NAF2, "25.30Z")),
        ((Standards.NAF1, "28.3B"), (Standards.NAF2, "33.11Z")),
        ((Standards.NAF1, "28.3B"), (Standards.NAF2, "33.20A")),
        ((Standards.NAF1, "28.3C"), (Standards.NAF2, "33.11Z")),
        ((Standards.NAF1, "28.3C"), (Standards.NAF2, "33.20A")),
        ((Standards.NAF1, "28.4A"), (Standards.NAF2, "25.50A")),
        ((Standards.NAF1, "28.4B"), (Standards.NAF2, "25.50B")),
        ((Standards.NAF1, "28.4C"), (Standards.NAF2, "25.50A")),
        ((Standards.NAF1, "28.5A"), (Standards.NAF2, "25.61Z")),
        ((Standards.NAF1, "28.5C"), (Standards.NAF2, "25.62A")),
        ((Standards.NAF1, "28.5D"), (Standards.NAF2, "25.62B")),
        ((Standards.NAF1, "28.5D"), (Standards.NAF2, "33.11Z")),
        ((Standards.NAF1, "28.5D"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "28.6A"), (Standards.NAF2, "25.71Z")),
        ((Standards.NAF1, "28.6A"), (Standards.NAF2, "33.11Z")),
        ((Standards.NAF1, "28.6C"), (Standards.NAF2, "25.73B")),
        ((Standards.NAF1, "28.6C"), (Standards.NAF2, "33.11Z")),
        ((Standards.NAF1, "28.6D"), (Standards.NAF2, "25.73B")),
        ((Standards.NAF1, "28.6D"), (Standards.NAF2, "28.49Z")),
        ((Standards.NAF1, "28.6D"), (Standards.NAF2, "33.11Z")),
        ((Standards.NAF1, "28.6F"), (Standards.NAF2, "25.72Z")),
        ((Standards.NAF1, "28.6F"), (Standards.NAF2, "33.11Z")),
        ((Standards.NAF1, "28.6F"), (Standards.NAF2, "33.20A")),
        ((Standards.NAF1, "28.7A"), (Standards.NAF2, "25.91Z")),
        ((Standards.NAF1, "28.7A"), (Standards.NAF2, "33.11Z")),
        ((Standards.NAF1, "28.7A"), (Standards.NAF2, "33.20A")),
        ((Standards.NAF1, "28.7C"), (Standards.NAF2, "25.92Z")),
        ((Standards.NAF1, "28.7E"), (Standards.NAF2, "25.93Z")),
        ((Standards.NAF1, "28.7G"), (Standards.NAF2, "25.94Z")),
        ((Standards.NAF1, "28.7H"), (Standards.NAF2, "25.93Z")),
        ((Standards.NAF1, "28.7J"), (Standards.NAF2, "25.93Z")),
        ((Standards.NAF1, "28.7L"), (Standards.NAF2, "25.99A")),
        ((Standards.NAF1, "28.7L"), (Standards.NAF2, "33.11Z")),
        ((Standards.NAF1, "28.7L"), (Standards.NAF2, "33.20A")),
        ((Standards.NAF1, "28.7N"), (Standards.NAF2, "25.99B")),
        ((Standards.NAF1, "28.7N"), (Standards.NAF2, "33.11Z")),
        ((Standards.NAF1, "28.7Q"), (Standards.NAF2, "25.71Z")),
        ((Standards.NAF1, "28.7Q"), (Standards.NAF2, "25.99B")),
        ((Standards.NAF1, "28.7Q"), (Standards.NAF2, "33.11Z")),
        ((Standards.NAF1, "28.7Q"), (Standards.NAF2, "33.20A")),
        ((Standards.NAF1, "29.1A"), (Standards.NAF2, "28.11Z")),
        ((Standards.NAF1, "29.1A"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.1A"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.1B"), (Standards.NAF2, "28.12Z")),
        ((Standards.NAF1, "29.1B"), (Standards.NAF2, "28.13Z")),
        ((Standards.NAF1, "29.1B"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.1B"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.1D"), (Standards.NAF2, "28.12Z")),
        ((Standards.NAF1, "29.1D"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.1D"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.1E"), (Standards.NAF2, "28.13Z")),
        ((Standards.NAF1, "29.1E"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.1E"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.1F"), (Standards.NAF2, "28.12Z")),
        ((Standards.NAF1, "29.1F"), (Standards.NAF2, "28.14Z")),
        ((Standards.NAF1, "29.1F"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.1F"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.1H"), (Standards.NAF2, "28.15Z")),
        ((Standards.NAF1, "29.1H"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.1H"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.1J"), (Standards.NAF2, "28.15Z")),
        ((Standards.NAF1, "29.1J"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.1J"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.2A"), (Standards.NAF2, "28.21Z")),
        ((Standards.NAF1, "29.2A"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.2A"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.2C"), (Standards.NAF2, "28.22Z")),
        ((Standards.NAF1, "29.2C"), (Standards.NAF2, "43.29B")),
        ((Standards.NAF1, "29.2D"), (Standards.NAF2, "28.22Z")),
        ((Standards.NAF1, "29.2D"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.2D"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.2F"), (Standards.NAF2, "28.25Z")),
        ((Standards.NAF1, "29.2F"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.2F"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.2H"), (Standards.NAF2, "28.29A")),
        ((Standards.NAF1, "29.2H"), (Standards.NAF2, "32.50A")),
        ((Standards.NAF1, "29.2H"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.2H"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.2J"), (Standards.NAF2, "28.29A")),
        ((Standards.NAF1, "29.2J"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.2J"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.2L"), (Standards.NAF2, "28.29B")),
        ((Standards.NAF1, "29.2L"), (Standards.NAF2, "32.50A")),
        ((Standards.NAF1, "29.2L"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.2L"), (Standards.NAF2, "33.13Z")),
        ((Standards.NAF1, "29.2L"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.2M"), (Standards.NAF2, "28.29B")),
        ((Standards.NAF1, "29.2M"), (Standards.NAF2, "32.50A")),
        ((Standards.NAF1, "29.2M"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.2M"), (Standards.NAF2, "33.13Z")),
        ((Standards.NAF1, "29.2M"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.3A"), (Standards.NAF2, "28.30Z")),
        ((Standards.NAF1, "29.3A"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.3C"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.3C"), (Standards.NAF2, "95.22Z")),
        ((Standards.NAF1, "29.3D"), (Standards.NAF2, "28.30Z")),
        ((Standards.NAF1, "29.3D"), (Standards.NAF2, "28.93Z")),
        ((Standards.NAF1, "29.3D"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.3D"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.4A"), (Standards.NAF2, "28.41Z")),
        ((Standards.NAF1, "29.4A"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.4A"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.4B"), (Standards.NAF2, "28.49Z")),
        ((Standards.NAF1, "29.4B"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.4B"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.4C"), (Standards.NAF2, "28.24Z")),
        ((Standards.NAF1, "29.4C"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.4D"), (Standards.NAF2, "27.90Z")),
        ((Standards.NAF1, "29.4D"), (Standards.NAF2, "28.29B")),
        ((Standards.NAF1, "29.4D"), (Standards.NAF2, "28.49Z")),
        ((Standards.NAF1, "29.4D"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.4D"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.4E"), (Standards.NAF2, "28.49Z")),
        ((Standards.NAF1, "29.4E"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.4E"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.5A"), (Standards.NAF2, "28.91Z")),
        ((Standards.NAF1, "29.5A"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.5A"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.5B"), (Standards.NAF2, "28.92Z")),
        ((Standards.NAF1, "29.5B"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.5B"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.5D"), (Standards.NAF2, "28.92Z")),
        ((Standards.NAF1, "29.5D"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.5D"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.5E"), (Standards.NAF2, "28.93Z")),
        ((Standards.NAF1, "29.5E"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.5E"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.5G"), (Standards.NAF2, "28.94Z")),
        ((Standards.NAF1, "29.5G"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.5G"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.5J"), (Standards.NAF2, "28.95Z")),
        ((Standards.NAF1, "29.5J"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.5J"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.5L"), (Standards.NAF2, "28.94Z")),
        ((Standards.NAF1, "29.5L"), (Standards.NAF2, "28.99A")),
        ((Standards.NAF1, "29.5L"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.5L"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.5M"), (Standards.NAF2, "28.96Z")),
        ((Standards.NAF1, "29.5M"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.5M"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.5N"), (Standards.NAF2, "25.73A")),
        ((Standards.NAF1, "29.5Q"), (Standards.NAF2, "28.99B")),
        ((Standards.NAF1, "29.5Q"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.5Q"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.5R"), (Standards.NAF2, "28.94Z")),
        ((Standards.NAF1, "29.5R"), (Standards.NAF2, "28.99B")),
        ((Standards.NAF1, "29.5R"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "29.5R"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "29.6A"), (Standards.NAF2, "25.40Z")),
        ((Standards.NAF1, "29.6A"), (Standards.NAF2, "30.30Z")),
        ((Standards.NAF1, "29.6A"), (Standards.NAF2, "30.40Z")),
        ((Standards.NAF1, "29.6A"), (Standards.NAF2, "33.11Z")),
        ((Standards.NAF1, "29.6A"), (Standards.NAF2, "33.20A")),
        ((Standards.NAF1, "29.6B"), (Standards.NAF2, "25.40Z")),
        ((Standards.NAF1, "29.6B"), (Standards.NAF2, "33.11Z")),
        ((Standards.NAF1, "29.7A"), (Standards.NAF2, "27.51Z")),
        ((Standards.NAF1, "29.7A"), (Standards.NAF2, "28.21Z")),
        ((Standards.NAF1, "29.7A"), (Standards.NAF2, "28.25Z")),
        ((Standards.NAF1, "29.7A"), (Standards.NAF2, "33.14Z")),
        ((Standards.NAF1, "29.7A"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "29.7C"), (Standards.NAF2, "27.52Z")),
        ((Standards.NAF1, "29.7C"), (Standards.NAF2, "28.21Z")),
        ((Standards.NAF1, "30.0A"), (Standards.NAF2, "26.20Z")),
        ((Standards.NAF1, "30.0A"), (Standards.NAF2, "28.23Z")),
        ((Standards.NAF1, "30.0A"), (Standards.NAF2, "33.20B")),
        ((Standards.NAF1, "30.0C"), (Standards.NAF2, "26.20Z")),
        ((Standards.NAF1, "30.0C"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "30.0C"), (Standards.NAF2, "62.09Z")),
        ((Standards.NAF1, "31.1A"), (Standards.NAF2, "26.11Z")),
        ((Standards.NAF1, "31.1A"), (Standards.NAF2, "27.11Z")),
        ((Standards.NAF1, "31.1A"), (Standards.NAF2, "27.90Z")),
        ((Standards.NAF1, "31.1A"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "31.1B"), (Standards.NAF2, "26.11Z")),
        ((Standards.NAF1, "31.1B"), (Standards.NAF2, "27.11Z")),
        ((Standards.NAF1, "31.1B"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "31.1C"), (Standards.NAF2, "33.13Z")),
        ((Standards.NAF1, "31.1C"), (Standards.NAF2, "33.14Z")),
        ((Standards.NAF1, "31.2A"), (Standards.NAF2, "26.11Z")),
        ((Standards.NAF1, "31.2A"), (Standards.NAF2, "27.12Z")),
        ((Standards.NAF1, "31.2A"), (Standards.NAF2, "27.33Z")),
        ((Standards.NAF1, "31.2A"), (Standards.NAF2, "27.90Z")),
        ((Standards.NAF1, "31.2A"), (Standards.NAF2, "33.14Z")),
        ((Standards.NAF1, "31.2A"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "31.2B"), (Standards.NAF2, "26.11Z")),
        ((Standards.NAF1, "31.2B"), (Standards.NAF2, "27.12Z")),
        ((Standards.NAF1, "31.2B"), (Standards.NAF2, "27.90Z")),
        ((Standards.NAF1, "31.2B"), (Standards.NAF2, "33.14Z")),
        ((Standards.NAF1, "31.2B"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "31.3Z"), (Standards.NAF2, "26.11Z")),
        ((Standards.NAF1, "31.3Z"), (Standards.NAF2, "27.31Z")),
        ((Standards.NAF1, "31.3Z"), (Standards.NAF2, "27.32Z")),
        ((Standards.NAF1, "31.3Z"), (Standards.NAF2, "27.90Z")),
        ((Standards.NAF1, "31.4Z"), (Standards.NAF2, "27.20Z")),
        ((Standards.NAF1, "31.5A"), (Standards.NAF2, "27.40Z")),
        ((Standards.NAF1, "31.5B"), (Standards.NAF2, "27.40Z")),
        ((Standards.NAF1, "31.5C"), (Standards.NAF2, "27.40Z")),
        ((Standards.NAF1, "31.6A"), (Standards.NAF2, "27.40Z")),
        ((Standards.NAF1, "31.6A"), (Standards.NAF2, "29.31Z")),
        ((Standards.NAF1, "31.6A"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "31.6C"), (Standards.NAF2, "25.99B")),
        ((Standards.NAF1, "31.6C"), (Standards.NAF2, "27.90Z")),
        ((Standards.NAF1, "31.6C"), (Standards.NAF2, "33.13Z")),
        ((Standards.NAF1, "31.6C"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "31.6D"), (Standards.NAF2, "23.44Z")),
        ((Standards.NAF1, "31.6D"), (Standards.NAF2, "26.30Z")),
        ((Standards.NAF1, "31.6D"), (Standards.NAF2, "26.51B")),
        ((Standards.NAF1, "31.6D"), (Standards.NAF2, "27.90Z")),
        ((Standards.NAF1, "31.6D"), (Standards.NAF2, "28.49Z")),
        ((Standards.NAF1, "31.6D"), (Standards.NAF2, "28.99B")),
        ((Standards.NAF1, "31.6D"), (Standards.NAF2, "33.13Z")),
        ((Standards.NAF1, "31.6D"), (Standards.NAF2, "33.14Z")),
        ((Standards.NAF1, "31.6D"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "32.1A"), (Standards.NAF2, "26.11Z")),
        ((Standards.NAF1, "32.1A"), (Standards.NAF2, "26.12Z")),
        ((Standards.NAF1, "32.1A"), (Standards.NAF2, "27.90Z")),
        ((Standards.NAF1, "32.1C"), (Standards.NAF2, "26.11Z")),
        ((Standards.NAF1, "32.1C"), (Standards.NAF2, "26.12Z")),
        ((Standards.NAF1, "32.1C"), (Standards.NAF2, "33.13Z")),
        ((Standards.NAF1, "32.1D"), (Standards.NAF2, "26.12Z")),
        ((Standards.NAF1, "32.2A"), (Standards.NAF2, "26.30Z")),
        ((Standards.NAF1, "32.2A"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "32.2A"), (Standards.NAF2, "95.12Z")),
        ((Standards.NAF1, "32.2B"), (Standards.NAF2, "26.30Z")),
        ((Standards.NAF1, "32.2B"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "32.2B"), (Standards.NAF2, "95.12Z")),
        ((Standards.NAF1, "32.3Z"), (Standards.NAF2, "26.20Z")),
        ((Standards.NAF1, "32.3Z"), (Standards.NAF2, "26.30Z")),
        ((Standards.NAF1, "32.3Z"), (Standards.NAF2, "26.40Z")),
        ((Standards.NAF1, "32.3Z"), (Standards.NAF2, "26.70Z")),
        ((Standards.NAF1, "32.3Z"), (Standards.NAF2, "28.23Z")),
        ((Standards.NAF1, "32.3Z"), (Standards.NAF2, "33.13Z")),
        ((Standards.NAF1, "32.3Z"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "32.3Z"), (Standards.NAF2, "95.12Z")),
        ((Standards.NAF1, "33.1A"), (Standards.NAF2, "26.60Z")),
        ((Standards.NAF1, "33.1A"), (Standards.NAF2, "33.13Z")),
        ((Standards.NAF1, "33.1A"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "33.1B"), (Standards.NAF2, "26.60Z")),
        ((Standards.NAF1, "33.1B"), (Standards.NAF2, "31.01Z")),
        ((Standards.NAF1, "33.1B"), (Standards.NAF2, "32.50A")),
        ((Standards.NAF1, "33.1B"), (Standards.NAF2, "32.99Z")),
        ((Standards.NAF1, "33.1B"), (Standards.NAF2, "33.14Z")),
        ((Standards.NAF1, "33.1B"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "33.2A"), (Standards.NAF2, "26.51A")),
        ((Standards.NAF1, "33.2A"), (Standards.NAF2, "33.13Z")),
        ((Standards.NAF1, "33.2A"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "33.2B"), (Standards.NAF2, "26.51B")),
        ((Standards.NAF1, "33.2B"), (Standards.NAF2, "26.70Z")),
        ((Standards.NAF1, "33.2B"), (Standards.NAF2, "28.29A")),
        ((Standards.NAF1, "33.2B"), (Standards.NAF2, "28.99B")),
        ((Standards.NAF1, "33.2B"), (Standards.NAF2, "32.50A")),
        ((Standards.NAF1, "33.2B"), (Standards.NAF2, "33.13Z")),
        ((Standards.NAF1, "33.2B"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "33.3Z"), (Standards.NAF2, "33.20C")),
        ((Standards.NAF1, "33.4A"), (Standards.NAF2, "32.50B")),
        ((Standards.NAF1, "33.4B"), (Standards.NAF2, "26.70Z")),
        ((Standards.NAF1, "33.4B"), (Standards.NAF2, "27.31Z")),
        ((Standards.NAF1, "33.4B"), (Standards.NAF2, "28.99B")),
        ((Standards.NAF1, "33.4B"), (Standards.NAF2, "33.13Z")),
        ((Standards.NAF1, "33.4B"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "33.5Z"), (Standards.NAF2, "26.52Z")),
        ((Standards.NAF1, "33.5Z"), (Standards.NAF2, "32.12Z")),
        ((Standards.NAF1, "33.5Z"), (Standards.NAF2, "32.13Z")),
        ((Standards.NAF1, "33.5Z"), (Standards.NAF2, "33.13Z")),
        ((Standards.NAF1, "33.5Z"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "34.1Z"), (Standards.NAF2, "28.92Z")),
        ((Standards.NAF1, "34.1Z"), (Standards.NAF2, "29.10Z")),
        ((Standards.NAF1, "34.1Z"), (Standards.NAF2, "29.32Z")),
        ((Standards.NAF1, "34.1Z"), (Standards.NAF2, "30.91Z")),
        ((Standards.NAF1, "34.2A"), (Standards.NAF2, "29.20Z")),
        ((Standards.NAF1, "34.2A"), (Standards.NAF2, "33.11Z")),
        ((Standards.NAF1, "34.2B"), (Standards.NAF2, "29.20Z")),
        ((Standards.NAF1, "34.3Z"), (Standards.NAF2, "28.11Z")),
        ((Standards.NAF1, "34.3Z"), (Standards.NAF2, "29.32Z")),
        ((Standards.NAF1, "35.1A"), (Standards.NAF2, "30.11Z")),
        ((Standards.NAF1, "35.1B"), (Standards.NAF2, "30.11Z")),
        ((Standards.NAF1, "35.1C"), (Standards.NAF2, "30.11Z")),
        ((Standards.NAF1, "35.1C"), (Standards.NAF2, "33.15Z")),
        ((Standards.NAF1, "35.1E"), (Standards.NAF2, "30.12Z")),
        ((Standards.NAF1, "35.1E"), (Standards.NAF2, "33.15Z")),
        ((Standards.NAF1, "35.2Z"), (Standards.NAF2, "30.20Z")),
        ((Standards.NAF1, "35.2Z"), (Standards.NAF2, "33.17Z")),
        ((Standards.NAF1, "35.3A"), (Standards.NAF2, "28.99B")),
        ((Standards.NAF1, "35.3A"), (Standards.NAF2, "30.30Z")),
        ((Standards.NAF1, "35.3A"), (Standards.NAF2, "33.16Z")),
        ((Standards.NAF1, "35.3B"), (Standards.NAF2, "30.30Z")),
        ((Standards.NAF1, "35.3B"), (Standards.NAF2, "33.16Z")),
        ((Standards.NAF1, "35.3C"), (Standards.NAF2, "30.30Z")),
        ((Standards.NAF1, "35.4A"), (Standards.NAF2, "30.91Z")),
        ((Standards.NAF1, "35.4C"), (Standards.NAF2, "30.92Z")),
        ((Standards.NAF1, "35.4E"), (Standards.NAF2, "30.92Z")),
        ((Standards.NAF1, "35.4E"), (Standards.NAF2, "33.17Z")),
        ((Standards.NAF1, "35.5Z"), (Standards.NAF2, "28.22Z")),
        ((Standards.NAF1, "35.5Z"), (Standards.NAF2, "30.99Z")),
        ((Standards.NAF1, "35.5Z"), (Standards.NAF2, "33.11Z")),
        ((Standards.NAF1, "35.5Z"), (Standards.NAF2, "33.17Z")),
        ((Standards.NAF1, "36.1A"), (Standards.NAF2, "29.32Z")),
        ((Standards.NAF1, "36.1A"), (Standards.NAF2, "30.11Z")),
        ((Standards.NAF1, "36.1A"), (Standards.NAF2, "30.20Z")),
        ((Standards.NAF1, "36.1A"), (Standards.NAF2, "30.30Z")),
        ((Standards.NAF1, "36.1A"), (Standards.NAF2, "31.01Z")),
        ((Standards.NAF1, "36.1A"), (Standards.NAF2, "31.02Z")),
        ((Standards.NAF1, "36.1A"), (Standards.NAF2, "31.09A")),
        ((Standards.NAF1, "36.1A"), (Standards.NAF2, "31.09B")),
        ((Standards.NAF1, "36.1A"), (Standards.NAF2, "95.24Z")),
        ((Standards.NAF1, "36.1C"), (Standards.NAF2, "28.23Z")),
        ((Standards.NAF1, "36.1C"), (Standards.NAF2, "31.01Z")),
        ((Standards.NAF1, "36.1E"), (Standards.NAF2, "31.02Z")),
        ((Standards.NAF1, "36.1G"), (Standards.NAF2, "31.09B")),
        ((Standards.NAF1, "36.1H"), (Standards.NAF2, "31.09B")),
        ((Standards.NAF1, "36.1J"), (Standards.NAF2, "31.09B")),
        ((Standards.NAF1, "36.1K"), (Standards.NAF2, "31.09B")),
        ((Standards.NAF1, "36.1K"), (Standards.NAF2, "95.24Z")),
        ((Standards.NAF1, "36.1M"), (Standards.NAF2, "31.03Z")),
        ((Standards.NAF1, "36.2A"), (Standards.NAF2, "32.11Z")),
        ((Standards.NAF1, "36.2C"), (Standards.NAF2, "32.12Z")),
        ((Standards.NAF1, "36.3Z"), (Standards.NAF2, "32.20Z")),
        ((Standards.NAF1, "36.3Z"), (Standards.NAF2, "33.19Z")),
        ((Standards.NAF1, "36.3Z"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "36.3Z"), (Standards.NAF2, "95.29Z")),
        ((Standards.NAF1, "36.4Z"), (Standards.NAF2, "32.30Z")),
        ((Standards.NAF1, "36.4Z"), (Standards.NAF2, "32.99Z")),
        ((Standards.NAF1, "36.4Z"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "36.4Z"), (Standards.NAF2, "95.29Z")),
        ((Standards.NAF1, "36.5Z"), (Standards.NAF2, "26.40Z")),
        ((Standards.NAF1, "36.5Z"), (Standards.NAF2, "28.99B")),
        ((Standards.NAF1, "36.5Z"), (Standards.NAF2, "32.40Z")),
        ((Standards.NAF1, "36.5Z"), (Standards.NAF2, "33.19Z")),
        ((Standards.NAF1, "36.5Z"), (Standards.NAF2, "33.20D")),
        ((Standards.NAF1, "36.6A"), (Standards.NAF2, "32.13Z")),
        ((Standards.NAF1, "36.6C"), (Standards.NAF2, "32.91Z")),
        ((Standards.NAF1, "36.6E"), (Standards.NAF2, "13.99Z")),
        ((Standards.NAF1, "36.6E"), (Standards.NAF2, "15.12Z")),
        ((Standards.NAF1, "36.6E"), (Standards.NAF2, "16.29Z")),
        ((Standards.NAF1, "36.6E"), (Standards.NAF2, "17.29Z")),
        ((Standards.NAF1, "36.6E"), (Standards.NAF2, "20.51Z")),
        ((Standards.NAF1, "36.6E"), (Standards.NAF2, "22.19Z")),
        ((Standards.NAF1, "36.6E"), (Standards.NAF2, "22.23Z")),
        ((Standards.NAF1, "36.6E"), (Standards.NAF2, "22.29B")),
        ((Standards.NAF1, "36.6E"), (Standards.NAF2, "25.99B")),
        ((Standards.NAF1, "36.6E"), (Standards.NAF2, "28.99B")),
        ((Standards.NAF1, "36.6E"), (Standards.NAF2, "30.92Z")),
        ((Standards.NAF1, "36.6E"), (Standards.NAF2, "32.99Z")),
        ((Standards.NAF1, "37.1Z"), (Standards.NAF2, "38.31Z")),
        ((Standards.NAF1, "37.1Z"), (Standards.NAF2, "38.32Z")),
        ((Standards.NAF1, "37.2Z"), (Standards.NAF2, "38.31Z")),
        ((Standards.NAF1, "37.2Z"), (Standards.NAF2, "38.32Z")),
        ((Standards.NAF1, "40.1A"), (Standards.NAF2, "35.11Z")),
        ((Standards.NAF1, "40.1A"), (Standards.NAF2, "38.12Z")),
        ((Standards.NAF1, "40.1C"), (Standards.NAF2, "35.12Z")),
        ((Standards.NAF1, "40.1E"), (Standards.NAF2, "35.13Z")),
        ((Standards.NAF1, "40.1E"), (Standards.NAF2, "35.14Z")),
        ((Standards.NAF1, "40.2A"), (Standards.NAF2, "35.21Z")),
        ((Standards.NAF1, "40.2C"), (Standards.NAF2, "35.22Z")),
        ((Standards.NAF1, "40.2C"), (Standards.NAF2, "35.23Z")),
        ((Standards.NAF1, "40.3Z"), (Standards.NAF2, "35.30Z")),
        ((Standards.NAF1, "41.0Z"), (Standards.NAF2, "36.00Z")),
        ((Standards.NAF1, "41.0Z"), (Standards.NAF2, "37.00Z")),
        ((Standards.NAF1, "45.1A"), (Standards.NAF2, "43.11Z")),
        ((Standards.NAF1, "45.1A"), (Standards.NAF2, "43.12A")),
        ((Standards.NAF1, "45.1B"), (Standards.NAF2, "43.12B")),
        ((Standards.NAF1, "45.1D"), (Standards.NAF2, "43.13Z")),
        ((Standards.NAF1, "45.2A"), (Standards.NAF2, "41.20A")),
        ((Standards.NAF1, "45.2A"), (Standards.NAF2, "43.99C")),
        ((Standards.NAF1, "45.2B"), (Standards.NAF2, "41.20B")),
        ((Standards.NAF1, "45.2B"), (Standards.NAF2, "43.99C")),
        ((Standards.NAF1, "45.2C"), (Standards.NAF2, "41.20B")),
        ((Standards.NAF1, "45.2C"), (Standards.NAF2, "42.13A")),
        ((Standards.NAF1, "45.2C"), (Standards.NAF2, "42.21Z")),
        ((Standards.NAF1, "45.2C"), (Standards.NAF2, "42.22Z")),
        ((Standards.NAF1, "45.2C"), (Standards.NAF2, "42.99Z")),
        ((Standards.NAF1, "45.2C"), (Standards.NAF2, "43.99D")),
        ((Standards.NAF1, "45.2D"), (Standards.NAF2, "42.12Z")),
        ((Standards.NAF1, "45.2D"), (Standards.NAF2, "42.13B")),
        ((Standards.NAF1, "45.2E"), (Standards.NAF2, "42.21Z")),
        ((Standards.NAF1, "45.2F"), (Standards.NAF2, "42.22Z")),
        ((Standards.NAF1, "45.2J"), (Standards.NAF2, "43.91B")),
        ((Standards.NAF1, "45.2K"), (Standards.NAF2, "43.99A")),
        ((Standards.NAF1, "45.2L"), (Standards.NAF2, "43.91A")),
        ((Standards.NAF1, "45.2N"), (Standards.NAF2, "42.12Z")),
        ((Standards.NAF1, "45.2P"), (Standards.NAF2, "41.20B")),
        ((Standards.NAF1, "45.2P"), (Standards.NAF2, "42.11Z")),
        ((Standards.NAF1, "45.2P"), (Standards.NAF2, "42.99Z")),
        ((Standards.NAF1, "45.2R"), (Standards.NAF2, "42.21Z")),
        ((Standards.NAF1, "45.2R"), (Standards.NAF2, "42.91Z")),
        ((Standards.NAF1, "45.2R"), (Standards.NAF2, "43.99D")),
        ((Standards.NAF1, "45.2T"), (Standards.NAF2, "43.99B")),
        ((Standards.NAF1, "45.2U"), (Standards.NAF2, "39.00Z")),
        ((Standards.NAF1, "45.2U"), (Standards.NAF2, "42.21Z")),
        ((Standards.NAF1, "45.2U"), (Standards.NAF2, "43.99D")),
        ((Standards.NAF1, "45.2V"), (Standards.NAF2, "43.99C")),
        ((Standards.NAF1, "45.3A"), (Standards.NAF2, "43.21A")),
        ((Standards.NAF1, "45.3A"), (Standards.NAF2, "43.22B")),
        ((Standards.NAF1, "45.3A"), (Standards.NAF2, "43.29B")),
        ((Standards.NAF1, "45.3A"), (Standards.NAF2, "80.20Z")),
        ((Standards.NAF1, "45.3C"), (Standards.NAF2, "43.29A")),
        ((Standards.NAF1, "45.3E"), (Standards.NAF2, "43.22A")),
        ((Standards.NAF1, "45.3F"), (Standards.NAF2, "43.22B")),
        ((Standards.NAF1, "45.3H"), (Standards.NAF2, "43.21B")),
        ((Standards.NAF1, "45.3H"), (Standards.NAF2, "43.29B")),
        ((Standards.NAF1, "45.4A"), (Standards.NAF2, "43.31Z")),
        ((Standards.NAF1, "45.4C"), (Standards.NAF2, "43.32A")),
        ((Standards.NAF1, "45.4D"), (Standards.NAF2, "43.32B")),
        ((Standards.NAF1, "45.4F"), (Standards.NAF2, "43.33Z")),
        ((Standards.NAF1, "45.4H"), (Standards.NAF2, "43.34Z")),
        ((Standards.NAF1, "45.4J"), (Standards.NAF2, "43.34Z")),
        ((Standards.NAF1, "45.4L"), (Standards.NAF2, "43.32C")),
        ((Standards.NAF1, "45.4M"), (Standards.NAF2, "43.39Z")),
        ((Standards.NAF1, "45.4M"), (Standards.NAF2, "43.99D")),
        ((Standards.NAF1, "45.5Z"), (Standards.NAF2, "43.99E")),
        ((Standards.NAF1, "50.1Z"), (Standards.NAF2, "45.11Z")),
        ((Standards.NAF1, "50.1Z"), (Standards.NAF2, "45.19Z")),
        ((Standards.NAF1, "50.1Z"), (Standards.NAF2, "45.20A")),
        ((Standards.NAF1, "50.1Z"), (Standards.NAF2, "45.20B")),
        ((Standards.NAF1, "50.2Z"), (Standards.NAF2, "45.20A")),
        ((Standards.NAF1, "50.2Z"), (Standards.NAF2, "45.20B")),
        ((Standards.NAF1, "50.2Z"), (Standards.NAF2, "52.21Z")),
        ((Standards.NAF1, "50.3A"), (Standards.NAF2, "45.31Z")),
        ((Standards.NAF1, "50.3B"), (Standards.NAF2, "45.32Z")),
        ((Standards.NAF1, "50.4Z"), (Standards.NAF2, "45.40Z")),
        ((Standards.NAF1, "50.5Z"), (Standards.NAF2, "47.30Z")),
        ((Standards.NAF1, "51.1A"), (Standards.NAF2, "46.11Z")),
        ((Standards.NAF1, "51.1C"), (Standards.NAF2, "46.12B")),
        ((Standards.NAF1, "51.1E"), (Standards.NAF2, "46.13Z")),
        ((Standards.NAF1, "51.1G"), (Standards.NAF2, "46.14Z")),
        ((Standards.NAF1, "51.1J"), (Standards.NAF2, "46.15Z")),
        ((Standards.NAF1, "51.1L"), (Standards.NAF2, "46.16Z")),
        ((Standards.NAF1, "51.1N"), (Standards.NAF2, "46.17B")),
        ((Standards.NAF1, "51.1P"), (Standards.NAF2, "46.17A")),
        ((Standards.NAF1, "51.1R"), (Standards.NAF2, "46.18Z")),
        ((Standards.NAF1, "51.1T"), (Standards.NAF2, "46.19B")),
        ((Standards.NAF1, "51.1U"), (Standards.NAF2, "46.12A")),
        ((Standards.NAF1, "51.1U"), (Standards.NAF2, "46.19A")),
        ((Standards.NAF1, "51.2A"), (Standards.NAF2, "46.21Z")),
        ((Standards.NAF1, "51.2C"), (Standards.NAF2, "46.22Z")),
        ((Standards.NAF1, "51.2E"), (Standards.NAF2, "46.23Z")),
        ((Standards.NAF1, "51.2G"), (Standards.NAF2, "46.24Z")),
        ((Standards.NAF1, "51.2J"), (Standards.NAF2, "46.21Z")),
        ((Standards.NAF1, "51.3A"), (Standards.NAF2, "10.39A")),
        ((Standards.NAF1, "51.3A"), (Standards.NAF2, "10.39B")),
        ((Standards.NAF1, "51.3A"), (Standards.NAF2, "46.31Z")),
        ((Standards.NAF1, "51.3C"), (Standards.NAF2, "46.32A")),
        ((Standards.NAF1, "51.3D"), (Standards.NAF2, "46.32B")),
        ((Standards.NAF1, "51.3E"), (Standards.NAF2, "46.32C")),
        ((Standards.NAF1, "51.3G"), (Standards.NAF2, "46.33Z")),
        ((Standards.NAF1, "51.3J"), (Standards.NAF2, "11.01Z")),
        ((Standards.NAF1, "51.3J"), (Standards.NAF2, "11.02A")),
        ((Standards.NAF1, "51.3J"), (Standards.NAF2, "11.02B")),
        ((Standards.NAF1, "51.3J"), (Standards.NAF2, "46.34Z")),
        ((Standards.NAF1, "51.3L"), (Standards.NAF2, "46.35Z")),
        ((Standards.NAF1, "51.3N"), (Standards.NAF2, "46.36Z")),
        ((Standards.NAF1, "51.3Q"), (Standards.NAF2, "46.37Z")),
        ((Standards.NAF1, "51.3S"), (Standards.NAF2, "46.38A")),
        ((Standards.NAF1, "51.3T"), (Standards.NAF2, "46.38B")),
        ((Standards.NAF1, "51.3V"), (Standards.NAF2, "46.39A")),
        ((Standards.NAF1, "51.3W"), (Standards.NAF2, "46.39B")),
        ((Standards.NAF1, "51.4A"), (Standards.NAF2, "46.41Z")),
        ((Standards.NAF1, "51.4C"), (Standards.NAF2, "46.42Z")),
        ((Standards.NAF1, "51.4D"), (Standards.NAF2, "46.42Z")),
        ((Standards.NAF1, "51.4F"), (Standards.NAF2, "46.43Z")),
        ((Standards.NAF1, "51.4F"), (Standards.NAF2, "46.47Z")),
        ((Standards.NAF1, "51.4F"), (Standards.NAF2, "46.52Z")),
        ((Standards.NAF1, "51.4H"), (Standards.NAF2, "46.44Z")),
        ((Standards.NAF1, "51.4H"), (Standards.NAF2, "46.49Z")),
        ((Standards.NAF1, "51.4J"), (Standards.NAF2, "46.44Z")),
        ((Standards.NAF1, "51.4J"), (Standards.NAF2, "46.73B")),
        ((Standards.NAF1, "51.4L"), (Standards.NAF2, "46.45Z")),
        ((Standards.NAF1, "51.4N"), (Standards.NAF2, "46.46Z")),
        ((Standards.NAF1, "51.4Q"), (Standards.NAF2, "46.49Z")),
        ((Standards.NAF1, "51.4R"), (Standards.NAF2, "46.49Z")),
        ((Standards.NAF1, "51.4S"), (Standards.NAF2, "46.43Z")),
        ((Standards.NAF1, "51.4S"), (Standards.NAF2, "46.47Z")),
        ((Standards.NAF1, "51.4S"), (Standards.NAF2, "46.48Z")),
        ((Standards.NAF1, "51.4S"), (Standards.NAF2, "46.49Z")),
        ((Standards.NAF1, "51.4S"), (Standards.NAF2, "46.73B")),
        ((Standards.NAF1, "51.5A"), (Standards.NAF2, "46.71Z")),
        ((Standards.NAF1, "51.5C"), (Standards.NAF2, "46.72Z")),
        ((Standards.NAF1, "51.5E"), (Standards.NAF2, "46.73A")),
        ((Standards.NAF1, "51.5F"), (Standards.NAF2, "46.73A")),
        ((Standards.NAF1, "51.5F"), (Standards.NAF2, "46.73B")),
        ((Standards.NAF1, "51.5H"), (Standards.NAF2, "46.74A")),
        ((Standards.NAF1, "51.5J"), (Standards.NAF2, "46.74B")),
        ((Standards.NAF1, "51.5L"), (Standards.NAF2, "46.75Z")),
        ((Standards.NAF1, "51.5L"), (Standards.NAF2, "46.76Z")),
        ((Standards.NAF1, "51.5N"), (Standards.NAF2, "46.76Z")),
        ((Standards.NAF1, "51.5Q"), (Standards.NAF2, "46.77Z")),
        ((Standards.NAF1, "51.8A"), (Standards.NAF2, "46.62Z")),
        ((Standards.NAF1, "51.8C"), (Standards.NAF2, "46.63Z")),
        ((Standards.NAF1, "51.8E"), (Standards.NAF2, "46.64Z")),
        ((Standards.NAF1, "51.8G"), (Standards.NAF2, "46.51Z")),
        ((Standards.NAF1, "51.8H"), (Standards.NAF2, "46.65Z")),
        ((Standards.NAF1, "51.8H"), (Standards.NAF2, "46.66Z")),
        ((Standards.NAF1, "51.8J"), (Standards.NAF2, "46.52Z")),
        ((Standards.NAF1, "51.8L"), (Standards.NAF2, "46.69A")),
        ((Standards.NAF1, "51.8M"), (Standards.NAF2, "46.69B")),
        ((Standards.NAF1, "51.8N"), (Standards.NAF2, "46.69C")),
        ((Standards.NAF1, "51.8P"), (Standards.NAF2, "46.61Z")),
        ((Standards.NAF1, "51.9A"), (Standards.NAF2, "46.90Z")),
        ((Standards.NAF1, "51.9B"), (Standards.NAF2, "46.90Z")),
        ((Standards.NAF1, "52.1A"), (Standards.NAF2, "47.11A")),
        ((Standards.NAF1, "52.1B"), (Standards.NAF2, "47.11B")),
        ((Standards.NAF1, "52.1C"), (Standards.NAF2, "47.11C")),
        ((Standards.NAF1, "52.1D"), (Standards.NAF2, "47.11D")),
        ((Standards.NAF1, "52.1E"), (Standards.NAF2, "47.11E")),
        ((Standards.NAF1, "52.1F"), (Standards.NAF2, "47.11F")),
        ((Standards.NAF1, "52.1H"), (Standards.NAF2, "47.19A")),
        ((Standards.NAF1, "52.1J"), (Standards.NAF2, "47.19B")),
        ((Standards.NAF1, "52.2A"), (Standards.NAF2, "47.21Z")),
        ((Standards.NAF1, "52.2C"), (Standards.NAF2, "47.22Z")),
        ((Standards.NAF1, "52.2E"), (Standards.NAF2, "47.23Z")),
        ((Standards.NAF1, "52.2G"), (Standards.NAF2, "47.24Z")),
        ((Standards.NAF1, "52.2J"), (Standards.NAF2, "47.25Z")),
        ((Standards.NAF1, "52.2L"), (Standards.NAF2, "47.26Z")),
        ((Standards.NAF1, "52.2N"), (Standards.NAF2, "47.29Z")),
        ((Standards.NAF1, "52.2P"), (Standards.NAF2, "47.21Z")),
        ((Standards.NAF1, "52.2P"), (Standards.NAF2, "47.29Z")),
        ((Standards.NAF1, "52.3A"), (Standards.NAF2, "47.73Z")),
        ((Standards.NAF1, "52.3C"), (Standards.NAF2, "47.74Z")),
        ((Standards.NAF1, "52.3E"), (Standards.NAF2, "47.75Z")),
        ((Standards.NAF1, "52.4A"), (Standards.NAF2, "47.51Z")),
        ((Standards.NAF1, "52.4C"), (Standards.NAF2, "47.71Z")),
        ((Standards.NAF1, "52.4E"), (Standards.NAF2, "47.72A")),
        ((Standards.NAF1, "52.4F"), (Standards.NAF2, "47.72B")),
        ((Standards.NAF1, "52.4H"), (Standards.NAF2, "47.59A")),
        ((Standards.NAF1, "52.4J"), (Standards.NAF2, "47.53Z")),
        ((Standards.NAF1, "52.4J"), (Standards.NAF2, "47.59B")),
        ((Standards.NAF1, "52.4L"), (Standards.NAF2, "47.43Z")),
        ((Standards.NAF1, "52.4L"), (Standards.NAF2, "47.54Z")),
        ((Standards.NAF1, "52.4L"), (Standards.NAF2, "47.59B")),
        ((Standards.NAF1, "52.4L"), (Standards.NAF2, "47.63Z")),
        ((Standards.NAF1, "52.4N"), (Standards.NAF2, "47.52A")),
        ((Standards.NAF1, "52.4P"), (Standards.NAF2, "47.52B")),
        ((Standards.NAF1, "52.4R"), (Standards.NAF2, "47.61Z")),
        ((Standards.NAF1, "52.4R"), (Standards.NAF2, "47.62Z")),
        ((Standards.NAF1, "52.4T"), (Standards.NAF2, "47.78A")),
        ((Standards.NAF1, "52.4T"), (Standards.NAF2, "47.78C")),
        ((Standards.NAF1, "52.4U"), (Standards.NAF2, "47.53Z")),
        ((Standards.NAF1, "52.4V"), (Standards.NAF2, "47.77Z")),
        ((Standards.NAF1, "52.4W"), (Standards.NAF2, "47.64Z")),
        ((Standards.NAF1, "52.4W"), (Standards.NAF2, "47.78C")),
        ((Standards.NAF1, "52.4X"), (Standards.NAF2, "47.76Z")),
        ((Standards.NAF1, "52.4Y"), (Standards.NAF2, "47.78B")),
        ((Standards.NAF1, "52.4Z"), (Standards.NAF2, "47.41Z")),
        ((Standards.NAF1, "52.4Z"), (Standards.NAF2, "47.42Z")),
        ((Standards.NAF1, "52.4Z"), (Standards.NAF2, "47.59A")),
        ((Standards.NAF1, "52.4Z"), (Standards.NAF2, "47.65Z")),
        ((Standards.NAF1, "52.4Z"), (Standards.NAF2, "47.76Z")),
        ((Standards.NAF1, "52.4Z"), (Standards.NAF2, "47.78C")),
        ((Standards.NAF1, "52.5Z"), (Standards.NAF2, "47.79Z")),
        ((Standards.NAF1, "52.6A"), (Standards.NAF2, "47.91A")),
        ((Standards.NAF1, "52.6B"), (Standards.NAF2, "47.91B")),
        ((Standards.NAF1, "52.6D"), (Standards.NAF2, "47.81Z")),
        ((Standards.NAF1, "52.6E"), (Standards.NAF2, "47.82Z")),
        ((Standards.NAF1, "52.6E"), (Standards.NAF2, "47.89Z")),
        ((Standards.NAF1, "52.6G"), (Standards.NAF2, "47.99A")),
        ((Standards.NAF1, "52.6H"), (Standards.NAF2, "47.99B")),
        ((Standards.NAF1, "52.7A"), (Standards.NAF2, "95.23Z")),
        ((Standards.NAF1, "52.7C"), (Standards.NAF2, "95.21Z")),
        ((Standards.NAF1, "52.7D"), (Standards.NAF2, "95.22Z")),
        ((Standards.NAF1, "52.7F"), (Standards.NAF2, "95.25Z")),
        ((Standards.NAF1, "52.7H"), (Standards.NAF2, "95.12Z")),
        ((Standards.NAF1, "52.7H"), (Standards.NAF2, "95.23Z")),
        ((Standards.NAF1, "52.7H"), (Standards.NAF2, "95.29Z")),
        ((Standards.NAF1, "55.1A"), (Standards.NAF2, "55.10Z")),
        ((Standards.NAF1, "55.1C"), (Standards.NAF2, "55.10Z")),
        ((Standards.NAF1, "55.1E"), (Standards.NAF2, "55.10Z")),
        ((Standards.NAF1, "55.2A"), (Standards.NAF2, "55.20Z")),
        ((Standards.NAF1, "55.2A"), (Standards.NAF2, "55.30Z")),
        ((Standards.NAF1, "55.2C"), (Standards.NAF2, "55.30Z")),
        ((Standards.NAF1, "55.2E"), (Standards.NAF2, "55.10Z")),
        ((Standards.NAF1, "55.2E"), (Standards.NAF2, "55.20Z")),
        ((Standards.NAF1, "55.2F"), (Standards.NAF2, "55.90Z")),
        ((Standards.NAF1, "55.3A"), (Standards.NAF2, "56.10A")),
        ((Standards.NAF1, "55.3A"), (Standards.NAF2, "56.10B")),
        ((Standards.NAF1, "55.3B"), (Standards.NAF2, "56.10C")),
        ((Standards.NAF1, "55.4A"), (Standards.NAF2, "56.30Z")),
        ((Standards.NAF1, "55.4B"), (Standards.NAF2, "56.30Z")),
        ((Standards.NAF1, "55.4C"), (Standards.NAF2, "56.30Z")),
        ((Standards.NAF1, "55.4C"), (Standards.NAF2, "93.29Z")),
        ((Standards.NAF1, "55.5A"), (Standards.NAF2, "56.29B")),
        ((Standards.NAF1, "55.5C"), (Standards.NAF2, "56.29A")),
        ((Standards.NAF1, "55.5D"), (Standards.NAF2, "56.21Z")),
        ((Standards.NAF1, "60.1Z"), (Standards.NAF2, "49.10Z")),
        ((Standards.NAF1, "60.1Z"), (Standards.NAF2, "49.20Z")),
        ((Standards.NAF1, "60.1Z"), (Standards.NAF2, "52.21Z")),
        ((Standards.NAF1, "60.2A"), (Standards.NAF2, "49.31Z")),
        ((Standards.NAF1, "60.2B"), (Standards.NAF2, "49.39A")),
        ((Standards.NAF1, "60.2C"), (Standards.NAF2, "49.31Z")),
        ((Standards.NAF1, "60.2C"), (Standards.NAF2, "49.39C")),
        ((Standards.NAF1, "60.2E"), (Standards.NAF2, "49.32Z")),
        ((Standards.NAF1, "60.2G"), (Standards.NAF2, "49.39B")),
        ((Standards.NAF1, "60.2L"), (Standards.NAF2, "49.41B")),
        ((Standards.NAF1, "60.2M"), (Standards.NAF2, "49.41A")),
        ((Standards.NAF1, "60.2N"), (Standards.NAF2, "49.42Z")),
        ((Standards.NAF1, "60.2P"), (Standards.NAF2, "49.41C")),
        ((Standards.NAF1, "60.3Z"), (Standards.NAF2, "49.50Z")),
        ((Standards.NAF1, "61.1A"), (Standards.NAF2, "50.10Z")),
        ((Standards.NAF1, "61.1A"), (Standards.NAF2, "50.20Z")),
        ((Standards.NAF1, "61.1A"), (Standards.NAF2, "52.22Z")),
        ((Standards.NAF1, "61.1B"), (Standards.NAF2, "50.10Z")),
        ((Standards.NAF1, "61.1B"), (Standards.NAF2, "50.20Z")),
        ((Standards.NAF1, "61.1B"), (Standards.NAF2, "52.22Z")),
        ((Standards.NAF1, "61.2Z"), (Standards.NAF2, "50.30Z")),
        ((Standards.NAF1, "61.2Z"), (Standards.NAF2, "50.40Z")),
        ((Standards.NAF1, "61.2Z"), (Standards.NAF2, "52.22Z")),
        ((Standards.NAF1, "62.1Z"), (Standards.NAF2, "51.10Z")),
        ((Standards.NAF1, "62.1Z"), (Standards.NAF2, "51.21Z")),
        ((Standards.NAF1, "62.2Z"), (Standards.NAF2, "51.10Z")),
        ((Standards.NAF1, "62.2Z"), (Standards.NAF2, "51.21Z")),
        ((Standards.NAF1, "62.3Z"), (Standards.NAF2, "51.22Z")),
        ((Standards.NAF1, "62.3Z"), (Standards.NAF2, "52.23Z")),
        ((Standards.NAF1, "63.1A"), (Standards.NAF2, "52.24A")),
        ((Standards.NAF1, "63.1B"), (Standards.NAF2, "52.24B")),
        ((Standards.NAF1, "63.1D"), (Standards.NAF2, "52.10A")),
        ((Standards.NAF1, "63.1E"), (Standards.NAF2, "52.10B")),
        ((Standards.NAF1, "63.2A"), (Standards.NAF2, "49.32Z")),
        ((Standards.NAF1, "63.2A"), (Standards.NAF2, "52.21Z")),
        ((Standards.NAF1, "63.2C"), (Standards.NAF2, "52.22Z")),
        ((Standards.NAF1, "63.2C"), (Standards.NAF2, "85.32Z")),
        ((Standards.NAF1, "63.2E"), (Standards.NAF2, "52.23Z")),
        ((Standards.NAF1, "63.2E"), (Standards.NAF2, "85.42Z")),
        ((Standards.NAF1, "63.3Z"), (Standards.NAF2, "79.11Z")),
        ((Standards.NAF1, "63.3Z"), (Standards.NAF2, "79.12Z")),
        ((Standards.NAF1, "63.3Z"), (Standards.NAF2, "79.90Z")),
        ((Standards.NAF1, "63.4A"), (Standards.NAF2, "52.29A")),
        ((Standards.NAF1, "63.4B"), (Standards.NAF2, "52.29B")),
        ((Standards.NAF1, "63.4C"), (Standards.NAF2, "52.29B")),
        ((Standards.NAF1, "63.4C"), (Standards.NAF2, "74.90B")),
        ((Standards.NAF1, "64.1A"), (Standards.NAF2, "53.10Z")),
        ((Standards.NAF1, "64.1A"), (Standards.NAF2, "82.19Z")),
        ((Standards.NAF1, "64.1C"), (Standards.NAF2, "53.20Z")),
        ((Standards.NAF1, "64.2C"), (Standards.NAF2, "61.10Z")),
        ((Standards.NAF1, "64.2C"), (Standards.NAF2, "61.20Z")),
        ((Standards.NAF1, "64.2C"), (Standards.NAF2, "61.30Z")),
        ((Standards.NAF1, "64.2C"), (Standards.NAF2, "61.90Z")),
        ((Standards.NAF1, "64.2D"), (Standards.NAF2, "61.10Z")),
        ((Standards.NAF1, "64.2D"), (Standards.NAF2, "61.20Z")),
        ((Standards.NAF1, "64.2D"), (Standards.NAF2, "61.30Z")),
        ((Standards.NAF1, "65.1A"), (Standards.NAF2, "64.11Z")),
        ((Standards.NAF1, "65.1C"), (Standards.NAF2, "64.19Z")),
        ((Standards.NAF1, "65.1D"), (Standards.NAF2, "64.19Z")),
        ((Standards.NAF1, "65.1E"), (Standards.NAF2, "64.19Z")),
        ((Standards.NAF1, "65.1F"), (Standards.NAF2, "64.19Z")),
        ((Standards.NAF1, "65.2A"), (Standards.NAF2, "64.91Z")),
        ((Standards.NAF1, "65.2C"), (Standards.NAF2, "64.92Z")),
        ((Standards.NAF1, "65.2C"), (Standards.NAF2, "64.99Z")),
        ((Standards.NAF1, "65.2E"), (Standards.NAF2, "64.20Z")),
        ((Standards.NAF1, "65.2E"), (Standards.NAF2, "64.30Z")),
        ((Standards.NAF1, "65.2F"), (Standards.NAF2, "64.99Z")),
        ((Standards.NAF1, "66.0A"), (Standards.NAF2, "65.11Z")),
        ((Standards.NAF1, "66.0A"), (Standards.NAF2, "65.20Z")),
        ((Standards.NAF1, "66.0C"), (Standards.NAF2, "65.20Z")),
        ((Standards.NAF1, "66.0C"), (Standards.NAF2, "65.30Z")),
        ((Standards.NAF1, "66.0E"), (Standards.NAF2, "65.12Z")),
        ((Standards.NAF1, "66.0F"), (Standards.NAF2, "65.20Z")),
        ((Standards.NAF1, "66.0G"), (Standards.NAF2, "65.12Z")),
        ((Standards.NAF1, "67.1A"), (Standards.NAF2, "66.11Z")),
        ((Standards.NAF1, "67.1C"), (Standards.NAF2, "66.12Z")),
        ((Standards.NAF1, "67.1C"), (Standards.NAF2, "66.30Z")),
        ((Standards.NAF1, "67.1E"), (Standards.NAF2, "66.12Z")),
        ((Standards.NAF1, "67.1E"), (Standards.NAF2, "66.19B")),
        ((Standards.NAF1, "67.2Z"), (Standards.NAF2, "66.21Z")),
        ((Standards.NAF1, "67.2Z"), (Standards.NAF2, "66.22Z")),
        ((Standards.NAF1, "67.2Z"), (Standards.NAF2, "66.29Z")),
        ((Standards.NAF1, "70.1A"), (Standards.NAF2, "41.10A")),
        ((Standards.NAF1, "70.1B"), (Standards.NAF2, "41.10B")),
        ((Standards.NAF1, "70.1C"), (Standards.NAF2, "41.10C")),
        ((Standards.NAF1, "70.1C"), (Standards.NAF2, "42.99Z")),
        ((Standards.NAF1, "70.1D"), (Standards.NAF2, "41.10D")),
        ((Standards.NAF1, "70.1F"), (Standards.NAF2, "68.10Z")),
        ((Standards.NAF1, "70.2A"), (Standards.NAF2, "68.20A")),
        ((Standards.NAF1, "70.2B"), (Standards.NAF2, "68.20B")),
        ((Standards.NAF1, "70.2C"), (Standards.NAF2, "68.20B")),
        ((Standards.NAF1, "70.3A"), (Standards.NAF2, "68.31Z")),
        ((Standards.NAF1, "70.3C"), (Standards.NAF2, "68.32A")),
        ((Standards.NAF1, "70.3C"), (Standards.NAF2, "81.10Z")),
        ((Standards.NAF1, "70.3D"), (Standards.NAF2, "68.32A")),
        ((Standards.NAF1, "70.3D"), (Standards.NAF2, "81.10Z")),
        ((Standards.NAF1, "70.3E"), (Standards.NAF2, "66.19A")),
        ((Standards.NAF1, "70.3E"), (Standards.NAF2, "68.32B")),
        ((Standards.NAF1, "71.1A"), (Standards.NAF2, "77.11A")),
        ((Standards.NAF1, "71.1B"), (Standards.NAF2, "77.11B")),
        ((Standards.NAF1, "71.2A"), (Standards.NAF2, "77.12Z")),
        ((Standards.NAF1, "71.2A"), (Standards.NAF2, "77.39Z")),
        ((Standards.NAF1, "71.2C"), (Standards.NAF2, "77.34Z")),
        ((Standards.NAF1, "71.2E"), (Standards.NAF2, "77.35Z")),
        ((Standards.NAF1, "71.3A"), (Standards.NAF2, "77.31Z")),
        ((Standards.NAF1, "71.3C"), (Standards.NAF2, "77.32Z")),
        ((Standards.NAF1, "71.3E"), (Standards.NAF2, "77.33Z")),
        ((Standards.NAF1, "71.3G"), (Standards.NAF2, "77.39Z")),
        ((Standards.NAF1, "71.4A"), (Standards.NAF2, "77.29Z")),
        ((Standards.NAF1, "71.4A"), (Standards.NAF2, "96.01A")),
        ((Standards.NAF1, "71.4B"), (Standards.NAF2, "77.21Z")),
        ((Standards.NAF1, "71.4B"), (Standards.NAF2, "77.22Z")),
        ((Standards.NAF1, "71.4B"), (Standards.NAF2, "77.29Z")),
        ((Standards.NAF1, "72.1Z"), (Standards.NAF2, "62.02A")),
        ((Standards.NAF1, "72.2A"), (Standards.NAF2, "58.21Z")),
        ((Standards.NAF1, "72.2A"), (Standards.NAF2, "58.29A")),
        ((Standards.NAF1, "72.2A"), (Standards.NAF2, "58.29B")),
        ((Standards.NAF1, "72.2A"), (Standards.NAF2, "58.29C")),
        ((Standards.NAF1, "72.2C"), (Standards.NAF2, "62.01Z")),
        ((Standards.NAF1, "72.2C"), (Standards.NAF2, "62.02A")),
        ((Standards.NAF1, "72.2C"), (Standards.NAF2, "62.02B")),
        ((Standards.NAF1, "72.2C"), (Standards.NAF2, "62.09Z")),
        ((Standards.NAF1, "72.3Z"), (Standards.NAF2, "62.03Z")),
        ((Standards.NAF1, "72.3Z"), (Standards.NAF2, "63.11Z")),
        ((Standards.NAF1, "72.4Z"), (Standards.NAF2, "58.11Z")),
        ((Standards.NAF1, "72.4Z"), (Standards.NAF2, "58.12Z")),
        ((Standards.NAF1, "72.4Z"), (Standards.NAF2, "58.13Z")),
        ((Standards.NAF1, "72.4Z"), (Standards.NAF2, "58.14Z")),
        ((Standards.NAF1, "72.4Z"), (Standards.NAF2, "58.19Z")),
        ((Standards.NAF1, "72.4Z"), (Standards.NAF2, "58.21Z")),
        ((Standards.NAF1, "72.4Z"), (Standards.NAF2, "58.29A")),
        ((Standards.NAF1, "72.4Z"), (Standards.NAF2, "58.29B")),
        ((Standards.NAF1, "72.4Z"), (Standards.NAF2, "58.29C")),
        ((Standards.NAF1, "72.4Z"), (Standards.NAF2, "59.20Z")),
        ((Standards.NAF1, "72.4Z"), (Standards.NAF2, "60.10Z")),
        ((Standards.NAF1, "72.4Z"), (Standards.NAF2, "60.20A")),
        ((Standards.NAF1, "72.4Z"), (Standards.NAF2, "60.20B")),
        ((Standards.NAF1, "72.4Z"), (Standards.NAF2, "62.01Z")),
        ((Standards.NAF1, "72.4Z"), (Standards.NAF2, "63.11Z")),
        ((Standards.NAF1, "72.4Z"), (Standards.NAF2, "63.12Z")),
        ((Standards.NAF1, "72.5Z"), (Standards.NAF2, "33.12Z")),
        ((Standards.NAF1, "72.5Z"), (Standards.NAF2, "62.09Z")),
        ((Standards.NAF1, "72.5Z"), (Standards.NAF2, "95.11Z")),
        ((Standards.NAF1, "72.6Z"), (Standards.NAF2, "62.09Z")),
        ((Standards.NAF1, "73.1Z"), (Standards.NAF2, "72.11Z")),
        ((Standards.NAF1, "73.1Z"), (Standards.NAF2, "72.19Z")),
        ((Standards.NAF1, "73.1Z"), (Standards.NAF2, "72.20Z")),
        ((Standards.NAF1, "73.2Z"), (Standards.NAF2, "72.20Z")),
        ((Standards.NAF1, "74.1A"), (Standards.NAF2, "69.10Z")),
        ((Standards.NAF1, "74.1C"), (Standards.NAF2, "69.20Z")),
        ((Standards.NAF1, "74.1E"), (Standards.NAF2, "73.20Z")),
        ((Standards.NAF1, "74.1G"), (Standards.NAF2, "02.40Z")),
        ((Standards.NAF1, "74.1G"), (Standards.NAF2, "70.21Z")),
        ((Standards.NAF1, "74.1G"), (Standards.NAF2, "70.22Z")),
        ((Standards.NAF1, "74.1G"), (Standards.NAF2, "74.90B")),
        ((Standards.NAF1, "74.1G"), (Standards.NAF2, "85.60Z")),
        ((Standards.NAF1, "74.1J"), (Standards.NAF2, "64.20Z")),
        ((Standards.NAF1, "74.1J"), (Standards.NAF2, "70.10Z")),
        ((Standards.NAF1, "74.2A"), (Standards.NAF2, "71.11Z")),
        ((Standards.NAF1, "74.2A"), (Standards.NAF2, "71.12B")),
        ((Standards.NAF1, "74.2B"), (Standards.NAF2, "71.12A")),
        ((Standards.NAF1, "74.2B"), (Standards.NAF2, "74.90A")),
        ((Standards.NAF1, "74.2C"), (Standards.NAF2, "71.12B")),
        ((Standards.NAF1, "74.2C"), (Standards.NAF2, "74.90B")),
        ((Standards.NAF1, "74.3A"), (Standards.NAF2, "71.20A")),
        ((Standards.NAF1, "74.3B"), (Standards.NAF2, "71.20B")),
        ((Standards.NAF1, "74.4A"), (Standards.NAF2, "73.11Z")),
        ((Standards.NAF1, "74.4A"), (Standards.NAF2, "73.12Z")),
        ((Standards.NAF1, "74.4B"), (Standards.NAF2, "73.11Z")),
        ((Standards.NAF1, "74.4B"), (Standards.NAF2, "73.12Z")),
        ((Standards.NAF1, "74.5A"), (Standards.NAF2, "78.10Z")),
        ((Standards.NAF1, "74.5A"), (Standards.NAF2, "78.30Z")),
        ((Standards.NAF1, "74.5B"), (Standards.NAF2, "78.20Z")),
        ((Standards.NAF1, "74.6Z"), (Standards.NAF2, "74.90B")),
        ((Standards.NAF1, "74.6Z"), (Standards.NAF2, "80.10Z")),
        ((Standards.NAF1, "74.6Z"), (Standards.NAF2, "80.20Z")),
        ((Standards.NAF1, "74.6Z"), (Standards.NAF2, "80.30Z")),
        ((Standards.NAF1, "74.7Z"), (Standards.NAF2, "81.21Z")),
        ((Standards.NAF1, "74.7Z"), (Standards.NAF2, "81.22Z")),
        ((Standards.NAF1, "74.7Z"), (Standards.NAF2, "81.29A")),
        ((Standards.NAF1, "74.7Z"), (Standards.NAF2, "81.29B")),
        ((Standards.NAF1, "74.8A"), (Standards.NAF2, "74.20Z")),
        ((Standards.NAF1, "74.8B"), (Standards.NAF2, "74.20Z")),
        ((Standards.NAF1, "74.8D"), (Standards.NAF2, "82.92Z")),
        ((Standards.NAF1, "74.8F"), (Standards.NAF2, "74.30Z")),
        ((Standards.NAF1, "74.8F"), (Standards.NAF2, "82.11Z")),
        ((Standards.NAF1, "74.8F"), (Standards.NAF2, "82.19Z")),
        ((Standards.NAF1, "74.8F"), (Standards.NAF2, "82.99Z")),
        ((Standards.NAF1, "74.8G"), (Standards.NAF2, "82.19Z")),
        ((Standards.NAF1, "74.8H"), (Standards.NAF2, "82.20Z")),
        ((Standards.NAF1, "74.8J"), (Standards.NAF2, "82.30Z")),
        ((Standards.NAF1, "74.8K"), (Standards.NAF2, "47.79Z")),
        ((Standards.NAF1, "74.8K"), (Standards.NAF2, "47.91A")),
        ((Standards.NAF1, "74.8K"), (Standards.NAF2, "47.91B")),
        ((Standards.NAF1, "74.8K"), (Standards.NAF2, "63.99Z")),
        ((Standards.NAF1, "74.8K"), (Standards.NAF2, "74.10Z")),
        ((Standards.NAF1, "74.8K"), (Standards.NAF2, "74.90B")),
        ((Standards.NAF1, "74.8K"), (Standards.NAF2, "77.40Z")),
        ((Standards.NAF1, "74.8K"), (Standards.NAF2, "82.91Z")),
        ((Standards.NAF1, "74.8K"), (Standards.NAF2, "82.99Z")),
        ((Standards.NAF1, "74.8K"), (Standards.NAF2, "90.02Z")),
        ((Standards.NAF1, "75.1A"), (Standards.NAF2, "84.11Z")),
        ((Standards.NAF1, "75.1C"), (Standards.NAF2, "84.12Z")),
        ((Standards.NAF1, "75.1E"), (Standards.NAF2, "84.13Z")),
        ((Standards.NAF1, "75.1G"), (Standards.NAF2, "81.10Z")),
        ((Standards.NAF1, "75.1G"), (Standards.NAF2, "84.11Z")),
        ((Standards.NAF1, "75.1G"), (Standards.NAF2, "91.01Z")),
        ((Standards.NAF1, "75.2A"), (Standards.NAF2, "84.21Z")),
        ((Standards.NAF1, "75.2A"), (Standards.NAF2, "88.99B")),
        ((Standards.NAF1, "75.2C"), (Standards.NAF2, "84.22Z")),
        ((Standards.NAF1, "75.2E"), (Standards.NAF2, "84.23Z")),
        ((Standards.NAF1, "75.2G"), (Standards.NAF2, "84.24Z")),
        ((Standards.NAF1, "75.2J"), (Standards.NAF2, "84.25Z")),
        ((Standards.NAF1, "75.3A"), (Standards.NAF2, "84.30A")),
        ((Standards.NAF1, "75.3B"), (Standards.NAF2, "84.30B")),
        ((Standards.NAF1, "75.3C"), (Standards.NAF2, "84.30C")),
        ((Standards.NAF1, "80.1Z"), (Standards.NAF2, "85.10Z")),
        ((Standards.NAF1, "80.1Z"), (Standards.NAF2, "85.20Z")),
        ((Standards.NAF1, "80.2A"), (Standards.NAF2, "85.31Z")),
        ((Standards.NAF1, "80.2C"), (Standards.NAF2, "85.32Z")),
        ((Standards.NAF1, "80.3Z"), (Standards.NAF2, "85.41Z")),
        ((Standards.NAF1, "80.3Z"), (Standards.NAF2, "85.42Z")),
        ((Standards.NAF1, "80.4A"), (Standards.NAF2, "85.32Z")),
        ((Standards.NAF1, "80.4A"), (Standards.NAF2, "85.53Z")),
        ((Standards.NAF1, "80.4C"), (Standards.NAF2, "85.32Z")),
        ((Standards.NAF1, "80.4C"), (Standards.NAF2, "85.51Z")),
        ((Standards.NAF1, "80.4C"), (Standards.NAF2, "85.59A")),
        ((Standards.NAF1, "80.4D"), (Standards.NAF2, "85.52Z")),
        ((Standards.NAF1, "80.4D"), (Standards.NAF2, "85.59B")),
        ((Standards.NAF1, "85.1A"), (Standards.NAF2, "86.10Z")),
        ((Standards.NAF1, "85.1A"), (Standards.NAF2, "87.10A")),
        ((Standards.NAF1, "85.1A"), (Standards.NAF2, "87.20A")),
        ((Standards.NAF1, "85.1A"), (Standards.NAF2, "87.20B")),
        ((Standards.NAF1, "85.1C"), (Standards.NAF2, "86.21Z")),
        ((Standards.NAF1, "85.1C"), (Standards.NAF2, "86.22A")),
        ((Standards.NAF1, "85.1C"), (Standards.NAF2, "86.22B")),
        ((Standards.NAF1, "85.1C"), (Standards.NAF2, "86.22C")),
        ((Standards.NAF1, "85.1E"), (Standards.NAF2, "86.23Z")),
        ((Standards.NAF1, "85.1G"), (Standards.NAF2, "86.90D")),
        ((Standards.NAF1, "85.1G"), (Standards.NAF2, "86.90E")),
        ((Standards.NAF1, "85.1G"), (Standards.NAF2, "86.90F")),
        ((Standards.NAF1, "85.1G"), (Standards.NAF2, "87.10A")),
        ((Standards.NAF1, "85.1G"), (Standards.NAF2, "87.10B")),
        ((Standards.NAF1, "85.1G"), (Standards.NAF2, "87.10C")),
        ((Standards.NAF1, "85.1G"), (Standards.NAF2, "87.20A")),
        ((Standards.NAF1, "85.1G"), (Standards.NAF2, "87.20B")),
        ((Standards.NAF1, "85.1G"), (Standards.NAF2, "87.30A")),
        ((Standards.NAF1, "85.1G"), (Standards.NAF2, "87.30B")),
        ((Standards.NAF1, "85.1H"), (Standards.NAF2, "86.90E")),
        ((Standards.NAF1, "85.1H"), (Standards.NAF2, "86.90F")),
        ((Standards.NAF1, "85.1J"), (Standards.NAF2, "86.90A")),
        ((Standards.NAF1, "85.1K"), (Standards.NAF2, "86.90B")),
        ((Standards.NAF1, "85.1L"), (Standards.NAF2, "86.90C")),
        ((Standards.NAF1, "85.2Z"), (Standards.NAF2, "75.00Z")),
        ((Standards.NAF1, "85.3A"), (Standards.NAF2, "87.10B")),
        ((Standards.NAF1, "85.3A"), (Standards.NAF2, "87.20A")),
        ((Standards.NAF1, "85.3A"), (Standards.NAF2, "87.20B")),
        ((Standards.NAF1, "85.3A"), (Standards.NAF2, "87.30B")),
        ((Standards.NAF1, "85.3B"), (Standards.NAF2, "87.10B")),
        ((Standards.NAF1, "85.3B"), (Standards.NAF2, "87.90A")),
        ((Standards.NAF1, "85.3C"), (Standards.NAF2, "87.10C")),
        ((Standards.NAF1, "85.3C"), (Standards.NAF2, "87.20A")),
        ((Standards.NAF1, "85.3C"), (Standards.NAF2, "87.20B")),
        ((Standards.NAF1, "85.3C"), (Standards.NAF2, "87.30B")),
        ((Standards.NAF1, "85.3D"), (Standards.NAF2, "87.10A")),
        ((Standards.NAF1, "85.3D"), (Standards.NAF2, "87.30A")),
        ((Standards.NAF1, "85.3E"), (Standards.NAF2, "87.20A")),
        ((Standards.NAF1, "85.3E"), (Standards.NAF2, "87.20B")),
        ((Standards.NAF1, "85.3E"), (Standards.NAF2, "87.90B")),
        ((Standards.NAF1, "85.3G"), (Standards.NAF2, "88.91A")),
        ((Standards.NAF1, "85.3H"), (Standards.NAF2, "88.10B")),
        ((Standards.NAF1, "85.3H"), (Standards.NAF2, "88.10C")),
        ((Standards.NAF1, "85.3H"), (Standards.NAF2, "88.91B")),
        ((Standards.NAF1, "85.3H"), (Standards.NAF2, "88.99B")),
        ((Standards.NAF1, "85.3J"), (Standards.NAF2, "88.10A")),
        ((Standards.NAF1, "85.3J"), (Standards.NAF2, "88.10B")),
        ((Standards.NAF1, "85.3J"), (Standards.NAF2, "88.99B")),
        ((Standards.NAF1, "85.3K"), (Standards.NAF2, "88.99A")),
        ((Standards.NAF1, "85.3K"), (Standards.NAF2, "88.99B")),
        ((Standards.NAF1, "90.0A"), (Standards.NAF2, "37.00Z")),
        ((Standards.NAF1, "90.0B"), (Standards.NAF2, "38.11Z")),
        ((Standards.NAF1, "90.0B"), (Standards.NAF2, "38.21Z")),
        ((Standards.NAF1, "90.0E"), (Standards.NAF2, "38.12Z")),
        ((Standards.NAF1, "90.0E"), (Standards.NAF2, "38.22Z")),
        ((Standards.NAF1, "90.0G"), (Standards.NAF2, "38.11Z")),
        ((Standards.NAF1, "90.0G"), (Standards.NAF2, "39.00Z")),
        ((Standards.NAF1, "90.0G"), (Standards.NAF2, "81.29B")),
        ((Standards.NAF1, "91.1A"), (Standards.NAF2, "94.11Z")),
        ((Standards.NAF1, "91.1C"), (Standards.NAF2, "94.12Z")),
        ((Standards.NAF1, "91.2Z"), (Standards.NAF2, "94.20Z")),
        ((Standards.NAF1, "91.3A"), (Standards.NAF2, "94.91Z")),
        ((Standards.NAF1, "91.3C"), (Standards.NAF2, "94.92Z")),
        ((Standards.NAF1, "91.3E"), (Standards.NAF2, "94.99Z")),
        ((Standards.NAF1, "92.1A"), (Standards.NAF2, "59.11A")),
        ((Standards.NAF1, "92.1B"), (Standards.NAF2, "59.11B")),
        ((Standards.NAF1, "92.1C"), (Standards.NAF2, "59.11C")),
        ((Standards.NAF1, "92.1D"), (Standards.NAF2, "59.11C")),
        ((Standards.NAF1, "92.1D"), (Standards.NAF2, "59.12Z")),
        ((Standards.NAF1, "92.1D"), (Standards.NAF2, "59.20Z")),
        ((Standards.NAF1, "92.1F"), (Standards.NAF2, "59.13A")),
        ((Standards.NAF1, "92.1G"), (Standards.NAF2, "59.13B")),
        ((Standards.NAF1, "92.1J"), (Standards.NAF2, "59.14Z")),
        ((Standards.NAF1, "92.2A"), (Standards.NAF2, "59.20Z")),
        ((Standards.NAF1, "92.2A"), (Standards.NAF2, "60.10Z")),
        ((Standards.NAF1, "92.2B"), (Standards.NAF2, "59.11A")),
        ((Standards.NAF1, "92.2D"), (Standards.NAF2, "60.20A")),
        ((Standards.NAF1, "92.2E"), (Standards.NAF2, "60.20B")),
        ((Standards.NAF1, "92.2F"), (Standards.NAF2, "61.10Z")),
        ((Standards.NAF1, "92.2F"), (Standards.NAF2, "61.20Z")),
        ((Standards.NAF1, "92.2F"), (Standards.NAF2, "61.30Z")),
        ((Standards.NAF1, "92.3A"), (Standards.NAF2, "90.01Z")),
        ((Standards.NAF1, "92.3A"), (Standards.NAF2, "90.02Z")),
        ((Standards.NAF1, "92.3A"), (Standards.NAF2, "90.03A")),
        ((Standards.NAF1, "92.3A"), (Standards.NAF2, "90.03B")),
        ((Standards.NAF1, "92.3B"), (Standards.NAF2, "90.02Z")),
        ((Standards.NAF1, "92.3D"), (Standards.NAF2, "79.90Z")),
        ((Standards.NAF1, "92.3D"), (Standards.NAF2, "90.04Z")),
        ((Standards.NAF1, "92.3F"), (Standards.NAF2, "93.21Z")),
        ((Standards.NAF1, "92.3K"), (Standards.NAF2, "79.90Z")),
        ((Standards.NAF1, "92.3K"), (Standards.NAF2, "85.52Z")),
        ((Standards.NAF1, "92.3K"), (Standards.NAF2, "90.01Z")),
        ((Standards.NAF1, "92.3K"), (Standards.NAF2, "93.29Z")),
        ((Standards.NAF1, "92.4Z"), (Standards.NAF2, "63.91Z")),
        ((Standards.NAF1, "92.4Z"), (Standards.NAF2, "74.20Z")),
        ((Standards.NAF1, "92.4Z"), (Standards.NAF2, "90.03B")),
        ((Standards.NAF1, "92.5A"), (Standards.NAF2, "91.01Z")),
        ((Standards.NAF1, "92.5C"), (Standards.NAF2, "91.02Z")),
        ((Standards.NAF1, "92.5C"), (Standards.NAF2, "91.03Z")),
        ((Standards.NAF1, "92.5E"), (Standards.NAF2, "91.04Z")),
        ((Standards.NAF1, "92.6A"), (Standards.NAF2, "93.11Z")),
        ((Standards.NAF1, "92.6C"), (Standards.NAF2, "79.90Z")),
        ((Standards.NAF1, "92.6C"), (Standards.NAF2, "85.51Z")),
        ((Standards.NAF1, "92.6C"), (Standards.NAF2, "93.12Z")),
        ((Standards.NAF1, "92.6C"), (Standards.NAF2, "93.19Z")),
        ((Standards.NAF1, "92.6C"), (Standards.NAF2, "93.29Z")),
        ((Standards.NAF1, "92.7A"), (Standards.NAF2, "92.00Z")),
        ((Standards.NAF1, "92.7C"), (Standards.NAF2, "01.62Z")),
        ((Standards.NAF1, "92.7C"), (Standards.NAF2, "78.10Z")),
        ((Standards.NAF1, "92.7C"), (Standards.NAF2, "79.90Z")),
        ((Standards.NAF1, "92.7C"), (Standards.NAF2, "85.51Z")),
        ((Standards.NAF1, "92.7C"), (Standards.NAF2, "93.29Z")),
        ((Standards.NAF1, "93.0A"), (Standards.NAF2, "96.01A")),
        ((Standards.NAF1, "93.0B"), (Standards.NAF2, "96.01B")),
        ((Standards.NAF1, "93.0D"), (Standards.NAF2, "96.02A")),
        ((Standards.NAF1, "93.0E"), (Standards.NAF2, "96.02B")),
        ((Standards.NAF1, "93.0G"), (Standards.NAF2, "96.03Z")),
        ((Standards.NAF1, "93.0H"), (Standards.NAF2, "96.03Z")),
        ((Standards.NAF1, "93.0K"), (Standards.NAF2, "96.04Z")),
        ((Standards.NAF1, "93.0L"), (Standards.NAF2, "93.13Z")),
        ((Standards.NAF1, "93.0L"), (Standards.NAF2, "96.04Z")),
        ((Standards.NAF1, "93.0N"), (Standards.NAF2, "85.51Z")),
        ((Standards.NAF1, "93.0N"), (Standards.NAF2, "96.09Z")),
        ((Standards.NAF1, "95.0Z"), (Standards.NAF2, "97.00Z")),
        ((Standards.NAF1, "96.0Z"), (Standards.NAF2, "98.10Z")),
        ((Standards.NAF1, "97.0Z"), (Standards.NAF2, "98.20Z")),
        ((Standards.NAF1, "99.0Z"), (Standards.NAF2, "99.00Z")),
    ],
)
