"""`Concordance between CCNAE2021 and ISIC4 <http://www.onei.gob.cu/node/14808>`_."""

from ...types import Concordance, Standards
from ..isic4 import ISIC4
from . import CCNAE2021

CCNAE2021_to_ISIC4 = Concordance(
    src=CCNAE2021,
    dst=ISIC4,
    concordances=[
        ((Standards.CCNAE2021, "0111"), (Standards.ISIC4, "0111")),
        ((Standards.CCNAE2021, "0112"), (Standards.ISIC4, "0112")),
        ((Standards.CCNAE2021, "0113"), (Standards.ISIC4, "0113")),
        ((Standards.CCNAE2021, "0114"), (Standards.ISIC4, "0114")),
        ((Standards.CCNAE2021, "0115"), (Standards.ISIC4, "0115")),
        ((Standards.CCNAE2021, "0116"), (Standards.ISIC4, "0116")),
        ((Standards.CCNAE2021, "0119"), (Standards.ISIC4, "0119")),
        ((Standards.CCNAE2021, "0121"), (Standards.ISIC4, "0121")),
        ((Standards.CCNAE2021, "0122"), (Standards.ISIC4, "0122")),
        ((Standards.CCNAE2021, "0123"), (Standards.ISIC4, "0123")),
        ((Standards.CCNAE2021, "0124"), (Standards.ISIC4, "0124")),
        ((Standards.CCNAE2021, "0125"), (Standards.ISIC4, "0125")),
        ((Standards.CCNAE2021, "0126"), (Standards.ISIC4, "0126")),
        ((Standards.CCNAE2021, "0127"), (Standards.ISIC4, "0127")),
        ((Standards.CCNAE2021, "0128"), (Standards.ISIC4, "0128")),
        ((Standards.CCNAE2021, "0129"), (Standards.ISIC4, "0129")),
        ((Standards.CCNAE2021, "0130"), (Standards.ISIC4, "0130")),
        ((Standards.CCNAE2021, "0141"), (Standards.ISIC4, "0141")),
        ((Standards.CCNAE2021, "0142"), (Standards.ISIC4, "0142")),
        ((Standards.CCNAE2021, "0144"), (Standards.ISIC4, "0144")),
        ((Standards.CCNAE2021, "0145"), (Standards.ISIC4, "0145")),
        ((Standards.CCNAE2021, "0146"), (Standards.ISIC4, "0146")),
        ((Standards.CCNAE2021, "0149"), (Standards.ISIC4, "0143")),
        ((Standards.CCNAE2021, "0149"), (Standards.ISIC4, "0149")),
        ((Standards.CCNAE2021, "0150"), (Standards.ISIC4, "0150")),
        ((Standards.CCNAE2021, "0161"), (Standards.ISIC4, "0161")),
        ((Standards.CCNAE2021, "0162"), (Standards.ISIC4, "0162")),
        ((Standards.CCNAE2021, "0163"), (Standards.ISIC4, "0163")),
        ((Standards.CCNAE2021, "0164"), (Standards.ISIC4, "0164")),
        ((Standards.CCNAE2021, "0170"), (Standards.ISIC4, "0170")),
        ((Standards.CCNAE2021, "0210"), (Standards.ISIC4, "0210")),
        ((Standards.CCNAE2021, "0220"), (Standards.ISIC4, "0220")),
        ((Standards.CCNAE2021, "0230"), (Standards.ISIC4, "0230")),
        ((Standards.CCNAE2021, "0240"), (Standards.ISIC4, "0240")),
        ((Standards.CCNAE2021, "0311"), (Standards.ISIC4, "0311")),
        ((Standards.CCNAE2021, "0312"), (Standards.ISIC4, "0312")),
        ((Standards.CCNAE2021, "0321"), (Standards.ISIC4, "0321")),
        ((Standards.CCNAE2021, "0322"), (Standards.ISIC4, "0322")),
        ((Standards.CCNAE2021, "0510"), (Standards.ISIC4, "0510")),
        ((Standards.CCNAE2021, "0520"), (Standards.ISIC4, "0520")),
        ((Standards.CCNAE2021, "0610"), (Standards.ISIC4, "0610")),
        ((Standards.CCNAE2021, "0620"), (Standards.ISIC4, "0620")),
        ((Standards.CCNAE2021, "0710"), (Standards.ISIC4, "0710")),
        ((Standards.CCNAE2021, "0721"), (Standards.ISIC4, "0721")),
        ((Standards.CCNAE2021, "0722"), (Standards.ISIC4, "0729")),
        ((Standards.CCNAE2021, "0729"), (Standards.ISIC4, "0729")),
        ((Standards.CCNAE2021, "0810"), (Standards.ISIC4, "0810")),
        ((Standards.CCNAE2021, "0891"), (Standards.ISIC4, "0891")),
        ((Standards.CCNAE2021, "0892"), (Standards.ISIC4, "0892")),
        ((Standards.CCNAE2021, "0893"), (Standards.ISIC4, "0893")),
        ((Standards.CCNAE2021, "0899"), (Standards.ISIC4, "0899")),
        ((Standards.CCNAE2021, "0910"), (Standards.ISIC4, "0910")),
        ((Standards.CCNAE2021, "0990"), (Standards.ISIC4, "0990")),
        ((Standards.CCNAE2021, "1010"), (Standards.ISIC4, "1010")),
        ((Standards.CCNAE2021, "1020"), (Standards.ISIC4, "1020")),
        ((Standards.CCNAE2021, "1030"), (Standards.ISIC4, "1030")),
        ((Standards.CCNAE2021, "1040"), (Standards.ISIC4, "1040")),
        ((Standards.CCNAE2021, "1050"), (Standards.ISIC4, "1050")),
        ((Standards.CCNAE2021, "1061"), (Standards.ISIC4, "1061")),
        ((Standards.CCNAE2021, "1062"), (Standards.ISIC4, "1062")),
        ((Standards.CCNAE2021, "1071"), (Standards.ISIC4, "1071")),
        ((Standards.CCNAE2021, "1072"), (Standards.ISIC4, "1072")),
        ((Standards.CCNAE2021, "1073"), (Standards.ISIC4, "1073")),
        ((Standards.CCNAE2021, "1074"), (Standards.ISIC4, "1074")),
        ((Standards.CCNAE2021, "1075"), (Standards.ISIC4, "1075")),
        ((Standards.CCNAE2021, "1079"), (Standards.ISIC4, "1079")),
        ((Standards.CCNAE2021, "1080"), (Standards.ISIC4, "1080")),
        ((Standards.CCNAE2021, "1101"), (Standards.ISIC4, "1101")),
        ((Standards.CCNAE2021, "1102"), (Standards.ISIC4, "1102")),
        ((Standards.CCNAE2021, "1103"), (Standards.ISIC4, "1103")),
        ((Standards.CCNAE2021, "1104"), (Standards.ISIC4, "1104")),
        ((Standards.CCNAE2021, "1200"), (Standards.ISIC4, "1200")),
        ((Standards.CCNAE2021, "1311"), (Standards.ISIC4, "1311")),
        ((Standards.CCNAE2021, "1312"), (Standards.ISIC4, "1312")),
        ((Standards.CCNAE2021, "1313"), (Standards.ISIC4, "1313")),
        ((Standards.CCNAE2021, "1391"), (Standards.ISIC4, "1391")),
        ((Standards.CCNAE2021, "1392"), (Standards.ISIC4, "1392")),
        ((Standards.CCNAE2021, "1393"), (Standards.ISIC4, "1393")),
        ((Standards.CCNAE2021, "1394"), (Standards.ISIC4, "1394")),
        ((Standards.CCNAE2021, "1399"), (Standards.ISIC4, "1399")),
        ((Standards.CCNAE2021, "1410"), (Standards.ISIC4, "1410")),
        ((Standards.CCNAE2021, "1420"), (Standards.ISIC4, "1420")),
        ((Standards.CCNAE2021, "1430"), (Standards.ISIC4, "1430")),
        ((Standards.CCNAE2021, "1511"), (Standards.ISIC4, "1511")),
        ((Standards.CCNAE2021, "1512"), (Standards.ISIC4, "1512")),
        ((Standards.CCNAE2021, "1520"), (Standards.ISIC4, "1520")),
        ((Standards.CCNAE2021, "1610"), (Standards.ISIC4, "1610")),
        ((Standards.CCNAE2021, "1621"), (Standards.ISIC4, "1621")),
        ((Standards.CCNAE2021, "1622"), (Standards.ISIC4, "1622")),
        ((Standards.CCNAE2021, "1623"), (Standards.ISIC4, "1623")),
        ((Standards.CCNAE2021, "1629"), (Standards.ISIC4, "1629")),
        ((Standards.CCNAE2021, "1701"), (Standards.ISIC4, "1701")),
        ((Standards.CCNAE2021, "1702"), (Standards.ISIC4, "1702")),
        ((Standards.CCNAE2021, "1709"), (Standards.ISIC4, "1709")),
        ((Standards.CCNAE2021, "1811"), (Standards.ISIC4, "1811")),
        ((Standards.CCNAE2021, "1812"), (Standards.ISIC4, "1812")),
        ((Standards.CCNAE2021, "1820"), (Standards.ISIC4, "1820")),
        ((Standards.CCNAE2021, "1910"), (Standards.ISIC4, "1910")),
        ((Standards.CCNAE2021, "1920"), (Standards.ISIC4, "1920")),
        ((Standards.CCNAE2021, "2011"), (Standards.ISIC4, "2011")),
        ((Standards.CCNAE2021, "2012"), (Standards.ISIC4, "2012")),
        ((Standards.CCNAE2021, "2013"), (Standards.ISIC4, "2013")),
        ((Standards.CCNAE2021, "2021"), (Standards.ISIC4, "2021")),
        ((Standards.CCNAE2021, "2022"), (Standards.ISIC4, "2022")),
        ((Standards.CCNAE2021, "2023"), (Standards.ISIC4, "2023")),
        ((Standards.CCNAE2021, "2029"), (Standards.ISIC4, "2029")),
        ((Standards.CCNAE2021, "2030"), (Standards.ISIC4, "2030")),
        ((Standards.CCNAE2021, "2100"), (Standards.ISIC4, "2100")),
        ((Standards.CCNAE2021, "2211"), (Standards.ISIC4, "2211")),
        ((Standards.CCNAE2021, "2219"), (Standards.ISIC4, "2219")),
        ((Standards.CCNAE2021, "2220"), (Standards.ISIC4, "2220")),
        ((Standards.CCNAE2021, "2310"), (Standards.ISIC4, "2310")),
        ((Standards.CCNAE2021, "2391"), (Standards.ISIC4, "2391")),
        ((Standards.CCNAE2021, "2392"), (Standards.ISIC4, "2392")),
        ((Standards.CCNAE2021, "2393"), (Standards.ISIC4, "2393")),
        ((Standards.CCNAE2021, "2394"), (Standards.ISIC4, "2394")),
        ((Standards.CCNAE2021, "2395"), (Standards.ISIC4, "2395")),
        ((Standards.CCNAE2021, "2396"), (Standards.ISIC4, "2396")),
        ((Standards.CCNAE2021, "2399"), (Standards.ISIC4, "2399")),
        ((Standards.CCNAE2021, "2410"), (Standards.ISIC4, "2410")),
        ((Standards.CCNAE2021, "2420"), (Standards.ISIC4, "2420")),
        ((Standards.CCNAE2021, "2421"), (Standards.ISIC4, "2420")),
        ((Standards.CCNAE2021, "2431"), (Standards.ISIC4, "2431")),
        ((Standards.CCNAE2021, "2432"), (Standards.ISIC4, "2432")),
        ((Standards.CCNAE2021, "2511"), (Standards.ISIC4, "2511")),
        ((Standards.CCNAE2021, "2512"), (Standards.ISIC4, "2512")),
        ((Standards.CCNAE2021, "2513"), (Standards.ISIC4, "2513")),
        ((Standards.CCNAE2021, "2520"), (Standards.ISIC4, "2520")),
        ((Standards.CCNAE2021, "2591"), (Standards.ISIC4, "2591")),
        ((Standards.CCNAE2021, "2592"), (Standards.ISIC4, "2592")),
        ((Standards.CCNAE2021, "2593"), (Standards.ISIC4, "2593")),
        ((Standards.CCNAE2021, "2599"), (Standards.ISIC4, "2599")),
        ((Standards.CCNAE2021, "2610"), (Standards.ISIC4, "2610")),
        ((Standards.CCNAE2021, "2620"), (Standards.ISIC4, "2620")),
        ((Standards.CCNAE2021, "2630"), (Standards.ISIC4, "2630")),
        ((Standards.CCNAE2021, "2640"), (Standards.ISIC4, "2640")),
        ((Standards.CCNAE2021, "2651"), (Standards.ISIC4, "2651")),
        ((Standards.CCNAE2021, "2652"), (Standards.ISIC4, "2652")),
        ((Standards.CCNAE2021, "2660"), (Standards.ISIC4, "2660")),
        ((Standards.CCNAE2021, "2670"), (Standards.ISIC4, "2670")),
        ((Standards.CCNAE2021, "2680"), (Standards.ISIC4, "2680")),
        ((Standards.CCNAE2021, "3311"), (Standards.ISIC4, "2710")),
        ((Standards.CCNAE2021, "2720"), (Standards.ISIC4, "2720")),
        ((Standards.CCNAE2021, "2731"), (Standards.ISIC4, "2731")),
        ((Standards.CCNAE2021, "2732"), (Standards.ISIC4, "2732")),
        ((Standards.CCNAE2021, "2733"), (Standards.ISIC4, "2733")),
        ((Standards.CCNAE2021, "2740"), (Standards.ISIC4, "2740")),
        ((Standards.CCNAE2021, "2750"), (Standards.ISIC4, "2750")),
        ((Standards.CCNAE2021, "2790"), (Standards.ISIC4, "2790")),
        ((Standards.CCNAE2021, "2811"), (Standards.ISIC4, "2811")),
        ((Standards.CCNAE2021, "2812"), (Standards.ISIC4, "2812")),
        ((Standards.CCNAE2021, "2813"), (Standards.ISIC4, "2813")),
        ((Standards.CCNAE2021, "2814"), (Standards.ISIC4, "2814")),
        ((Standards.CCNAE2021, "2815"), (Standards.ISIC4, "2815")),
        ((Standards.CCNAE2021, "2816"), (Standards.ISIC4, "2816")),
        ((Standards.CCNAE2021, "2817"), (Standards.ISIC4, "2817")),
        ((Standards.CCNAE2021, "2818"), (Standards.ISIC4, "2818")),
        ((Standards.CCNAE2021, "2819"), (Standards.ISIC4, "2819")),
        ((Standards.CCNAE2021, "2821"), (Standards.ISIC4, "2821")),
        ((Standards.CCNAE2021, "2822"), (Standards.ISIC4, "2822")),
        ((Standards.CCNAE2021, "2823"), (Standards.ISIC4, "2823")),
        ((Standards.CCNAE2021, "2824"), (Standards.ISIC4, "2824")),
        ((Standards.CCNAE2021, "2825"), (Standards.ISIC4, "2825")),
        ((Standards.CCNAE2021, "2826"), (Standards.ISIC4, "2826")),
        ((Standards.CCNAE2021, "2829"), (Standards.ISIC4, "2829")),
        ((Standards.CCNAE2021, "2910"), (Standards.ISIC4, "2910")),
        ((Standards.CCNAE2021, "2920"), (Standards.ISIC4, "2920")),
        ((Standards.CCNAE2021, "2930"), (Standards.ISIC4, "2930")),
        ((Standards.CCNAE2021, "3011"), (Standards.ISIC4, "3011")),
        ((Standards.CCNAE2021, "3012"), (Standards.ISIC4, "3012")),
        ((Standards.CCNAE2021, "3020"), (Standards.ISIC4, "3020")),
        ((Standards.CCNAE2021, "3030"), (Standards.ISIC4, "3030")),
        ((Standards.CCNAE2021, "3040"), (Standards.ISIC4, "3040")),
        ((Standards.CCNAE2021, "3091"), (Standards.ISIC4, "3091")),
        ((Standards.CCNAE2021, "3092"), (Standards.ISIC4, "3092")),
        ((Standards.CCNAE2021, "3099"), (Standards.ISIC4, "3099")),
        ((Standards.CCNAE2021, "3100"), (Standards.ISIC4, "3100")),
        ((Standards.CCNAE2021, "3211"), (Standards.ISIC4, "3211")),
        ((Standards.CCNAE2021, "3212"), (Standards.ISIC4, "3212")),
        ((Standards.CCNAE2021, "3220"), (Standards.ISIC4, "3220")),
        ((Standards.CCNAE2021, "3230"), (Standards.ISIC4, "3230")),
        ((Standards.CCNAE2021, "3240"), (Standards.ISIC4, "3240")),
        ((Standards.CCNAE2021, "3250"), (Standards.ISIC4, "3250")),
        ((Standards.CCNAE2021, "3290"), (Standards.ISIC4, "3290")),
        ((Standards.CCNAE2021, "3311"), (Standards.ISIC4, "3311")),
        ((Standards.CCNAE2021, "3312"), (Standards.ISIC4, "3312")),
        ((Standards.CCNAE2021, "3313"), (Standards.ISIC4, "3313")),
        ((Standards.CCNAE2021, "3314"), (Standards.ISIC4, "3314")),
        ((Standards.CCNAE2021, "3315"), (Standards.ISIC4, "3315")),
        ((Standards.CCNAE2021, "3319"), (Standards.ISIC4, "3319")),
        ((Standards.CCNAE2021, "3320"), (Standards.ISIC4, "3320")),
        ((Standards.CCNAE2021, "3510"), (Standards.ISIC4, "3510")),
        ((Standards.CCNAE2021, "3520"), (Standards.ISIC4, "3520")),
        ((Standards.CCNAE2021, "3530"), (Standards.ISIC4, "3530")),
        ((Standards.CCNAE2021, "3600"), (Standards.ISIC4, "3600")),
        ((Standards.CCNAE2021, "3700"), (Standards.ISIC4, "3700")),
        ((Standards.CCNAE2021, "3811"), (Standards.ISIC4, "3811")),
        ((Standards.CCNAE2021, "3812"), (Standards.ISIC4, "3812")),
        ((Standards.CCNAE2021, "3821"), (Standards.ISIC4, "3821")),
        ((Standards.CCNAE2021, "3822"), (Standards.ISIC4, "3822")),
        ((Standards.CCNAE2021, "3830"), (Standards.ISIC4, "3830")),
        ((Standards.CCNAE2021, "3900"), (Standards.ISIC4, "3900")),
        ((Standards.CCNAE2021, "4100"), (Standards.ISIC4, "4100")),
        ((Standards.CCNAE2021, "4210"), (Standards.ISIC4, "4210")),
        ((Standards.CCNAE2021, "4220"), (Standards.ISIC4, "4220")),
        ((Standards.CCNAE2021, "4290"), (Standards.ISIC4, "4290")),
        ((Standards.CCNAE2021, "4311"), (Standards.ISIC4, "4311")),
        ((Standards.CCNAE2021, "4312"), (Standards.ISIC4, "4312")),
        ((Standards.CCNAE2021, "4321"), (Standards.ISIC4, "4321")),
        ((Standards.CCNAE2021, "4322"), (Standards.ISIC4, "4322")),
        ((Standards.CCNAE2021, "4329"), (Standards.ISIC4, "4329")),
        ((Standards.CCNAE2021, "4330"), (Standards.ISIC4, "4330")),
        ((Standards.CCNAE2021, "4390"), (Standards.ISIC4, "4390")),
        ((Standards.CCNAE2021, "4510"), (Standards.ISIC4, "4510")),
        ((Standards.CCNAE2021, "4520"), (Standards.ISIC4, "4520")),
        ((Standards.CCNAE2021, "4530"), (Standards.ISIC4, "4530")),
        ((Standards.CCNAE2021, "4540"), (Standards.ISIC4, "4540")),
        ((Standards.CCNAE2021, "4610"), (Standards.ISIC4, "4610")),
        ((Standards.CCNAE2021, "4620"), (Standards.ISIC4, "4620")),
        ((Standards.CCNAE2021, "4630"), (Standards.ISIC4, "4630")),
        ((Standards.CCNAE2021, "4641"), (Standards.ISIC4, "4641")),
        ((Standards.CCNAE2021, "4649"), (Standards.ISIC4, "4649")),
        ((Standards.CCNAE2021, "4651"), (Standards.ISIC4, "4651")),
        ((Standards.CCNAE2021, "4652"), (Standards.ISIC4, "4652")),
        ((Standards.CCNAE2021, "4653"), (Standards.ISIC4, "4653")),
        ((Standards.CCNAE2021, "4659"), (Standards.ISIC4, "4659")),
        ((Standards.CCNAE2021, "4661"), (Standards.ISIC4, "4661")),
        ((Standards.CCNAE2021, "4662"), (Standards.ISIC4, "4662")),
        ((Standards.CCNAE2021, "4663"), (Standards.ISIC4, "4663")),
        ((Standards.CCNAE2021, "4669"), (Standards.ISIC4, "4669")),
        ((Standards.CCNAE2021, "4690"), (Standards.ISIC4, "4690")),
        ((Standards.CCNAE2021, "4711"), (Standards.ISIC4, "4711")),
        ((Standards.CCNAE2021, "4719"), (Standards.ISIC4, "4719")),
        ((Standards.CCNAE2021, "4721"), (Standards.ISIC4, "4721")),
        ((Standards.CCNAE2021, "4722"), (Standards.ISIC4, "4722")),
        ((Standards.CCNAE2021, "4723"), (Standards.ISIC4, "4723")),
        ((Standards.CCNAE2021, "4730"), (Standards.ISIC4, "4730")),
        ((Standards.CCNAE2021, "4741"), (Standards.ISIC4, "4741")),
        ((Standards.CCNAE2021, "4742"), (Standards.ISIC4, "4742")),
        ((Standards.CCNAE2021, "4751"), (Standards.ISIC4, "4751")),
        ((Standards.CCNAE2021, "4752"), (Standards.ISIC4, "4752")),
        ((Standards.CCNAE2021, "4753"), (Standards.ISIC4, "4753")),
        ((Standards.CCNAE2021, "4759"), (Standards.ISIC4, "4759")),
        ((Standards.CCNAE2021, "4761"), (Standards.ISIC4, "4761")),
        ((Standards.CCNAE2021, "4762"), (Standards.ISIC4, "4762")),
        ((Standards.CCNAE2021, "4763"), (Standards.ISIC4, "4763")),
        ((Standards.CCNAE2021, "4764"), (Standards.ISIC4, "4764")),
        ((Standards.CCNAE2021, "4771"), (Standards.ISIC4, "4771")),
        ((Standards.CCNAE2021, "4772"), (Standards.ISIC4, "4772")),
        ((Standards.CCNAE2021, "4773"), (Standards.ISIC4, "4773")),
        ((Standards.CCNAE2021, "4774"), (Standards.ISIC4, "4774")),
        ((Standards.CCNAE2021, "4781"), (Standards.ISIC4, "4781")),
        ((Standards.CCNAE2021, "4782"), (Standards.ISIC4, "4782")),
        ((Standards.CCNAE2021, "4789"), (Standards.ISIC4, "4789")),
        ((Standards.CCNAE2021, "4791"), (Standards.ISIC4, "4791")),
        ((Standards.CCNAE2021, "4799"), (Standards.ISIC4, "4799")),
        ((Standards.CCNAE2021, "4911"), (Standards.ISIC4, "4911")),
        ((Standards.CCNAE2021, "4912"), (Standards.ISIC4, "4912")),
        ((Standards.CCNAE2021, "4921"), (Standards.ISIC4, "4921")),
        ((Standards.CCNAE2021, "4922"), (Standards.ISIC4, "4922")),
        ((Standards.CCNAE2021, "4923"), (Standards.ISIC4, "4923")),
        ((Standards.CCNAE2021, "4930"), (Standards.ISIC4, "4930")),
        ((Standards.CCNAE2021, "5011"), (Standards.ISIC4, "5011")),
        ((Standards.CCNAE2021, "5012"), (Standards.ISIC4, "5012")),
        ((Standards.CCNAE2021, "5021"), (Standards.ISIC4, "5021")),
        ((Standards.CCNAE2021, "5022"), (Standards.ISIC4, "5022")),
        ((Standards.CCNAE2021, "5110"), (Standards.ISIC4, "5110")),
        ((Standards.CCNAE2021, "5120"), (Standards.ISIC4, "5120")),
        ((Standards.CCNAE2021, "5210"), (Standards.ISIC4, "5210")),
        ((Standards.CCNAE2021, "5221"), (Standards.ISIC4, "5221")),
        ((Standards.CCNAE2021, "5222"), (Standards.ISIC4, "5222")),
        ((Standards.CCNAE2021, "5223"), (Standards.ISIC4, "5223")),
        ((Standards.CCNAE2021, "5224"), (Standards.ISIC4, "5224")),
        ((Standards.CCNAE2021, "5229"), (Standards.ISIC4, "5229")),
        ((Standards.CCNAE2021, "5310"), (Standards.ISIC4, "5310")),
        ((Standards.CCNAE2021, "5320"), (Standards.ISIC4, "5320")),
        ((Standards.CCNAE2021, "5510"), (Standards.ISIC4, "5510")),
        ((Standards.CCNAE2021, "5520"), (Standards.ISIC4, "5520")),
        ((Standards.CCNAE2021, "5590"), (Standards.ISIC4, "5590")),
        ((Standards.CCNAE2021, "5610"), (Standards.ISIC4, "5610")),
        ((Standards.CCNAE2021, "5621"), (Standards.ISIC4, "5621")),
        ((Standards.CCNAE2021, "5629"), (Standards.ISIC4, "5629")),
        ((Standards.CCNAE2021, "5630"), (Standards.ISIC4, "5630")),
        ((Standards.CCNAE2021, "5811"), (Standards.ISIC4, "5811")),
        ((Standards.CCNAE2021, "5812"), (Standards.ISIC4, "5812")),
        ((Standards.CCNAE2021, "5813"), (Standards.ISIC4, "5813")),
        ((Standards.CCNAE2021, "5819"), (Standards.ISIC4, "5819")),
        ((Standards.CCNAE2021, "5820"), (Standards.ISIC4, "5820")),
        ((Standards.CCNAE2021, "5911"), (Standards.ISIC4, "5911")),
        ((Standards.CCNAE2021, "5912"), (Standards.ISIC4, "5912")),
        ((Standards.CCNAE2021, "5913"), (Standards.ISIC4, "5913")),
        ((Standards.CCNAE2021, "5914"), (Standards.ISIC4, "5914")),
        ((Standards.CCNAE2021, "5920"), (Standards.ISIC4, "5920")),
        ((Standards.CCNAE2021, "6010"), (Standards.ISIC4, "6010")),
        ((Standards.CCNAE2021, "6020"), (Standards.ISIC4, "6020")),
        ((Standards.CCNAE2021, "6110"), (Standards.ISIC4, "6110")),
        ((Standards.CCNAE2021, "6120"), (Standards.ISIC4, "6120")),
        ((Standards.CCNAE2021, "6130"), (Standards.ISIC4, "6130")),
        ((Standards.CCNAE2021, "6190"), (Standards.ISIC4, "6190")),
        ((Standards.CCNAE2021, "6201"), (Standards.ISIC4, "6201")),
        ((Standards.CCNAE2021, "6202"), (Standards.ISIC4, "6202")),
        ((Standards.CCNAE2021, "6209"), (Standards.ISIC4, "6209")),
        ((Standards.CCNAE2021, "6311"), (Standards.ISIC4, "6311")),
        ((Standards.CCNAE2021, "6312"), (Standards.ISIC4, "6312")),
        ((Standards.CCNAE2021, "6391"), (Standards.ISIC4, "6391")),
        ((Standards.CCNAE2021, "6399"), (Standards.ISIC4, "6399")),
        ((Standards.CCNAE2021, "6411"), (Standards.ISIC4, "6411")),
        ((Standards.CCNAE2021, "6419"), (Standards.ISIC4, "6419")),
        ((Standards.CCNAE2021, "6420"), (Standards.ISIC4, "6420")),
        ((Standards.CCNAE2021, "6430"), (Standards.ISIC4, "6430")),
        ((Standards.CCNAE2021, "6491"), (Standards.ISIC4, "6491")),
        ((Standards.CCNAE2021, "6492"), (Standards.ISIC4, "6492")),
        ((Standards.CCNAE2021, "6499"), (Standards.ISIC4, "6499")),
        ((Standards.CCNAE2021, "6511"), (Standards.ISIC4, "6511")),
        ((Standards.CCNAE2021, "6512"), (Standards.ISIC4, "6512")),
        ((Standards.CCNAE2021, "6520"), (Standards.ISIC4, "6520")),
        ((Standards.CCNAE2021, "6530"), (Standards.ISIC4, "6530")),
        ((Standards.CCNAE2021, "6611"), (Standards.ISIC4, "6611")),
        ((Standards.CCNAE2021, "6612"), (Standards.ISIC4, "6612")),
        ((Standards.CCNAE2021, "6619"), (Standards.ISIC4, "6619")),
        ((Standards.CCNAE2021, "6621"), (Standards.ISIC4, "6621")),
        ((Standards.CCNAE2021, "6622"), (Standards.ISIC4, "6622")),
        ((Standards.CCNAE2021, "6629"), (Standards.ISIC4, "6629")),
        ((Standards.CCNAE2021, "6630"), (Standards.ISIC4, "6630")),
        ((Standards.CCNAE2021, "6810"), (Standards.ISIC4, "6810")),
        ((Standards.CCNAE2021, "6820"), (Standards.ISIC4, "6820")),
        ((Standards.CCNAE2021, "6910"), (Standards.ISIC4, "6910")),
        ((Standards.CCNAE2021, "6920"), (Standards.ISIC4, "6920")),
        ((Standards.CCNAE2021, "7010"), (Standards.ISIC4, "7010")),
        ((Standards.CCNAE2021, "7020"), (Standards.ISIC4, "7020")),
        ((Standards.CCNAE2021, "7110"), (Standards.ISIC4, "7110")),
        ((Standards.CCNAE2021, "7120"), (Standards.ISIC4, "7120")),
        ((Standards.CCNAE2021, "7210"), (Standards.ISIC4, "7210")),
        ((Standards.CCNAE2021, "7220"), (Standards.ISIC4, "7220")),
        ((Standards.CCNAE2021, "7310"), (Standards.ISIC4, "7310")),
        ((Standards.CCNAE2021, "7320"), (Standards.ISIC4, "7320")),
        ((Standards.CCNAE2021, "7410"), (Standards.ISIC4, "7410")),
        ((Standards.CCNAE2021, "7420"), (Standards.ISIC4, "7420")),
        ((Standards.CCNAE2021, "7490"), (Standards.ISIC4, "7490")),
        ((Standards.CCNAE2021, "7500"), (Standards.ISIC4, "7500")),
        ((Standards.CCNAE2021, "7710"), (Standards.ISIC4, "7710")),
        ((Standards.CCNAE2021, "7721"), (Standards.ISIC4, "7721")),
        ((Standards.CCNAE2021, "7722"), (Standards.ISIC4, "7722")),
        ((Standards.CCNAE2021, "7729"), (Standards.ISIC4, "7729")),
        ((Standards.CCNAE2021, "7730"), (Standards.ISIC4, "7730")),
        ((Standards.CCNAE2021, "7740"), (Standards.ISIC4, "7740")),
        ((Standards.CCNAE2021, "7810"), (Standards.ISIC4, "7810")),
        ((Standards.CCNAE2021, "7820"), (Standards.ISIC4, "7820")),
        ((Standards.CCNAE2021, "7830"), (Standards.ISIC4, "7830")),
        ((Standards.CCNAE2021, "7911"), (Standards.ISIC4, "7911")),
        ((Standards.CCNAE2021, "7912"), (Standards.ISIC4, "7912")),
        ((Standards.CCNAE2021, "7990"), (Standards.ISIC4, "7990")),
        ((Standards.CCNAE2021, "8010"), (Standards.ISIC4, "8010")),
        ((Standards.CCNAE2021, "8020"), (Standards.ISIC4, "8020")),
        ((Standards.CCNAE2021, "8030"), (Standards.ISIC4, "8030")),
        ((Standards.CCNAE2021, "8110"), (Standards.ISIC4, "8110")),
        ((Standards.CCNAE2021, "8121"), (Standards.ISIC4, "8121")),
        ((Standards.CCNAE2021, "8129"), (Standards.ISIC4, "8129")),
        ((Standards.CCNAE2021, "8130"), (Standards.ISIC4, "8130")),
        ((Standards.CCNAE2021, "8211"), (Standards.ISIC4, "8211")),
        ((Standards.CCNAE2021, "8219"), (Standards.ISIC4, "8219")),
        ((Standards.CCNAE2021, "8220"), (Standards.ISIC4, "8220")),
        ((Standards.CCNAE2021, "8230"), (Standards.ISIC4, "8230")),
        ((Standards.CCNAE2021, "8291"), (Standards.ISIC4, "8291")),
        ((Standards.CCNAE2021, "8292"), (Standards.ISIC4, "8292")),
        ((Standards.CCNAE2021, "8299"), (Standards.ISIC4, "8299")),
        ((Standards.CCNAE2021, "8411"), (Standards.ISIC4, "8411")),
        ((Standards.CCNAE2021, "8412"), (Standards.ISIC4, "8412")),
        ((Standards.CCNAE2021, "8413"), (Standards.ISIC4, "8413")),
        ((Standards.CCNAE2021, "8415"), (Standards.ISIC4, "8411")),
        ((Standards.CCNAE2021, "8421"), (Standards.ISIC4, "8421")),
        ((Standards.CCNAE2021, "8422"), (Standards.ISIC4, "8422")),
        ((Standards.CCNAE2021, "8423"), (Standards.ISIC4, "8423")),
        ((Standards.CCNAE2021, "8430"), (Standards.ISIC4, "8430")),
        ((Standards.CCNAE2021, "8510"), (Standards.ISIC4, "8510")),
        ((Standards.CCNAE2021, "8511"), (Standards.ISIC4, "8510")),
        ((Standards.CCNAE2021, "8513"), (Standards.ISIC4, "8510")),
        ((Standards.CCNAE2021, "8521"), (Standards.ISIC4, "8521")),
        ((Standards.CCNAE2021, "8522"), (Standards.ISIC4, "8522")),
        ((Standards.CCNAE2021, "8523"), (Standards.ISIC4, "8521")),
        ((Standards.CCNAE2021, "8530"), (Standards.ISIC4, "8530")),
        ((Standards.CCNAE2021, "8541"), (Standards.ISIC4, "8541")),
        ((Standards.CCNAE2021, "8542"), (Standards.ISIC4, "8542")),
        ((Standards.CCNAE2021, "8549"), (Standards.ISIC4, "8549")),
        ((Standards.CCNAE2021, "8550"), (Standards.ISIC4, "8550")),
        ((Standards.CCNAE2021, "8561"), (Standards.ISIC4, "8510")),
        ((Standards.CCNAE2021, "8561"), (Standards.ISIC4, "8521")),
        ((Standards.CCNAE2021, "8562"), (Standards.ISIC4, "8521")),
        ((Standards.CCNAE2021, "8562"), (Standards.ISIC4, "8522")),
        ((Standards.CCNAE2021, "8610"), (Standards.ISIC4, "8610")),
        ((Standards.CCNAE2021, "8620"), (Standards.ISIC4, "8620")),
        ((Standards.CCNAE2021, "8690"), (Standards.ISIC4, "8690")),
        ((Standards.CCNAE2021, "8710"), (Standards.ISIC4, "8710")),
        ((Standards.CCNAE2021, "8720"), (Standards.ISIC4, "8720")),
        ((Standards.CCNAE2021, "8730"), (Standards.ISIC4, "8730")),
        ((Standards.CCNAE2021, "8790"), (Standards.ISIC4, "8790")),
        ((Standards.CCNAE2021, "8810"), (Standards.ISIC4, "8810")),
        ((Standards.CCNAE2021, "8890"), (Standards.ISIC4, "8890")),
        ((Standards.CCNAE2021, "9000"), (Standards.ISIC4, "9000")),
        ((Standards.CCNAE2021, "9101"), (Standards.ISIC4, "9101")),
        ((Standards.CCNAE2021, "9102"), (Standards.ISIC4, "9102")),
        ((Standards.CCNAE2021, "9103"), (Standards.ISIC4, "9103")),
        ((Standards.CCNAE2021, "9200"), (Standards.ISIC4, "9200")),
        ((Standards.CCNAE2021, "9311"), (Standards.ISIC4, "9311")),
        ((Standards.CCNAE2021, "9312"), (Standards.ISIC4, "9312")),
        ((Standards.CCNAE2021, "9319"), (Standards.ISIC4, "9319")),
        ((Standards.CCNAE2021, "9321"), (Standards.ISIC4, "9321")),
        ((Standards.CCNAE2021, "9329"), (Standards.ISIC4, "9329")),
        ((Standards.CCNAE2021, "9411"), (Standards.ISIC4, "9411")),
        ((Standards.CCNAE2021, "9412"), (Standards.ISIC4, "9412")),
        ((Standards.CCNAE2021, "9420"), (Standards.ISIC4, "9420")),
        ((Standards.CCNAE2021, "9491"), (Standards.ISIC4, "9491")),
        ((Standards.CCNAE2021, "9492"), (Standards.ISIC4, "9492")),
        ((Standards.CCNAE2021, "9499"), (Standards.ISIC4, "9499")),
        ((Standards.CCNAE2021, "9511"), (Standards.ISIC4, "9511")),
        ((Standards.CCNAE2021, "9512"), (Standards.ISIC4, "9512")),
        ((Standards.CCNAE2021, "9521"), (Standards.ISIC4, "9521")),
        ((Standards.CCNAE2021, "9522"), (Standards.ISIC4, "9522")),
        ((Standards.CCNAE2021, "9523"), (Standards.ISIC4, "9523")),
        ((Standards.CCNAE2021, "9524"), (Standards.ISIC4, "9524")),
        ((Standards.CCNAE2021, "9529"), (Standards.ISIC4, "9529")),
        ((Standards.CCNAE2021, "9601"), (Standards.ISIC4, "9601")),
        ((Standards.CCNAE2021, "9602"), (Standards.ISIC4, "9602")),
        ((Standards.CCNAE2021, "9603"), (Standards.ISIC4, "9603")),
        ((Standards.CCNAE2021, "9609"), (Standards.ISIC4, "9609")),
        ((Standards.CCNAE2021, "9700"), (Standards.ISIC4, "9700")),
        ((Standards.CCNAE2021, "9810"), (Standards.ISIC4, "9810")),
        ((Standards.CCNAE2021, "9820"), (Standards.ISIC4, "9820")),
    ],
)
