"""Opyplus compatibility package, allows to handle different versions of EnergyPlus on different platforms."""

__all__ = ["get_eplus_base_dir_path", "APPS_DIR_PATH", "EPLUS_AVAILABLE_VERSIONS", "EPLUS_DIR_PATTERN",
           "get_simulated_epw_path", "get_simulation_base_command", "get_simulation_command_style",
           "get_simulation_input_command_style", "SIMULATION_COMMAND_STYLES", "SIMULATION_INPUT_COMMAND_STYLES"]

from .util import APPS_DIR_PATH, EPLUS_DIR_PATTERN
from .simulation import SIMULATION_COMMAND_STYLES, SIMULATION_INPUT_COMMAND_STYLES, get_simulation_base_command, \
    get_simulation_input_command_style, get_simulation_command_style, EPLUS_AVAILABLE_VERSIONS, get_eplus_base_dir_path
from .epw import get_simulated_epw_path  # must be at the end to prevent an import error
