"""tssc.StepImplementers for the 'validate-environment-configuration' TSSC step.


Step Configuration
------------------
All tssc.StepImplementers for this step should
accept minimally the following configuration options.

| Parameter       | Description
|-----------------|------------
| `yaml_path`     | Path to the files to be reviewed.

Results
-------
All tssc.StepImplementers for this step should
minimally produce the following step results.

| Result             | Description
|--------------------|------------
| `result`           | A dictionary describing the results of this step
| `report-artifacts` | An array of dictionaries describing artifacts \
                       generated by this step


"""
from .configlint import Configlint
from .configlint_from_argocd import ConfiglintFromArgocd

__all__ = [
    'configlint',
    'configlint_from_argocd'
]
