ms1searchpy - a DirectMS1 proteomics search engine for LC-MS1 spectra
-----------------------------------------------------------------------

The .tsv (or mzML) and .fasta files are required for basic operation of the script.
tsv file is tab-separated text file with peptide features generated by Dinosaur software (J.Teleman et al., "Dinosaur: A Refined Open-Source Peptide MS Feature Detector", JPR 2016) or Biosaur (https://github.com/abdrakhimov1/Biosaur) from mzML file. This file can be generated by any other software for peak-picking and must contain columns 'massCalib', 'rtApex', 'charge' and 'nIsotopes' columns.
For a сonvenient usage, mzML files can be used directly and the script will run an attached version of Dinosaur (installed Java is required).  
For an efficient usage of retention time, user can install and use ELUDE prediction algorithm (-elude path_to_elude_binary should be used in parameters).
For the most efficient usage of retention time, user can install and use DeepLC prediction algorithm (-deeplc path_to_deeplc_binary should be used in parameters).

Algorithm can be run with following command:

    ms1searchpy path_to_MZML -d path_to_fasta

    OR

    ms1searchpy path_to_peptideFeatures -d path_to_fasta

The script output contains files: all identified proteins (filename_proteins_full.csv), filtered proteins (filename_proteins.csv), all matched peptide match fingerprints (filename_PFMs.csv), all matched peptide match fingerprints with features prepared for Machnine Learning (filename_PFMs_ML.csv) and log file with estimated mass and RT accuracies (filename_log.txt).

Citing ms1searchpy
-------------------
Ivanov et al. DirectMS1: MS/MS-free identification of 1000 proteins of cellular proteomes in 5 minutes. https://doi.org/10.1021/acs.analchem.9b05095

Installation
-------------
Using the pip:

    pip install ms1searchpy
    
Example for full installation and usage:
-----------------------------------------

    pip3 install ms1searchpy
    pip3 install deeplc
    pip3 install biosaur
    
 Convert raw files to mzML: 
 
    msconvert.dock path_to_file.raw -o path_to_output_folder --mzML --filter "peakPicking true 1-" --filter "MS2Deisotope" --filter "zeroSamples removeExtra" --filter "threshold absolute 1 most-intense"

Extract features from mzML:

    biosaur path_to_mzml
    *OR “biosaur path_to_mzml --faims” for FAIMS data
    *OR  “biosaur path_to_mzml --negative_mode” for negative ions data
    
Prepare shuffled!! decoy database. Python code example:

	from pyteomics import fasta
    fasta.write_decoy_db(source='/home/test/sprot_human.fasta', output=open('/home/test/sprot_human_shuffled.fasta', 'w'), mode='shuffle').close()	

Alternative way is to use -ad 1 option in ms1searchpy for automatic decoy database creation.

Run DirectMS1search:

	ms1searchpy path_to.features.tsv -d path_to_shuffled.fasta -sc 2 -i 2 -nproc 9 -mc 0 -cmin 1 -ptol 8 -fdr 1 -deeplc ~/virtualenv_deeplc/bin/deeplc -ts 2 -ml 1 -nproc 9
    
Enjoy!


Dependencies
------------

- pyteomics
- numpy
- scipy
- sklearn
- lightgbm
- pandas
- biosaur

Links
-----

- GitHub repo & issue tracker: https://github.com/markmipt/ms1searchpy
- Mailing list: markmipt@gmail.com

- Dinosaur repo: https://github.com/fickludd/dinosaur
