#
#   © Copyright 2020 Hewlett Packard Enterprise Development LP
#
#   This file was auto-generated by the Python SDK generator; DO NOT EDIT.
#


from ...resource import Resource, Collection
from .snapshots import SnapshotList
from .volume_collections import VolumeCollection


class Volume(Resource):
    """Volumes are the basic storage units from which the total capacity is apportioned. The terms volume and LUN are used interchangeably.The number of volumes per array depends on
    storage allocation.

    # Parameters
    id                            : Identifier for the volume.
    name                          : Name of the volume.
    full_name                     : Fully qualified name of volume.
    search_name                   : Name of volume used for object search.
    size                          : Volume size in mebibytes. Size is required for creating a volume but not for cloning an existing volume.
    description                   : Text description of volume.
    perfpolicy_name               : Name of performance policy.
    perfpolicy_id                 : Identifier of the performance policy. After creating a volume, performance policy for the volume can only be changed to another performance
                                    policy with same block size.
    reserve                       : Amount of space to reserve for this volume as a percentage of volume size.
    warn_level                    : This attribute is deprecated. Alert threshold for the volume's mapped usage, expressed as a percentage of the volume's size. When the volume's
                                    mapped usage exceeds warn_level, the array issues an alert. If this option is not specified, array default volume warn level setting is used to
                                    decide the warning level for this volume.
    limit                         : Limit on the volume's mapped usage, expressed as a percentage of the volume's size. When the volume's mapped usage exceeds limit, the volume
                                    will be offlined or made non-writable. If this option is not specified, array default volume limit setting is used to decide the limit for this
                                    volume.
    snap_reserve                  : Amount of space to reserve for snapshots of this volume as a percentage of volume size.
    snap_warn_level               : Threshold for available space as a percentage of volume size below which an alert is raised.
    snap_limit                    : This attribute is deprecated. The array does not limit a volume's snapshot space usage. The attribute is ignored on input and returns max int64
                                    on output.
    snap_limit_percent            : This attribute is deprecated. The array does not limit a volume's snapshot space usage. The attribute is ignored on input and returns -1 on
                                    output.
    num_snaps                     : Number of live, non-hidden snapshots for this volume.
    projected_num_snaps           : Deprecated. Projected number of snapshots (including scheduled and manual) for this volume.
    online                        : Online state of volume, available for host initiators to establish connections.
    owned_by_group                : Name of group that currently owns the volume.
    owned_by_group_id             : ID of group that currently owns the volume.
    multi_initiator               : For iSCSI Volume Target, this flag indicates whether the volume and its snapshots can be accessed from multiple initiators at the same time.
                                    The default is false. For iSCSI Group Target or FC access protocol, the attribute cannot be modified and always reads as false.
    iscsi_target_scope            : This indicates whether volume is exported under iSCSI Group Target or iSCSI Volume Target. This attribute is only meaningful to iSCSI system.
                                    On FC system, all volumes are exported under the FC Group Target. In create operation, the volume's target type will be set by this attribute.
                                    If not specified, it will be set as the group-setting. In clone operation, the clone's target type will inherit from the parent' setting.
    pool_name                     : Name of the pool where the volume resides. Volume data will be distributed across arrays over which specified pool is defined. If pool option
                                    is not specified, volume is assigned to the default pool.
    pool_id                       : Identifier associated with the pool in the storage pool table.
    read_only                     : Volume is read-only.
    serial_number                 : Identifier associated with the volume for the SCSI protocol.
    secondary_serial_number       : Secondary identifier associated with the volume for the SCSI protocol.
    target_name                   : The iSCSI Qualified Name (IQN) or the Fibre Channel World Wide Node Name (WWNN) of the target volume.
    block_size                    : Size in bytes of blocks in the volume.
    offline_reason                : Volume offline reason.
    clone                         : Whether this volume is a clone. Use this attribute in combination with name and base_snap_id to create a clone by setting clone = true.
    parent_vol_name               : Name of parent volume.
    parent_vol_id                 : Parent volume ID.
    base_snap_name                : Name of base snapshot.
    base_snap_id                  : Base snapshot ID. This attribute is required together with name and clone when cloning a volume with the create operation.
    replication_role              : Replication role that this volume performs.
    volcoll_name                  : Name of volume collection of which this volume is a member.
    volcoll_id                    : ID of volume collection of which this volume is a member. Use this attribute in update operation to associate or dissociate volumes with or
                                    from volume collections. When associating, set this attribute to the ID of the volume collection. When dissociating, set this attribute to
                                    empty string.
    agent_type                    : External management agent type.
    force                         : Forcibly offline, reduce size or change read-only status a volume.
    creation_time                 : Time when this volume was created.
    last_modified                 : Time when this volume was last modified.
    protection_type               : Specifies if volume is protected with schedules. If protected, indicate whether replication is setup.
    last_snap                     : Last snapshot for this volume.
    last_replicated_snap          : Last replicated snapshot for this volume.
    dest_pool_name                : Name of the destination pool where the volume is moving to.
    dest_pool_id                  : ID of the destination pool where the volume is moving to.
    move_start_time               : The Start time when this volume was moved.
    move_aborting                 : This indicates whether the move of the volume is aborting or not.
    move_bytes_migrated           : The bytes of volume which have been moved.
    move_bytes_remaining          : The bytes of volume which have not been moved.
    move_est_compl_time           : The estimated time of completion of a move.
    usage_valid                   : This indicates whether usage information of volume and snapshots are valid or not.
    space_usage_level             : Indicates space usage level based on warning level.
    total_usage_bytes             : Sum of volume mapped usage and uncompressed backup data(including pending deletes) in bytes of this volume.
    vol_usage_compressed_bytes    : Compressed data in bytes for this volume.
    vol_usage_uncompressed_bytes  : Uncompressed data in bytes for this volume.
    vol_usage_mapped_bytes        : Mapped data in bytes for this volume.
    snap_usage_compressed_bytes   : Sum of compressed backup data in bytes stored in snapshots of this volume.
    snap_usage_uncompressed_bytes : Sum of uncompressed unique backup data in bytes stored in snapshots of this volume.
    snap_usage_populated_bytes    : Sum of backup data in bytes stored in snapshots of this volume without accounting for the sharing of data between snapshots.
    cache_pinned                  : If set to true, all the contents of this volume are kept in flash cache. This provides for consistent performance guarantees for all types of
                                    workloads. The amount of flash needed to pin the volume is equal to the limit for the volume.
    pinned_cache_size             : The amount of flash pinned on the volume.
    cache_needed_for_pin          : The amount of flash needed to pin the volume.
    upstream_cache_pinned         : This indicates whether the upstream volume is cache pinned or not.
    cache_policy                  : Cache policy applied to the volume.
    thinly_provisioned            : Set volume's provisioning level to thin.  Also advertises volume as thinly provisioned to initiators supporting thin provisioning. For such
                                    volumes, soft limit notification is set to initiators when the volume space usage crosses its volume_warn_level. Default is yes. The volume's
                                    space is provisioned immediately, but for advertising status, this change takes effect only for new connections to the volume. Initiators must
                                    disconnect and reconnect for the new setting to be take effect at the initiator level consistently.
    vol_state                     : Status of the volume.
    online_snaps                  : The list of online snapshots of this volume.
    num_connections               : Number of connections of this volume.
    num_iscsi_connections         : Number of iscsi connections of this volume.
    num_fc_connections            : Number of Fibre Channel connections of this volume.
    access_control_records        : List of access control records that apply to this volume.
    inherit_acl                   : In a volume clone operation, if both the parent and the clone have no external management agent (their agent_type property is "none"), then
                                    inherit_acl controls whether the clone will inherit a copy of the parent's access control list. If either the parent or the clone have an
                                    external management agent, then the clone will not inherit the parent's access control list.
    encryption_cipher             : The encryption cipher of the volume.
    app_uuid                      : Application identifier of volume.
    folder_id                     : ID of the folder holding this volume.
    folder_name                   : Name of the folder holding this volume. It can be empty.
    metadata                      : Key-value pairs that augment an volume's attributes.
    iscsi_sessions                : List of iSCSI sessions connected to this volume.
    fc_sessions                   : List of Fibre Channel sessions connected to this volume.
    caching_enabled               : Indicate caching the volume is enabled.
    previously_deduped            : Indicate whether dedupe has ever been enabled on this volume.
    dedupe_enabled                : Indicate whether dedupe is enabled.
    vpd_t10                       : The volume's T10 Vendor ID-based identifier.
    vpd_ieee0                     : The first 64 bits of the volume's EUI-64 identifier, encoded as a hexadecimal string.
    vpd_ieee1                     : The last 64 bits of the volume's EUI-64 identifier, encoded as a hexadecimal string.
    app_category                  : Application category that the volume belongs to.
    limit_iops                    : IOPS limit for this volume. If limit_iops is not specified when a volume is created, or if limit_iops is set to -1, then the volume has no IOPS
                                    limit. If limit_iops is not specified while creating a clone, IOPS limit of parent volume will be used as limit. IOPS limit should be in range
                                    [256, 4294967294] or -1 for unlimited. If both limit_iops and limit_mbps are specified, limit_mbps must not be hit before limit_iops. In other
                                    words, IOPS and MBPS limits should honor limit_iops <= ((limit_mbps MB/s * 2^20 B/MB) / block_size B).
    limit_mbps                    : Throughput limit for this volume in MB/s. If limit_mbps is not specified when a volume is created, or if limit_mbps is set to -1, then the
                                    volume has no MBPS limit. MBPS limit should be in range [1, 4294967294] or -1 for unlimited. If both limit_iops and limit_mbps are specified,
                                    limit_mbps must not be hit before limit_iops. In other words, IOPS and MBPS limits should honor limit_iops <= ((limit_mbps MB/s * 2^20 B/MB) /
                                    block_size B).
    needs_content_repl            : Indicates whether the volume needs content based replication.
    content_repl_errors_found     : Indicates whether the last content based replication had errors.
    last_content_snap_br_cg_uid   : The branch cg uid of the content based snapshot that was last replicated.
    last_content_snap_br_gid      : The branch gid of the content based snapshot that was last replicated.
    last_content_snap_id          : The ID of the content based snapshot that was last replicated.
    cksum_last_verified           : Last checksum verification time.
    pre_filter                    : Pre-filtering criteria.
    avg_stats_last_5mins          : Average statistics in last 5 minutes.
    srep_last_sync                : Time when synchronously replicated volume was last synchronized.
    srep_resync_percent           : Percentage of resync progress for synchronously replicated volume.
    """
    def restore(self, base_snap_id, **kwargs):
        """Restore volume data from a previous snapshot.

        # Parameters
        id           : ID of the restored volume.
        base_snap_id : ID of the snapshot to which this the volume is restored.
        """

        return self._collection.restore(
            self.id,
            base_snap_id,
            **kwargs
        )
    def move(self, dest_pool_id, **kwargs):
        """Move a volume and its related volumes to another pool. To change a single volume's folder assignment (while remaining in the same pool), use a volume update operation to
        change the folder_id attribute.

        # Parameters
        id           : ID of the volume to move.
        dest_pool_id : ID of the destination pool or folder. Specify a pool ID when the volumes should not be in a folder; otherwise, specify a folder ID and the pool will be
                       derived from the folder.
        force_vvol   : Forcibly move a Virtual Volume. Moving Virtual Volume is disruptive to the vCenter, hence it should only be done by the VASA Provider (VP). This flag should
                       only be set by the VP when it calls this API.
        """

        return self._collection.move(
            self.id,
            dest_pool_id,
            **kwargs
        )
    def bulk_move(self, dest_pool_id, vol_ids, **kwargs):
        """Move volumes and their related volumes to another pool. To change a single volume's folder assignment (while remaining in the same pool), use a volume update operation to
        change the folder_id attribute.

        # Parameters
        vol_ids      : IDs of the volumes to move.
        dest_pool_id : ID of the destination pool or folder. Specify a pool ID when the volumes should not be in a folder; otherwise, specify a folder ID and the pool will be
                       derived from the folder.
        force_vvol   : Forcibly move a Virtual Volume. Moving Virtual Volume is disruptive to the vCenter, hence it should only be done by the VASA Provider (VP). This flag should
                       only be set by the VP when it calls this API.
        """

        return self._collection.bulk_move(
            self,
            dest_pool_id,
            vol_ids,
            **kwargs
        )
    def abort_move(self, **kwargs):
        """Abort the in-progress move of the specified volume to another pool.

        # Parameters
        id : ID of the volume to stop moving to a different pool.
        """

        return self._collection.abort_move(
            self.id,
            **kwargs
        )
    def bulk_set_dedupe(self, dedupe_enabled, vol_ids, **kwargs):
        """Enable or disable dedupe on a list of volumes. If the volumes are not dedupe capable, the operation will fail for the specified volume.

        # Parameters
        vol_ids        : IDs of the volumes to enable/disable dedupe.
        dedupe_enabled : Dedupe property to be applied to the list of volumes.
        """

        return self._collection.bulk_set_dedupe(
            self,
            dedupe_enabled,
            vol_ids,
            **kwargs
        )
    def bulk_set_online_and_offline(self, online, vol_ids, **kwargs):
        """Bring a list of volumes online or offline.

        # Parameters
        vol_ids : IDs of the volumes to set online or offline.
        online  : Desired state of the volumes. "true" for online, "false" for offline.
        """

        return self._collection.bulk_set_online_and_offline(
            self,
            online,
            vol_ids,
            **kwargs
        )

    def online(self):
        """Bring volume online."""

        return self._collection.online(
            self.id
        )

    def offline(self):
        """Take volume offline."""

        return self._collection.offline(
            self.id
        )

    def associate(self, volcoll):
        """Associate the volume to a volume_collection."""

        return self._collection.associate(
            self.id,
            volcoll
        )

    def dissociate(self):
        """Dissociate the volume from a volume collection."""

        return self._collection.dissociate(
            self.id
        )

    @property
    def snapshots(self):
        return SnapshotList(
            self._client
        )


class VolumeList(Collection):
    resource = Volume
    resource_type = "volumes"

    def restore(self, id, base_snap_id, **kwargs):
        """Restore volume data from a previous snapshot.

        # Parameters
        id           : ID of the restored volume.
        base_snap_id : ID of the snapshot to which this the volume is restored.
        """

        return self._client.perform_resource_action(
            self.resource_type,
            id,
            'restore',
            base_snap_id=base_snap_id,
            id=id,
            **kwargs
        )

    def move(self, id, dest_pool_id, **kwargs):
        """Move a volume and its related volumes to another pool. To change a single volume's folder assignment (while remaining in the same pool), use a volume update operation to
        change the folder_id attribute.

        # Parameters
        id           : ID of the volume to move.
        dest_pool_id : ID of the destination pool or folder. Specify a pool ID when the volumes should not be in a folder; otherwise, specify a folder ID and the pool will be
                       derived from the folder.
        force_vvol   : Forcibly move a Virtual Volume. Moving Virtual Volume is disruptive to the vCenter, hence it should only be done by the VASA Provider (VP). This flag should
                       only be set by the VP when it calls this API.
        """

        return self._client.perform_resource_action(
            self.resource_type,
            id,
            'move',
            dest_pool_id=dest_pool_id,
            id=id,
            **kwargs
        )

    def bulk_move(self, dest_pool_id, vol_ids, **kwargs):
        """Move volumes and their related volumes to another pool. To change a single volume's folder assignment (while remaining in the same pool), use a volume update operation to
        change the folder_id attribute.

        # Parameters
        vol_ids      : IDs of the volumes to move.
        dest_pool_id : ID of the destination pool or folder. Specify a pool ID when the volumes should not be in a folder; otherwise, specify a folder ID and the pool will be
                       derived from the folder.
        force_vvol   : Forcibly move a Virtual Volume. Moving Virtual Volume is disruptive to the vCenter, hence it should only be done by the VASA Provider (VP). This flag should
                       only be set by the VP when it calls this API.
        """

        return self._client.perform_bulk_resource_action(
            self.resource_type,
            'bulk_move',
            dest_pool_id=dest_pool_id,
            vol_ids=vol_ids,
            **kwargs
        )

    def abort_move(self, id, **kwargs):
        """Abort the in-progress move of the specified volume to another pool.

        # Parameters
        id : ID of the volume to stop moving to a different pool.
        """

        return self._client.perform_resource_action(
            self.resource_type,
            id,
            'abort_move',
            id=id,
            **kwargs
        )

    def bulk_set_dedupe(self, dedupe_enabled, vol_ids, **kwargs):
        """Enable or disable dedupe on a list of volumes. If the volumes are not dedupe capable, the operation will fail for the specified volume.

        # Parameters
        vol_ids        : IDs of the volumes to enable/disable dedupe.
        dedupe_enabled : Dedupe property to be applied to the list of volumes.
        """

        return self._client.perform_bulk_resource_action(
            self.resource_type,
            'bulk_set_dedupe',
            dedupe_enabled=dedupe_enabled,
            vol_ids=vol_ids,
            **kwargs
        )

    def bulk_set_online_and_offline(self, online, vol_ids, **kwargs):
        """Bring a list of volumes online or offline.

        # Parameters
        vol_ids : IDs of the volumes to set online or offline.
        online  : Desired state of the volumes. "true" for online, "false" for offline.
        """

        return self._client.perform_bulk_resource_action(
            self.resource_type,
            'bulk_set_online_and_offline',
            online=online,
            vol_ids=vol_ids,
            **kwargs
        )

    def online(self, id):
        """Bring volume online.

        # Parameters
        id : ID of the volume.
        """

        return self._client.update_resource(
            self.resource_type,
            id,
            online=True
        )

    def offline(self, id):
        """Take volume offline.

        # Parameters
        id : ID of the volume.
        """

        return self._client.update_resource(
            self.resource_type,
            id,
            online=False
        )

    def associate(self, id, volcoll):
        """Associate the volume to a volume_collection

        # Parameters
        id : ID of the volume.
        """

        return self._client.update_resource(
            self.resource_type,
            id,
            volcoll_id=volcoll.id if isinstance(volcoll, VolumeCollection) else volcoll
        )

    def dissociate(self, id):
        """Dissociate the volume from a volume collection

        # Parameters
        id : ID of the volume.
        """

        return self._client.update_resource(
            self.resource_type,
            id,
            volcoll_id=''
        )
