#
#   © Copyright 2020 Hewlett Packard Enterprise Development LP
#
#   This file was auto-generated by the Python SDK generator; DO NOT EDIT.
#


from ...resource import Resource, Collection
from ...exceptions import NimOSAPIOperationUnsupported


class UserPolicy(Resource):
    """Manages the password policies configured for the group.

    # Parameters
    id               : Identifier for the security policy.
    allowed_attempts : Number of authentication attempts allowed before the user account is locked. Allowed range is [1, 10] inclusive. '0' indicates no limit.
    min_length       : Minimum length for user passwords. Allowed range is [8, 255] inclusive.
    upper            : Number of uppercase characters required in user passwords. Allowed range is [0, 255] inclusive.
    lower            : Number of lowercase characters required in user passwords. Allowed range is [0, 255] inclusive.
    digit            : Number of numerical characters required in user passwords. Allowed range is [0, 255] inclusive.
    special          : Number of special characters required in user passwords. Allowed range is [0, 255] inclusive.
    previous_diff    : Number of characters that must be different from the previous password. Allowed range is [1, 255] inclusive.
    no_reuse         : Number of times that a password must change before you can reuse a previous password. Allowed range is [1,20] inclusive.
    max_sessions     : Maximum number of sessions allowed for a group. Allowed range is [10, 1000] inclusive. '0' indicates no limit.
    """

    def create(self, **kwargs):
        raise NimOSAPIOperationUnsupported("create operation not supported")

    def delete(self, **kwargs):
        raise NimOSAPIOperationUnsupported("delete operation not supported")


class UserPolicyList(Collection):
    resource = UserPolicy
    resource_type = "user_policies"

    def create(self, **kwargs):
        raise NimOSAPIOperationUnsupported("create operation not supported")

    def delete(self, **kwargs):
        raise NimOSAPIOperationUnsupported("delete operation not supported")
