#
#   © Copyright 2020 Hewlett Packard Enterprise Development LP
#
#   This file was auto-generated by the Python SDK generator; DO NOT EDIT.
#


from ...resource import Resource, Collection


class Snapshot(Resource):
    """Snapshots are point-in-time copies of a volume. Snapshots are managed the same way you manage volumes. In reality, snapshots are volumes: they can be accessed by initiators,
    are subject to the same controls, can be modified, and have the same restrictions as volumes. Snapshots can be cloned and replicated. The initial snapshot uses no space: it
    shares the original data with the source volume. Each successive snapshot captures the changes that have occurred on the volume. The changed blocks are compressed.

    # Parameters
    id                          : Identifier for the snapshot.
    name                        : Name of snapshot.
    description                 : Text description of snapshot.
    size                        : Size of volume at time of snapshot (in bytes).
    vol_name                    : Name of the parent volume in which the snapshot belongs to.
    pool_name                   : Name of the pool in which the parent volume belongs to.
    vol_id                      : Parent volume ID.
    snap_collection_name        : Name of snapshot collection.
    snap_collection_id          : Identifier of snapshot collection.
    online                      : Online state for a snapshot means it could be mounted for data restore.
    writable                    : Allow snapshot to be writable. Mandatory and must be set to 'true' for VSS application synchronized snapshots.
    offline_reason              : Snapshot offline reason - possible entries: one of 'user', 'recovery', 'replica', 'over_volume_limit', 'over_snapshot_limit',
                                  'over_volume_reserve', 'nvram_loss_recovery', 'pool_free_space_exhausted' .
    expiry_time                 : Unix timestamp indicating that the snapshot is considered expired by Snapshot Time-to-live(TTL). A value of 0 indicates that snapshot never
                                  expires.
    expiry_after                : Number of seconds after which this snapshot is considered expired by snapshot TTL. A value of 0 indicates that snapshot never expires, 1
                                  indicates that snapshot uses group-level configured TTL value and any other value indicates number of seconds.
    origin_name                 : Origination group name.
    is_replica                  : Snapshot is a replica from upstream replication partner.
    is_unmanaged                : Indicates whether the snapshot is unmanaged. The snapshot will not be deleted automatically unless the unmanaged cleanup feature is enabled.
    is_manually_managed         : Is snapshot manually managed, i.e., snapshot is manually or third party created or created by system at the time of volume restore or resize.
    replication_status          : Replication status.
    access_control_records      : List of access control records that apply to this snapshot.
    serial_number               : Identifier for the SCSI protocol.
    target_name                 : The iSCSI Qualified Name (IQN) or the Fibre Channel World Wide Node Name (WWNN) of the target snapshot.
    creation_time               : Time when this snapshot was created.
    last_modified               : Time when this snapshort was last modified.
    schedule_name               : Name of protection schedule.
    schedule_id                 : Identifier of protection schedule.
    app_uuid                    : Application identifier of snapshots.
    metadata                    : Key-value pairs that augment a snapshot's attributes.
    new_data_valid              : Indicate the usage infomation is valid.
    new_data_compressed_bytes   : The bytes of compressed new data.
    new_data_uncompressed_bytes : The bytes of uncompressed new data.
    agent_type                  : External management agent type.
    vpd_t10                     : The snapshot's T10 Vendor ID-based identifier.
    vpd_ieee0                   : The first 64 bits of the snapshots's EUI-64 identifier, encoded as a hexadecimal string.
    vpd_ieee1                   : The last 64 bits of the snapshots's EUI-64 identifier, encoded as a hexadecimal string.
    force                       : Forcibly delete the specified snapshot even if it is the last replicated collection. Doing so could lead to full re-seeding at the next
                                  replication.
    """
    def bulk_create(self, replicate, snap_vol_list, vss_snap, **kwargs):
        """Create snapshots on the given set of volumes.

        # Parameters
        snap_vol_list : List of volumes to snapshot and corresponding snapshot creation attributes. VSS application-synchronized snapshot must specify the 'writable' parameter and
                        set it to true.
        replicate     : Allow snapshot to be replicated.
        vss_snap      : VSS app-synchronized snapshot; we don't support creation of non app-synchronized sanpshots through this interface; must be set to true.
        """

        return self._collection.bulk_create(
            self,
            replicate,
            snap_vol_list,
            vss_snap,
            **kwargs
        )


class SnapshotList(Collection):
    resource = Snapshot
    resource_type = "snapshots"

    def bulk_create(self, replicate, snap_vol_list, vss_snap, **kwargs):
        """Create snapshots on the given set of volumes.

        # Parameters
        snap_vol_list : List of volumes to snapshot and corresponding snapshot creation attributes. VSS application-synchronized snapshot must specify the 'writable' parameter and
                        set it to true.
        replicate     : Allow snapshot to be replicated.
        vss_snap      : VSS app-synchronized snapshot; we don't support creation of non app-synchronized sanpshots through this interface; must be set to true.
        """

        return self._client.perform_bulk_resource_action(
            self.resource_type,
            'bulk_create',
            replicate=replicate,
            snap_vol_list=snap_vol_list,
            vss_snap=vss_snap,
            **kwargs
        )
