#
#   © Copyright 2020 Hewlett Packard Enterprise Development LP
#
#   This file was auto-generated by the Python SDK generator; DO NOT EDIT.
#


from ...resource import Resource, Collection


class InitiatorGroup(Resource):
    """Manage initiator groups for initiator authentication. An initiator group is a set of initiators that can be configured as part of your ACL to access a specific volume through
    group membership.

    # Parameters
    id               : Identifier for initiator group.
    name             : Name of initiator group.
    full_name        : Initiator group's full name.
    search_name      : Initiator group name used for search.
    description      : Text description of initiator group.
    access_protocol  : Initiator group access protocol.
    host_type        : Initiator group host type. Available options are auto and hpux. The default option is auto. This attribute will be applied to all the initiators in the
                       initiator group. Initiators with different host OSes should not be kept in the same initiator group having a non-default host type attribute.
    fc_tdz_ports     : List of target Fibre Channel ports with Target Driven Zoning configured on this initiator group.
    target_subnets   : List of target subnet labels. If specified, discovery and access to volumes will be restricted to the specified subnets.
    iscsi_initiators : List of iSCSI initiators. When create/update iscsi_initiators, either iqn or ip_address is always required with label.
    fc_initiators    : List of FC initiators. When create/update fc_initiators, wwpn is required.
    creation_time    : Time when this initiator group was created.
    last_modified    : Time when this initiator group was last modified.
    vp_override      : Flag to allow modifying VP created initiator groups. When set to true, user can add this initiator to a VP created initiator group.
    app_uuid         : Application identifier of initiator group.
    volume_count     : Number of volumes that are accessible by the initiator group.
    volume_list      : List of volumes that are accessible by the initiator group.
    num_connections  : Total number of connections from initiators in the initiator group.
    metadata         : Key-value pairs that augment an initiator group's attributes.
    """
    def suggest_lun(self, **kwargs):
        """Suggest an LU number for the volume and initiator group combination.

        # Parameters
        id     : ID of the initiator group.
        vol_id : ID of the volume.
        """

        return self._collection.suggest_lun(
            self.id,
            **kwargs
        )
    def validate_lun(self, lun, **kwargs):
        """Validate an LU number for the volume and initiator group combination.

        # Parameters
        id     : ID of the initiator group.
        vol_id : ID of the volume.
        lun    : LU number to validate in decimal.
        """

        return self._collection.validate_lun(
            self.id,
            lun,
            **kwargs
        )


class InitiatorGroupList(Collection):
    resource = InitiatorGroup
    resource_type = "initiator_groups"

    def suggest_lun(self, id, **kwargs):
        """Suggest an LU number for the volume and initiator group combination.

        # Parameters
        id     : ID of the initiator group.
        vol_id : ID of the volume.
        """

        return self._client.perform_resource_action(
            self.resource_type,
            id,
            'suggest_lun',
            id=id,
            **kwargs
        )

    def validate_lun(self, id, lun, **kwargs):
        """Validate an LU number for the volume and initiator group combination.

        # Parameters
        id     : ID of the initiator group.
        vol_id : ID of the volume.
        lun    : LU number to validate in decimal.
        """

        return self._client.perform_resource_action(
            self.resource_type,
            id,
            'validate_lun',
            id=id,
            lun=lun,
            **kwargs
        )
