#
#   © Copyright 2020 Hewlett Packard Enterprise Development LP
#
#   This file was auto-generated by the Python SDK generator; DO NOT EDIT.
#


from ...resource import Resource, Collection
from ...exceptions import NimOSAPIOperationUnsupported


class Controller(Resource):
    """Controller is a redundant collection of hardware capable of running the array software.

    # Parameters
    id                  : Identifier of the controller.
    name                : Name of the controller.
    array_name          : Name of the array containing this controller.
    array_id            : Rest ID of the array containing this controller.
    partial_response_ok : Indicate that it is ok to provide partially available response.
    serial              : Serial number for this controller.
    model               : Model of this controller.
    hostname            : Host name for the controller.
    support_address     : IP address used for support.
    support_netmask     : IP netmask used for support.
    support_nic         : Network card used for support.
    power_status        : Overall power supply status for the controller.
    fan_status          : Overall fan status for the controller.
    temperature_status  : Overall temperature status for the controller.
    power_supplies      : Status for each power supply in the controller.
    fans                : Status for each fan in the controller.
    temperature_sensors : Status for temperature sensor in the controller.
    partition_status    : Status of the system's raid partitions.
    ctrlr_side          : Identifies which controller this is on its array.
    state               : Indicates whether this controller is active or not.
    nvme_cards_enabled  : Indicates if the NVMe accelerator card is enabled.
    nvme_cards          : List of NVMe accelerator cards.
    asup_time           : Time of the last autosupport by the controller.
    """

    def create(self, **kwargs):
        raise NimOSAPIOperationUnsupported("create operation not supported")

    def delete(self, **kwargs):
        raise NimOSAPIOperationUnsupported("delete operation not supported")

    def update(self, **kwargs):
        raise NimOSAPIOperationUnsupported("update operation not supported")


class ControllerList(Collection):
    resource = Controller
    resource_type = "controllers"

    def create(self, **kwargs):
        raise NimOSAPIOperationUnsupported("create operation not supported")

    def delete(self, **kwargs):
        raise NimOSAPIOperationUnsupported("delete operation not supported")

    def update(self, **kwargs):
        raise NimOSAPIOperationUnsupported("update operation not supported")
