#
#   © Copyright 2020 Hewlett Packard Enterprise Development LP
#
#   This file was auto-generated by the Python SDK generator; DO NOT EDIT.
#


from ...resource import Resource, Collection
from ...exceptions import NimOSAPIOperationUnsupported


class Alarm(Resource):
    """View alarms.

    # Parameters
    id                     : Identifier for the alarm.
    type                   : Identifier for type of alarm.
    array                  : The array name where the alarm is generated.
    curr_onset_event_id    : Identifier for the current onset event.
    object_id              : Identifier of object operated upon.
    object_name            : Name of object operated upon.
    object_type            : Type of the object being operated upon.
    onset_time             : Time when this alarm was triggered.
    ack_time               : Time when this alarm was acknowledged.
    status                 : Status of the operation -- open or acknowledged.
    user_id                : Identifier of the user who acknowledged the alarm.
    user_name              : Username of the user who acknowledged the alarm.
    user_full_name         : Full name of the user who acknowledged the alarm.
    category               : Category of the alarm.
    severity               : Severity level of the event.
    remind_every           : Frequency of notification. This number and the remind_every_unit define how frequent one alarm notification is sent. For example, a value of 1 with
                             the 'remind_every_unit' of 'days' results in one notification every day.
    remind_every_unit      : Time unit over which to send the number of notification specified in 'remind_every'. For example, a value of 'days' with a 'remind_every' of '1'
                             results in one notification every day.
    activity               : Description of activity performed and recorded in alarm.
    next_notification_time : Time when next reminder for the alarm will be sent.
    """
    def acknowledge(self, **kwargs):
        """Acknowledge an alarm.

        # Parameters
        id                : ID of the acknowledged alarm.
        remind_every      : Notification frequency unit.
        remind_every_unit : Period unit.
        """

        return self._collection.acknowledge(
            self.id,
            **kwargs
        )
    def unacknowledge(self, **kwargs):
        """Unacknowledge an alarm.

        # Parameters
        id : ID of the acknowledged alarm.
        """

        return self._collection.unacknowledge(
            self.id,
            **kwargs
        )

    def create(self, **kwargs):
        raise NimOSAPIOperationUnsupported("create operation not supported")


class AlarmList(Collection):
    resource = Alarm
    resource_type = "alarms"

    def acknowledge(self, id, **kwargs):
        """Acknowledge an alarm.

        # Parameters
        id                : ID of the acknowledged alarm.
        remind_every      : Notification frequency unit.
        remind_every_unit : Period unit.
        """

        return self._client.perform_resource_action(
            self.resource_type,
            id,
            'acknowledge',
            id=id,
            **kwargs
        )

    def unacknowledge(self, id, **kwargs):
        """Unacknowledge an alarm.

        # Parameters
        id : ID of the acknowledged alarm.
        """

        return self._client.perform_resource_action(
            self.resource_type,
            id,
            'unacknowledge',
            id=id,
            **kwargs
        )

    def create(self, **kwargs):
        raise NimOSAPIOperationUnsupported("create operation not supported")
