# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request as APIRequest, Response as APIResponse, set_timeout, set_tenant_key, set_user_access_token, set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.mailgroup_members = MailgroupMemberService(self)
        self.mailgroup_permission_members = MailgroupPermissionMemberService(self)
        self.public_mailboxs = PublicMailboxService(self)
        self.public_mailbox_members = PublicMailboxMemberService(self)
        self.mailgroups = MailgroupService(self)
        



class MailgroupMemberService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def list(self, tenant_key=None, timeout=None):
        # type: (str, int) -> MailgroupMemberListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return MailgroupMemberListReqCall(self, request_opts=request_opts)

    def get(self, tenant_key=None, timeout=None):
        # type: (str, int) -> MailgroupMemberGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return MailgroupMemberGetReqCall(self, request_opts=request_opts)

    def create(self, body, tenant_key=None, timeout=None):
        # type: (MailgroupMember, str, int) -> MailgroupMemberCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return MailgroupMemberCreateReqCall(self, body, request_opts=request_opts)

    def delete(self, tenant_key=None, timeout=None):
        # type: (str, int) -> MailgroupMemberDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return MailgroupMemberDeleteReqCall(self, request_opts=request_opts)


class MailgroupPermissionMemberService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def delete(self, tenant_key=None, timeout=None):
        # type: (str, int) -> MailgroupPermissionMemberDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return MailgroupPermissionMemberDeleteReqCall(self, request_opts=request_opts)

    def get(self, tenant_key=None, timeout=None):
        # type: (str, int) -> MailgroupPermissionMemberGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return MailgroupPermissionMemberGetReqCall(self, request_opts=request_opts)

    def list(self, tenant_key=None, timeout=None):
        # type: (str, int) -> MailgroupPermissionMemberListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return MailgroupPermissionMemberListReqCall(self, request_opts=request_opts)

    def create(self, body, tenant_key=None, timeout=None):
        # type: (MailgroupPermissionMember, str, int) -> MailgroupPermissionMemberCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return MailgroupPermissionMemberCreateReqCall(self, body, request_opts=request_opts)


class PublicMailboxService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def update(self, body, tenant_key=None, timeout=None):
        # type: (PublicMailbox, str, int) -> PublicMailboxUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return PublicMailboxUpdateReqCall(self, body, request_opts=request_opts)

    def list(self, tenant_key=None, timeout=None):
        # type: (str, int) -> PublicMailboxListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return PublicMailboxListReqCall(self, request_opts=request_opts)

    def create(self, body, tenant_key=None, timeout=None):
        # type: (PublicMailbox, str, int) -> PublicMailboxCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return PublicMailboxCreateReqCall(self, body, request_opts=request_opts)

    def get(self, tenant_key=None, timeout=None):
        # type: (str, int) -> PublicMailboxGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return PublicMailboxGetReqCall(self, request_opts=request_opts)

    def patch(self, body, tenant_key=None, timeout=None):
        # type: (PublicMailbox, str, int) -> PublicMailboxPatchReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return PublicMailboxPatchReqCall(self, body, request_opts=request_opts)


class PublicMailboxMemberService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def get(self, tenant_key=None, timeout=None):
        # type: (str, int) -> PublicMailboxMemberGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return PublicMailboxMemberGetReqCall(self, request_opts=request_opts)

    def delete(self, tenant_key=None, timeout=None):
        # type: (str, int) -> PublicMailboxMemberDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return PublicMailboxMemberDeleteReqCall(self, request_opts=request_opts)

    def clear(self, tenant_key=None, timeout=None):
        # type: (str, int) -> PublicMailboxMemberClearReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return PublicMailboxMemberClearReqCall(self, request_opts=request_opts)

    def list(self, tenant_key=None, timeout=None):
        # type: (str, int) -> PublicMailboxMemberListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return PublicMailboxMemberListReqCall(self, request_opts=request_opts)

    def create(self, body, tenant_key=None, timeout=None):
        # type: (PublicMailboxMember, str, int) -> PublicMailboxMemberCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return PublicMailboxMemberCreateReqCall(self, body, request_opts=request_opts)


class MailgroupService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def get(self, tenant_key=None, timeout=None):
        # type: (str, int) -> MailgroupGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return MailgroupGetReqCall(self, request_opts=request_opts)

    def update(self, body, tenant_key=None, timeout=None):
        # type: (Mailgroup, str, int) -> MailgroupUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return MailgroupUpdateReqCall(self, body, request_opts=request_opts)

    def delete(self, tenant_key=None, timeout=None):
        # type: (str, int) -> MailgroupDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return MailgroupDeleteReqCall(self, request_opts=request_opts)

    def create(self, body, tenant_key=None, timeout=None):
        # type: (Mailgroup, str, int) -> MailgroupCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return MailgroupCreateReqCall(self, body, request_opts=request_opts)

    def list(self, tenant_key=None, timeout=None):
        # type: (str, int) -> MailgroupListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return MailgroupListReqCall(self, request_opts=request_opts)

    def patch(self, body, tenant_key=None, timeout=None):
        # type: (Mailgroup, str, int) -> MailgroupPatchReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return MailgroupPatchReqCall(self, body, request_opts=request_opts)



class MailgroupGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MailgroupService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_mailgroup_id(self, mailgroup_id):
        # type: (str) -> MailgroupGetReqCall
        self.path_params['mailgroup_id'] = mailgroup_id
        return self

    def do(self):
        # type: () -> APIResponse[Type[Mailgroup]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/mail/v1/mailgroups/:mailgroup_id', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=Mailgroup, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MailgroupUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MailgroupService, Mailgroup, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_mailgroup_id(self, mailgroup_id):
        # type: (str) -> MailgroupUpdateReqCall
        self.path_params['mailgroup_id'] = mailgroup_id
        return self

    def do(self):
        # type: () -> APIResponse[Type[Mailgroup]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/mail/v1/mailgroups/:mailgroup_id', 'PUT', [ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=Mailgroup, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MailgroupDeleteReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MailgroupService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_mailgroup_id(self, mailgroup_id):
        # type: (str) -> MailgroupDeleteReqCall
        self.path_params['mailgroup_id'] = mailgroup_id
        return self

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/mail/v1/mailgroups/:mailgroup_id', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT],
                        None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MailgroupCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MailgroupService, Mailgroup, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[Mailgroup]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/mail/v1/mailgroups', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=Mailgroup, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MailgroupListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MailgroupService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_page_token(self, page_token):
        # type: (str) -> MailgroupListReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> MailgroupListReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> APIResponse[Type[MailgroupListResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/mail/v1/mailgroups', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=MailgroupListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MailgroupPatchReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MailgroupService, Mailgroup, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_mailgroup_id(self, mailgroup_id):
        # type: (str) -> MailgroupPatchReqCall
        self.path_params['mailgroup_id'] = mailgroup_id
        return self

    def do(self):
        # type: () -> APIResponse[Type[Mailgroup]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/mail/v1/mailgroups/:mailgroup_id', 'PATCH', [ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=Mailgroup, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MailgroupMemberListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MailgroupMemberService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_mailgroup_id(self, mailgroup_id):
        # type: (str) -> MailgroupMemberListReqCall
        self.path_params['mailgroup_id'] = mailgroup_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> MailgroupMemberListReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> MailgroupMemberListReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def set_page_token(self, page_token):
        # type: (str) -> MailgroupMemberListReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> MailgroupMemberListReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> APIResponse[Type[MailgroupMemberListResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/mail/v1/mailgroups/:mailgroup_id/members', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=MailgroupMemberListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MailgroupMemberGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MailgroupMemberService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_mailgroup_id(self, mailgroup_id):
        # type: (str) -> MailgroupMemberGetReqCall
        self.path_params['mailgroup_id'] = mailgroup_id
        return self

    def set_member_id(self, member_id):
        # type: (str) -> MailgroupMemberGetReqCall
        self.path_params['member_id'] = member_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> MailgroupMemberGetReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> MailgroupMemberGetReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def do(self):
        # type: () -> APIResponse[Type[MailgroupMember]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/mail/v1/mailgroups/:mailgroup_id/members/:member_id', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=MailgroupMember, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MailgroupMemberCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MailgroupMemberService, MailgroupMember, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_mailgroup_id(self, mailgroup_id):
        # type: (str) -> MailgroupMemberCreateReqCall
        self.path_params['mailgroup_id'] = mailgroup_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> MailgroupMemberCreateReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> MailgroupMemberCreateReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def do(self):
        # type: () -> APIResponse[Type[MailgroupMember]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/mail/v1/mailgroups/:mailgroup_id/members', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=MailgroupMember, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MailgroupMemberDeleteReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MailgroupMemberService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_mailgroup_id(self, mailgroup_id):
        # type: (str) -> MailgroupMemberDeleteReqCall
        self.path_params['mailgroup_id'] = mailgroup_id
        return self

    def set_member_id(self, member_id):
        # type: (str) -> MailgroupMemberDeleteReqCall
        self.path_params['member_id'] = member_id
        return self

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/mail/v1/mailgroups/:mailgroup_id/members/:member_id', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT],
                        None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MailgroupPermissionMemberDeleteReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MailgroupPermissionMemberService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_mailgroup_id(self, mailgroup_id):
        # type: (str) -> MailgroupPermissionMemberDeleteReqCall
        self.path_params['mailgroup_id'] = mailgroup_id
        return self

    def set_permission_member_id(self, permission_member_id):
        # type: (str) -> MailgroupPermissionMemberDeleteReqCall
        self.path_params['permission_member_id'] = permission_member_id
        return self

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/mail/v1/mailgroups/:mailgroup_id/permission_members/:permission_member_id', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT],
                        None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MailgroupPermissionMemberGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MailgroupPermissionMemberService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_mailgroup_id(self, mailgroup_id):
        # type: (str) -> MailgroupPermissionMemberGetReqCall
        self.path_params['mailgroup_id'] = mailgroup_id
        return self

    def set_permission_member_id(self, permission_member_id):
        # type: (str) -> MailgroupPermissionMemberGetReqCall
        self.path_params['permission_member_id'] = permission_member_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> MailgroupPermissionMemberGetReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> MailgroupPermissionMemberGetReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def do(self):
        # type: () -> APIResponse[Type[MailgroupPermissionMember]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/mail/v1/mailgroups/:mailgroup_id/permission_members/:permission_member_id', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=MailgroupPermissionMember, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MailgroupPermissionMemberListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MailgroupPermissionMemberService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_mailgroup_id(self, mailgroup_id):
        # type: (str) -> MailgroupPermissionMemberListReqCall
        self.path_params['mailgroup_id'] = mailgroup_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> MailgroupPermissionMemberListReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> MailgroupPermissionMemberListReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def set_page_token(self, page_token):
        # type: (str) -> MailgroupPermissionMemberListReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> MailgroupPermissionMemberListReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> APIResponse[Type[MailgroupPermissionMemberListResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/mail/v1/mailgroups/:mailgroup_id/permission_members', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=MailgroupPermissionMemberListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MailgroupPermissionMemberCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MailgroupPermissionMemberService, MailgroupPermissionMember, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_mailgroup_id(self, mailgroup_id):
        # type: (str) -> MailgroupPermissionMemberCreateReqCall
        self.path_params['mailgroup_id'] = mailgroup_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> MailgroupPermissionMemberCreateReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> MailgroupPermissionMemberCreateReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def do(self):
        # type: () -> APIResponse[Type[MailgroupPermissionMember]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/mail/v1/mailgroups/:mailgroup_id/permission_members', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=MailgroupPermissionMember, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class PublicMailboxUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (PublicMailboxService, PublicMailbox, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_public_mailbox_id(self, public_mailbox_id):
        # type: (str) -> PublicMailboxUpdateReqCall
        self.path_params['public_mailbox_id'] = public_mailbox_id
        return self

    def do(self):
        # type: () -> APIResponse[Type[PublicMailbox]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/mail/v1/public_mailboxes/:public_mailbox_id', 'PUT', [ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=PublicMailbox, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class PublicMailboxListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (PublicMailboxService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_page_token(self, page_token):
        # type: (str) -> PublicMailboxListReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> PublicMailboxListReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> APIResponse[Type[PublicMailboxListResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/mail/v1/public_mailboxes', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=PublicMailboxListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class PublicMailboxCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (PublicMailboxService, PublicMailbox, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[PublicMailbox]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/mail/v1/public_mailboxes', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=PublicMailbox, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class PublicMailboxGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (PublicMailboxService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_public_mailbox_id(self, public_mailbox_id):
        # type: (str) -> PublicMailboxGetReqCall
        self.path_params['public_mailbox_id'] = public_mailbox_id
        return self

    def do(self):
        # type: () -> APIResponse[Type[PublicMailbox]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/mail/v1/public_mailboxes/:public_mailbox_id', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=PublicMailbox, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class PublicMailboxPatchReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (PublicMailboxService, PublicMailbox, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_public_mailbox_id(self, public_mailbox_id):
        # type: (str) -> PublicMailboxPatchReqCall
        self.path_params['public_mailbox_id'] = public_mailbox_id
        return self

    def do(self):
        # type: () -> APIResponse[Type[PublicMailbox]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/mail/v1/public_mailboxes/:public_mailbox_id', 'PATCH', [ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=PublicMailbox, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class PublicMailboxMemberGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (PublicMailboxMemberService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_public_mailbox_id(self, public_mailbox_id):
        # type: (str) -> PublicMailboxMemberGetReqCall
        self.path_params['public_mailbox_id'] = public_mailbox_id
        return self

    def set_member_id(self, member_id):
        # type: (str) -> PublicMailboxMemberGetReqCall
        self.path_params['member_id'] = member_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> PublicMailboxMemberGetReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def do(self):
        # type: () -> APIResponse[Type[PublicMailboxMember]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/mail/v1/public_mailboxes/:public_mailbox_id/members/:member_id', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=PublicMailboxMember, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class PublicMailboxMemberDeleteReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (PublicMailboxMemberService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_public_mailbox_id(self, public_mailbox_id):
        # type: (str) -> PublicMailboxMemberDeleteReqCall
        self.path_params['public_mailbox_id'] = public_mailbox_id
        return self

    def set_member_id(self, member_id):
        # type: (str) -> PublicMailboxMemberDeleteReqCall
        self.path_params['member_id'] = member_id
        return self

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/mail/v1/public_mailboxes/:public_mailbox_id/members/:member_id', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT],
                        None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class PublicMailboxMemberClearReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (PublicMailboxMemberService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_public_mailbox_id(self, public_mailbox_id):
        # type: (str) -> PublicMailboxMemberClearReqCall
        self.path_params['public_mailbox_id'] = public_mailbox_id
        return self

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/mail/v1/public_mailboxes/:public_mailbox_id/members/clear', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                        None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class PublicMailboxMemberListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (PublicMailboxMemberService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_public_mailbox_id(self, public_mailbox_id):
        # type: (str) -> PublicMailboxMemberListReqCall
        self.path_params['public_mailbox_id'] = public_mailbox_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> PublicMailboxMemberListReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_page_token(self, page_token):
        # type: (str) -> PublicMailboxMemberListReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> PublicMailboxMemberListReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> APIResponse[Type[PublicMailboxMemberListResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/mail/v1/public_mailboxes/:public_mailbox_id/members', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=PublicMailboxMemberListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class PublicMailboxMemberCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (PublicMailboxMemberService, PublicMailboxMember, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_public_mailbox_id(self, public_mailbox_id):
        # type: (str) -> PublicMailboxMemberCreateReqCall
        self.path_params['public_mailbox_id'] = public_mailbox_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> PublicMailboxMemberCreateReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def do(self):
        # type: () -> APIResponse[Type[PublicMailboxMember]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/mail/v1/public_mailboxes/:public_mailbox_id/members', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=PublicMailboxMember, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp

