# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request as APIRequest, Response as APIResponse, set_timeout, set_tenant_key, set_user_access_token, set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.members = MemberService(self)
        self.publics = PublicService(self)
        



class MemberService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def create(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (MemberCreateReqBody, str, str, int) -> MemberCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MemberCreateReqCall(self, body, request_opts=request_opts)

    def delete(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (MemberDeleteReqBody, str, str, int) -> MemberDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MemberDeleteReqCall(self, body, request_opts=request_opts)

    def list(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (MemberListReqBody, str, str, int) -> MemberListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MemberListReqCall(self, body, request_opts=request_opts)

    def permitted(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (MemberPermittedReqBody, str, str, int) -> MemberPermittedReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MemberPermittedReqCall(self, body, request_opts=request_opts)

    def transfer(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (MemberTransferReqBody, str, str, int) -> MemberTransferReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MemberTransferReqCall(self, body, request_opts=request_opts)

    def update(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (MemberUpdateReqBody, str, str, int) -> MemberUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MemberUpdateReqCall(self, body, request_opts=request_opts)


class PublicService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def update(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (PublicUpdateReqBody, str, str, int) -> PublicUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return PublicUpdateReqCall(self, body, request_opts=request_opts)



class MemberCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MemberService, MemberCreateReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[MemberCreateResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/drive/permission/member/create', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=MemberCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MemberDeleteReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MemberService, MemberDeleteReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[MemberDeleteResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/drive/permission/member/delete', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=MemberDeleteResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MemberListReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MemberService, MemberListReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[MemberListResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/drive/permission/member/list', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=MemberListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MemberPermittedReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MemberService, MemberPermittedReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[MemberPermittedResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/drive/permission/member/permitted', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=MemberPermittedResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MemberTransferReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MemberService, MemberTransferReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[MemberTransferResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/drive/permission/member/transfer', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=MemberTransferResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MemberUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MemberService, MemberUpdateReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[MemberUpdateResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/drive/permission/member/update', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=MemberUpdateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class PublicUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (PublicService, PublicUpdateReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[PublicUpdateResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/drive/permission/public/update', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=PublicUpdateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp

