# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['imageedit']

package_data = \
{'': ['*'], 'imageedit': ['resources/*']}

install_requires = \
['Pillow>=9.1.0,<10',
 'blendmodes>=2022,<2024',
 'colourswatch>=2022.0.1,<2024',
 'layeredimage>=2022.0.1,<2024',
 'svgtrace>=2022,<2024']

setup_kwargs = {
    'name': 'imageedit',
    'version': '2022.0.1',
    'description': 'Create various icon masks and shading effects with the imageedit library',
    'long_description': '[![GitHub top language](https://img.shields.io/github/languages/top/FHPythonUtils/ImageEdit.svg?style=for-the-badge)](../../)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/ImageEdit.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/ImageEdit.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/ImageEdit.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/ImageEdit.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/ImageEdit.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/imageedit.svg?style=for-the-badge)](https://pypistats.org/packages/imageedit)\n[![PyPI Total Downloads](https://img.shields.io/badge/dynamic/json?style=for-the-badge&label=total%20downloads&query=%24.total_downloads&url=https%3A%2F%2Fapi.pepy.tech%2Fapi%2Fprojects%2Fimageedit)](https://pepy.tech/project/imageedit)\n[![PyPI Version](https://img.shields.io/pypi/v/imageedit.svg?style=for-the-badge)](https://pypi.org/project/imageedit)\n\n<!-- omit in toc -->\n# ImageEdit\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\n[**Now available on pypi.org!**](https://pypi.org/project/imageedit/)\n\nCreate various icon masks and shading effects with the imageedit library.\nSix example files under main: round.py, makeProjIcons.py, makePWAImages.py,\nmakeRetro.py, getPWAScreenshots.py and readWriteLayered.py.\n\nLeverages the following libraries to do the heavy lifting:\n\n```none\nPillow\nblendmodes\ncolourswatch\nlayeredimage\nmetprint\nsvgtrace\n```\n\nHave a look under test/test_read_write_layered for an example of converting an\nxcf to ora and png. Unfortunately, visibility of xcf is currently ignored :(\n\n- [Example Files](#example-files)\n- [Comparison to similar solutions](#comparison-to-similar-solutions)\n\t- [GUI](#gui)\n\t- [Web](#web)\n\t- [Advantages of this solution](#advantages-of-this-solution)\n\t- [Disadvantages of this solution](#disadvantages-of-this-solution)\n- [How to use out of the box](#how-to-use-out-of-the-box)\n\t- [get_pwa_screenshots.py](#get_pwa_screenshotspy)\n\t- [make_phone_screenshots.py](#make_phone_screenshotspy)\n\t- [make_proj_icons.py](#make_proj_iconspy)\n\t- [make_pwa_images.py](#make_pwa_imagespy)\n\t- [make_retro.py](#make_retropy)\n\t- [read_write_layered.py](#read_write_layeredpy)\n\t- [round.py](#roundpy)\n- [Documentation](#documentation)\n- [Install With PIP](#install-with-pip)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Windows - Python.org](#windows---pythonorg)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n\t- [Dnf](#dnf)\n- [Install Python on MacOS](#install-python-on-macos)\n\t- [Homebrew](#homebrew)\n\t- [MacOS - Python.org](#macos---pythonorg)\n- [How to run](#how-to-run)\n\t- [Windows](#windows)\n\t- [Linux/ MacOS](#linux-macos)\n- [Download Project](#download-project)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n\t- [Support](#support)\n\t- [Rationale](#rationale)\n\nSee the documentation for each library for more information on things you\ncan use it for.\n\n## Example Files\n\n- get_pwa_screenshots.py\n- make_phone_screenshots.py\n- make_poj_icons.py\n- make_pwa_images.py\n- make_retro.py\n- read_write_layered.py\n- round.py\n\n## Comparison to similar solutions\n\nSimilar solutions include but are not limited to:\n\n### GUI\n\nhttps://www.getpaint.net/\n\n### Web\n\nhttps://realfavicongenerator.net/\n\n### Advantages of this solution\n\n- Lightweight: few dependencies required (python, pillow, blendmodes,\nlayeredimage, and svgtrace)\n- Quick: when given a regular or mask image it can produce many\nvariants in a relatively short amount of time\n- Customizable: write your own scripts to leverage imageEdit (python knowledge\nrequired)\n- Produce a PWA mask icon out of the box\n- SVG tracing lib doesn\'t require potrace/ pypotrace which can be challenging to\nset up on Windows\n- SVG tracing using imageTracerJs.py (https://github.com/jankovicsandras/imagetracerjs)\nis pretty good (requires pyppeteer: https://github.com/miyakogi/pyppeteer)\n\n### Disadvantages of this solution\n\n- Specific image dimensions needed out of the box: whilst this is something that\ncould be changed, maskable icons are 640x640 and regular icons are 512x512\n\n## How to use out of the box\n\n### get_pwa_screenshots.py\n\n### make_phone_screenshots.py\n\n### make_proj_icons.py\n\n### make_pwa_images.py\n\n1. Put regular 512x512 image or mask 640x640 image under main/input in this\nexample I am using lightfox.png\n\n\t<img src="readme-assets/examples/lightfox.png" alt="LightFox" width="128">\n\n2. Run ```make_pwa_images.py``` and navigate to main/output/lightfox.png/pwa\n\n\t<div>\n\t<img src="readme-assets/examples/mask.png" alt="LightFox" width="128">\n\t<img src="readme-assets/examples/round-192.png" alt="LightFox" width="38">\n\t<img src="readme-assets/examples/round-512.png" alt="LightFox" width="102">\n\t<img src="readme-assets/examples/square-180.png" alt="LightFox" width="36">\n\t<img src="readme-assets/examples/squircle-256.png" alt="LightFox" width="52">\n\t</div>\n\n### make_retro.py\n\n1. Put regular 512x512 image or mask 640x640 image under main/input. In this\n   example I am using BlendModes.png\n\n\t<img src="readme-assets/examples/blendmodes.png" alt="BlendModes" width="128">\n\n2. Run ```make_retro.py``` and navigate to main/output/blendmodes.png/retro\n\tPersonal Computers\n\n\t<div>\n\t<img src="readme-assets/examples/3level.png" alt="BlendModes" width="128">\n\t<img src="readme-assets/examples/bbc-micro.png" alt="BlendModes" width="128">\n\t<img src="readme-assets/examples/zxspectrum.png" alt="BlendModes" width="128">\n\t<img src="readme-assets/examples/websafe.png" alt="BlendModes" width="128">\n\t</div>\n\n\tMobile Operating Systems\n\n\tiOS\n\n\t<div>\n\t<img src="readme-assets/examples/ios1.png" alt="BlendModes" width="128">\n\t<img src="readme-assets/examples/ios7.png" alt="BlendModes" width="128">\n\t</div>\n\n\tAndroid\n\n\t<div>\n\t<img src="readme-assets/examples/android2.png" alt="BlendModes" width="128">\n\t<img src="readme-assets/examples/android6.png" alt="BlendModes" width="128">\n\t<img src="readme-assets/examples/android7.png" alt="BlendModes" width="128">\n\t<img src="readme-assets/examples/android8.png" alt="BlendModes" width="128">\n\t</div>\n\n### read_write_layered.py\n\n### round.py\n\n## Documentation\n\nA high-level overview of how the documentation is organized organized will help you know\nwhere to look for certain things:\n\n<!--\n- [Tutorials](/documentation/tutorials) take you by the hand through a series of steps to get\n  started using the software. Start here if you’re new.\n-->\n- The [Technical Reference](/documentation/reference) documents APIs and other aspects of the\n  machinery. This documentation describes how to use the classes and functions at a lower level\n  and assume that you have a good high-level understanding of the software.\n<!--\n- The [Help](/documentation/help) guide provides a starting point and outlines common issues that you\n  may have.\n-->\n\n## Install With PIP\n\n```python\npip install imageedit\n```\n\nHead to https://pypi.org/project/imageedit/ for more info\n\n## Language information\n\n### Built for\n\nThis program has been written for Python versions 3.7 - 3.10 and has been tested with both 3.7 and\n3.10\n\n## Install Python on Windows\n\n### Chocolatey\n\n```powershell\nchoco install python\n```\n\n### Windows - Python.org\n\nTo install Python, go to https://www.python.org/downloads/windows/ and download the latest\nversion.\n\n## Install Python on Linux\n\n### Apt\n\n```bash\nsudo apt install python3.x\n```\n\n### Dnf\n\n```bash\nsudo dnf install python3.x\n```\n\n## Install Python on MacOS\n\n### Homebrew\n\n```bash\nbrew install python@3.x\n```\n\n### MacOS - Python.org\n\nTo install Python, go to https://www.python.org/downloads/macos/ and download the latest\nversion.\n\n## How to run\n\n### Windows\n\n- Module\n\t`py -3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`py -3.x [file]` or `./[file]`\n\n### Linux/ MacOS\n\n- Module\n\t`python3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`python3.x [file]` or `./[file]`\n\n## Download Project\n\n### Clone\n\n#### Using The Command Line\n\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to clone to\n4. Type \'git clone\' followed by URL in step 2\n\t```bash\n\tgit clone https://github.com/FHPythonUtils/ImageEdit\n\t```\n\nMore information can be found at\nhttps://help.github.com/en/articles/cloning-a-repository\n\n#### Using GitHub Desktop\n\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\nhttps://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Community Files\n\n### Licence\n\nMIT License\nCopyright (c) FredHappyface\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\n\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\n\nOnline communities include people from many backgrounds. The *Project*\ncontributors are committed to providing a friendly, safe and welcoming\nenvironment for all. Please see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md)\n for more information.\n\n### Contributing\n\nContributions are welcome, please see the\n[Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md)\nfor more information.\n\n### Security\n\nThank you for improving the security of the project, please see the\n[Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md)\nfor more information.\n\n### Support\n\nThank you for using this project, I hope it is of use to you. Please be aware that\nthose involved with the project often do so for fun along with other commitments\n(such as work, family, etc). Please see the\n[Support Policy](https://github.com/FHPythonUtils/.github/blob/master/SUPPORT.md)\nfor more information.\n\n### Rationale\n\nThe rationale acts as a guide to various processes regarding projects such as\nthe versioning scheme and the programming styles used. Please see the\n[Rationale](https://github.com/FHPythonUtils/.github/blob/master/RATIONALE.md)\nfor more information.\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FredHappyface/Python.ImageEdit',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
