# AUTOGENERATED! DO NOT EDIT! File to edit: 01_dashboard_one.ipynb (unless otherwise specified).

__all__ = ['RED', 'BLUE', 'GREEN', 'BOLD', 'ITALIC', 'RESET', 'dashboard_one']

# Cell
RED = '\033[31m'
BLUE = '\033[94m'
GREEN = '\033[92m'
BOLD   = '\033[1m'
ITALIC = '\033[3m'
RESET  = '\033[0m'

import ipywidgets as widgets
import torchvision; import torch

from IPython.display import display,clear_output, Javascript
import webbrowser

# Cell
def dashboard_one():
    """GUI for Info tab"""
    try:
        import fastai2; fastver = fastai2.__version__
    except ImportError:
        fastver = 'fastai not found'
    try:
        import fastprogress; fastprog = fastprogress.__version__
    except ImportError:
        fastprog = 'fastprogress not found'
    try:
        import fastpages; fastp = fastpages.__version__
    except ImportError:
        fastp = 'fastpages not found'
    try:
        import nbdev; nbd = nbdev.__version__
    except ImportError:
        nbd = 'nbdev not found'

    print (BOLD +  RED + '>> Vision_UI Update: 05/30/2020')
    style = {'description_width': 'initial'}

    button = widgets.Button(description='System', button_style='success')
    ex_button = widgets.Button(description='Explore', button_style='success')
    display(button)

    out = widgets.Output()
    display(out)

    def on_button_clicked_info(b):
        with out:
            clear_output()
            print(BOLD + BLUE + "fastai2 Version: " + RESET + ITALIC + str(fastver))
            print(BOLD + BLUE + "nbdev Version: " + RESET + ITALIC + str(nbd))
            print(BOLD + BLUE + "fastprogress Version: " + RESET + ITALIC + str(fastprog))
            print(BOLD + BLUE + "fastpages Version: " + RESET + ITALIC + str(fastp) + '\n')
            print(BOLD + BLUE + "torchvision: " + RESET + ITALIC + str(torchvision.__version__))
            print(BOLD + BLUE + "torch version: " + RESET + ITALIC + str(torch.__version__))
            print(BOLD + BLUE + "\nCuda: " + RESET + ITALIC + str(torch.cuda.is_available()))
            print(BOLD + BLUE + "cuda Version: " + RESET + ITALIC + str(torch.version.cuda))
            print(BOLD + BLUE + "GPU: " + RESET + ITALIC + str(torch.cuda.get_device_name(0)))
    button.on_click(on_button_clicked_info)

    print ('>> Resources')
    button_two = widgets.Button(description='Fastai Docs', button_style='info')
    button_three = widgets.Button(description='Fastai Forums', button_style='info')
    button_four = widgets.Button(description='Vision_UI github', button_style='info')

    but_two = widgets.HBox([button_two, button_three, button_four])
    display(but_two)

    def on_doc_info(b):
        webbrowser.open('https://dev.fast.ai/')
    button_two.on_click(on_doc_info)

    def on_forum(b):
        webbrowser.open('https://forums.fast.ai/')
    button_three.on_click(on_forum)

    def vision_utube(b):
            webbrowser.open('https://github.com/asvcode/Vision_UI')
    button_four.on_click(vision_utube)