import datetime
from typing import Any, Dict, List, Type, TypeVar, Union

import attr
from dateutil.parser import isoparse

from ..models.exploits_api_v1_report_explanations_retrieve_response_200_explanations_item import (
    ExploitsApiV1ReportExplanationsRetrieveResponse200ExplanationsItem,
)
from ..types import UNSET, OSIDBModel, Unset

T = TypeVar("T", bound="ExploitsApiV1ReportExplanationsRetrieveResponse200")


@attr.s(auto_attribs=True)
class ExploitsApiV1ReportExplanationsRetrieveResponse200(OSIDBModel):
    """ """

    dt: Union[Unset, datetime.datetime] = UNSET
    env: Union[Unset, str] = UNSET
    explanations: Union[
        Unset, List[ExploitsApiV1ReportExplanationsRetrieveResponse200ExplanationsItem]
    ] = UNSET
    page_size: Union[Unset, int] = UNSET
    revision: Union[Unset, str] = UNSET
    version: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        dt: Union[Unset, str] = UNSET
        if not isinstance(self.dt, Unset):
            dt = self.dt.isoformat()

        env = self.env
        explanations: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.explanations, Unset):
            explanations = []
            for explanations_item_data in self.explanations:
                explanations_item: Dict[str, Any] = UNSET
                if not isinstance(explanations_item_data, Unset):
                    explanations_item = explanations_item_data.to_dict()

                explanations.append(explanations_item)

        page_size = self.page_size
        revision = self.revision
        version = self.version

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        if dt is not UNSET:
            field_dict["dt"] = dt
        if env is not UNSET:
            field_dict["env"] = env
        if explanations is not UNSET:
            field_dict["explanations"] = explanations
        if page_size is not UNSET:
            field_dict["page_size"] = page_size
        if revision is not UNSET:
            field_dict["revision"] = revision
        if version is not UNSET:
            field_dict["version"] = version

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        _dt = d.pop("dt", UNSET)
        dt: Union[Unset, datetime.datetime]
        if isinstance(_dt, Unset):
            dt = UNSET
        else:
            dt = isoparse(_dt)

        env = d.pop("env", UNSET)

        explanations = []
        _explanations = d.pop("explanations", UNSET)
        if _explanations is UNSET:
            explanations = UNSET
        else:
            for explanations_item_data in _explanations or []:
                _explanations_item = explanations_item_data
                explanations_item: ExploitsApiV1ReportExplanationsRetrieveResponse200ExplanationsItem
                if isinstance(_explanations_item, Unset):
                    explanations_item = UNSET
                else:
                    explanations_item = ExploitsApiV1ReportExplanationsRetrieveResponse200ExplanationsItem.from_dict(
                        _explanations_item
                    )

                explanations.append(explanations_item)

        page_size = d.pop("page_size", UNSET)

        revision = d.pop("revision", UNSET)

        version = d.pop("version", UNSET)

        exploits_api_v1_report_explanations_retrieve_response_200 = cls(
            dt=dt,
            env=env,
            explanations=explanations,
            page_size=page_size,
            revision=revision,
            version=version,
        )

        exploits_api_v1_report_explanations_retrieve_response_200.additional_properties = (
            d
        )
        return exploits_api_v1_report_explanations_retrieve_response_200

    @staticmethod
    def get_fields():
        return {
            "dt": datetime.datetime,
            "env": str,
            "explanations": List[
                ExploitsApiV1ReportExplanationsRetrieveResponse200ExplanationsItem
            ],
            "page_size": int,
            "revision": str,
            "version": str,
        }

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
