# generated by datamodel-codegen:
#   filename:  schema/entity/policies/lifecycle/moveAction.json
#   timestamp: 2021-12-04T12:57:16+00:00

from __future__ import annotations

from typing import Any, Optional, Union

from pydantic import BaseModel, Field, conint

from ....type import storage
from ...data import location
from ...services import storageService


class Destination(BaseModel):
    storageServiceType: Optional[storageService.StorageService] = Field(
        None, description='The storage service to move this entity to.'
    )
    storageClassType: Optional[storage.StorageClassType] = Field(
        None, description='The storage class to move this entity to.'
    )
    location: Optional[location.Table] = Field(
        None, description='The location where to move this entity to.'
    )


class LifecycleMoveAction1(BaseModel):
    daysAfterCreation: Optional[conint(ge=1)] = Field(
        None,
        description='Number of days after creation of the entity that the move should be triggered.',
    )
    daysAfterModification: Optional[conint(ge=1)] = Field(
        None,
        description='Number of days after last modification of the entity that the move should be triggered.',
    )
    destination: Optional[Destination] = Field(
        None, description='Location where this entity needs to be moved to.'
    )


class LifecycleMoveAction(BaseModel):
    __root__: Union[LifecycleMoveAction1, Any, Any] = Field(
        ...,
        description='An action to move the entity to a different location. For eg: Move from Standard storage tier to Archive storage tier.',
        title='LifecycleMoveAction',
    )
