// Copyright (c) Thorsten Beier
// Copyright (c) JupyterLite Contributors
// Distributed under the terms of the Modified BSD License.

import {
  IServiceWorkerRegistrationWrapper,
  JupyterLiteServer,
  JupyterLiteServerPlugin
} from '@jupyterlite/server';

import { IKernel, IKernelSpecs } from '@jupyterlite/kernel';

import { XeusServerKernel } from './xeus_server_kernel';

import logo32 from '!!file-loader?context=.!../style/logos/python-logo-32x32.png';
import logo64 from '!!file-loader?context=.!../style/logos/python-logo-64x64.png';

const server_kernel: JupyterLiteServerPlugin<void> = {
  id: '@jupyterlite/xeus-python-kernel-extension:kernel',
  autoStart: true,
  requires: [IKernelSpecs, IServiceWorkerRegistrationWrapper],
  activate: (
    app: JupyterLiteServer,
    kernelspecs: IKernelSpecs,
    serviceWorkerRegistrationWrapper: IServiceWorkerRegistrationWrapper
  ) => {
    kernelspecs.register({
      spec: {
        name: 'xeus-python',
        display_name: 'Python (XPython)',
        language: 'python',
        argv: [],
        resources: {
          'logo-32x32': logo32,
          'logo-64x64': logo64
        }
      },
      create: async (options: IKernel.IOptions): Promise<IKernel> => {
        return new XeusServerKernel({
          ...options,
          mountDrive: serviceWorkerRegistrationWrapper.enabled
        });
      }
    });
  }
};

const plugins: JupyterLiteServerPlugin<any>[] = [server_kernel];

export default plugins;
