import setuptools

test_packages = [
    "pytest>=5.4.3",
    "pytest-cov>=2.6.1"
]

docs_packages = [
    "mkdocs>=1.1",
    "mkdocs-material>=4.6.3",
    "mkdocstrings>=0.8.0",
]

base_packages = [
    "numpy>=1.19.2",
    "umap-learn>=0.5.0",
    "pandas>=1.1.5",
    "scikit-learn>=0.22.2.post1",
    "tqdm>=4.41.1",
    "torch>=1.4.0",
    "sentence-transformers>=0.4.1"
]

visualization_packages = [
    "matplotlib>=3.2.2",
    "plotly>=4.7.0,<4.14.3"
]

flair_packages = [
    "flair==0.7"
]

extra_packages = visualization_packages + flair_packages

dev_packages = docs_packages + test_packages + extra_packages


with open("README.md", "r") as fh:
    long_description = fh.read()

setuptools.setup(
    name="btmodified",
    packages=["btmodified"],
    version="0.6.0",
    author="Unknown",
    author_email="israel.osorioo@outlook.com",
    description="Modified version of Bertopics",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/Israel-osorio-ortiz/BERTmodified",
    keywords="none",
    classifiers=[
        "Programming Language :: Python",
        "Intended Audience :: Science/Research",
        "Intended Audience :: Developers",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
        "License :: OSI Approved :: MIT License",
        "Topic :: Scientific/Engineering",
        "Operating System :: Microsoft :: Windows",
        "Operating System :: POSIX",
        "Operating System :: Unix",
        "Operating System :: MacOS",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.8",
    ],
    install_requires=base_packages,
    extras_require={
        "test": test_packages,
        "docs": docs_packages,
        "dev": dev_packages,
        "visualization": visualization_packages,
        "flair": flair_packages,
        "all": extra_packages
    },
    python_requires='>=3.6',
)
