# generated by datamodel-codegen:
#   filename:  schema/entity/services/databaseService.json
#   timestamp: 2022-01-26T12:25:45+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional

from pydantic import BaseModel, Extra, Field, constr

from ...type import basic, entityHistory, entityReference


class DatabaseServiceType(Enum):
    BigQuery = 'BigQuery'
    MySQL = 'MySQL'
    Redshift = 'Redshift'
    Snowflake = 'Snowflake'
    Postgres = 'Postgres'
    MSSQL = 'MSSQL'
    Hive = 'Hive'
    Oracle = 'Oracle'
    Athena = 'Athena'
    Presto = 'Presto'
    Trino = 'Trino'
    Vertica = 'Vertica'
    Glue = 'Glue'
    MariaDB = 'MariaDB'
    Druid = 'Druid'


class DatabaseConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    username: Optional[str] = Field(
        None, description='username to connect  to the data source.'
    )
    password: Optional[str] = Field(
        None, description='password to connect  to the data source.'
    )
    hostPort: Optional[str] = Field(
        None, description='Host and port of the data source.'
    )
    database: Optional[str] = Field(None, description='Database of the data source.')
    connectionOptions: Optional[Dict[str, Any]] = Field(
        None,
        description='Additional connection options that can be sent to service during the connection.',
    )
    connectionArguments: Optional[Dict[str, Any]] = Field(
        None,
        description='Additional connection arguments such as security or protocol configs that can be sent to service during connection.',
    )


class DatabaseService(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(
        ..., description='Unique identifier of this database service instance.'
    )
    name: constr(min_length=1, max_length=128) = Field(
        ..., description='Name that identifies this database service.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this database service.'
    )
    serviceType: DatabaseServiceType = Field(
        ...,
        description='Type of database service such as MySQL, BigQuery, Snowflake, Redshift, Postgres...',
    )
    description: Optional[str] = Field(
        None, description='Description of a database service instance.'
    )
    databaseConnection: Optional[DatabaseConnection] = None
    airflowPipelines: Optional[entityReference.EntityReferenceList] = Field(
        None,
        description='References to airflow pipelines deployed for this database service.',
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: basic.Href = Field(
        ..., description='Link to the resource corresponding to this database service.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
