# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/ewm.ipynb (unless otherwise specified).

__all__ = ['ewm_mean']

# Cell
import random

import numpy as np
from numba import njit

# Cell
@njit
def ewm_mean(x: np.ndarray, alpha: float) -> np.ndarray:
    n = x.size
    out = np.empty(n, dtype=np.float32)
    out[0] = x[0]
    for i in range(1, n):
        out[i] = alpha * x[i] + (1-alpha) * out[i-1]
    return out