// Copyright (c) 2013-15, LKC Technologies, Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// Redistributions of source code must retain the above copyright notice, this
// list of conditions and the following disclaimer. Redistributions in binary
// form must reproduce the above copyright notice, this list of conditions and
// the following disclaimer in the documentation and/or other materials
// provided with the distribution. THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT
// HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
// INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
// COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#ifndef CODE128_H
#define CODE128_H

#include <stddef.h>

// credits to https://www.transmissionzero.co.uk/computing/building-dlls-with-mingw/
#ifdef _WIN32

    /* You should define ADD_EXPORTS *only* when building the DLL. */
    #ifdef ADD_EXPORTS
        #define ADDAPI __declspec(dllexport)
    #else
        #define ADDAPI __declspec(dllimport)
    #endif

    /* Define calling convention in one place, for convenience. */
    #define ADDCALL __cdecl

#else /* _WIN32 not defined. */

    /* Define with no value on non-Windows OSes. */
    #define ADDAPI
    #define ADDCALL

#endif


#ifdef __cplusplus
extern "C" {
#endif

// Since the FNCn characters are not ASCII, define versions here to
// simplify encoding strings that include them.
#define CODE128_FNC1 '\xf1'
#define CODE128_FNC2 '\xf2'
#define CODE128_FNC3 '\xf3'
#define CODE128_FNC4 '\xf4'

ADDAPI size_t ADDCALL code128_estimate_len(const char *s);
ADDAPI size_t ADDCALL code128_encode_gs1(const char *s, char *out, size_t maxlength);
ADDAPI size_t ADDCALL code128_encode_raw(const char *s, char *out, size_t maxlength);

#ifdef __cplusplus
}
#endif

#endif // CODE128_H
