# whylabs-client
WhyLabs API that enables end-to-end AI observability

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1
- Package version: 0.4.2
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://whylabs.ai](https://whylabs.ai)

## Requirements.

Python >= 3.6

## Getting Started

```python

import time
import whylabs_client
from pprint import pprint
from whylabs_client.api import alerts_api
from whylabs_client.model.get_alerts_paths_response import GetAlertsPathsResponse
from whylabs_client.model.segment_tag import SegmentTag
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = whylabs_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with whylabs_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = alerts_api.AlertsApi(api_client)
    org_id = "org-123" # str | Your company's unique organization ID
model_id = "model-123" # str | The unique model ID in your company. The model is created if it doesn't exist already.
start_timestamp = 1577836800000 # int | Start time exclusive
end_timestamp = 1893456000000 # int | 
segment_tags = [
        SegmentTag(
            key="key_example",
            value="value_example",
        ),
    ] # [SegmentTag], none_type | List of (key, value) pair tags for a segment. Must not contain duplicate values (optional)
version = "" # str, none_type | the version of the alert in case we have multiple schemas (optional)

    try:
        # Get the alerts for a given time period.
        api_response = api_instance.get_alerts_paths(org_id, model_id, start_timestamp, end_timestamp, segment_tags=segment_tags, version=version)
        pprint(api_response)
    except whylabs_client.ApiException as e:
        print("Exception when calling AlertsApi->get_alerts_paths: %s\n" % e)
```

