# -*- coding: utf-8 -*-
"""`NAF1 Standard <https://www.insee.fr/fr/information/2408180>`_.
"""
from ...types import Category, Classification, Standard, Standards

NAF1 = Standard(
    standard=Standards.NAF1,
    classes=[
        Classification("A", "AGRICULTURE, SYLVICULTURE ET PÊCHE", Category.SECTION),
        Classification("A", "Agriculture, chasse, sylviculture", Category.SECTION),
        Classification("B", "Pêche, aquaculture, services annexes", Category.SECTION),
        Classification("C", "Industries extractives", Category.SECTION),
        Classification("D", "Industrie manufacturière", Category.SECTION),
        Classification("E", "Production et distribution d'électricité, de gaz et d'eau", Category.SECTION),
        Classification("F", "Construction", Category.SECTION),
        Classification("G", "Commerce ; réparations automobile et d'articles domestiques", Category.SECTION),
        Classification("H", "Hôtels et restaurants", Category.SECTION),
        Classification("I", "Transports et communications", Category.SECTION),
        Classification("J", "Activités financières", Category.SECTION),
        Classification("K", "Immobilier, location et services aux entreprises", Category.SECTION),
        Classification("L", "Administration publique", Category.SECTION),
        Classification("M", "Education", Category.SECTION),
        Classification("N", "Santé et action sociale", Category.SECTION),
        Classification("O", "Services collectifs, sociaux et personnels", Category.SECTION),
        Classification("P", "Activités des ménages", Category.SECTION),
        Classification("Q", "Activités extra-territoriales", Category.SECTION),
        Classification("AA", "Agriculture, chasse, sylviculture", Category.DIVISION),
        Classification("BA", "Pêche, aquaculture, services annexes", Category.DIVISION),
        Classification("CA", "Extraction de produits énergétiques", Category.DIVISION),
        Classification("CB", "Extraction de produits non énergétiques", Category.DIVISION),
        Classification("DA", "Industries agricoles et alimentaires", Category.DIVISION),
        Classification("DB", "Industrie textile et habillement", Category.DIVISION),
        Classification("DC", "Industrie du cuir et de la chaussure", Category.DIVISION),
        Classification("DD", "Travail du bois et fabrication d'articles en bois", Category.DIVISION),
        Classification("DE", "Industrie du papier et du carton ; édition et imprimerie", Category.DIVISION),
        Classification("DF", "Cokéfaction, raffinage, industries nucléaires", Category.DIVISION),
        Classification("DG", "Industrie chimique", Category.DIVISION),
        Classification("DH", "Industrie du caoutchouc et des plastiques", Category.DIVISION),
        Classification("DI", "Fabrication d'autres produits minéraux non métalliques", Category.DIVISION),
        Classification("DJ", "Métallurgie et travail des métaux", Category.DIVISION),
        Classification("DK", "Fabrication de machines et équipements", Category.DIVISION),
        Classification("DL", "Fabrication d'équipements électriques et électroniques", Category.DIVISION),
        Classification("DM", "Fabrication de matériel de transport", Category.DIVISION),
        Classification("DN", "Autres industries manufacturières", Category.DIVISION),
        Classification("EA", "Production et distribution d'électricité, de gaz et d'eau", Category.DIVISION),
        Classification("FA", "Construction", Category.DIVISION),
        Classification("GA", "Commerce ; réparations automobile et d'articles domestiques", Category.DIVISION),
        Classification("HA", "Hôtels et restaurants", Category.DIVISION),
        Classification("IA", "Transports et communications", Category.DIVISION),
        Classification("JA", "Activités financières", Category.DIVISION),
        Classification("KA", "Immobilier, location et services aux entreprises", Category.DIVISION),
        Classification("LA", "Administration publique", Category.DIVISION),
        Classification("MA", "Education", Category.DIVISION),
        Classification("OA", "Services collectifs, sociaux et personnels", Category.DIVISION),
        Classification("PA", "Activités des ménages", Category.DIVISION),
        Classification("QA", "Activités extra-territoriales", Category.DIVISION),
        Classification("1", "Agriculture, chasse, services annexes", Category.GROUP),
        Classification("2", "Sylviculture, exploitation forestière, services annexes", Category.GROUP),
        Classification("5", "Pêche, aquaculture, services annexes", Category.GROUP),
        Classification("10", "Extraction de houille, de lignite et de tourbe", Category.GROUP),
        Classification("11", "Extraction d'hydrocarbures ; services annexes", Category.GROUP),
        Classification("12", "Extraction de minerais d'uranium", Category.GROUP),
        Classification("13", "Extraction de minerais métalliques", Category.GROUP),
        Classification("14", "Autres industries extractives", Category.GROUP),
        Classification("15", "Industries alimentaires", Category.GROUP),
        Classification("16", "Industrie du tabac", Category.GROUP),
        Classification("17", "Industrie textile", Category.GROUP),
        Classification("18", "Industrie de l'habillement et des fourrures", Category.GROUP),
        Classification("19", "Industrie du cuir et de la chaussure", Category.GROUP),
        Classification("20", "Travail du bois et fabrication d'articles en bois", Category.GROUP),
        Classification("21", "Industrie du papier et du carton", Category.GROUP),
        Classification("22", "Edition, imprimerie, reproduction", Category.GROUP),
        Classification("23", "Cokéfaction, raffinage, industries nucléaires", Category.GROUP),
        Classification("24", "Industrie chimique", Category.GROUP),
        Classification("25", "Industrie du caoutchouc et des plastiques", Category.GROUP),
        Classification("26", "Fabrication d'autres produits minéraux non métalliques", Category.GROUP),
        Classification("27", "Métallurgie", Category.GROUP),
        Classification("28", "Travail des métaux", Category.GROUP),
        Classification("29", "Fabrication de machines et d'équipements", Category.GROUP),
        Classification("30", "Fabrication de machines de bureau et de matériel informatique", Category.GROUP),
        Classification("31", "Fabrication de machines et appareils électriques", Category.GROUP),
        Classification("32", "Fabrication d'équipements de radio, télévision et communication", Category.GROUP),
        Classification(
            "33", "Fabrication d'instruments médicaux, de précision, d'optique et d'horlogerie", Category.GROUP
        ),
        Classification("34", "Industrie automobile", Category.GROUP),
        Classification("35", "Fabrication d'autres matériels de transport", Category.GROUP),
        Classification("36", "Fabrication de meubles ; industries diverses", Category.GROUP),
        Classification("37", "Récupération", Category.GROUP),
        Classification("40", "Production et distribution d'électricité, de gaz et de chaleur", Category.GROUP),
        Classification("41", "Captage, traitement et distribution d'eau", Category.GROUP),
        Classification("45", "Construction", Category.GROUP),
        Classification("50", "Commerce et réparation automobile", Category.GROUP),
        Classification("51", "Commerce de gros et intermédiaires du commerce", Category.GROUP),
        Classification("52", "Commerce de détail et réparation d'articles domestiques", Category.GROUP),
        Classification("55", "Hôtels et restaurants", Category.GROUP),
        Classification("60", "Transports terrestres", Category.GROUP),
        Classification("61", "Transports par eau", Category.GROUP),
        Classification("62", "Transports aériens", Category.GROUP),
        Classification("63", "Services auxiliaires des transports", Category.GROUP),
        Classification("64", "Postes et télécommunications", Category.GROUP),
        Classification("65", "Intermédiation financière", Category.GROUP),
        Classification("66", "Assurance", Category.GROUP),
        Classification("67", "Auxiliaires financiers et d'assurance", Category.GROUP),
        Classification("70", "Activités immobilières", Category.GROUP),
        Classification("71", "Location sans opérateur", Category.GROUP),
        Classification("72", "Activités informatiques", Category.GROUP),
        Classification("73", "Recherche et développement", Category.GROUP),
        Classification("74", "Services fournis principalement aux entreprises", Category.GROUP),
        Classification("75", "Administration publique", Category.GROUP),
        Classification("80", "Education", Category.GROUP),
        Classification("85", "Santé et action sociale", Category.GROUP),
        Classification("90", "Assainissement, voirie et gestion des déchets", Category.GROUP),
        Classification("91", "Activités associatives", Category.GROUP),
        Classification("92", "Activités récréatives, culturelles et sportives", Category.GROUP),
        Classification("93", "Services personnels", Category.GROUP),
        Classification("95", "Activités des ménages en tant qu'employeur de personnel domestique", Category.GROUP),
        Classification(
            "96",
            "Activités indifférenciées des ménages en tant que producteurs de biens pour usage propre",
            Category.GROUP,
        ),
        Classification(
            "97",
            "Activités indifférenciées des ménages en tant que producteurs de services pour usage propre",
            Category.GROUP,
        ),
        Classification("99", "Activités extra-territoriales", Category.GROUP),
        Classification("1.1", "Culture", Category.CLASS),
        Classification("1.2", "Elevage", Category.CLASS),
        Classification("1.3", "Culture et élevage associés", Category.CLASS),
        Classification("1.4", "Services annexes à l'agriculture et aménagement des paysages", Category.CLASS),
        Classification("1.5", "Chasse", Category.CLASS),
        Classification("2.0", "Sylviculture, exploitation forestière, services annexes", Category.CLASS),
        Classification("5.0", "Pêche, aquaculture, services annexes", Category.CLASS),
        Classification("10.1", "Extraction et agglomération de la houille", Category.CLASS),
        Classification("10.2", "Extraction et agglomération du lignite", Category.CLASS),
        Classification("10.3", "Extraction et agglomération de la tourbe", Category.CLASS),
        Classification("11.1", "Extraction d'hydrocarbures", Category.CLASS),
        Classification("11.2", "Services annexes à l'extraction d'hydrocarbures", Category.CLASS),
        Classification("12.0", "Extraction de minerais d'uranium", Category.CLASS),
        Classification("13.1", "Extraction de minerais de fer", Category.CLASS),
        Classification("13.2", "Extraction de minerais de métaux non ferreux", Category.CLASS),
        Classification("14.1", "Extraction de pierres", Category.CLASS),
        Classification("14.2", "Extraction de sables et d'argiles", Category.CLASS),
        Classification(
            "14.3", "Extraction de minéraux pour l'industrie chimique et d'engrais naturels", Category.CLASS
        ),
        Classification("14.4", "Production de sel", Category.CLASS),
        Classification("14.5", "Activités extractives n.c.a.", Category.CLASS),
        Classification("15.1", "Industrie des viandes", Category.CLASS),
        Classification("15.2", "Industrie du poisson", Category.CLASS),
        Classification("15.3", "Industrie des fruits et légumes", Category.CLASS),
        Classification("15.4", "Industrie des corps gras", Category.CLASS),
        Classification("15.5", "Industrie laitière", Category.CLASS),
        Classification("15.6", "Travail des grains ; fabrication de produits amylacés", Category.CLASS),
        Classification("15.7", "Fabrication d'aliments pour animaux", Category.CLASS),
        Classification("15.8", "Autres industries alimentaires", Category.CLASS),
        Classification("15.9", "Industrie des boissons", Category.CLASS),
        Classification("16.0", "Industrie du tabac", Category.CLASS),
        Classification("17.1", "Filature", Category.CLASS),
        Classification("17.2", "Tissage", Category.CLASS),
        Classification("17.3", "Ennoblissement textile", Category.CLASS),
        Classification("17.4", "Fabrication d'articles textiles", Category.CLASS),
        Classification("17.5", "Autres industries textiles", Category.CLASS),
        Classification("17.6", "Fabrication d'étoffes à maille", Category.CLASS),
        Classification("17.7", "Fabrication d'articles à maille", Category.CLASS),
        Classification("18.1", "Fabrication de vêtements en cuir", Category.CLASS),
        Classification("18.2", "Fabrication de vêtements en textile", Category.CLASS),
        Classification("18.3", "Industrie des fourrures", Category.CLASS),
        Classification("19.1", "Apprêt et tannage des cuirs", Category.CLASS),
        Classification("19.2", "Fabrication d'articles de voyage et de maroquinerie", Category.CLASS),
        Classification("19.3", "Fabrication de chaussures", Category.CLASS),
        Classification("20.1", "Sciage, rabotage, imprégnation du bois", Category.CLASS),
        Classification("20.2", "Fabrication de panneaux de bois", Category.CLASS),
        Classification("20.3", "Fabrication de charpentes et de menuiseries", Category.CLASS),
        Classification("20.4", "Fabrication d'emballages en bois", Category.CLASS),
        Classification("20.5", "Fabrication d'objets divers en bois, liège ou vannerie", Category.CLASS),
        Classification("21.1", "Fabrication de pâte à papier, de papier et de carton", Category.CLASS),
        Classification("21.2", "Fabrication d'articles en papier ou en carton", Category.CLASS),
        Classification("22.1", "Edition", Category.CLASS),
        Classification("22.2", "Imprimerie", Category.CLASS),
        Classification("22.3", "Reproduction d'enregistrements", Category.CLASS),
        Classification("23.1", "Cokéfaction", Category.CLASS),
        Classification("23.2", "Raffinage de pétrole", Category.CLASS),
        Classification("23.3", "Elaboration et transformation de matières nucléaires", Category.CLASS),
        Classification("24.1", "Industrie chimique de base", Category.CLASS),
        Classification("24.2", "Fabrication de produits agrochimiques", Category.CLASS),
        Classification("24.3", "Fabrication de peintures et vernis", Category.CLASS),
        Classification("24.4", "Industrie pharmaceutique", Category.CLASS),
        Classification("24.5", "Fabrication de savons, de parfums et de produits d'entretien", Category.CLASS),
        Classification("24.6", "Fabrication d'autres produits chimiques", Category.CLASS),
        Classification("24.7", "Fabrication de fibres artificielles ou synthétiques", Category.CLASS),
        Classification("25.1", "Industrie du caoutchouc", Category.CLASS),
        Classification("25.2", "Transformation des matières plastiques", Category.CLASS),
        Classification("26.1", "Fabrication de verre et d'articles en verre", Category.CLASS),
        Classification("26.2", "Fabrication de produits céramiques", Category.CLASS),
        Classification("26.3", "Fabrication de carreaux en céramique", Category.CLASS),
        Classification("26.4", "Fabrication de tuiles et briques en terre cuite", Category.CLASS),
        Classification("26.5", "Fabrication de ciment, chaux et plâtre", Category.CLASS),
        Classification("26.6", "Fabrication d'ouvrages en béton ou en plâtre", Category.CLASS),
        Classification(
            "26.7", "Taille, façonnage et finissage de pierres ornementales et de construction", Category.CLASS
        ),
        Classification("26.8", "Fabrication de produits minéraux divers", Category.CLASS),
        Classification("27.1", "Sidérurgie", Category.CLASS),
        Classification("27.2", "Fabrication de tubes", Category.CLASS),
        Classification("27.3", "Autres opérations de première transformation de l'acier", Category.CLASS),
        Classification("27.4", "Production de métaux non ferreux", Category.CLASS),
        Classification("27.5", "Fonderie", Category.CLASS),
        Classification("28.1", "Fabrication d'éléments en métal pour la construction", Category.CLASS),
        Classification(
            "28.2", "Fabrication de réservoirs métalliques et de chaudières pour le chauffage central", Category.CLASS
        ),
        Classification("28.3", "Chaudronnerie", Category.CLASS),
        Classification("28.4", "Forge, emboutissage, estampage ; métallurgie des poudres", Category.CLASS),
        Classification("28.5", "Traitement des métaux ; mécanique générale", Category.CLASS),
        Classification("28.6", "Fabrication de coutellerie, d'outillage et de quincaillerie", Category.CLASS),
        Classification("28.7", "Fabrication d'autres ouvrages en métaux", Category.CLASS),
        Classification("29.1", "Fabrication d'équipements mécaniques", Category.CLASS),
        Classification("29.2", "Fabrication de machines d'usage général", Category.CLASS),
        Classification("29.3", "Fabrication de machines agricoles", Category.CLASS),
        Classification("29.4", "Fabrication de machines-outils", Category.CLASS),
        Classification("29.5", "Fabrication d'autres machines d'usage spécifique", Category.CLASS),
        Classification("29.6", "Fabrication d'armes et de munitions", Category.CLASS),
        Classification("29.7", "Fabrication d'appareils domestiques", Category.CLASS),
        Classification("30.0", "Fabrication de machines de bureau et de matériel informatique", Category.CLASS),
        Classification("31.1", "Fabrication de moteurs, génératrices et transformateurs électriques", Category.CLASS),
        Classification("31.2", "Fabrication de matériel de distribution et de commande électrique", Category.CLASS),
        Classification("31.3", "Fabrication de fils et câbles isolés", Category.CLASS),
        Classification("31.4", "Fabrication d'accumulateurs et de piles électriques", Category.CLASS),
        Classification("31.5", "Fabrication de lampes et d'appareils d'éclairage", Category.CLASS),
        Classification("31.6", "Fabrication d'autres matériels électriques", Category.CLASS),
        Classification("32.1", "Fabrication de composants électroniques", Category.CLASS),
        Classification("32.2", "Fabrication d'appareils d'émission et de transmission", Category.CLASS),
        Classification(
            "32.3",
            "Fabrication d'appareils de réception, enregistrement ou reproduction du son et de l'image",
            Category.CLASS,
        ),
        Classification("33.1", "Fabrication de matériel médico-chirurgical et d'orthopédie", Category.CLASS),
        Classification("33.2", "Fabrication d'instruments de mesure et de contrôle", Category.CLASS),
        Classification("33.3", "Fabrication d'équipements de contrôle des processus industriels", Category.CLASS),
        Classification("33.4", "Fabrication de matériels optique et photographique", Category.CLASS),
        Classification("33.5", "Horlogerie", Category.CLASS),
        Classification("34.1", "Construction de véhicules automobiles", Category.CLASS),
        Classification("34.2", "Fabrication de carrosseries et remorques", Category.CLASS),
        Classification("34.3", "Fabrication d'équipements automobiles", Category.CLASS),
        Classification("35.1", "Construction navale", Category.CLASS),
        Classification("35.2", "Construction de matériel ferroviaire roulant", Category.CLASS),
        Classification("35.3", "Construction aéronautique et spatiale", Category.CLASS),
        Classification("35.4", "Fabrication de motocycles et de bicyclettes", Category.CLASS),
        Classification("35.5", "Fabrication de matériels de transport n.c.a.", Category.CLASS),
        Classification("36.1", "Fabrication de meubles", Category.CLASS),
        Classification("36.2", "Bijouterie", Category.CLASS),
        Classification("36.3", "Fabrication d'instruments de musique", Category.CLASS),
        Classification("36.4", "Fabrication d'articles de sport", Category.CLASS),
        Classification("36.5", "Fabrication de jeux et jouets", Category.CLASS),
        Classification("36.6", "Autres industries diverses", Category.CLASS),
        Classification("37.1", "Récupération de matières métalliques recyclables", Category.CLASS),
        Classification("37.2", "Récupération de matières non métalliques recyclables", Category.CLASS),
        Classification("40.1", "Production et distribution d'électricité", Category.CLASS),
        Classification("40.2", "Production et distribution de combustibles gazeux", Category.CLASS),
        Classification("40.3", "Production et distribution de chaleur", Category.CLASS),
        Classification("41.0", "Captage, traitement et distribution d'eau", Category.CLASS),
        Classification("45.1", "Préparation des sites", Category.CLASS),
        Classification("45.2", "Construction d'ouvrages de bâtiment ou de génie civil", Category.CLASS),
        Classification("45.3", "Travaux d'installation", Category.CLASS),
        Classification("45.4", "Travaux de finition", Category.CLASS),
        Classification("45.5", "Location avec opérateur de matériel de construction", Category.CLASS),
        Classification("50.1", "Commerce de véhicules automobiles", Category.CLASS),
        Classification("50.2", "Entretien et réparation de véhicules automobiles", Category.CLASS),
        Classification("50.3", "Commerce d'équipements automobiles", Category.CLASS),
        Classification("50.4", "Commerce et réparation de motocycles", Category.CLASS),
        Classification("50.5", "Commerce de détail de carburants", Category.CLASS),
        Classification("51.1", "Intermédiaires du commerce de gros", Category.CLASS),
        Classification("51.2", "Commerce de gros de produits agricoles bruts", Category.CLASS),
        Classification("51.3", "Commerce de gros de produits alimentaires", Category.CLASS),
        Classification("51.4", "Commerce de gros de biens de consommation non alimentaires", Category.CLASS),
        Classification("51.5", "Commerce de gros de produits intermédiaires non agricoles", Category.CLASS),
        Classification("51.8", "Commerce de gros d'équipements industriels", Category.CLASS),
        Classification("51.9", "Autres commerces de gros", Category.CLASS),
        Classification("52.1", "Commerce de détail en magasin non spécialisé", Category.CLASS),
        Classification("52.2", "Commerce de détail alimentaire en magasin spécialisé", Category.CLASS),
        Classification("52.3", "Commerce de détail de produits pharmaceutiques et de parfumerie", Category.CLASS),
        Classification("52.4", "Autres commerces de détail en magasin spécialisé", Category.CLASS),
        Classification("52.5", "Commerce de détail de biens d'occasion", Category.CLASS),
        Classification("52.6", "Commerce de détail hors magasin", Category.CLASS),
        Classification("52.7", "Réparation d'articles personnels et domestiques", Category.CLASS),
        Classification("55.1", "Hôtels", Category.CLASS),
        Classification("55.2", "Autres moyens d'hébergement de courte durée", Category.CLASS),
        Classification("55.3", "Restaurants", Category.CLASS),
        Classification("55.4", "Cafés", Category.CLASS),
        Classification("55.5", "Cantines et traiteurs", Category.CLASS),
        Classification("60.1", "Transports ferroviaires", Category.CLASS),
        Classification("60.2", "Transports urbains et routiers", Category.CLASS),
        Classification("60.3", "Transports par conduites", Category.CLASS),
        Classification("61.1", "Transports maritimes et côtiers", Category.CLASS),
        Classification("61.2", "Transports fluviaux", Category.CLASS),
        Classification("62.1", "Transports aériens réguliers", Category.CLASS),
        Classification("62.2", "Transports aériens non réguliers", Category.CLASS),
        Classification("62.3", "Transports spatiaux", Category.CLASS),
        Classification("63.1", "Manutention et entreposage", Category.CLASS),
        Classification("63.2", "Gestion d'infrastructures de transports", Category.CLASS),
        Classification("63.3", "Agences de voyage", Category.CLASS),
        Classification("63.4", "Organisation du transport de fret", Category.CLASS),
        Classification("64.1", "Activités de poste et de courrier", Category.CLASS),
        Classification("64.2", "Télécommunications", Category.CLASS),
        Classification("65.1", "Intermédiation monétaire", Category.CLASS),
        Classification("65.2", "Autres intermédiations financières", Category.CLASS),
        Classification("66.0", "Assurance", Category.CLASS),
        Classification("67.1", "Auxiliaires financiers", Category.CLASS),
        Classification("67.2", "Auxiliaires d'assurance", Category.CLASS),
        Classification("70.1", "Activités immobilières pour compte propre", Category.CLASS),
        Classification("70.2", "Location de biens immobiliers", Category.CLASS),
        Classification("70.3", "Activités immobilières pour compte de tiers", Category.CLASS),
        Classification("71.1", "Location de véhicules automobiles", Category.CLASS),
        Classification("71.2", "Location d'autres matériels de transport", Category.CLASS),
        Classification("71.3", "Location de machines et équipements", Category.CLASS),
        Classification("71.4", "Location de biens personnels et domestiques", Category.CLASS),
        Classification("72.1", "Conseil en systèmes informatiques", Category.CLASS),
        Classification("72.2", "Réalisation de logiciels", Category.CLASS),
        Classification("72.3", "Traitement de données", Category.CLASS),
        Classification("72.4", "Activités de banques de données", Category.CLASS),
        Classification(
            "72.5", "Entretien et réparation de machines de bureau et de matériel informatique", Category.CLASS
        ),
        Classification("72.6", "Autres activités rattachées à l'informatique", Category.CLASS),
        Classification("73.1", "Recherche-développement en sciences physiques et naturelles", Category.CLASS),
        Classification("73.2", "Recherche-développement en sciences humaines et sociales", Category.CLASS),
        Classification("74.1", "Activités juridiques, comptables et de conseil de gestion", Category.CLASS),
        Classification("74.2", "Activités d'architecture et d'ingénierie", Category.CLASS),
        Classification("74.3", "Activités de contrôle et analyses techniques", Category.CLASS),
        Classification("74.4", "Publicité", Category.CLASS),
        Classification("74.5", "Sélection et fourniture de personnel", Category.CLASS),
        Classification("74.6", "Enquêtes et sécurité", Category.CLASS),
        Classification("74.7", "Activités de nettoyage", Category.CLASS),
        Classification("74.8", "Services divers fournis principalement aux entreprises", Category.CLASS),
        Classification("75.1", "Administration générale, économique et sociale", Category.CLASS),
        Classification("75.2", "Services de prérogative publique", Category.CLASS),
        Classification("75.3", "Sécurité sociale obligatoire", Category.CLASS),
        Classification("80.1", "Enseignement primaire", Category.CLASS),
        Classification("80.2", "Enseignement secondaire", Category.CLASS),
        Classification("80.3", "Enseignement supérieur", Category.CLASS),
        Classification("80.4", "Formation permanente et autres activités d'enseignement", Category.CLASS),
        Classification("85.1", "Activités pour la santé humaine", Category.CLASS),
        Classification("85.2", "Activités vétérinaires", Category.CLASS),
        Classification("85.3", "Action sociale", Category.CLASS),
        Classification("90.0", "Assainissement, voirie et gestion des déchets", Category.CLASS),
        Classification("91.1", "Organisations économiques", Category.CLASS),
        Classification("91.2", "Syndicats de salariés", Category.CLASS),
        Classification("91.3", "Autres organisations associatives", Category.CLASS),
        Classification("92.1", "Activités cinématographiques et vidéo", Category.CLASS),
        Classification("92.2", "Activités de radio et de télévision", Category.CLASS),
        Classification("92.3", "Autres activités artistiques et de spectacle", Category.CLASS),
        Classification("92.4", "Agences de presse", Category.CLASS),
        Classification("92.5", "Autres activités culturelles", Category.CLASS),
        Classification("92.6", "Activités liées au sport", Category.CLASS),
        Classification("92.7", "Activités récréatives", Category.CLASS),
        Classification("93.0", "Services personnels", Category.CLASS),
        Classification("95.0", "Activités des ménages en tant qu'employeur de personnel domestique", Category.CLASS),
        Classification(
            "96.0",
            "Activités indifférenciées des ménages en tant que producteurs de biens pour usage propre",
            Category.CLASS,
        ),
        Classification(
            "97.0",
            "Activités indifférenciées des ménages en tant que producteurs de services pour usage propre",
            Category.CLASS,
        ),
        Classification("99.0", "Activités extra-territoriales", Category.CLASS),
        Classification("01.1A", "Culture de céréales ; cultures industrielles", Category.SUBCLASS),
        Classification("01.1C", "Culture de légumes ; maraîchage", Category.SUBCLASS),
        Classification("01.1D", "Horticulture ; pépinières", Category.SUBCLASS),
        Classification("01.1F", "Culture fruitière", Category.SUBCLASS),
        Classification("01.1G", "Viticulture", Category.SUBCLASS),
        Classification("01.2A", "Elevage de bovins", Category.SUBCLASS),
        Classification("01.2C", "Elevage d'ovins, caprins et équidés", Category.SUBCLASS),
        Classification("01.2E", "Elevage de porcins", Category.SUBCLASS),
        Classification("01.2G", "Elevage de volailles", Category.SUBCLASS),
        Classification("01.2J", "Elevage d'autres animaux", Category.SUBCLASS),
        Classification("01.3Z", "Culture et élevage associés", Category.SUBCLASS),
        Classification("01.4A", "Services aux cultures productives", Category.SUBCLASS),
        Classification("01.4B", "Réalisation et entretien de plantations ornementales", Category.SUBCLASS),
        Classification("01.4D", "Services annexes à l'élevage", Category.SUBCLASS),
        Classification("01.5Z", "Chasse", Category.SUBCLASS),
        Classification("02.0A", "Sylviculture", Category.SUBCLASS),
        Classification("02.0B", "Exploitation forestière", Category.SUBCLASS),
        Classification("02.0D", "Services forestiers", Category.SUBCLASS),
        Classification("05.0A", "Pêche", Category.SUBCLASS),
        Classification("05.0C", "Pisciculture, aquaculture", Category.SUBCLASS),
        Classification("10.1Z", "Extraction et agglomération de la houille", Category.SUBCLASS),
        Classification("10.2Z", "Extraction et agglomération du lignite", Category.SUBCLASS),
        Classification("10.3Z", "Extraction et agglomération de la tourbe", Category.SUBCLASS),
        Classification("11.1Z", "Extraction d'hydrocarbures", Category.SUBCLASS),
        Classification("11.2Z", "Services annexes à l'extraction d'hydrocarbures", Category.SUBCLASS),
        Classification("12.0Z", "Extraction de minerais d'uranium", Category.SUBCLASS),
        Classification("13.1Z", "Extraction de minerais de fer", Category.SUBCLASS),
        Classification("13.2Z", "Extraction de minerais de métaux non ferreux", Category.SUBCLASS),
        Classification("14.1A", "Extraction de pierres ornementales et de construction", Category.SUBCLASS),
        Classification("14.1C", "Extraction de calcaire industriel, de gypse et de craie", Category.SUBCLASS),
        Classification("14.1E", "Extraction d'ardoise", Category.SUBCLASS),
        Classification("14.2A", "Production de sables et de granulats", Category.SUBCLASS),
        Classification("14.2C", "Extraction d'argiles et de kaolin", Category.SUBCLASS),
        Classification(
            "14.3Z", "Extraction de minéraux pour l'industrie chimique et d'engrais naturels", Category.SUBCLASS
        ),
        Classification("14.4Z", "Production de sel", Category.SUBCLASS),
        Classification("14.5Z", "Activités extractives n.c.a.", Category.SUBCLASS),
        Classification("15.1A", "Production de viandes de boucherie", Category.SUBCLASS),
        Classification("15.1C", "Production de viandes de volailles", Category.SUBCLASS),
        Classification("15.1E", "Préparation industrielle de produits à base de viandes", Category.SUBCLASS),
        Classification("15.1F", "Charcuterie", Category.SUBCLASS),
        Classification("15.2Z", "Industrie du poisson", Category.SUBCLASS),
        Classification("15.3A", "Transformation et conservation de pommes de terre", Category.SUBCLASS),
        Classification("15.3C", "Préparation de jus de fruits et légumes", Category.SUBCLASS),
        Classification("15.3E", "Transformation et conservation de légumes", Category.SUBCLASS),
        Classification("15.3F", "Transformation et conservation de fruits", Category.SUBCLASS),
        Classification("15.4A", "Fabrication d'huiles et graisses brutes", Category.SUBCLASS),
        Classification("15.4C", "Fabrication d'huiles et graisses raffinées", Category.SUBCLASS),
        Classification("15.4E", "Fabrication de margarine", Category.SUBCLASS),
        Classification("15.5A", "Fabrication de lait liquide et de produits frais", Category.SUBCLASS),
        Classification("15.5B", "Fabrication de beurre", Category.SUBCLASS),
        Classification("15.5C", "Fabrication de fromages", Category.SUBCLASS),
        Classification("15.5D", "Fabrication d'autres produits laitiers", Category.SUBCLASS),
        Classification("15.5F", "Fabrication de glaces et sorbets", Category.SUBCLASS),
        Classification("15.6A", "Meunerie", Category.SUBCLASS),
        Classification("15.6B", "Autres activités de travail des grains", Category.SUBCLASS),
        Classification("15.6D", "Fabrication de produits amylacés", Category.SUBCLASS),
        Classification("15.7A", "Fabrication d'aliments pour animaux de ferme", Category.SUBCLASS),
        Classification("15.7C", "Fabrication d'aliments pour animaux de compagnie", Category.SUBCLASS),
        Classification("15.8A", "Fabrication industrielle de pain et de pâtisserie fraîche", Category.SUBCLASS),
        Classification("15.8B", "Cuisson de produits de boulangerie", Category.SUBCLASS),
        Classification("15.8C", "Boulangerie et boulangerie-pâtisserie", Category.SUBCLASS),
        Classification("15.8D", "Pâtisserie", Category.SUBCLASS),
        Classification("15.8F", "Biscotterie, biscuiterie, pâtisserie de conservation", Category.SUBCLASS),
        Classification("15.8H", "Fabrication de sucre", Category.SUBCLASS),
        Classification("15.8K", "Chocolaterie, confiserie", Category.SUBCLASS),
        Classification("15.8M", "Fabrication de pâtes alimentaires", Category.SUBCLASS),
        Classification("15.8P", "Transformation du thé et du café", Category.SUBCLASS),
        Classification("15.8R", "Fabrication de condiments et assaisonnements", Category.SUBCLASS),
        Classification("15.8T", "Fabrication d'aliments adaptés à l'enfant et diététiques", Category.SUBCLASS),
        Classification("15.8V", "Industries alimentaires n.c.a.", Category.SUBCLASS),
        Classification("15.9A", "Production d'eaux de vie naturelles", Category.SUBCLASS),
        Classification("15.9B", "Fabrication de spiritueux", Category.SUBCLASS),
        Classification("15.9D", "Production d'alcool éthylique de fermentation", Category.SUBCLASS),
        Classification("15.9F", "Champagnisation", Category.SUBCLASS),
        Classification("15.9G", "Vinification", Category.SUBCLASS),
        Classification("15.9J", "Cidrerie", Category.SUBCLASS),
        Classification("15.9L", "Production d'autres boissons fermentées", Category.SUBCLASS),
        Classification("15.9N", "Brasserie", Category.SUBCLASS),
        Classification("15.9Q", "Malterie", Category.SUBCLASS),
        Classification("15.9S", "Industrie des eaux de table", Category.SUBCLASS),
        Classification("15.9T", "Production de boissons rafraîchissantes", Category.SUBCLASS),
        Classification("16.0Z", "Industrie du tabac", Category.SUBCLASS),
        Classification("17.1A", "Filature de l'industrie cotonnière", Category.SUBCLASS),
        Classification("17.1C", "Filature de l'industrie lainière - cycle cardé", Category.SUBCLASS),
        Classification("17.1E", "Préparation de la laine", Category.SUBCLASS),
        Classification("17.1F", "Filature de l'industrie lainière - cycle peigné", Category.SUBCLASS),
        Classification("17.1H", "Préparation et filature du lin", Category.SUBCLASS),
        Classification(
            "17.1K",
            "Moulinage et texturation de la soie et des textiles artificiels ou synthétiques",
            Category.SUBCLASS,
        ),
        Classification("17.1M", "Fabrication de fils à coudre", Category.SUBCLASS),
        Classification("17.1P", "Préparation et filature d'autres fibres", Category.SUBCLASS),
        Classification("17.2A", "Tissage de l'industrie cotonnière", Category.SUBCLASS),
        Classification("17.2C", "Tissage de l'industrie lainière - cycle cardé", Category.SUBCLASS),
        Classification("17.2E", "Tissage de l'industrie lainière - cycle peigné", Category.SUBCLASS),
        Classification("17.2G", "Tissage de soieries", Category.SUBCLASS),
        Classification("17.2J", "Tissage d'autres textiles", Category.SUBCLASS),
        Classification("17.3Z", "Ennoblissement textile", Category.SUBCLASS),
        Classification("17.4A", "Fabrication de linge de maison et d'articles d'ameublement", Category.SUBCLASS),
        Classification("17.4B", "Fabrication de petits articles textiles de literie", Category.SUBCLASS),
        Classification("17.4C", "Fabrication d'autres articles confectionnés en textile", Category.SUBCLASS),
        Classification("17.5A", "Fabrication de tapis et moquettes", Category.SUBCLASS),
        Classification("17.5C", "Ficellerie, corderie, fabrication de filets", Category.SUBCLASS),
        Classification("17.5E", "Fabrication de non-tissés", Category.SUBCLASS),
        Classification("17.5G", "Industries textiles n.c.a.", Category.SUBCLASS),
        Classification("17.6Z", "Fabrication d'étoffes à maille", Category.SUBCLASS),
        Classification("17.7A", "Fabrication de bas et chaussettes", Category.SUBCLASS),
        Classification("17.7C", "Fabrication de pull-overs et articles similaires", Category.SUBCLASS),
        Classification("18.1Z", "Fabrication de vêtements en cuir", Category.SUBCLASS),
        Classification("18.2A", "Fabrication de vêtements de travail", Category.SUBCLASS),
        Classification("18.2C", "Fabrication de vêtements sur mesure", Category.SUBCLASS),
        Classification("18.2D", "Fabrication de vêtements de dessus pour hommes et garçonnets", Category.SUBCLASS),
        Classification("18.2E", "Fabrication de vêtements de dessus pour femmes et fillettes", Category.SUBCLASS),
        Classification("18.2G", "Fabrication de vêtements de dessous", Category.SUBCLASS),
        Classification("18.2J", "Fabrication d'autres vêtements et accessoires", Category.SUBCLASS),
        Classification("18.3Z", "Industrie des fourrures", Category.SUBCLASS),
        Classification("19.1Z", "Apprêt et tannage des cuirs", Category.SUBCLASS),
        Classification("19.2Z", "Fabrication d'articles de voyage et de maroquinerie", Category.SUBCLASS),
        Classification("19.3Z", "Fabrication de chaussures", Category.SUBCLASS),
        Classification("20.1A", "Sciage et rabotage du bois", Category.SUBCLASS),
        Classification("20.1B", "Imprégnation du bois", Category.SUBCLASS),
        Classification("20.2Z", "Fabrication de panneaux de bois", Category.SUBCLASS),
        Classification("20.3Z", "Fabrication de charpentes et de menuiseries", Category.SUBCLASS),
        Classification("20.4Z", "Fabrication d'emballages en bois", Category.SUBCLASS),
        Classification("20.5A", "Fabrication d'objets divers en bois", Category.SUBCLASS),
        Classification("20.5C", "Fabrication d'objets en liège, vannerie ou sparterie", Category.SUBCLASS),
        Classification("21.1A", "Fabrication de pâte à papier", Category.SUBCLASS),
        Classification("21.1C", "Fabrication de papier et de carton", Category.SUBCLASS),
        Classification("21.2A", "Industrie du carton ondulé", Category.SUBCLASS),
        Classification("21.2B", "Fabrication de cartonnages", Category.SUBCLASS),
        Classification("21.2C", "Fabrication d'emballages en papier", Category.SUBCLASS),
        Classification("21.2E", "Fabrication d'articles en papier à usage sanitaire ou domestique", Category.SUBCLASS),
        Classification("21.2G", "Fabrication d'articles de papeterie", Category.SUBCLASS),
        Classification("21.2J", "Fabrication de papiers peints", Category.SUBCLASS),
        Classification("21.2L", "Fabrication d'autres articles en papier ou en carton", Category.SUBCLASS),
        Classification("22.1A", "Edition de livres", Category.SUBCLASS),
        Classification("22.1C", "Edition de journaux", Category.SUBCLASS),
        Classification("22.1E", "Edition de revues et périodiques", Category.SUBCLASS),
        Classification("22.1G", "Edition d'enregistrements sonores", Category.SUBCLASS),
        Classification("22.1J", "Autres activités d'édition", Category.SUBCLASS),
        Classification("22.2A", "Imprimerie de journaux", Category.SUBCLASS),
        Classification("22.2C", "Autre imprimerie (labeur)", Category.SUBCLASS),
        Classification("22.2E", "Reliure", Category.SUBCLASS),
        Classification("22.2G", "Activités de pré-presse", Category.SUBCLASS),
        Classification("22.2J", "Activités graphiques auxiliaires", Category.SUBCLASS),
        Classification("22.3A", "Reproduction d'enregistrements sonores", Category.SUBCLASS),
        Classification("22.3C", "Reproduction d'enregistrements vidéo", Category.SUBCLASS),
        Classification("22.3E", "Reproduction d'enregistrements informatiques", Category.SUBCLASS),
        Classification("23.1Z", "Cokéfaction", Category.SUBCLASS),
        Classification("23.2Z", "Raffinage de pétrole", Category.SUBCLASS),
        Classification("23.3Z", "Elaboration et transformation de matières nucléaires", Category.SUBCLASS),
        Classification("24.1A", "Fabrication de gaz industriels", Category.SUBCLASS),
        Classification("24.1C", "Fabrication de colorants et de pigments", Category.SUBCLASS),
        Classification("24.1E", "Fabrication d'autres produits chimiques inorganiques de base", Category.SUBCLASS),
        Classification("24.1G", "Fabrication d'autres produits chimiques organiques de base", Category.SUBCLASS),
        Classification("24.1J", "Fabrication de produits azotés et d'engrais", Category.SUBCLASS),
        Classification("24.1L", "Fabrication de matières plastiques de base", Category.SUBCLASS),
        Classification("24.1N", "Fabrication de caoutchouc synthétique", Category.SUBCLASS),
        Classification("24.2Z", "Fabrication de produits agrochimiques", Category.SUBCLASS),
        Classification("24.3Z", "Fabrication de peintures et vernis", Category.SUBCLASS),
        Classification("24.4A", "Fabrication de produits pharmaceutiques de base", Category.SUBCLASS),
        Classification("24.4C", "Fabrication de médicaments", Category.SUBCLASS),
        Classification("24.4D", "Fabrication d'autres produits pharmaceutiques", Category.SUBCLASS),
        Classification("24.5A", "Fabrication de savons, détergents et produits d'entretien", Category.SUBCLASS),
        Classification("24.5C", "Fabrication de parfums et de produits pour la toilette", Category.SUBCLASS),
        Classification("24.6A", "Fabrication de produits explosifs", Category.SUBCLASS),
        Classification("24.6C", "Fabrication de colles et gélatines", Category.SUBCLASS),
        Classification("24.6E", "Fabrication d'huiles essentielles", Category.SUBCLASS),
        Classification("24.6G", "Fabrication de produits chimiques pour la photographie", Category.SUBCLASS),
        Classification("24.6J", "Fabrication de supports de données", Category.SUBCLASS),
        Classification("24.6L", "Fabrication de produits chimiques à usage industriel", Category.SUBCLASS),
        Classification("24.7Z", "Fabrication de fibres artificielles ou synthétiques", Category.SUBCLASS),
        Classification("25.1A", "Fabrication de pneumatiques", Category.SUBCLASS),
        Classification("25.1C", "Rechapage de pneumatiques", Category.SUBCLASS),
        Classification("25.1E", "Fabrication d'autres articles en caoutchouc", Category.SUBCLASS),
        Classification(
            "25.2A", "Fabrication de plaques, feuilles, tubes et profilés en matières plastiques", Category.SUBCLASS
        ),
        Classification("25.2C", "Fabrication d'emballages en matières plastiques", Category.SUBCLASS),
        Classification(
            "25.2E", "Fabrication d'éléments en matières plastiques pour la construction", Category.SUBCLASS
        ),
        Classification("25.2G", "Fabrication d'articles divers en matières plastiques", Category.SUBCLASS),
        Classification("25.2H", "Fabrication de pièces techniques en matières plastiques", Category.SUBCLASS),
        Classification("26.1A", "Fabrication de verre plat", Category.SUBCLASS),
        Classification("26.1C", "Façonnage et transformation du verre plat", Category.SUBCLASS),
        Classification("26.1E", "Fabrication de verre creux", Category.SUBCLASS),
        Classification("26.1G", "Fabrication de fibres de verre", Category.SUBCLASS),
        Classification("26.1J", "Fabrication et façonnage d'articles techniques en verre", Category.SUBCLASS),
        Classification("26.1K", "Fabrication d'isolateurs en verre", Category.SUBCLASS),
        Classification(
            "26.2A", "Fabrication d'articles céramiques à usage domestique ou ornemental", Category.SUBCLASS
        ),
        Classification("26.2C", "Fabrication d'appareils sanitaires en céramique", Category.SUBCLASS),
        Classification("26.2E", "Fabrication d'isolateurs et pièces isolantes en céramique", Category.SUBCLASS),
        Classification("26.2G", "Fabrication d'autres produits céramiques à usage technique", Category.SUBCLASS),
        Classification("26.2J", "Fabrication d'autres produits céramiques", Category.SUBCLASS),
        Classification("26.2L", "Fabrication de produits céramiques réfractaires", Category.SUBCLASS),
        Classification("26.3Z", "Fabrication de carreaux en céramique", Category.SUBCLASS),
        Classification("26.4A", "Fabrication de briques", Category.SUBCLASS),
        Classification("26.4B", "Fabrication de tuiles", Category.SUBCLASS),
        Classification("26.4C", "Fabrication de produits divers en terre cuite", Category.SUBCLASS),
        Classification("26.5A", "Fabrication de ciment", Category.SUBCLASS),
        Classification("26.5C", "Fabrication de chaux", Category.SUBCLASS),
        Classification("26.5E", "Fabrication de plâtre", Category.SUBCLASS),
        Classification("26.6A", "Fabrication d'éléments en béton pour la construction", Category.SUBCLASS),
        Classification("26.6C", "Fabrication d'éléments en plâtre pour la construction", Category.SUBCLASS),
        Classification("26.6E", "Fabrication de béton prêt à l'emploi", Category.SUBCLASS),
        Classification("26.6G", "Fabrication de mortiers et bétons secs", Category.SUBCLASS),
        Classification("26.6J", "Fabrication d'ouvrages en fibre-ciment", Category.SUBCLASS),
        Classification("26.6L", "Fabrication d'autres ouvrages en béton ou en plâtre", Category.SUBCLASS),
        Classification(
            "26.7Z", "Taille, façonnage et finissage de pierres ornementales et de construction", Category.SUBCLASS
        ),
        Classification("26.8A", "Fabrication de produits abrasifs", Category.SUBCLASS),
        Classification("26.8C", "Fabrication de produits minéraux non métalliques n.c.a.", Category.SUBCLASS),
        Classification("27.1Y", "Sidérurgie", Category.SUBCLASS),
        Classification("27.2A", "Fabrication de tubes en fonte", Category.SUBCLASS),
        Classification("27.2C", "Fabrication de tubes en acier", Category.SUBCLASS),
        Classification("27.3A", "Etirage à froid", Category.SUBCLASS),
        Classification("27.3C", "Laminage à froid de feuillards", Category.SUBCLASS),
        Classification("27.3E", "Profilage à froid par formage ou pliage", Category.SUBCLASS),
        Classification("27.3G", "Tréfilage à froid", Category.SUBCLASS),
        Classification("27.4A", "Production de métaux précieux", Category.SUBCLASS),
        Classification("27.4C", "Production d'aluminium", Category.SUBCLASS),
        Classification("27.4D", "Première transformation de l'aluminium", Category.SUBCLASS),
        Classification("27.4F", "Production de plomb, de zinc ou d'étain", Category.SUBCLASS),
        Classification("27.4G", "Première transformation du plomb, du zinc ou de l'étain", Category.SUBCLASS),
        Classification("27.4J", "Production de cuivre", Category.SUBCLASS),
        Classification("27.4K", "Première transformation du cuivre", Category.SUBCLASS),
        Classification("27.4M", "Métallurgie des autres métaux non ferreux", Category.SUBCLASS),
        Classification("27.5A", "Fonderie de fonte", Category.SUBCLASS),
        Classification("27.5C", "Fonderie d'acier", Category.SUBCLASS),
        Classification("27.5E", "Fonderie de métaux légers", Category.SUBCLASS),
        Classification("27.5G", "Fonderie d'autres métaux non ferreux", Category.SUBCLASS),
        Classification("28.1A", "Fabrication de constructions métalliques", Category.SUBCLASS),
        Classification("28.1C", "Fabrication de menuiseries et fermetures métalliques", Category.SUBCLASS),
        Classification("28.2C", "Fabrication de réservoirs, citernes et conteneurs métalliques", Category.SUBCLASS),
        Classification(
            "28.2D", "Fabrication de radiateurs et de chaudières pour le chauffage central", Category.SUBCLASS
        ),
        Classification("28.3A", "Fabrication de générateurs de vapeur", Category.SUBCLASS),
        Classification("28.3B", "Chaudronnerie nucléaire", Category.SUBCLASS),
        Classification("28.3C", "Chaudronnerie-tuyauterie", Category.SUBCLASS),
        Classification("28.4A", "Forge, estampage, matriçage", Category.SUBCLASS),
        Classification("28.4B", "Découpage, emboutissage", Category.SUBCLASS),
        Classification("28.4C", "Métallurgie des poudres", Category.SUBCLASS),
        Classification("28.5A", "Traitement et revêtement des métaux", Category.SUBCLASS),
        Classification("28.5C", "Décolletage", Category.SUBCLASS),
        Classification("28.5D", "Mécanique générale", Category.SUBCLASS),
        Classification("28.6A", "Fabrication de coutellerie", Category.SUBCLASS),
        Classification("28.6C", "Fabrication d'outillage à main", Category.SUBCLASS),
        Classification("28.6D", "Fabrication d'outillage mécanique", Category.SUBCLASS),
        Classification("28.6F", "Fabrication de serrures et de ferrures", Category.SUBCLASS),
        Classification("28.7A", "Fabrication de fûts et emballages métalliques similaires", Category.SUBCLASS),
        Classification("28.7C", "Fabrication d'emballages métalliques légers", Category.SUBCLASS),
        Classification("28.7E", "Fabrication d'articles en fils métalliques", Category.SUBCLASS),
        Classification("28.7G", "Visserie et boulonnerie", Category.SUBCLASS),
        Classification("28.7H", "Fabrication de ressorts", Category.SUBCLASS),
        Classification("28.7J", "Fabrication de chaînes", Category.SUBCLASS),
        Classification("28.7L", "Fabrication d'articles métalliques ménagers", Category.SUBCLASS),
        Classification("28.7N", "Fabrication de petits articles métalliques", Category.SUBCLASS),
        Classification("28.7Q", "Fabrication d'articles métalliques divers", Category.SUBCLASS),
        Classification("29.1A", "Fabrication de moteurs et turbines", Category.SUBCLASS),
        Classification("29.1B", "Fabrication de pompes", Category.SUBCLASS),
        Classification("29.1D", "Fabrication de transmissions hydrauliques et pneumatiques", Category.SUBCLASS),
        Classification("29.1E", "Fabrication de compresseurs", Category.SUBCLASS),
        Classification("29.1F", "Fabrication d'articles de robinetterie", Category.SUBCLASS),
        Classification("29.1H", "Fabrication de roulements", Category.SUBCLASS),
        Classification("29.1J", "Fabrication d'organes mécaniques de transmission", Category.SUBCLASS),
        Classification("29.2A", "Fabrication de fours et brûleurs", Category.SUBCLASS),
        Classification("29.2C", "Fabrication d'ascenseurs, monte-charges et escaliers mécaniques", Category.SUBCLASS),
        Classification("29.2D", "Fabrication d'équipements de levage et de manutention", Category.SUBCLASS),
        Classification(
            "29.2F", "Fabrication d'équipements aérauliques et frigorifiques industriels", Category.SUBCLASS
        ),
        Classification("29.2H", "Fabrication d'équipements d'emballage et de conditionnement", Category.SUBCLASS),
        Classification("29.2J", "Fabrication d'appareils de pesage", Category.SUBCLASS),
        Classification("29.2L", "Fabrication de matériel pour les industries chimiques", Category.SUBCLASS),
        Classification("29.2M", "Fabrication d'autres machines d'usage général", Category.SUBCLASS),
        Classification("29.3A", "Fabrication de tracteurs agricoles", Category.SUBCLASS),
        Classification("29.3C", "Réparation de matériel agricole", Category.SUBCLASS),
        Classification("29.3D", "Fabrication de matériel agricole", Category.SUBCLASS),
        Classification("29.4A", "Fabrication de machines-outils à métaux", Category.SUBCLASS),
        Classification("29.4B", "Fabrication de machines-outils à bois", Category.SUBCLASS),
        Classification("29.4C", "Fabrication de machines-outils portatives à moteur incorporé", Category.SUBCLASS),
        Classification("29.4D", "Fabrication de matériel de soudage", Category.SUBCLASS),
        Classification("29.4E", "Fabrication d'autres machines-outils", Category.SUBCLASS),
        Classification("29.5A", "Fabrication de machines pour la métallurgie", Category.SUBCLASS),
        Classification("29.5B", "Fabrication de matériels de mines pour l'extraction", Category.SUBCLASS),
        Classification("29.5D", "Fabrication de matériels de travaux publics", Category.SUBCLASS),
        Classification("29.5E", "Fabrication de machines pour l'industrie agroalimentaire", Category.SUBCLASS),
        Classification("29.5G", "Fabrication de machines pour les industries textiles", Category.SUBCLASS),
        Classification(
            "29.5J", "Fabrication de machines pour les industries du papier et du carton", Category.SUBCLASS
        ),
        Classification("29.5L", "Fabrication de machines d'imprimerie", Category.SUBCLASS),
        Classification(
            "29.5M", "Fabrication de machines pour le travail du caoutchouc ou des plastiques", Category.SUBCLASS
        ),
        Classification("29.5N", "Fabrication de moules et modèles", Category.SUBCLASS),
        Classification("29.5Q", "Fabrication de machines d'assemblage automatique", Category.SUBCLASS),
        Classification("29.5R", "Fabrication machines spécialisées diverses", Category.SUBCLASS),
        Classification("29.6A", "Fabrication d'armement", Category.SUBCLASS),
        Classification("29.6B", "Fabrication d'armes de chasse, de tir et de défense", Category.SUBCLASS),
        Classification("29.7A", "Fabrication d'appareils électroménagers", Category.SUBCLASS),
        Classification("29.7C", "Fabrication d'appareils ménagers non électriques", Category.SUBCLASS),
        Classification("30.0A", "Fabrication de machines de bureau", Category.SUBCLASS),
        Classification("30.0C", "Fabrication d'ordinateurs et d'autres équipements informatiques", Category.SUBCLASS),
        Classification(
            "31.1A",
            "Fabrication de moteurs, génératrices et transformateurs électriques de petite et moyenne puissance",
            Category.SUBCLASS,
        ),
        Classification(
            "31.1B",
            "Fabrication de moteurs, génératrices et transformateurs électriques de grande puissance",
            Category.SUBCLASS,
        ),
        Classification("31.1C", "Réparation de matériels électriques", Category.SUBCLASS),
        Classification(
            "31.2A",
            "Fabrication de matériel de distribution et de commande électrique pour basse tension",
            Category.SUBCLASS,
        ),
        Classification(
            "31.2B",
            "Fabrication de matériel de distribution et de commande électrique pour haute tension",
            Category.SUBCLASS,
        ),
        Classification("31.3Z", "Fabrication de fils et câbles isolés", Category.SUBCLASS),
        Classification("31.4Z", "Fabrication d'accumulateurs et de piles électriques", Category.SUBCLASS),
        Classification("31.5A", "Fabrication de lampes", Category.SUBCLASS),
        Classification("31.5B", "Fabrication d'appareils électriques autonomes de sécurité", Category.SUBCLASS),
        Classification("31.5C", "Fabrication d'appareils d'éclairage", Category.SUBCLASS),
        Classification("31.6A", "Fabrication de matériels électriques pour moteurs et véhicules", Category.SUBCLASS),
        Classification("31.6C", "Fabrication de matériel électromagnétique industriel", Category.SUBCLASS),
        Classification("31.6D", "Fabrication de matériels électriques n.c.a.", Category.SUBCLASS),
        Classification("32.1A", "Fabrication de composants passifs et de condensateurs", Category.SUBCLASS),
        Classification("32.1C", "Fabrication de composants électroniques actifs", Category.SUBCLASS),
        Classification("32.1D", "Assemblage de cartes électroniques pour compte de tiers", Category.SUBCLASS),
        Classification(
            "32.2A", "Fabrication d'équipements d'émission et de transmission hertzienne", Category.SUBCLASS
        ),
        Classification("32.2B", "Fabrication d'appareils de téléphonie", Category.SUBCLASS),
        Classification(
            "32.3Z",
            "Fabrication d'appareils de réception, enregistrement ou reproduction du son et de l'image",
            Category.SUBCLASS,
        ),
        Classification("33.1A", "Fabrication de matériel d'imagerie médicale et de radiologie", Category.SUBCLASS),
        Classification("33.1B", "Fabrication d'appareils médicochirurgicaux", Category.SUBCLASS),
        Classification("33.2A", "Fabrication d'équipements d'aide à la navigation", Category.SUBCLASS),
        Classification("33.2B", "Fabrication d'instrumentation scientifique et technique", Category.SUBCLASS),
        Classification("33.3Z", "Fabrication d'équipements de contrôle des processus industriels", Category.SUBCLASS),
        Classification("33.4A", "Fabrication de lunettes", Category.SUBCLASS),
        Classification("33.4B", "Fabrication d'instruments d'optique et de matériel photographique", Category.SUBCLASS),
        Classification("33.5Z", "Horlogerie", Category.SUBCLASS),
        Classification("34.1Z", "Construction de véhicules automobiles", Category.SUBCLASS),
        Classification("34.2A", "Fabrication de carrosseries automobiles", Category.SUBCLASS),
        Classification("34.2B", "Fabrications de caravanes et véhicules de loisirs", Category.SUBCLASS),
        Classification("34.3Z", "Fabrication d'équipements automobiles", Category.SUBCLASS),
        Classification("35.1A", "Construction de bâtiments de guerre", Category.SUBCLASS),
        Classification("35.1B", "Construction de navires civils", Category.SUBCLASS),
        Classification("35.1C", "Réparation navale", Category.SUBCLASS),
        Classification("35.1E", "Construction de bateaux de plaisance", Category.SUBCLASS),
        Classification("35.2Z", "Construction de matériel ferroviaire roulant", Category.SUBCLASS),
        Classification("35.3A", "Construction de moteurs pour aéronefs", Category.SUBCLASS),
        Classification("35.3B", "Construction de cellules d'aéronefs", Category.SUBCLASS),
        Classification("35.3C", "Construction de lanceurs et engins spatiaux", Category.SUBCLASS),
        Classification("35.4A", "Fabrication de motocycles", Category.SUBCLASS),
        Classification("35.4C", "Fabrication de bicyclettes", Category.SUBCLASS),
        Classification("35.4E", "Fabrication de véhicules pour invalides", Category.SUBCLASS),
        Classification("35.5Z", "Fabrication de matériels de transport n.c.a.", Category.SUBCLASS),
        Classification("36.1A", "Fabrication de sièges", Category.SUBCLASS),
        Classification("36.1C", "Fabrication de meubles de bureau et de magasin", Category.SUBCLASS),
        Classification("36.1E", "Fabrication de meubles de cuisine", Category.SUBCLASS),
        Classification("36.1G", "Fabrication de meubles meublants", Category.SUBCLASS),
        Classification("36.1H", "Fabrication de meubles de jardin et d'extérieur", Category.SUBCLASS),
        Classification("36.1J", "Fabrication de meubles n.c.a.", Category.SUBCLASS),
        Classification("36.1K", "Industries connexes de l'ameublement", Category.SUBCLASS),
        Classification("36.1M", "Fabrication de matelas", Category.SUBCLASS),
        Classification("36.2A", "Fabrication de monnaies", Category.SUBCLASS),
        Classification("36.2C", "Bijouterie, joaillerie, orfèvrerie", Category.SUBCLASS),
        Classification("36.3Z", "Fabrication d'instruments de musique", Category.SUBCLASS),
        Classification("36.4Z", "Fabrication d'articles de sport", Category.SUBCLASS),
        Classification("36.5Z", "Fabrication de jeux et jouets", Category.SUBCLASS),
        Classification("36.6A", "Bijouterie fantaisie", Category.SUBCLASS),
        Classification("36.6C", "Industrie de la brosserie", Category.SUBCLASS),
        Classification("36.6E", "Autres activités manufacturières n.c.a.", Category.SUBCLASS),
        Classification("37.1Z", "Récupération de matières métalliques recyclables", Category.SUBCLASS),
        Classification("37.2Z", "Récupération de matières non métalliques recyclables", Category.SUBCLASS),
        Classification("40.1A", "Production d'électricité", Category.SUBCLASS),
        Classification("40.1C", "Transport d'électricité", Category.SUBCLASS),
        Classification("40.1E", "Distribution et commerce d'électricité", Category.SUBCLASS),
        Classification("40.2A", "Production de combustible gazeux", Category.SUBCLASS),
        Classification("40.2C", "Distribution de combustibles gazeux", Category.SUBCLASS),
        Classification("40.3Z", "Production et distribution de chaleur", Category.SUBCLASS),
        Classification("41.0Z", "Captage, traitement et distribution d'eau", Category.SUBCLASS),
        Classification("45.1A", "Terrassements divers, démolition", Category.SUBCLASS),
        Classification("45.1B", "Terrassements en grande masse", Category.SUBCLASS),
        Classification("45.1D", "Forages et sondages", Category.SUBCLASS),
        Classification("45.2A", "Construction de maisons individuelles", Category.SUBCLASS),
        Classification("45.2B", "Construction de bâtiments divers", Category.SUBCLASS),
        Classification("45.2C", "Construction d'ouvrages d'art", Category.SUBCLASS),
        Classification("45.2D", "Travaux souterrains", Category.SUBCLASS),
        Classification("45.2E", "Réalisation de réseaux", Category.SUBCLASS),
        Classification("45.2F", "Construction de lignes électriques et de télécommunication", Category.SUBCLASS),
        Classification("45.2J", "Réalisation de couvertures par éléments", Category.SUBCLASS),
        Classification("45.2K", "Travaux d'étanchéification", Category.SUBCLASS),
        Classification("45.2L", "Travaux de charpente", Category.SUBCLASS),
        Classification("45.2N", "Construction de voies ferrées", Category.SUBCLASS),
        Classification("45.2P", "Construction de chaussées routières et de sols sportifs", Category.SUBCLASS),
        Classification("45.2R", "Travaux maritimes et fluviaux", Category.SUBCLASS),
        Classification("45.2T", "Levage, montage", Category.SUBCLASS),
        Classification("45.2U", "Autres travaux spécialisés de construction", Category.SUBCLASS),
        Classification("45.2V", "Travaux de maçonnerie générale", Category.SUBCLASS),
        Classification("45.3A", "Travaux d'installation électrique", Category.SUBCLASS),
        Classification("45.3C", "Travaux d'isolation", Category.SUBCLASS),
        Classification("45.3E", "Installation d'eau et de gaz", Category.SUBCLASS),
        Classification("45.3F", "Installation d'équipements thermiques et de climatisation", Category.SUBCLASS),
        Classification("45.3H", "Autres travaux d'installation", Category.SUBCLASS),
        Classification("45.4A", "Plâtrerie", Category.SUBCLASS),
        Classification("45.4C", "Menuiserie bois et matières plastiques", Category.SUBCLASS),
        Classification("45.4D", "Menuiserie métallique ; serrurerie", Category.SUBCLASS),
        Classification("45.4F", "Revêtement des sols et des murs", Category.SUBCLASS),
        Classification("45.4H", "Miroiterie de bâtiment, vitrerie", Category.SUBCLASS),
        Classification("45.4J", "Peinture", Category.SUBCLASS),
        Classification("45.4L", "Agencement de lieux de vente", Category.SUBCLASS),
        Classification("45.4M", "Travaux de finition n.c.a.", Category.SUBCLASS),
        Classification("45.5Z", "Location avec opérateur de matériel de construction", Category.SUBCLASS),
        Classification("50.1Z", "Commerce de véhicules automobiles", Category.SUBCLASS),
        Classification("50.2Z", "Entretien et réparation de véhicules automobiles", Category.SUBCLASS),
        Classification("50.3A", "Commerce de gros d'équipements automobiles", Category.SUBCLASS),
        Classification("50.3B", "Commerce de détail d'équipements automobiles", Category.SUBCLASS),
        Classification("50.4Z", "Commerce et réparation de motocycles", Category.SUBCLASS),
        Classification("50.5Z", "Commerce de détail de carburants", Category.SUBCLASS),
        Classification(
            "51.1A",
            "Intermédiaires du commerce en matières premières agricoles, animaux vivants, matières premières textiles et demi-produits",
            Category.SUBCLASS,
        ),
        Classification(
            "51.1C",
            "Intermédiaires du commerce en combustibles, métaux, minéraux et produits chimiques",
            Category.SUBCLASS,
        ),
        Classification("51.1E", "Intermédiaires du commerce en bois et matériaux de construction", Category.SUBCLASS),
        Classification(
            "51.1G",
            "Intermédiaires du commerce en machines, équipements industriels, navires et avions",
            Category.SUBCLASS,
        ),
        Classification(
            "51.1J", "Intermédiaires du commerce en meubles, articles de ménage et quincaillerie", Category.SUBCLASS
        ),
        Classification(
            "51.1L",
            "Intermédiaires du commerce en textiles, habillement, chaussures et articles en cuir",
            Category.SUBCLASS,
        ),
        Classification("51.1N", "Intermédiaires du commerce en produits alimentaires", Category.SUBCLASS),
        Classification("51.1P", "Centrales d'achats alimentaires", Category.SUBCLASS),
        Classification("51.1R", "Autres intermédiaires spécialisés du commerce", Category.SUBCLASS),
        Classification("51.1T", "Intermédiaires non spécialisés du commerce", Category.SUBCLASS),
        Classification("51.1U", "Centrales d'achats non alimentaires", Category.SUBCLASS),
        Classification("51.2A", "Commerce de gros de céréales et aliments pour le bétail", Category.SUBCLASS),
        Classification("51.2C", "Commerce de gros de fleurs et plantes", Category.SUBCLASS),
        Classification("51.2E", "Commerce de gros d'animaux vivants", Category.SUBCLASS),
        Classification("51.2G", "Commerce de gros de cuirs et peaux", Category.SUBCLASS),
        Classification("51.2J", "Commerce de gros de tabac non manufacturé", Category.SUBCLASS),
        Classification("51.3A", "Commerce de gros de fruits et légumes", Category.SUBCLASS),
        Classification("51.3C", "Commerce de gros de viandes de boucherie", Category.SUBCLASS),
        Classification("51.3D", "Commerce de gros de produits à base de viande", Category.SUBCLASS),
        Classification("51.3E", "Commerce de gros de volailles et gibiers", Category.SUBCLASS),
        Classification("51.3G", "Commerce de gros de produits laitiers, oeufs, huiles", Category.SUBCLASS),
        Classification("51.3J", "Commerce de gros de boissons", Category.SUBCLASS),
        Classification("51.3L", "Commerce de gros de tabac", Category.SUBCLASS),
        Classification("51.3N", "Commerce de gros de sucre, chocolat et confiserie", Category.SUBCLASS),
        Classification("51.3Q", "Commerce de gros de café, thé, cacao et épices", Category.SUBCLASS),
        Classification("51.3S", "Commerce de gros de poissons, crustacés et mollusques", Category.SUBCLASS),
        Classification("51.3T", "Commerces de gros alimentaires spécialisés divers", Category.SUBCLASS),
        Classification("51.3V", "Commerce de gros de produits surgelés", Category.SUBCLASS),
        Classification("51.3W", "Commerce de gros alimentaire non spécialisé", Category.SUBCLASS),
        Classification("51.4A", "Commerce de gros de textiles", Category.SUBCLASS),
        Classification("51.4C", "Commerce de gros d'habillement", Category.SUBCLASS),
        Classification("51.4D", "Commerce de gros de la chaussure", Category.SUBCLASS),
        Classification(
            "51.4F", "Commerce de gros d'appareils électroménagers et de radios et télévisions", Category.SUBCLASS
        ),
        Classification("51.4H", "Commerce de gros de vaisselle et verrerie de ménage", Category.SUBCLASS),
        Classification(
            "51.4J", "Commerce de gros de produits pour l'entretien et l'aménagement de l'habitat", Category.SUBCLASS
        ),
        Classification("51.4L", "Commerce de gros de parfumerie et de produits de beauté", Category.SUBCLASS),
        Classification("51.4N", "Commerce de gros de produits pharmaceutiques", Category.SUBCLASS),
        Classification("51.4Q", "Commerce de gros de papeterie", Category.SUBCLASS),
        Classification("51.4R", "Commerce de gros de jouets", Category.SUBCLASS),
        Classification("51.4S", "Autres commerces de gros de biens de consommation", Category.SUBCLASS),
        Classification("51.5A", "Commerce de gros de combustibles", Category.SUBCLASS),
        Classification("51.5C", "Commerce de gros de minerais et métaux", Category.SUBCLASS),
        Classification("51.5E", "Commerce de gros de bois et de produits dérivés", Category.SUBCLASS),
        Classification(
            "51.5F", "Commerce de gros de matériaux de construction et d'appareils sanitaires", Category.SUBCLASS
        ),
        Classification("51.5H", "Commerce de gros de quincaillerie", Category.SUBCLASS),
        Classification("51.5J", "Commerce de gros de fournitures pour plomberie et chauffage", Category.SUBCLASS),
        Classification("51.5L", "Commerce de gros de produits chimiques", Category.SUBCLASS),
        Classification("51.5N", "Commerce de gros d'autres produits intermédiaires", Category.SUBCLASS),
        Classification("51.5Q", "Commerce de gros de déchets et débris", Category.SUBCLASS),
        Classification("51.8A", "Commerce de gros de machines-outils", Category.SUBCLASS),
        Classification(
            "51.8C",
            "Commerce de gros de machines pour l'extraction, la construction et le génie civil",
            Category.SUBCLASS,
        ),
        Classification(
            "51.8E", "Commerce de gros de machines pour l'industrie textile et l'habillement", Category.SUBCLASS
        ),
        Classification(
            "51.8G",
            "Commerce de gros d'ordinateurs, d'équipements informatiques périphériques et de progiciels",
            Category.SUBCLASS,
        ),
        Classification("51.8H", "Commerce de gros d'autres machines et équipements de bureau", Category.SUBCLASS),
        Classification(
            "51.8J", "Commerce de gros de composants et d'autres équipements électroniques", Category.SUBCLASS
        ),
        Classification("51.8L", "Commerce de gros de matériel électrique", Category.SUBCLASS),
        Classification("51.8M", "Commerce de gros de fournitures et équipements industriels divers", Category.SUBCLASS),
        Classification(
            "51.8N",
            "Commerce de gros de fournitures et équipements divers pour le commerce et les services",
            Category.SUBCLASS,
        ),
        Classification("51.8P", "Commerce de gros de matériel agricole", Category.SUBCLASS),
        Classification("51.9A", "Autres commerces de gros spécialisés", Category.SUBCLASS),
        Classification("51.9B", "Commerce de gros non spécialisé", Category.SUBCLASS),
        Classification("52.1A", "Commerce de détail de produits surgelés", Category.SUBCLASS),
        Classification("52.1B", "Commerce d'alimentation générale", Category.SUBCLASS),
        Classification("52.1C", "Supérettes", Category.SUBCLASS),
        Classification("52.1D", "Supermarchés", Category.SUBCLASS),
        Classification("52.1E", "Magasins populaires", Category.SUBCLASS),
        Classification("52.1F", "Hypermarchés", Category.SUBCLASS),
        Classification("52.1H", "Grands magasins", Category.SUBCLASS),
        Classification("52.1J", "Autres commerces de détail en magasin non spécialisé", Category.SUBCLASS),
        Classification("52.2A", "Commerce de détail de fruits et légumes", Category.SUBCLASS),
        Classification("52.2C", "Commerce de détail de viandes et produits à base de viande", Category.SUBCLASS),
        Classification("52.2E", "Commerce de détail de poissons, crustacés et mollusques", Category.SUBCLASS),
        Classification("52.2G", "Commerce de détail de pain, pâtisserie et confiserie", Category.SUBCLASS),
        Classification("52.2J", "Commerce de détail de boissons", Category.SUBCLASS),
        Classification("52.2L", "Commerce de détail de tabac", Category.SUBCLASS),
        Classification("52.2N", "Commerce de détail de produits laitiers", Category.SUBCLASS),
        Classification("52.2P", "Commerces de détail alimentaires spécialisés divers", Category.SUBCLASS),
        Classification("52.3A", "Commerce de détail de produits pharmaceutiques", Category.SUBCLASS),
        Classification("52.3C", "Commerce de détail d'articles médicaux et orthopédiques", Category.SUBCLASS),
        Classification("52.3E", "Commerce de détail de parfumerie et de produits de beauté", Category.SUBCLASS),
        Classification("52.4A", "Commerce de détail de textiles", Category.SUBCLASS),
        Classification("52.4C", "Commerce de détail d'habillement", Category.SUBCLASS),
        Classification("52.4E", "Commerce de détail de la chaussure", Category.SUBCLASS),
        Classification("52.4F", "Commerce de détail de maroquinerie et d'articles de voyage", Category.SUBCLASS),
        Classification("52.4H", "Commerce de détail de meubles", Category.SUBCLASS),
        Classification("52.4J", "Commerce de détail d'équipement du foyer", Category.SUBCLASS),
        Classification(
            "52.4L", "Commerce de détail d'appareils électroménagers, de radio et de télévision", Category.SUBCLASS
        ),
        Classification("52.4N", "Commerce de détail de quincaillerie", Category.SUBCLASS),
        Classification("52.4P", "Commerce de détail de bricolage", Category.SUBCLASS),
        Classification("52.4R", "Commerce de détail de livres, journaux et papeterie", Category.SUBCLASS),
        Classification("52.4T", "Commerce de détail d'optique et de photographie", Category.SUBCLASS),
        Classification("52.4U", "Commerce de détail de revêtements de sols et de murs", Category.SUBCLASS),
        Classification("52.4V", "Commerce de détail d'horlogerie et de bijouterie", Category.SUBCLASS),
        Classification("52.4W", "Commerce de détail d'articles de sport et de loisir", Category.SUBCLASS),
        Classification("52.4X", "Commerce de détail de fleurs", Category.SUBCLASS),
        Classification("52.4Y", "Commerce de détail de charbons et combustibles", Category.SUBCLASS),
        Classification("52.4Z", "Commerces de détail divers en magasin spécialisé", Category.SUBCLASS),
        Classification("52.5Z", "Commerce de détail de biens d'occasion", Category.SUBCLASS),
        Classification("52.6A", "Vente par correspondance sur catalogue général", Category.SUBCLASS),
        Classification("52.6B", "Vente par correspondance spécialisée", Category.SUBCLASS),
        Classification("52.6D", "Commerce de détail alimentaire sur éventaires et marchés", Category.SUBCLASS),
        Classification("52.6E", "Commerce de détail non alimentaire sur éventaires et marchés", Category.SUBCLASS),
        Classification("52.6G", "Vente à domicile", Category.SUBCLASS),
        Classification("52.6H", "Vente par automate", Category.SUBCLASS),
        Classification("52.7A", "Réparation de chaussures et d'articles en cuir", Category.SUBCLASS),
        Classification("52.7C", "Réparation de matériel électronique grand public", Category.SUBCLASS),
        Classification("52.7D", "Réparation d'appareils électroménagers", Category.SUBCLASS),
        Classification("52.7F", "Réparation de montres, horloges et bijoux", Category.SUBCLASS),
        Classification("52.7H", "Réparation d'articles personnels et domestiques n.c.a.", Category.SUBCLASS),
        Classification("55.1A", "Hôtels touristiques avec restaurant", Category.SUBCLASS),
        Classification("55.1C", "Hôtels touristiques sans restaurant", Category.SUBCLASS),
        Classification("55.1E", "Autres hôtels", Category.SUBCLASS),
        Classification("55.2A", "Auberges de jeunesse et refuges", Category.SUBCLASS),
        Classification("55.2C", "Exploitation de terrains de camping", Category.SUBCLASS),
        Classification("55.2E", "Autre hébergement touristique", Category.SUBCLASS),
        Classification("55.2F", "Hébergement collectif non touristique", Category.SUBCLASS),
        Classification("55.3A", "Restauration de type traditionnel", Category.SUBCLASS),
        Classification("55.3B", "Restauration de type rapide", Category.SUBCLASS),
        Classification("55.4A", "Cafés tabacs", Category.SUBCLASS),
        Classification("55.4B", "Débits de boissons", Category.SUBCLASS),
        Classification("55.4C", "Discothèques", Category.SUBCLASS),
        Classification("55.5A", "Cantines et restaurants d'entreprises", Category.SUBCLASS),
        Classification("55.5C", "Restauration collective sous contrat", Category.SUBCLASS),
        Classification("55.5D", "Traiteurs, organisation de réceptions", Category.SUBCLASS),
        Classification("60.1Z", "Transports ferroviaires", Category.SUBCLASS),
        Classification("60.2A", "Transports urbains de voyageurs", Category.SUBCLASS),
        Classification("60.2B", "Transports routiers réguliers de voyageurs", Category.SUBCLASS),
        Classification("60.2C", "Téléphériques, remontées mécaniques", Category.SUBCLASS),
        Classification("60.2E", "Transport de voyageurs par taxis", Category.SUBCLASS),
        Classification("60.2G", "Autres transports routiers de voyageurs", Category.SUBCLASS),
        Classification("60.2L", "Transports routiers de marchandises de proximité", Category.SUBCLASS),
        Classification("60.2M", "Transports routiers de marchandises interurbains", Category.SUBCLASS),
        Classification("60.2N", "Déménagement", Category.SUBCLASS),
        Classification("60.2P", "Location de camions avec conducteur", Category.SUBCLASS),
        Classification("60.3Z", "Transports par conduites", Category.SUBCLASS),
        Classification("61.1A", "Transports maritimes", Category.SUBCLASS),
        Classification("61.1B", "Transports côtiers", Category.SUBCLASS),
        Classification("61.2Z", "Transports fluviaux", Category.SUBCLASS),
        Classification("62.1Z", "Transports aériens réguliers", Category.SUBCLASS),
        Classification("62.2Z", "Transports aériens non réguliers", Category.SUBCLASS),
        Classification("62.3Z", "Transports spatiaux", Category.SUBCLASS),
        Classification("63.1A", "Manutention portuaire", Category.SUBCLASS),
        Classification("63.1B", "Manutention non portuaire", Category.SUBCLASS),
        Classification("63.1D", "Entreposage frigorifique", Category.SUBCLASS),
        Classification("63.1E", "Entreposage non frigorifique", Category.SUBCLASS),
        Classification("63.2A", "Gestion d'infrastructures de transports terrestres", Category.SUBCLASS),
        Classification("63.2C", "Services portuaires, maritimes et fluviaux", Category.SUBCLASS),
        Classification("63.2E", "Services aéroportuaires", Category.SUBCLASS),
        Classification("63.3Z", "Agences de voyage", Category.SUBCLASS),
        Classification("63.4A", "Messagerie, fret express", Category.SUBCLASS),
        Classification("63.4B", "Affrètement", Category.SUBCLASS),
        Classification("63.4C", "Organisation des transports internationaux", Category.SUBCLASS),
        Classification("64.1A", "Postes nationales", Category.SUBCLASS),
        Classification("64.1C", "Autres activités de courrier", Category.SUBCLASS),
        Classification("64.2C", "Télécommunications (hors transmissions audiovisuelles)", Category.SUBCLASS),
        Classification("64.2D", "Transmission d'émissions de radio et de télévision", Category.SUBCLASS),
        Classification("65.1A", "Banque centrale", Category.SUBCLASS),
        Classification("65.1C", "Banques", Category.SUBCLASS),
        Classification("65.1D", "Banques mutualistes", Category.SUBCLASS),
        Classification("65.1E", "Caisses d'épargne", Category.SUBCLASS),
        Classification("65.1F", "Intermédiations monétaires n.c.a.", Category.SUBCLASS),
        Classification("65.2A", "Crédit-bail", Category.SUBCLASS),
        Classification("65.2C", "Distribution de crédit", Category.SUBCLASS),
        Classification("65.2E", "Organismes de placement en valeurs mobilières", Category.SUBCLASS),
        Classification("65.2F", "Intermédiations financières diverses", Category.SUBCLASS),
        Classification("66.0A", "Assurance-vie et capitalisation", Category.SUBCLASS),
        Classification("66.0C", "Caisses de retraite", Category.SUBCLASS),
        Classification("66.0E", "Assurance dommages", Category.SUBCLASS),
        Classification("66.0F", "Réassurance", Category.SUBCLASS),
        Classification("66.0G", "Assurance relevant du code de la mutualité", Category.SUBCLASS),
        Classification("67.1A", "Administration de marchés financiers", Category.SUBCLASS),
        Classification("67.1C", "Gestion de portefeuilles", Category.SUBCLASS),
        Classification("67.1E", "Autres auxiliaires financiers", Category.SUBCLASS),
        Classification("67.2Z", "Auxiliaires d'assurance", Category.SUBCLASS),
        Classification("70.1A", "Promotion immobilière de logements", Category.SUBCLASS),
        Classification("70.1B", "Promotion immobilière de bureaux", Category.SUBCLASS),
        Classification("70.1C", "Promotion immobilière d'infrastructures", Category.SUBCLASS),
        Classification("70.1D", "Supports juridiques de programme", Category.SUBCLASS),
        Classification("70.1F", "Marchands de biens immobiliers", Category.SUBCLASS),
        Classification("70.2A", "Location de logements", Category.SUBCLASS),
        Classification("70.2B", "Location de terrains", Category.SUBCLASS),
        Classification("70.2C", "Location d'autres biens immobiliers", Category.SUBCLASS),
        Classification("70.3A", "Agences immobilières", Category.SUBCLASS),
        Classification("70.3C", "Administration d'immeubles résidentiels", Category.SUBCLASS),
        Classification("70.3D", "Administration d'autres biens immobiliers", Category.SUBCLASS),
        Classification("70.3E", "Supports juridiques de gestion de patrimoine", Category.SUBCLASS),
        Classification("71.1A", "Location de courte durée de véhicules automobiles", Category.SUBCLASS),
        Classification("71.1B", "Location de longue durée de véhicules automobiles", Category.SUBCLASS),
        Classification("71.2A", "Location d'autres matériels de transport terrestre", Category.SUBCLASS),
        Classification("71.2C", "Location de matériels de transport par eau", Category.SUBCLASS),
        Classification("71.2E", "Location d'appareils de transport aérien", Category.SUBCLASS),
        Classification("71.3A", "Location de matériel agricole", Category.SUBCLASS),
        Classification("71.3C", "Location de machines et équipements pour la construction", Category.SUBCLASS),
        Classification("71.3E", "Location de machines de bureau et de matériel informatique", Category.SUBCLASS),
        Classification("71.3G", "Location de machines et équipements divers", Category.SUBCLASS),
        Classification("71.4A", "Location de linge", Category.SUBCLASS),
        Classification("71.4B", "Location d'autres biens personnels et domestiques", Category.SUBCLASS),
        Classification("72.1Z", "Conseil en systèmes informatiques", Category.SUBCLASS),
        Classification("72.2A", "Edition de logiciels (non personnalisés)", Category.SUBCLASS),
        Classification("72.2C", "Autres activités de réalisation de logiciels", Category.SUBCLASS),
        Classification("72.3Z", "Traitement de données", Category.SUBCLASS),
        Classification("72.4Z", "Activités de banques de données", Category.SUBCLASS),
        Classification(
            "72.5Z", "Entretien et réparation de machines de bureau et de matériel informatique", Category.SUBCLASS
        ),
        Classification("72.6Z", "Autres activités rattachées à l'informatique", Category.SUBCLASS),
        Classification("73.1Z", "Recherche-développement en sciences physiques et naturelles", Category.SUBCLASS),
        Classification("73.2Z", "Recherche-développement en sciences humaines et sociales", Category.SUBCLASS),
        Classification("74.1A", "Activités juridiques", Category.SUBCLASS),
        Classification("74.1C", "Activités comptables", Category.SUBCLASS),
        Classification("74.1E", "Etudes de marché et sondages", Category.SUBCLASS),
        Classification("74.1G", "Conseil pour les affaires et la gestion", Category.SUBCLASS),
        Classification("74.1J", "Administration d'entreprises", Category.SUBCLASS),
        Classification("74.2A", "Activités d'architecture", Category.SUBCLASS),
        Classification("74.2B", "Métreurs, géomètres", Category.SUBCLASS),
        Classification("74.2C", "Ingénierie, études techniques", Category.SUBCLASS),
        Classification("74.3A", "Contrôle technique automobile", Category.SUBCLASS),
        Classification("74.3B", "Analyses, essais et inspections techniques", Category.SUBCLASS),
        Classification("74.4A", "Gestion de supports de publicité", Category.SUBCLASS),
        Classification("74.4B", "Agences, conseil en publicité", Category.SUBCLASS),
        Classification("74.5A", "Sélection et mise à disposition de personnel", Category.SUBCLASS),
        Classification("74.5B", "Travail temporaire", Category.SUBCLASS),
        Classification("74.6Z", "Enquêtes et sécurité", Category.SUBCLASS),
        Classification("74.7Z", "Activités de nettoyage", Category.SUBCLASS),
        Classification("74.8A", "Studios et autres activités photographiques", Category.SUBCLASS),
        Classification("74.8B", "Laboratoires techniques de développement et de tirage", Category.SUBCLASS),
        Classification("74.8D", "Conditionnement à façon", Category.SUBCLASS),
        Classification("74.8F", "Secrétariat et traduction", Category.SUBCLASS),
        Classification("74.8G", "Routage", Category.SUBCLASS),
        Classification("74.8H", "Centres d'appel", Category.SUBCLASS),
        Classification("74.8J", "Organisation de foires et salons", Category.SUBCLASS),
        Classification("74.8K", "Services annexes à la production", Category.SUBCLASS),
        Classification("75.1A", "Administration publique générale", Category.SUBCLASS),
        Classification("75.1C", "Tutelle des activités sociales", Category.SUBCLASS),
        Classification("75.1E", "Tutelle des activités économiques", Category.SUBCLASS),
        Classification("75.1G", "Activités de soutien aux administrations", Category.SUBCLASS),
        Classification("75.2A", "Affaires étrangères", Category.SUBCLASS),
        Classification("75.2C", "Défense", Category.SUBCLASS),
        Classification("75.2E", "Justice", Category.SUBCLASS),
        Classification("75.2G", "Police", Category.SUBCLASS),
        Classification("75.2J", "Protection civile", Category.SUBCLASS),
        Classification("75.3A", "Activités générales de sécurité sociale", Category.SUBCLASS),
        Classification("75.3B", "Gestion des retraites complémentaires", Category.SUBCLASS),
        Classification("75.3C", "Distribution sociale de revenus", Category.SUBCLASS),
        Classification("80.1Z", "Enseignement primaire", Category.SUBCLASS),
        Classification("80.2A", "Enseignement secondaire général", Category.SUBCLASS),
        Classification("80.2C", "Enseignement secondaire technique ou professionnel", Category.SUBCLASS),
        Classification("80.3Z", "Enseignement supérieur", Category.SUBCLASS),
        Classification("80.4A", "Ecoles de conduite", Category.SUBCLASS),
        Classification("80.4C", "Formation des adultes et formation continue", Category.SUBCLASS),
        Classification("80.4D", "Autres enseignements", Category.SUBCLASS),
        Classification("85.1A", "Activités hospitalières", Category.SUBCLASS),
        Classification("85.1C", "Pratique médicale", Category.SUBCLASS),
        Classification("85.1E", "Pratique dentaire", Category.SUBCLASS),
        Classification("85.1G", "Activités des auxiliaires médicaux", Category.SUBCLASS),
        Classification("85.1H", "Soins hors d'un cadre réglementé", Category.SUBCLASS),
        Classification("85.1J", "Ambulances", Category.SUBCLASS),
        Classification("85.1K", "Laboratoires d'analyses médicales", Category.SUBCLASS),
        Classification("85.1L", "Centres de collecte et banques d'organes", Category.SUBCLASS),
        Classification("85.2Z", "Activités vétérinaires", Category.SUBCLASS),
        Classification("85.3A", "Accueil des enfants handicapés", Category.SUBCLASS),
        Classification("85.3B", "Accueil des enfants en difficulté", Category.SUBCLASS),
        Classification("85.3C", "Accueil des adultes handicapés", Category.SUBCLASS),
        Classification("85.3D", "Accueil des personnes âgées", Category.SUBCLASS),
        Classification("85.3E", "Autres hébergements sociaux", Category.SUBCLASS),
        Classification("85.3G", "Crèches et garderies d'enfants", Category.SUBCLASS),
        Classification("85.3H", "Aide par le travail, ateliers protégés", Category.SUBCLASS),
        Classification("85.3J", "Aide à domicile", Category.SUBCLASS),
        Classification("85.3K", "Autres formes d'action sociale", Category.SUBCLASS),
        Classification("90.0A", "Collecte et traitement des eaux usées", Category.SUBCLASS),
        Classification("90.0B", "Enlèvement et traitement des ordures ménagères", Category.SUBCLASS),
        Classification("90.0E", "Traitements des autres déchets solides", Category.SUBCLASS),
        Classification("90.0G", "Autres travaux d'assainissement et de voirie", Category.SUBCLASS),
        Classification("91.1A", "Organisations patronales et consulaires", Category.SUBCLASS),
        Classification("91.1C", "Organisations professionnelles", Category.SUBCLASS),
        Classification("91.2Z", "Syndicats de salariés", Category.SUBCLASS),
        Classification("91.3A", "Organisations religieuses", Category.SUBCLASS),
        Classification("91.3C", "Organisations politiques", Category.SUBCLASS),
        Classification("91.3E", "Organisations associatives n.c.a.", Category.SUBCLASS),
        Classification("92.1A", "Production de films pour la télévision", Category.SUBCLASS),
        Classification("92.1B", "Production de films institutionnels et publicitaires", Category.SUBCLASS),
        Classification("92.1C", "Production de films pour le cinéma", Category.SUBCLASS),
        Classification("92.1D", "Prestations techniques pour le cinéma et la télévision", Category.SUBCLASS),
        Classification("92.1F", "Distribution de films cinématographiques", Category.SUBCLASS),
        Classification("92.1G", "Edition et distribution vidéo", Category.SUBCLASS),
        Classification("92.1J", "Projection de films cinématographiques", Category.SUBCLASS),
        Classification("92.2A", "Activités de radio", Category.SUBCLASS),
        Classification("92.2B", "Production de programmes de télévision", Category.SUBCLASS),
        Classification("92.2D", "Edition de chaînes généralistes", Category.SUBCLASS),
        Classification("92.2E", "Edition de chaînes thématiques", Category.SUBCLASS),
        Classification("92.2F", "Distribution de bouquets de programmes de radio et de télévision", Category.SUBCLASS),
        Classification("92.3A", "Activités artistiques", Category.SUBCLASS),
        Classification("92.3B", "Services annexes aux spectacles", Category.SUBCLASS),
        Classification("92.3D", "Gestion de salles de spectacles", Category.SUBCLASS),
        Classification("92.3F", "Manèges forains et parcs d'attractions", Category.SUBCLASS),
        Classification("92.3K", "Activités diverses du spectacle", Category.SUBCLASS),
        Classification("92.4Z", "Agences de presse", Category.SUBCLASS),
        Classification("92.5A", "Gestion des bibliothèques", Category.SUBCLASS),
        Classification("92.5C", "Gestion du patrimoine culturel", Category.SUBCLASS),
        Classification("92.5E", "Gestion du patrimoine naturel", Category.SUBCLASS),
        Classification("92.6A", "Gestion d'installations sportives", Category.SUBCLASS),
        Classification("92.6C", "Autres activités sportives", Category.SUBCLASS),
        Classification("92.7A", "Jeux de hasard et d'argent", Category.SUBCLASS),
        Classification("92.7C", "Autres activités récréatives", Category.SUBCLASS),
        Classification("93.0A", "Blanchisserie - teinturerie de gros", Category.SUBCLASS),
        Classification("93.0B", "Blanchisserie - teinturerie de détail", Category.SUBCLASS),
        Classification("93.0D", "Coiffure", Category.SUBCLASS),
        Classification("93.0E", "Soins de beauté", Category.SUBCLASS),
        Classification("93.0G", "Soins aux défunts", Category.SUBCLASS),
        Classification("93.0H", "Pompes funèbres", Category.SUBCLASS),
        Classification("93.0K", "Activités thermales et de thalassothérapie", Category.SUBCLASS),
        Classification("93.0L", "Autres soins corporels", Category.SUBCLASS),
        Classification("93.0N", "Autres services personnels", Category.SUBCLASS),
        Classification(
            "95.0Z", "Activités des ménages en tant qu'employeur de personnel domestique", Category.SUBCLASS
        ),
        Classification(
            "96.0Z",
            "Activités indifférenciées des ménages en tant que producteurs de biens pour usage propre",
            Category.SUBCLASS,
        ),
        Classification(
            "97.0Z",
            "Activités indifférenciées des ménages en tant que producteurs de services pour usage propre",
            Category.SUBCLASS,
        ),
        Classification("99.0Z", "Activités extra-territoriales", Category.SUBCLASS),
    ],
)
