import os
from codecs import open
from setuptools import setup, find_packages


here = os.path.abspath(os.path.dirname(__file__))


# Get the long description from the README file
with open(os.path.join(here, "README.md"), encoding="utf-8") as f:
    long_description = f.read()


setup(
    name="trustlines-contracts-deploy",
    setup_requires=["setuptools_scm"],
    use_scm_version={"root": ".."},
    description="deploy trustlines contracts",
    long_description_content_type="text/markdown",
    long_description=long_description,
    url="https://github.com/trustlines-protocol/contracts",
    author="Trustlines-Network",
    author_email="contact@brainbot.com",
    license="MIT",
    # See https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        # How mature is this project? Common values are
        #   3 - Alpha
        #   4 - Beta
        #   5 - Production/Stable
        "Development Status :: 2 - Pre-Alpha",
        # Indicate who your project is intended for
        "Intended Audience :: Developers",
        # Pick your license as you wish (should match "license" above)
        "License :: OSI Approved :: MIT License",
        # Specify the Python versions you support here. In particular, ensure
        # that you indicate whether you support Python 2, Python 3 or both.
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.5",
        "Programming Language :: Python :: 3.6",
    ],
    # What does your project relate to?
    keywords="trustlines",
    # You can just specify the packages manually here if your project is
    # simple. Or you can use find_packages().
    packages=find_packages(exclude=["contrib", "docs", "tests"]),
    package_data={"tldeploy": ["identity-proxy.json"]},
    install_requires=[
        "web3>=5.7.0,<6.0",
        "click>=7.0",
        "trustlines-contracts-bin>=1.1.5,<2.0.0",
        "contract-deploy-tools>=0.9.0",
        "attrs>=18.2",
        "pendulum>=2.0.0",
    ],
    python_requires=">=3.6",
    # To provide executable scripts, use entry points in preference to the
    # "scripts" keyword. Entry points provide cross-platform support and allow
    # pip to create the appropriate form of executable for the target platform.
    entry_points="""
    [console_scripts]
    tl-deploy=tldeploy.cli:cli
    """,
)
