# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['arcade_gui', 'arcade_gui.elements']

package_data = \
{'': ['*'],
 'arcade_gui': ['resources/basic_ui_pack/red/*', 'resources/style/*']}

install_requires = \
['arcade>=2.3.15,<3.0.0', 'pyyaml>=5.3.1,<6.0.0']

setup_kwargs = {
    'name': 'arcade-gui',
    'version': '0.1.0a6',
    'description': 'GUI extension for the Python game library Arcade  https://arcade.academy/',
    'long_description': "[![Build Status](https://travis-ci.org/eruvanos/arcade_gui.svg?branch=master)](https://travis-ci.org/eruvanos/arcade_gui)\n[![Documentation Status](https://readthedocs.org/projects/arcade-gui/badge/?version=latest)](https://arcade-gui.readthedocs.io/en/latest/?badge=latest)\n\n# GUI Library for Python Arcade\n\nThis project targets to offer simple to complex ui elements\nto use in games and software written with the Python Arcade library.\n\nSome UI components were copied over to adjust and fix them.\n\nThis project could also end up in a PR to integrate within Arcade.\n\n## The vision - WIP\n\nArcadeGui enables you to build this UI in 15 minutes:\n![Kenney 1 - UI Base Pack](docs\\_static\\UIBasePackPreview.png)\n\n\n## Basic Components\n\n#### UIView\nCentral class to manager the ui components.\nConverts `on_` callback functions into events, so that UIElements\njust have to contain one method to interact with user input.\n\n#### UIElement\nA general interface of an UI element.\n\n## Examples\n\nExamples providing an overview of features, there will be dedicated documentation soon.\n\n* [UILabel](https://github.com/eruvanos/arcade_gui/blob/master/examples/show_uilabel.py)\n* [UIButton](https://github.com/eruvanos/arcade_gui/blob/master/examples/show_uibutton.py)\n* [UIInputBox](https://github.com/eruvanos/arcade_gui/blob/master/examples/show_uiinputbox.py)\n* [Example with ID](https://github.com/eruvanos/arcade_gui/blob/master/examples/show_id_example.py)\n\n### Screenshots\n\n![Example with ID Screenshot](https://github.com/eruvanos/arcade_gui/blob/master/docs/_static/ProGramer.png)\n\n\n## Features for first release\n\n* [x] UILabel\n    * [x] Align with UITextBox\n* [x] UIButton\n* [x] Focused element tracked\n* [x] ID reference system for UIElements\n* [x] CI/CD\n* [x] UITextBox\n    * [x] Basic setup\n    * [x] Emit event on ENTER\n    * [ ] Scroll text with cursor\n    * [ ] Set max length\n* [x] UIElements emit own UIEvents\n    * [x] UIButton\n    * [x] UITextInput\n* [x] FlatButtons (https://codepen.io/maziarzamani/full/YXgvjv)\n* [x] UIImageButton\n* [ ] UITexturedInputBox (maybe include in UIInputBox)\n* [ ] Theme support\n    * [x] Load style from yaml\n    * [x] Parse arcade.color, hex and rgb\n    * [x] Introduce style classes\n    * [x] Style attributes can be set as global fallback under class `globals`\n    * [x] Use UIElement.id to lookup special style data\n    * [ ] Use UIStyle in UIElements\n      * [x] UI3DButton\n      * [x] FlatButton\n      * [x] GhostFlatButton\n      * [x] UILabel\n      * [x] UIInputBox\n      * [ ] UIImageButton (images)\n      * [ ] Read font attributes from style\n    * [ ] Provide different color styles\n    * [x] Overwrite properties on UIElement \n* [ ] Add documentation and doc strings (sphinx)\n    * [x] release notes\n    * [x] setup sphinx\n    * [ ] choose a sphinx theme\n    * [ ] setup readthedocs\n    * [ ] Document features\n      * [ ] Quickstart\n      * [ ] Interactions with ids \n      * [ ] Styles\n      * [ ] Style with id and classes\n      * [ ] Implement own components\n* [ ] track new features and issues in Github\n\n## Roadmap to arcade 2.4\n\n* [ ] render textures, and draw UIElements using a SpriteList\n\n## Features for later\n\n* [ ] Add hierarchy for ui_elements \n* [ ] style classes can have effect on child elements\n* [ ] live refresh of loaded image\n* [ ] New UIElements\n  * [ ] UITextArea\n  * [ ] UIContainer supporting automatic positioning (row & column) \n* [ ] Layouting in general\n\n\n### Chores\n\n* [ ] improve docs\n    * [x] fix reference to examples\n    * [x] include screenshots (at least one)\n* [x] support Python 3.7\n* [x] test examples render the expected screen\n* [x] separate button functionality from appearance \n* [x] move theme resolve logic into UIElement (now called `.parent_style()`) \n* [x] make 3D Button more realistic, or change to flat buttons\n* [x] harmonize constructors `x, y` vs `center_x, center_y`\n* [ ] fix hitbox of FlatButtons \n* [ ] add example for custom styles for all elements (perfect for test coverage)\n* [ ] figure out, how `UIView.find_by_id` does not produce typing warnings\n\n### Thoughts on themes (now called style)\n\n* UIView should hold a UIStyle that is used by all components, added to this view\n* UIElements have a _style attribute to overwrite style properties\n* Maybe supporting a hierarchy would be nice \n\n## Background information and other frameworks\n\n## Decisions\n\n* UIView is central component\n* One UIStyle object per UIView  \n  seems to be easier to implement a live refresh later\n* UIStyle information can be loaded from file or set programmatically\n* Themes vs Style  \n  talking to my younger brother gave me the impression, that 'style' or 'design' are more understandable then 'theme'\n* Events vs o 'on_'-callbacks  \n  Implementing new UIElements is way easier (less typing) if there is a central on_event method.  \n  Furthermore subclassing of UIElements to add custom actions like butten is pressed feels not as easy as it should be,\n  an alternative could have been a signal/slot mechanism like in QT\n\n\n### Reference Pygame GUI projects\n\n[Overview](https://www.pygame.org/wiki/gui)\n\n* ThorPy\n    * http://www.thorpy.org/index.html\n* Phil's pyGame Utilities\n    * https://www.pygame.org/project/108\n* OcempGUI\n    * https://www.pygame.org/project/125\n* PyGVisuals\n    * https://github.com/Impelon/PyGVisuals\n* Pygame GUI\n    * [Homepage](https://github.com/MyreMylar/pygame_gui)\n    * [Examples](https://github.com/MyreMylar/pygame_gui_examples)\n    * [QuickStart Example](https://github.com/MyreMylar/pygame_gui_examples/blob/master/quick_start.py)\n    * Concept\n        * UIManager manages every interaction, new elements get the UIManager on creation\n        * Elements create events and hook into pygames event system\n        * Themes can be read from JSON files\n* CSS Layout Engine: [Colosseum](https://colosseum.readthedocs.io/en/latest/index.html)\n* Tkinter Geometry Manager: [doc](https://effbot.org/tkinterbook/pack.htm)",
    'author': 'Maic Siemering',
    'author_email': 'maic@siemering.tech',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/eruvanos/arcade_gui',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7',
}


setup(**setup_kwargs)
