"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductStackSynthesizer = void 0;
const cdk = require("@aws-cdk/core");
/**
 * Deployment environment for an AWS Service Catalog product stack.
 *
 * Interoperates with the StackSynthesizer of the parent stack.
 */
class ProductStackSynthesizer extends cdk.StackSynthesizer {
    bind(stack) {
        if (this.stack !== undefined) {
            throw new Error('A Stack Synthesizer can only be bound once, create a new instance to use with a different Stack');
        }
        this.stack = stack;
    }
    addFileAsset(_asset) {
        throw new Error('Service Catalog Product Stacks cannot use Assets');
    }
    addDockerImageAsset(_asset) {
        throw new Error('Service Catalog Product Stacks cannot use Assets');
    }
    synthesize(session) {
        if (!this.stack) {
            throw new Error('You must call bindStack() first');
        }
        // Synthesize the template, but don't emit as a cloud assembly artifact.
        // It will be registered as an S3 asset of its parent instead.
        this.synthesizeStackTemplate(this.stack, session);
    }
}
exports.ProductStackSynthesizer = ProductStackSynthesizer;
//# sourceMappingURL=data:application/json;base64,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