"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SfnStateMachine = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const util_1 = require("./util");
/**
 * Use a StepFunctions state machine as a target for Amazon EventBridge rules.
 */
class SfnStateMachine {
    constructor(machine, props = {}) {
        var _b;
        this.machine = machine;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_events_targets_SfnStateMachineProps(props);
        if (props.role) {
            props.role.grant(new iam.ServicePrincipal('events.amazonaws.com'));
        }
        // no statements are passed because we are configuring permissions by using grant* helper below
        this.role = (_b = props.role) !== null && _b !== void 0 ? _b : util_1.singletonEventRole(machine, []);
        machine.grantStartExecution(this.role);
    }
    /**
     * Returns a properties that are used in an Rule to trigger this State Machine
     *
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sns-permissions
     */
    bind(_rule, _id) {
        if (this.props.deadLetterQueue) {
            util_1.addToDeadLetterQueueResourcePolicy(_rule, this.props.deadLetterQueue);
        }
        return {
            ...util_1.bindBaseTargetConfig(this.props),
            arn: this.machine.stateMachineArn,
            role: this.role,
            input: this.props.input,
            targetResource: this.machine,
        };
    }
}
exports.SfnStateMachine = SfnStateMachine;
_a = JSII_RTTI_SYMBOL_1;
SfnStateMachine[_a] = { fqn: "@aws-cdk/aws-events-targets.SfnStateMachine", version: "1.147.0" };
//# sourceMappingURL=data:application/json;base64,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