"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsTopic = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
/**
 * Use an SNS topic as a target for Amazon EventBridge rules.
 *
 * @example
 *   /// fixture=withRepoAndTopic
 *   // publish to an SNS topic every time code is committed
 *   // to a CodeCommit repository
 *   repository.onCommit('onCommit', { target: new targets.SnsTopic(topic) });
 *
 */
class SnsTopic {
    constructor(topic, props = {}) {
        this.topic = topic;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_events_targets_SnsTopicProps(props);
    }
    /**
     * Returns a RuleTarget that can be used to trigger this SNS topic as a
     * result from an EventBridge event.
     *
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sns-permissions
     */
    bind(_rule, _id) {
        // deduplicated automatically
        this.topic.grantPublish(new iam.ServicePrincipal('events.amazonaws.com'));
        return {
            arn: this.topic.topicArn,
            input: this.props.message,
            targetResource: this.topic,
        };
    }
}
exports.SnsTopic = SnsTopic;
_a = JSII_RTTI_SYMBOL_1;
SnsTopic[_a] = { fqn: "@aws-cdk/aws-events-targets.SnsTopic", version: "1.147.0" };
//# sourceMappingURL=data:application/json;base64,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