"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchLogGroup = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const core_1 = require("@aws-cdk/core");
const log_group_resource_policy_1 = require("./log-group-resource-policy");
const util_1 = require("./util");
/**
 * Use an AWS CloudWatch LogGroup as an event rule target.
 */
class CloudWatchLogGroup {
    constructor(logGroup, props = {}) {
        this.logGroup = logGroup;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_events_targets_LogGroupProps(props);
    }
    /**
     * Returns a RuleTarget that can be used to log an event into a CloudWatch LogGroup
     */
    bind(_rule, _id) {
        // Use a custom resource to set the log group resource policy since it is not supported by CDK and cfn.
        const resourcePolicyId = `EventsLogGroupPolicy${cdk.Names.nodeUniqueId(_rule.node)}`;
        const logGroupStack = cdk.Stack.of(this.logGroup);
        if (!this.logGroup.node.tryFindChild(resourcePolicyId)) {
            new log_group_resource_policy_1.LogGroupResourcePolicy(logGroupStack, resourcePolicyId, {
                policyStatements: [new iam.PolicyStatement({
                        effect: iam.Effect.ALLOW,
                        actions: ['logs:PutLogEvents', 'logs:CreateLogStream'],
                        resources: [this.logGroup.logGroupArn],
                        principals: [new iam.ServicePrincipal('events.amazonaws.com')],
                    })],
            });
        }
        return {
            ...util_1.bindBaseTargetConfig(this.props),
            arn: logGroupStack.formatArn({
                service: 'logs',
                resource: 'log-group',
                arnFormat: core_1.ArnFormat.COLON_RESOURCE_NAME,
                resourceName: this.logGroup.logGroupName,
            }),
            input: this.props.event,
            targetResource: this.logGroup,
        };
    }
}
exports.CloudWatchLogGroup = CloudWatchLogGroup;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchLogGroup[_a] = { fqn: "@aws-cdk/aws-events-targets.CloudWatchLogGroup", version: "1.147.0" };
//# sourceMappingURL=data:application/json;base64,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