"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisStream = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const util_1 = require("./util");
/**
 * Use a Kinesis Stream as a target for AWS CloudWatch event rules.
 *
 * @example
 *   /// fixture=withRepoAndKinesisStream
 *   // put to a Kinesis stream every time code is committed
 *   // to a CodeCommit repository
 *   repository.onCommit('onCommit', { target: new targets.KinesisStream(stream) });
 *
 */
class KinesisStream {
    constructor(stream, props = {}) {
        this.stream = stream;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_events_targets_KinesisStreamProps(props);
    }
    /**
     * Returns a RuleTarget that can be used to trigger this Kinesis Stream as a
     * result from a CloudWatch event.
     */
    bind(_rule, _id) {
        const policyStatements = [new iam.PolicyStatement({
                actions: ['kinesis:PutRecord', 'kinesis:PutRecords'],
                resources: [this.stream.streamArn],
            })];
        return {
            arn: this.stream.streamArn,
            role: util_1.singletonEventRole(this.stream, policyStatements),
            input: this.props.message,
            targetResource: this.stream,
            kinesisParameters: this.props.partitionKeyPath ? { partitionKeyPath: this.props.partitionKeyPath } : undefined,
        };
    }
}
exports.KinesisStream = KinesisStream;
_a = JSII_RTTI_SYMBOL_1;
KinesisStream[_a] = { fqn: "@aws-cdk/aws-events-targets.KinesisStream", version: "1.147.0" };
//# sourceMappingURL=data:application/json;base64,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