"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBus = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const util_1 = require("./util");
/**
 * Notify an existing Event Bus of an event
 */
class EventBus {
    constructor(eventBus, props = {}) {
        this.eventBus = eventBus;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_events_targets_EventBusProps(props);
    }
    bind(rule, _id) {
        var _b, _c;
        if (this.props.role) {
            this.props.role.addToPrincipalPolicy(this.putEventStatement());
        }
        const role = (_b = this.props.role) !== null && _b !== void 0 ? _b : util_1.singletonEventRole(rule, [this.putEventStatement()]);
        if (this.props.deadLetterQueue) {
            util_1.addToDeadLetterQueueResourcePolicy(rule, this.props.deadLetterQueue);
        }
        return {
            arn: this.eventBus.eventBusArn,
            deadLetterConfig: this.props.deadLetterQueue ? { arn: (_c = this.props.deadLetterQueue) === null || _c === void 0 ? void 0 : _c.queueArn } : undefined,
            role,
        };
    }
    putEventStatement() {
        return new iam.PolicyStatement({
            actions: ['events:PutEvents'],
            resources: [this.eventBus.eventBusArn],
        });
    }
}
exports.EventBus = EventBus;
_a = JSII_RTTI_SYMBOL_1;
EventBus[_a] = { fqn: "@aws-cdk/aws-events-targets.EventBus", version: "1.147.0" };
//# sourceMappingURL=data:application/json;base64,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