"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeBuildProject = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const util_1 = require("./util");
/**
 * Start a CodeBuild build when an Amazon EventBridge rule is triggered.
 */
class CodeBuildProject {
    constructor(project, props = {}) {
        this.project = project;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_events_targets_CodeBuildProjectProps(props);
    }
    /**
     * Allows using build projects as event rule targets.
     */
    bind(_rule, _id) {
        if (this.props.deadLetterQueue) {
            util_1.addToDeadLetterQueueResourcePolicy(_rule, this.props.deadLetterQueue);
        }
        return {
            ...util_1.bindBaseTargetConfig(this.props),
            arn: this.project.projectArn,
            role: this.props.eventRole || util_1.singletonEventRole(this.project, [
                new iam.PolicyStatement({
                    actions: ['codebuild:StartBuild'],
                    resources: [this.project.projectArn],
                }),
            ]),
            input: this.props.event,
            targetResource: this.project,
        };
    }
}
exports.CodeBuildProject = CodeBuildProject;
_a = JSII_RTTI_SYMBOL_1;
CodeBuildProject[_a] = { fqn: "@aws-cdk/aws-events-targets.CodeBuildProject", version: "1.147.0" };
//# sourceMappingURL=data:application/json;base64,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