"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsApi = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const events = require("@aws-cdk/aws-events");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const sdk_api_metadata_generated_1 = require("./sdk-api-metadata.generated");
const util_1 = require("./util");
const awsSdkMetadata = sdk_api_metadata_generated_1.metadata;
/**
 * Use an AWS Lambda function that makes API calls as an event rule target.
 */
class AwsApi {
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_events_targets_AwsApiProps(props);
    }
    /**
     * Returns a RuleTarget that can be used to trigger this AwsApi as a
     * result from an EventBridge event.
     */
    bind(rule, id) {
        const handler = new lambda.SingletonFunction(rule, `${rule.node.id}${id}Handler`, {
            code: lambda.Code.fromAsset(path.join(__dirname, 'aws-api-handler')),
            runtime: lambda.Runtime.NODEJS_12_X,
            handler: 'index.handler',
            uuid: 'b4cf1abd-4e4f-4bc6-9944-1af7ccd9ec37',
            lambdaPurpose: 'AWS',
        });
        checkServiceExists(this.props.service, handler);
        if (this.props.policyStatement) {
            handler.addToRolePolicy(this.props.policyStatement);
        }
        else {
            handler.addToRolePolicy(new iam.PolicyStatement({
                actions: [awsSdkToIamAction(this.props.service, this.props.action)],
                resources: ['*'],
            }));
        }
        // Allow handler to be called from rule
        util_1.addLambdaPermission(rule, handler);
        const input = {
            service: this.props.service,
            action: this.props.action,
            parameters: this.props.parameters,
            catchErrorPattern: this.props.catchErrorPattern,
            apiVersion: this.props.apiVersion,
        };
        return {
            arn: handler.functionArn,
            input: events.RuleTargetInput.fromObject(input),
            targetResource: handler,
        };
    }
}
exports.AwsApi = AwsApi;
_a = JSII_RTTI_SYMBOL_1;
AwsApi[_a] = { fqn: "@aws-cdk/aws-events-targets.AwsApi", version: "1.147.0" };
/**
 * Check if the given service exists in the AWS SDK. If not, a warning will be raised.
 * @param service Service name
 */
function checkServiceExists(service, handler) {
    const sdkService = awsSdkMetadata[service.toLowerCase()];
    if (!sdkService) {
        core_1.Annotations.of(handler).addWarning(`Service ${service} does not exist in the AWS SDK. Check the list of available \
services and actions from https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html`);
    }
}
/**
 * Transform SDK service/action to IAM action using metadata from aws-sdk module.
 */
function awsSdkToIamAction(service, action) {
    const srv = service.toLowerCase();
    const iamService = awsSdkMetadata[srv].prefix || srv;
    const iamAction = action.charAt(0).toUpperCase() + action.slice(1);
    return `${iamService}:${iamAction}`;
}
//# sourceMappingURL=data:application/json;base64,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