"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGateway = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const util_1 = require("./util");
/**
 * Use an API Gateway REST APIs as a target for Amazon EventBridge rules.
 */
class ApiGateway {
    constructor(restApi, props) {
        this.restApi = restApi;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_events_targets_ApiGatewayProps(props);
    }
    /**
     * Returns a RuleTarget that can be used to trigger this API Gateway REST APIs
     * as a result from an EventBridge event.
     *
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sqs-permissions
     */
    bind(rule, _id) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s;
        if ((_b = this.props) === null || _b === void 0 ? void 0 : _b.deadLetterQueue) {
            util_1.addToDeadLetterQueueResourcePolicy(rule, this.props.deadLetterQueue);
        }
        const wildcardCountsInPath = (_f = (_e = (_d = (_c = this.props) === null || _c === void 0 ? void 0 : _c.path) === null || _d === void 0 ? void 0 : _d.match(/\*/g)) === null || _e === void 0 ? void 0 : _e.length) !== null && _f !== void 0 ? _f : 0;
        if (wildcardCountsInPath !== (((_g = this.props) === null || _g === void 0 ? void 0 : _g.pathParameterValues) || []).length) {
            throw new Error('The number of wildcards in the path does not match the number of path pathParameterValues.');
        }
        const restApiArn = this.restApi.arnForExecuteApi((_h = this.props) === null || _h === void 0 ? void 0 : _h.method, ((_j = this.props) === null || _j === void 0 ? void 0 : _j.path) || '/', ((_k = this.props) === null || _k === void 0 ? void 0 : _k.stage) || this.restApi.deploymentStage.stageName);
        return {
            ...(this.props ? util_1.bindBaseTargetConfig(this.props) : {}),
            arn: restApiArn,
            role: ((_l = this.props) === null || _l === void 0 ? void 0 : _l.eventRole) || util_1.singletonEventRole(this.restApi, [new iam.PolicyStatement({
                    resources: [restApiArn],
                    actions: [
                        'execute-api:Invoke',
                        'execute-api:ManageConnections',
                    ],
                })]),
            deadLetterConfig: ((_m = this.props) === null || _m === void 0 ? void 0 : _m.deadLetterQueue) && { arn: (_o = this.props.deadLetterQueue) === null || _o === void 0 ? void 0 : _o.queueArn },
            input: (_p = this.props) === null || _p === void 0 ? void 0 : _p.postBody,
            targetResource: this.restApi,
            httpParameters: {
                headerParameters: (_q = this.props) === null || _q === void 0 ? void 0 : _q.headerParameters,
                queryStringParameters: (_r = this.props) === null || _r === void 0 ? void 0 : _r.queryStringParameters,
                pathParameterValues: (_s = this.props) === null || _s === void 0 ? void 0 : _s.pathParameterValues,
            },
        };
    }
}
exports.ApiGateway = ApiGateway;
_a = JSII_RTTI_SYMBOL_1;
ApiGateway[_a] = { fqn: "@aws-cdk/aws-events-targets.ApiGateway", version: "1.147.0" };
//# sourceMappingURL=data:application/json;base64,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