"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiDestination = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const util_1 = require("./util");
/**
 * Use an API Destination rule target.
 */
class ApiDestination {
    constructor(apiDestination, props = {}) {
        this.apiDestination = apiDestination;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_events_targets_ApiDestinationProps(props);
    }
    /**
     * Returns a RuleTarget that can be used to trigger API destinations
     * from an EventBridge event.
     */
    bind(_rule, _id) {
        var _b, _c, _d, _e, _f;
        const httpParameters = ((_c = (_b = !!this.props.headerParameters) !== null && _b !== void 0 ? _b : !!this.props.pathParameterValues) !== null && _c !== void 0 ? _c : !!this.props.queryStringParameters) ? {
            headerParameters: this.props.headerParameters,
            pathParameterValues: this.props.pathParameterValues,
            queryStringParameters: this.props.queryStringParameters,
        } : undefined;
        if ((_d = this.props) === null || _d === void 0 ? void 0 : _d.deadLetterQueue) {
            util_1.addToDeadLetterQueueResourcePolicy(_rule, this.props.deadLetterQueue);
        }
        return {
            ...(this.props ? util_1.bindBaseTargetConfig(this.props) : {}),
            arn: this.apiDestination.apiDestinationArn,
            role: (_f = (_e = this.props) === null || _e === void 0 ? void 0 : _e.eventRole) !== null && _f !== void 0 ? _f : util_1.singletonEventRole(this.apiDestination, [new iam.PolicyStatement({
                    resources: [this.apiDestination.apiDestinationArn],
                    actions: ['events:InvokeApiDestination'],
                })]),
            input: this.props.event,
            targetResource: this.apiDestination,
            httpParameters,
        };
    }
}
exports.ApiDestination = ApiDestination;
_a = JSII_RTTI_SYMBOL_1;
ApiDestination[_a] = { fqn: "@aws-cdk/aws-events-targets.ApiDestination", version: "1.147.0" };
//# sourceMappingURL=data:application/json;base64,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