/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.lightgbm.testing;

import com.google.common.base.Equivalence;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.dmg.pmml.PMML;
import org.jpmml.converter.testing.ModelEncoderBatch;
import org.jpmml.converter.testing.OptionsUtil;
import org.jpmml.evaluator.ResultField;
import org.jpmml.lightgbm.GBDT;
import org.jpmml.lightgbm.LightGBMUtil;
import org.jpmml.lightgbm.ObjectiveFunction;
import org.jpmml.lightgbm.testing.FieldImportanceInspector;
import org.jpmml.lightgbm.testing.LightGBMEncoderBatchTest;
import org.jpmml.model.visitors.VisitorBattery;

public abstract class LightGBMEncoderBatch
extends ModelEncoderBatch {
    public LightGBMEncoderBatch(String algorithm, String dataset, Predicate<ResultField> columnFilter, Equivalence<Object> equivalence) {
        super(algorithm, dataset, columnFilter, equivalence);
    }

    public abstract LightGBMEncoderBatchTest getArchiveBatchTest();

    public List<Map<String, Object>> getOptionsMatrix() {
        String dataset = this.getDataset();
        Integer numIteration = null;
        int index = dataset.indexOf(64);
        if (index > -1) {
            numIteration = new Integer(dataset.substring(index + 1));
        }
        LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
        options.put("compact", new Boolean[]{false, true});
        options.put("nan_as_missing", true);
        options.put("num_iteration", numIteration);
        return OptionsUtil.generateOptionsMatrix(options);
    }

    public ObjectiveFunction getObjectiveFunction() {
        return null;
    }

    public String getModelTxtPath() {
        return "/lgbm/" + this.getAlgorithm() + LightGBMEncoderBatch.truncate((String)this.getDataset()) + ".txt";
    }

    public PMML getPMML() throws Exception {
        GBDT gbdt;
        try (InputStream is = this.open(this.getModelTxtPath());){
            gbdt = LightGBMUtil.loadGBDT(is);
        }
        ObjectiveFunction objectiveFunction = this.getObjectiveFunction();
        if (objectiveFunction != null) {
            gbdt.setObjectiveFunction(objectiveFunction);
        }
        Map options = this.getOptions();
        PMML pmml = gbdt.encodePMML(options, null, null);
        this.validatePMML(pmml);
        return pmml;
    }

    public String getInputCsvPath() {
        return "/csv/" + LightGBMEncoderBatch.truncate((String)this.getDataset()) + ".csv";
    }

    public String getOutputCsvPath() {
        return super.getOutputCsvPath();
    }

    public VisitorBattery getValidators() {
        VisitorBattery visitorBattery = super.getValidators();
        visitorBattery.add(FieldImportanceInspector.class);
        return visitorBattery;
    }
}

