/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.ensemble;

import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.python.DataFrameScope;
import org.jpmml.python.PredicateTranslator;
import org.jpmml.python.Scope;
import org.jpmml.python.TupleUtil;
import sklearn.Estimator;

public class SelectFirstUtil {
    private SelectFirstUtil() {
    }

    public static MiningModel encodeRegressor(List<Object[]> steps, Schema schema) {
        return SelectFirstUtil.encodeModel(MiningFunction.REGRESSION, steps, schema);
    }

    public static MiningModel encodeClassifier(List<Object[]> steps, Schema schema) {
        return SelectFirstUtil.encodeModel(MiningFunction.CLASSIFICATION, steps, schema);
    }

    private static MiningModel encodeModel(MiningFunction miningFunction, List<Object[]> steps, Schema schema) {
        if (steps.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Label label = schema.getLabel();
        List features = schema.getFeatures();
        Segmentation segmentation = new Segmentation(Segmentation.MultipleModelMethod.SELECT_FIRST, null);
        DataFrameScope scope = new DataFrameScope("X", features);
        for (Object[] step : steps) {
            String name = (String)TupleUtil.extractElement((Object[])step, (int)0, String.class);
            Estimator estimator = (Estimator)TupleUtil.extractElement((Object[])step, (int)1, Estimator.class);
            String predicate = (String)TupleUtil.extractElement((Object[])step, (int)2, String.class);
            if (estimator.getMiningFunction() != miningFunction) {
                throw new IllegalArgumentException();
            }
            Predicate pmmlPredicate = PredicateTranslator.translate((String)predicate, (Scope)scope);
            Model model = estimator.encode(schema);
            Segment segment = new Segment(pmmlPredicate, model).setId(name);
            segmentation.addSegments(new Segment[]{segment});
        }
        MiningModel miningModel = new MiningModel(miningFunction, ModelUtil.createMiningSchema((Label)label)).setSegmentation(segmentation);
        return miningModel;
    }
}

